(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     81337,       2201]
NotebookOptionsPosition[     73121,       2063]
NotebookOutlinePosition[     73632,       2081]
CellTagsIndexPosition[     73589,       2078]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"60a4a78e-000b-4703-b419-1e934bcb9f30"],

Cell[BoxData["\<\"D:\\\\VYUKA\\\\iap2023\"\>"], "Output",
 CellChangeTimes->{3.90608541022882*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"c6cfffa9-d0cb-46e3-9340-facfa9f2db94"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9060845212002563`*^9, 3.9060845212002563`*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"be906b25-f752-4b17-a529-2551c3f02e03"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"info", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataReal", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{"Transpose", "[", "data1", "]"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906084156409767*^9, 3.906084161955413*^9}, {
   3.906084344810624*^9, 3.906084348881589*^9}, {3.9060845348008585`*^9, 
   3.906084570519206*^9}, 3.90608462097089*^9, {3.906084679119188*^9, 
   3.906084761976327*^9}, {3.906084798679098*^9, 3.906084803409314*^9}, 
   3.9060848396510096`*^9, {3.906084893812612*^9, 3.906084939864373*^9}, {
   3.906084977913763*^9, 3.9060850313520412`*^9}, {3.9060850621930556`*^9, 
   3.906085126265901*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"8a256d78-bb04-49ee-a95e-093a8c497241"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906085004961555*^9, 3.9060850135550203`*^9}, {
   3.9060850652661605`*^9, 3.906085126801789*^9}, 3.9060854102762623`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"eba9d314-9454-45a1-937d-aa9ab2cd9357"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "b", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rovnice", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"A", ".", "nezname"}], "==", "b"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "rovnice", "]"}]}], "Input",
 CellChangeTimes->{{3.9060851404271755`*^9, 3.906085221740617*^9}, {
  3.9060853421076193`*^9, 3.9060853512980056`*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"ab2ae774-a8d7-4b4c-9d58-f825f9de5909"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", "3.09193370835402`"}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     RowBox[{"-", "1.37183183356454`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", "0.27537728971604836`"}], ",", 
    RowBox[{
     SubscriptBox["x", "4"], "\[Rule]", "2.7605480410534207`"}], ",", 
    RowBox[{
     SubscriptBox["x", "5"], "\[Rule]", 
     RowBox[{"-", "0.3056072433248169`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "6"], "\[Rule]", "3.051173169637574`"}], ",", 
    RowBox[{
     SubscriptBox["x", "7"], "\[Rule]", "2.5473126863519013`"}], ",", 
    RowBox[{
     SubscriptBox["x", "8"], "\[Rule]", "6.20371892158359`"}], ",", 
    RowBox[{
     SubscriptBox["x", "9"], "\[Rule]", 
     RowBox[{"-", "1.5918417224634418`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "10"], "\[Rule]", 
     RowBox[{"-", "3.981102568677317`"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9060851736724653`*^9, 3.906085222353649*^9}, {
   3.9060853424375076`*^9, 3.9060853522283707`*^9}, 3.9060854102918854`*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"f111f257-0857-499b-a65e-42fbb674ce46"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maticeA", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{";;", 
       RowBox[{"-", "2"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearSolve", "[", 
   RowBox[{"maticeA", ",", "b"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906084156409767*^9, 3.906084161955413*^9}, {
   3.906084344810624*^9, 3.906084348881589*^9}, {3.9060845348008585`*^9, 
   3.906084570519206*^9}, 3.90608462097089*^9, {3.906084679119188*^9, 
   3.906084761976327*^9}, {3.906084798679098*^9, 3.906084803409314*^9}, 
   3.9060848396510096`*^9, {3.906084893812612*^9, 3.906084939864373*^9}, {
   3.906084977913763*^9, 3.9060850313520412`*^9}, {3.9060850621930556`*^9, 
   3.906085126265901*^9}, {3.9060854939756455`*^9, 3.9060855012529893`*^9}, {
   3.9060855671485558`*^9, 3.9060855775616846`*^9}, {3.906085612423377*^9, 
   3.9060856706505427`*^9}, 3.9060857137370577`*^9, {3.9060857565028296`*^9, 
   3.906085780688182*^9}, {3.906085865934195*^9, 3.9060859250303917`*^9}, {
   3.9060859587030153`*^9, 3.906086068467969*^9}},
 CellLabel->
  "In[225]:=",ExpressionUUID->"833d7e0a-b33b-4339-b1cc-42b0b31fa2f6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataReal", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", 
       RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906086088435356*^9, 3.906086218024295*^9}},
 CellLabel->
  "In[280]:=",ExpressionUUID->"f2342688-ae13-48cb-baf7-60369d065b29"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060861950906253`*^9, 3.9060862186221533`*^9}},
 CellLabel->
  "Out[286]=",ExpressionUUID->"66801b6c-f555-469b-ac02-d1bbe94c4a10"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataComplex", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataComplex", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "data1"}], ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"re_Real", ",", "im_"}], "}"}], ":>", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", "data2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{"Transpose", "[", "data1", "]"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", ">>", "\"\<res1\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.906086298985217*^9, 3.906086355752006*^9}, {
   3.906086399312234*^9, 3.906086465651675*^9}, 3.9060865294037495`*^9, 
   3.906086584395951*^9, {3.906086661731371*^9, 3.90608672017743*^9}, {
   3.9060868287916355`*^9, 3.9060868358896203`*^9}, {3.9060869509929934`*^9, 
   3.9060869818576584`*^9}, {3.9060880043192425`*^9, 
   3.9060880063580647`*^9}, {3.9060880768856115`*^9, 3.9060880848556986`*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"400362b7-1a26-4406-ac3b-bf4965c40225"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Range", "[", "20", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"%", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906086532647899*^9, 3.9060865482007613`*^9}},
 CellLabel->
  "In[313]:=",ExpressionUUID->"d0e900d5-91ce-4dc7-b337-066b6f1d15ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",
 CellChangeTimes->{{3.906086537790236*^9, 3.906086548656083*^9}},
 CellLabel->
  "Out[313]=",ExpressionUUID->"1ac154be-8618-49ad-b048-aa36f529a45f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906086537790236*^9, 3.906086548656083*^9}},
 CellLabel->
  "Out[314]=",ExpressionUUID->"59f84142-19c3-4c45-9329-39fcde8e7293"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.906087057622938*^9, {3.9060871166146913`*^9, 3.906087142389784*^9}, 
   3.9060872056788683`*^9},
 CellLabel->
  "In[455]:=",ExpressionUUID->"ebdaeb30-1640-4569-9d0c-624de813d8d2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maticeAre", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "4"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maticeAim", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"2", ";;", 
       RowBox[{"-", "3"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maticeA", "=", 
    RowBox[{"maticeAre", "+", 
     RowBox[{"I", "*", "maticeAim"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bre", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"-", "2"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bim", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Bre", "+", 
    RowBox[{"I", "*", "Bim"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni2", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"maticeA", ",", "B"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", "=", 
   RowBox[{"<<", "\"\<res1\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"reseni1", "==", "reseni2"}], "\[IndentingNewLine]", 
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"reseni1", "-", "reseni2"}], "//", "Chop"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.906087057622938*^9, {3.9060871166146913`*^9, 3.906087142389784*^9}, 
   3.9060872111148643`*^9, 3.9060872443798456`*^9, {3.906087290687933*^9, 
   3.9060874884470215`*^9}, {3.9060875351535535`*^9, 
   3.9060875439523907`*^9}, {3.90608780942445*^9, 3.906087817889943*^9}, {
   3.9060878621536913`*^9, 3.906087977714353*^9}, {3.906088022614476*^9, 
   3.9060880241372404`*^9}, {3.906088138504223*^9, 3.9060881684887667`*^9}, {
   3.9060882088693047`*^9, 3.9060882129936323`*^9}, {3.906088246601988*^9, 
   3.906088260729715*^9}},
 CellLabel->
  "In[503]:=",ExpressionUUID->"4baf7827-d9fb-4d72-a217-0545b500b66c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9060881692585397`*^9, 3.9060882142983165`*^9, {3.906088248444545*^9, 
   3.9060882614059467`*^9}},
 CellLabel->
  "Out[511]=",ExpressionUUID->"3480de9b-0eab-4b59-bbfe-305b0fb557cb"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.9060881692585397`*^9, 3.9060882142983165`*^9, {3.906088248444545*^9, 
   3.9060882614059467`*^9}},
 CellLabel->
  "Out[512]=",ExpressionUUID->"527ec9b1-50a9-419e-8398-563550fa034d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
     FractionBox[
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"t", "+", "1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "5"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9060883040142403`*^9, 3.9060884517851257`*^9}, 
   3.9060887028810587`*^9, {3.9060887454520297`*^9, 3.9060887510406876`*^9}},
 CellLabel->
  "In[562]:=",ExpressionUUID->"38aee430-6229-44e0-a869-8be597f99731"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
     FractionBox[
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"t", "+", "1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "5"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.90608872676969*^9, 3.906088756645773*^9}},
 CellLabel->
  "In[568]:=",ExpressionUUID->"c290d6d0-0a6d-447c-9ce1-11fb9f6c1603"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pom", "=", 
  RowBox[{
   RowBox[{"MatrixPower", "[", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {"1", "2"},
        {"7", "13"}
       }], ")"}], ",", 
     FractionBox["1", "5"]}], "]"}], "//", "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", ".", "pom", ".", "pom", ".", "pom", ".", "pom"}], "//", 
  "Chop"}]}], "Input",
 CellChangeTimes->{{3.9060888236153526`*^9, 3.9060888559086256`*^9}, {
  3.9060891308359656`*^9, 3.906089151291851*^9}},
 CellLabel->"",ExpressionUUID->"f6edb8ca-405e-4ac4-8293-dc40d6c0ef16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.5691634617262573`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.32014693179423653`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.17256009246590126`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04898558195889979`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.6039603236306542`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.17144953685614922`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.6045240165216648`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.026233440040837854`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.906088853298781*^9, 3.906088856573948*^9}, {
  3.9060891325171175`*^9, 3.9060891478396435`*^9}},
 CellLabel->
  "Out[587]=",ExpressionUUID->"fa7f5ade-2558-4fd2-b49f-4f26785d8cd9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.9999999999999997`", "\[VeryThinSpace]", "-", 
      RowBox[{"5.551115123125783`*^-17", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"2.`", "\[VeryThinSpace]", "-", 
      RowBox[{"6.591949208711867`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"6.999999999999998`", "\[VeryThinSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"13.`", "\[VeryThinSpace]", "+", 
      RowBox[{"2.498001805406602`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.906088853298781*^9, 3.906088856573948*^9}, {
  3.9060891325171175`*^9, 3.9060891478396435`*^9}},
 CellLabel->
  "Out[588]=",ExpressionUUID->"fcc85842-02cd-4d07-a793-e4d38047cb39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "//", "TreeForm"}]], "Input",
 CellChangeTimes->{{3.906089028209114*^9, 3.906089049788868*^9}},
 CellLabel->
  "In[579]:=",ExpressionUUID->"38a4472f-8ae5-4c0b-a951-0c32fce450cc"],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[
   TagBox[
    GraphicsComplexBox[{{0.4472135954999579, 0.8944271909999159}, {0., 0.}, {
     0.8944271909999159, 0.}}, {
      {RGBColor[0.55, 0.45, 0.45], LineBox[{{1, 2}, {1, 3}}]}, {
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          SuperscriptBox["x", "3"], HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x^3], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["3",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox["3", HoldForm]],
        Annotation[#, 
         HoldForm[3], "Tooltip"]& ]}}],
    Annotation[#, 
     VertexCoordinateRules -> {{0.4472135954999579, 0.8944271909999159}, {0., 
      0.}, {0.8944271909999159, 0.}}]& ],
   AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
   FormatType:>StandardForm,
   FrameTicks->Automatic,
   ImageSize->{198.21428571428595`, Automatic},
   PlotRange->All,
   PlotRangePadding->Scaled[0.1]],
  TreeForm[$CellContext`x^3],
  Editable->False]], "Output",
 CellChangeTimes->{3.9060890501516047`*^9},
 CellLabel->
  "Out[579]//TreeForm=",ExpressionUUID->"57c9bba8-d5c4-4075-b421-\
9f8469f1026d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Attributes", "[", "Sin", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060890851657104`*^9, 3.9060890955228157`*^9}},
 CellLabel->
  "In[581]:=",ExpressionUUID->"dedec0b3-4dd4-4289-a383-9553f58b7b3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9060890886811495`*^9, 3.9060890957263966`*^9}},
 CellLabel->
  "Out[581]=",ExpressionUUID->"afcda4d7-4695-4cd0-b669-151523f3b973"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "1", "]"}], ",", 
   RowBox[{"Sin", "[", "2", "]"}], ",", 
   RowBox[{"Sin", "[", "3", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060890886811495`*^9, 3.9060890957263966`*^9}},
 CellLabel->
  "Out[582]=",ExpressionUUID->"b09f0dab-de9e-4154-acac-eeb5edeaa3f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Power", "]"}]], "Input",
 CellChangeTimes->{{3.906089011324544*^9, 3.906089016682666*^9}},
 CellLabel->
  "In[578]:=",ExpressionUUID->"b80975ef-ef9c-42cd-aec2-806b8efcdf9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", "Protected", 
   ",", "ReadProtected"}], "}"}]], "Output",
 CellChangeTimes->{3.9060890171856813`*^9},
 CellLabel->
  "Out[578]=",ExpressionUUID->"cf5cb471-65f8-40f8-b13e-fb756e941b70"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}]], "Input",Express\
ionUUID->"e4dde944-1321-4e6f-8351-2e30e563fcbd"],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", GridBox[{
     {"1", "2"},
     {"7", "13"}
    }], ")"}], 
  FractionBox["1", "5"]]], "Input",
 CellChangeTimes->{{3.9060891163408046`*^9, 3.9060891180512185`*^9}},
 CellLabel->
  "In[583]:=",ExpressionUUID->"0d1da216-6ba4-47b7-b645-d0ef8126eb84"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["7", 
      RowBox[{"1", "/", "5"}]], ",", 
     SuperscriptBox["13", 
      RowBox[{"1", "/", "5"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.906089118843398*^9},
 CellLabel->
  "Out[583]=",ExpressionUUID->"20a0ba67-1cb3-4d9f-a787-d15311703277"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "==", "b"}], "//", "FullForm"}]], "Input",
 CellChangeTimes->{{3.9066888896654835`*^9, 3.9066888963365364`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"981f1133-eb50-46a5-a728-3dd766e91a06"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Equal", "[", 
    RowBox[{"a", ",", "b"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{3.9066888969226513`*^9},
 CellLabel->
  "Out[8]//FullForm=",ExpressionUUID->"63edf0c9-8737-4817-973b-8b917f68c90d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constr", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "==", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{"constr", "/.", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], ":>", 
     RowBox[{"lhs", "-", "rhs"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{"constr", "/.", 
    RowBox[{
     RowBox[{"lhs_", "==", "rhs_"}], ":>", 
     RowBox[{"lhs", "-", "rhs"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"expr", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rovnice", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0", "==", 
     RowBox[{"D", "[", 
      RowBox[{"lagrange", ",", "#"}], "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], 
    "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", "rovnice", "]"}], "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.906688666028878*^9, 3.906688745602178*^9}, {
  3.906688836939495*^9, 3.906688869108017*^9}, {3.9066889241037235`*^9, 
  3.9066889466616592`*^9}, {3.9066889782678175`*^9, 3.9066890350087433`*^9}, {
  3.906689067845648*^9, 3.906689106308592*^9}, {3.9066892526416397`*^9, 
  3.90668928067634*^9}, {3.9066893140315495`*^9, 3.906689350713806*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"c82b66fe-d38a-47b9-b4fd-bcc9c5cbac81"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 3.906689351311284*^9}},
 CellLabel->"Out[68]=",ExpressionUUID->"2bd45318-2e0c-45a8-8fa5-48c24cf6c649"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472135954999579`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944271909999159`"}]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "1.118033988749895`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.4472135954999579`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944271909999159`"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", "1.118033988749895`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 3.906689351311284*^9}},
 CellLabel->"Out[69]=",ExpressionUUID->"66dd8154-f36a-44ee-abd9-3fcce159cbca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.23606797749979`"}], ",", "2.23606797749979`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 3.906689351311284*^9}},
 CellLabel->"Out[70]=",ExpressionUUID->"eeec8b34-852d-4e45-a8b5-a8b02d304b4c"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.906688829212121*^9, 
  3.906688834509803*^9}},ExpressionUUID->"b8285001-ecf4-420f-b6d7-\
c67099f83650"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constr", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "==", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"expr", ",", "constr"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"expr", ",", "constr"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9066894074684296`*^9, 3.906689434149102*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"f396f575-008b-4683-aa3f-6454f00e1e6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.236067985266875`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472134065123647`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944272893772551`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9066894571983905`*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"ec4fd5bf-3567-45a2-a402-864b75379018"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2360679786324718`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.44721622493105484`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944258768507084`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.906689457230426*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"7ff8ede8-ef74-416d-81b5-7f85cae0b376"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}, 3.906689667589672*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"0f02548d-6b74-498a-ba06-9a74acfe2ad0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<teploty.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"teploty", "/.", 
    RowBox[{
     RowBox[{"{", "T_", "}"}], ":>", "T"}]}], ";"}], 
  RowBox[{"(*", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Flatten", "[", "teploty", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "1"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"First", "/@", "teploty"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Last", "/@", "teploty"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "teploty"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "teploty", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ">>", "\"\<teploty\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906689682623513*^9, 3.9066898067879105`*^9}, {
  3.906689871323526*^9, 3.906689878839707*^9}, {3.9066904003846645`*^9, 
  3.906690438002571*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"6fade0c1-17c6-4a59-baf2-4cf4dbb6ff53"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{"<<", "teploty"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"teploty", ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Joined", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "15"}], "<", "T", "<=", 
        RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], "<", "T", "<=", 
          RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], "<", "T", "<=", 
            RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9066897098562737`*^9, 3.906689727559839*^9}, {
  3.906690443646738*^9, 3.906690455695727*^9}, {3.9066905201409826`*^9, 
  3.9066905363764*^9}, {3.9066905762831707`*^9, 3.906690619730276*^9}, {
  3.906690680843998*^9, 3.9066907499201155`*^9}, {3.906690798828497*^9, 
  3.9066908242204514`*^9}, {3.9066908596180334`*^9, 3.906691042194658*^9}, {
  3.9066911499871864`*^9, 3.9066911642821527`*^9}, {3.9066913664848757`*^9, 
  3.906691378813081*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"d2027d55-7db4-48f0-8ce1-31080b9e72ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "P"}]], "Input",
 CellChangeTimes->{{3.9066913091603713`*^9, 3.9066913133617873`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"a971ab71-f16f-4861-9bfe-025f3718922d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`P\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"P", "[", "T_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "\[Infinity]"}], "<", "T"}], "&&", 
                    RowBox[{"T", "\[LessEqual]", 
                    RowBox[{"-", "15"}]}]}], ",", "20", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "15"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "12"}]}], ",", "15", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "12"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "8"}]}], ",", "12", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "8"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "2"}]}], ",", "9", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "<", "T", "\[LessEqual]", "5"}], ",", 
                    "5", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"5", "<", "T", "\[LessEqual]", "13"}], ",", "3", 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"T", ">", "13"}], ",", "0"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`P\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{24., {8., 16.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{24., {8., 16.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`P\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`P", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`P, {$CellContext`P[
         Pattern[$CellContext`T, 
          Blank[]]] :> If[
         And[-Infinity < $CellContext`T, $CellContext`T <= -15], 20, 
         If[
          Inequality[-15, Less, $CellContext`T, LessEqual, -12], 15, 
          If[
           Inequality[-12, Less, $CellContext`T, LessEqual, -8], 12, 
           If[
            Inequality[-8, Less, $CellContext`T, LessEqual, -2], 9, 
            If[
             Inequality[-2, Less, $CellContext`T, LessEqual, 5], 5, 
             If[
              Inequality[5, Less, $CellContext`T, LessEqual, 13], 3, 
              If[$CellContext`T > 13, 0]]]]]]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> "Global`P"|>, 
   False]]], "Output",
 CellChangeTimes->{3.906691314555398*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"3d4674a7-6d3c-4fe3-a057-527f93b676a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "P1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P1", "[", "T_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "15"}], "<", "T", "<=", 
      RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "12"}], "<", "T", "<=", 
      RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "8"}], "<", "T", "<=", 
      RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"P1", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.906691171758151*^9, 3.906691176907378*^9}, {
   3.906691228194005*^9, 3.906691285569903*^9}, {3.906691324106803*^9, 
   3.9066913254430585`*^9}, 3.906691390602851*^9, {3.906691664616319*^9, 
   3.906691713630332*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"bcf1800b-5e94-4c1f-85cb-d618080fb1c5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[{{-19.99999918367347, 20.}, {-19.607426367806127`, 
       20.}, {-19.214853551938784`, 20.}, {-18.363665716581654`, 
       20.}, {-17.568884657193916`, 20.}, {-16.789694047244957`, 
       20.}, {-15.944461233673556`, 20.}, {-15.55004821487255, 
       20.}, {-15.155635196071543`, 20.}, {-15.102205930995016`, 
       20.}, {-15.048776665918487`, 20.}, {-15.035419349649356`, 
       20.}, {-15.022062033380223`, 20.}, {-15.012755102040817`, 20.}}], 
      LineBox[{{-14.987244897959183`, 15.}, {-14.968632768303694`, 
       15.}, {-14.94191813576543, 15.}, {-14.835059605612372`, 
       15.}, {-14.728201075459316`, 15.}, {-14.5144840151532, 
       15.}, {-14.300766954847088`, 15.}, {-13.88112805895425, 
       15.}, {-13.461489163061414`, 15.}, {-13.07005365515327, 
       15.}, {-12.678618147245128`, 15.}, {-12.466389842385446`, 
       15.}, {-12.254161537525764`, 15.}, {-12.148047385095923`, 
       15.}, {-12.041933232666082`, 15.}, {-12.028668963612352`, 
       15.}, {-12.015404694558622`, 15.}, {-12.012755102040817`, 15.}}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7XfwtGbFT/UDDGCg4fAobMflHW8Q/OM6G9cq30fw
J91YlPjzMIIf1zJF9PwKBD/v0+nEt3fV4Py6BOZ13MIIPoOu/H7nVhU4/1b3
zPbVV5Xg/N+nGiQCeBB8Ga6MlV+cFOF8J7/N9y9dVYDzMyf9E92YgeAXJU9c
nOGL4NeYqBgqGCH4jHPffq9WQfDbWLfvuy6G4J/YKb2IVQDB58praDXmRPA3
2Zlca2dD8AHiq1aa
       "]], 
      LineBox[{{-7.987244897959184, 9.}, {-7.884753448827102, 
       9.}, {-7.778179245663845, 9.}, {-7.3596776577302085`, 
       9.}, {-6.941176069796572, 9.}, {-6.16057966989869, 
       9.}, {-5.313941066378363, 9.}, {-4.523709238827428, 
       9.}, {-3.667435207654049, 9.}, {-2.8267516259194494`, 
       9.}, {-2.4346132230368456`, 9.}, {-2.0424748201542418`, 
       9.}, {-2.0291885856325598`, 9.}, {-2.015902351110878, 
       9.}, {-2.0127551020408165`, 9.}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQXcwV53fw9P/9DGAg4lC3Uy+wJB3BV60OE5j76x+c
X/Jvad87BQT/UONXHgf3v3B+fMcUzseTf8P5f/qM2doe/ITzzeYU/j9d+Q3O
L1i5/oeg8Gc4n635xwK3opdwflia8sJLNTfh/ONnbnYZB9+wh/GtdA9uCpj+
Gc5nKhO9kyLJ4ADjs/MENCa9Y4Pzmx9ccy5azAvn/2S13CmdJADnb5jdFlD3
SRDOT5CtOzD9tBCcLzC/1GDjEmE4362/JO7KfgS/pr645/stBH/69yLlzhcI
/tym6cEfPiH4AJ6yauQ=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQnVybsYafV8SBAQw4HF7EF76wFUTwQxzyXVrcEfwD
CrkLTtUi+DMeZkSEv0Lw8xelCDwJE4Xz09r+TzN9Iwbnx2XNkm1vlIDzOwPL
LI3nSMP5LCJTn9X/koPzr59u/dDCrwjnh1Ynmc06rATn53C/VjoXpQLny68+
No3tlSqcX73DOZh/tjqcX6Z/g0U5VQPOL1iWs81MXxPOf/Lx6eqvqQh+uG38
wi1zEHyBx9IyIjsQ/FMdN6YVX0bwl982C1F+iOC36E0VvPwOwf8U7vJh1VcE
3+/gac2Knwg+AKqpXOc=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBmIQvcnO5Fo7m5YDAxTYXQnsMeJC8Nf8ZcjmEkTwpdU3
eD4SR/B/VPKxT1JF8DfJn2786IDgq2a7lG8oR/B5mMyT9J4i+DvLmYOfvUbw
096ed573CcE/cCNDlY9BG84vXj/rxVspBP9WzL+8tQEI/ortR6t19iD4rrkh
U7Um68D5Ejtl811V9OD8SUUdEw2u68P5QW3+unO3GcD5WtEtoUtqDeH8a884
F00ONYLzzyU9dRSSN4bzH7Is/zFVCcH/sixjvaQagi/5+rWMoi6Cn1L86bu+
NYL/q/n/Wt9wBF9tqaRUZz+Cb+l++wLPZATf5+Wc9gnTEPxCXYWv0+ci+Hu2
ql1YthrBDzpm3HbkOIKfmvHVxuM0gl/Btf3z6XMI/lw/q8TLVxH8F9ccbB49
RnJvBdPn1OcIPq/0kZUvXyH4RvHu4h8/IviujJznSr4i+BGLT7X8+IHgZ7n2
WNf8QfBrn/t++v8fwQcAfeeWBQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$43591#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-20, 20}, {0., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.906691672228509*^9, 3.9066917173377295`*^9}, 
   3.906691826444401*^9},
 CellLabel->
  "Out[239]=",ExpressionUUID->"508e113f-baf6-4e9a-a85c-caf2ff0ac1f3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"P2", "[", "T_", "]"}], ":=", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"Reverse", "/@", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
            RowBox[{"T", "<=", 
             RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "15"}], "<", "T", "<=", 
            RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "12"}], "<", "T", "<=", 
            RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "8"}], "<", "T", "<=", 
            RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"T", ">", "13"}], ",", "0"}], "}"}], ",", "2"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"P2", "[", "T", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.906691943233055*^9, 3.906692027480878*^9}},
 CellLabel->
  "In[274]:=",ExpressionUUID->"c9fa5922-6fc0-4229-86f2-9652fd0bcd49"],

Cell[BoxData["Piecewise"], "Input",
 CellChangeTimes->{{3.9066918519026318`*^9, 
  3.906691853769823*^9}},ExpressionUUID->"1aaac348-c292-45f6-a0e1-\
57072463167d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "P", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"20", "/;", 
    RowBox[{"T", "<=", 
     RowBox[{"-", "15"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"15", "/;", 
    RowBox[{
     RowBox[{"-", "15"}], "<", "T", "<=", 
     RowBox[{"-", "12"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"12", "/;", 
    RowBox[{
     RowBox[{"-", "12"}], "<", "T", "<=", 
     RowBox[{"-", "8"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"9", "/;", 
    RowBox[{
     RowBox[{"-", "8"}], "<", "T", "<=", 
     RowBox[{"-", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"5", "/;", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "T", "<=", 
     RowBox[{"+", "5"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"3", "/;", 
    RowBox[{"5", "<", "T", "<=", "13"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{"13", "<", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"P", "[", "T", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"P", "[", "T", "]"}], "-", 
      RowBox[{"P1", "[", "T", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", 
       RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodinoveEnergie", "=", 
   RowBox[{"P", "/@", "teploty"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"celkem", "=", 
    RowBox[{"Total", "[", "hodinoveEnergie", "]"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<celkem spotreba= \>\"", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"celkem", "*", "3600"}], 
     SuperscriptBox["10", "6"]], "//", "N"}], ",", "\"\< GJ\>\""}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906691394200259*^9, 3.9066914399291887`*^9}, {
  3.906691482545882*^9, 3.906691646544938*^9}, {3.9066917546573596`*^9, 
  3.906691760922557*^9}, {3.9066918325194955`*^9, 3.9066918438006773`*^9}, {
  3.9066921819894533`*^9, 3.9066922930116596`*^9}, {3.9066923754124737`*^9, 
  3.9066923757891235`*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"df01f70b-9a45-4cf1-8631-21fabca340aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"celkem spotreba= \"\>", "\[InvisibleSpace]", "74.5632`", 
   "\[InvisibleSpace]", "\<\" GJ\"\>"}],
  SequenceForm["celkem spotreba= ", 74.5632, " GJ"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9066922698331976`*^9, 3.9066922934889364`*^9}, 
   3.9066923768243484`*^9},
 CellLabel->
  "During evaluation of \
In[339]:=",ExpressionUUID->"b9d87df4-7197-4295-8453-bb946ef3ff86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "teploty", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dvojice", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "-", "1"}], ")"}], "*", "3600"}], ",", 
       RowBox[{"teploty", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teplota", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"dvojice", ",", 
     RowBox[{"InterpolationOrder", "->", "0"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"teplota", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"energie", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"teplota", "[", "t", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9066924565337133`*^9, 3.906692568285914*^9}, {
  3.906692609581072*^9, 3.9066926304392014`*^9}, {3.9066926828143516`*^9, 
  3.9066927901841197`*^9}, {3.9066930943348885`*^9, 3.906693098563115*^9}},
 CellLabel->
  "In[386]:=",ExpressionUUID->"d64fa0a7-82a8-4698-94c3-0fda502ad916"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 390, 4, 30047219477750647461,
    "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906692790904142*^9, 3.906693099647092*^9},
 CellLabel->
  "During evaluation of \
In[386]:=",ExpressionUUID->"812cd6e6-bc73-44f5-9a63-0f1246b07aab"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "ncvb", 
   "\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) recursive bisections in \
\\!\\(\\*RowBox[{\\\"t\\\"}]\\) near \\!\\(\\*RowBox[{\\\"{\\\", \\\"t\\\", \
\\\"}\\\"}]\\) = \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.850248216024077`*^6\\\", \
\\\"}\\\"}]\\). NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"7.230282013017038`*^7\\\"}]\\) and \
\\!\\(\\*RowBox[{\\\"2.6637987089154874`*^6\\\"}]\\) for the integral and \
error estimates.\"", 2, 390, 5, 30047219477750647461, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906692790904142*^9, 3.906693099662716*^9},
 CellLabel->
  "During evaluation of \
In[386]:=",ExpressionUUID->"b584ddcc-8e24-4fbe-8073-07ce84557421"],

Cell[BoxData["7.230282013017038`*^7"], "Output",
 CellChangeTimes->{
  3.9066924588299856`*^9, 3.906692491047865*^9, 3.906692568835784*^9, 
   3.906692631066777*^9, {3.906692693726636*^9, 3.906692735184021*^9}, 
   3.9066927909982634`*^9, 3.906693099678345*^9},
 CellLabel->
  "Out[390]=",ExpressionUUID->"b034aff7-23f1-4efe-9779-9c585497009f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"P", "[", 
          RowBox[{"teplota", "[", "t", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"e", "[", "tmin", "]"}], "==", "0"}]}], "}"}], ",", "e", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tmin", ",", " ", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "->", "10"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<celkem spotreba= \>\"", ",", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"e", "[", "tmax", "]"}], "/.", "sol"}], 
      SuperscriptBox["10", "6"]], "//", "N"}], ",", "\"\< GJ\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9066929623220377`*^9, 3.906693064415374*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"8e257bea-3040-460f-b860-d9e376f30633"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"celkem spotreba= \"\>", "\[InvisibleSpace]", 
   "74.55238264059874`", "\[InvisibleSpace]", "\<\" GJ\"\>"}],
  SequenceForm["celkem spotreba= ", 74.55238264059874, " GJ"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066930434523153`*^9, 3.906693083564986*^9, 
  3.906693120614758*^9},
 CellLabel->
  "During evaluation of \
In[391]:=",ExpressionUUID->"ddd0709f-ef26-4df2-be3a-37c4a3198665"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}, 3.906689667589672*^9},
 CellLabel->
  "In[395]:=",ExpressionUUID->"380da6cb-4304-4ddc-8c80-d4d1ee7974d9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mereni", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<DataStatistika.xls\>\"", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", ";;", ",", "1"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mean", "=", 
   RowBox[{"Mean", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"var", "=", 
   RowBox[{"Variance", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sd", "=", 
   RowBox[{"StandardDeviation", "[", "mereni", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{"Total", "[", "mereni", "]"}], "n"], "-", 
  "mean"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906689682623513*^9, 3.9066898067879105`*^9}, {
  3.906689871323526*^9, 3.906689878839707*^9}, {3.9066904003846645`*^9, 
  3.906690438002571*^9}, {3.9066931834805717`*^9, 3.906693365258732*^9}, {
  3.906693413410345*^9, 
  3.906693477073718*^9}},ExpressionUUID->"52af7075-f1e2-40d2-aa66-\
9c7f8914e277"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.9066934669498587`*^9, 3.9066934724703765`*^9}},
 CellLabel->
  "Out[462]=",ExpressionUUID->"8b708043-bcb2-4e6d-8744-bcf47dac51e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["var"], "Input",
 CellChangeTimes->{{3.9066935579155235`*^9, 3.9066935582290916`*^9}},
 CellLabel->
  "In[468]:=",ExpressionUUID->"d0aefc0f-5795-4c21-9a5f-a0c75f2d1a6b"],

Cell[BoxData["212.21462996995172`"], "Output",
 CellChangeTimes->{3.90669355870059*^9},
 CellLabel->
  "Out[468]=",ExpressionUUID->"fee1ed13-9bc0-417b-b9d4-b8d7df9b08b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"Total", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"mereni", "-", "mean"}], ")"}], "2"], "]"}], 
  StyleBox[
   RowBox[{"n", "-", "1"}],
   FontColor->RGBColor[1, 0, 0]]]], "Input",
 CellChangeTimes->{{3.9066935007072926`*^9, 3.9066935503463783`*^9}, {
  3.9066935935633316`*^9, 3.906693593939483*^9}},
 CellLabel->
  "In[469]:=",ExpressionUUID->"656c6763-c400-4248-a7a9-7208a05e17d0"],

Cell[BoxData["212.2146299699517`"], "Output",
 CellChangeTimes->{{3.906693504941555*^9, 3.906693550895708*^9}, 
   3.9066935943949833`*^9},
 CellLabel->
  "Out[469]=",ExpressionUUID->"26386c0a-af91-4196-8276-286ef8a80a44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 SqrtBox[
  FractionBox[
   RowBox[{"Total", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"mereni", "-", "mean"}], ")"}], "2"], "]"}], 
   RowBox[{"n", "-", "1"}]]], "\[IndentingNewLine]", "sd"}], "Input",
 CellChangeTimes->{{3.906693652988057*^9, 3.906693660345026*^9}},
 CellLabel->
  "In[471]:=",ExpressionUUID->"97a94c4b-a0de-4382-b8f0-35eac1e7a4df"],

Cell[BoxData["14.567588337468617`"], "Output",
 CellChangeTimes->{{3.9066936535677924`*^9, 3.906693660724206*^9}},
 CellLabel->
  "Out[471]=",ExpressionUUID->"99947fb3-62da-4e38-9c0a-2496f3842036"],

Cell[BoxData["14.567588337468619`"], "Output",
 CellChangeTimes->{{3.9066936535677924`*^9, 3.906693660724206*^9}},
 CellLabel->
  "Out[472]=",ExpressionUUID->"e5c4d922-82fe-4625-960a-63c283c320d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", "*", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<z= \>\"", ",", 
   RowBox[{"TraditionalForm", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "*", 
     SuperscriptBox["E", 
      RowBox[{"I", "*", 
       RowBox[{"Arg", "[", "z", "]"}]}]]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<z= \>\"", ",", 
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], "*", 
    SuperscriptBox["E", 
     RowBox[{"I", "*", 
      RowBox[{"Arg", "[", "z", "]"}]}]]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.906693756096627*^9, 3.9066938563819313`*^9}},
 CellLabel->
  "In[475]:=",ExpressionUUID->"634016ce-821e-4bfb-b03c-fbfdf6894d3d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z= \"\>", "\[InvisibleSpace]", 
   TagBox[
    FormBox[
     RowBox[{
      SqrtBox["5"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{
         SuperscriptBox["tan", 
          RowBox[{"-", "1"}]], "(", "2", ")"}]}]]}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}],
  SequenceForm["z= ", 
   TraditionalForm[5^Rational[1, 2] E^(Complex[0, 1] ArcTan[2])]],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066938239498634`*^9, 3.9066938568522873`*^9},
 CellLabel->
  "During evaluation of \
In[475]:=",ExpressionUUID->"4e4bbd41-3ad9-41cb-98fc-2e20d985db8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z= \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SqrtBox["5"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"ArcTan", "[", "2", "]"}]}]]}]}],
  SequenceForm["z= ", 5^Rational[1, 2] E^(Complex[0, 1] ArcTan[2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066938239498634`*^9, 3.9066938568522873`*^9},
 CellLabel->
  "During evaluation of \
In[475]:=",ExpressionUUID->"96eef058-2645-4e24-bff9-fc61810f9db9"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1428., 825.75},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.4 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"daddefa0-4b23-49df-b118-d53eb21ef294"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 564, 13, 160, "Input",ExpressionUUID->"60a4a78e-000b-4703-b419-1e934bcb9f30"],
Cell[1147, 37, 181, 3, 77, "Output",ExpressionUUID->"c6cfffa9-d0cb-46e3-9340-facfa9f2db94"]
}, Open  ]],
Cell[1343, 43, 179, 3, 67, "Input",ExpressionUUID->"be906b25-f752-4b17-a529-2551c3f02e03"],
Cell[CellGroupData[{
Cell[1547, 50, 1718, 44, 388, "Input",ExpressionUUID->"8a256d78-bb04-49ee-a95e-093a8c497241"],
Cell[3268, 96, 639, 12, 123, "Output",ExpressionUUID->"eba9d314-9454-45a1-937d-aa9ab2cd9357"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3944, 113, 656, 19, 160, "Input",ExpressionUUID->"ab2ae774-a8d7-4b4c-9d58-f825f9de5909"],
Cell[4603, 134, 1224, 31, 123, "Output",ExpressionUUID->"f111f257-0857-499b-a65e-42fbb674ce46"]
}, Open  ]],
Cell[5842, 168, 1858, 44, 342, "Input",ExpressionUUID->"833d7e0a-b33b-4339-b1cc-42b0b31fa2f6"],
Cell[CellGroupData[{
Cell[7725, 216, 1257, 39, 342, "Input",ExpressionUUID->"f2342688-ae13-48cb-baf7-60369d065b29"],
Cell[8985, 257, 565, 11, 123, "Output",ExpressionUUID->"66801b6c-f555-469b-ac02-d1bbe94c4a10"]
}, Open  ]],
Cell[9565, 271, 2207, 60, 479, "Input",ExpressionUUID->"400362b7-1a26-4406-ac3b-bf4965c40225"],
Cell[CellGroupData[{
Cell[11797, 335, 298, 6, 114, "Input",ExpressionUUID->"d0e900d5-91ce-4dc7-b337-066b6f1d15ff"],
Cell[12098, 343, 424, 8, 77, "Output",ExpressionUUID->"1ac154be-8618-49ad-b048-aa36f529a45f"],
Cell[12525, 353, 803, 25, 123, "Output",ExpressionUUID->"59f84142-19c3-4c45-9329-39fcde8e7293"]
}, Open  ]],
Cell[13343, 381, 618, 17, 160, "Input",ExpressionUUID->"ebdaeb30-1640-4569-9d0c-624de813d8d2"],
Cell[CellGroupData[{
Cell[13986, 402, 2304, 65, 571, "Input",ExpressionUUID->"4baf7827-d9fb-4d72-a217-0545b500b66c"],
Cell[16293, 469, 237, 5, 77, "Output",ExpressionUUID->"3480de9b-0eab-4b59-bbfe-305b0fb557cb"],
Cell[16533, 476, 256, 6, 77, "Output",ExpressionUUID->"527ec9b1-50a9-419e-8398-563550fa034d"]
}, Open  ]],
Cell[16804, 485, 1809, 55, 344, "Input",ExpressionUUID->"38aee430-6229-44e0-a869-8be597f99731"],
Cell[18616, 542, 1703, 53, 344, "Input",ExpressionUUID->"c290d6d0-0a6d-447c-9ce1-11fb9f6c1603"],
Cell[CellGroupData[{
Cell[20344, 599, 683, 19, 203, "Input",ExpressionUUID->"f6edb8ca-405e-4ac4-8293-dc40d6c0ef16"],
Cell[21030, 620, 866, 19, 123, "Output",ExpressionUUID->"fa7f5ade-2558-4fd2-b49f-4f26785d8cd9"],
Cell[21899, 641, 848, 20, 136, "Output",ExpressionUUID->"fcc85842-02cd-4d07-a793-e4d38047cb39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22784, 666, 230, 5, 68, "Input",ExpressionUUID->"38a4472f-8ae5-4c0b-a951-0c32fce450cc"],
Cell[23017, 673, 2754, 77, 499, "Output",ExpressionUUID->"57c9bba8-d5c4-4075-b421-9f8469f1026d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25808, 755, 334, 7, 114, "Input",ExpressionUUID->"dedec0b3-4dd4-4289-a383-9553f58b7b3a"],
Cell[26145, 764, 268, 6, 77, "Output",ExpressionUUID->"afcda4d7-4695-4cd0-b669-151523f3b973"],
Cell[26416, 772, 329, 8, 77, "Output",ExpressionUUID->"b09f0dab-de9e-4154-acac-eeb5edeaa3f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26782, 785, 216, 4, 67, "Input",ExpressionUUID->"b80975ef-ef9c-42cd-aec2-806b8efcdf9d"],
Cell[27001, 791, 288, 7, 77, "Output",ExpressionUUID->"cf5cb471-65f8-40f8-b13e-fb756e941b70"]
}, Open  ]],
Cell[27304, 801, 177, 4, 67, "Input",ExpressionUUID->"e4dde944-1321-4e6f-8351-2e30e563fcbd"],
Cell[CellGroupData[{
Cell[27506, 809, 294, 9, 112, "Input",ExpressionUUID->"0d1da216-6ba4-47b7-b645-d0ef8126eb84"],
Cell[27803, 820, 459, 15, 84, "Output",ExpressionUUID->"20a0ba67-1cb3-4d9f-a787-d15311703277"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28299, 840, 229, 4, 67, "Input",ExpressionUUID->"981f1133-eb50-46a5-a728-3dd766e91a06"],
Cell[28531, 846, 342, 11, 110, "Output",ExpressionUUID->"63edf0c9-8737-4817-973b-8b917f68c90d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28910, 862, 1831, 49, 434, "Input",ExpressionUUID->"c82b66fe-d38a-47b9-b4fd-bcc9c5cbac81"],
Cell[30744, 913, 667, 17, 84, "Output",ExpressionUUID->"2bd45318-2e0c-45a8-8fa5-48c24cf6c649"],
Cell[31414, 932, 814, 19, 123, "Output",ExpressionUUID->"66dd8154-f36a-44ee-abd9-3fcce159cbca"],
Cell[32231, 953, 370, 8, 77, "Output",ExpressionUUID->"eeec8b34-852d-4e45-a8b5-a8b02d304b4c"]
}, Open  ]],
Cell[32616, 964, 152, 3, 67, "Input",ExpressionUUID->"b8285001-ecf4-420f-b6d7-c67099f83650"],
Cell[CellGroupData[{
Cell[32793, 971, 948, 28, 251, "Input",ExpressionUUID->"f396f575-008b-4683-aa3f-6454f00e1e6d"],
Cell[33744, 1001, 425, 11, 77, "Output",ExpressionUUID->"ec4fd5bf-3567-45a2-a402-864b75379018"],
Cell[34172, 1014, 365, 9, 77, "Output",ExpressionUUID->"7ff8ede8-ef74-416d-81b5-7f85cae0b376"]
}, Open  ]],
Cell[34552, 1026, 601, 13, 160, "Input",ExpressionUUID->"0f02548d-6b74-498a-ba06-9a74acfe2ad0"],
Cell[35156, 1041, 1410, 41, 479, "Input",ExpressionUUID->"6fade0c1-17c6-4a59-baf2-4cf4dbb6ff53"],
Cell[36569, 1084, 2426, 58, 753, "Input",ExpressionUUID->"d2027d55-7db4-48f0-8ce1-31080b9e72ea"],
Cell[CellGroupData[{
Cell[39020, 1146, 197, 4, 67, "Input",ExpressionUUID->"a971ab71-f16f-4861-9bfe-025f3718922d"],
Cell[39220, 1152, 11545, 287, 657, "Output",ExpressionUUID->"3d4674a7-6d3c-4fe3-a057-527f93b676a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50802, 1444, 1543, 39, 479, "Input",ExpressionUUID->"bcf1800b-5e94-4c1f-85cb-d618080fb1c5"],
Cell[52348, 1485, 4873, 102, 580, "Output",ExpressionUUID->"508e113f-baf6-4e9a-a85c-caf2ff0ac1f3"]
}, Open  ]],
Cell[57236, 1590, 1642, 42, 434, "Input",ExpressionUUID->"c9fa5922-6fc0-4229-86f2-9652fd0bcd49"],
Cell[58881, 1634, 163, 3, 67, "Input",ExpressionUUID->"1aaac348-c292-45f6-a0e1-57072463167d"],
Cell[CellGroupData[{
Cell[59069, 1641, 2842, 87, 757, "Input",ExpressionUUID->"df01f70b-9a45-4cf1-8631-21fabca340aa"],
Cell[61914, 1730, 434, 10, 52, "Print",ExpressionUUID->"b9d87df4-7197-4295-8453-bb946ef3ff86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62385, 1745, 1474, 42, 251, "Input",ExpressionUUID->"d64fa0a7-82a8-4698-94c3-0fda502ad916"],
Cell[63862, 1789, 507, 11, 110, "Message",ExpressionUUID->"812cd6e6-bc73-44f5-9a63-0f1246b07aab"],
Cell[64372, 1802, 781, 15, 163, "Message",ExpressionUUID->"b584ddcc-8e24-4fbe-8073-07ce84557421"],
Cell[65156, 1819, 344, 6, 77, "Output",ExpressionUUID->"b034aff7-23f1-4efe-9779-9c585497009f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65537, 1830, 1098, 30, 300, "Input",ExpressionUUID->"8e257bea-3040-460f-b860-d9e376f30633"],
Cell[66638, 1862, 447, 10, 52, "Print",ExpressionUUID->"ddd0709f-ef26-4df2-be3a-37c4a3198665"]
}, Open  ]],
Cell[67100, 1875, 605, 14, 160, "Input",ExpressionUUID->"380da6cb-4304-4ddc-8c80-d4d1ee7974d9"],
Cell[CellGroupData[{
Cell[67730, 1893, 1215, 32, 434, "Input",ExpressionUUID->"52af7075-f1e2-40d2-aa66-9c7f8914e277"],
Cell[68948, 1927, 183, 3, 77, "Output",ExpressionUUID->"8b708043-bcb2-4e6d-8744-bcf47dac51e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69168, 1935, 182, 3, 67, "Input",ExpressionUUID->"d0aefc0f-5795-4c21-9a5f-a0c75f2d1a6b"],
Cell[69353, 1940, 170, 3, 77, "Output",ExpressionUUID->"fee1ed13-9bc0-417b-b9d4-b8d7df9b08b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69560, 1948, 437, 12, 116, "Input",ExpressionUUID->"656c6763-c400-4248-a7a9-7208a05e17d0"],
Cell[70000, 1962, 222, 4, 77, "Output",ExpressionUUID->"26386c0a-af91-4196-8276-286ef8a80a44"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70259, 1971, 383, 10, 196, "Input",ExpressionUUID->"97a94c4b-a0de-4382-b8f0-35eac1e7a4df"],
Cell[70645, 1983, 197, 3, 77, "Output",ExpressionUUID->"99947fb3-62da-4e38-9c0a-2496f3842036"],
Cell[70845, 1988, 197, 3, 77, "Output",ExpressionUUID->"e5c4d922-82fe-4625-960a-63c283c320d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71079, 1996, 788, 23, 172, "Input",ExpressionUUID->"634016ce-821e-4bfb-b03c-fbfdf6894d3d"],
Cell[CellGroupData[{
Cell[71892, 2023, 686, 21, 62, "Print",ExpressionUUID->"4e4bbd41-3ad9-41cb-98fc-2e20d985db8d"],
Cell[72581, 2046, 512, 13, 55, "Print",ExpressionUUID->"96eef058-2645-4e24-bff9-fc61810f9db9"]
}, Open  ]]
}, Open  ]]
}
]
*)

