(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    146432,       3868]
NotebookOptionsPosition[    134066,       3664]
NotebookOutlinePosition[    134572,       3682]
CellTagsIndexPosition[    134529,       3679]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}},ExpressionUUID->"60a4a78e-000b-4703-b419-\
1e934bcb9f30"],

Cell[BoxData["\<\"D:\\\\VYUKA\\\\iap2023\"\>"], "Output",
 CellChangeTimes->{
  3.90608541022882*^9},ExpressionUUID->"c6cfffa9-d0cb-46e3-9340-facfa9f2db94"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9060845212002563`*^9, 
  3.9060845212002563`*^9}},ExpressionUUID->"be906b25-f752-4b17-a529-\
2551c3f02e03"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"info", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataReal", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{"Transpose", "[", "data1", "]"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906084156409767*^9, 3.906084161955413*^9}, {
   3.906084344810624*^9, 3.906084348881589*^9}, {3.9060845348008585`*^9, 
   3.906084570519206*^9}, 3.90608462097089*^9, {3.906084679119188*^9, 
   3.906084761976327*^9}, {3.906084798679098*^9, 3.906084803409314*^9}, 
   3.9060848396510096`*^9, {3.906084893812612*^9, 3.906084939864373*^9}, {
   3.906084977913763*^9, 3.9060850313520412`*^9}, {3.9060850621930556`*^9, 
   3.906085126265901*^9}},ExpressionUUID->"8a256d78-bb04-49ee-a95e-\
093a8c497241"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906085004961555*^9, 3.9060850135550203`*^9}, {
   3.9060850652661605`*^9, 3.906085126801789*^9}, 
   3.9060854102762623`*^9},ExpressionUUID->"eba9d314-9454-45a1-937d-\
aa9ab2cd9357"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "b", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rovnice", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"A", ".", "nezname"}], "==", "b"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "rovnice", "]"}]}], "Input",
 CellChangeTimes->{{3.9060851404271755`*^9, 3.906085221740617*^9}, {
  3.9060853421076193`*^9, 
  3.9060853512980056`*^9}},ExpressionUUID->"ab2ae774-a8d7-4b4c-9d58-\
f825f9de5909"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", "3.09193370835402`"}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     RowBox[{"-", "1.37183183356454`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", "0.27537728971604836`"}], ",", 
    RowBox[{
     SubscriptBox["x", "4"], "\[Rule]", "2.7605480410534207`"}], ",", 
    RowBox[{
     SubscriptBox["x", "5"], "\[Rule]", 
     RowBox[{"-", "0.3056072433248169`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "6"], "\[Rule]", "3.051173169637574`"}], ",", 
    RowBox[{
     SubscriptBox["x", "7"], "\[Rule]", "2.5473126863519013`"}], ",", 
    RowBox[{
     SubscriptBox["x", "8"], "\[Rule]", "6.20371892158359`"}], ",", 
    RowBox[{
     SubscriptBox["x", "9"], "\[Rule]", 
     RowBox[{"-", "1.5918417224634418`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "10"], "\[Rule]", 
     RowBox[{"-", "3.981102568677317`"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9060851736724653`*^9, 3.906085222353649*^9}, {
   3.9060853424375076`*^9, 3.9060853522283707`*^9}, 
   3.9060854102918854`*^9},ExpressionUUID->"f111f257-0857-499b-a65e-\
42fbb674ce46"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maticeA", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{";;", 
       RowBox[{"-", "2"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinearSolve", "[", 
   RowBox[{"maticeA", ",", "b"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906084156409767*^9, 3.906084161955413*^9}, {
   3.906084344810624*^9, 3.906084348881589*^9}, {3.9060845348008585`*^9, 
   3.906084570519206*^9}, 3.90608462097089*^9, {3.906084679119188*^9, 
   3.906084761976327*^9}, {3.906084798679098*^9, 3.906084803409314*^9}, 
   3.9060848396510096`*^9, {3.906084893812612*^9, 3.906084939864373*^9}, {
   3.906084977913763*^9, 3.9060850313520412`*^9}, {3.9060850621930556`*^9, 
   3.906085126265901*^9}, {3.9060854939756455`*^9, 3.9060855012529893`*^9}, {
   3.9060855671485558`*^9, 3.9060855775616846`*^9}, {3.906085612423377*^9, 
   3.9060856706505427`*^9}, 3.9060857137370577`*^9, {3.9060857565028296`*^9, 
   3.906085780688182*^9}, {3.906085865934195*^9, 3.9060859250303917`*^9}, {
   3.9060859587030153`*^9, 
   3.906086068467969*^9}},ExpressionUUID->"833d7e0a-b33b-4339-b1cc-\
42b0b31fa2f6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataReal", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", 
       RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906086088435356*^9, 
  3.906086218024295*^9}},ExpressionUUID->"f2342688-ae13-48cb-baf7-\
60369d065b29"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060861950906253`*^9, 
  3.9060862186221533`*^9}},ExpressionUUID->"66801b6c-f555-469b-ac02-\
d1bbe94c4a10"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataComplex", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"dataComplex", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "data1"}], ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"re_Real", ",", "im_"}], "}"}], ":>", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", "data2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{"Transpose", "[", "data1", "]"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", ">>", "\"\<res1\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.906086298985217*^9, 3.906086355752006*^9}, {
   3.906086399312234*^9, 3.906086465651675*^9}, 3.9060865294037495`*^9, 
   3.906086584395951*^9, {3.906086661731371*^9, 3.90608672017743*^9}, {
   3.9060868287916355`*^9, 3.9060868358896203`*^9}, {3.9060869509929934`*^9, 
   3.9060869818576584`*^9}, {3.9060880043192425`*^9, 
   3.9060880063580647`*^9}, {3.9060880768856115`*^9, 
   3.9060880848556986`*^9}},ExpressionUUID->"400362b7-1a26-4406-ac3b-\
bf4965c40225"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Range", "[", "20", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"%", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906086532647899*^9, 
  3.9060865482007613`*^9}},ExpressionUUID->"d0e900d5-91ce-4dc7-b337-\
066b6f1d15ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",
 CellChangeTimes->{{3.906086537790236*^9, 
  3.906086548656083*^9}},ExpressionUUID->"1ac154be-8618-49ad-b048-\
aa36f529a45f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906086537790236*^9, 
  3.906086548656083*^9}},ExpressionUUID->"59f84142-19c3-4c45-9329-\
39fcde8e7293"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataReal", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.906087057622938*^9, {3.9060871166146913`*^9, 3.906087142389784*^9}, 
   3.9060872056788683`*^9},ExpressionUUID->"ebdaeb30-1640-4569-9d0c-\
624de813d8d2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maticeAre", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "4"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maticeAim", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"2", ";;", 
       RowBox[{"-", "3"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maticeA", "=", 
    RowBox[{"maticeAre", "+", 
     RowBox[{"I", "*", "maticeAim"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bre", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"-", "2"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bim", "=", 
   RowBox[{"dataReal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Bre", "+", 
    RowBox[{"I", "*", "Bim"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni2", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"maticeA", ",", "B"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni1", "=", 
   RowBox[{"<<", "\"\<res1\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"reseni1", "==", "reseni2"}], "\[IndentingNewLine]", 
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"reseni1", "-", "reseni2"}], "//", "Chop"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.906087057622938*^9, {3.9060871166146913`*^9, 3.906087142389784*^9}, 
   3.9060872111148643`*^9, 3.9060872443798456`*^9, {3.906087290687933*^9, 
   3.9060874884470215`*^9}, {3.9060875351535535`*^9, 
   3.9060875439523907`*^9}, {3.90608780942445*^9, 3.906087817889943*^9}, {
   3.9060878621536913`*^9, 3.906087977714353*^9}, {3.906088022614476*^9, 
   3.9060880241372404`*^9}, {3.906088138504223*^9, 3.9060881684887667`*^9}, {
   3.9060882088693047`*^9, 3.9060882129936323`*^9}, {3.906088246601988*^9, 
   3.906088260729715*^9}},ExpressionUUID->"4baf7827-d9fb-4d72-a217-\
0545b500b66c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9060881692585397`*^9, 3.9060882142983165`*^9, {3.906088248444545*^9, 
   3.9060882614059467`*^9}},ExpressionUUID->"3480de9b-0eab-4b59-bbfe-\
305b0fb557cb"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.9060881692585397`*^9, 3.9060882142983165`*^9, {3.906088248444545*^9, 
   3.9060882614059467`*^9}},ExpressionUUID->"527ec9b1-50a9-419e-8398-\
563550fa034d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
     FractionBox[
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"t", "+", "1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "5"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9060883040142403`*^9, 3.9060884517851257`*^9}, 
   3.9060887028810587`*^9, {3.9060887454520297`*^9, 
   3.9060887510406876`*^9}},ExpressionUUID->"38aee430-6229-44e0-a869-\
8be597f99731"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
        RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
     FractionBox[
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"t", "+", "1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "5"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.90608872676969*^9, 
  3.906088756645773*^9}},ExpressionUUID->"c290d6d0-0a6d-447c-9ce1-\
11fb9f6c1603"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pom", "=", 
  RowBox[{
   RowBox[{"MatrixPower", "[", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {"1", "2"},
        {"7", "13"}
       }], ")"}], ",", 
     FractionBox["1", "5"]}], "]"}], "//", "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", ".", "pom", ".", "pom", ".", "pom", ".", "pom"}], "//", 
  "Chop"}]}], "Input",
 CellChangeTimes->{{3.9060888236153526`*^9, 3.9060888559086256`*^9}, {
  3.9060891308359656`*^9, 
  3.906089151291851*^9}},ExpressionUUID->"f6edb8ca-405e-4ac4-8293-\
dc40d6c0ef16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.5691634617262573`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.32014693179423653`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.17256009246590126`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04898558195889979`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.6039603236306542`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.17144953685614922`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.6045240165216648`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.026233440040837854`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.906088853298781*^9, 3.906088856573948*^9}, {
  3.9060891325171175`*^9, 
  3.9060891478396435`*^9}},ExpressionUUID->"fa7f5ade-2558-4fd2-b49f-\
4f26785d8cd9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.9999999999999997`", "\[VeryThinSpace]", "-", 
      RowBox[{"5.551115123125783`*^-17", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"2.`", "\[VeryThinSpace]", "-", 
      RowBox[{"6.591949208711867`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"6.999999999999998`", "\[VeryThinSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"13.`", "\[VeryThinSpace]", "+", 
      RowBox[{"2.498001805406602`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.906088853298781*^9, 3.906088856573948*^9}, {
  3.9060891325171175`*^9, 
  3.9060891478396435`*^9}},ExpressionUUID->"fcc85842-02cd-4d07-a793-\
e4d38047cb39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "//", "TreeForm"}]], "Input",
 CellChangeTimes->{{3.906089028209114*^9, 
  3.906089049788868*^9}},ExpressionUUID->"38a4472f-8ae5-4c0b-a951-\
0c32fce450cc"],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[
   TagBox[
    GraphicsComplexBox[{{0.4472135954999579, 0.8944271909999159}, {0., 0.}, {
     0.8944271909999159, 0.}}, {
      {RGBColor[0.55, 0.45, 0.45], LineBox[{{1, 2}, {1, 3}}]}, {
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          SuperscriptBox["x", "3"], HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x^3], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["3",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox["3", HoldForm]],
        Annotation[#, 
         HoldForm[3], "Tooltip"]& ]}}],
    Annotation[#, 
     VertexCoordinateRules -> {{0.4472135954999579, 0.8944271909999159}, {0., 
      0.}, {0.8944271909999159, 0.}}]& ],
   AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
   FormatType:>StandardForm,
   FrameTicks->Automatic,
   ImageSize->{198.21428571428595`, Automatic},
   PlotRange->All,
   PlotRangePadding->Scaled[0.1]],
  TreeForm[$CellContext`x^3],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.9060890501516047`*^9},ExpressionUUID->"57c9bba8-d5c4-4075-b421-\
9f8469f1026d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Attributes", "[", "Sin", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060890851657104`*^9, 
  3.9060890955228157`*^9}},ExpressionUUID->"dedec0b3-4dd4-4289-a383-\
9553f58b7b3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9060890886811495`*^9, 
  3.9060890957263966`*^9}},ExpressionUUID->"afcda4d7-4695-4cd0-b669-\
151523f3b973"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "1", "]"}], ",", 
   RowBox[{"Sin", "[", "2", "]"}], ",", 
   RowBox[{"Sin", "[", "3", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060890886811495`*^9, 
  3.9060890957263966`*^9}},ExpressionUUID->"b09f0dab-de9e-4154-acac-\
eeb5edeaa3f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Power", "]"}]], "Input",
 CellChangeTimes->{{3.906089011324544*^9, 
  3.906089016682666*^9}},ExpressionUUID->"b80975ef-ef9c-42cd-aec2-\
806b8efcdf9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", "Protected", 
   ",", "ReadProtected"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9060890171856813`*^9},ExpressionUUID->"cf5cb471-65f8-40f8-b13e-\
fb756e941b70"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}]], "Input",Express\
ionUUID->"e4dde944-1321-4e6f-8351-2e30e563fcbd"],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", GridBox[{
     {"1", "2"},
     {"7", "13"}
    }], ")"}], 
  FractionBox["1", "5"]]], "Input",
 CellChangeTimes->{{3.9060891163408046`*^9, 
  3.9060891180512185`*^9}},ExpressionUUID->"0d1da216-6ba4-47b7-b645-\
d0ef8126eb84"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["7", 
      RowBox[{"1", "/", "5"}]], ",", 
     SuperscriptBox["13", 
      RowBox[{"1", "/", "5"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.906089118843398*^9},ExpressionUUID->"20a0ba67-1cb3-4d9f-a787-\
d15311703277"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "==", "b"}], "//", "FullForm"}]], "Input",
 CellChangeTimes->{{3.9066888896654835`*^9, 
  3.9066888963365364`*^9}},ExpressionUUID->"981f1133-eb50-46a5-a728-\
3dd766e91a06"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Equal", "[", 
    RowBox[{"a", ",", "b"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{
  3.9066888969226513`*^9},ExpressionUUID->"63edf0c9-8737-4817-973b-\
8b917f68c90d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constr", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "==", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{"constr", "/.", 
    RowBox[{
     RowBox[{"Equal", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], ":>", 
     RowBox[{"lhs", "-", "rhs"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{"constr", "/.", 
    RowBox[{
     RowBox[{"lhs_", "==", "rhs_"}], ":>", 
     RowBox[{"lhs", "-", "rhs"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"expr", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rovnice", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0", "==", 
     RowBox[{"D", "[", 
      RowBox[{"lagrange", ",", "#"}], "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], 
    "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", "rovnice", "]"}], "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.906688666028878*^9, 3.906688745602178*^9}, {
  3.906688836939495*^9, 3.906688869108017*^9}, {3.9066889241037235`*^9, 
  3.9066889466616592`*^9}, {3.9066889782678175`*^9, 3.9066890350087433`*^9}, {
  3.906689067845648*^9, 3.906689106308592*^9}, {3.9066892526416397`*^9, 
  3.90668928067634*^9}, {3.9066893140315495`*^9, 
  3.906689350713806*^9}},ExpressionUUID->"c82b66fe-d38a-47b9-b4fd-\
bcc9c5cbac81"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 
   3.906689351311284*^9}},ExpressionUUID->"2bd45318-2e0c-45a8-8fa5-\
48c24cf6c649"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472135954999579`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944271909999159`"}]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "1.118033988749895`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.4472135954999579`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944271909999159`"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", "1.118033988749895`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 
   3.906689351311284*^9}},ExpressionUUID->"66dd8154-f36a-44ee-abd9-\
3fcce159cbca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.23606797749979`"}], ",", "2.23606797749979`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9066889962714825`*^9, 3.90668910066726*^9, {3.906689260811754*^9, 
   3.906689268816778*^9}, {3.906689321843901*^9, 
   3.906689351311284*^9}},ExpressionUUID->"eeec8b34-852d-4e45-a8b5-\
a8b02d304b4c"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.906688829212121*^9, 
  3.906688834509803*^9}},ExpressionUUID->"b8285001-ecf4-420f-b6d7-\
c67099f83650"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constr", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "==", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"expr", ",", "constr"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"expr", ",", "constr"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9066894074684296`*^9, 
  3.906689434149102*^9}},ExpressionUUID->"f396f575-008b-4683-aa3f-\
6454f00e1e6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.236067985266875`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472134065123647`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944272893772551`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9066894571983905`*^9},ExpressionUUID->"ec4fd5bf-3567-45a2-a402-\
864b75379018"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2360679786324718`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.44721622493105484`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944258768507084`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.906689457230426*^9},ExpressionUUID->"7ff8ede8-ef74-416d-81b5-\
7f85cae0b376"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}, 
   3.906689667589672*^9},ExpressionUUID->"0f02548d-6b74-498a-ba06-\
9a74acfe2ad0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<teploty.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"teploty", "/.", 
    RowBox[{
     RowBox[{"{", "T_", "}"}], ":>", "T"}]}], ";"}], 
  RowBox[{"(*", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Flatten", "[", "teploty", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "1"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"First", "/@", "teploty"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Last", "/@", "teploty"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "teploty"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "teploty", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ">>", "\"\<teploty\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906689682623513*^9, 3.9066898067879105`*^9}, {
  3.906689871323526*^9, 3.906689878839707*^9}, {3.9066904003846645`*^9, 
  3.906690438002571*^9}},ExpressionUUID->"6fade0c1-17c6-4a59-baf2-\
4cf4dbb6ff53"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{"<<", "teploty"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"teploty", ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Joined", "->", "True"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "15"}], "<", "T", "<=", 
        RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], "<", "T", "<=", 
          RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], "<", "T", "<=", 
            RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9066897098562737`*^9, 3.906689727559839*^9}, {
  3.906690443646738*^9, 3.906690455695727*^9}, {3.9066905201409826`*^9, 
  3.9066905363764*^9}, {3.9066905762831707`*^9, 3.906690619730276*^9}, {
  3.906690680843998*^9, 3.9066907499201155`*^9}, {3.906690798828497*^9, 
  3.9066908242204514`*^9}, {3.9066908596180334`*^9, 3.906691042194658*^9}, {
  3.9066911499871864`*^9, 3.9066911642821527`*^9}, {3.9066913664848757`*^9, 
  3.906691378813081*^9}},ExpressionUUID->"d2027d55-7db4-48f0-8ce1-\
31080b9e72ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "P"}]], "Input",
 CellChangeTimes->{{3.9066913091603713`*^9, 
  3.9066913133617873`*^9}},ExpressionUUID->"a971ab71-f16f-4861-9bfe-\
025f3718922d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`P\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"P", "[", "T_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "\[Infinity]"}], "<", "T"}], "&&", 
                    RowBox[{"T", "\[LessEqual]", 
                    RowBox[{"-", "15"}]}]}], ",", "20", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "15"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "12"}]}], ",", "15", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "12"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "8"}]}], ",", "12", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "8"}], "<", "T", "\[LessEqual]", 
                    RowBox[{"-", "2"}]}], ",", "9", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "<", "T", "\[LessEqual]", "5"}], ",", 
                    "5", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"5", "<", "T", "\[LessEqual]", "13"}], ",", "3", 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"T", ">", "13"}], ",", "0"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`P\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->{},
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{24., {8., 16.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{24., {8., 16.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`P\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`P", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`P, {$CellContext`P[
         Pattern[$CellContext`T, 
          Blank[]]] :> If[
         And[-Infinity < $CellContext`T, $CellContext`T <= -15], 20, 
         If[
          Inequality[-15, Less, $CellContext`T, LessEqual, -12], 15, 
          If[
           Inequality[-12, Less, $CellContext`T, LessEqual, -8], 12, 
           If[
            Inequality[-8, Less, $CellContext`T, LessEqual, -2], 9, 
            If[
             Inequality[-2, Less, $CellContext`T, LessEqual, 5], 5, 
             If[
              Inequality[5, Less, $CellContext`T, LessEqual, 13], 3, 
              If[$CellContext`T > 13, 0]]]]]]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> "Global`P"|>, 
   False]]], "Output",
 CellChangeTimes->{
  3.906691314555398*^9},ExpressionUUID->"3d4674a7-6d3c-4fe3-a057-\
527f93b676a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "P1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P1", "[", "T_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "15"}], "<", "T", "<=", 
      RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "12"}], "<", "T", "<=", 
      RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "8"}], "<", "T", "<=", 
      RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"P1", "[", "T", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.906691171758151*^9, 3.906691176907378*^9}, {
   3.906691228194005*^9, 3.906691285569903*^9}, {3.906691324106803*^9, 
   3.9066913254430585`*^9}, 3.906691390602851*^9, {3.906691664616319*^9, 
   3.906691713630332*^9}},ExpressionUUID->"bcf1800b-5e94-4c1f-85cb-\
d618080fb1c5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[{{-19.99999918367347, 20.}, {-19.607426367806127`, 
       20.}, {-19.214853551938784`, 20.}, {-18.363665716581654`, 
       20.}, {-17.568884657193916`, 20.}, {-16.789694047244957`, 
       20.}, {-15.944461233673556`, 20.}, {-15.55004821487255, 
       20.}, {-15.155635196071543`, 20.}, {-15.102205930995016`, 
       20.}, {-15.048776665918487`, 20.}, {-15.035419349649356`, 
       20.}, {-15.022062033380223`, 20.}, {-15.012755102040817`, 20.}}], 
      LineBox[{{-14.987244897959183`, 15.}, {-14.968632768303694`, 
       15.}, {-14.94191813576543, 15.}, {-14.835059605612372`, 
       15.}, {-14.728201075459316`, 15.}, {-14.5144840151532, 
       15.}, {-14.300766954847088`, 15.}, {-13.88112805895425, 
       15.}, {-13.461489163061414`, 15.}, {-13.07005365515327, 
       15.}, {-12.678618147245128`, 15.}, {-12.466389842385446`, 
       15.}, {-12.254161537525764`, 15.}, {-12.148047385095923`, 
       15.}, {-12.041933232666082`, 15.}, {-12.028668963612352`, 
       15.}, {-12.015404694558622`, 15.}, {-12.012755102040817`, 15.}}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7XfwtGbFT/UDDGCg4fAobMflHW8Q/OM6G9cq30fw
J91YlPjzMIIf1zJF9PwKBD/v0+nEt3fV4Py6BOZ13MIIPoOu/H7nVhU4/1b3
zPbVV5Xg/N+nGiQCeBB8Ga6MlV+cFOF8J7/N9y9dVYDzMyf9E92YgeAXJU9c
nOGL4NeYqBgqGCH4jHPffq9WQfDbWLfvuy6G4J/YKb2IVQDB58praDXmRPA3
2Zlca2dD8AHiq1aa
       "]], 
      LineBox[{{-7.987244897959184, 9.}, {-7.884753448827102, 
       9.}, {-7.778179245663845, 9.}, {-7.3596776577302085`, 
       9.}, {-6.941176069796572, 9.}, {-6.16057966989869, 
       9.}, {-5.313941066378363, 9.}, {-4.523709238827428, 
       9.}, {-3.667435207654049, 9.}, {-2.8267516259194494`, 
       9.}, {-2.4346132230368456`, 9.}, {-2.0424748201542418`, 
       9.}, {-2.0291885856325598`, 9.}, {-2.015902351110878, 
       9.}, {-2.0127551020408165`, 9.}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQXcwV53fw9P/9DGAg4lC3Uy+wJB3BV60OE5j76x+c
X/Jvad87BQT/UONXHgf3v3B+fMcUzseTf8P5f/qM2doe/ITzzeYU/j9d+Q3O
L1i5/oeg8Gc4n635xwK3opdwflia8sJLNTfh/ONnbnYZB9+wh/GtdA9uCpj+
Gc5nKhO9kyLJ4ADjs/MENCa9Y4Pzmx9ccy5azAvn/2S13CmdJADnb5jdFlD3
SRDOT5CtOzD9tBCcLzC/1GDjEmE4362/JO7KfgS/pr645/stBH/69yLlzhcI
/tym6cEfPiH4AJ6yauQ=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQnVybsYafV8SBAQw4HF7EF76wFUTwQxzyXVrcEfwD
CrkLTtUi+DMeZkSEv0Lw8xelCDwJE4Xz09r+TzN9Iwbnx2XNkm1vlIDzOwPL
LI3nSMP5LCJTn9X/koPzr59u/dDCrwjnh1Ynmc06rATn53C/VjoXpQLny68+
No3tlSqcX73DOZh/tjqcX6Z/g0U5VQPOL1iWs81MXxPOf/Lx6eqvqQh+uG38
wi1zEHyBx9IyIjsQ/FMdN6YVX0bwl982C1F+iOC36E0VvPwOwf8U7vJh1VcE
3+/gac2Knwg+AKqpXOc=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBmIQvcnO5Fo7m5YDAxTYXQnsMeJC8Nf8ZcjmEkTwpdU3
eD4SR/B/VPKxT1JF8DfJn2786IDgq2a7lG8oR/B5mMyT9J4i+DvLmYOfvUbw
096ed573CcE/cCNDlY9BG84vXj/rxVspBP9WzL+8tQEI/ortR6t19iD4rrkh
U7Um68D5Ejtl811V9OD8SUUdEw2u68P5QW3+unO3GcD5WtEtoUtqDeH8a884
F00ONYLzzyU9dRSSN4bzH7Is/zFVCcH/sixjvaQagi/5+rWMoi6Cn1L86bu+
NYL/q/n/Wt9wBF9tqaRUZz+Cb+l++wLPZATf5+Wc9gnTEPxCXYWv0+ci+Hu2
ql1YthrBDzpm3HbkOIKfmvHVxuM0gl/Btf3z6XMI/lw/q8TLVxH8F9ccbB49
RnJvBdPn1OcIPq/0kZUvXyH4RvHu4h8/IviujJznSr4i+BGLT7X8+IHgZ7n2
WNf8QfBrn/t++v8fwQcAfeeWBQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$43591#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-20, 20}, {0., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.906691672228509*^9, 3.9066917173377295`*^9}, 
   3.906691826444401*^9},ExpressionUUID->"508e113f-baf6-4e9a-a85c-\
caf2ff0ac1f3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"P2", "[", "T_", "]"}], ":=", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"Reverse", "/@", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
            RowBox[{"T", "<=", 
             RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "15"}], "<", "T", "<=", 
            RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "12"}], "<", "T", "<=", 
            RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "8"}], "<", "T", "<=", 
            RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"T", ">", "13"}], ",", "0"}], "}"}], ",", "2"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"P2", "[", "T", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.906691943233055*^9, 
  3.906692027480878*^9}},ExpressionUUID->"c9fa5922-6fc0-4229-86f2-\
9652fd0bcd49"],

Cell[BoxData["Piecewise"], "Input",
 CellChangeTimes->{{3.9066918519026318`*^9, 
  3.906691853769823*^9}},ExpressionUUID->"1aaac348-c292-45f6-a0e1-\
57072463167d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "P", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"20", "/;", 
    RowBox[{"T", "<=", 
     RowBox[{"-", "15"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"15", "/;", 
    RowBox[{
     RowBox[{"-", "15"}], "<", "T", "<=", 
     RowBox[{"-", "12"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"12", "/;", 
    RowBox[{
     RowBox[{"-", "12"}], "<", "T", "<=", 
     RowBox[{"-", "8"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"9", "/;", 
    RowBox[{
     RowBox[{"-", "8"}], "<", "T", "<=", 
     RowBox[{"-", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"5", "/;", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "T", "<=", 
     RowBox[{"+", "5"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"3", "/;", 
    RowBox[{"5", "<", "T", "<=", "13"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{"13", "<", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"P", "[", "T", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"P", "[", "T", "]"}], "-", 
      RowBox[{"P1", "[", "T", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", 
       RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodinoveEnergie", "=", 
   RowBox[{"P", "/@", "teploty"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"celkem", "=", 
    RowBox[{"Total", "[", "hodinoveEnergie", "]"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<celkem spotreba= \>\"", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"celkem", "*", "3600"}], 
     SuperscriptBox["10", "6"]], "//", "N"}], ",", "\"\< GJ\>\""}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906691394200259*^9, 3.9066914399291887`*^9}, {
  3.906691482545882*^9, 3.906691646544938*^9}, {3.9066917546573596`*^9, 
  3.906691760922557*^9}, {3.9066918325194955`*^9, 3.9066918438006773`*^9}, {
  3.9066921819894533`*^9, 3.9066922930116596`*^9}, {3.9066923754124737`*^9, 
  3.9066923757891235`*^9}},ExpressionUUID->"df01f70b-9a45-4cf1-8631-\
21fabca340aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"celkem spotreba= \"\>", "\[InvisibleSpace]", "74.5632`", 
   "\[InvisibleSpace]", "\<\" GJ\"\>"}],
  SequenceForm["celkem spotreba= ", 74.5632, " GJ"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9066922698331976`*^9, 3.9066922934889364`*^9}, 
   3.9066923768243484`*^9},ExpressionUUID->"b9d87df4-7197-4295-8453-\
bb946ef3ff86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "teploty", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dvojice", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "-", "1"}], ")"}], "*", "3600"}], ",", 
       RowBox[{"teploty", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teplota", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"dvojice", ",", 
     RowBox[{"InterpolationOrder", "->", "0"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"teplota", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"energie", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"teplota", "[", "t", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9066924565337133`*^9, 3.906692568285914*^9}, {
  3.906692609581072*^9, 3.9066926304392014`*^9}, {3.9066926828143516`*^9, 
  3.9066927901841197`*^9}, {3.9066930943348885`*^9, 
  3.906693098563115*^9}},ExpressionUUID->"d64fa0a7-82a8-4698-94c3-\
0fda502ad916"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 390, 4, 30047219477750647461,
    "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906692790904142*^9, 
  3.906693099647092*^9},ExpressionUUID->"812cd6e6-bc73-44f5-9a63-\
0f1246b07aab"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "ncvb", 
   "\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) recursive bisections in \
\\!\\(\\*RowBox[{\\\"t\\\"}]\\) near \\!\\(\\*RowBox[{\\\"{\\\", \\\"t\\\", \
\\\"}\\\"}]\\) = \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.850248216024077`*^6\\\", \
\\\"}\\\"}]\\). NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"7.230282013017038`*^7\\\"}]\\) and \
\\!\\(\\*RowBox[{\\\"2.6637987089154874`*^6\\\"}]\\) for the integral and \
error estimates.\"", 2, 390, 5, 30047219477750647461, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906692790904142*^9, 
  3.906693099662716*^9},ExpressionUUID->"b584ddcc-8e24-4fbe-8073-\
07ce84557421"],

Cell[BoxData["7.230282013017038`*^7"], "Output",
 CellChangeTimes->{
  3.9066924588299856`*^9, 3.906692491047865*^9, 3.906692568835784*^9, 
   3.906692631066777*^9, {3.906692693726636*^9, 3.906692735184021*^9}, 
   3.9066927909982634`*^9, 
   3.906693099678345*^9},ExpressionUUID->"b034aff7-23f1-4efe-9779-\
9c585497009f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"P", "[", 
          RowBox[{"teplota", "[", "t", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"e", "[", "tmin", "]"}], "==", "0"}]}], "}"}], ",", "e", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tmin", ",", " ", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "->", "10"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<celkem spotreba= \>\"", ",", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"e", "[", "tmax", "]"}], "/.", "sol"}], 
      SuperscriptBox["10", "6"]], "//", "N"}], ",", "\"\< GJ\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9066929623220377`*^9, 
  3.906693064415374*^9}},ExpressionUUID->"8e257bea-3040-460f-b860-\
d9e376f30633"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"celkem spotreba= \"\>", "\[InvisibleSpace]", 
   "74.55238264059874`", "\[InvisibleSpace]", "\<\" GJ\"\>"}],
  SequenceForm["celkem spotreba= ", 74.55238264059874, " GJ"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066930434523153`*^9, 3.906693083564986*^9, 
  3.906693120614758*^9},ExpressionUUID->"ddd0709f-ef26-4df2-be3a-\
37c4a3198665"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8955645391300936`*^9, 3.895564540719207*^9}, 
   3.906084146592049*^9, 3.9060844348922677`*^9, {3.9060845538319035`*^9, 
   3.906084564716062*^9}, 
   3.906689667589672*^9},ExpressionUUID->"380da6cb-4304-4ddc-8c80-\
d4d1ee7974d9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mereni", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<DataStatistika.xls\>\"", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", ";;", ",", "1"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mean", "=", 
   RowBox[{"Mean", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"var", "=", 
   RowBox[{"Variance", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sd", "=", 
   RowBox[{"StandardDeviation", "[", "mereni", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "mereni", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{"Total", "[", "mereni", "]"}], "n"], "-", 
  "mean"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906689682623513*^9, 3.9066898067879105`*^9}, {
  3.906689871323526*^9, 3.906689878839707*^9}, {3.9066904003846645`*^9, 
  3.906690438002571*^9}, {3.9066931834805717`*^9, 3.906693365258732*^9}, {
  3.906693413410345*^9, 
  3.906693477073718*^9}},ExpressionUUID->"52af7075-f1e2-40d2-aa66-\
9c7f8914e277"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.9066934669498587`*^9, 
  3.9066934724703765`*^9}},ExpressionUUID->"8b708043-bcb2-4e6d-8744-\
bcf47dac51e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["var"], "Input",
 CellChangeTimes->{{3.9066935579155235`*^9, 
  3.9066935582290916`*^9}},ExpressionUUID->"d0aefc0f-5795-4c21-9a5f-\
a0c75f2d1a6b"],

Cell[BoxData["212.21462996995172`"], "Output",
 CellChangeTimes->{
  3.90669355870059*^9},ExpressionUUID->"fee1ed13-9bc0-417b-b9d4-b8d7df9b08b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"Total", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"mereni", "-", "mean"}], ")"}], "2"], "]"}], 
  StyleBox[
   RowBox[{"n", "-", "1"}],
   FontColor->RGBColor[1, 0, 0]]]], "Input",
 CellChangeTimes->{{3.9066935007072926`*^9, 3.9066935503463783`*^9}, {
  3.9066935935633316`*^9, 
  3.906693593939483*^9}},ExpressionUUID->"656c6763-c400-4248-a7a9-\
7208a05e17d0"],

Cell[BoxData["212.2146299699517`"], "Output",
 CellChangeTimes->{{3.906693504941555*^9, 3.906693550895708*^9}, 
   3.9066935943949833`*^9},ExpressionUUID->"26386c0a-af91-4196-8276-\
286ef8a80a44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 SqrtBox[
  FractionBox[
   RowBox[{"Total", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"mereni", "-", "mean"}], ")"}], "2"], "]"}], 
   RowBox[{"n", "-", "1"}]]], "\[IndentingNewLine]", "sd"}], "Input",
 CellChangeTimes->{{3.906693652988057*^9, 
  3.906693660345026*^9}},ExpressionUUID->"97a94c4b-a0de-4382-b8f0-\
35eac1e7a4df"],

Cell[BoxData["14.567588337468617`"], "Output",
 CellChangeTimes->{{3.9066936535677924`*^9, 
  3.906693660724206*^9}},ExpressionUUID->"99947fb3-62da-4e38-9c0a-\
2496f3842036"],

Cell[BoxData["14.567588337468619`"], "Output",
 CellChangeTimes->{{3.9066936535677924`*^9, 
  3.906693660724206*^9}},ExpressionUUID->"e5c4d922-82fe-4625-960a-\
63c283c320d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", "*", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<z= \>\"", ",", 
   RowBox[{"TraditionalForm", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "*", 
     SuperscriptBox["E", 
      RowBox[{"I", "*", 
       RowBox[{"Arg", "[", "z", "]"}]}]]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<z= \>\"", ",", 
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], "*", 
    SuperscriptBox["E", 
     RowBox[{"I", "*", 
      RowBox[{"Arg", "[", "z", "]"}]}]]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.906693756096627*^9, 
  3.9066938563819313`*^9}},ExpressionUUID->"634016ce-821e-4bfb-b03c-\
fbfdf6894d3d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z= \"\>", "\[InvisibleSpace]", 
   TagBox[
    FormBox[
     RowBox[{
      SqrtBox["5"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{
         SuperscriptBox["tan", 
          RowBox[{"-", "1"}]], "(", "2", ")"}]}]]}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}],
  SequenceForm["z= ", 
   TraditionalForm[5^Rational[1, 2] E^(Complex[0, 1] ArcTan[2])]],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066938239498634`*^9, 
  3.9066938568522873`*^9},ExpressionUUID->"4e4bbd41-3ad9-41cb-98fc-\
2e20d985db8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z= \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SqrtBox["5"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"ArcTan", "[", "2", "]"}]}]]}]}],
  SequenceForm["z= ", 5^Rational[1, 2] E^(Complex[0, 1] ArcTan[2])],
  Editable->False]], "Print",
 CellChangeTimes->{3.9066938239498634`*^9, 
  3.9066938568522873`*^9},ExpressionUUID->"96eef058-2645-4e24-bff9-\
fc61810f9db9"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "8.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "1."}], "}"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.", ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", "8.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "9.2"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9072910247853727`*^9, 
  3.907291075725439*^9}},ExpressionUUID->"d26be33c-614f-4aac-801d-\
6c33de94933f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}]], "Input",Express\
ionUUID->"fab3f9ee-43d1-45df-9e79-79592627d199"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"1", "+", "I"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"1", "-", 
    RowBox[{"3", "I"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.907293416977784*^9, 
  3.907293460184684*^9}},ExpressionUUID->"cd405113-7300-437e-b038-\
a32afb4d16a8"],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"A", "*", "B"}], 
  RowBox[{"A", "+", "B"}]]], "Input",
 CellChangeTimes->{{3.90729346772853*^9, 3.9072934923980036`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"cd116a19-b7c8-4cb3-a440-1125a994f839"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "+", 
  FractionBox["\[ImaginaryI]", "2"]}]], "Output",
 CellChangeTimes->{{3.9072934541528983`*^9, 3.907293458043646*^9}, 
   3.9072934970661154`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"d82dcde8-93e2-4f77-a308-3ef23c11804c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["I", "I"], "//", "ComplexExpand"}]], "Input",
 CellChangeTimes->{{3.9072935217792735`*^9, 3.9072935308498974`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"fca69241-6a48-46ab-8809-f029397ca726"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "\[Pi]"}], "/", "2"}]]], "Output",
 CellChangeTimes->{3.907293531495905*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"d2868a6e-15e2-4b83-b9bb-da685bf5fe79"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lhs", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rhs", "=", 
   RowBox[{"1", "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"0.5", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"lhs", ",", "rhs"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"lhs", "==", "rhs"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9072936091787767`*^9, 3.9072936894124155`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"23b769ae-20ab-4b92-ad75-7919d3307acc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vect", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b1", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rce", "=", 
  RowBox[{
   RowBox[{"vect", "==", 
    RowBox[{
     RowBox[{"\[Lambda]1", "*", "b1"}], "+", 
     RowBox[{"\[Lambda]2", "*", "b2"}], "+", 
     RowBox[{"\[Lambda]3", "*", "b3"}]}]}], "//", 
   "Thread"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "rce", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.907293706544763*^9, 3.907293823758857*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"dd01a7e4-287e-48a2-9bf3-478b8e910063"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Equal]", 
    RowBox[{"2", " ", "\[Lambda]2"}]}], ",", 
   RowBox[{"2", "\[Equal]", 
    FractionBox["\[Lambda]1", "2"]}], ",", 
   RowBox[{"3", "\[Equal]", "\[Lambda]3"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9072937905913534`*^9, 3.907293824135208*^9}},
 CellLabel->"Out[53]=",ExpressionUUID->"1cbb7752-1749-4359-9d8f-dc8e84b2244a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]1", "\[Rule]", "4"}], ",", 
    RowBox[{"\[Lambda]2", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"\[Lambda]3", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9072937905913534`*^9, 3.907293824135208*^9}},
 CellLabel->"Out[54]=",ExpressionUUID->"97d0a2a9-5059-4717-8605-fc24ed9a2b38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.9072938938930235`*^9, 3.9072939190815086`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"8092c786-10b5-4d72-9544-07c5b6825298"],

Cell[BoxData["0.6593299064355118`"], "Output",
 CellChangeTimes->{{3.907293912478136*^9, 3.9072939196930327`*^9}},
 CellLabel->"Out[58]=",ExpressionUUID->"259b06f4-508b-4970-a46e-eadce7a1795d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "\[Tau]_", "]"}], "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "\[Tau]"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "\[Tau]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", "\[Tau]", "]"}], "\[Tau]"], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.9072939524168196`*^9, 3.907294041428464*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"5a0fbd76-41b3-4f71-ad53-866b9d695534"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVjXs0lAkAxcdE4SitjUitTBJKFCaP6jJJZVPSg5yaZUqPXYekh6O1sZJX
0pbaNo+2KGGZ7aHX0Wx0aiLJ1FqSD5N5fsQMYzDDfDv9cc/953d/154THxZD
p9FoIfp8bc8jyUY0mgJrttbl7vhCosxgrDjAQIG0vGWtFwdIzLmUyEynK7Bv
MttY0E9ipDb24HQjBXb4me8MIUnc07IbzUwVKOjftXe9lIR75ro8mzkKnLuV
tNRDSGJpiZmlh5MC9i6qBqM2EozmEocDoQpcj9g3PbOOxBvTlIz8cv2/IeNP
/lkSE+Yi3+FxBRzTWwIE20l8Kz6/tm6jEob1RXGL7EnIikbSN11XAg9CZ0fJ
5WDZChfMVigRf9FoWuEDOcJ/zpr4Y8MwPsnsjpcmy7G7OnFRbvEwdutmHVD5
y9FbJr1R+2UY4YIaZpKpHIzTlpzSwBGcoBs+qmiRQW7XfKLp8gherHcpc74i
Q9GFVx8jxCPImhh2c2bLYCpK/qXSTwVB8lra04UyTE09Oul1TgXzqGD3RokU
VZqae+l9KkiuxhSGlUsRxJf7+fiMoiSf95p9SIqYyGobp+xRuDaYOFi7SuHf
6uLT2TMKp5oNOR4DElw3W1H90l2NVU+Mns3hSvB0qZJzLEuNXYP3XwbGSlA/
b/RATrcaydlcNxsXCUJa0/75uHwMBcbxt7r7xSg49Hr3QMYYam+YPOwpFyOK
//tG7/YxKAvUZbKDYlirKzP6HccxM5dz84WTGLkzkgw5KeMw3Ovo19QnQnrP
2/ZvWsYRluop1d0UYdU1YuDM4gnUX/HdFLZHhHaHFaE/nJoAS0lpTluJMHl8
pnHimwnsD+1fRmvrQ1dFqUEwQwNhEE9wKa8PAWUNWyMTNQjmMTflBffhYtzi
AUGDBjbWXbxM4z6U2LKazGy0ONsri8t7/hlu+dLJ1MNadKbQmdYpn3FKHJTw
+LkWvJyIqnKPz9hMd/N1tpiERQXr2NtBIUyHIrcZcCZhV/1s3awqIdJ5/pVF
jydhEjN0MjRaiLQd3PAEkyk0rN1sFThfCN+37UEm0VMo/NT5G1PQix7LwDPG
j6bgIdaJQzN7YbLYxypghg7TE4lDXqxeDFrJ5KvZOhRH21Kegz2IeGdncZSr
w3/0MWZNdA+44YVZsygdjnZkX/irvRv1Da3+cTspiN2b3z0I6EaE6nzIjNsU
rm57732plsCrFpZ7fDmFOIYrw/4+Ac8KtUX7HQqdl48ac/8mYM5md9yuorBE
yX/TVKXn+a77gu5+3Utc6TcJeBU2J2XUUWiM9eccOU/AgmVaNu0DhWvN3cXB
Bwmkzued/elfCrSmCueO/QQG1QmHP7RRqOffvxfDIdBY9XF5aQcFxZb8utS9
et6y4gmrm8L3O2u4D7cTGJJteJcmp/AypdOS4U9gzwvtXTlJYbBWcIK7hkBT
Mbdg2wCFT1Yr21b7EbgdNjfSfohCSpd3TjiTALtOInqu0vu877SdW0ag+co1
vpOagnXSSsY8FwK+CVsqL4xRcBrxjS1fQsDS8WF8lIaCdpFgvJ5B4Ffaj2Gv
tRQcvtvvt3UhAUXnAi/3KQrsrtOnuhbo/bWCuVd1FN7Tljw5bKv352doKIrC
Ddc9KrU1gf8BkkeAwQ==
         "]]},
       Annotation[#, "Charting`Private`Tag$12524#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.0000000000000022`, 0.45464872229851067`},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{1, 2}, {0.45464872229850967`, 0.8414709786615969}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVjWs0lAkAhsdEDUcqG5FamSSUKEwu1csklU2hCzmZZUqXXYeki6NVShKS
ttRWLl0oYZntQpej2ejURJKptS75MJk7McMYDObb2R/vef4853lt2HEh0VQK
hRKo2/90O5xkQKEosHZbTdaO73IU640W+OopcDZ7efOVfjnmXk1gpFIV2DuZ
QeP3yTFcFXNguoECO7xn7QyUy/F4glVvbKRAbt+uiA0SOVzS12dbzlUg+37i
MleBHMsKjc1c7RVY5KiqM2iRg95YaLs/SIE7YXunp9fI8cEoOS2nRPevT7/D
Oy/H+Cyh19CYAnapTb787XL8ILq0rmaTEvq1+bGLbeSQ5g+nbr6tBJ4GzY6U
ycC0EiycrVAi7orBtLynMoT+dmH85sYhfJVaHytKkmF3RcLirIIh7Naa7Ff5
yNBTLLlb9X0IofxKRqKRDPTTZuwiv2Ecp+o/K22SQmbdeLzh2jDebHAsdrgu
Rf7ld+1homGkjw85O7CkMBImnSrzVuFz0jrKy0VSTE09O+F+UQWTyACXerEE
5ZrKx6m9KohvROeFlEjgz5N5e3qOoDCH+551UILo8ApL+4wRONUZ2lo4SeDT
7OjZ0T0C+8qNma79Ytw2Xlnx1kWN1S8MXs3liPFymZJ99IIauwaevPWLEaN2
/sj+zC41kjI4zpaOYgQ2n/m7fcUocmlx97v6RMg9+H53f9ooqu8aVneXiBDJ
+2OTR+solLnqYukBESzUZWl9dmOYmcW+98ZehKwZifrs5DHoR9h5N/QKkdr9
sXVO0xhCUtwk2ntCrL5F9J9bMo7a616bQ/YI0Wq7Mujnk+NgKknNaXMhJo/N
pCV8GMe+oL7llJZedJYW6QXQNRD4c/lXs3vhW1y3LTxBgwAuY3N2QC+uxC7p
59dpYGnRyU2n9aLQitlgbDmB8z3S2OzX3+CcI5lMOTSB9mQqwyL5G06K/OOf
v54ANzOsvMT1G7ZQnb0cTCcxp5R59OOAAEaD4cF67ElYV7xab1IuQCrXpyz/
+SRo0YMngqIEOLODExpvOIW6dVvM/RYI4PWx1d8wagp5Xzt+Z/B70G3md472
bAquIq0oKL0Hhks8zX1naGGQQBx0Z/ZgwFwqW8PSIj/KinQb6EbYJ2vTIxwt
/qWOMiqjusEJzbtgQmoR35Zx+c/WLtTWNfvE7iQhdGn89NS3C2GqS4EzHpC4
GfzZ42oVgXdNTJe4EhKxdCe6zRMCbqVq09aHJNqvHaFx/iIwi8Vqe1BOYqmS
96GhXOfznPb6PyJxI1jsRL1HwD2vMTGthkR9jA/78CUCpkyj4mlfSNxq7CoI
OEAgZQH3/K//kNBrKHVo20dgQB1/6EsLiVrek8fRbAL15e0ritpIKLbm1KRE
6Hyz0hfMLhI/7azkVG8nMCjd+OmMjMS75A4zug+BPW8mHsnkJAaq+Mc5awk0
FHByg/tJfDVf1bLGm8CDkHnhNoMkTnV6ZIYyCLBqxMLXKl3P42HLxeUEGq/f
4tmrSVgkrqLPdyTgFb+17PIoCfthr5iSpQTM7KrjIjUkNIv5Y7V0Amcpv4S8
nyBh++M+722LCCg6Frq7TJGI6Dx9snOhrl/Fn3dDS4JPWfrikJWun5OmIUkS
d532qNQWBP4Dj++AvA==
         "]]},
       Annotation[#, "Charting`Private`Tag$12577#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.0000000000000022`, 0.45464872229851067`},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{1, 2}, {0.45464872229850967`, 0.8414709786615969}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.907293985749034*^9, 3.907293990492557*^9}, 
   3.9072940421340156`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"c70b6bd0-d550-4ce9-9568-4e394f79ea1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "t", "]"}]}], "+", 
     RowBox[{"c", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"y", "[", "t", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"poly", "=", 
  RowBox[{"rce", "/.", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       StyleBox[
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "n_", "]"}], "[", "y", "]"}], "[", "t", 
         "]"}],
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True], "\[RuleDelayed]", 
       SuperscriptBox["\[Lambda]", "n"]}],
      FullForm], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], ":>", "1"}]}], 
    "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"poly", ",", "\[Lambda]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Re", "[", "\[Lambda]", "]"}], "/.", "sol"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9072941374578505`*^9, 3.907294259449176*^9}, {
  3.907294312265793*^9, 3.907294345721772*^9}, {3.9072944633244877`*^9, 
  3.9072944645482197`*^9}, {3.907294531022818*^9, 3.907294563789874*^9}, {
  3.9072946013527603`*^9, 3.9072946575588164`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"7eb6b492-7a99-4e66-bae5-c3b616e46720"],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", "+", 
   RowBox[{"c", " ", "\[Lambda]"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Lambda]", "2"]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.9072942602565527`*^9, 3.907294315217258*^9, 3.90729434638143*^9, 
   3.907294465817686*^9, 3.90729456441813*^9, {3.907294601855136*^9, 
   3.907294658144954*^9}},
 CellLabel->
  "Out[111]=",ExpressionUUID->"fb109c64-14de-4851-8fd0-aa17265bbc69"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "40"}], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "c"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "40"}], "+", 
          SuperscriptBox["c", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9072942602565527`*^9, 3.907294315217258*^9, 3.90729434638143*^9, 
   3.907294465817686*^9, 3.90729456441813*^9, {3.907294601855136*^9, 
   3.907294658144954*^9}},
 CellLabel->
  "Out[112]=",ExpressionUUID->"82175e5e-fd9b-4616-bc1a-a3a608f45412"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVjWs8lIkegEcRSqwo3nfu84ZQ2NJByr/YJVsrTVQqpHVp28noejqcDW0r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       "]], LineBox[CompressedData["
1:eJwt1P9P1VUcx/EbSIAUhHD5nM+kQFitHAbDpIHY+xQx50pFCSpmWHTBBk4M
2h11k6I0i5rVBjm/bUANIbYi5pqj5vs0XCbo9eYXyuxSSBLBIrhe7ud8NEa1
Vz889/gPnssqajdXhjkcjg3/9p9tyZ0uX6GpoE119TXN66SpoE2VI9usxlxT
QZueWudyHcs2FbRpTcozD6XcbSpoU1bz0z1P3GUqaFPaXIloNkwFbYoa2hAI
RpsK2nTRLTsHp4WCmk6N5ic4JoSCmvofz3191ahQUFNbWnZZ2wWhoKYab3qs
+7hQUFPYPZHuZW8IBTXNfRA+VuoRCmqauLmw8b2XhIKavN/r+6wqoaCmA7sm
/WceEwpqyrp0trDBKRTUVL67xXmuy1DQIi+FIhs6DAUtoptP3kg9bChoUWrd
0l/q3jcUtOjq1o6uJLehoEVVq3tXlxcYClq0IzD03J/+JAVD1Phs+GcxCUkK
hsixIoUL9iQqGKSf3j2wt+fSEgUDlLz4he7gI/EKzlLNquURV5LjFPyLnn9w
pGtgIEbBKVrekLew45MoBSeo3V988uWHIxS8Rr83OfPXijAFr1J/672FE6Xz
DP2U9cflYOaREMNherT/SvR86QxDH+3s/lzHJ4wxHKDSqvT286+eZthNp85c
bl5Z/N3/dnHeim/6ivaPERzgMLfzZ5c5Q9DHkbcVNVVMhwgO85u/DhfUfTxP
0M+9h94qagzcIuEo13a47vitNELCa1xeffDOvU1REk7wO5vcuSsPx0g4xYsS
W8dfuxEr4TT/MLRnZndcvISzXOKpyDk4sETCAG+PmUrzliVKGOSUnm8/unXS
KeEce44XFMcdMiS0OHuLb2ZruyGhxZMLW/b1HjUktLhsrfv0pmOGhBbnDXdR
y1lDQov19dszTIeQULM788dF6ZVCQs33X3B11NcICTWPu2fp5ItCQs0lJxZ7
KhuFhJofWL9m9uh+IaHm69Ud/oxBIaHmT2MzPbt8QkLNFX1fCe+wkFDzefti
ce2YkFBz39uRg1/8LSTUXJ3Rsi0s3JTQ5jRfakRxtCmhzR8aeTLoNCW0eWfn
9i9zMk0JbR45t7Q1NseU0Ob19mD9eL4poc1fp72y+USBKaHN7fiZhDb/A2C6
ado=
       "]], LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAABZoOEeBSGUDZDRlaynX6vwefh+5F
WBlAFdVX94bh+r92yDbNHV8ZQNpcpB6STPu/5PHlq/VlGUDoFgMCiab7v1Ib
lYrNbBlAuWaBmQP2+7/BRERppXMZQAcKl082Pvy/npeiJlWBGUDMs3HZer/8
vwzBUQUtiBlAE4nij4j6/L966gDkBI8ZQBfF6Ue3Mv2/Vz1fobScGUAxK/Qa
G5z9v8ZmDoCMoxlAKYlsz+nN/b80kL1eZKoZQCB/ywgZ/v2/EOMbHBS4GUDm
ltMlRVr+v8qI2JZz0xlAcCOyJDUF/78+1FGMMgoaQNfB2pLmGgDArP0AawoR
GkA3llfHoywAwBsnsEniFxpAZw6ahCQ+AMD4eQ4HkiUaQFZnYKF8YADAsh/L
gfFAGkBix70dz6IAwCVrRHewdxpA70YMqbMfAcAMAjdiLuUaQI+WW501AwLA
uXcDU+brGkDw/1eHbRACwGbtz0Oe8hpAuwbZ7pIdAsDA2GglDgAbQGD2YAKo
NwLAc6+a6O0aG0DkezTdBmsCwNpc/m6tUBtAcf9naujOAsCot8V7LLwbQMGw
lm8zjQPARW1UlSqTHEAgym1+N+4EwBi5HW9FJB5A6u83T59DB8CScoiRMNcf
QBwy+CNplgnAUoZPLZ22IEDgtmTlLaMLwCpbhFWkfSFAdl9MuCKSDcDW5gmi
k1UiQCxpqGI1mw/AzmLlQRIfI0BW3SFJBLsQwOEEp/iVIiNAXTMe1x2/EMD0
pmivGSYjQDcDpA83wxDAGevrHCEtI0DSNJmBaMsQwGRz8vcvOyNAcskrcsfb
EMD6g/+tTVcjQE4Yg8x1/BDAJqUZGomPI0D2B7mDlj0RwDlH29AMkyNAZPvd
+6VBEcBM6ZyHkJYjQLgBISi1RRHAcS0g9ZedI0B04Bie0k0RwLy1JtCmqyNA
fXtgBwpeEcBSxjOGxMcjQBaVpQprfhHAZWj1PEjLI0Dq7a/kdYIRwHgKt/PL
ziNA7C4Nd4CGEcCdTjph09UjQMKKwcWUjhHA6NZAPOLjI0BsJwcSup4RwPp4
AvNl5yNA7pigtcKiEcANG8Sp6eojQDq5hhPLphHAMl9HF/HxI0BT0y//2q4R
wEUBCc509SNAp2ttjeKyEcBYo8qE+PgjQOfw7NbpthHAakWMO3z8I0C07Orb
8LoRwH3nTfL//yNAoZqjnPe+EcC+G6Gq
       "]]},
     Annotation[#, "Charting`Private`Tag$19533#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAfedN8v//I8ChmqOc974RQOZ7FvXb
/CPAYZPPiV67EUBOEN/3t/kjwIx+fEDFtxFAIDlw/W/zI8AfMq0JkrARQMKK
kgjg5iPAfUarBimiEUAILtcewM0jwJ+FfIRMhRFAlHRgS4CbI8B6iKdPaEsR
QKsBc6QANyPApiiSaejWEEAFZUcyGV0iwJS0ugodrQ9AE9jFbKKRIcBMUVtb
AcMNQFLDmmMpyiDAeGnwHYvUC0B77z1skOMfwHwxiiXGpglAuHeaaq9PHsC2
guie/oAHQE6SVSD+mRzAT/cDVvX4BEB6Mg9JR5McwLZehbVk7gRAptLIcZCM
HMBWELLuzeMEQP4SPMMifxzA0ImcnI3OBECtkyJmR2QcwHz3eZS/owRADJXv
q5AuHMDcsCPU2UwEQMqXiTcjwxvAwG4zPyiZA0D2N0NgbLwbwMjc0FChjQNA
Itj8iLW1G8AdOCySEIIDQHoYcNpHqBvAyhvy9tBqA0ApmVZ9bI0bwBJwyEbU
OwNAiJojw7VXG8B4DS9IuNsCQEedvU5I7BrA/u3Ivi0RAkDwjdz8BOYawK0u
wN3cBAJAmn77qsHfGsAHUlOLe/gBQOxfOQc70xrA0Ft5+IXfAUCSIrW/Lboa
wAtWRvbCrAFA3qesMBOIGsAIr15ea0MBQIiYy97PgRrAw4iXCdk1AUAxieqM
jHsawCDjM2AtKAFAhGoo6QVvGsAVT6nJhgwBQCotpKH4VRrAcqTKCePTAEB2
spsS3iMawONmj2lCXABAIKO6wJodGsDEtOX/mUwAQMmT2W5XFxrA9Z/egMM8
AEAcdRfL0AoawLoV6FiDHABAwjeTg8PxGcAJtyrL2bL/P2wosjGA6xnAe24h
WhaQ/z8VGdHfPOUZwINFliHHbP8/aPoOPLbYGcDtsd4+YST/Pw69ivSovxnA
qbqQQDyL/j+4ramiZbkZwIaWLJbiYv4/YZ7IUCKzGcCdlcHqkDn+P7R/Bq2b
phnA+hQmxKTj/T9ecCVbWKAZwAZMqFHPtv0/B2FECRWaGcBAMaWziYj9P1pC
gmWOjRnAYL5Id+wm/T8EM6ETS4cZwKenaMYW8/w/rSPAwQeBGcAaT6ney7z8
P1YU32/EehnA/W0bE5eD/D8ABf4dgXQZwKSmi6XaRvw/qvUczD1uGcCGWRIp
uAX8P1PmO3r6ZxnA1JJQ6OO++z/81loot2EZwIwdw7NGcPs/psd51nNbGcBE
i6xrExb7P5kydkOpVBnAcpOi4vmc+j8Emg4R4FIZwLwNGVrKdfo/+NzJyA==

       "]], LineBox[CompressedData["
1:eJwt1P9P1VUcx/EbSIAUhHD5nM+kQFitHAbDpIHY+xQx50pFCSpmWHTBBk4M
2h11k6I0i5rVBjm/bUANIbYi5pqj5vs0XCbo9eYXyuxSSBLBIrhe7ud8NEa1
Vz889/gPnssqajdXhjkcjg3/9p9tyZ0uX6GpoE119TXN66SpoE2VI9usxlxT
QZueWudyHcs2FbRpTcozD6XcbSpoU1bz0z1P3GUqaFPaXIloNkwFbYoa2hAI
RpsK2nTRLTsHp4WCmk6N5ic4JoSCmvofz3191ahQUFNbWnZZ2wWhoKYab3qs
+7hQUFPYPZHuZW8IBTXNfRA+VuoRCmqauLmw8b2XhIKavN/r+6wqoaCmA7sm
/WceEwpqyrp0trDBKRTUVL67xXmuy1DQIi+FIhs6DAUtoptP3kg9bChoUWrd
0l/q3jcUtOjq1o6uJLehoEVVq3tXlxcYClq0IzD03J/+JAVD1Phs+GcxCUkK
hsixIoUL9iQqGKSf3j2wt+fSEgUDlLz4he7gI/EKzlLNquURV5LjFPyLnn9w
pGtgIEbBKVrekLew45MoBSeo3V988uWHIxS8Rr83OfPXijAFr1J/672FE6Xz
DP2U9cflYOaREMNherT/SvR86QxDH+3s/lzHJ4wxHKDSqvT286+eZthNp85c
bl5Z/N3/dnHeim/6ivaPERzgMLfzZ5c5Q9DHkbcVNVVMhwgO85u/DhfUfTxP
0M+9h94qagzcIuEo13a47vitNELCa1xeffDOvU1REk7wO5vcuSsPx0g4xYsS
W8dfuxEr4TT/MLRnZndcvISzXOKpyDk4sETCAG+PmUrzliVKGOSUnm8/unXS
KeEce44XFMcdMiS0OHuLb2ZruyGhxZMLW/b1HjUktLhsrfv0pmOGhBbnDXdR
y1lDQov19dszTIeQULM788dF6ZVCQs33X3B11NcICTWPu2fp5ItCQs0lJxZ7
KhuFhJofWL9m9uh+IaHm69Ud/oxBIaHmT2MzPbt8QkLNFX1fCe+wkFDzefti
ce2YkFBz39uRg1/8LSTUXJ3Rsi0s3JTQ5jRfakRxtCmhzR8aeTLoNCW0eWfn
9i9zMk0JbR45t7Q1NseU0Ob19mD9eL4poc1fp72y+USBKaHN7fiZhDb/A2C6
ado=
       "]], LineBox[CompressedData["
1:eJwVjmlYUwcahUPER8GwSHG59yYheAErsip1wYz9VBBrR6mpQZTNoiBKKiJU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       "]]},
     Annotation[#, "Charting`Private`Tag$19533#2"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {-4.436491439328763, 4.436491439328763}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9072942602565527`*^9, 3.907294315217258*^9, 3.90729434638143*^9, 
   3.907294465817686*^9, 3.90729456441813*^9, {3.907294601855136*^9, 
   3.907294658170207*^9}},
 CellLabel->
  "Out[113]=",ExpressionUUID->"570fe993-09b2-420f-a55d-7363bf328a07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fit", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"body", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x", ",", 
       SuperscriptBox["x", "2"], ",", 
       SuperscriptBox["x", "3"]}], "}"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"body", ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"fit", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "5"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<fit[x=2]= \>\"", ",", 
   RowBox[{"fit", "/.", 
    RowBox[{"x", "->", "2"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9072946984501066`*^9, 3.907294855824577*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"16596054-fad2-4d43-a966-a0f07667e8e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"fit[x=2]= \"\>", "\[InvisibleSpace]", "2.3809523809523836`"}],
  SequenceForm["fit[x=2]= ", 2.3809523809523836`],
  Editable->False]], "Print",
 CellChangeTimes->{3.9072948563266954`*^9},
 CellLabel->
  "During evaluation of \
In[128]:=",ExpressionUUID->"4458ee71-a47d-4b30-92e5-2d760f4134f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "8.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "1."}], "}"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.", ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", "8.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "9.2"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xb_", ",", "yb_"}], "}"}], ",", "d_"}], "}"}], "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"xb", "-", "x"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"yb", "-", "y"}], ")"}], "2"]}]], "-", "d"}], ")"}], "2"]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errCelk", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"err", "/@", "points"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{"errCelk", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.907295314749379*^9, 3.9072954236902266`*^9}, {
  3.9072957868887405`*^9, 3.9072957879460754`*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"02c9e994-6813-4745-b842-6a023cfff70f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0011042810789204955`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5.006438712264826`"}], ",", 
     RowBox[{"y", "\[Rule]", "5.035082744215957`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9072953883433704`*^9, 3.907295424050603*^9}, 
   3.9072957885590277`*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"a2d4b91d-53d2-49dc-a06c-af76e5f22cf9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"errCelk", "=", 
     RowBox[{"Total", "[", 
      RowBox[{"points", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xb_", ",", "yb_"}], "}"}], ",", "d_"}], "}"}], ":>", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SqrtBox[
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"xb", "-", "x"}], ")"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"yb", "-", "y"}], ")"}], "2"]}]], "-", "d"}], ")"}], 
         "2"]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{"NMinimize", "[", 
     RowBox[{"errCelk", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9072969037013664`*^9, 3.9072969539306164`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"f8162d51-1393-459b-aa5c-e218c2d0cdf5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0011042810789204955`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5.006438712264826`"}], ",", 
     RowBox[{"y", "\[Rule]", "5.035082744215957`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9072969548081603`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"09225fbe-ce6d-4535-9d2f-8ac5adb2de3f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"First", "/@", "points"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl2", ",", "pl1", ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.907295793316622*^9, 3.907295927192361*^9}, 
   3.907297044567538*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"ad4d7764-b13c-44a3-9ff0-0609ef6546df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv1", "=", 
   RowBox[{"1", "+", 
    RowBox[{"3", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv2", "=", 
   RowBox[{"0.5", "*", "zv1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", "314."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zz", "=", 
   FractionBox[
    RowBox[{"100", "*", "I", "*", "\[Omega]", "*", "0.5"}], 
    RowBox[{"100", "+", 
     RowBox[{"I", "*", "\[Omega]", "*", "0.5"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv2c", "=", 
   RowBox[{"zv2", "+", 
    FractionBox["1", 
     RowBox[{"I", "*", "\[Omega]", "*", "c"}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", "230"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"U", "-", "Uz"}], "zv1"], "==", 
     RowBox[{
      FractionBox["Uz", "zz"], "+", 
      FractionBox["Uz", "zv2c"]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{
     RowBox[{"Solve", "[", "rce", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i1", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"U", "-", "Uz"}], "zv1"], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i2", "=", 
   RowBox[{
    FractionBox["Uz", "zv2c"], "/.", "sol"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formin1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "zv1", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], "+", 
    RowBox[{
     RowBox[{"Re", "[", "zv2", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formin2", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"Uz", "/.", "sol"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.90729706395739*^9, {3.9072972104497614`*^9, 3.907297472173135*^9}},
 CellLabel->
  "In[265]:=",ExpressionUUID->"a535f2a9-7343-46ca-9594-7b866311e935"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{"formin1", ",", 
   RowBox[{"{", "c", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9072974766025457`*^9, 3.9072974855431533`*^9}},
 CellLabel->
  "In[278]:=",ExpressionUUID->"2bc708a5-0210-471a-b038-87faf11cb6ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.813499058580608`", ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0.000012656788546157476`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.907297486934495*^9},
 CellLabel->
  "Out[278]=",ExpressionUUID->"1333a73e-7e4f-402b-9133-a89c0c4c04e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{"formin2", ",", 
   RowBox[{"{", "c", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9072974965810366`*^9, 3.9072974997388816`*^9}},
 CellLabel->
  "In[279]:=",ExpressionUUID->"1ebc7cd4-a48f-4509-882f-15a1fd2ea1a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"480.06803122549815`", ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0.0006135287947512207`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9072975019871254`*^9},
 CellLabel->
  "Out[279]=",ExpressionUUID->"60fee6f0-4149-42d3-a31d-f11696d3f026"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv1", "=", 
   RowBox[{"1", "+", 
    RowBox[{"3", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv2", "=", 
   RowBox[{"0.5", "*", "zv1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", "314."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zz", "=", 
   FractionBox[
    RowBox[{"R", "*", "I", "*", "\[Omega]", "*", "L"}], 
    RowBox[{"R", "+", 
     RowBox[{"I", "*", "\[Omega]", "*", "L"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zv2c", "=", 
   RowBox[{"zv2", "+", 
    FractionBox["1", 
     RowBox[{"I", "*", "\[Omega]", "*", "c"}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", "230"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"U", "-", "Uz"}], "zv1"], "==", 
     RowBox[{
      FractionBox["Uz", "zz"], "+", 
      FractionBox["Uz", "zv2c"]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{
     RowBox[{"Solve", "[", "rce", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i1", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"U", "-", "Uz"}], "zv1"], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i2", "=", 
   RowBox[{
    FractionBox["Uz", "zv2c"], "/.", "sol"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formin", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "zv1", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], "+", 
    RowBox[{
     RowBox[{"Re", "[", "zv2", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formax", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"Uz", "/.", "sol"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.90729776154846*^9, 3.9072978140449753`*^9}},
 CellLabel->
  "In[295]:=",ExpressionUUID->"a8beef22-7c32-45f4-8fcc-ecab8a18d808"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{"formin", ",", 
   RowBox[{"{", "c", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.907297826874076*^9},
 CellLabel->
  "In[310]:=",ExpressionUUID->"4b6bfc91-7f04-4cd2-a9a1-3bc2d1217142"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.813499058580608`", ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0.000012656788546157476`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9072978572788506`*^9},
 CellLabel->
  "Out[310]=",ExpressionUUID->"f144ab23-b0d7-4419-ac0d-6c1b361ce3af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{"formax", ",", 
   RowBox[{"{", "c", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9072978415875735`*^9, 3.9072978538029814`*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"0ab88a55-ef06-467a-aad7-a7ac0bc95ed9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"480.06803122549815`", ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0.0006135287947512207`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.907297859675089*^9},
 CellLabel->
  "Out[311]=",ExpressionUUID->"fa960346-c7e4-437e-a81c-9a4560576d0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"formax", ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "4"}]], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]]}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<c[F]\>\"", ",", "\"\<Abs[Uz]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "->", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.907298091704234*^9, 3.9072981676656017`*^9}},
 CellLabel->
  "In[313]:=",ExpressionUUID->"f4add35e-04ef-4333-9ad1-2127e0a7fbb4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[0.006], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Hs01VkbB3BppMubcZufPbJ/jpM5ZYh4Kx3XnVtyndeb25s4JQ5HyJ1y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       "]], LineBox[CompressedData["
1:eJwV1Hk4VWsXAHAyax92x3Dek7Mrrqg0UKHUzZKQDJlSqZSpgYSSJEOEVKYQ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       "]]},
     Annotation[#, "Charting`Private`Tag$279003#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"c[F]\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"Abs[Uz]\"", HoldForm], TraditionalForm]},
  AxesOrigin->{-9.210340371976162, 3.5206195353551637`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 
      6}]& }, {{{-9.210340371976182, 
       Directive[]}, {-7.600902459542082, 
       Directive[]}, {-6.907755278982137, 
       Directive[]}, {-5.298317366548036, 
       Directive[]}, {-4.605170185988091, 
       Directive[]}, {-11.512925464970229`, 
       Directive[]}, {-10.819778284410283`, 
       Directive[]}, {-10.41431317630212, 
       Directive[]}, {-10.126631103850338`, 
       Directive[]}, {-9.903487552536127, 
       Directive[]}, {-9.721165995742174, 
       Directive[]}, {-9.567015315914915, 
       Directive[]}, {-9.433483923290392, 
       Directive[]}, {-9.315700887634009, 
       Directive[]}, {-8.517193191416238, 
       Directive[]}, {-8.111728083308073, 
       Directive[]}, {-7.824046010856292, 
       Directive[]}, {-7.418580902748128, 
       Directive[]}, {-7.264430222920869, 
       Directive[]}, {-7.1308988302963465`, 
       Directive[]}, {-7.013115794639964, 
       Directive[]}, {-6.214608098422191, 
       Directive[]}, {-5.809142990314028, 
       Directive[]}, {-5.521460917862246, 
       Directive[]}, {-5.115995809754082, 
       Directive[]}, {-4.961845129926823, 
       Directive[]}, {-4.8283137373023015`, 
       Directive[]}, {-4.710530701645918, 
       Directive[]}, {-3.912023005428146, 
       Directive[]}, {-3.506557897319982, 
       Directive[]}, {-3.2188758248682006`, 
       Directive[]}, {-2.995732273553991, 
       Directive[]}}, {{3.912023005428146, 
       Directive[]}, {4.605170185988092, 
       Directive[]}, {5.298317366548036, 
       Directive[]}, {6.214608098422191, 
       Directive[]}, {2.833213344056216, 
       Directive[]}, {2.8903717578961645`, 
       Directive[]}, {2.9444389791664403`, 
       Directive[]}, {2.995732273553991, 
       Directive[]}, {3.4011973816621555`, 
       Directive[]}, {3.6888794541139363`, 
       Directive[]}, {4.0943445622221, 
       Directive[]}, {4.248495242049359, 
       Directive[]}, {4.382026634673881, 
       Directive[]}, {4.499809670330265, 
       Directive[]}, {5.0106352940962555`, 
       Directive[]}, {5.703782474656201, 
       Directive[]}, {5.991464547107982, 
       Directive[]}, {6.396929655216146, 
       Directive[]}, {6.551080335043404, 
       Directive[]}, {6.684611727667927, 
       Directive[]}, {6.802394763324311, 
       Directive[]}, {6.907755278982137, 
       Directive[]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{214.99999999999983`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{-Log[10000], -Log[100]}, {3.5206195353551557`, 
     6.173927811197458}}, {{-9.210340371976184, -4.605170185988092}, {
    3.5206195353551557`, 6.173927811197458}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0]}, {{{-9.210340371976182, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "5.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.005\"", ShowStringCharacters -> False], 0.005, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.41431317630212, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.126631103850338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.721165995742174, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.567015315914915, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.433483923290392, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.315700887634009, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
      3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {5.298317366548036, 
       FormBox["200", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
       FormBox["500", TraditionalForm], {0.01, 0.}}, {2.833213344056216, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.8903717578961645`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.9444389791664403`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.0106352940962555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.907755278982137, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{3.9072981161019382`*^9, 3.907298168390055*^9},
 CellLabel->
  "Out[313]=",ExpressionUUID->"6782b573-7f39-4373-9f0a-28dd7795780d"]
}, Open  ]]
},
WindowSize->{1428, 825},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2. Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"9c2a9e9b-acfe-49fd-811d-7d092df23d84"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 538, 12, 133, "Input",ExpressionUUID->"60a4a78e-000b-4703-b419-1e934bcb9f30"],
Cell[1121, 36, 156, 2, 64, "Output",ExpressionUUID->"c6cfffa9-d0cb-46e3-9340-facfa9f2db94"]
}, Open  ]],
Cell[1292, 41, 156, 3, 56, "Input",ExpressionUUID->"be906b25-f752-4b17-a529-2551c3f02e03"],
Cell[CellGroupData[{
Cell[1473, 48, 1692, 43, 323, "Input",ExpressionUUID->"8a256d78-bb04-49ee-a95e-093a8c497241"],
Cell[3168, 93, 617, 12, 103, "Output",ExpressionUUID->"eba9d314-9454-45a1-937d-aa9ab2cd9357"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3822, 110, 633, 19, 133, "Input",ExpressionUUID->"ab2ae774-a8d7-4b4c-9d58-f825f9de5909"],
Cell[4458, 131, 1202, 31, 103, "Output",ExpressionUUID->"f111f257-0857-499b-a65e-42fbb674ce46"]
}, Open  ]],
Cell[5675, 165, 1836, 44, 285, "Input",ExpressionUUID->"833d7e0a-b33b-4339-b1cc-42b0b31fa2f6"],
Cell[CellGroupData[{
Cell[7536, 213, 1234, 39, 285, "Input",ExpressionUUID->"f2342688-ae13-48cb-baf7-60369d065b29"],
Cell[8773, 254, 542, 11, 103, "Output",ExpressionUUID->"66801b6c-f555-469b-ac02-d1bbe94c4a10"]
}, Open  ]],
Cell[9330, 268, 2185, 60, 399, "Input",ExpressionUUID->"400362b7-1a26-4406-ac3b-bf4965c40225"],
Cell[CellGroupData[{
Cell[11540, 332, 275, 6, 95, "Input",ExpressionUUID->"d0e900d5-91ce-4dc7-b337-066b6f1d15ff"],
Cell[11818, 340, 401, 8, 64, "Output",ExpressionUUID->"1ac154be-8618-49ad-b048-aa36f529a45f"],
Cell[12222, 350, 780, 25, 103, "Output",ExpressionUUID->"59f84142-19c3-4c45-9329-39fcde8e7293"]
}, Open  ]],
Cell[13017, 378, 592, 16, 133, "Input",ExpressionUUID->"ebdaeb30-1640-4569-9d0c-624de813d8d2"],
Cell[CellGroupData[{
Cell[13634, 398, 2278, 64, 475, "Input",ExpressionUUID->"4baf7827-d9fb-4d72-a217-0545b500b66c"],
Cell[15915, 464, 211, 4, 64, "Output",ExpressionUUID->"3480de9b-0eab-4b59-bbfe-305b0fb557cb"],
Cell[16129, 470, 230, 5, 64, "Output",ExpressionUUID->"527ec9b1-50a9-419e-8398-563550fa034d"]
}, Open  ]],
Cell[16374, 478, 1787, 55, 287, "Input",ExpressionUUID->"38aee430-6229-44e0-a869-8be597f99731"],
Cell[18164, 535, 1680, 53, 287, "Input",ExpressionUUID->"c290d6d0-0a6d-447c-9ce1-11fb9f6c1603"],
Cell[CellGroupData[{
Cell[19869, 592, 672, 20, 169, "Input",ExpressionUUID->"f6edb8ca-405e-4ac4-8293-dc40d6c0ef16"],
Cell[20544, 614, 843, 19, 103, "Output",ExpressionUUID->"fa7f5ade-2558-4fd2-b49f-4f26785d8cd9"],
Cell[21390, 635, 825, 20, 113, "Output",ExpressionUUID->"fcc85842-02cd-4d07-a793-e4d38047cb39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22252, 660, 207, 5, 57, "Input",ExpressionUUID->"38a4472f-8ae5-4c0b-a951-0c32fce450cc"],
Cell[22462, 667, 2719, 76, 388, "Output",ExpressionUUID->"57c9bba8-d5c4-4075-b421-9f8469f1026d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25218, 748, 311, 7, 95, "Input",ExpressionUUID->"dedec0b3-4dd4-4289-a383-9553f58b7b3a"],
Cell[25532, 757, 245, 6, 64, "Output",ExpressionUUID->"afcda4d7-4695-4cd0-b669-151523f3b973"],
Cell[25780, 765, 306, 8, 64, "Output",ExpressionUUID->"b09f0dab-de9e-4154-acac-eeb5edeaa3f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26123, 778, 193, 4, 56, "Input",ExpressionUUID->"b80975ef-ef9c-42cd-aec2-806b8efcdf9d"],
Cell[26319, 784, 265, 7, 64, "Output",ExpressionUUID->"cf5cb471-65f8-40f8-b13e-fb756e941b70"]
}, Open  ]],
Cell[26599, 794, 177, 4, 56, "Input",ExpressionUUID->"e4dde944-1321-4e6f-8351-2e30e563fcbd"],
Cell[CellGroupData[{
Cell[26801, 802, 271, 9, 93, "Input",ExpressionUUID->"0d1da216-6ba4-47b7-b645-d0ef8126eb84"],
Cell[27075, 813, 436, 15, 70, "Output",ExpressionUUID->"20a0ba67-1cb3-4d9f-a787-d15311703277"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27548, 833, 211, 5, 56, "Input",ExpressionUUID->"981f1133-eb50-46a5-a728-3dd766e91a06"],
Cell[27762, 840, 311, 11, 64, "Output",ExpressionUUID->"63edf0c9-8737-4817-973b-8b917f68c90d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28110, 856, 1812, 50, 361, "Input",ExpressionUUID->"c82b66fe-d38a-47b9-b4fd-bcc9c5cbac81"],
Cell[29925, 908, 649, 18, 70, "Output",ExpressionUUID->"2bd45318-2e0c-45a8-8fa5-48c24cf6c649"],
Cell[30577, 928, 796, 20, 103, "Output",ExpressionUUID->"66dd8154-f36a-44ee-abd9-3fcce159cbca"],
Cell[31376, 950, 352, 9, 64, "Output",ExpressionUUID->"eeec8b34-852d-4e45-a8b5-a8b02d304b4c"]
}, Open  ]],
Cell[31743, 962, 152, 3, 56, "Input",ExpressionUUID->"b8285001-ecf4-420f-b6d7-c67099f83650"],
Cell[CellGroupData[{
Cell[31920, 969, 929, 29, 209, "Input",ExpressionUUID->"f396f575-008b-4683-aa3f-6454f00e1e6d"],
Cell[32852, 1000, 406, 12, 64, "Output",ExpressionUUID->"ec4fd5bf-3567-45a2-a402-864b75379018"],
Cell[33261, 1014, 346, 10, 64, "Output",ExpressionUUID->"7ff8ede8-ef74-416d-81b5-7f85cae0b376"]
}, Open  ]],
Cell[33622, 1027, 583, 14, 133, "Input",ExpressionUUID->"0f02548d-6b74-498a-ba06-9a74acfe2ad0"],
Cell[34208, 1043, 1384, 40, 399, "Input",ExpressionUUID->"6fade0c1-17c6-4a59-baf2-4cf4dbb6ff53"],
Cell[35595, 1085, 2400, 57, 628, "Input",ExpressionUUID->"d2027d55-7db4-48f0-8ce1-31080b9e72ea"],
Cell[CellGroupData[{
Cell[38020, 1146, 174, 4, 56, "Input",ExpressionUUID->"a971ab71-f16f-4861-9bfe-025f3718922d"],
Cell[38197, 1152, 11520, 287, 547, "Output",ExpressionUUID->"3d4674a7-6d3c-4fe3-a057-527f93b676a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49754, 1444, 1517, 38, 399, "Input",ExpressionUUID->"bcf1800b-5e94-4c1f-85cb-d618080fb1c5"],
Cell[51274, 1484, 4847, 101, 483, "Output",ExpressionUUID->"508e113f-baf6-4e9a-a85c-caf2ff0ac1f3"]
}, Open  ]],
Cell[56136, 1588, 1619, 42, 361, "Input",ExpressionUUID->"c9fa5922-6fc0-4229-86f2-9652fd0bcd49"],
Cell[57758, 1632, 163, 3, 56, "Input",ExpressionUUID->"1aaac348-c292-45f6-a0e1-57072463167d"],
Cell[CellGroupData[{
Cell[57946, 1639, 2816, 86, 631, "Input",ExpressionUUID->"df01f70b-9a45-4cf1-8631-21fabca340aa"],
Cell[60765, 1727, 385, 8, 44, "Print",ExpressionUUID->"b9d87df4-7197-4295-8453-bb946ef3ff86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61187, 1740, 1451, 42, 209, "Input",ExpressionUUID->"d64fa0a7-82a8-4698-94c3-0fda502ad916"],
Cell[62641, 1784, 461, 10, 92, "Message",ExpressionUUID->"812cd6e6-bc73-44f5-9a63-0f1246b07aab"],
Cell[63105, 1796, 735, 14, 136, "Message",ExpressionUUID->"b584ddcc-8e24-4fbe-8073-07ce84557421"],
Cell[63843, 1812, 322, 6, 64, "Output",ExpressionUUID->"b034aff7-23f1-4efe-9779-9c585497009f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64202, 1823, 1075, 30, 250, "Input",ExpressionUUID->"8e257bea-3040-460f-b860-d9e376f30633"],
Cell[65280, 1855, 398, 8, 44, "Print",ExpressionUUID->"ddd0709f-ef26-4df2-be3a-37c4a3198665"]
}, Open  ]],
Cell[65693, 1866, 583, 14, 133, "Input",ExpressionUUID->"380da6cb-4304-4ddc-8c80-d4d1ee7974d9"],
Cell[CellGroupData[{
Cell[66301, 1884, 1215, 32, 362, "Input",ExpressionUUID->"52af7075-f1e2-40d2-aa66-9c7f8914e277"],
Cell[67519, 1918, 160, 3, 64, "Output",ExpressionUUID->"8b708043-bcb2-4e6d-8744-bcf47dac51e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67716, 1926, 159, 3, 56, "Input",ExpressionUUID->"d0aefc0f-5795-4c21-9a5f-a0c75f2d1a6b"],
Cell[67878, 1931, 145, 2, 64, "Output",ExpressionUUID->"fee1ed13-9bc0-417b-b9d4-b8d7df9b08b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68060, 1938, 414, 12, 97, "Input",ExpressionUUID->"656c6763-c400-4248-a7a9-7208a05e17d0"],
Cell[68477, 1952, 196, 3, 64, "Output",ExpressionUUID->"26386c0a-af91-4196-8276-286ef8a80a44"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68710, 1960, 360, 10, 163, "Input",ExpressionUUID->"97a94c4b-a0de-4382-b8f0-35eac1e7a4df"],
Cell[69073, 1972, 174, 3, 64, "Output",ExpressionUUID->"99947fb3-62da-4e38-9c0a-2496f3842036"],
Cell[69250, 1977, 174, 3, 64, "Output",ExpressionUUID->"e5c4d922-82fe-4625-960a-63c283c320d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69461, 1985, 765, 23, 143, "Input",ExpressionUUID->"634016ce-821e-4bfb-b03c-fbfdf6894d3d"],
Cell[CellGroupData[{
Cell[70251, 2012, 640, 20, 52, "Print",ExpressionUUID->"4e4bbd41-3ad9-41cb-98fc-2e20d985db8d"],
Cell[70894, 2034, 466, 12, 45, "Print",ExpressionUUID->"96eef058-2645-4e24-bff9-fc61810f9db9"]
}, Open  ]]
}, Open  ]],
Cell[71387, 2050, 1120, 36, 209, "Input",ExpressionUUID->"d26be33c-614f-4aac-801d-6c33de94933f"],
Cell[72510, 2088, 177, 4, 56, "Input",ExpressionUUID->"fab3f9ee-43d1-45df-9e79-79592627d199"],
Cell[72690, 2094, 331, 10, 95, "Input",ExpressionUUID->"cd405113-7300-437e-b038-a32afb4d16a8"],
Cell[CellGroupData[{
Cell[73046, 2108, 238, 5, 86, "Input",ExpressionUUID->"cd116a19-b7c8-4cb3-a440-1125a994f839"],
Cell[73287, 2115, 278, 6, 85, "Output",ExpressionUUID->"d82dcde8-93e2-4f77-a308-3ef23c11804c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73602, 2126, 234, 4, 56, "Input",ExpressionUUID->"fca69241-6a48-46ab-8809-f029397ca726"],
Cell[73839, 2132, 231, 5, 65, "Output",ExpressionUUID->"d2868a6e-15e2-4b83-b9bb-da685bf5fe79"]
}, Open  ]],
Cell[74085, 2140, 920, 28, 209, "Input",ExpressionUUID->"23b769ae-20ab-4b92-ad75-7919d3307acc"],
Cell[CellGroupData[{
Cell[75030, 2172, 1148, 32, 359, "Input",ExpressionUUID->"dd01a7e4-287e-48a2-9bf3-478b8e910063"],
Cell[76181, 2206, 398, 9, 85, "Output",ExpressionUUID->"1cbb7752-1749-4359-9d8f-dc8e84b2244a"],
Cell[76582, 2217, 398, 9, 85, "Output",ExpressionUUID->"97d0a2a9-5059-4717-8605-fc24ed9a2b38"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77017, 2231, 502, 13, 130, "Input",ExpressionUUID->"8092c786-10b5-4d72-9544-07c5b6825298"],
Cell[77522, 2246, 193, 2, 64, "Output",ExpressionUUID->"259b06f4-508b-4970-a46e-eadce7a1795d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77752, 2253, 1018, 31, 207, "Input",ExpressionUUID->"5a0fbd76-41b3-4f71-ad53-866b9d695534"],
Cell[78773, 2286, 7054, 151, 256, "Output",ExpressionUUID->"c70b6bd0-d550-4ce9-9568-4e394f79ea1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85864, 2442, 1856, 56, 214, "Input",ExpressionUUID->"7eb6b492-7a99-4e66-bae5-c3b616e46720"],
Cell[87723, 2500, 450, 11, 65, "Output",ExpressionUUID->"fb109c64-14de-4851-8fd0-aa17265bbc69"],
Cell[88176, 2513, 943, 30, 85, "Output",ExpressionUUID->"82175e5e-fd9b-4616-bc1a-a3a608f45412"],
Cell[89122, 2545, 11529, 216, 478, "Output",ExpressionUUID->"570fe993-09b2-420f-a55d-7363bf328a07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100688, 2766, 1560, 49, 253, "Input",ExpressionUUID->"16596054-fad2-4d43-a966-a0f07667e8e5"],
Cell[102251, 2817, 342, 8, 44, "Print",ExpressionUUID->"4458ee71-a47d-4b30-92e5-2d760f4134f2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102630, 2830, 2000, 65, 307, "Input",ExpressionUUID->"02c9e994-6813-4745-b842-6a023cfff70f"],
Cell[104633, 2897, 423, 11, 64, "Output",ExpressionUUID->"a2d4b91d-53d2-49dc-a06c-af76e5f22cf9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105093, 2913, 1050, 31, 193, "Input",ExpressionUUID->"f8162d51-1393-459b-aa5c-e218c2d0cdf5"],
Cell[106146, 2946, 371, 10, 64, "Output",ExpressionUUID->"09225fbe-ce6d-4535-9d2f-8ac5adb2de3f"]
}, Open  ]],
Cell[106532, 2959, 1006, 31, 209, "Input",ExpressionUUID->"ad4d7764-b13c-44a3-9ff0-0609ef6546df"],
Cell[107541, 2992, 2272, 74, 734, "Input",ExpressionUUID->"a535f2a9-7343-46ca-9594-7b866311e935"],
Cell[CellGroupData[{
Cell[109838, 3070, 268, 6, 56, "Input",ExpressionUUID->"2bc708a5-0210-471a-b038-87faf11cb6ba"],
Cell[110109, 3078, 296, 8, 64, "Output",ExpressionUUID->"1333a73e-7e4f-402b-9133-a89c0c4c04e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110442, 3091, 268, 6, 56, "Input",ExpressionUUID->"1ebc7cd4-a48f-4509-882f-15a1fd2ea1a4"],
Cell[110713, 3099, 297, 8, 64, "Output",ExpressionUUID->"60fee6f0-4149-42d3-a31d-f11696d3f026"]
}, Open  ]],
Cell[111025, 3110, 2351, 76, 775, "Input",ExpressionUUID->"a8beef22-7c32-45f4-8fcc-ecab8a18d808"],
Cell[CellGroupData[{
Cell[113401, 3190, 239, 6, 56, "Input",ExpressionUUID->"4b6bfc91-7f04-4cd2-a9a1-3bc2d1217142"],
Cell[113643, 3198, 298, 8, 64, "Output",ExpressionUUID->"f144ab23-b0d7-4419-ac0d-6c1b361ce3af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113978, 3211, 267, 6, 56, "Input",ExpressionUUID->"0ab88a55-ef06-467a-aad7-a7ac0bc95ed9"],
Cell[114248, 3219, 295, 8, 64, "Output",ExpressionUUID->"fa960346-c7e4-437e-a81c-9a4560576d0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114580, 3232, 706, 19, 105, "Input",ExpressionUUID->"f4add35e-04ef-4333-9ad1-2127e0a7fbb4"],
Cell[115289, 3253, 18761, 408, 317, "Output",ExpressionUUID->"6782b573-7f39-4373-9f0a-28dd7795780d"]
}, Open  ]]
}
]
*)

