(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    331635,       7495]
NotebookOptionsPosition[    315256,       7226]
NotebookOutlinePosition[    315771,       7244]
CellTagsIndexPosition[    315728,       7241]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  RowBox[{"(*", "koment", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.906090434663175*^9, 3.9060904443443313`*^9}, 
   3.9060905392644854`*^9, {3.9060906062591085`*^9, 3.9060906122392397`*^9}},
 CellLabel->
  "In[712]:=",ExpressionUUID->"00d62c7a-efa5-4dae-b718-f61dbee0b343"],

Cell["\<\

P\[RHacek]\[IAcute]li\[SHacek] \[ZHacek]lu\[THacek]ou\[CHacek]k\[YAcute] k\
\[URing]\[NHacek] \[UAcute]p\[EHacek]l \[DHacek]\[AAcute]belsk\[EAcute] \
\[OAcute]dy.\
\>", "Text",
 CellChangeTimes->{{3.9060906188819857`*^9, 
  3.9060906549370203`*^9}},ExpressionUUID->"63417646-cf97-4d9e-a9b0-\
fd9b74ba588d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"info", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"data1", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"pom", "=", 
       RowBox[{"Transpose", "[", "data2", "]"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060905484435015`*^9, 3.906090583512492*^9}, {
  3.906090742885088*^9, 3.906090757201*^9}, {3.9060907938101945`*^9, 
  3.9060908013364735`*^9}, {3.9060908484719133`*^9, 3.9060909465732336`*^9}, {
  3.9060909868605824`*^9, 3.90609108869783*^9}},
 CellLabel->
  "In[715]:=",ExpressionUUID->"1965499e-6ba4-47b6-8aa5-0ef8f7048997"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906091077416854*^9, 3.9060910892029395`*^9}, 
   3.906091407199205*^9, 3.907303045968175*^9},
 CellLabel->
  "Out[722]=",ExpressionUUID->"2be405c6-207f-4f17-94df-b854505f0865"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Drop", "[", 
    RowBox[{
     RowBox[{"pom", "=", 
      RowBox[{"data2", "\[Transpose]"}]}], ",", 
     RowBox[{"-", "1"}]}], "]"}], "\[Transpose]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9060913426592817`*^9, 3.906091399142404*^9}},
 CellLabel->
  "In[723]:=",ExpressionUUID->"07898d04-8875-4b2c-b969-481eebc91150"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "u"}], "}"}], "==", 
  RowBox[{"{", 
   RowBox[{"k", ",", "d", ",", "h"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "u"}], "}"}], "==", 
   RowBox[{"{", 
    RowBox[{"k", ",", "dd", ",", "h"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.90609125281457*^9, 3.90609130389725*^9}},
 CellLabel->
  "In[724]:=",ExpressionUUID->"65dbe89f-19e4-4de1-9bda-a680643be0b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "u"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"k", ",", "d", ",", "h"}], "}"}]}]], "Output",
 CellChangeTimes->{{3.906091263120324*^9, 3.9060913043842564`*^9}, 
   3.9073030459908967`*^9},
 CellLabel->
  "Out[724]=",ExpressionUUID->"735e77b4-9893-4b21-a3de-e55a2ab61329"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", "\[Equal]", "k"}], ",", 
   RowBox[{"d", "\[Equal]", "dd"}], ",", 
   RowBox[{"u", "\[Equal]", "h"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.906091263120324*^9, 3.9060913043842564`*^9}, 
   3.9073030460002065`*^9},
 CellLabel->
  "Out[725]=",ExpressionUUID->"09bb25a3-7fec-4e30-b824-9a2b72473c98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "b", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rovnice", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"A", ".", "nezname"}], "==", "b"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "rovnice", "]"}]}], "Input",
 CellChangeTimes->{{3.9060911092841864`*^9, 3.9060911957158065`*^9}},
 CellLabel->
  "In[726]:=",ExpressionUUID->"afa8795a-f4ed-4028-bb49-471aa8d3894d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", "3.09193370835402`"}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     RowBox[{"-", "1.37183183356454`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", "0.27537728971604836`"}], ",", 
    RowBox[{
     SubscriptBox["x", "4"], "\[Rule]", "2.7605480410534207`"}], ",", 
    RowBox[{
     SubscriptBox["x", "5"], "\[Rule]", 
     RowBox[{"-", "0.3056072433248169`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "6"], "\[Rule]", "3.051173169637574`"}], ",", 
    RowBox[{
     SubscriptBox["x", "7"], "\[Rule]", "2.5473126863519013`"}], ",", 
    RowBox[{
     SubscriptBox["x", "8"], "\[Rule]", "6.20371892158359`"}], ",", 
    RowBox[{
     SubscriptBox["x", "9"], "\[Rule]", 
     RowBox[{"-", "1.5918417224634418`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "10"], "\[Rule]", 
     RowBox[{"-", "3.981102568677317`"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9060911442469144`*^9, 3.9060911475590315`*^9}, {
   3.9060911784126496`*^9, 3.9060911961097574`*^9}, 3.907303046008712*^9},
 CellLabel->
  "Out[728]=",ExpressionUUID->"558ee17e-66a0-40de-850e-e6ae32901f50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"data1", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", 
       RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data2"}], ")"}], "//", 
    "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", "data2"}], ")"}], "/.", 
    RowBox[{
     RowBox[{"{", "v_Real", "}"}], ":>", "v"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060915195825205`*^9, 3.9060916580312004`*^9}},
 CellLabel->
  "In[729]:=",ExpressionUUID->"b372b501-87bb-46e5-aea2-f4d5116b20b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.90609165863011*^9, 3.9073030460468245`*^9},
 CellLabel->
  "Out[736]=",ExpressionUUID->"1858d51d-83cf-4f6c-bd7c-c2d13d762a9c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyReal.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.906091722497165*^9, 3.906091736746647*^9}},
 CellLabel->
  "In[737]:=",ExpressionUUID->"ed1fb500-f9c8-4976-a26c-a5ddd6947edd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "2"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "//", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060917435915737`*^9, 3.9060917924749565`*^9}, {
   3.9060918388237567`*^9, 3.906091929413034*^9}, {3.906092003880368*^9, 
   3.906092030088756*^9}, 3.9060920895747213`*^9, {3.906092253978368*^9, 
   3.9060923084248176`*^9}},
 CellLabel->
  "In[740]:=",ExpressionUUID->"39870c84-e027-4907-b9be-f1473625114f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.09193370835402`", ",", 
   RowBox[{"-", "1.371831833564541`"}], ",", "0.27537728971604936`", ",", 
   "2.76054804105342`", ",", 
   RowBox[{"-", "0.3056072433248168`"}], ",", "3.0511731696375746`", ",", 
   "2.5473126863519022`", ",", "6.203718921583591`", ",", 
   RowBox[{"-", "1.5918417224634414`"}], ",", 
   RowBox[{"-", "3.9811025686773176`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.906092308808156*^9, 3.907303046078415*^9},
 CellLabel->
  "Out[743]=",ExpressionUUID->"18d7bea3-553b-4310-9cbb-4540fd387f1e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"data1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], "&"}], "/@", "data2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "data3"}], ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"re_Real", ",", "im_"}], "}"}], ":>", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], "&"}], "/@", "data2"}], 
     ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"re_Real", ",", "im_"}], "}"}], ":>", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}], ">>", "\"\<vys1\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.9060924192001567`*^9, 3.906092438253257*^9}, {
  3.9060924831809096`*^9, 3.906092483576357*^9}, {3.9060925234415092`*^9, 
  3.906092532223237*^9}, {3.906092670511801*^9, 3.9060927532963576`*^9}, {
  3.906092811872772*^9, 3.9060929246412134`*^9}, {3.906093205326655*^9, 
  3.9060933206878743`*^9}, {3.906093938743512*^9, 3.906093943272148*^9}},
 CellLabel->
  "In[744]:=",ExpressionUUID->"17c259c0-924a-4f38-82b9-2d3a60ee82ab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pom", "=", 
  RowBox[{"Range", "[", "20", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"pom", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.906092756643944*^9, 3.9060927742476254`*^9}},
 CellLabel->
  "In[752]:=",ExpressionUUID->"7b38808d-7cb2-4cea-86ca-93d07d5a5a57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",
 CellChangeTimes->{{3.90609276523647*^9, 3.906092774470004*^9}, 
   3.907303046189434*^9},
 CellLabel->
  "Out[752]=",ExpressionUUID->"a40b5b12-f15f-44a2-9770-80bed4ee008c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.90609276523647*^9, 3.906092774470004*^9}, 
   3.907303046189434*^9},
 CellLabel->
  "Out[753]=",ExpressionUUID->"400e39af-2098-49ca-a0c9-5275276183e7"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<koeficientyKomplex.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Are", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "3"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Aim", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"2", ";;", 
       RowBox[{"-", "3"}], ";;", "2"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Are", "+", 
    RowBox[{"I", "*", "Aim"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bre", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"-", "2"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bim", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Bre", "+", 
    RowBox[{"I", "*", "Bim"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{"<<", "\"\<vys1\>\""}], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.906093432234274*^9, 3.906093689360118*^9}, {
   3.9060937305368204`*^9, 3.9060938980184507`*^9}, {3.906093998227234*^9, 
   3.9060940034824715`*^9}, 3.9060940775167274`*^9},
 CellLabel->
  "In[754]:=",ExpressionUUID->"7621f556-f301-4d62-a620-7f45184a86ea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Dimensions", "[", "Are", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "Aim", "]"}]}], "Input",
 CellChangeTimes->{{3.9060937355771503`*^9, 3.90609374602145*^9}},
 CellLabel->
  "In[764]:=",ExpressionUUID->"ce457c79-3696-450b-adae-b07c1a1bfc57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "100"}], "}"}]], "Output",
 CellChangeTimes->{{3.906093747515504*^9, 3.906093755637544*^9}, 
   3.9073030462367496`*^9},
 CellLabel->
  "Out[764]=",ExpressionUUID->"6c3e9557-a921-4fa7-ba39-16b6af4d016c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "100"}], "}"}]], "Output",
 CellChangeTimes->{{3.906093747515504*^9, 3.906093755637544*^9}, 
   3.9073030462527523`*^9},
 CellLabel->
  "Out[765]=",ExpressionUUID->"377612eb-717a-4390-b495-392c7e902afc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "y"}]], "Input",
 CellChangeTimes->{{3.9060947894345565`*^9, 3.906094789967804*^9}},
 CellLabel->
  "In[766]:=",ExpressionUUID->"7aa1bd2c-ece1-4fd6-859c-18b0376ce5e1"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"y\"\>"}], "]"}]], "Output",
 CellChangeTimes->{3.9060947905948544`*^9, 3.9073030462686033`*^9},
 CellLabel->
  "Out[766]=",ExpressionUUID->"f49ec9c3-e61e-471e-aba2-0467a51c58bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "y", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
    FractionBox[
     RowBox[{"Sin", "[", "t", "]"}], 
     RowBox[{"t", "+", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rce", ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "==", "5"}]}], "}"}], ",", "y", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9060947388037205`*^9, 3.906094753538631*^9}, {
  3.906094807142144*^9, 3.906094812059921*^9}},
 CellLabel->
  "In[767]:=",ExpressionUUID->"5bd9f76e-8542-4bda-8d38-9f068c5175e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   InterpretationBox[
    RowBox[{
     TagBox["InterpolatingFunction",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]],
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000004237283312}, {
                    0.3626943734551407, 1.7770156504730057`}}], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAR4lsJH1DEEAIMHT2p278PxV5s3E+
1xBA+4HfHrCQ+z8gHT1dzh0UQMpI8djIPfc/KRylE5OqF0BZlfX1kUjzP3As
Dv3EJhtAvoR77l4i8D8QqYlNAGceQNP/FE2cies/WMBxNLj2IEDVAVRb21Xn
P1Xip/X0myJAXEh3Ssz74z/xjF5Q6DgkQA68/pS7C+E/DGWEEPb4JUC5FFGI
f2DcP1VzM4QImydAF5h/vbHA1z8er1FdNWApQA9LzQNdptM/hXPwzxgdK0AK
bgKu6IrQPxluGPYAvCxAnB3nzICXzD8tlq+BA34uQG516igDjcg/OPpnYAUR
MEDx387M5BfFPxnArzKW9DBApZc/SNJ7wT9JyrdRAtQxQKysuX7XcLw/j2+E
ynCkMkBV1SDrHGK3P5WrCHZshjNAg1Jq2RVksz+yglF7alk0QCuW3F2U7LA/
Hp5azUMoNUCLY+9jLleuP0pQG1KqCDZAhux3n1atqj+NnaAwE9o2QAevaY4t
q6Y/j4HdQQm9N0CwGj/bmNyhP+Gp2p/amzhA7bEsLBAwmz9JbZxXrms5QOPr
HVDsrpU/cccVQg9NOkAcZS8WjeWSP7C8U4ZyHztALHGQArtAkj8+9lEXse07
QCobfGsuvpE/jMYH23zNPECP0gUmZ5CPP/AxgvhKnj1AwkFAL77BiD8UNLRI
poA+QBAY1/a8MoA/T9Gq8gNUP0A1uiM872p0P23ZsHSeEUBA+ZPn6cIvcD+S
FWiJAYJAQJLJtL46I3M/Qp8By+XqQECtKEf/Xid4P1L09qWQXEFAscK4E5DG
eT+Ka0wnKcxBQMaeNuWjhHQ/TTCE1UI0QkDnq1tQJbRmP3DAFx0jpUJAg6U8
0qYCQT8fno2RhA5DQLqw98bo5TS/9Z1jrNN1Q0DCtPajtlk0PytplWDp5UNA
UQOtrzrfXj/sgalBgE5EQCQwu8BXzmg/DWYZvN2/RECqcAwGAxVoP1Zs6dwo
L0VA/A+3shepWD8qwJsq9ZZFQF7/Za6eJSy/Xt+pEYgHRkAXeRG319xVvx1M
miWccEZAku2/0yrcUb88hObSduJGQOeTtDvJHjI/g96SJj9SR0BX+BREgaFb
P1WGIaeIukdApejuznhwYT+H+QvBmCtIQNXwkZMtzlU/RbrYByqVSEDaP/dB
vpUbvz4Z5Pj//0hAH/3aw/RDVb9PNJzd
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456156#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0013343912690043141`, 
                 1.7770156504730057`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]],
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000004237283312}, {
                    0.3626943734551407, 1.7770156504730057`}}], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAR4lsJH1DEEAIMHT2p278PxV5s3E+
1xBA+4HfHrCQ+z8gHT1dzh0UQMpI8djIPfc/KRylE5OqF0BZlfX1kUjzP3As
Dv3EJhtAvoR77l4i8D8QqYlNAGceQNP/FE2cies/WMBxNLj2IEDVAVRb21Xn
P1Xip/X0myJAXEh3Ssz74z/xjF5Q6DgkQA68/pS7C+E/DGWEEPb4JUC5FFGI
f2DcP1VzM4QImydAF5h/vbHA1z8er1FdNWApQA9LzQNdptM/hXPwzxgdK0AK
bgKu6IrQPxluGPYAvCxAnB3nzICXzD8tlq+BA34uQG516igDjcg/OPpnYAUR
MEDx387M5BfFPxnArzKW9DBApZc/SNJ7wT9JyrdRAtQxQKysuX7XcLw/j2+E
ynCkMkBV1SDrHGK3P5WrCHZshjNAg1Jq2RVksz+yglF7alk0QCuW3F2U7LA/
Hp5azUMoNUCLY+9jLleuP0pQG1KqCDZAhux3n1atqj+NnaAwE9o2QAevaY4t
q6Y/j4HdQQm9N0CwGj/bmNyhP+Gp2p/amzhA7bEsLBAwmz9JbZxXrms5QOPr
HVDsrpU/cccVQg9NOkAcZS8WjeWSP7C8U4ZyHztALHGQArtAkj8+9lEXse07
QCobfGsuvpE/jMYH23zNPECP0gUmZ5CPP/AxgvhKnj1AwkFAL77BiD8UNLRI
poA+QBAY1/a8MoA/T9Gq8gNUP0A1uiM872p0P23ZsHSeEUBA+ZPn6cIvcD+S
FWiJAYJAQJLJtL46I3M/Qp8By+XqQECtKEf/Xid4P1L09qWQXEFAscK4E5DG
eT+Ka0wnKcxBQMaeNuWjhHQ/TTCE1UI0QkDnq1tQJbRmP3DAFx0jpUJAg6U8
0qYCQT8fno2RhA5DQLqw98bo5TS/9Z1jrNN1Q0DCtPajtlk0PytplWDp5UNA
UQOtrzrfXj/sgalBgE5EQCQwu8BXzmg/DWYZvN2/RECqcAwGAxVoP1Zs6dwo
L0VA/A+3shepWD8qwJsq9ZZFQF7/Za6eJSy/Xt+pEYgHRkAXeRG319xVvx1M
miWccEZAku2/0yrcUb88hObSduJGQOeTtDvJHjI/g96SJj9SR0BX+BREgaFb
P1WGIaeIukdApejuznhwYT+H+QvBmCtIQNXwkZMtzlU/RbrYByqVSEDaP/dB
vpUbvz4Z5Pj//0hAH/3aw/RDVb9PNJzd
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456156#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0013343912690043141`, 
                 1.7770156504730057`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    InterpolatingFunction[{{0., 50.}}, {
     5, 7, 2, {337}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
      False}, CompressedData["
1:eJwtlok/FHgDxl2F3CJEYUjum8Hg94wxY5w58nbZtK5CpUOppHKrCKNVQyqJ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     "], {Developer`PackedArrayForm, CompressedData["
1:eJwl04l7DwQcBvCfrSY1TWOhISuZI1FEc7QMUWpl5khoKDVNE00YK6xcyVVK
yWo55iysRBHmSDlqRWqRaSXLpNy3zx7f5/m8f8D7Pt+ovqkJL5QJBAIJpeGC
CaEcoYQRTgRViKQGUdQimno0oBGNaUoMLYkljnZ0oCPxdCKRbvSgF0n0oz/J
pJDKYNIYRjoZjCaTcUxkMlOZwUxmMZsssplHDotZxnJyWcUa1rKePLawje3s
Ip/d7KWA/RRSxCGKKeEYxznFWS5wmSDdXst13MCN3EQlKnML1anJ7dSmLnfS
kHu4l/towf20pi3teZhHeZzOdOUJevIUfXmG53ie0sFf5CVeZgSjeJWxvM4E
3mAK03mbd3mfOXzEXBawiKV8yko+ZzVf8TUb2cw3fMdOfuAnfuZX9nGAP/iL
wxzhX/7nJGc4zyXKBAUC11CW6ylPBSpyM1Wpxq3cxh3UoT53cTdNaEZzWvEA
bXiQh3iEx0igC915kt704WmeZQADGcQQhjKckbzCGF5jPJN4k2m8xTu8xwd8
yMfMZyFL+IQVfMYXfMk6NrCJrXzLDr7nR/bwC7/xOwf5k7/5h6P8xwlOc46L
QVefP5gQyhFKGOFEUIVIahBFLaKpRwMa0ZimxNCSWOJoRwc6Ek8nEulGD3qR
RD/6k0wKqQwmjWGkk8FoMhnHRCYzlRnMZBazySKbeeSwmGUsJ5dVrGEt68lj
C9vYzi7y2c1eCthPIUUcopgSjnGcK9aKqmc=
      "], CompressedData["
1:eJwtl3c0Fg7Ux+0RUpQVKquMqOyU+1jZe++dmb1LZFTKHoXInmVFpHUfRANl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      "]}, {Automatic}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060947403075705`*^9, 3.9060947584871206`*^9}, 
   3.906094812703845*^9, 3.9073030463160973`*^9},
 CellLabel->
  "Out[770]=",ExpressionUUID->"73b90289-e829-4594-ba39-eba6b619eed3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
    FractionBox[
     RowBox[{"Sin", "[", "t", "]"}], 
     RowBox[{"t", "+", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"rce", ",", 
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "0", "]"}], "==", "5"}]}], "}"}], ",", "y",
       ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"sol", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.906094099064414*^9, 3.9060941656089225`*^9}, {
  3.9060942065468225`*^9, 3.906094312464677*^9}, {3.9060943743162575`*^9, 
  3.906094383611906*^9}, {3.9060944176335216`*^9, 3.9060944802123513`*^9}, {
  3.906094518831524*^9, 3.9060945609914265`*^9}, {3.90609471140909*^9, 
  3.9060947177195435`*^9}},
 CellLabel->
  "In[771]:=",ExpressionUUID->"e0fd99e0-c867-4836-b6a8-bbd30b0c8a06"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   InterpretationBox[
    RowBox[{
     TagBox["InterpolatingFunction",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]],
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000004237283312}, {
                    0.3626943734551407, 1.7770156504730057`}}], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAR4lsJH1DEEAIMHT2p278PxV5s3E+
1xBA+4HfHrCQ+z8gHT1dzh0UQMpI8djIPfc/KRylE5OqF0BZlfX1kUjzP3As
Dv3EJhtAvoR77l4i8D8QqYlNAGceQNP/FE2cies/WMBxNLj2IEDVAVRb21Xn
P1Xip/X0myJAXEh3Ssz74z/xjF5Q6DgkQA68/pS7C+E/DGWEEPb4JUC5FFGI
f2DcP1VzM4QImydAF5h/vbHA1z8er1FdNWApQA9LzQNdptM/hXPwzxgdK0AK
bgKu6IrQPxluGPYAvCxAnB3nzICXzD8tlq+BA34uQG516igDjcg/OPpnYAUR
MEDx387M5BfFPxnArzKW9DBApZc/SNJ7wT9JyrdRAtQxQKysuX7XcLw/j2+E
ynCkMkBV1SDrHGK3P5WrCHZshjNAg1Jq2RVksz+yglF7alk0QCuW3F2U7LA/
Hp5azUMoNUCLY+9jLleuP0pQG1KqCDZAhux3n1atqj+NnaAwE9o2QAevaY4t
q6Y/j4HdQQm9N0CwGj/bmNyhP+Gp2p/amzhA7bEsLBAwmz9JbZxXrms5QOPr
HVDsrpU/cccVQg9NOkAcZS8WjeWSP7C8U4ZyHztALHGQArtAkj8+9lEXse07
QCobfGsuvpE/jMYH23zNPECP0gUmZ5CPP/AxgvhKnj1AwkFAL77BiD8UNLRI
poA+QBAY1/a8MoA/T9Gq8gNUP0A1uiM872p0P23ZsHSeEUBA+ZPn6cIvcD+S
FWiJAYJAQJLJtL46I3M/Qp8By+XqQECtKEf/Xid4P1L09qWQXEFAscK4E5DG
eT+Ka0wnKcxBQMaeNuWjhHQ/TTCE1UI0QkDnq1tQJbRmP3DAFx0jpUJAg6U8
0qYCQT8fno2RhA5DQLqw98bo5TS/9Z1jrNN1Q0DCtPajtlk0PytplWDp5UNA
UQOtrzrfXj/sgalBgE5EQCQwu8BXzmg/DWYZvN2/RECqcAwGAxVoP1Zs6dwo
L0VA/A+3shepWD8qwJsq9ZZFQF7/Za6eJSy/Xt+pEYgHRkAXeRG319xVvx1M
miWccEZAku2/0yrcUb88hObSduJGQOeTtDvJHjI/g96SJj9SR0BX+BREgaFb
P1WGIaeIukdApejuznhwYT+H+QvBmCtIQNXwkZMtzlU/RbrYByqVSEDaP/dB
vpUbvz4Z5Pj//0hAH/3aw/RDVb9PNJzd
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456243#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0013343912690043141`, 
                 1.7770156504730057`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]],
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000004237283312}, {
                    0.3626943734551407, 1.7770156504730057`}}], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAR4lsJH1DEEAIMHT2p278PxV5s3E+
1xBA+4HfHrCQ+z8gHT1dzh0UQMpI8djIPfc/KRylE5OqF0BZlfX1kUjzP3As
Dv3EJhtAvoR77l4i8D8QqYlNAGceQNP/FE2cies/WMBxNLj2IEDVAVRb21Xn
P1Xip/X0myJAXEh3Ssz74z/xjF5Q6DgkQA68/pS7C+E/DGWEEPb4JUC5FFGI
f2DcP1VzM4QImydAF5h/vbHA1z8er1FdNWApQA9LzQNdptM/hXPwzxgdK0AK
bgKu6IrQPxluGPYAvCxAnB3nzICXzD8tlq+BA34uQG516igDjcg/OPpnYAUR
MEDx387M5BfFPxnArzKW9DBApZc/SNJ7wT9JyrdRAtQxQKysuX7XcLw/j2+E
ynCkMkBV1SDrHGK3P5WrCHZshjNAg1Jq2RVksz+yglF7alk0QCuW3F2U7LA/
Hp5azUMoNUCLY+9jLleuP0pQG1KqCDZAhux3n1atqj+NnaAwE9o2QAevaY4t
q6Y/j4HdQQm9N0CwGj/bmNyhP+Gp2p/amzhA7bEsLBAwmz9JbZxXrms5QOPr
HVDsrpU/cccVQg9NOkAcZS8WjeWSP7C8U4ZyHztALHGQArtAkj8+9lEXse07
QCobfGsuvpE/jMYH23zNPECP0gUmZ5CPP/AxgvhKnj1AwkFAL77BiD8UNLRI
poA+QBAY1/a8MoA/T9Gq8gNUP0A1uiM872p0P23ZsHSeEUBA+ZPn6cIvcD+S
FWiJAYJAQJLJtL46I3M/Qp8By+XqQECtKEf/Xid4P1L09qWQXEFAscK4E5DG
eT+Ka0wnKcxBQMaeNuWjhHQ/TTCE1UI0QkDnq1tQJbRmP3DAFx0jpUJAg6U8
0qYCQT8fno2RhA5DQLqw98bo5TS/9Z1jrNN1Q0DCtPajtlk0PytplWDp5UNA
UQOtrzrfXj/sgalBgE5EQCQwu8BXzmg/DWYZvN2/RECqcAwGAxVoP1Zs6dwo
L0VA/A+3shepWD8qwJsq9ZZFQF7/Za6eJSy/Xt+pEYgHRkAXeRG319xVvx1M
miWccEZAku2/0yrcUb88hObSduJGQOeTtDvJHjI/g96SJj9SR0BX+BREgaFb
P1WGIaeIukdApejuznhwYT+H+QvBmCtIQNXwkZMtzlU/RbrYByqVSEDaP/dB
vpUbvz4Z5Pj//0hAH/3aw/RDVb9PNJzd
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456243#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0013343912690043141`, 
                 1.7770156504730057`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    InterpolatingFunction[{{0., 50.}}, {
     5, 7, 2, {337}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
      False}, CompressedData["
1:eJwtlok/FHgDxl2F3CJEYUjum8Hg94wxY5w58nbZtK5CpUOppHKrCKNVQyqJ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     "], {Developer`PackedArrayForm, CompressedData["
1:eJwl04l7DwQcBvCfrSY1TWOhISuZI1FEc7QMUWpl5khoKDVNE00YK6xcyVVK
yWo55iysRBHmSDlqRWqRaSXLpNy3zx7f5/m8f8D7Pt+ovqkJL5QJBAIJpeGC
CaEcoYQRTgRViKQGUdQimno0oBGNaUoMLYkljnZ0oCPxdCKRbvSgF0n0oz/J
pJDKYNIYRjoZjCaTcUxkMlOZwUxmMZsssplHDotZxnJyWcUa1rKePLawje3s
Ip/d7KWA/RRSxCGKKeEYxznFWS5wmSDdXst13MCN3EQlKnML1anJ7dSmLnfS
kHu4l/towf20pi3teZhHeZzOdOUJevIUfXmG53ie0sFf5CVeZgSjeJWxvM4E
3mAK03mbd3mfOXzEXBawiKV8yko+ZzVf8TUb2cw3fMdOfuAnfuZX9nGAP/iL
wxzhX/7nJGc4zyXKBAUC11CW6ylPBSpyM1Wpxq3cxh3UoT53cTdNaEZzWvEA
bXiQh3iEx0igC915kt704WmeZQADGcQQhjKckbzCGF5jPJN4k2m8xTu8xwd8
yMfMZyFL+IQVfMYXfMk6NrCJrXzLDr7nR/bwC7/xOwf5k7/5h6P8xwlOc46L
QVefP5gQyhFKGOFEUIVIahBFLaKpRwMa0ZimxNCSWOJoRwc6Ek8nEulGD3qR
RD/6k0wKqQwmjWGkk8FoMhnHRCYzlRnMZBazySKbeeSwmGUsJ5dVrGEt68lj
C9vYzi7y2c1eCthPIUUcopgSjnGcK9aKqmc=
      "], CompressedData["
1:eJwtl3c0Fg7Ux+0RUpQVKquMqOyU+1jZe++dmb1LZFTKHoXInmVFpHUfRANl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      "]}, {Automatic}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060941201527033`*^9, 3.906094134349616*^9}, 
   3.906094166975144*^9, {3.9060942503300023`*^9, 3.9060943129875727`*^9}, {
   3.9060943809011273`*^9, 3.9060943839598107`*^9}, {3.906094429728905*^9, 
   3.9060944808103075`*^9}, {3.9060945210284643`*^9, 
   3.9060945616088495`*^9}, {3.906094712884157*^9, 3.9060947183628654`*^9}, 
   3.9073030463793774`*^9},
 CellLabel->
  "Out[774]=",ExpressionUUID->"81fd5e2d-d858-4699-9bf5-47e1d8d50c86"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVV3c81e8Xt1sqozKiJFkhe3POda97b5RklT2ypcy4QopSsslKoiFKWYUG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       "]]},
     Annotation[#, "Charting`Private`Tag$456308#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9060941201527033`*^9, 3.906094134349616*^9}, 
   3.906094166975144*^9, {3.9060942503300023`*^9, 3.9060943129875727`*^9}, {
   3.9060943809011273`*^9, 3.9060943839598107`*^9}, {3.906094429728905*^9, 
   3.9060944808103075`*^9}, {3.9060945210284643`*^9, 
   3.9060945616088495`*^9}, {3.906094712884157*^9, 3.9060947183628654`*^9}, 
   3.907303046427039*^9},
 CellLabel->
  "Out[775]=",ExpressionUUID->"80ea4616-3892-4fab-8295-1ecb7b8e431e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "11", ",", "2"}], "}"}], ".", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}]}], "==", 
    FractionBox[
     RowBox[{"Sin", "[", "t", "]"}], 
     RowBox[{"t", "+", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"rce", ",", 
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
        RowBox[{
         RowBox[{"y", "[", "1", "]"}], "==", "5"}]}], "}"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"sol", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060943147868776`*^9, 3.9060943722105713`*^9}, {
  3.9060946376573696`*^9, 3.9060946436584625`*^9}},
 CellLabel->
  "In[776]:=",ExpressionUUID->"a9bb6f04-8ad0-4b2c-b3be-dc361db67657"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   InterpretationBox[
    RowBox[{
     TagBox["InterpolatingFunction",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]],
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000009134964347}, {
                    0.3386430441913689, 2.5974661904268266`}}], 
                    LineBox[CompressedData["
1:eJwBcQOO/CFib1JlAgAAADYAAAACAAAArlk5uYRaFECbyqJanMcEQCkcpROT
qhdAmK4uuhGCAUBwLA79xCYbQFuMBBvrWf0/EKmJTQBnHkBcxSeDwQD5P1jA
cTS49iBA3dHbPyIW9T9V4qf19JsiQKs3USJG+/E/8YxeUOg4JEDpYaafFKXu
PwxlhBD2+CVA2KQuMaGa6T9VczOECJsnQPzqOWhokuU/Hq9RXTVgKUD+TKWf
jvLhP4Vz8M8YHStA8mEaVz8y3j8Zbhj2ALwsQBftVFod6Nk/LZavgQN+LkAY
c0oKuAPWPzj6Z2AFETBAO5nsveLP0j8ZwK8ylvQwQEZahxdrUs8/Scq3UQLU
MUA7inD4ntfJP49vhMpwpDJAcHekCCyRxT+Vqwh2bIYzQB6MXWwA+cE/soJR
e2pZNECLQ5ajd/a+Px6eWs1DKDVAsYOGfDMduz9KUBtSqgg2QDq69UuZXLc/
jZ2gMBPaNkAMVoQfRdizP4+B3UEJvTdAI+pHQ/sOsD/hqdqf2ps4QAMk/hRZ
kqk/SW2cV65rOUCMt+NpOwalP3HHFUIPTTpA5c5JIbH8oT+wvFOGch87QHsU
WF/3XqA/PvZRF7HtO0CkHnrcYxOeP4zGB9t8zTxABBoUH/cimj/wMYL4Sp49
QJ5Lz42lLJU/FDS0SKaAPkBa8Qw9UvCOP0/RqvIDVD9A1fzec6a0hj9t2bB0
nhFAQEaERszjuII/khVoiQGCQEB6HXNsZ3yCP0KfAcvl6kBApDGGTGSlgz9S
9PalkFxBQLoQc6CrOYM/imtMJynMQUCDK7yINip/P00whNVCNEJAjMebd31m
dD9wwBcdI6VCQObHD1dobGM/H56NkYQOQ0Af+nc01YJUP/WdY6zTdUNAota3
o7D8Wj8raZVg6eVDQNrJZCxpoGg/7IGpQYBOREC7BqzrOU5wPw1mGbzdv0RA
mfHaYsOebj9WbOncKC9FQFpR9iIg02E/KsCbKvWWRUB/HBKQMk03P17fqRGI
B0ZAdjr+yUQNTL8dTJolnHBGQAxJfCBxa0a/PITm0nbiRkAVNq+FXzFEP4Pe
kiY/UkdA8oHO4Q4nYD9VhiGniLpHQLkoc53QbGM/h/kLwZgrSEDStSmvMSJZ
P0W62AcqlUhAgEvQpp+RET8+GeT4//9IQI+Ma6OM4FK/4Y+A8w==
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456427#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0011521695538981057`, 
                 2.5974661904268266`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]],
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{8.47457627118644*^-7, 1.000009134964347}, {
                    0.3386430441913689, 2.5974661904268266`}}], 
                    LineBox[CompressedData["
1:eJwBcQOO/CFib1JlAgAAADYAAAACAAAArlk5uYRaFECbyqJanMcEQCkcpROT
qhdAmK4uuhGCAUBwLA79xCYbQFuMBBvrWf0/EKmJTQBnHkBcxSeDwQD5P1jA
cTS49iBA3dHbPyIW9T9V4qf19JsiQKs3USJG+/E/8YxeUOg4JEDpYaafFKXu
PwxlhBD2+CVA2KQuMaGa6T9VczOECJsnQPzqOWhokuU/Hq9RXTVgKUD+TKWf
jvLhP4Vz8M8YHStA8mEaVz8y3j8Zbhj2ALwsQBftVFod6Nk/LZavgQN+LkAY
c0oKuAPWPzj6Z2AFETBAO5nsveLP0j8ZwK8ylvQwQEZahxdrUs8/Scq3UQLU
MUA7inD4ntfJP49vhMpwpDJAcHekCCyRxT+Vqwh2bIYzQB6MXWwA+cE/soJR
e2pZNECLQ5ajd/a+Px6eWs1DKDVAsYOGfDMduz9KUBtSqgg2QDq69UuZXLc/
jZ2gMBPaNkAMVoQfRdizP4+B3UEJvTdAI+pHQ/sOsD/hqdqf2ps4QAMk/hRZ
kqk/SW2cV65rOUCMt+NpOwalP3HHFUIPTTpA5c5JIbH8oT+wvFOGch87QHsU
WF/3XqA/PvZRF7HtO0CkHnrcYxOeP4zGB9t8zTxABBoUH/cimj/wMYL4Sp49
QJ5Lz42lLJU/FDS0SKaAPkBa8Qw9UvCOP0/RqvIDVD9A1fzec6a0hj9t2bB0
nhFAQEaERszjuII/khVoiQGCQEB6HXNsZ3yCP0KfAcvl6kBApDGGTGSlgz9S
9PalkFxBQLoQc6CrOYM/imtMJynMQUCDK7yINip/P00whNVCNEJAjMebd31m
dD9wwBcdI6VCQObHD1dobGM/H56NkYQOQ0Af+nc01YJUP/WdY6zTdUNAota3
o7D8Wj8raZVg6eVDQNrJZCxpoGg/7IGpQYBOREC7BqzrOU5wPw1mGbzdv0RA
mfHaYsOebj9WbOncKC9FQFpR9iIg02E/KsCbKvWWRUB/HBKQMk03P17fqRGI
B0ZAdjr+yUQNTL8dTJolnHBGQAxJfCBxa0a/PITm0nbiRkAVNq+FXzFEP4Pe
kiY/UkdA8oHO4Q4nYD9VhiGniLpHQLkoc53QbGM/h/kLwZgrSEDStSmvMSJZ
P0W62AcqlUhAgEvQpp+RET8+GeT4//9IQI+Ma6OM4FK/4Y+A8w==
                    "]]}, 
                   Annotation[#, "Charting`Private`Tag$456427#1"]& ]}}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, 
                  "DefaultGraphicsInteraction" -> {
                   "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                  "DefaultMeshStyle" -> AbsolutePointSize[6], 
                  "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 50.}, {-0.0011521695538981057`, 
                 2.5974661904268266`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    InterpolatingFunction[{{0., 50.}}, {
     5, 7, 2, {336}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
      False}, CompressedData["
1:eJwtlok7FHoDhS1Rlil7QnbZwxiDMeZ3ZoaZaRVJuSllbZGlui3S5qJQIstw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     "], {Developer`PackedArrayForm, CompressedData["
1:eJwl03l4DwQYB/CfuWtuahGZ3CUTYRlyTHJfUSQ3zTVHY5Gr3Awlt3KUO2eO
KDlbYRKZCHObVmNUjpyfPd7n+Xz/fZ/n/T5vaOfoFn0zBAKB5ulhMpKF7AST
i7wUIIRCFCGU4pSiLOUIoyKVCSeCmtQmkvo0pEn6PlrRhra0pyNd6E4UvYlm
ADHEMpThjGI045hIHNOYzkzmMJ8FLGYJy1nFGtazkS1sYzs72UM8+0jgEEdI
5DgnSeIcF0kmhVTS+Ieb3OEeDwly28xk40lykof8PE1BClOU5ylJGV6kPC/z
ClWpRg1qUZfXaUBjmtGS1rzNO3SgM914j16kF96f9xnMEIYxko8ZywQmM5VP
mcFs5vEFi/iKZaxkNev4hs1s5Xt2sJsf+ZkD/MJhjvI7f3Cas1zgMn/yN9e4
wX/c5i4PyBAUCGQiK0+Qg9zk4yme4VmeoxglKM0LvEQFKlGFV6nOa9ShHm/Q
iKa04E3eoh3v0omu9KAnfejHQAbxAR8ygo8Yw3gmMYVP+IxZzOVzFvIlS1nB
16xlA5v4lu/4gV3s5Sf2c5Bf+Y1jnOAUZzjPJa7wF1e5zr/c4n/uBz1+/oxk
ITvB5CIvBQihEEUIpTilKEs5wqhIZcKJoCa1iaQ+DWlCc1rRhra0pyNd6E4U
vYlmADHEMpThjGI045hIHNOYzkzmMJ8FLGYJy1nFGtazkS1sYzs72UM8+0jg
EEdI5DgnSeIcF0kmhVTSeAQni6lw
      "], CompressedData["
1:eJwtl2c41w8XxjOTHZKKyEqijMxwvkkpGWWGsilEZiKyZxFC2aJQyt6j8wt/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      "]}, {Automatic}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.9060943689497056`*^9, 3.9060946443957677`*^9, 
  3.9073030465224113`*^9},
 CellLabel->
  "Out[779]=",ExpressionUUID->"84e1c972-aeba-409f-bfb9-1007d1ef92be"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVVnc81f8Xlsyi7CRJvpJKspJ9zh3uvcjI3lnZK0mUea+RmaRIiBKSjDJK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       "]]},
     Annotation[#, "Charting`Private`Tag$456492#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9060943689497056`*^9, 3.9060946443957677`*^9, 
  3.9073030465693808`*^9},
 CellLabel->
  "Out[780]=",ExpressionUUID->"ed4913aa-3425-4121-82a7-6011b1ee68db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", "=", 
  RowBox[{
   RowBox[{"MatrixPower", "[", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {"1", "2"},
        {"7", "13"}
       }], ")"}], ",", 
     FractionBox["1", "5"]}], "]"}], "//", "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", ".", "mat", ".", "mat", ".", "mat", ".", "mat"}], "//", 
  "Chop"}]}], "Input",
 CellChangeTimes->{{3.906094850522415*^9, 3.906094904137085*^9}},
 CellLabel->
  "In[781]:=",ExpressionUUID->"67333e1d-a3c5-43be-aa97-d5419c8072ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.5691634617262573`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.32014693179423653`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.17256009246590126`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.04898558195889979`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.6039603236306542`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.17144953685614922`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.6045240165216648`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.026233440040837854`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9060948777471046`*^9, 3.906094904695555*^9}, 
   3.9073030466094303`*^9},
 CellLabel->
  "Out[782]=",ExpressionUUID->"75d1084a-ef4c-4492-9649-86172e8365bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999997`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.999999999999998`", ",", "13.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9060948777471046`*^9, 3.906094904695555*^9}, 
   3.9073030466169424`*^9},
 CellLabel->
  "Out[783]=",ExpressionUUID->"3aba556d-4b71-4587-8daf-6e09bd3561cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "//", "TreeForm"}]], "Input",
 CellChangeTimes->{{3.9060950291638045`*^9, 3.9060950352084055`*^9}},
 CellLabel->
  "In[784]:=",ExpressionUUID->"385b36b3-2146-4984-b141-a0373d086d58"],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[
   TagBox[
    GraphicsComplexBox[{{0.4472135954999579, 0.8944271909999159}, {0., 0.}, {
     0.8944271909999159, 0.}}, {
      {RGBColor[0.55, 0.45, 0.45], LineBox[{{1, 2}, {1, 3}}]}, {
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          SuperscriptBox["x", "3"], HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x^3], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["3",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            LineColor->GrayLevel[0],
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox["3", HoldForm]],
        Annotation[#, 
         HoldForm[3], "Tooltip"]& ]}}],
    Annotation[#, 
     VertexCoordinateRules -> {{0.4472135954999579, 0.8944271909999159}, {0., 
      0.}, {0.8944271909999159, 0.}}]& ],
   AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
   FormatType:>StandardForm,
   FrameTicks->Automatic,
   ImageSize->{242.93478260869506`, Automatic},
   PlotRange->All,
   PlotRangePadding->Scaled[0.1]],
  TreeForm[$CellContext`x^3],
  Editable->False]], "Output",
 CellChangeTimes->{3.9060950358095827`*^9, 3.907303046640519*^9},
 CellLabel->
  "Out[784]//TreeForm=",ExpressionUUID->"83c80af3-8b9c-49e9-a3eb-\
1f14996698d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Sin", "]"}]], "Input",
 CellChangeTimes->{{3.90609505385365*^9, 3.9060950857796373`*^9}},
 CellLabel->
  "In[785]:=",ExpressionUUID->"6f92284e-0f8c-49a3-a063-e7e29c1167d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9060950607492*^9, 3.906095086283224*^9}, 
   3.9073030466514454`*^9},
 CellLabel->
  "Out[785]=",ExpressionUUID->"9e7faeea-d0e6-4c98-bb32-86d8fbdb1690"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9060950727906003`*^9, 3.9060950778825827`*^9}},
 CellLabel->
  "In[786]:=",ExpressionUUID->"b45460fb-cf8b-496c-ad5f-ccfb3cad30f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "a", "]"}], ",", 
   RowBox[{"Sin", "[", "b", "]"}], ",", 
   RowBox[{"Sin", "[", "c", "]"}], ",", 
   RowBox[{"Sin", "[", "d", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9060950788325777`*^9, 3.9073030466644487`*^9},
 CellLabel->
  "Out[786]=",ExpressionUUID->"d302ca64-6373-4530-98d5-39e37e42b3f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.906095098223176*^9, 3.9060951039723644`*^9}},
 CellLabel->
  "In[787]:=",ExpressionUUID->"6a980b7e-096c-4ae6-9bb1-8b7e5cf4f70e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "a", "]"}], ",", 
   RowBox[{"Sin", "[", "b", "]"}], ",", 
   RowBox[{"Sin", "[", "c", "]"}], ",", 
   RowBox[{"Sin", "[", "d", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9060951047108517`*^9, 3.9073030466800823`*^9},
 CellLabel->
  "Out[787]=",ExpressionUUID->"16fc9655-ef87-4779-9d3b-79100bc79454"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matM", "=", 
  SuperscriptBox[
   RowBox[{"(", GridBox[{
      {"1", "2"},
      {"7", "13"}
     }], ")"}], 
   FractionBox["1", "5"]]}]], "Input",
 CellChangeTimes->{{3.906095015394388*^9, 3.906095017498745*^9}, {
  3.9060951470232153`*^9, 3.906095149723752*^9}},
 CellLabel->
  "In[788]:=",ExpressionUUID->"7d0128bc-f3a6-4d0f-8c68-e404a2dd1ebf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["7", 
      RowBox[{"1", "/", "5"}]], ",", 
     SuperscriptBox["13", 
      RowBox[{"1", "/", "5"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9060950177816305`*^9, 3.9060951506095324`*^9, 
  3.907303046695716*^9},
 CellLabel->
  "Out[788]=",ExpressionUUID->"fcef875f-4c1e-452c-8ce4-e3ae425b1934"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matM", "*", "matM", "*", "matM", "*", "matM", "*", 
  "matM"}]], "Input",
 CellChangeTimes->{{3.9060951514183903`*^9, 3.9060951653322024`*^9}},
 CellLabel->
  "In[789]:=",ExpressionUUID->"cc7bd83a-0562-4809-9880-ab19dd6afcf1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "13"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.906095165601453*^9, 3.907303046695716*^9},
 CellLabel->
  "Out[789]=",ExpressionUUID->"badffb52-573b-4818-8938-9af6e5701b10"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Method", "->", "\"\<DifferentialEvolution\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"pom", "=", 
  RowBox[{"NMaximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.906095216400532*^9, 3.9060952510756907`*^9}, {
  3.9060953517408276`*^9, 3.906095390531415*^9}},
 CellLabel->
  "In[790]:=",ExpressionUUID->"e4f5e520-c6d5-4a8c-a227-b70008d31d14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.236067985266875`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.4472134065073133`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8944272893797809`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9060952521596327`*^9, 3.9060953912427793`*^9, 
  3.9073030468214717`*^9},
 CellLabel->
  "Out[790]=",ExpressionUUID->"b7b8d2e5-95e8-4387-bab2-6c33f728dafc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2360679786324718`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.44721622493105484`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.8944258768507084`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9060952521596327`*^9, 3.9060953912427793`*^9, 
  3.9073030468535895`*^9},
 CellLabel->
  "Out[791]=",ExpressionUUID->"38bb2e8d-1b9d-4b9a-9515-c4e06f5f220b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "/.", 
  RowBox[{"pom", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.906095399071911*^9, 3.906095424123128*^9}},
 CellLabel->
  "In[792]:=",ExpressionUUID->"7568d302-9edf-4887-a328-fe6b69b2ed6d"],

Cell[BoxData["0.8944258768507084`"], "Output",
 CellChangeTimes->{{3.9060954174660864`*^9, 3.9060954247334166`*^9}, 
   3.9073030468714514`*^9},
 CellLabel->
  "Out[792]=",ExpressionUUID->"b3c56185-fdf2-4f64-b4dc-95d4b4687cab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "/."}]], "Input",
 CellChangeTimes->{{3.9060954424988785`*^9, 3.9060954434421115`*^9}},
 CellLabel->
  "In[793]:=",ExpressionUUID->"1673b715-f221-4ede-9679-3e61d64f65c3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"]], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"]]}, Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              
              ButtonData->
               "http://reference.wolfram.com/language/ref/ReplaceAll.html",
              
              ButtonNote->
               "http://reference.wolfram.com/language/ref/ReplaceAll.html"],
             "\"http://reference.wolfram.com/language/ref/ReplaceAll.html\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"\\!\\(\\*RowBox[{StyleBox[\\\"expr\\\", \
\\\"TI\\\"], \\\"/.\\\", StyleBox[\\\"rules\\\", \\\"TI\\\"]}]\\) or \
\\!\\(\\*RowBox[{\\\"ReplaceAll\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"rules\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) applies a rule or list \
of rules in an attempt to transform each subpart of an expression \
\\!\\(\\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\\). \
\\n\\!\\(\\*RowBox[{\\\"ReplaceAll\\\", \\\"[\\\", StyleBox[\\\"rules\\\", \\\
\"TI\\\"], \\\"]\\\"}]\\) represents an operator form of ReplaceAll that can \
be applied to an expression.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Documentation\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Documentation\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Documentation", "Tooltip"]& ], 
                   TemplateBox[{
                    TemplateBox[{"\"Web \[RightGuillemet]\"", {
                    URL[
                    "http://reference.wolfram.com/language/ref/ReplaceAll.\
html"], None}, "http://reference.wolfram.com/language/ref/ReplaceAll.html", 
                    "Hyperlink", {
                    RGBColor[0.9686274509803922, 0.4666666666666667, 0.]}, 
                    BaseStyle -> {
                    RGBColor[0.0784313725490196, 0.1568627450980392, 0.6]}}, 
                    "HyperlinkTemplate"]},
                    "RowDefault"]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`ReplaceAll\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"],
                ImageSizeCache->{29.9, {9., 20.9}}], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"],
                ImageSizeCache->{29.9, {9., 20.9}}]}, Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              
              ButtonData->
               "http://reference.wolfram.com/language/ref/ReplaceAll.html",
              
              ButtonNote->
               "http://reference.wolfram.com/language/ref/ReplaceAll.html"],
             "\"http://reference.wolfram.com/language/ref/ReplaceAll.html\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"\\!\\(\\*RowBox[{StyleBox[\\\"expr\\\", \
\\\"TI\\\"], \\\"/.\\\", StyleBox[\\\"rules\\\", \\\"TI\\\"]}]\\) or \
\\!\\(\\*RowBox[{\\\"ReplaceAll\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"rules\\\", \\\"TI\\\"]}], \\\"]\\\"}]\\) applies a rule or list \
of rules in an attempt to transform each subpart of an expression \
\\!\\(\\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\\). \
\\n\\!\\(\\*RowBox[{\\\"ReplaceAll\\\", \\\"[\\\", StyleBox[\\\"rules\\\", \\\
\"TI\\\"], \\\"]\\\"}]\\) represents an operator form of ReplaceAll that can \
be applied to an expression.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{23., {7., 16.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{23., {7., 16.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"/.\", StyleBox[\"rules\", \
\"TI\"]}]\) or \!\(\*RowBox[{\"ReplaceAll\", \"[\", \
RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"]}], \"]\
\"}]\) applies a rule or list of rules in an attempt to transform each \
subpart of an expression \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\
\"ReplaceAll\", \"[\", StyleBox[\"rules\", \"TI\"], \"]\"}]\) represents an \
operator form of ReplaceAll that can be applied to an expression.", 
    "Documentation" -> <|
     "Web" -> "http://reference.wolfram.com/language/ref/ReplaceAll.html"|>, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "System`ReplaceAll"|>, False]]], "Output",
 CellChangeTimes->{3.906095444057108*^9, 3.9073030469102116`*^9},
 CellLabel->
  "Out[793]=",ExpressionUUID->"c78fccd2-563f-4f59-b662-208f5dd022be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pom", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"NMaximize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "+", 
           RowBox[{"2", "y"}]}], ",", 
          RowBox[{
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], "==", "#"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", "10", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9060954923073387`*^9, 3.9060955166154594`*^9}},
 CellLabel->
  "In[794]:=",ExpressionUUID->"449bd336-7e55-487a-acdf-415d0f143f23"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2.2360679786324718`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "0.44721622493105484`"}], ",", 
         RowBox[{"y", "\[Rule]", "0.8944258768507084`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3.1622776616407675`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "0.6324581419049793`"}], ",", 
         RowBox[{"y", "\[Rule]", "1.264909759867894`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"3.872983346713453`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "0.774601146008669`"}], ",", 
         RowBox[{"y", "\[Rule]", "1.5491911003523922`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"4.47213595499958`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "0.894427190999916`"}], ",", 
         RowBox[{"y", "\[Rule]", "1.7888543819998317`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"5.000000000893092`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.0000048566637019`"}], ",", 
         RowBox[{"y", "\[Rule]", "1.9999975721146952`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{"5.477225578041221`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.0954515674148788`"}], ",", 
         RowBox[{"y", "\[Rule]", "2.190887005313171`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{"5.916079784598858`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.1832232958004951`"}], ",", 
         RowBox[{"y", "\[Rule]", "2.3664282443991813`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"{", 
      RowBox[{"6.324555320674013`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.2649192970327452`"}], ",", 
         RowBox[{"y", "\[Rule]", "2.529818011820634`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{"6.708203932499369`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.3416407864998736`"}], ",", 
         RowBox[{"y", "\[Rule]", "2.6832815729997477`"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"7.0710678118654755`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "\[Rule]", "1.4142135623730951`"}], ",", 
         RowBox[{"y", "\[Rule]", "2.8284271247461903`"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9060955170722036`*^9, 3.9073030472164483`*^9},
 CellLabel->
  "Out[794]=",ExpressionUUID->"d86bf9ff-d219-440f-850f-3399d16dda8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"pom", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "_"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9060955476796064`*^9, 3.906095571421055*^9}},
 CellLabel->
  "In[795]:=",ExpressionUUID->"c98cdaae-993d-4334-b532-7833eedfb3f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"4", ",", 
    RowBox[{"{", 
     RowBox[{"4.47213595499958`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "0.894427190999916`"}], ",", 
        RowBox[{"y", "\[Rule]", "1.7888543819998317`"}]}], "}"}]}], "}"}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.906095563316411*^9, 3.9060955720711937`*^9}, 
   3.90730304723213*^9},
 CellLabel->
  "Out[795]=",ExpressionUUID->"d8d83e78-01b4-47f3-b2f2-7465aa64a2b9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  RowBox[{"(*", "koment", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<teploty.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{"teploty", ",", "5"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Flatten", "[", "teploty", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"First", "/@", "teploty"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "/.", 
   RowBox[{
    RowBox[{"{", "T_", "}"}], ":>", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "1"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "teploty", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ">>", "\"\<teploty\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.906090434663175*^9, 3.9060904443443313`*^9}, 
   3.9060905392644854`*^9, {3.9060906062591085`*^9, 3.9060906122392397`*^9}, {
   3.906695370082594*^9, 3.906695417225071*^9}, {3.9066954762951717`*^9, 
   3.906695571288802*^9}, {3.906695601583294*^9, 3.9066956038357954`*^9}, {
   3.9066956553617935`*^9, 3.906695657135125*^9}, {3.9066957295132704`*^9, 
   3.9066957831654005`*^9}, {3.906695814504179*^9, 3.9066958150846443`*^9}, {
   3.906695852739005*^9, 3.9066960038333607`*^9}, {3.9066960893170714`*^9, 
   3.9066961953011203`*^9}},
 CellLabel->
  "In[796]:=",ExpressionUUID->"70269f7d-9aa8-43f8-ad3b-b8e248ca6ad4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{"<<", "\"\<teploty\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "15"}], "<", "T", "<=", 
        RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], "<", "T", "<=", 
          RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], "<", "T", "<=", 
            RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9066961990703974`*^9, 3.906696213101059*^9}, 
   3.9066962613949904`*^9, {3.9066963319443507`*^9, 3.906696355893758*^9}, 
   3.906696745618927*^9},
 CellLabel->
  "In[807]:=",ExpressionUUID->"ede5addb-4f52-4997-ab1b-d7e9188dd84a"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "P1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P1", "[", "T_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
      RowBox[{"T", "<=", 
       RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "15"}], "<", "T", "<=", 
      RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "12"}], "<", "T", "<=", 
      RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "8"}], "<", "T", "<=", 
      RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"T", ">", "13"}], ",", "0"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9066967542657413`*^9, 3.906696756915265*^9}, {
  3.9066968139296494`*^9, 3.9066968799889617`*^9}, {3.9066969764860725`*^9, 
  3.9066970088829374`*^9}, {3.9066970566422925`*^9, 3.9066970770220685`*^9}, {
  3.9066973925995145`*^9, 3.906697394561235*^9}},
 CellLabel->
  "In[809]:=",ExpressionUUID->"512a6cc5-5dad-46de-ae8a-8876371c5eb0"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.90669718031026*^9, 3.9066971982321405`*^9}},
 CellLabel->
  "In[811]:=",ExpressionUUID->"e15bb4f7-7940-4728-9894-b63384618db8"],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"20", "/;", 
    RowBox[{"T", "<=", 
     RowBox[{"-", "15"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"15", "/;", 
    RowBox[{
     RowBox[{"-", "15"}], "<", "T", "<=", 
     RowBox[{"-", "12"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"12", "/;", 
    RowBox[{
     RowBox[{"-", "12"}], "<", "T", "<=", 
     RowBox[{"-", "8"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"9", "/;", 
    RowBox[{
     RowBox[{"-", "8"}], "<", "T", "<=", 
     RowBox[{"-", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"5", "/;", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "T", "<=", "5"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"3", "/;", 
    RowBox[{"5", "<", "T", "<=", "13"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "T_", "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{"13", "<", "T"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.9066970885086465`*^9, {3.9066971722569304`*^9, 3.9066973660321913`*^9}},
 CellLabel->
  "In[812]:=",ExpressionUUID->"50859fe7-d76d-4fc8-bdfd-32411248c306"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"#", "[", "T", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"P", ",", "P1"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.906696569716881*^9, 3.906696602172228*^9}, {
   3.9066966336737566`*^9, 3.9066966356459117`*^9}, 3.906696728497165*^9, 
   3.906696882488535*^9, {3.906697404795105*^9, 3.9066974326235113`*^9}, 
   3.906697483946904*^9},
 CellLabel->
  "In[820]:=",ExpressionUUID->"6b857406-5b4c-4dc6-860f-c85643b6a767"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"P3", "[", "T_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"Reverse", "/@", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "Infinity"}], "<", "T"}], "&&", 
          RowBox[{"T", "<=", 
           RowBox[{"-", "15"}]}]}], ",", "20", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", "15"}], "<", "T", "<=", 
          RowBox[{"-", "12"}]}], ",", "15", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", "12"}], "<", "T", "<=", 
          RowBox[{"-", "8"}]}], ",", "12", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", "8"}], "<", "T", "<=", 
          RowBox[{"-", "2"}]}], ",", "9", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", "2"}], "<", "T", "<=", "5"}], ",", "5", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"5", "<", "T", "<=", "13"}], ",", "3", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"T", ">", "13"}], ",", "0"}], "}"}], ",", "2"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"#", "[", "T", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"P", ",", "P1", ",", "P3"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9066974928783913`*^9, 3.906697494196969*^9}, {
  3.9066976109927344`*^9, 3.906697697105623*^9}},
 CellLabel->
  "In[821]:=",ExpressionUUID->"f3078d6d-2edf-48e7-8eea-e986b895ea6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"teploty", ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.906697862396234*^9, 3.9066978833856936`*^9}, {
  3.9066979435269117`*^9, 3.9066979787721043`*^9}, {3.9066980135924377`*^9, 
  3.906698016167823*^9}, {3.9066980547315855`*^9, 3.90669806719362*^9}},
 CellLabel->
  "In[823]:=",ExpressionUUID->"045c2ab7-1d9b-44be-a4a9-873f64f19005"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.9066982132884164`*^9, 3.9066982188127604`*^9}},
 CellLabel->
  "In[824]:=",ExpressionUUID->"639bd85e-07a9-489e-a6df-70cbf34641ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.906698219095727*^9, 3.907303047658004*^9},
 CellLabel->
  "Out[824]=",ExpressionUUID->"a22295f0-77d6-4391-b2f0-f5dc6c1bdaa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "5.", "]"}]], "Input",
 CellChangeTimes->{{3.9066986218305855`*^9, 3.906698632884362*^9}},
 CellLabel->
  "In[825]:=",ExpressionUUID->"e5e44c11-6fa8-4612-a7bc-aa830e6c6a6d"],

Cell[BoxData["Real"], "Output",
 CellChangeTimes->{{3.9066986239504185`*^9, 3.906698633590355*^9}, 
   3.907303047673007*^9},
 CellLabel->
  "Out[825]=",ExpressionUUID->"50259d9e-05ff-422f-a1a7-ff56a47acb55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.906698716927916*^9, 3.9066987204582567`*^9}},
 CellLabel->
  "In[826]:=",ExpressionUUID->"d258c835-0ebe-46a1-8d34-69be94858f48"],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
9986280348253421170679821480865191976`100."], "Output",
 CellChangeTimes->{3.9066987209602585`*^9, 3.907303047683025*^9},
 CellLabel->
  "Out[826]=",ExpressionUUID->"a7426422-10c7-41ed-a203-004df7e75736"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "5", "]"}], ",", "50"}], "]"}]], "Input",
 CellChangeTimes->{{3.906698696818734*^9, 3.9066987139299865`*^9}},
 CellLabel->
  "In[827]:=",ExpressionUUID->"30d29b19-3dba-4c66-84aa-cb3412e60923"],

Cell[BoxData[
 RowBox[{"-", 
  "0.9589242746631384688931544061559939733524615439646017781316724542351025580\
8655`50."}]], "Output",
 CellChangeTimes->{{3.9066986984941225`*^9, 3.906698714322855*^9}, 
   3.907303047689027*^9},
 CellLabel->
  "Out[827]=",ExpressionUUID->"8a2b9ad3-dc45-4fa9-9616-dd86d35ecc67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "5.", "]"}]], "Input",
 CellChangeTimes->{{3.9066985874709063`*^9, 3.906698589478978*^9}, 
   3.906698645092738*^9},
 CellLabel->
  "In[828]:=",ExpressionUUID->"9970468b-8552-4b0e-8733-120d7384db44"],

Cell[BoxData[
 RowBox[{"-", "0.9589242746631385`"}]], "Output",
 CellChangeTimes->{3.9073030477116575`*^9},
 CellLabel->
  "Out[828]=",ExpressionUUID->"39444235-a84c-4305-81ca-11aa1663f460"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9589242746631385`"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.90669866152089*^9, 3.90669866152089*^9}},
 CellLabel->
  "In[829]:=",ExpressionUUID->"ee5f5fe7-67f0-4ce1-94c3-bbef3a105e44"],

Cell[BoxData[
 RowBox[{"-", "0.9589242746631385`"}]], "Output",
 CellChangeTimes->{3.9073030477206593`*^9},
 CellLabel->
  "Out[829]=",ExpressionUUID->"b97ea1aa-f0b7-49fc-aca4-ade8c64cd09d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"hodinoveEnergie", "=", 
   RowBox[{"P", "/@", "teploty"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "teploty", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodinoveEnergie", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"teploty", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"energieCelkem", "=", 
   RowBox[{"Total", "[", "hodinoveEnergie", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<energie= \>\"", ",", 
   FractionBox[
    RowBox[{"energieCelkem", "*", "3600."}], 
    SuperscriptBox["10", "6"]], ",", "\"\< GJ\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.9066981758529806`*^9, 3.906698209656129*^9}, {
  3.9066982502925873`*^9, 3.906698291069354*^9}, {3.906698349522029*^9, 
  3.9066983644046755`*^9}, {3.9066984318874807`*^9, 3.9066984956220527`*^9}},
 CellLabel->
  "In[830]:=",ExpressionUUID->"3dfd0eb4-7a6e-4624-9bf2-9258a8351792"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"energie= \"\>", "\[InvisibleSpace]", "74.5632`", 
   "\[InvisibleSpace]", "\<\" GJ\"\>"}],
  SequenceForm["energie= ", 74.5632, " GJ"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9066984905633326`*^9, 3.90669849647584*^9}, 
   3.9073030477993608`*^9},
 CellLabel->
  "During evaluation of \
In[830]:=",ExpressionUUID->"a12c0f7a-5bb5-4a2c-bb1f-8bafffe0a09d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "NIntegrate", "]"}]], "Input",
 CellChangeTimes->{{3.906698581348485*^9, 3.906698582532854*^9}, {
  3.906699362581375*^9, 3.9066993652546463`*^9}},
 CellLabel->
  "In[835]:=",ExpressionUUID->"3bf7bd06-68e6-4db9-a8b5-8aae16c7381b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AccuracyGoal", "\[Rule]", "\[Infinity]"}], ",", 
   RowBox[{"Compiled", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"EvaluationMonitor", "\[Rule]", "None"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
   RowBox[{"MaxPoints", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Method", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MinRecursion", "\[Rule]", "0"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.906699366043585*^9, 3.907303047815369*^9},
 CellLabel->
  "Out[835]=",ExpressionUUID->"a3762bba-cb6d-435c-b5b4-7acdb03c004a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataProInterpolaci", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "-", "1"}], ")"}], "*", "3600."}], ",", 
       RowBox[{"teploty", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intTeplota", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"dataProInterpolaci", ",", 
     RowBox[{"InterpolationOrder", "->", "0"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"intTeplota", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"energiInt", "=", 
  RowBox[{"Quiet", "@", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"intTeplota", "[", "t", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.9066989863495593`*^9, 3.9066990718410316`*^9}, {
  3.906699124032447*^9, 3.906699137908478*^9}, {3.906699189345332*^9, 
  3.906699305122716*^9}, {3.90669938725215*^9, 3.906699388586896*^9}},
 CellLabel->
  "In[836]:=",ExpressionUUID->"6c7aa381-d3e6-48f5-ab1e-7a418eac01e7"],

Cell[BoxData["7.230282013017038`*^7"], "Output",
 CellChangeTimes->{3.9066993057822304`*^9, 3.9066993892610188`*^9, 
  3.9073030480052867`*^9},
 CellLabel->
  "Out[839]=",ExpressionUUID->"b4f146a0-8d9f-45f4-9783-5b2251bfe2b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "NDSolve", "]"}]], "Input",
 CellChangeTimes->{{3.9066995286555214`*^9, 3.906699532423345*^9}},
 CellLabel->
  "In[840]:=",ExpressionUUID->"e60b3634-4211-463d-abb5-0691a392a808"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AccuracyGoal", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Compiled", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"DependentVariables", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"DiscreteVariables", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"EvaluationMonitor", "\[Rule]", "None"}], ",", 
   RowBox[{"InitialSeeding", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MaxStepFraction", "\[Rule]", 
    FractionBox["1", "10"]}], ",", 
   RowBox[{"MaxSteps", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MaxStepSize", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Method", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"NormFunction", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"StartingStepSize", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"StepMonitor", "\[Rule]", "None"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.906699532768939*^9, 3.9073030480212965`*^9},
 CellLabel->
  "Out[840]=",ExpressionUUID->"9434154e-dc52-4150-958f-596d36d17c1d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
        RowBox[{"P", "[", 
         RowBox[{"intTeplota", "[", "t", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"e", "[", "tmin", "]"}], "==", "0"}]}], "}"}], ",", "e", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}], ",", 
     RowBox[{"MaxStepSize", "->", "50"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "[", "tmax", "]"}], "/.", "sol"}]}], "Input",
 CellChangeTimes->{{3.9066994560099564`*^9, 3.90669951777334*^9}, {
  3.9066995478777266`*^9, 3.906699572390378*^9}},
 CellLabel->
  "In[841]:=",ExpressionUUID->"01a9118d-564b-474b-a13c-66bb5ac2b037"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", "\[Rule]", 
   TagBox[
    TemplateBox[{
      RowBox[{
        StyleBox[
         TagBox["InterpolatingFunction", "SummaryHead"], 
         "NonInterpretableSummary"], 
        StyleBox["[", "NonInterpretableSummary"], 
        DynamicModuleBox[{
         Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
         TemplateBox[{
           TemplateBox[{
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFx20w2wcAx/GImlZrq3TpWVe1tG4n2q6qimocv6kOpZSIxKyCahRBVJ5I
UiT/eNZ01mWoTbqeFl2mbu1Gn3bsalZVfXCTlNQ8zM3YuBSZnnbbG15873sf
WlJWVAqZRCIx/uv/P7J7Vbl3y2/+6kr53G2uTUDej61N3QnO4F7Yo21NDwRj
xs2qh+2O3M0DPv3aj6E7qtcfD/FBYDdtdz4pBfrb+5vs1gXgirt3r84qDZ3c
xoFBHEKDmXSmOTETSzHScLVHMEyWN4097QJMxZq+ahSH4fBfiVu3ugrR6dx6
I50ZiQB13beqUAl0jO1d5uAoxFW9/lrxRIqhhGHGdR4TB6Z6hMP380G/GhJ/
MomFTUsLxrQsBY6kH2p3jmbD7bD14y88CtDjXqKkZMbhnp7e/chUAI6z3Pzi
RDyMYs+mcl4hgt6+2b9RfRx3e37QbZsvhPWdLmHtUS5SSHHX/T2LwFeTWS7B
iagpcrkwmlEEm8cT07+wkhDbSa3q26DE+2061qnoZERXLg+3lCohpJLFLikn
ELfz4HjDayU+aKPfGBOkgK75tEMbrkL2GP3n2oyTmKuaMQVUqDCi7dNkynhw
i7/Gab6ogmHkyC7fvFTM2jaPjbeo4Jes+X3d6VNwbZviz/2kwsNUaexCQRqK
ta0DVLMKU+SDdUZZ+oo93tOdf1aZseIJUZ9+pIYP+4iwiG/+UYGW9LR2uDoT
DaKhiUkygfJ+hd/ixSyE7jUb+u0I3P2jgLMmMhtd8geTQU4EZmwbd7zVu+o2
nlPIlSgBNpP9eb40ArccrNh+/QIwhbQFjg+BT5a9OrnsHNwKml+4xCTw4T4D
teDXVQ/ZPJfQmKfRdx+iGjYB+y3e3seerVopeWmScXJXrHGkjHqN5oK2Xa5g
ZhOIiql4kZMqRAVfu6i7RoAzlDPbPCEEI6H2KqYJLF5q+UjAF0G9Wzlr9lfD
8H1kyb5pEW4+IWLDBtXI5nEGxali6M7mVBfaFONL9nfK0L/FqG8SyBc9i+Hw
Wb7jO3wJOtLC83rrivGuw/m1onkJFLb66tm0EhjdKGtj8qUQcUeoltJSmKpe
zu6xSLEthCNjOZZB4um9v+ZMHpYayiyXyeWIdXme9Go5D53ZXpct9eV4EGP4
c06dj0CR76jHZAUsO7xVPHsZ4h8OtUdsqkIqw+oNQ5kMXmuSq+9IzyLrc6ex
QYocCuoGa8ouDTp8G5uenpPDddx2/cZlDQ5M5iyyKArUO67feezeOfwLkB/B
/w==
                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$458529#1"]& ]}}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{{}, {}}, {{}, {}}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 3.15324*^7}, {0., 
                    7.455239476083608*^7}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "3.15324`*^7"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFx20w2wcAx/GImlZrq3TpWVe1tG4n2q6qimocv6kOpZSIxKyCahRBVJ5I
UiT/eNZ01mWoTbqeFl2mbu1Gn3bsalZVfXCTlNQ8zM3YuBSZnnbbG15873sf
WlJWVAqZRCIx/uv/P7J7Vbl3y2/+6kr53G2uTUDej61N3QnO4F7Yo21NDwRj
xs2qh+2O3M0DPv3aj6E7qtcfD/FBYDdtdz4pBfrb+5vs1gXgirt3r84qDZ3c
xoFBHEKDmXSmOTETSzHScLVHMEyWN4097QJMxZq+ahSH4fBfiVu3ugrR6dx6
I50ZiQB13beqUAl0jO1d5uAoxFW9/lrxRIqhhGHGdR4TB6Z6hMP380G/GhJ/
MomFTUsLxrQsBY6kH2p3jmbD7bD14y88CtDjXqKkZMbhnp7e/chUAI6z3Pzi
RDyMYs+mcl4hgt6+2b9RfRx3e37QbZsvhPWdLmHtUS5SSHHX/T2LwFeTWS7B
iagpcrkwmlEEm8cT07+wkhDbSa3q26DE+2061qnoZERXLg+3lCohpJLFLikn
ELfz4HjDayU+aKPfGBOkgK75tEMbrkL2GP3n2oyTmKuaMQVUqDCi7dNkynhw
i7/Gab6ogmHkyC7fvFTM2jaPjbeo4Jes+X3d6VNwbZviz/2kwsNUaexCQRqK
ta0DVLMKU+SDdUZZ+oo93tOdf1aZseIJUZ9+pIYP+4iwiG/+UYGW9LR2uDoT
DaKhiUkygfJ+hd/ixSyE7jUb+u0I3P2jgLMmMhtd8geTQU4EZmwbd7zVu+o2
nlPIlSgBNpP9eb40ArccrNh+/QIwhbQFjg+BT5a9OrnsHNwKml+4xCTw4T4D
teDXVQ/ZPJfQmKfRdx+iGjYB+y3e3seerVopeWmScXJXrHGkjHqN5oK2Xa5g
ZhOIiql4kZMqRAVfu6i7RoAzlDPbPCEEI6H2KqYJLF5q+UjAF0G9Wzlr9lfD
8H1kyb5pEW4+IWLDBtXI5nEGxali6M7mVBfaFONL9nfK0L/FqG8SyBc9i+Hw
Wb7jO3wJOtLC83rrivGuw/m1onkJFLb66tm0EhjdKGtj8qUQcUeoltJSmKpe
zu6xSLEthCNjOZZB4um9v+ZMHpYayiyXyeWIdXme9Go5D53ZXpct9eV4EGP4
c06dj0CR76jHZAUsO7xVPHsZ4h8OtUdsqkIqw+oNQ5kMXmuSq+9IzyLrc6ex
QYocCuoGa8ouDTp8G5uenpPDddx2/cZlDQ5M5iyyKArUO67feezeOfwLkB/B
/w==
                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$458529#1"]& ]}}, {}}, {
                    DisplayFunction -> Identity, 
                    Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
                    FrameTicks -> {{{}, {}}, {{}, {}}}, 
                    GridLines -> {None, None}, DisplayFunction -> Identity, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                    PlotRange -> {{0., 3.15324*^7}, {0., 
                    7.455239476083608*^7}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "3.15324`*^7"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
            "SummaryPanel"], 
           ButtonBox[
            DynamicBox[
             ToBoxes[
              If[
               
               Or[$VersionNumber < 11.2, CurrentValue["RunningEvaluator"] =!= 
                "Local"], 
               Style["This object cannot be used as input.", "SummaryEmbed"], 
               BoxForm`EmbedSummaryLabel[InterpolatingFunction, 20520920, 
                Dynamic[Typeset`embedState$$], Automatic]], StandardForm]], 
            ButtonFunction :> 
            BoxForm`EmbedSummaryInterpretation[
             "Choose", InterpolatingFunction, 20520920, 
              10225887730404479741648797530700272225724922696836161930576, 
              EvaluationBox[], 
              Dynamic[Typeset`embedState$$], StandardForm, 
              ElisionsDump`embedSummaryBoxes], DefaultBaseStyle -> 
            "SummaryEmbedButton", ImageSize -> Inherited, 
            BaseStyle -> {"DialogStyle"}, Enabled -> Dynamic[
              
              And[$VersionNumber >= 11.2, CurrentValue["RunningEvaluator"] === 
               "Local", Typeset`embedState$$ === "Ready"]], Appearance -> 
            Inherited, Method -> Inherited, Evaluator -> Automatic]}, 
          "SummaryEmbedGrid"], DynamicModuleValues :> {}], 
        StyleBox["]", "NonInterpretableSummary"]}]},
     "CopyTag",
     DisplayFunction->(#& ),
     InterpretationFunction->(
      "                                      7\nInterpolatingFunction[{{0., \
3.15324 10 }}, <>]"& )],
    False,
    BoxID -> 10225887730404479741648797530700272225724922696836161930576,
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.906699492753912*^9, 3.906699518511199*^9}, {
   3.906699555221223*^9, 3.9066995766970887`*^9}, 3.9073030518536787`*^9},
 CellLabel->
  "Out[841]=",ExpressionUUID->"13496c5d-3cd6-4e65-9e36-74a0cdbe8f8a"],

Cell[BoxData["7.455239743307337`*^7"], "Output",
 CellChangeTimes->{{3.906699492753912*^9, 3.906699518511199*^9}, {
   3.906699555221223*^9, 3.9066995766970887`*^9}, 3.907303051932299*^9},
 CellLabel->
  "Out[842]=",ExpressionUUID->"999fd085-c1c3-4b04-844a-0abd566cff0b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  RowBox[{"(*", "koment", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FileNames", "[", "\"\<*.xls\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mereni", "=", 
   RowBox[{"First", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Import", "[", "\"\<DataStatistika.xls\>\"", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.906699647762885*^9, 3.9066997030354905`*^9}},
 CellLabel->
  "In[843]:=",ExpressionUUID->"2d92d2f4-55d7-4c1e-a419-3ed63f57f1f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", "2"}]], "Input",
 CellChangeTimes->{{3.906699786664654*^9, 3.906699795063279*^9}},
 CellLabel->
  "In[848]:=",ExpressionUUID->"e94e1f6d-2455-49fb-a2aa-ecd8e2ec8633"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", "a"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "c"}]}], "}"}]], "Output",
 CellChangeTimes->{3.906699795394561*^9, 3.907303052027043*^9},
 CellLabel->
  "Out[848]=",ExpressionUUID->"420795de-2fc0-43fe-af18-d68b5fc05e8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "2"]], "Input",
 CellChangeTimes->{{3.90669982907685*^9, 3.9066998337878933`*^9}},
 CellLabel->
  "In[849]:=",ExpressionUUID->"79595480-44fa-4943-b07c-0136e1a30a69"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["a", "2"], ",", 
   SuperscriptBox["b", "2"], ",", 
   SuperscriptBox["c", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.9066998340383267`*^9, 3.907303052043104*^9},
 CellLabel->
  "Out[849]=",ExpressionUUID->"56852b2e-190f-43e2-a254-0bfbf4978ed1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"Total", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"mereni", "-", 
      RowBox[{"Mean", "[", "mereni", "]"}]}], ")"}], "2"], "]"}], 
  RowBox[{
   RowBox[{"Length", "[", "mereni", "]"}], "-", "1"}]]], "Input",
 CellChangeTimes->{{3.906699815738872*^9, 3.906699862533703*^9}},
 CellLabel->
  "In[850]:=",ExpressionUUID->"57cb1ca1-0a2f-4a03-a7ab-c3c1507ab6ef"],

Cell[BoxData["212.2146299699517`"], "Output",
 CellChangeTimes->{{3.906699822416539*^9, 3.9066998634620867`*^9}, 
   3.907303052058608*^9},
 CellLabel->
  "Out[850]=",ExpressionUUID->"f1c8f2d2-7ed4-49ab-9ccc-9afcef343812"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", "mereni", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", "mereni", "]"}], "\[IndentingNewLine]", 
 RowBox[{"StandardDeviation", "[", "mereni", "]"}], "\[IndentingNewLine]", 
 SqrtBox[
  RowBox[{"Variance", "[", "mereni", "]"}]]}], "Input",
 CellChangeTimes->{{3.9066997084393826`*^9, 3.9066997475891566`*^9}},
 CellLabel->
  "In[851]:=",ExpressionUUID->"15211551-3932-4f31-950e-39447a6c1068"],

Cell[BoxData[
 RowBox[{"-", "0.517620406208032`"}]], "Output",
 CellChangeTimes->{{3.906699714165866*^9, 3.906699748208376*^9}, 
   3.907303052074235*^9},
 CellLabel->
  "Out[851]=",ExpressionUUID->"6c963a0f-1ac6-4835-b281-3448c095c921"],

Cell[BoxData["212.21462996995172`"], "Output",
 CellChangeTimes->{{3.906699714165866*^9, 3.906699748208376*^9}, 
   3.907303052074235*^9},
 CellLabel->
  "Out[852]=",ExpressionUUID->"3f81fdd4-9c71-4ed0-8a2c-83c7adbb6e9a"],

Cell[BoxData["14.567588337468619`"], "Output",
 CellChangeTimes->{{3.906699714165866*^9, 3.906699748208376*^9}, 
   3.907303052089858*^9},
 CellLabel->
  "Out[853]=",ExpressionUUID->"2f353d47-cc87-4337-bad5-7b83dcd81347"],

Cell[BoxData["14.567588337468619`"], "Output",
 CellChangeTimes->{{3.906699714165866*^9, 3.906699748208376*^9}, 
   3.907303052089858*^9},
 CellLabel->
  "Out[854]=",ExpressionUUID->"3c5cc08c-4735-4193-b955-2ecf9b7da2ce"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", "*", "I"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9066999433070736`*^9, 3.9066999537411003`*^9}, {
  3.9067000179220505`*^9, 3.9067000287869253`*^9}, {3.9067000673612595`*^9, 
  3.906700070532256*^9}},
 CellLabel->
  "In[855]:=",ExpressionUUID->"68798ca0-7abd-4f19-8a96-3564e762f0cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"\"\<z= \>\"", ",", 
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], "*", 
    SuperscriptBox["E", 
     RowBox[{"I", "*", 
      RowBox[{"Arg", "[", "z", "]"}]}]]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9066999585284834`*^9, 3.9067000050112505`*^9}},
 CellLabel->
  "In[856]:=",ExpressionUUID->"86748160-80c1-4fe9-b824-6e1612078eac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z= \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SqrtBox["5"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"ArcTan", "[", "2", "]"}]}]]}]}],
  SequenceForm["z= ", 5^Rational[1, 2] E^(Complex[0, 1] ArcTan[2])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.90669999248757*^9, 3.9067000305450287`*^9}, 
   3.9073030521054816`*^9},
 CellLabel->
  "During evaluation of \
In[856]:=",ExpressionUUID->"7bc6a75c-dcd0-4edc-ab4e-772b0c082fb2"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "8.9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "1."}], "}"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.", ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", "8.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", 
          RowBox[{"-", "1.5"}]}], "}"}], ",", "9.2"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9072910247853727`*^9, 3.907291075725439*^9}},
 CellLabel->
  "In[857]:=",ExpressionUUID->"9c3587ed-9559-4a6b-a32c-f90938eb733b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"1", "+", "I"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"1", "-", 
    RowBox[{"3", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{"A", "*", "B"}], 
  RowBox[{"A", "+", "B"}]]}], "Input",
 CellChangeTimes->{
  3.9072993455552063`*^9, {3.907299727043126*^9, 3.907299747979311*^9}},
 CellLabel->
  "In[859]:=",ExpressionUUID->"e327b21e-c4a0-4f6f-b73d-b9ce1223e720"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "+", 
  FractionBox["\[ImaginaryI]", "2"]}]], "Output",
 CellChangeTimes->{3.907299748607011*^9, 3.9073030521533084`*^9},
 CellLabel->
  "Out[862]=",ExpressionUUID->"3902177d-14bc-4e1d-8ae2-358271129d3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["I", "I"], "//", "ComplexExpand"}]], "Input",
 CellChangeTimes->{{3.9072997709438906`*^9, 3.907299781460993*^9}},
 CellLabel->
  "In[863]:=",ExpressionUUID->"18bc40b5-3bc0-4604-9659-07bf3cad0db6"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "\[Pi]"}], "/", "2"}]]], "Output",
 CellChangeTimes->{3.907299782263049*^9, 3.9073030521737795`*^9},
 CellLabel->
  "Out[863]=",ExpressionUUID->"155d4730-310e-4873-949e-d8314b74526a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lhs", "=", 
   RowBox[{"1", "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"0.5", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rhs", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"lhs", ",", "rhs"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"lhs", "==", "rhs"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"lhs", "-", "rhs"}], ")"}], "2"], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.907299875384077*^9, 3.9072999774056654`*^9}},
 CellLabel->
  "In[864]:=",ExpressionUUID->"e58fb51b-9d15-4968-b749-008dd5be8d34"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.6878939988284738`"}], "}"}]], "Output",
 CellChangeTimes->{{3.907299908945117*^9, 3.907299939520596*^9}, 
   3.907299977719224*^9, 3.90730305220053*^9},
 CellLabel->
  "Out[868]=",ExpressionUUID->"c701d54e-caa5-4a08-932f-a2a9cdef35d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.232595164407831`*^-32", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.6878939988284736`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.907299908945117*^9, 3.907299939520596*^9}, 
   3.907299977719224*^9, 3.907303052232257*^9},
 CellLabel->
  "Out[869]=",ExpressionUUID->"d7dc8d4e-a625-4a66-8b01-71075301abf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b1", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b3", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rce", "=", 
  RowBox[{
   RowBox[{"v", "==", 
    RowBox[{
     RowBox[{"\[Lambda]1", "*", "b1"}], "+", 
     RowBox[{"\[Lambda]2", "*", "b2"}], "+", 
     RowBox[{"\[Lambda]3", "*", "b3"}]}]}], "//", 
   "Thread"}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "rce", "]"}]}], "Input",
 CellChangeTimes->{{3.907300042804941*^9, 3.907300114822*^9}},
 CellLabel->
  "In[870]:=",ExpressionUUID->"689ca1a7-0385-4153-bc8a-8e667cbcd9e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Equal]", 
    RowBox[{"2", " ", "\[Lambda]2"}]}], ",", 
   RowBox[{"2", "\[Equal]", 
    FractionBox["\[Lambda]1", "2"]}], ",", 
   RowBox[{"3", "\[Equal]", "\[Lambda]3"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.90730010130898*^9, 3.907300115601051*^9}, 
   3.9073030522479496`*^9},
 CellLabel->
  "Out[875]=",ExpressionUUID->"999057a1-2624-4f3f-9606-709f86473a01"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]1", "\[Rule]", "4"}], ",", 
    RowBox[{"\[Lambda]2", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"\[Lambda]3", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.90730010130898*^9, 3.907300115601051*^9}, 
   3.9073030522479496`*^9},
 CellLabel->
  "Out[876]=",ExpressionUUID->"d98067af-5738-423f-acda-55351b253e7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.9073002701091886`*^9, 3.907300289084135*^9}, {
  3.907300352073056*^9, 3.9073003529232016`*^9}},
 CellLabel->
  "In[877]:=",ExpressionUUID->"a998d9a2-f94c-454b-a37b-b75854322959"],

Cell[BoxData["0.6593299064355118`"], "Output",
 CellChangeTimes->{3.907300289367671*^9, 3.9073003536893225`*^9, 
  3.9073030523109465`*^9},
 CellLabel->
  "Out[878]=",ExpressionUUID->"cd7b2f3b-eda0-4390-9ebc-112ed6b9384b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "\[Tau]_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "\[Tau]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "\[Tau]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", "\[Tau]", "]"}], "\[Tau]"], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.9073003720066223`*^9, 3.90730052059067*^9}},
 CellLabel->
  "In[879]:=",ExpressionUUID->"81b76024-b473-4bbd-8f5e-273e1a22c268"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"SinIntegral", "[", "1", "]"}]}], "+", 
  RowBox[{"SinIntegral", "[", "\[Tau]", "]"}]}]], "Output",
 CellChangeTimes->{{3.9073003858826756`*^9, 3.9073004869284177`*^9}, 
   3.907300521187735*^9, 3.9073030523738356`*^9},
 CellLabel->
  "Out[880]=",ExpressionUUID->"c8693571-53ba-420b-8354-f04647a65424"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVjXs0lAkAxcdE4SitjUitTBJKFCaP6jJJZVPSg5yaZUqPXYekh6O1sZJX
0pbaNo+2KGGZ7aHX0Wx0aiLJ1FqSD5N5fsQMYzDDfDv9cc/953d/154THxZD
p9FoIfp8bc8jyUY0mgJrttbl7vhCosxgrDjAQIG0vGWtFwdIzLmUyEynK7Bv
MttY0E9ipDb24HQjBXb4me8MIUnc07IbzUwVKOjftXe9lIR75ro8mzkKnLuV
tNRDSGJpiZmlh5MC9i6qBqM2EozmEocDoQpcj9g3PbOOxBvTlIz8cv2/IeNP
/lkSE+Yi3+FxBRzTWwIE20l8Kz6/tm6jEob1RXGL7EnIikbSN11XAg9CZ0fJ
5WDZChfMVigRf9FoWuEDOcJ/zpr4Y8MwPsnsjpcmy7G7OnFRbvEwdutmHVD5
y9FbJr1R+2UY4YIaZpKpHIzTlpzSwBGcoBs+qmiRQW7XfKLp8gherHcpc74i
Q9GFVx8jxCPImhh2c2bLYCpK/qXSTwVB8lra04UyTE09Oul1TgXzqGD3RokU
VZqae+l9KkiuxhSGlUsRxJf7+fiMoiSf95p9SIqYyGobp+xRuDaYOFi7SuHf
6uLT2TMKp5oNOR4DElw3W1H90l2NVU+Mns3hSvB0qZJzLEuNXYP3XwbGSlA/
b/RATrcaydlcNxsXCUJa0/75uHwMBcbxt7r7xSg49Hr3QMYYam+YPOwpFyOK
//tG7/YxKAvUZbKDYlirKzP6HccxM5dz84WTGLkzkgw5KeMw3Ovo19QnQnrP
2/ZvWsYRluop1d0UYdU1YuDM4gnUX/HdFLZHhHaHFaE/nJoAS0lpTluJMHl8
pnHimwnsD+1fRmvrQ1dFqUEwQwNhEE9wKa8PAWUNWyMTNQjmMTflBffhYtzi
AUGDBjbWXbxM4z6U2LKazGy0ONsri8t7/hlu+dLJ1MNadKbQmdYpn3FKHJTw
+LkWvJyIqnKPz9hMd/N1tpiERQXr2NtBIUyHIrcZcCZhV/1s3awqIdJ5/pVF
jydhEjN0MjRaiLQd3PAEkyk0rN1sFThfCN+37UEm0VMo/NT5G1PQix7LwDPG
j6bgIdaJQzN7YbLYxypghg7TE4lDXqxeDFrJ5KvZOhRH21Kegz2IeGdncZSr
w3/0MWZNdA+44YVZsygdjnZkX/irvRv1Da3+cTspiN2b3z0I6EaE6nzIjNsU
rm57732plsCrFpZ7fDmFOIYrw/4+Ac8KtUX7HQqdl48ac/8mYM5md9yuorBE
yX/TVKXn+a77gu5+3Utc6TcJeBU2J2XUUWiM9eccOU/AgmVaNu0DhWvN3cXB
Bwmkzued/elfCrSmCueO/QQG1QmHP7RRqOffvxfDIdBY9XF5aQcFxZb8utS9
et6y4gmrm8L3O2u4D7cTGJJteJcmp/AypdOS4U9gzwvtXTlJYbBWcIK7hkBT
Mbdg2wCFT1Yr21b7EbgdNjfSfohCSpd3TjiTALtOInqu0vu877SdW0ag+co1
vpOagnXSSsY8FwK+CVsqL4xRcBrxjS1fQsDS8WF8lIaCdpFgvJ5B4Ffaj2Gv
tRQcvtvvt3UhAUXnAi/3KQrsrtOnuhbo/bWCuVd1FN7Tljw5bKv352doKIrC
Ddc9KrU1gf8BkkeAwQ==
         "]]},
       Annotation[#, "Charting`Private`Tag$459161#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.0000000000000022`, 0.45464872229851067`},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{1, 2}, {0.45464872229850967`, 0.8414709786615969}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVjWs0lAkAhsdEDUcqG5FamSSUKEwu1csklU2hCzmZZUqXXYeki6NVShKS
ttRWLl0oYZntQpej2ejURJKptS75MJk7McMYDObb2R/vef4853lt2HEh0VQK
hRKo2/90O5xkQKEosHZbTdaO73IU640W+OopcDZ7efOVfjnmXk1gpFIV2DuZ
QeP3yTFcFXNguoECO7xn7QyUy/F4glVvbKRAbt+uiA0SOVzS12dbzlUg+37i
MleBHMsKjc1c7RVY5KiqM2iRg95YaLs/SIE7YXunp9fI8cEoOS2nRPevT7/D
Oy/H+Cyh19CYAnapTb787XL8ILq0rmaTEvq1+bGLbeSQ5g+nbr6tBJ4GzY6U
ycC0EiycrVAi7orBtLynMoT+dmH85sYhfJVaHytKkmF3RcLirIIh7Naa7Ff5
yNBTLLlb9X0IofxKRqKRDPTTZuwiv2Ecp+o/K22SQmbdeLzh2jDebHAsdrgu
Rf7ld+1homGkjw85O7CkMBImnSrzVuFz0jrKy0VSTE09O+F+UQWTyACXerEE
5ZrKx6m9KohvROeFlEjgz5N5e3qOoDCH+551UILo8ApL+4wRONUZ2lo4SeDT
7OjZ0T0C+8qNma79Ytw2Xlnx1kWN1S8MXs3liPFymZJ99IIauwaevPWLEaN2
/sj+zC41kjI4zpaOYgQ2n/m7fcUocmlx97v6RMg9+H53f9ooqu8aVneXiBDJ
+2OTR+solLnqYukBESzUZWl9dmOYmcW+98ZehKwZifrs5DHoR9h5N/QKkdr9
sXVO0xhCUtwk2ntCrL5F9J9bMo7a616bQ/YI0Wq7Mujnk+NgKknNaXMhJo/N
pCV8GMe+oL7llJZedJYW6QXQNRD4c/lXs3vhW1y3LTxBgwAuY3N2QC+uxC7p
59dpYGnRyU2n9aLQitlgbDmB8z3S2OzX3+CcI5lMOTSB9mQqwyL5G06K/OOf
v54ANzOsvMT1G7ZQnb0cTCcxp5R59OOAAEaD4cF67ElYV7xab1IuQCrXpyz/
+SRo0YMngqIEOLODExpvOIW6dVvM/RYI4PWx1d8wagp5Xzt+Z/B70G3md472
bAquIq0oKL0Hhks8zX1naGGQQBx0Z/ZgwFwqW8PSIj/KinQb6EbYJ2vTIxwt
/qWOMiqjusEJzbtgQmoR35Zx+c/WLtTWNfvE7iQhdGn89NS3C2GqS4EzHpC4
GfzZ42oVgXdNTJe4EhKxdCe6zRMCbqVq09aHJNqvHaFx/iIwi8Vqe1BOYqmS
96GhXOfznPb6PyJxI1jsRL1HwD2vMTGthkR9jA/78CUCpkyj4mlfSNxq7CoI
OEAgZQH3/K//kNBrKHVo20dgQB1/6EsLiVrek8fRbAL15e0ritpIKLbm1KRE
6Hyz0hfMLhI/7azkVG8nMCjd+OmMjMS75A4zug+BPW8mHsnkJAaq+Mc5awk0
FHByg/tJfDVf1bLGm8CDkHnhNoMkTnV6ZIYyCLBqxMLXKl3P42HLxeUEGq/f
4tmrSVgkrqLPdyTgFb+17PIoCfthr5iSpQTM7KrjIjUkNIv5Y7V0Amcpv4S8
nyBh++M+722LCCg6Frq7TJGI6Dx9snOhrl/Fn3dDS4JPWfrikJWun5OmIUkS
d532qNQWBP4Dj++AvA==
         "]]},
       Annotation[#, "Charting`Private`Tag$459214#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.0000000000000022`, 0.45464872229851067`},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{1, 2}, {0.45464872229850967`, 0.8414709786615969}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9073003858826756`*^9, 3.9073004869284177`*^9}, 
   3.907300521187735*^9, 3.9073030524050817`*^9},
 CellLabel->
  "Out[881]=",ExpressionUUID->"ac17047f-dd45-4650-b04f-0e8aa7927116"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "t", "]"}]}], "+", 
     RowBox[{"c", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
     RowBox[{"5", "*", 
      RowBox[{"y", "[", "t", "]"}]}]}], "==", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"charrce", "=", 
   RowBox[{"rce", "/.", 
    RowBox[{"{", 
     RowBox[{
      TagBox[
       RowBox[{
        StyleBox[
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", "n_", "]"}], "[", "y", "]"}], "[", "t", 
          "]"}],
         ShowSpecialCharacters->False,
         ShowStringCharacters->True,
         NumberMarks->True], "\[RuleDelayed]", 
        SuperscriptBox["\[Lambda]", "n"]}],
       FullForm], ",", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "->", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"charrce", ",", "\[Lambda]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"Re", "[", "\[Lambda]", "]"}], "/.", "sol"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9073005977860003`*^9, 3.9073006897814364`*^9}, {
  3.9073007496998854`*^9, 3.9073007704481173`*^9}, {3.907300942188581*^9, 
  3.9073010152205715`*^9}, {3.90730108195533*^9, 3.907301112553751*^9}},
 CellLabel->
  "In[882]:=",ExpressionUUID->"79ab5810-6a49-467e-9a6d-7222893566cd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fit", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"body", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x", ",", 
       SuperscriptBox["x", "2"], ",", 
       SuperscriptBox["x", "3"]}], "}"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"body", ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", 
      RowBox[{"\"\<fit[x=2] = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"fit", "/.", 
         RowBox[{"x", "->", "2"}]}], "]"}]}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"fit", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.907301032975648*^9, 3.907301060383274*^9}, {
  3.907301120236233*^9, 3.907301278707677*^9}, {3.907301364288739*^9, 
  3.907301424954433*^9}},
 CellLabel->
  "In[887]:=",ExpressionUUID->"07f7f4c3-5820-4314-939b-67b3c642b062"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], 
     PointBox[{{1., 2.}, {-3., 5.}, {0., 1.}, {
      4., -3.}}]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VU8bAPC72HfSplBIlghFlDyTXYSyJqkktKFEJakkKURa7NIiypok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        "]]},
      Annotation[#, "Charting`Private`Tag$459383#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"fit[x=2] = 2.38095\"", TraditionalForm],
  PlotRange->{{-3., 4.}, {-3., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9073012799257035`*^9, {3.9073014053856096`*^9, 3.907301425440308*^9}, 
   3.9073030524684677`*^9},
 CellLabel->
  "Out[890]=",ExpressionUUID->"448a9ee9-2ed6-4838-8b4e-053be2a2644f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Prime", "[", "i", "]"}], ",", 
       RowBox[{"Prime", "[", 
        RowBox[{"i", "+", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"xb_", ",", "yb_"}], "}"}], "]"}], ":=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "xb"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", "-", "yb"}], ")"}], "2"]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"err", "/@", "body"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.907303426956275*^9, 3.9073034300635223`*^9}, {
  3.907303479113052*^9, 3.9073035155668592`*^9}},
 CellLabel->
  "In[949]:=",ExpressionUUID->"907bce48-a981-4d1f-bd2d-d0a15d575636"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Prime", "[", "i", "]"}], ",", 
       RowBox[{"Prime", "[", 
        RowBox[{"i", "+", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"body", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xb_", ",", "yb_"}], "}"}], ":>", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "xb"}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "yb"}], ")"}], "2"]}]]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.907301490015552*^9, 3.9073015342411585`*^9}, {
   3.9073015758597207`*^9, 3.907301602948954*^9}, {3.9073016799625425`*^9, 
   3.9073018403272753`*^9}, {3.90730265698058*^9, 3.9073026633524246`*^9}, 
   3.9073034109587684`*^9, {3.9073034614511642`*^9, 3.9073034771639547`*^9}, {
   3.9073035190250463`*^9, 3.90730352430235*^9}, {3.907303735517078*^9, 
   3.9073037622130513`*^9}, 3.9073037942886744`*^9},
 CellLabel->
  "In[978]:=",ExpressionUUID->"fde208aa-8a72-4325-8636-7014326bd34f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"err", "[", 
      RowBox[{"{", 
       RowBox[{"xb_", ",", "yb_"}], "}"}], "]"}], ":=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "xb"}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "yb"}], ")"}], "2"]}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"totalError", "=", 
     RowBox[{"Total", "[", 
      RowBox[{"err", "/@", "body"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"min", "=", 
    RowBox[{"NMinimize", "[", 
     RowBox[{"totalError", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.907301490015552*^9, 3.9073015342411585`*^9}, {
   3.9073015758597207`*^9, 3.907301602948954*^9}, {3.9073016799625425`*^9, 
   3.9073018403272753`*^9}, {3.90730265698058*^9, 3.9073026633524246`*^9}, 
   3.9073034109587684`*^9, {3.9073034614511642`*^9, 3.9073034771639547`*^9}, {
   3.9073035190250463`*^9, 3.90730352430235*^9}, 3.907303735517078*^9},
 CellLabel->
  "In[981]:=",ExpressionUUID->"c9495c78-8c26-48c4-82f3-ff2e188ff6e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"554.8084228644643`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "28.999880755711715`"}], ",", 
     RowBox[{"y", "\[Rule]", "36.999866013341816`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.90730352483567*^9, 3.907303797438368*^9},
 CellLabel->
  "Out[983]=",ExpressionUUID->"fae8fec6-2ff4-4d83-baa3-86e4375bf7f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"min", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9073035900061436`*^9, 3.907303591507702*^9}},
 CellLabel->
  "In[961]:=",ExpressionUUID->"f6ae0bf6-afcb-4823-849e-91c07f03d266"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "28.999880755711715`"}], ",", 
   RowBox[{"y", "\[Rule]", "36.999866013341816`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9073035917466497`*^9},
 CellLabel->
  "Out[961]=",ExpressionUUID->"45f0015d-71c5-4ce1-b3cc-c34f91355db2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9073036339184775`*^9, 3.907303684476419*^9}},
 CellLabel->
  "In[967]:=",ExpressionUUID->"b9c7c228-90b6-4aae-90d6-bf620168de54"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`], 
    AbsoluteThickness[1.6], PointBox[{{5., 6.}, {5., 6.}}]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {0, 12.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.907303642020447*^9, 3.907303685027663*^9}},
 CellLabel->
  "Out[967]=",ExpressionUUID->"d8ecdeeb-6af3-4744-9a28-828614e42f10"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}], "/.", 
   RowBox[{"min", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.90730357989657*^9, 3.907303617407753*^9}},
 CellLabel->
  "In[963]:=",ExpressionUUID->"d515e9a9-99d2-493e-a316-0bac2fe3a110"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`], 
    AbsoluteThickness[1.6], 
    PointBox[{{28.999880755711715`, 36.999866013341816`}, {
     28.999880755711715`, 36.999866013341816`}}]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 57.99976151142343}, {0, 73.99973202668363}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.907303586432782*^9, 3.9073036179880867`*^9}},
 CellLabel->
  "Out[963]=",ExpressionUUID->"beacb9d8-fa0b-4c0e-a7ec-69cf81f7907a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"body", ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9073035433931355`*^9, 3.9073035474711657`*^9}},
 CellLabel->
  "In[959]:=",ExpressionUUID->"2d8ca164-2f98-4d88-8dec-08e553018c05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pl2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "/.", 
         RowBox[{"min", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"body", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Prime", "[", "i", "]"}], ",", 
         RowBox[{"Prime", "[", 
          RowBox[{"i", "+", "2"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "pl2"}], "]"}], "\[IndentingNewLine]", "min", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.907301490015552*^9, 3.9073015342411585`*^9}, {
   3.9073015758597207`*^9, 3.907301602948954*^9}, {3.9073016799625425`*^9, 
   3.9073018403272753`*^9}, {3.90730265698058*^9, 3.9073026633524246`*^9}, 
   3.9073034109587684`*^9, {3.9073034614511642`*^9, 3.9073034771639547`*^9}, {
   3.9073035190250463`*^9, 3.9073035393344955`*^9}},
 CellLabel->
  "In[968]:=",ExpressionUUID->"7bb56512-cb57-4a8e-a0ad-56eac5dfbdec"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {GrayLevel[0], PointSize[0.01], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQUOEEoESnNAaRk0cTU0cS00cUM0cWM0cXM0cVs0
cXtU8QYnVPEGF1TxBlc0cXc0cS80cV80cT9U8QMBqOIHAlHFHYLQxIMdABae
H80=
      "]]}, {{}, {}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.02], AbsoluteThickness[1.6], 
     PointBox[{{28.999880755711715`, 36.999866013341816`}, {
      28.999880755711715`, 36.999866013341816`}}]}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 71.}, {0, 79.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.907301723208849*^9, 3.9073017434820547`*^9}, 
   3.90730177648075*^9, {3.9073018136577644`*^9, 3.907301847052028*^9}, {
   3.9073026465226517`*^9, 3.9073026652985315`*^9}, 3.9073030525313497`*^9, 
   3.907303464417617*^9, 3.90730371399328*^9},
 CellLabel->
  "Out[970]=",ExpressionUUID->"b0f75727-370e-4923-a746-912e94a7787a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"554.8084228644643`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "28.999880755711715`"}], ",", 
     RowBox[{"y", "\[Rule]", "36.999866013341816`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.907301723208849*^9, 3.9073017434820547`*^9}, 
   3.90730177648075*^9, {3.9073018136577644`*^9, 3.907301847052028*^9}, {
   3.9073026465226517`*^9, 3.9073026652985315`*^9}, 3.9073030525313497`*^9, 
   3.907303464417617*^9, 3.90730371399328*^9},
 CellLabel->
  "Out[971]=",ExpressionUUID->"73217904-b982-4868-8eb5-54ce2ccecfe6"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zv1", "=", 
   RowBox[{"1", "+", 
    RowBox[{"5", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zv2", "=", 
   RowBox[{"1", "+", "I"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lz", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rz", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", "314."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zz", "=", 
   FractionBox[
    RowBox[{"Rz", "*", "I", "*", "\[Omega]", "*", "Lz"}], 
    RowBox[{"Rz", "+", 
     RowBox[{"I", "*", "\[Omega]", "*", "Lz"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "=", "230."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"U", "-", "Ub"}], "Zv1"], "==", 
      RowBox[{
       FractionBox[
        RowBox[{"Ub", "-", "Ua"}], "Zv2"], "+", 
       FractionBox["Ub", 
        FractionBox["1", 
         RowBox[{"I", "*", "\[Omega]", "*", "c"}]]]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Ub", "-", "Ua"}], "Zv2"], "==", 
      FractionBox["Ua", "Zz"]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"Ua", ",", "Ub"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ztraty", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", "Zv1", "]"}], "*", 
      SuperscriptBox[
       RowBox[{"Abs", "[", 
        FractionBox[
         RowBox[{"U", "-", "Ub"}], "Zv1"], "]"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"Re", "[", "Zv2", "]"}], "*", 
      SuperscriptBox[
       RowBox[{"Abs", "[", 
        FractionBox[
         RowBox[{"Ub", "-", "Ua"}], "Zv1"], "]"}], "2"]}]}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"absUa", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"Ua", "/.", "sol"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9073024513428373`*^9, 3.907302637380539*^9}, {
  3.9073026915378385`*^9, 3.9073028797705793`*^9}, {3.907302926010167*^9, 
  3.907302928604533*^9}, {3.9073030192675896`*^9, 3.907303031479005*^9}},
 CellLabel->
  "In[984]:=",ExpressionUUID->"e51bc3b2-5fdf-4bf7-801c-3e809cd432df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{"ztraty", ",", 
   RowBox[{"{", "c", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.9073046705419455`*^9},
 CellLabel->
  "In[1007]:=",ExpressionUUID->"f2cede81-687a-4e04-a4e6-84918bae6822"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.432595780431507`", ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "8.581706455781145`*^-6"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.907302907068426*^9, 3.9073030533341427`*^9, 
  3.907304123801318*^9, 3.907305454542962*^9},
 CellLabel->
  "Out[1007]=",ExpressionUUID->"71f1afcf-9b6c-4234-b595-aca01a506ba8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"ztraty", ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "8"}]], ",", 
     RowBox[{"1.7", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "5"}]]}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<c[F]\>\"", ",", "\"\<ztraty[W]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "->", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.907304572107484*^9, 3.9073046584134417`*^9}},
 CellLabel->
  "In[1006]:=",ExpressionUUID->"70df4d57-94f3-4c04-ac88-4a67eb9ea234"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[0.006], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV13k8VdsXAHBDFCFlnhJx9jVfMjdsSsbImGeoJA2GiJRKKUWDJ1PKUB6V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       "]]},
     Annotation[#, "Charting`Private`Tag$625097#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"c[F]\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"ztraty[W]\"", HoldForm], TraditionalForm]},
  AxesOrigin->{-18.420680743952325`, 1.6924171271069395`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 
      6}]& }, {{{-18.420680743952367`, 
       Directive[]}, {-16.11809565095832, 
       Directive[]}, {-13.815510557964274`, 
       Directive[]}, {-11.512925464970229`, 
       Directive[]}, {-20.72326583694641, 
       Directive[]}, {-20.030118656386467`, 
       Directive[]}, {-19.624653548278303`, 
       Directive[]}, {-19.33697147582652, 
       Directive[]}, {-19.11382792451231, 
       Directive[]}, {-18.931506367718356`, 
       Directive[]}, {-18.7773556878911, 
       Directive[]}, {-18.643824295266576`, 
       Directive[]}, {-18.526041259610192`, 
       Directive[]}, {-17.72753356339242, 
       Directive[]}, {-17.322068455284256`, 
       Directive[]}, {-17.034386382832476`, 
       Directive[]}, {-16.811242831518264`, 
       Directive[]}, {-16.62892127472431, 
       Directive[]}, {-16.474770594897052`, 
       Directive[]}, {-16.34123920227253, 
       Directive[]}, {-16.223456166616145`, 
       Directive[]}, {-15.424948470398375`, 
       Directive[]}, {-15.01948336229021, 
       Directive[]}, {-14.73180128983843, 
       Directive[]}, {-14.508657738524219`, 
       Directive[]}, {-14.326336181730264`, 
       Directive[]}, {-14.172185501903007`, 
       Directive[]}, {-14.038654109278484`, 
       Directive[]}, {-13.9208710736221, 
       Directive[]}, {-13.122363377404328`, 
       Directive[]}, {-12.716898269296165`, 
       Directive[]}, {-12.429216196844383`, 
       Directive[]}, {-12.206072645530174`, 
       Directive[]}, {-12.02375108873622, 
       Directive[]}, {-11.86960040890896, 
       Directive[]}, {-11.736069016284437`, 
       Directive[]}, {-11.618285980628055`, 
       Directive[]}, {-10.819778284410283`, 
       Directive[]}, {-10.41431317630212, 
       Directive[]}, {-10.126631103850338`, 
       Directive[]}, {-9.903487552536127, 
       Directive[]}, {-9.721165995742174, 
       Directive[]}, {-9.567015315914915, 
       Directive[]}, {-9.433483923290392, 
       Directive[]}, {-9.315700887634009, 
       Directive[]}, {-9.210340371976182, 
       Directive[]}, {-9.115030192171858, 
       Directive[]}, {-9.028018815182229, 
       Directive[]}}, {{1.7047480922384253`, 
       Directive[]}, {1.7227665977411035`, 
       Directive[]}, {1.7404661748405046`, 
       Directive[]}, {1.7578579175523736`, 
       Directive[]}, {1.6863989535702288`, 
       Directive[]}, {1.6900958154515549`, 
       Directive[]}, {1.6937790608678513`, 
       Directive[]}, {1.6974487897568136`, 
       Directive[]}, {1.7011051009599243`, 
       Directive[]}, {1.7083778602890038`, 
       Directive[]}, {1.7119945007591924`, 
       Directive[]}, {1.715598108262491, 
       Directive[]}, {1.7191887763932197`, 
       Directive[]}, {1.7263316639055997`, 
       Directive[]}, {1.7298840655099674`, 
       Directive[]}, {1.7334238922150915`, 
       Directive[]}, {1.7369512327330598`, 
       Directive[]}, {1.7439688053917064`, 
       Directive[]}, {1.747459210331475, 
       Directive[]}, {1.7509374747078, 
       Directive[]}, {1.7544036826842861`, 
       Directive[]}, {1.7613002617433464`, 
       Directive[]}, {1.7647307968401356`, 
       Directive[]}, {1.7681496035889213`, 
       Directive[]}, {1.7715567619105355`, 
       Directive[]}, {1.7749523509116738`, 
       Directive[]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{277.17391304347825`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{-Log[100000000], -10.982297213908058`}, {1.6924171271069357`, 
     1.7580037646034714`}}, {{-18.420680743952367`, -10.982297213908058`}, {
    1.6924171271069357`, 1.7580037646034714`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0]}, {{{-18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-20.72326583694641, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-20.030118656386467`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-19.624653548278303`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-19.33697147582652, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-19.11382792451231, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.931506367718356`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.7773556878911, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.643824295266576`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.526041259610192`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-17.72753356339242, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-17.322068455284256`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-17.034386382832476`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.811242831518264`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.62892127472431, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.474770594897052`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.34123920227253, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.223456166616145`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-15.424948470398375`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-15.01948336229021, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-14.73180128983843, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-14.508657738524219`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-14.326336181730264`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-14.172185501903007`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-14.038654109278484`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-13.9208710736221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-13.122363377404328`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.716898269296165`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.429216196844383`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.02375108873622, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.86960040890896, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.736069016284437`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.618285980628055`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.41431317630212, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.126631103850338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.721165995742174, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.567015315914915, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.433483923290392, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.315700887634009, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.115030192171858, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.028018815182229, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
      1.7047480922384253`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"5.5\"", ShowStringCharacters -> False], 5.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.7227665977411035`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"5.6\"", ShowStringCharacters -> False], 5.6, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.7404661748405046`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"5.7\"", ShowStringCharacters -> False], 5.7, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.7578579175523736`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"5.8\"", ShowStringCharacters -> False], 5.8, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.6863989535702288`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6900958154515549`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6937790608678513`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6974487897568136`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7011051009599243`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7083778602890038`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7119945007591924`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.715598108262491, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7191887763932197`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7263316639055997`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7298840655099674`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7334238922150915`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7369512327330598`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7439688053917064`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.747459210331475, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7509374747078, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7544036826842861`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7613002617433464`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7647307968401356`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7681496035889213`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7715567619105355`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.7749523509116738`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.9073045742277517`*^9, 3.907304658698172*^9}},
 CellLabel->
  "Out[1006]=",ExpressionUUID->"710de8f2-c30d-4190-8047-a5246614f939"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{"absUa", ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]]}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<c[F]\>\"", ",", "\"\<Abs[Ua][V]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "->", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9073030763589673`*^9, 3.907303158700032*^9}},
 CellLabel->
  "In[997]:=",ExpressionUUID->"e1fcc269-381a-42a7-b24f-35765d76e0a3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[0.006], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0Hs4VdkbB3AkqVE0nL3POdveZ29yqSmaSLrpzf3SUKFGVAgzSkkNI6Gb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       "]], LineBox[CompressedData["
1:eJwV0Hs0lHkYwHHUvIOW9I7r+74/tyTlKG1WiDwY1yntyi0MpUkcpVakQldN
lMrSWu2prYRqEpJuTvFwzIgt2bQHbbqotmJUCrlEO/vHc57z+e/7PBaxm4PW
a6ipqYWo5v9t1+m2PS6LYGP465T2FSzkC7/d+LCb4MBdz+eZKh/rHc5TZBK8
Kde0dFI5d48y4VQ6QT+tC51Pl7OQbfrSM2UHQbOE+v6fVc663c2K0gjmD7Ki
QRELeyPahyxSCU454KsolXeNKu6PJhOcbO27WBPAws7CO2UPthDMGmePjvqz
sM2hZndZEkGXQ8xBG5WTH8rCMzcSDLj6JVfox0KibpG2bTzBwnTjS+DDQnz5
0ZfqcQQfjmnVm3uzIAk4cLtrHcGGjCWdSi8WoqTJSdIYgh03uDn+HiyEWyX4
isUETz+eltDtzkJIY4y5QyRBt9V77ocsYyFwavnDF6EEQ8aq7QRLWQg46XXp
ZrCqV9roH+zMgq+LS9axIIJjr3Wa9y5hAbbNdXQLVN3nZbeseDELi96r/17k
TVBolqTxdT4LC3JHkzd7EdxRdv5rsQ0L8+d/EPl4EJxesMZ9iTULlnFPJj+7
EtzM9DraWLCg//T62pUOBNPEK9PtDVnQy7jsYv09QXFymLOPgAUdpkQwuZDg
frP4kwF6LFChv8hltgSPZxZy5tosfLmfOI+aTVDa/2fntEkGmiL9RRXmBBcf
LjrsP8ZA3jvrTaGmBMfbE3syhhmw4fVWlZkQhGLhocsDDES4hjv56hFUeDTm
uPcwUCcT+mZPcvhpVX78xlsMHHKyTLCf4DC6xNLgSg0DYYpvh7pGOUypnVr/
tpKBjy9q22yGODy+I8fVvowBS5NFoS19HBbyPIvt8hmQHiTrtbs47BGb/mUV
z0CQwYS0+m8OjVJLXW/FMmB2rutCRAeH3gceLvAWM3CzrkApa+Nw9qruJmEQ
A33DWikiOYfzIOrHvqUMBEpG9uVWcyhXGrpr6jJg4PHgjO4RVc/zdxoWlSZw
ZGm1TE+dw3j7Gr+8AGPwyu3Y9SiNRWvXj//GzDCCqfaq3L5eBvvzXDKHugxA
cErHbjyMwQfvJSPSbn1YILbmRzWYoCQsyuRFjwDOldRtveFggkU/SULVeAII
9fxV9khmjPPi8vl73GiY+WguKzQwxn37Q5Tnt8wCywFn08s5RuhTbsCzqNUD
l3F+ZPwnQxSukIy0fZkJeWL92NdiQ1y9IbOz7qgugN+ZicgOAywQum7V9dWB
Eeu3bVZuBuje9BbG+2cAdaTS4U2VPjaoh69KqNCGYP9rksS5+rhOWm62MEML
zo9ta/PIF6BbgaiyyUETghfdbJ3FF2Bgl/ixEZ8PhZNnA0qmC7BQkhL5RJ0P
3S2HWx01BPi4dBl79isF0bExrZGTNIbIINT2EwUbCqjW0s80vqn3vObZQ8HO
4eAW5+c0fqvuH8y4SsGZW4PNa2/RyOl3epiuoaD3wD++Q9dpHMi95tsXQcGc
IHmztIbGPdnGB6+HUCDrK2q+VEnjHFHblZUiCq6y0DxcSmNjdGV1liMFisyj
ipx8GnvvRMLYdxRoBmz34fJoTDvtde8unwKRYayi4giNnkk+x4o0KGiv+EHR
kU3jb+uoWqdRHnQ/eyInu2lMagv/I/0lD7hyhXdVBo13ktWeLX/Kg+jtVXLP
nape9RMhpt086NXLkm9IpXFQqfWqoY0HVj2bvMeTabxndGKioIUHGy6GyXO3
qP7RLPWLa+KBLNXD2yyJxqayilaneh4oPWzlVxJpPJah3Dujlgf/AevmXUA=

       "]]},
     Annotation[#, "Charting`Private`Tag$607151#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"c[F]\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"Abs[Ua][V]\"", HoldForm], TraditionalForm]},
  AxesOrigin->{-11.512925464970204`, 2.715842261342529},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Log, Exp}][#, #2, {6, 
      6}]& }, {{{-11.512925464970229`, 
       Directive[]}, {-9.903487552536127, 
       Directive[]}, {-9.210340371976182, 
       Directive[]}, {-7.600902459542082, 
       Directive[]}, {-6.907755278982137, 
       Directive[]}, {-5.298317366548036, 
       Directive[]}, {-4.605170185988091, 
       Directive[]}, {-13.815510557964274`, 
       Directive[]}, {-13.122363377404328`, 
       Directive[]}, {-12.716898269296165`, 
       Directive[]}, {-12.429216196844383`, 
       Directive[]}, {-12.206072645530174`, 
       Directive[]}, {-12.02375108873622, 
       Directive[]}, {-11.86960040890896, 
       Directive[]}, {-11.736069016284437`, 
       Directive[]}, {-11.618285980628055`, 
       Directive[]}, {-10.819778284410283`, 
       Directive[]}, {-10.41431317630212, 
       Directive[]}, {-10.126631103850338`, 
       Directive[]}, {-9.721165995742174, 
       Directive[]}, {-9.567015315914915, 
       Directive[]}, {-9.433483923290392, 
       Directive[]}, {-9.315700887634009, 
       Directive[]}, {-8.517193191416238, 
       Directive[]}, {-8.111728083308073, 
       Directive[]}, {-7.824046010856292, 
       Directive[]}, {-7.418580902748128, 
       Directive[]}, {-7.264430222920869, 
       Directive[]}, {-7.1308988302963465`, 
       Directive[]}, {-7.013115794639964, 
       Directive[]}, {-6.214608098422191, 
       Directive[]}, {-5.809142990314028, 
       Directive[]}, {-5.521460917862246, 
       Directive[]}, {-5.115995809754082, 
       Directive[]}, {-4.961845129926823, 
       Directive[]}, {-4.8283137373023015`, 
       Directive[]}, {-4.710530701645918, 
       Directive[]}, {-3.912023005428146, 
       Directive[]}, {-3.506557897319982, 
       Directive[]}, {-3.2188758248682006`, 
       Directive[]}, {-2.995732273553991, 
       Directive[]}, {-2.8134107167600364`, 
       Directive[]}, {-2.659260036932778, 
       Directive[]}}, {{3.912023005428146, 
       Directive[]}, {4.605170185988092, 
       Directive[]}, {6.214608098422191, 
       Directive[]}, {6.907755278982137, 
       Directive[]}, {0., 
       Directive[]}, {0.6931471805599453, 
       Directive[]}, {1.0986122886681098`, 
       Directive[]}, {1.3862943611198906`, 
       Directive[]}, {1.6094379124341003`, 
       Directive[]}, {1.791759469228055, 
       Directive[]}, {1.9459101490553132`, 
       Directive[]}, {2.0794415416798357`, 
       Directive[]}, {2.1972245773362196`, 
       Directive[]}, {2.302585092994046, 
       Directive[]}, {2.995732273553991, 
       Directive[]}, {3.4011973816621555`, 
       Directive[]}, {3.6888794541139363`, 
       Directive[]}, {4.0943445622221, 
       Directive[]}, {4.248495242049359, 
       Directive[]}, {4.382026634673881, 
       Directive[]}, {4.499809670330265, 
       Directive[]}, {5.298317366548036, 
       Directive[]}, {5.703782474656201, 
       Directive[]}, {5.991464547107982, 
       Directive[]}, {6.396929655216146, 
       Directive[]}, {6.551080335043404, 
       Directive[]}, {6.684611727667927, 
       Directive[]}, {6.802394763324311, 
       Directive[]}, {7.600902459542082, 
       Directive[]}, {8.006367567650246, 
       Directive[]}, {8.294049640102028, 
       Directive[]}, {8.517193191416238, 
       Directive[]}, {8.699514748210191, 
       Directive[]}, {8.85366542803745, 
       Directive[]}, {8.987196820661973, 
       Directive[]}, {9.104979856318357, 
       Directive[]}, {9.210340371976184, 
       Directive[]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{287.93478260869557`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{-Log[100000], -Log[100]}, {2.7158422613425226`, 
     6.825990686459935}}, {{-11.512925464970229`, -4.605170185988092}, {
    2.7158422613425226`, 6.825990686459935}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0]}, {{{-11.512925464970229`, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-9.903487552536127, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "5.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "5.`", 
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {-6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.005\"", ShowStringCharacters -> False], 0.005, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-13.122363377404328`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.716898269296165`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.429216196844383`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.02375108873622, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.86960040890896, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.736069016284437`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.618285980628055`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.41431317630212, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.126631103850338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.721165995742174, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.567015315914915, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.433483923290392, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.315700887634009, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
      3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
       FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.210340371976184, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.90730309545427*^9, 3.9073031132551966`*^9}, {
   3.907303148697915*^9, 3.9073031592653885`*^9}, 3.9073041266957483`*^9},
 CellLabel->
  "Out[997]=",ExpressionUUID->"055e99fe-d04e-4bc8-8fd0-cc52a8b70149"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{"clintel", ".", "org"}], "/"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.9073048274335556`*^9, 
  3.907304829377201*^9}},ExpressionUUID->"dbfa7378-5668-4002-868a-\
3a25c91d3063"]
},
WindowSize->{1428., 819.75},
WindowMargins->{{-9.75, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.3 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"802f9efd-8924-487b-a593-eaf8ba495d15"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 609, 15, 197, "Input",ExpressionUUID->"00d62c7a-efa5-4dae-b718-f61dbee0b343"],
Cell[1170, 37, 317, 8, 129, "Text",ExpressionUUID->"63417646-cf97-4d9e-a9b0-fd9b74ba588d"],
Cell[CellGroupData[{
Cell[1512, 49, 1513, 41, 372, "Input",ExpressionUUID->"1965499e-6ba4-47b6-8aa5-0ef8f7048997"],
Cell[3028, 92, 611, 12, 118, "Output",ExpressionUUID->"2be405c6-207f-4f17-94df-b854505f0865"]
}, Open  ]],
Cell[3654, 107, 374, 10, 64, "Input",ExpressionUUID->"07898d04-8875-4b2c-b969-481eebc91150"],
Cell[CellGroupData[{
Cell[4053, 121, 516, 14, 109, "Input",ExpressionUUID->"65dbe89f-19e4-4de1-9bda-a680643be0b8"],
Cell[4572, 137, 350, 9, 74, "Output",ExpressionUUID->"735e77b4-9893-4b21-a3de-e55a2ab61329"],
Cell[4925, 148, 356, 9, 74, "Output",ExpressionUUID->"09bb25a3-7fec-4e30-b824-9a2b72473c98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5318, 162, 605, 18, 153, "Input",ExpressionUUID->"afa8795a-f4ed-4028-bb49-471aa8d3894d"],
Cell[5926, 182, 1224, 31, 118, "Output",ExpressionUUID->"558ee17e-66a0-40de-850e-e6ae32901f50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7187, 218, 1579, 51, 372, "Input",ExpressionUUID->"b372b501-87bb-46e5-aea2-f4d5116b20b3"],
Cell[8769, 271, 560, 11, 118, "Output",ExpressionUUID->"1858d51d-83cf-4f6c-bd7c-c2d13d762a9c"]
}, Open  ]],
Cell[9344, 285, 557, 15, 153, "Input",ExpressionUUID->"ed1fb500-f9c8-4976-a26c-a5ddd6947edd"],
Cell[CellGroupData[{
Cell[9926, 304, 977, 27, 197, "Input",ExpressionUUID->"39870c84-e027-4907-b9be-f1473625114f"],
Cell[10906, 333, 559, 11, 118, "Output",ExpressionUUID->"18d7bea3-553b-4310-9cbb-4540fd387f1e"]
}, Open  ]],
Cell[11480, 347, 2364, 71, 372, "Input",ExpressionUUID->"17c259c0-924a-4f38-82b9-2d3a60ee82ab"],
Cell[CellGroupData[{
Cell[13869, 422, 325, 7, 109, "Input",ExpressionUUID->"7b38808d-7cb2-4cea-86ca-93d07d5a5a57"],
Cell[14197, 431, 449, 9, 74, "Output",ExpressionUUID->"a40b5b12-f15f-44a2-9770-80bed4ee008c"],
Cell[14649, 442, 828, 26, 118, "Output",ExpressionUUID->"400e39af-2098-49ca-a0c9-5275276183e7"]
}, Open  ]],
Cell[15492, 471, 2114, 67, 459, "Input",ExpressionUUID->"7621f556-f301-4d62-a620-7f45184a86ea"],
Cell[CellGroupData[{
Cell[17631, 542, 283, 5, 109, "Input",ExpressionUUID->"ce457c79-3696-450b-adae-b07c1a1bfc57"],
Cell[17917, 549, 254, 6, 74, "Output",ExpressionUUID->"6c3e9557-a921-4fa7-ba39-16b6af4d016c"],
Cell[18174, 557, 254, 6, 74, "Output",ExpressionUUID->"377612eb-717a-4390-b495-392c7e902afc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18465, 568, 195, 4, 64, "Input",ExpressionUUID->"7aa1bd2c-ece1-4fd6-859c-18b0376ce5e1"],
Cell[18663, 574, 263, 5, 74, "Output",ExpressionUUID->"f49ec9c3-e61e-471e-aba2-0467a51c58bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18963, 584, 1274, 38, 242, "Input",ExpressionUUID->"5bd9f76e-8542-4bda-8d38-9f068c5175e1"],
Cell[20240, 624, 29135, 531, 138, "Output",ExpressionUUID->"73b90289-e829-4594-ba39-eba6b619eed3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49412, 1160, 2080, 61, 330, "Input",ExpressionUUID->"e0fd99e0-c867-4836-b6a8-bbd30b0c8a06"],
Cell[51495, 1223, 29395, 535, 138, "Output",ExpressionUUID->"81fd5e2d-d858-4699-9bf5-47e1d8d50c86"],
Cell[80893, 1760, 22692, 392, 544, "Output",ExpressionUUID->"80ea4616-3892-4fab-8295-1ecb7b8e431e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103622, 2157, 1849, 56, 330, "Input",ExpressionUUID->"a9bb6f04-8ad0-4b2c-b3be-dc361db67657"],
Cell[105474, 2215, 29006, 527, 138, "Output",ExpressionUUID->"84e1c972-aeba-409f-bfb9-1007d1ef92be"],
Cell[134483, 2744, 20721, 360, 556, "Output",ExpressionUUID->"ed4913aa-3425-4121-82a7-6011b1ee68db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155241, 3109, 640, 19, 196, "Input",ExpressionUUID->"67333e1d-a3c5-43be-aa97-d5419c8072ec"],
Cell[155884, 3130, 843, 19, 118, "Output",ExpressionUUID->"75d1084a-ef4c-4492-9649-86172e8365bc"],
Cell[156730, 3151, 390, 10, 74, "Output",ExpressionUUID->"3aba556d-4b71-4587-8daf-6e09bd3561cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157157, 3166, 234, 5, 64, "Input",ExpressionUUID->"385b36b3-2146-4984-b141-a0373d086d58"],
Cell[157394, 3173, 2776, 77, 538, "Output",ExpressionUUID->"83c80af3-8b9c-49e9-a3eb-1f14996698d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160207, 3255, 215, 4, 64, "Input",ExpressionUUID->"6f92284e-0f8c-49a3-a063-e7e29c1167d7"],
Cell[160425, 3261, 290, 7, 74, "Output",ExpressionUUID->"9e7faeea-d0e6-4c98-bb32-86d8fbdb1690"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160752, 3273, 276, 6, 64, "Input",ExpressionUUID->"b45460fb-cf8b-496c-ad5f-ccfb3cad30f3"],
Cell[161031, 3281, 368, 9, 74, "Output",ExpressionUUID->"d302ca64-6373-4530-98d5-39e37e42b3f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161436, 3295, 270, 6, 64, "Input",ExpressionUUID->"6a980b7e-096c-4ae6-9bb1-8b7e5cf4f70e"],
Cell[161709, 3303, 368, 9, 74, "Output",ExpressionUUID->"16fc9655-ef87-4779-9d3b-79100bc79454"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162114, 3317, 372, 11, 108, "Input",ExpressionUUID->"7d0128bc-f3a6-4d0f-8c68-e404a2dd1ebf"],
Cell[162489, 3330, 510, 16, 80, "Output",ExpressionUUID->"fcef875f-4c1e-452c-8ce4-e3ae425b1934"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163036, 3351, 250, 5, 64, "Input",ExpressionUUID->"cc7bd83a-0562-4809-9880-ab19dd6afcf1"],
Cell[163289, 3358, 319, 9, 74, "Output",ExpressionUUID->"badffb52-573b-4818-8938-9af6e5701b10"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163645, 3372, 998, 31, 120, "Input",ExpressionUUID->"e4f5e520-c6d5-4a8c-a227-b70008d31d14"],
Cell[164646, 3405, 480, 13, 74, "Output",ExpressionUUID->"b7b8d2e5-95e8-4387-bab2-6c33f728dafc"],
Cell[165129, 3420, 422, 11, 74, "Output",ExpressionUUID->"38bb2e8d-1b9d-4b9a-9515-c4e06f5f220b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165588, 3436, 253, 6, 64, "Input",ExpressionUUID->"7568d302-9edf-4887-a328-fe6b69b2ed6d"],
Cell[165844, 3444, 227, 4, 74, "Output",ExpressionUUID->"b3c56185-fdf2-4f64-b4dc-95d4b4687cab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166108, 3453, 198, 4, 64, "Input",ExpressionUUID->"1673b715-f221-4ede-9679-3e61d64f65c3"],
Cell[166309, 3459, 13016, 306, 393, "Output",ExpressionUUID->"c78fccd2-563f-4f59-b662-208f5dd022be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179362, 3770, 708, 21, 70, "Input",ExpressionUUID->"449bd336-7e55-487a-acdf-415d0f143f23"],
Cell[180073, 3793, 3193, 95, 425, "Output",ExpressionUUID->"d86bf9ff-d219-440f-850f-3399d16dda8f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183303, 3893, 283, 7, 64, "Input",ExpressionUUID->"c98cdaae-993d-4334-b532-7833eedfb3f4"],
Cell[183589, 3902, 504, 14, 74, "Output",ExpressionUUID->"d8d83e78-01b4-47f3-b2f2-7465aa64a2b9"]
}, Open  ]],
Cell[184108, 3919, 2028, 50, 547, "Input",ExpressionUUID->"70269f7d-9aa8-43f8-ad3b-b8e248ca6ad4"],
Cell[186139, 3971, 1946, 49, 678, "Input",ExpressionUUID->"ede5addb-4f52-4997-ab1b-d7e9188dd84a"],
Cell[188088, 4022, 1385, 33, 416, "Input",ExpressionUUID->"512a6cc5-5dad-46de-ae8a-8876371c5eb0"],
Cell[189476, 4057, 176, 3, 64, "Input",ExpressionUUID->"e15bb4f7-7940-4728-9894-b63384618db8"],
Cell[189655, 4062, 1522, 49, 372, "Input",ExpressionUUID->"50859fe7-d76d-4fc8-bdfd-32411248c306"],
Cell[191180, 4113, 644, 17, 64, "Input",ExpressionUUID->"6b857406-5b4c-4dc6-860f-c85643b6a767"],
Cell[191827, 4132, 1690, 45, 372, "Input",ExpressionUUID->"f3078d6d-2edf-48e7-8eea-e986b895ea6e"],
Cell[193520, 4179, 447, 9, 64, "Input",ExpressionUUID->"045c2ab7-1d9b-44be-a4a9-873f64f19005"],
Cell[CellGroupData[{
Cell[193992, 4192, 260, 6, 64, "Input",ExpressionUUID->"639bd85e-07a9-489e-a6df-70cbf34641ba"],
Cell[194255, 4200, 317, 8, 74, "Output",ExpressionUUID->"a22295f0-77d6-4391-b2f0-f5dc6c1bdaa4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194609, 4213, 209, 4, 64, "Input",ExpressionUUID->"e5e44c11-6fa8-4612-a7bc-aa830e6c6a6d"],
Cell[194821, 4219, 208, 4, 74, "Output",ExpressionUUID->"50259d9e-05ff-422f-a1a7-ff56a47acb55"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195066, 4228, 231, 5, 64, "Input",ExpressionUUID->"d258c835-0ebe-46a1-8d34-69be94858f48"],
Cell[195300, 4235, 302, 5, 118, "Output",ExpressionUUID->"a7426422-10c7-41ed-a203-004df7e75736"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195639, 4245, 260, 6, 64, "Input",ExpressionUUID->"30d29b19-3dba-4c66-84aa-cb3412e60923"],
Cell[195902, 4253, 309, 7, 74, "Output",ExpressionUUID->"8a2b9ad3-dc45-4fa9-9616-dd86d35ecc67"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196248, 4265, 234, 5, 64, "Input",ExpressionUUID->"9970468b-8552-4b0e-8733-120d7384db44"],
Cell[196485, 4272, 190, 4, 74, "Output",ExpressionUUID->"39444235-a84c-4305-81ca-11aa1663f460"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196712, 4281, 245, 5, 109, "Input",ExpressionUUID->"ee5f5fe7-67f0-4ce1-94c3-bbef3a105e44"],
Cell[196960, 4288, 190, 4, 74, "Output",ExpressionUUID->"b97ea1aa-f0b7-49fc-aca4-ade8c64cd09d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197187, 4297, 1166, 30, 285, "Input",ExpressionUUID->"3dfd0eb4-7a6e-4624-9bf2-9258a8351792"],
Cell[198356, 4329, 415, 10, 50, "Print",ExpressionUUID->"a12c0f7a-5bb5-4a2c-bb1f-8bafffe0a09d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198808, 4344, 269, 5, 64, "Input",ExpressionUUID->"3bf7bd06-68e6-4db9-a8b5-8aae16c7381b"],
Cell[199080, 4351, 779, 16, 206, "Output",ExpressionUUID->"a3762bba-cb6d-435c-b5b4-7acdb03c004a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199896, 4372, 1426, 40, 197, "Input",ExpressionUUID->"6c7aa381-d3e6-48f5-ab1e-7a418eac01e7"],
Cell[201325, 4414, 226, 4, 74, "Output",ExpressionUUID->"b4f146a0-8d9f-45f4-9783-5b2251bfe2b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201588, 4423, 217, 4, 64, "Input",ExpressionUUID->"e60b3634-4211-463d-abb5-0691a392a808"],
Cell[201808, 4429, 1206, 25, 403, "Output",ExpressionUUID->"9434154e-dc52-4150-958f-596d36d17c1d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203051, 4459, 862, 23, 153, "Input",ExpressionUUID->"01a9118d-564b-474b-a13c-66bb5ac2b037"],
Cell[203916, 4484, 16041, 317, 197, "Output",ExpressionUUID->"13496c5d-3cd6-4e65-9e36-74a0cdbe8f8a"],
Cell[219960, 4803, 271, 4, 74, "Output",ExpressionUUID->"999fd085-c1c3-4b04-844a-0abd566cff0b"]
}, Open  ]],
Cell[220246, 4810, 874, 24, 240, "Input",ExpressionUUID->"2d92d2f4-55d7-4c1e-a419-3ed63f57f1f5"],
Cell[CellGroupData[{
Cell[221145, 4838, 255, 6, 64, "Input",ExpressionUUID->"e94e1f6d-2455-49fb-a2aa-ecd8e2ec8633"],
Cell[221403, 4846, 362, 11, 74, "Output",ExpressionUUID->"420795de-2fc0-43fe-af18-d68b5fc05e8a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221802, 4862, 257, 6, 64, "Input",ExpressionUUID->"79595480-44fa-4943-b07c-0136e1a30a69"],
Cell[222062, 4870, 307, 8, 80, "Output",ExpressionUUID->"56852b2e-190f-43e2-a254-0bfbf4978ed1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222406, 4883, 411, 11, 117, "Input",ExpressionUUID->"57cb1ca1-0a2f-4a03-a7ab-c3c1507ab6ef"],
Cell[222820, 4896, 222, 4, 74, "Output",ExpressionUUID->"f1c8f2d2-7ed4-49ab-9ccc-9afcef343812"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223079, 4905, 439, 8, 203, "Input",ExpressionUUID->"15211551-3932-4f31-950e-39447a6c1068"],
Cell[223521, 4915, 237, 5, 74, "Output",ExpressionUUID->"6c963a0f-1ac6-4835-b281-3448c095c921"],
Cell[223761, 4922, 221, 4, 74, "Output",ExpressionUUID->"3f81fdd4-9c71-4ed0-8a2c-83c7adbb6e9a"],
Cell[223985, 4928, 221, 4, 74, "Output",ExpressionUUID->"2f353d47-cc87-4337-bad5-7b83dcd81347"],
Cell[224209, 4934, 221, 4, 74, "Output",ExpressionUUID->"3c5cc08c-4735-4193-b955-2ecf9b7da2ce"]
}, Open  ]],
Cell[224445, 4941, 373, 9, 64, "Input",ExpressionUUID->"68798ca0-7abd-4f19-8a96-3564e762f0cf"],
Cell[CellGroupData[{
Cell[224843, 4954, 386, 10, 70, "Input",ExpressionUUID->"86748160-80c1-4fe9-b824-6e1612078eac"],
Cell[225232, 4966, 539, 14, 52, "Print",ExpressionUUID->"7bc6a75c-dcd0-4edc-ab4e-772b0c082fb2"]
}, Open  ]],
Cell[225786, 4983, 1143, 36, 240, "Input",ExpressionUUID->"9c3587ed-9559-4a6b-a32c-f90938eb733b"],
Cell[CellGroupData[{
Cell[226954, 5023, 599, 18, 233, "Input",ExpressionUUID->"e327b21e-c4a0-4f6f-b73d-b9ce1223e720"],
Cell[227556, 5043, 253, 6, 98, "Output",ExpressionUUID->"3902177d-14bc-4e1d-8ae2-358271129d3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[227846, 5054, 237, 5, 64, "Input",ExpressionUUID->"18bc40b5-3bc0-4604-9659-07bf3cad0db6"],
Cell[228086, 5061, 260, 6, 74, "Output",ExpressionUUID->"155d4730-310e-4873-949e-d8314b74526a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228383, 5072, 1092, 34, 290, "Input",ExpressionUUID->"e58fb51b-9d15-4968-b749-008dd5be8d34"],
Cell[229478, 5108, 293, 6, 74, "Output",ExpressionUUID->"c701d54e-caa5-4a08-932f-a2a9cdef35d0"],
Cell[229774, 5116, 365, 8, 80, "Output",ExpressionUUID->"d7dc8d4e-a625-4a66-8b01-71075301abf1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230176, 5129, 1120, 33, 370, "Input",ExpressionUUID->"689ca1a7-0385-4153-bc8a-8e667cbcd9e0"],
Cell[231299, 5164, 427, 11, 98, "Output",ExpressionUUID->"999057a1-2624-4f3f-9606-709f86473a01"],
Cell[231729, 5177, 427, 11, 98, "Output",ExpressionUUID->"d98067af-5738-423f-acda-55351b253e7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[232193, 5193, 555, 15, 149, "Input",ExpressionUUID->"a998d9a2-f94c-454b-a37b-b75854322959"],
Cell[232751, 5210, 222, 4, 74, "Output",ExpressionUUID->"cd7b2f3b-eda0-4390-9ebc-112ed6b9384b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233010, 5219, 997, 31, 238, "Input",ExpressionUUID->"81b76024-b473-4bbd-8f5e-273e1a22c268"],
Cell[234010, 5252, 353, 8, 74, "Output",ExpressionUUID->"c8693571-53ba-420b-8354-f04647a65424"],
Cell[234366, 5262, 7086, 152, 294, "Output",ExpressionUUID->"ac17047f-dd45-4650-b04f-0e8aa7927116"]
}, Open  ]],
Cell[241467, 5417, 1960, 62, 290, "Input",ExpressionUUID->"79ab5810-6a49-467e-9a6d-7222893566cd"],
Cell[CellGroupData[{
Cell[243452, 5483, 1665, 50, 290, "Input",ExpressionUUID->"07f7f4c3-5820-4314-939b-67b3c642b062"],
Cell[245120, 5535, 10765, 196, 582, "Output",ExpressionUUID->"448a9ee9-2ed6-4838-8b4e-053be2a2644f"]
}, Open  ]],
Cell[255900, 5734, 1148, 37, 211, "Input",ExpressionUUID->"907bce48-a981-4d1f-bd2d-d0a15d575636"],
Cell[257051, 5773, 1394, 38, 175, "Input",ExpressionUUID->"fde208aa-8a72-4325-8636-7014326bd34f"],
Cell[CellGroupData[{
Cell[258470, 5815, 1222, 32, 211, "Input",ExpressionUUID->"c9495c78-8c26-48c4-82f3-ff2e188ff6e9"],
Cell[259695, 5849, 388, 10, 107, "Output",ExpressionUUID->"fae8fec6-2ff4-4d83-baa3-86e4375bf7f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260120, 5864, 230, 5, 64, "Input",ExpressionUUID->"f6ae0bf6-afcb-4823-849e-91c07f03d266"],
Cell[260353, 5871, 296, 7, 74, "Output",ExpressionUUID->"45f0015d-71c5-4ce1-b3cc-c34f91355db2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260686, 5883, 284, 7, 64, "Input",ExpressionUUID->"b9c7c228-90b6-4aae-90d6-bf620168de54"],
Cell[260973, 5892, 1274, 36, 563, "Output",ExpressionUUID->"d8ecdeeb-6af3-4744-9a28-828614e42f10"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262284, 5933, 364, 10, 64, "Input",ExpressionUUID->"d515e9a9-99d2-493e-a316-0bac2fe3a110"],
Cell[262651, 5945, 1383, 38, 563, "Output",ExpressionUUID->"beacb9d8-fa0b-4c0e-a7ec-69cf81f7907a"]
}, Open  ]],
Cell[264049, 5986, 428, 12, 64, "Input",ExpressionUUID->"2d8ca164-2f98-4d88-8dec-08e553018c05"],
Cell[CellGroupData[{
Cell[264502, 6002, 1553, 40, 416, "Input",ExpressionUUID->"7bb56512-cb57-4a8e-a0ad-56eac5dfbdec"],
Cell[266058, 6044, 1765, 46, 563, "Output",ExpressionUUID->"b0f75727-370e-4923-a746-912e94a7787a"],
Cell[267826, 6092, 591, 13, 74, "Output",ExpressionUUID->"73217904-b982-4868-8eb5-54ce2ccecfe6"]
}, Open  ]],
Cell[268432, 6108, 2539, 78, 747, "Input",ExpressionUUID->"e51bc3b2-5fdf-4bf7-801c-3e809cd432df"],
Cell[CellGroupData[{
Cell[270996, 6190, 242, 6, 64, "Input",ExpressionUUID->"f2cede81-687a-4e04-a4e6-84918bae6822"],
Cell[271241, 6198, 366, 9, 112, "Output",ExpressionUUID->"71f1afcf-9b6c-4234-b595-aca01a506ba8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271644, 6212, 739, 20, 120, "Input",ExpressionUUID->"70df4d57-94f3-4c04-ac88-4a67eb9ea234"],
Cell[272386, 6234, 20192, 461, 471, "Output",ExpressionUUID->"710de8f2-c30d-4190-8047-a5246614f939"]
}, Open  ]],
Cell[CellGroupData[{
Cell[292615, 6700, 708, 19, 120, "Input",ExpressionUUID->"e1fcc269-381a-42a7-b24f-35765d76e0a3"],
Cell[293326, 6721, 21633, 492, 445, "Output",ExpressionUUID->"055e99fe-d04e-4bc8-8fd0-cc52a8b70149"]
}, Open  ]],
Cell[314974, 7216, 278, 8, 64, "Input",ExpressionUUID->"dbfa7378-5668-4002-868a-3a25c91d3063"]
}
]
*)

