(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26236,        591]
NotebookOptionsPosition[     25122,        563]
NotebookOutlinePosition[     25603,        581]
CellTagsIndexPosition[     25560,        578]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"765fac16-ef7e-48c1-ac30-f6a15112985e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soly", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "-", "y"}], ")"}], "*", "Pr", "*", "Ps"}], "\[Equal]", 
      "y"}], ",", "y"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.75358392059375*^9, 
  3.753583959*^9}},ExpressionUUID->"01cb38bc-eae0-42a4-880c-837f5f3263f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   FractionBox[
    RowBox[{"Pr", " ", "Ps", " ", "u"}], 
    RowBox[{"1", "+", 
     RowBox[{"Pr", " ", "Ps"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333521256916*^9},ExpressionUUID->"3bb934a3-6e67-40ac-968a-\
cc5bba23355b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"example1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ps", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        RowBox[{"\[Tau]1", "*", "s"}]}]]}], ",", 
     RowBox[{"Pr", "\[Rule]", 
      RowBox[{
       RowBox[{"kD", "*", "s"}], "+", "kP", "+", 
       FractionBox["kI", "s"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"trf1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"y", "/.", "soly"}], "/.", "example1"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7535839791875*^9, 3.75358406746875*^9}, {
   3.753584117234375*^9, 3.7535841200625*^9}, 
   3.753584197671875*^9},ExpressionUUID->"96cdae4c-b0ab-4272-8046-\
8dac2e1cf315"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"kI", "+", 
     RowBox[{"s", " ", 
      RowBox[{"(", 
       RowBox[{"kP", "+", 
        RowBox[{"kD", " ", "s"}]}], ")"}]}]}], ")"}], " ", "u"}], 
  RowBox[{"kI", "+", 
   RowBox[{"s", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "kP", "+", 
      RowBox[{"kD", " ", "s"}], "+", 
      RowBox[{"s", " ", "\[Tau]1"}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{
  3.8473335213194027`*^9},ExpressionUUID->"6ab9934a-0e88-4d9d-a943-\
fe31e110a6d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"outLaplace", "=", 
   RowBox[{"trf1", "/.", 
    RowBox[{"(", 
     RowBox[{"values", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Tau]1", "\[Rule]", "1"}], ",", 
        RowBox[{"kP", "\[Rule]", "5"}], ",", 
        RowBox[{"kD", "\[Rule]", "0.5"}], ",", 
        RowBox[{"kI", "\[Rule]", "2"}], ",", 
        RowBox[{"u", "\[Rule]", 
         FractionBox["1", "s"]}]}], "}"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outTimeDomain", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{"outLaplace", ",", "s", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outP", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", "kP"}], "/.", "values"}], ",", "s", ",", 
     "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outI", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", 
       FractionBox["kI", "s"]}], "/.", "values"}], ",", "s", ",", "t"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outD", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outLaplace", "*", "kD", "*", "s"}], "/.", "values"}], ",", "s",
      ",", "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"popis", "=", 
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"values", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", "a", "]"}], "<>", "\"\< = \>\"", "<>", 
      RowBox[{"ToString", "[", "b", "]"}], "<>", "\"\< \>\""}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pla", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outTimeDomain", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\< \!\(\*StyleBox[\"outReal\",FontColor->RGBColor[1, 0, 0]]\) \
outDesired\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "popis"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plb", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outP", ",", "outI", ",", "outD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Magenta", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t [s]\>\"", ",", "\"\<outsReg\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{
      "\"\<\!\(\*StyleBox[\"outP\",FontColor->RGBColor[0, 0, 1]]\) outI \
\!\(\*StyleBox[\"outD\",FontColor->RGBColor[1, 0, 1]]\)\>\"", "<>", 
       "\"\<\\n\>\"", "<>", "popis"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{"{", 
   RowBox[{"pla", ",", "plb"}], "}"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753584141578125*^9, 3.753584316*^9}, {
   3.75358436790625*^9, 3.75358462721875*^9}, {3.753584668453125*^9, 
   3.75358475271875*^9}, {3.75358499859375*^9, 3.7535850486875*^9}, {
   3.75358510321875*^9, 3.75358512653125*^9}, {3.75358520246875*^9, 
   3.753585250234375*^9}, 
   3.7535852864375*^9},ExpressionUUID->"08ccb811-d7fb-4efc-81bc-b435081cb88b"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0nk41IkfB3BH9ZXpwEqRVGgUSqWLfnl/UWyiy6Ii5Sgjs4VNisrRUjGT
q2zk3BKzdKjt2rVK7lzJMck5hhkzY76uViHZ+f3xeT7P63k+f3zez/Ne6Xnm
4AkFOTm5W7L5//6653T6/jP+FgfbGj46ObUg2ttgdQN9L9Li8q6e+aUFdVTf
KTbdHVXDc+f5J7Rg+Kk1i0k/DQs5PcmquhZEaoxpu9EvI7+mxdnHuhU1lXb9
jvQbOOm1wc7RiIszWeeq99EzkF23yeSY6CNKWKy/HegPUeDC+iNWtwPF4rZa
Guch1LZOZ8ze0YGiHw26qo0eocLI77GPSwdcFTzk7i55jDkqjMi+2A44FU/p
LtcphL1Dsm3pWAfstmxgLF7zFMwhW/PVrzthSk8bJfAChS99mnV3dWP2nEBC
dOo1otKqO7Xm8jCwO2zhWO5r6HnONZ1Q4+Edm7V4uu81tGcYOxu0eaiMaUq6
ZvIGjkFyLz3X8xCrRt1N47yB7+2oPAMXHtR19crK0ksQw7n/zuQuD3RL9qxF
0aUQT895xdjci91hHlHPnCtx9lfjZ0JrPjbGldhkn61E77rHe0v28KGduVKJ
nVgJxk3tiJuOfAwX82K862X35/dUGHjxkfzdI/4Hmyqom+9iKETy0XfJ807A
5mp0hIw8YBXzEX7Rq3Cteg32vZ8dqGnahxcXTnTmNNZjxvXvCwa0fty38ONq
jdbD6ZEvV1OtH8mKAY1xag2412anPUezH+fYF8svODbg6KeRgFp6P7ZkJz1w
aGnA9pBqoYpVP1z7eopDmO8xySotuxTcj0+0hXG6/o3of597YV5XP9qO+JkE
Bjdh6y7a1OI7AsT02jJ/i25C5Nm6SocsAcxP6XOKbjVBpWSda1iOAGkXOnWJ
P5vANtjS1/JIgOO392mkDTdhsCWMv79MAGGL6XS5bzPsWdsfRgwK8O/+b+80
3VrAWhGaIDATQtWWfbKE5EK87L1qULUQOzlFMDrAhT/HRE+tXojztMEltzy4
sH8kb5r/QYieBrsaRiQXTkHlbo3tQjw+pLRepYyLBUbRoKRC7D91ZcLd9iN8
jv/O/Fl1APHsC6xvDm3I4RvNT3UagErziSdbXdvR9i7X2qdpAKTUUvyTXztU
Oa0F87kD8J+joxsY2g5qPnN24acBNG5rTSi4046+9T1xFG8Aiek2ASs72nFg
wYTzruEBLPIxWE872oHY2iULvOeJoDU58KDLvRP/8/fNPm8lgt4KJifKsxu1
azuLY+6LwOpamc0O6EbWx+V+ezkijKdxb98K74aD38D4wgIRqjStr+VkdEPc
tulPVqEIzB+0fMo/deN90bUvzCIRXBW9EyPX9EApMs3wXaMIOeOq+99m90Bn
xzJLxSkRtnX+XGOZyINC+vKIGlsxHq4JXMRIlfW6ISpsl50Y+ufOHbvxOw+0
vivB/9iLobIwbOzTEx7c5ua55h4QQ0TGLz3bxEPw1SYDL1cxUu898buv3gtD
4oD3xdNifPP7QqP91osZ+/QiyyQxSibD7Zvv8PGDWq55EFeMZs3A8TN3+WB2
V5cdahNDsM0ri5bPh0ruCqF5uxjzgnd9tvqLj7tr101MdonhPDY3rfAjH5PE
4C+nBGKIJYmSG4v60Gz1spr4Vwz1znsxu+P6sLHnybC1qgSM11VVxZH9cHDx
6Pq+S4IJMxXdTTH9cPNe7njdVoKYP11COQmyXmcbPFbbLUE+R7D2ZlY/LI48
o+vaS0AlzUryLe5HUMOIzqaDEpxlkEfVJ/uRatGqsMpdgnDVlyO+AQIoHyzP
I4MkSPHK1Vp0XIjuj2Hp7CwJmHuWvDVmCOH01lT6OVsCC9Prvjv9hXhVtHeD
610JehX8Xv4SLsSaJ8Gp+vclMP59nfOHLCH4QcnK+fkSFPc8S4jjCaHhttvk
6nMJ+EfLlJS9BjAaalkdWSPB2kO88e8nRGhesDTj+agEXWP76klZjtGL2tsM
TQcx2q25XsNJis+Ziw86nh5EfH6Ij4vLEEoT40sfZA6CvlDJ4fydYXyTEsZ+
lYN47h+efyNzBIc543lfBgfRvCqJOJA4CvnuiRVlNCn0rzStPpoyhhD5oe7j
a6Qw29+9KfPOZ1QtE2sftpai0z/Kgs36F83JmV8dDkvxxOzw/PKEcXy4+LRT
9YwUGs6VbXlRX7BK6udUGyEFeuUS3p79ii3af9cNJEqRosGYTz8/gUmFPXJ7
7kkRmeF7dfOpSUzATTHpqRTp9bcrbvhPQa9144hVqRSXTicNLwv8hqTWsGOC
RikkHquXHPacxk9TxxePd0kROy2e1XXyOwzfOnFvDErx16Dt0IIjM7BSKc2o
+CpF66ptveb6cuTlnQa/HplFgbHGyyQpR46cyjF8FKlCocTZNdRSR578SOtV
jlhKwfSQmKOeLU9GXL1irmZAgXnFhrtjqQKZ/342Fb+BwrWTSpPySQqkx8Pa
VcnbKfyzzGNGrK5ImmaGKBrbUHj1PVrR8IYiqba5KbJ2H4X6p9Zituos8oHh
A+OvhymUrzhZwUqcRTJNfkx86kXh1xdO2Tzl2eQfwmDNeCYFN90Od1f2bPJD
6qHEkSAKU89NlhoRc8gK5+Dnly9TuKgoqr11eQ6Z432543E0BQ19M49VcgR5
P6/AyCOOQvBp58/KFwhSi7y+0+E3CtpbvKvooQTZtdLBwl/mN9MBaVaXCDLF
JmVTkszKbPbOkAiCdFes1WiTOSO/7KboOkE6D94v9L5NoWJg4+aqVIKkGcdZ
hqZQUPdaeC6qiCB5PUp1OXdkeQ2X2WUXE6T9pexDVTK7jxrq/POGIOXON/SI
Zc6LsKn4XEaQ1vpSgUkahe1ZlzS86whScsv83SuZPTslz626CDI8MFham06B
yJmIce+R/a+QbDUkcwGTOBbSS5AxjvtvqmZQGJ/SJZ4ICFK/MWWts8wxWkdc
Vg4RpIpN7NZumU16fYx2jBBk91higHwmhWZO0MyhMYLcE2uWpyezjllCbvwX
ghxSOkFjyFwqlxlaMEGQvS/EW2NkZlQV7KuaIsg+nopHgczz4v/S65smyEUS
bnS9zIUuVV9mZgjy3FaSMyzzf0P6nqE=
           "]]},
         Annotation[#, "Charting`Private`Tag$2234#1"]& ], 
        TagBox[
         {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/cM7b25AfoEdAxh8sM9fUHbSX22ePYx/sKdnt6/a
Ojifla2I/WXWfjjfsz6xdWvYcTh/e2Xq3aUXz8H5N6Oy9YvKL8P5gu69aQcd
rsP5AldSN5lH34bzlRVyVrYm3YfzLe7mnnac9BDhnl8NPldmP4bzM/afOLGv
6SmcPzN5uZRownM4Xzfi4bd/qS/h/Huf/c85eL6G8z/dlzQQC30L509YXZUe
Hv4ezlfj5/CtmP0Bzt9W0LC6b/5HOP+K6mT2wEmf4HyV5ssasTM/w/mWAfdN
5s/+AuffLWi16+35CudvsozkPTrxG5wvFnb85orW73C+/SOGiYdKfiD8J5bB
q1bxE85vmpfZbpr1C86fe27Gsb6C33B+bd7kD7JFf+D814kaEpFJf+H87r+v
WO6l/YPzd71xf88X9R/Ov6Zq8chKhcEBHt6ayfqTlyL4B8Oiqx3lGOF844hX
K0UWIvg5zW7XbaWZ4PyONI5fjJMR/L2yif9fiTDD+Tv/tTFr9SH45zY7v+oV
ZIHzjyqkHeuZhOC3bA9d+JCLFc6PUboTF92L4P/epi+tzc4G59cwvzwztQ7B
F1OxTFRlYIfzy/PCvnBVIvgiyfxlrXsQ/I3hJ77//4/gAwBtO/5l
           "]]},
         Annotation[#, "Charting`Private`Tag$2234#2"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{
        FormBox["\"t [s]\"", TraditionalForm], 
        FormBox[
        "\" \\!\\(\\*StyleBox[\\\"outReal\\\",FontColor->RGBColor[1, 0, \
0]]\\) outDesired\"", TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
        AbsolutePointSize[6], "ScalingFunctions" -> None, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox[
        RowBox[{"{", 
          
          RowBox[{"\" kP = 5 \"", ",", "\" kD = 0.5 \"", ",", 
            "\" kI = 2 \""}], "}"}], TraditionalForm],
      PlotRange->{{0., 2.99999993877551}, {0, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {189., -118.66252583997979}, 
     ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV1Xk4lQkXAPBr67227vu+95KlyJKSJm2atDhHGYqpNE2IyJrlGts0DGoS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           "]]},
         Annotation[#, "Charting`Private`Tag$2340#1"]& ], 
        TagBox[
         {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJwVjns01HkYxgfD14p1+5lQKrfJZTdKlO3kfcMiXVRyibK5W0lWlhANUa01
NtQ5RIMTaRqXYo0tuSaNk8ihRa27yiUZtOPO2j+e83z+ec7n0fS6cMJXnEaj
Oa7n/54/FHz32IUQi3XcXD/ma3HNZ7teG/Mo0PLDZuX1rOH1l5FANtMDaMZB
FrJmJ0FYbpUcxAwGWm73+I4TPhDPmN18mhkLNE0xak9SGLx6af/BkZkCrGTH
ueH5BLiQG97swOQA62nvvYw3t6E+ObnqCLMEhKI3/i6BhVAz3tOygVsCCnPS
i6zeQnhmt72v2bAUsGfbDcbxB+Au7km7p/oI6vQ5SgnmXHCqWdLauuUxsIK+
c/CQ54G92c6AjfrlMLDJdrmqtQRMmNkzBCphfrXwcPPhcpCUCiVjgbWgV+C7
e+/9Kjh4xTOxwvkldGdFKOdcaYLKSN/egvZW+Jxl1+851QY9bueMQiM6YF6P
z7eKfwuKtmy/euwC1TApn1rae1Do9C3b4/4e9DlOUiOcAdDeFsRN9OqHzIB0
nWctw7C39/yrA2mD8E4iV5LT8xHqF1mHO7OGgWuvuti4bxwCagWCmvgPwJKO
dfO5OAmZ3oXqKmc/AbXzuKmFoxC+dx0UrfqOQXy+u5G8ygz0zTq04sEJqLhb
oUxVz8JMv5oxw2kS3ub8ZXw/+V+4yYvyd3GZAhU+aGu7zAFTXvrIpSwhCIaf
i05ILgA/hMVLyZkGvn3csvu7RejUTSfH02bgUVxGi37aMuhc7dA7kzkLA3HF
UdyQVTA/1r87J+srpCyH71LToWFvSKIFe93TMqs4XEsTwzLzU3IvUkUQZWeW
XSwUQ4bzy54HiXOQQRe9tW8XRxiipTaEzYOaeng2vUQCMxkBcsxLC/Bq8UU7
nUPHeM7P100DFyH44fJ0RKwk3m3NaEoJWYKThccmzUOlMCY4XagRugyBVjOF
4l4EJzz1VE95rUCSnYWPoqU0/r4yTu/zWwWX6Lb6S6bf4NPPtlPfuq1BQGLd
H4pqMvi37t6hH9Z/G3+ix1+fl8EAfW+j9AIacu04xZ4TG7De2T36wBYxtLKo
KD7aKosmruNcKk8MmTEf5XmNchh01aZr/yZxfOSd1CHD+xZv+EkviqWLY2Ku
vbUJWx6rNTzXxikJNBN1pJ87oIBPVq9JGKRIoPHZi927/lTA1nKrcbYiHTMM
eVurjRXxxTa/puQ0OuYPCM8b8BQxodIpb1BGErVXijhxGkp4WusfD3e2JLKU
393Jy1TCJb7RJkMihQxCuAVyynhZYqzldqwUaiopMOKuKCNDx9xTl0awZ/5Q
qcGSMkYEO3+ViSQ4KErJKQmmcLOZj4AZTbBBcqK0LITCupVfsi1jCGqt3mrg
h1Iow2ZbR8URjKlv/1ITTiGH13hr7DeCZTtGvdpiKWwa3WUquENwY5bTE2EK
hZS3fHjiM4L6o1kapqUUPjHQsM+rIWh5xjrC/DGFHjMGW6rrCDZHmnTsL6fw
QZxN09dGgvkNI6k2lRTuy41h+Lwm2G7LNnCtpdCrd4Jv2UeQ2f1cEN1GISlY
SPIYIKj5psqG1U5hURD5KWqIYHW3qCmhg0LRkhYp+0iQ2mPayu6iMEndzUVz
iqDxaMtcTj+FRkP+hvunCRLdruv5gxR2cn9dc50lyOFqqXOHKdxinlp4c259
f//yj2WfKHxOy4kuWiAoW5TUxx+jMEBQ5CBYIjit0hNZNUGh7M2n2iMrBPsf
+m+sm6TwsYtgbm2N4MJOs8rGKQr/A/bAWcI=
           "]]},
         Annotation[#, "Charting`Private`Tag$2340#2"]& ], 
        TagBox[
         {RGBColor[1, 0, 1], Thickness[Large], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVlnc41Y0DxZW4Iq8IldKLzCjRol7Ol4zSUi+FJCuZhVdC4iKyN8mWkRHl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           "]]},
         Annotation[#, "Charting`Private`Tag$2340#3"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{
        FormBox["\"t [s]\"", TraditionalForm], 
        FormBox["\"outsReg\"", TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
        AbsolutePointSize[6], "ScalingFunctions" -> None, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox[
       "\"\\!\\(\\*StyleBox[\\\"outP\\\",FontColor->RGBColor[0, 0, 1]]\\) \
outI \\!\\(\\*StyleBox[\\\"outD\\\",FontColor->RGBColor[1, 0, 1]]\\)\\n kP = \
5  kD = 0.5  kI = 2 \"", TraditionalForm],
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {189., -355.98757751993935}, 
     ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8473335221629534`*^9},ExpressionUUID->"ae2c77e8-03a7-46a4-b9c9-\
380a85dc30c5"]
}, Open  ]]
},
WindowSize->{1120, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 387, 10, 106, "Input",ExpressionUUID->"765fac16-ef7e-48c1-ac30-f6a15112985e"],
Cell[CellGroupData[{
Cell[957, 34, 415, 12, 45, "Input",ExpressionUUID->"01cb38bc-eae0-42a4-880c-837f5f3263f3"],
Cell[1375, 48, 293, 9, 79, "Output",ExpressionUUID->"3bb934a3-6e67-40ac-968a-cc5bba23355b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1705, 62, 716, 20, 115, "Input",ExpressionUUID->"96cdae4c-b0ab-4272-8046-8dac2e1cf315"],
Cell[2424, 84, 518, 17, 83, "Output",ExpressionUUID->"6ab9934a-0e88-4d9d-a943-fe31e110a6d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2979, 106, 4319, 119, 606, "Input",ExpressionUUID->"08ccb811-d7fb-4efc-81bc-b435081cb88b"],
Cell[7301, 227, 17805, 333, 706, "Output",ExpressionUUID->"ae2c77e8-03a7-46a4-b9c9-380a85dc30c5"]
}, Open  ]]
}
]
*)

