(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     71748,       2094]
NotebookOptionsPosition[     66062,       2003]
NotebookOutlinePosition[     66523,       2020]
CellTagsIndexPosition[     66480,       2017]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"users", ".", "fit", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "stampfra"}]}], "/", "lectures"}], "/", "lin"}], "/", 
     "lin"}], "-", "prednaska", "-", "14", "-", 
    RowBox[{"handout", ".", "v1", ".", "pdf"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6856836586400037`*^9, 
  3.6856836622806287`*^9}},ExpressionUUID->"6ebce331-a2f7-490f-84fc-\
b4a55addd8e8"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "popovidat", " ", "o", " ", "experimentalni", " ", "matematice", " ", 
         "s", " ", "pouzitim", " ", "nahodnych", " ", "cisel"}], "..."}], " ",
        "slo", " ", "by", " ", "o", " ", "tom", " ", "delat", " ", "doktorat",
        " ", "na", " ", "statistice", " ", "a", " ", "pravdepodobnosti"}], 
      "..."}], " ", "ale", " ", "jistotu", " ", "inzenyrum", " ", "neda", " ",
      "nic"}], ",", " ", 
    RowBox[{
    "tedy", " ", "pravdepodobnost", " ", "a", " ", "statistika", " ", 
     "zvetsi", " ", "pravdepodobnost"}], ",", " ", 
    RowBox[{"ze", " ", "jsme", " ", "nevypocitali", " ", 
     RowBox[{"pitomost", " ", ":", "-"}]}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.68572043146875*^9, 
  3.685720524296875*^9}},ExpressionUUID->"c6cc6347-d9bf-48a4-8aa9-\
6ec262c4beff"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sortByImag", ":=", 
   RowBox[{
    RowBox[{"Sort", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Im", "[", "#1", "]"}], "<", 
        RowBox[{"Im", "[", "#2", "]"}]}], "&"}]}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"randomMatrix", "[", "rnm_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "&"}], "[", "i", 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6856875226556287`*^9, 3.6856875658743787`*^9}, {
  3.6856878199368787`*^9, 3.6856878215931287`*^9}, {3.68571858965625*^9, 
  3.685718645375*^9}},ExpressionUUID->"5087cceb-51fe-434f-ad1d-e54623583f30"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
   RowBox[{
    RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Inverse", "[", "P", "]"}], ".", "A", ".", "P"}], "//", 
    "Chop"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "mf"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sortByImag", "[", 
      RowBox[{"Eigenvalues", "[", "diag", "]"}], "]"}], "-", 
     RowBox[{"sortByImag", "[", "lambdas", "]"}]}], "}"}], "//", "Chop"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685683424625*^9, 3.685683427375*^9}, {
  3.6856869625775037`*^9, 3.6856869639837537`*^9}, {3.6856871341556287`*^9, 
  3.6856872405931287`*^9}, {3.6856872751712537`*^9, 3.6856873130618787`*^9}, {
  3.6856873595462537`*^9, 3.6856874004525037`*^9}, {3.6856875840150037`*^9, 
  3.6856875882806287`*^9}, {3.6856876514993787`*^9, 3.6856876959212537`*^9}, {
  3.6856878448900037`*^9, 3.6856878511243787`*^9}, {3.6857172029375*^9, 
  3.68571723615625*^9}, {3.6857186751875*^9, 
  3.68571867653125*^9}},ExpressionUUID->"429799c8-ce34-48af-81c5-\
f5d703da1345"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.4499527993439698`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.26246018311032815`", " ", "\[ImaginaryI]"}]}], "0", "0"},
     {"0", 
      RowBox[{"0.44995279934396976`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.26246018311032826`", " ", "\[ImaginaryI]"}]}], "0"},
     {"0", "0", "0.05014184080337665`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8473338079135237`*^9},ExpressionUUID->"0e698630-a4c8-4b5c-bb08-\
0280e71c98c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333808569659*^9},ExpressionUUID->"1822d9b5-ddb9-4020-bc85-\
e78797f2823e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"functions", " ", "of", " ", "matrices"}], "..."}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix_", ",", "function_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "lambdas", ",", "vectors", ",", "P", ",", "invP", ",", 
         "diagonalMatrix"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
         RowBox[{
          RowBox[{"Eigensystem", "[", "matrix", "]"}], "//", "N"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"P", "=", 
         RowBox[{"Transpose", "[", "vectors", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"invP", "=", 
         RowBox[{"Inverse", "[", "P", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"diagonalMatrix", "=", 
         RowBox[{
          RowBox[{"Inverse", "[", "P", "]"}], ".", "matrix", ".", "P"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"P", ".", 
         RowBox[{"DiagonalMatrix", "[", 
          RowBox[{"function", "/@", 
           RowBox[{"Diagonal", "[", "diagonalMatrix", "]"}]}], "]"}], ".", 
         "invP"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{"#", "&"}]}], "]"}], "-", "A"}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{
        SuperscriptBox["#", "2"], "&"}]}], "]"}], "-", 
     RowBox[{"A", ".", "A"}]}], "//", "Chop"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"A", ",", 
       RowBox[{
        SuperscriptBox["#", 
         RowBox[{"-", "1"}]], "&"}]}], "]"}], "-", 
     RowBox[{"Inverse", "[", "A", "]"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6857173034375*^9, 3.685717580828125*^9}, {
  3.685717612265625*^9, 3.685717619109375*^9}, {3.685717694515625*^9, 
  3.68571784334375*^9}, {3.685717955203125*^9, 3.685718015671875*^9}, {
  3.685718048140625*^9, 3.68571805409375*^9}, {3.68571809434375*^9, 
  3.685718143109375*^9}, {3.685718698890625*^9, 3.685718705765625*^9}, {
  3.685778281015625*^9, 
  3.685778284234375*^9}},ExpressionUUID->"afb2a661-0554-4ed4-9751-\
8bc6291fd2f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333808632105*^9},ExpressionUUID->"75eff53a-d1b1-474a-ab4e-\
94932f324844"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333808647725*^9},ExpressionUUID->"80662809-e0e7-49e8-9038-\
25742cc4b53c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338086633472`*^9},ExpressionUUID->"92bceee0-0958-4dd0-bee0-\
7a840b977152"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dokazte", ",", " ", 
    RowBox[{
    "ze", " ", "pokud", " ", "takto", " ", "zavedeme", " ", "funkce"}], ",", 
    " ", 
    RowBox[{
    "ktere", " ", "maji", " ", "konvergentni", " ", "rozvoje", " ", "v", " ", 
     "Taylorovy", " ", "rady"}], ",", " ", 
    RowBox[{
    "tak", " ", "ze", " ", "vztahy", " ", "platne", " ", "pro", " ", "funkce",
      " ", "jedne", " ", "realne", " ", 
     RowBox[{"(", 
      RowBox[{"var", ":", " ", "komplexni"}], ")"}], "plati", " ", "i", " ", 
     "pro", " ", "prislusne", " ", "funkce", " ", "\"\<rozumnych\>\"", " ", 
     "matic"}], ",", " ", 
    RowBox[{
    "ukazeme", " ", "\"\<dukaz\>\"", " ", "s", " ", "pouzitim", " ", 
     "nahodne", " ", "matice"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Sin"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cos", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Cos"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exp", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Exp"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ln", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", "Log"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", "matrix_", "]"}], ":=", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{"matrix", ",", 
       RowBox[{
        SuperscriptBox["#", "2"], "&"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alfa", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"beta", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "/@", 
     RowBox[{"{", 
      RowBox[{"alfa", ",", "beta"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"2", "*", "alfa"}], "]"}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"sin", "[", "alfa", "]"}], ".", 
       RowBox[{"cos", "[", "alfa", "]"}]}]}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exp", "[", 
      RowBox[{"I", "*", "alfa"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"cos", "[", "alfa", "]"}], "+", 
       RowBox[{"I", "*", 
        RowBox[{"sin", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ln", "[", 
      RowBox[{"exp", "[", "alfa", "]"}], "]"}], "-", "alfa"}], "//", "Chop"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", "alfa", "]"}], "-", 
     RowBox[{"exp", "[", 
      RowBox[{"2", "*", 
       RowBox[{"ln", "[", "alfa", "]"}]}], "]"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.68571812734375*^9, {3.685718158515625*^9, 3.685718439*^9}, {
   3.68571875828125*^9, 3.68571881184375*^9}, {3.685718849171875*^9, 
   3.685718862140625*^9}, {3.68571893453125*^9, 3.68571898603125*^9}, {
   3.685719068890625*^9, 3.685719255578125*^9}, {3.685719309890625*^9, 
   3.6857193148125*^9}, {3.685719424890625*^9, 3.6857194463125*^9}, {
   3.685719481578125*^9, 3.685719639890625*^9}, {3.6857197019375*^9, 
   3.685719722265625*^9}, {3.685719772953125*^9, 3.68571984015625*^9}, {
   3.6857198815*^9, 
   3.685719921453125*^9}},ExpressionUUID->"0dfe432c-4228-46f4-b6d3-\
e7385866b1e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338086945896`*^9},ExpressionUUID->"0f4e5af1-1d14-476b-8a0e-\
b31af14baed9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333808710219*^9},ExpressionUUID->"02ccd073-f3b2-4da7-986e-\
46ad559d9f32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333808725833*^9},ExpressionUUID->"979c4089-3b54-4320-803e-\
99b38705c8d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338087414536`*^9},ExpressionUUID->"17add1f9-c737-4ff3-bbca-\
0e53867a9acc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPoints", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", "t_", "]"}], ":=", 
   RowBox[{"alfa", "*", "t"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejCislo", "[", 
    RowBox[{"fce_", ",", "matSkalarFce_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"matSkalarFce", "@", 
     RowBox[{"fuctionOfMatrix", "[", 
      RowBox[{
       RowBox[{"mat", "[", "t", "]"}], ",", "fce"}], "]"}]}], "//", "Re"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejPlot", "[", 
    RowBox[{"fce_", ",", "matSkalarFce_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "dats", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dats", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"vydejCislo", "[", 
            RowBox[{"fce", ",", "matSkalarFce", ",", "#"}], "]"}]}], "}"}], 
         "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", "tmax", ",", 
          FractionBox["tmax", "nPoints"]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"dats", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<t\>\"", ",", "\"\<fce[t]\>\""}], "}"}]}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
        RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matSkalarFce", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{"List", "\[Rule]", "Plus"}]}], ")"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"dejPlot", "[", 
  RowBox[{"Sin", ",", "matSkalarFce"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685721060203125*^9, 3.68572114934375*^9}, {
   3.6857212245625*^9, 3.685721329890625*^9}, {3.685721372203125*^9, 
   3.68572143103125*^9}, {3.68572146984375*^9, 3.685721590953125*^9}, {
   3.685721631421875*^9, 3.6857219174375*^9}, {3.685721992484375*^9, 
   3.685722109234375*^9}, 3.68572218078125*^9, 
   3.6857223648125*^9},ExpressionUUID->"ad4f7d39-ce4f-47be-92c2-d3238df8bacc"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQjR1csLc7o3NXuOXifgj/gb29a9nTixceQvkv7B/w
XbQMy34N5X+wt5KaWcp9+xOU/8X+T7KysFrEDyj/h/283ETbb6L/oPw/9jvT
GTn8PjEegFroULhd7+jkvSxQPpPDkZlRb47bsEP5LA5bSiuV8s04oXw2h7Ou
L7N3ZnFB+RwOvbJVYZOnw/hcDi3F+3LKa2HqeRw8JbYLHHrCBuXzOTi1359t
s5gJyhdw8OJhahNx/gl1n6BDEB/fv8yGx1C+kMOCOVO2fhN6ZA/hCzsE6tzc
tn/xPyhfxOGu1oRgLh1uBwhf1OGCifVF9TPCUL6Yw8Wb5Qle/yWhfHEHJ8XI
Y5LX5aF8CQeLGT5PDCqVoHxJh7zuZf93lapA+VIObpf2iR9YpwrlSzsE31F6
4fgVxpdxmN49keO1Aowv6zDzoHd8rLAylC/nMO/Rw0cny2D2yTscOJX4a4e+
GJSv4CCytOqd9QsWCL9BwWHKzszsF52w+FV0aHl6lOcGtzAkvBoUHTLtOCsE
7ytCw0/JYdOrO7vdkrSg8koOMdVKtaf8DKHyyg5Hy28KVXOaQuWVHSYcCll1
S84CKq/ioKCytaTcx+oAAO4usOI=
      "]]}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox["\"fce[t]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.}, {-26.298697752212433`, 10.979018453841638`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473338089133215`*^9},ExpressionUUID->"67e2dc81-5c03-4b4f-b695-\
50279fb2ac56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"co", " ", "takhle", " ", "vyzkouset"}], ",", " ", 
    RowBox[{"neni", "-", 
     RowBox[{"li", " ", "duvodem"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "ze", " ", "nejsou", " ", "stejne", " ", "diagonalni", " ", "matice", 
       " ", "a", " ", "transformacni", " ", "matice", " ", "P"}], "..."}], 
     " ", "za", " ", 
     RowBox[{"body", ":", " ", 
      RowBox[{"najdete", " ", "ruzne", " ", "matice"}]}]}], ",", 
    RowBox[{
    "ntere", " ", "maji", " ", "stejny", " ", "Eigensystem", " ", "a", " ", 
     "vyzkousejte", " ", "identity", " ", "pro", " ", "dve", " ", 
     RowBox[{"promenne", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", 
      RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqr", "[", "alfa", "]"}], "+", 
       RowBox[{"sqr", "[", "beta", "]"}], "+", 
       RowBox[{"2", "*", 
        RowBox[{"alfa", ".", "beta"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqr", "[", 
      RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqr", "[", "alfa", "]"}], "+", 
       RowBox[{"sqr", "[", "beta", "]"}], "+", 
       RowBox[{"2", "*", 
        RowBox[{"beta", ".", "alfa"}]}]}], ")"}]}], "//", "Chop"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "nepomuze", " ", "ani", " ", "prehodit", " ", "poradi", " ", "matic", " ",
      "pri", " ", 
     RowBox[{"nasobeni", "!"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.6857199673125*^9, 3.685720171140625*^9}, {
  3.685720211953125*^9, 
  3.685720232421875*^9}},ExpressionUUID->"20a9e252-99b6-4274-93c2-\
12c72843c0e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2271499369171897`"}], ",", "0.03637622687608974`", ",", 
     RowBox[{"-", "0.2342163504780685`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13806239928789726`", ",", 
     RowBox[{"-", "0.04595414023288774`"}], ",", 
     RowBox[{"-", "0.13408555262194383`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5390074392225646`", ",", "0.11863908379397368`", ",", 
     "0.2731040771500768`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809038292*^9},ExpressionUUID->"e4fe1409-0dfb-4bb0-a678-\
cefcf7d8173c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.22714993691719082`", ",", 
     RowBox[{"-", "0.03637622687608863`"}], ",", "0.23421635047806982`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.13806239928790037`"}], ",", "0.04595414023288541`", ",", 
     "0.13408555262194205`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.539007439222567`"}], ",", 
     RowBox[{"-", "0.11863908379397527`"}], ",", 
     RowBox[{"-", "0.273104077150077`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809053913*^9},ExpressionUUID->"4a3328ed-3ccf-4ee5-b6e4-\
9b9ceaa78880"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"pozor", " ", "na", " ", "zobecneni"}], ",", " ", 
    RowBox[{
    "pro", " ", "vic", " ", "promennych", " ", "to", " ", "nefunguje", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"alespon", " ", "ne", " ", "obecne"}], ")"}], "!!"}], 
      "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", "alfa", "]"}], ".", 
         RowBox[{"cos", "[", "beta", "]"}]}], "+", 
        RowBox[{
         RowBox[{"cos", "[", "alfa", "]"}], ".", 
         RowBox[{"sin", "[", "beta", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", "alfa", "]"}], ".", 
         RowBox[{"cos", "[", "beta", "]"}]}], "+", 
        RowBox[{
         RowBox[{"sin", "[", "beta", "]"}], ".", 
         RowBox[{"cos", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cos", "[", "beta", "]"}], ".", 
         RowBox[{"sin", "[", "alfa", "]"}]}], "+", 
        RowBox[{
         RowBox[{"sin", "[", "beta", "]"}], ".", 
         RowBox[{"cos", "[", "alfa", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"alfa", "+", "beta"}], "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cos", "[", "beta", "]"}], ".", 
         RowBox[{"sin", "[", "alfa", "]"}]}], "+", 
        RowBox[{
         RowBox[{"cos", "[", "alfa", "]"}], ".", 
         RowBox[{"sin", "[", "beta", "]"}]}]}], ")"}]}], "//", "Chop"}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68571982896875*^9, 3.6857198339375*^9}, {
  3.6857199366875*^9, 3.68571994434375*^9}, {3.68572018003125*^9, 
  3.685720201140625*^9}},ExpressionUUID->"5433b00b-54dd-446f-97a7-\
cb3686315df1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", "A", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invP", "=", 
   RowBox[{"Inverse", "[", "P", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{"invP", ".", "A", ".", "P"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"diag", "//", "Chop"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", ".", "diag", ".", "invP"}], "//", "Chop"}], "//", 
  "mf"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sortByImag", "@", 
    RowBox[{"Eigenvalues", "[", "diag", "]"}]}], "-", 
   RowBox[{"sortByImag", "@", "lambdas"}]}], "//", "Chop"}]}], "Input",
 CellChangeTimes->{{3.6856865878900037`*^9, 3.6856866719837537`*^9}, {
  3.6856867147962537`*^9, 3.6856867159212537`*^9}, {3.6856867830931287`*^9, 
  3.6856868233275037`*^9}, {3.6856878857962537`*^9, 
  3.6856878973743787`*^9}},ExpressionUUID->"5f278105-f440-441b-8474-\
0ce351234c9d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "4.`"}], 
      RowBox[{"-", "1.`"}], 
      RowBox[{"-", "5.`"}]},
     {"2.`", 
      RowBox[{"-", "5.`"}], 
      RowBox[{"-", "5.`"}]},
     {"3.`", "1.`", 
      RowBox[{"-", "5.`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8473338091007442`*^9},ExpressionUUID->"75a2fb5e-03f3-4896-b90c-\
1799cc806eb9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "4.729867923570636`"}], "+", 
       RowBox[{"4.656033705128153`", " ", "\[ImaginaryI]"}]}], "0", "0"},
     {"0", 
      RowBox[{
       RowBox[{"-", "4.729867923570636`"}], "-", 
       RowBox[{"4.656033705128152`", " ", "\[ImaginaryI]"}]}], "0"},
     {"0", "0", 
      RowBox[{"-", "4.540264152858729`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.847333809116366*^9},ExpressionUUID->"38f1c403-41a6-4125-b27f-\
f95a53df125b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "4.000000000000002`"}], 
      RowBox[{"-", "0.9999999999999998`"}], 
      RowBox[{"-", "4.999999999999999`"}]},
     {"1.9999999999999993`", 
      RowBox[{"-", "5.`"}], 
      RowBox[{"-", "5.000000000000001`"}]},
     {"2.9999999999999996`", "0.9999999999999998`", 
      RowBox[{"-", "4.999999999999998`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8473338091319866`*^9},ExpressionUUID->"6dde40d4-3924-4c47-919d-\
41fe9939014d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338091476083`*^9},ExpressionUUID->"816a2485-dfe6-4e02-96c4-\
6a002218bb28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "linear", " ", "1", "st", " ", "order", " ", "differential", " ", 
    "equations", " ", "and", " ", "eigenvalues"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"(", GridBox[{
        {"2", "1"},
        {"1", "2"}
       }], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mrank", "=", 
     RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{"Eigensystem", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"invP", "=", 
     RowBox[{"Inverse", "[", "P", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diag", "=", 
     RowBox[{"invP", ".", "A", ".", "P"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "@", "diag"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"P", ".", "diag", ".", "invP"}], "//", "mf"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Eigenvalues", "[", "diag", "]"}], "-", "lambdas"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "#"], "[", "t", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "mrank", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"vars", ",", "t"}], "]"}], "\[Equal]", 
       RowBox[{"A", ".", "vars"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vectInitConds", "=", 
     RowBox[{"Range", "[", "mrank", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"vars", "==", "vectInitConds"}], "]"}], "/.", 
      RowBox[{"t", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expDiagMat", "=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"Diagonal", "[", 
        RowBox[{"t", "*", "diag"}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expDiagMat", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expMatA", "=", 
     RowBox[{"P", ".", "expDiagMat", ".", "invP"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"expMatA", ".", "vectInitConds"}], "//", "Simplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"eqns", ",", "initConds"}], "]"}], ",", "vars", ",", "t"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6856879851087537`*^9, 3.6856879891243787`*^9}, {
  3.6856887820931287`*^9, 3.6856887845931287`*^9}, {3.6856888571243787`*^9, 
  3.6856889788743787`*^9}, {3.6856890943587537`*^9, 3.6856892230775037`*^9}, {
  3.6856893027493787`*^9, 3.6856894558900037`*^9}, {3.6856894936087537`*^9, 
  3.6856895799212537`*^9}, {3.6856900909212537`*^9, 3.6856901037650037`*^9}, {
  3.685716804109375*^9, 3.685716804640625*^9}, {3.685716834890625*^9, 
  3.685716835421875*^9}},ExpressionUUID->"b041151a-f09f-43d4-b586-\
9e0fd20a70c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", "t"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "t"}]]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", "t"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "t"}]]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809194472*^9},ExpressionUUID->"8fb44230-5ee4-4231-b35b-\
c7b827d0430f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", "t"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", "t"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t"}]]}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809225724*^9},ExpressionUUID->"ee4feb32-a759-4f3a-a4f6-\
20932209ba68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\"\<dukaz\>\"", " ", "ze", " ", "rovnice", " ", "n"}], "-", 
    RowBox[{
    "teho", " ", "radu", " ", "ma", " ", "stejne", " ", "koreny", " ", "jako",
      " ", "matice", " ", "vlastni", " ", "cisla"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "a", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mrank", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origEqn", "=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "mrank"}], "}"}]}], "]"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], 
        RowBox[{"mrank", "-", "1"}]], 
       RowBox[{
        SubscriptBox["a", "i"], "*", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"y", "[", "t", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "i"}], "}"}]}], "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "#"], "[", "t", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "mrank", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x", 
           RowBox[{"#", "-", "1"}]], "'"}], "[", "t", "]"}], "==", 
        RowBox[{
         SubscriptBox["x", "#"], "[", "t", "]"}]}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"2", ",", "mrank"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnn", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["x", "mrank"], "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", "1"}], "mrank"], 
        RowBox[{
         SubscriptBox["a", 
          RowBox[{"i", "-", "1"}]], "*", 
         RowBox[{
          SubscriptBox["x", "i"], "[", "t", "]"}]}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"eqnsTogether", "=", 
    RowBox[{"Append", "[", 
     RowBox[{"eqns1", ",", "eqnn"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"b", ",", "m"}], "}"}], "=", 
    RowBox[{
     RowBox[{"CoefficientArrays", "[", 
      RowBox[{"eqnsTogether", ",", "vars"}], "]"}], "//", "Normal"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Thread", "[", 
    RowBox[{"b", "\[Equal]", 
     RowBox[{
      StyleBox["-",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       StyleBox["m",
        FontColor->RGBColor[1, 0, 0]], ".", "vars"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"-", "m"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "A"}], "\[IndentingNewLine]", 
   RowBox[{"Det", "[", 
    RowBox[{"A", "-", 
     RowBox[{"\[Lambda]", "*", 
      RowBox[{"IdentityMatrix", "[", "mrank", "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"origEqn", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "n_", "]"}], "[", "y", "]"}], "[", "t", 
         "]"}], ")"}], "\[RuleDelayed]", 
       SuperscriptBox["\[Lambda]", "n"]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "\[Rule]", "1"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6856900526868787`*^9, 3.6856900768275037`*^9}, {
   3.6856901143743787`*^9, 3.6856901688118787`*^9}, {3.6856902096087537`*^9, 
   3.6856902544056287`*^9}, {3.6856902874993787`*^9, 
   3.6856903959368787`*^9}, {3.6856904347337537`*^9, 
   3.6856905076556287`*^9}, {3.6856906767181287`*^9, 3.6856907117962537`*^9}, 
   3.6856908119837537`*^9, {3.6856908506556287`*^9, 3.6856908637337537`*^9}, 
   3.6856909850150037`*^9, {3.6856910239525037`*^9, 3.6856910608118787`*^9}, {
   3.6856911028587537`*^9, 3.6856911685150037`*^9}, {3.6856912122806287`*^9, 
   3.6856915537806287`*^9}, {3.6856918025306287`*^9, 
   3.6856918052493787`*^9}, {3.68571709028125*^9, 3.685717130453125*^9}, 
   3.6857224233125*^9},ExpressionUUID->"5aaf0613-c1e0-4717-b2dc-7242927f6fd8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "1"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "2"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "3"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "3"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "4"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "5"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "5"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["a", "0"]}], " ", 
      RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "1"], " ", 
      RowBox[{
       SubscriptBox["x", "2"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "2"], " ", 
      RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "3"], " ", 
      RowBox[{
       SubscriptBox["x", "4"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "4"], " ", 
      RowBox[{
       SubscriptBox["x", "5"], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.84733380927258*^9},ExpressionUUID->"9a1841f9-4457-4c46-95e7-dd364a42079f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "1"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "2"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "3"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "4"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], ",", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["x", "5"], "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "0"], ",", 
       SubscriptBox["a", "1"], ",", 
       SubscriptBox["a", "2"], ",", 
       SubscriptBox["a", "3"], ",", 
       SubscriptBox["a", "4"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338093038216`*^9},ExpressionUUID->"b27703ee-7ee6-43fd-9f5c-\
0e10b1a330b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "1"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "2"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "3"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "3"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "4"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["x", "5"], "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["x", "5"], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["a", "0"]}], " ", 
      RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "1"], " ", 
      RowBox[{
       SubscriptBox["x", "2"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "2"], " ", 
      RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "3"], " ", 
      RowBox[{
       SubscriptBox["x", "4"], "[", "t", "]"}]}], "-", 
     RowBox[{
      SubscriptBox["a", "4"], " ", 
      RowBox[{
       SubscriptBox["x", "5"], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338093194437`*^9},ExpressionUUID->"895625eb-b76d-4ce8-a180-\
1cca1a36f661"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", "0", "0"},
     {"0", "0", "1", "0", "0"},
     {"0", "0", "0", "1", "0"},
     {"0", "0", "0", "0", "1"},
     {
      RowBox[{"-", 
       SubscriptBox["a", "0"]}], 
      RowBox[{"-", 
       SubscriptBox["a", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["a", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["a", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["a", "4"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8473338093350644`*^9},ExpressionUUID->"fd11d781-74e9-4022-948a-\
b2a57040e22f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[Lambda]", "5"]}], "-", 
  SubscriptBox["a", "0"], "-", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["a", "1"]}], "-", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "2"], " ", 
   SubscriptBox["a", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "3"], " ", 
   SubscriptBox["a", "3"]}], "-", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "4"], " ", 
   SubscriptBox["a", "4"]}]}]], "Output",
 CellChangeTimes->{
  3.8473338093663073`*^9},ExpressionUUID->"f3754345-9643-421f-9b1a-\
217203d5b152"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "5"], "+", 
  SubscriptBox["a", "0"], "+", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["a", "1"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "2"], " ", 
   SubscriptBox["a", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "3"], " ", 
   SubscriptBox["a", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "4"], " ", 
   SubscriptBox["a", "4"]}]}]], "Output",
 CellChangeTimes->{
  3.8473338093819284`*^9},ExpressionUUID->"9ebc309d-4e2e-4d90-9d72-\
b7ca2480a419"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"matice", " ", "a", " ", "slozky"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dosa", "=", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "2", "*", 
         FractionBox["Pi", "3."]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"1", "1", "1"},
         {"1", 
          SuperscriptBox["a", "2"], "a"},
         {"1", "a", 
          SuperscriptBox["a", "2"]}
        }], ")"}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"invT", "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], 
       RowBox[{"(", GridBox[{
          {"1", "1", "1"},
          {"1", "a", 
           SuperscriptBox["a", "2"]},
          {"1", 
           SuperscriptBox["a", "2"], "a"}
         }], ")"}]}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Inverse", "[", "T", "]"}], "-", "invT"}], "//", "Simplify"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6856932708743787`*^9, 3.6856932786087537`*^9}, {
   3.6856933219056287`*^9, 3.6856934819368787`*^9}, {3.6856940138743787`*^9, 
   3.6856940630931287`*^9}, {3.68577487578125*^9, 3.685774904515625*^9}, {
   3.6857749355*^9, 3.685774974375*^9}, 
   3.685775304109375*^9},ExpressionUUID->"47684669-89a3-40cb-9dc3-\
56891b4ca6fe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338094131713`*^9},ExpressionUUID->"5d7a20ff-221c-41fc-af55-\
a5d2c4a644ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"impedances", "=", 
   RowBox[{"{", 
    RowBox[{"Zv", ",", "Z1", ",", "Z2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matZ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"RotateRight", "[", 
      RowBox[{"impedances", ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "2", ",", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "@", "matZ"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"transformedMatZ", "=", 
   RowBox[{"Chop", "@", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"invT", ".", "matZ", ".", "T"}], "//", "Chop"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "%"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6857750335*^9, 3.68577511096875*^9}, {
   3.6857751805625*^9, 3.685775180921875*^9}, {3.685775226671875*^9, 
   3.685775258375*^9}, {3.685775290046875*^9, 3.685775337765625*^9}, {
   3.685775392125*^9, 3.685775394625*^9}, {3.6857754278125*^9, 
   3.685775434953125*^9}, {3.685775478828125*^9, 3.6857755254375*^9}, 
   3.685775741171875*^9, {3.685778404296875*^9, 
   3.685778429828125*^9}},ExpressionUUID->"d97c67a4-dd23-4da7-a878-\
b0cd67d73050"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"Zv", "Z1", "Z2"},
     {"Z2", "Zv", "Z1"},
     {"Z1", "Z2", "Zv"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.847333809444413*^9},ExpressionUUID->"fdbf552f-7ee6-4b17-a84e-\
725bbcf8942b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqnJthPhase", "[", "j_", "]"}], ":=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "j"], "==", 
    RowBox[{
     RowBox[{
      SubscriptBox["R", "j"], "*", 
      SubscriptBox["i", "j"]}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "3"], 
      RowBox[{
       SubscriptBox["Z", 
        RowBox[{"k", ",", "j"}]], "*", 
       SubscriptBox["i", "k"]}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqns3phases", "=", 
  RowBox[{
   RowBox[{"eqnJthPhase", "/@", 
    RowBox[{"Range", "[", "3", "]"}]}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"varsToSolve", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["i", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rhsabc", ",", "Zaux"}], "}"}], "=", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{"eqns3phases", ",", "varsToSolve"}], "]"}], "//", "Normal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zabc", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "*", "Zaux"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "Zabc"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Thread", "[", 
  RowBox[{"rhsabc", "\[Equal]", 
   RowBox[{"Zabc", ".", "varsToSolve"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.685776050640625*^9, 3.68577618884375*^9}, {
  3.685776221265625*^9, 3.685776247984375*^9}, {3.685776299640625*^9, 
  3.68577631771875*^9}, {3.68577654528125*^9, 3.68577664084375*^9}, {
  3.6857766748125*^9, 3.68577669803125*^9}, {3.68577672909375*^9, 
  3.68577676646875*^9}, {3.68577682040625*^9, 
  3.68577687321875*^9}},ExpressionUUID->"f2ceb922-fe0e-4a50-acb7-\
52b4ec04c2fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "1"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "1"], "+", 
        SubscriptBox["Z", 
         RowBox[{"1", ",", "1"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "1"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "2"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "2"], "+", 
        SubscriptBox["Z", 
         RowBox[{"2", ",", "2"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "3"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "3"], "+", 
        SubscriptBox["Z", 
         RowBox[{"3", ",", "3"}]]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338094912806`*^9},ExpressionUUID->"2723ff14-0fb0-48fb-b0d9-\
0191729ac652"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "1"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "1"], "+", 
        SubscriptBox["Z", 
         RowBox[{"1", ",", "1"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "1"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "2"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "2"], "+", 
        SubscriptBox["Z", 
         RowBox[{"2", ",", "2"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "3"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "3"], "+", 
        SubscriptBox["Z", 
         RowBox[{"3", ",", "3"}]]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338095225205`*^9},ExpressionUUID->"448ccd33-d315-40fb-9a5c-\
3b575fbb0bb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"symmetric", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["R", "_"], "\[RuleDelayed]", "R"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "k_"}]], "\[RuleDelayed]", "Zv"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "r_"}]], "\[RuleDelayed]", 
      SubscriptBox["Z", 
       RowBox[{"r", ",", "k"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ZabcSymmetric", "=", 
   RowBox[{"Zabc", "//.", "symmetric"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "ZabcSymmetric"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]voltages", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
       RowBox[{"Range", "[", "3", "]"}]}], ")"}], "->", 
     RowBox[{"\[CapitalDelta]Uf", "*", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SuperscriptBox["a", "2"], ",", "a"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalDelta]Uf", "\[Rule]", "100"}], ",", 
     RowBox[{"Zm", "\[Rule]", 
      RowBox[{"20", "I"}]}], ",", 
     RowBox[{"Zv", "\[Rule]", 
      RowBox[{"30", "I"}]}], ",", 
     RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"originalEqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"eqns3phases", "//.", "symmetric"}], ")"}], "/.", 
      "\[CapitalDelta]voltages"}], ")"}], "/.", "values"}], "/.", 
   "dosa"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", "originalEqns", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685776939578125*^9, 3.685776955171875*^9}, 
   3.68577701765625*^9, {3.685777057484375*^9, 3.685777240078125*^9}, {
   3.685777318546875*^9, 3.68577738565625*^9}, {3.685777418296875*^9, 
   3.685777423609375*^9}, {3.685778585484375*^9, 3.685778737234375*^9}, {
   3.685778768984375*^9, 3.685778801171875*^9}, {3.68577885315625*^9, 
   3.685778933078125*^9}, {3.68577916865625*^9, 3.68577920478125*^9}, {
   3.6857801846875*^9, 
   3.68578018596875*^9}},ExpressionUUID->"de8f541f-310d-4a6d-8730-\
62f4738790c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"100", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "3"]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "50.000000000000036`"}], "-", 
     RowBox[{"86.60254037844383`", " ", "\[ImaginaryI]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "3"]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "49.99999999999998`"}], "+", 
     RowBox[{"86.60254037844388`", " ", "\[ImaginaryI]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "3"]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338095537624`*^9},ExpressionUUID->"507ef7fb-8058-4eba-a474-\
344d8b3f28a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["i", "1"], "\[Rule]", 
    RowBox[{"0.9900990099009895`", "\[VeryThinSpace]", "-", 
     RowBox[{"9.900990099009904`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["i", "2"], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "9.069558453311275`"}], "+", 
     RowBox[{"4.093044154668877`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["i", "3"], "\[Rule]", 
    RowBox[{"8.079459443410286`", "\[VeryThinSpace]", "+", 
     RowBox[{"5.807945944341029`", " ", "\[ImaginaryI]"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8473338095693846`*^9},ExpressionUUID->"a4446104-25b7-4884-a78d-\
3ca6d1ae1734"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Zcomponents", "=", 
   RowBox[{
    RowBox[{"invT", ".", 
     RowBox[{"(", 
      RowBox[{"ZabcSymmetric", "/.", "values"}], ")"}], ".", "T"}], "//", 
    "Chop"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "Zcomponents"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"voltagesOriginal", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
        RowBox[{"Range", "[", "3", "]"}]}], "/.", "\[CapitalDelta]voltages"}],
       ")"}], "/.", "values"}], "/.", "dosa"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"voltagesComponents", "=", 
   RowBox[{
    RowBox[{"invT", ".", "voltagesOriginal"}], "//", "Chop"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"currentsComponents", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["iomn", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eqnsComponents", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"voltagesComponents", "==", 
    RowBox[{"Zcomponents", ".", "currentsComponents"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"solComponents", "=", 
  RowBox[{
   RowBox[{"Solve", "[", "eqnsComponents", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"originalCurrents", "=", 
  RowBox[{"T", ".", 
   RowBox[{"(", 
    RowBox[{"currentsComponents", "/.", "solComponents"}], 
    ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.68577954978125*^9, 3.685779657765625*^9}, {
  3.6857797485625*^9, 3.685779836015625*^9}, {3.685779947578125*^9, 
  3.685780075875*^9}, {3.685780120078125*^9, 3.685780121875*^9}, {
  3.68578017075*^9, 3.68578017721875*^9}, {3.685780214890625*^9, 
  3.6857802251875*^9}, {3.685780367890625*^9, 
  3.68578038203125*^9}},ExpressionUUID->"d1d93e73-4d8e-4ecc-82c6-\
0b0bda5c6c52"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["iomn", "1"], ",", 
   SubscriptBox["iomn", "2"], ",", 
   SubscriptBox["iomn", "3"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809600627*^9},ExpressionUUID->"7e3e52c9-ede0-47d0-9056-\
39cf6f02266b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "+", 
       RowBox[{"69.99999999999999`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "1"]}]}], ",", 
   RowBox[{"99.99999999999999`", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0000000000000033`", "\[VeryThinSpace]", "+", 
       RowBox[{"9.999999999999998`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "2"]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0000000000000033`", "\[VeryThinSpace]", "+", 
       RowBox[{"9.999999999999998`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "3"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.84733380963187*^9},ExpressionUUID->"20fd1884-9f4e-4ab8-a40b-b6125e6afb11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["iomn", "1"], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["iomn", "2"], "\[Rule]", 
    RowBox[{"0.9900990099009934`", "\[VeryThinSpace]", "-", 
     RowBox[{"9.9009900990099`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["iomn", "3"], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847333809647491*^9},ExpressionUUID->"b38eeefe-8b65-48e9-a271-\
e79dd7a58030"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.9900990099009934`", "\[VeryThinSpace]", "-", 
    RowBox[{"9.9009900990099`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.069558453311272`"}], "+", 
    RowBox[{"4.093044154668872`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"8.07945944341028`", "\[VeryThinSpace]", "+", 
    RowBox[{"5.807945944341029`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473338096631117`*^9},ExpressionUUID->"0a4ae5c9-c210-47ca-a020-\
d2acb18898bc"]
}, Open  ]]
},
WindowSize->{1032, 694},
WindowMargins->{{27, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5000001192092896`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 538, 15, 73, "Input",ExpressionUUID->"6ebce331-a2f7-490f-84fc-b4a55addd8e8"],
Cell[1098, 37, 935, 22, 160, "Input",ExpressionUUID->"c6cc6347-d9bf-48a4-8aa9-6ec262c4beff"],
Cell[2036, 61, 1392, 41, 189, "Input",ExpressionUUID->"5087cceb-51fe-434f-ad1d-e54623583f30"],
Cell[CellGroupData[{
Cell[3453, 106, 1812, 45, 363, "Input",ExpressionUUID->"429799c8-ce34-48af-81c5-f5d703da1345"],
Cell[5268, 153, 989, 25, 118, "Output",ExpressionUUID->"0e698630-a4c8-4b5c-bb08-0280e71c98c3"],
Cell[6260, 180, 209, 6, 49, "Output",ExpressionUUID->"1822d9b5-ddb9-4020-bc85-e78797f2823e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6506, 191, 2917, 78, 519, "Input",ExpressionUUID->"afb2a661-0554-4ed4-9751-8bc6291fd2f2"],
Cell[9426, 271, 362, 11, 49, "Output",ExpressionUUID->"75eff53a-d1b1-474a-ab4e-94932f324844"],
Cell[9791, 284, 362, 11, 49, "Output",ExpressionUUID->"80662809-e0e7-49e8-9038-25742cc4b53c"],
Cell[10156, 297, 364, 11, 49, "Output",ExpressionUUID->"92bceee0-0958-4dd0-bee0-7a840b977152"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10557, 313, 3905, 105, 630, "Input",ExpressionUUID->"0dfe432c-4228-46f4-b6d3-e7385866b1e4"],
Cell[14465, 420, 364, 11, 49, "Output",ExpressionUUID->"0f4e5af1-1d14-476b-8a0e-b31af14baed9"],
Cell[14832, 433, 362, 11, 49, "Output",ExpressionUUID->"02ccd073-f3b2-4da7-986e-46ad559d9f32"],
Cell[15197, 446, 362, 11, 49, "Output",ExpressionUUID->"979c4089-3b54-4320-803e-99b38705c8d6"],
Cell[15562, 459, 364, 11, 49, "Output",ExpressionUUID->"17add1f9-c737-4ff3-bbca-0e53867a9acc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15963, 475, 2472, 65, 464, "Input",ExpressionUUID->"ad4f7d39-ce4f-47be-92c2-d3238df8bacc"],
Cell[18438, 542, 1961, 49, 364, "Output",ExpressionUUID->"67e2dc81-5c03-4b4f-b695-50279fb2ac56"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20436, 596, 1853, 50, 276, "Input",ExpressionUUID->"20a9e252-99b6-4274-93c2-12c72843c0e9"],
Cell[22292, 648, 624, 17, 79, "Output",ExpressionUUID->"e4fe1409-0dfb-4bb0-a678-cefcf7d8173c"],
Cell[22919, 667, 645, 18, 79, "Output",ExpressionUUID->"4a3328ed-3ccf-4ee5-b6e4-9b9ceaa78880"]
}, Open  ]],
Cell[23579, 688, 2405, 72, 189, "Input",ExpressionUUID->"5433b00b-54dd-446f-97a7-cb3686315df1"],
Cell[CellGroupData[{
Cell[26009, 764, 1646, 44, 305, "Input",ExpressionUUID->"5f278105-f440-441b-8474-0ce351234c9d"],
Cell[27658, 810, 871, 27, 118, "Output",ExpressionUUID->"75a2fb5e-03f3-4896-b90c-1799cc806eb9"],
Cell[28532, 839, 1006, 28, 118, "Output",ExpressionUUID->"38f1c403-41a6-4125-b27f-f95a53df125b"],
Cell[29541, 869, 995, 27, 118, "Output",ExpressionUUID->"6dde40d4-3924-4c47-919d-41fe9939014d"],
Cell[30539, 898, 187, 5, 49, "Output",ExpressionUUID->"816a2485-dfe6-4e02-96c4-6a002218bb28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30763, 908, 3433, 94, 592, "Input",ExpressionUUID->"b041151a-f09f-43d4-b586-9e0fd20a70c1"],
Cell[34199, 1004, 691, 22, 69, "Output",ExpressionUUID->"8fb44230-5ee4-4231-b35b-c7b827d0430f"],
Cell[34893, 1028, 925, 29, 69, "Output",ExpressionUUID->"ee4feb32-a759-4f3a-a4f6-20932209ba68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35855, 1062, 4327, 120, 550, "Input",ExpressionUUID->"5aaf0613-c1e0-4717-b2dc-7242927f6fd8"],
Cell[40185, 1184, 1815, 59, 79, "Output",ExpressionUUID->"9a1841f9-4457-4c46-95e7-dd364a42079f"],
Cell[42003, 1245, 1602, 48, 79, "Output",ExpressionUUID->"b27703ee-7ee6-43fd-9f5c-0e10b1a330b9"],
Cell[43608, 1295, 1820, 60, 79, "Output",ExpressionUUID->"895625eb-b76d-4ce8-a180-1cca1a36f661"],
Cell[45431, 1357, 1060, 33, 170, "Output",ExpressionUUID->"fd11d781-74e9-4022-948a-b2a57040e22f"],
Cell[46494, 1392, 558, 18, 49, "Output",ExpressionUUID->"f3754345-9643-421f-9b1a-217203d5b152"],
Cell[47055, 1412, 539, 17, 49, "Output",ExpressionUUID->"9ebc309d-4e2e-4d90-9d72-b7ca2480a419"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47631, 1434, 1535, 46, 362, "Input",ExpressionUUID->"47684669-89a3-40cb-9dc3-56891b4ca6fe"],
Cell[49169, 1482, 364, 11, 49, "Output",ExpressionUUID->"5d7a20ff-221c-41fc-af55-a5d2c4a644ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49570, 1498, 1224, 32, 160, "Input",ExpressionUUID->"d97c67a4-dd23-4da7-a878-b0cd67d73050"],
Cell[50797, 1532, 728, 21, 118, "Output",ExpressionUUID->"fdbf552f-7ee6-4b17-a84e-725bbcf8942b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51562, 1558, 1799, 51, 263, "Input",ExpressionUUID->"f2ceb922-fe0e-4a50-acb7-52b4ec04c2fd"],
Cell[53364, 1611, 1717, 59, 81, "Output",ExpressionUUID->"2723ff14-0fb0-48fb-b0d9-0191729ac652"],
Cell[55084, 1672, 1717, 59, 81, "Output",ExpressionUUID->"448ccd33-d315-40fb-9a5c-3b575fbb0bb5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56838, 1736, 2694, 73, 258, "Input",ExpressionUUID->"de8f541f-310d-4a6d-8730-62f4738790c5"],
Cell[59535, 1811, 1521, 44, 79, "Output",ExpressionUUID->"507ef7fb-8058-4eba-a474-344d8b3f28a2"],
Cell[61059, 1857, 705, 19, 49, "Output",ExpressionUUID->"a4446104-25b7-4884-a78d-3ca6d1ae1734"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61801, 1881, 1915, 52, 247, "Input",ExpressionUUID->"d1d93e73-4d8e-4ecc-82c6-0b0bda5c6c52"],
Cell[63719, 1935, 263, 8, 49, "Output",ExpressionUUID->"7e3e52c9-ede0-47d0-9056-39cf6f02266b"],
Cell[63985, 1945, 879, 22, 49, "Output",ExpressionUUID->"20fd1884-9f4e-4ab8-a40b-b6125e6afb11"],
Cell[64867, 1969, 646, 17, 49, "Output",ExpressionUUID->"b38eeefe-8b65-48e9-a271-e79dd7a58030"],
Cell[65516, 1988, 530, 12, 49, "Output",ExpressionUUID->"0a4ae5c9-c210-47ca-a020-d2acb18898bc"]
}, Open  ]]
}
]
*)

