(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     83962,       1656]
NotebookOptionsPosition[     83105,       1633]
NotebookOutlinePosition[     83553,       1650]
CellTagsIndexPosition[     83510,       1647]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"317fbb22-4b1b-4dae-92cb-99a192784aa9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"derivative", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "y"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"5", "t"}], "]"}], "+", 
      FractionBox["2", "5"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t0", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startPoint", "=", 
   RowBox[{"{", 
    RowBox[{"t0", ",", "y0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnsForNDSolve", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"derivative", "[", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"y", "[", "t", "]"}]}], "}"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t0", "]"}], "\[Equal]", "y0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solNDS", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"eqnsForNDSolve", ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plNDS", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "solNDS"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t[s]\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Full"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPoints", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox[
    RowBox[{"tmax", "-", "t0"}], "nPoints"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stepEuler", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{"y", "+", 
      RowBox[{"\[CapitalDelta]t", "*", 
       RowBox[{"derivative", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "y"}], "}"}], "]"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startingPoint", "=", 
   RowBox[{"{", 
    RowBox[{"t0", ",", "y0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solEuler", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"stepEuler", ",", "startingPoint", ",", "nPoints"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plEuler", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"solEuler", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNDS", ",", "plEuler"}], "]"}]}], "Input",
 CellChangeTimes->{{3.877595173871191*^9, 3.8775952581180983`*^9}, {
   3.8775953671415186`*^9, 3.877595399036772*^9}, {3.877595454069204*^9, 
   3.8775954936406207`*^9}, {3.877595525234356*^9, 3.877595585259189*^9}, {
   3.877595661514612*^9, 3.8775958404833126`*^9}, {3.87759587792644*^9, 
   3.877595895330923*^9}, {3.877596038189048*^9, 3.8775960818190317`*^9}, {
   3.8775961382340937`*^9, 3.877596312267763*^9}, {3.87759793002999*^9, 
   3.8775979308545327`*^9}, 3.8775980437925787`*^9},
 CellLabel->
  "In[103]:=",ExpressionUUID->"b4affade-f01e-48d0-97f3-b0bbbe8e50ee"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0, 0, 1], Thickness[0.006], Opacity[1.], 
       LineBox[CompressedData["
1:eJwUV3k81F8Xtu/bGMaapUghoRDRuVGiJAmppJIUIVJRlIpIP1tlSfaQJdvY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        "]]},
      Annotation[#, "Charting`Private`Tag$8811#1"]& ]}, {}, {}}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.01], AbsoluteThickness[1.6], Opacity[
      0.4], PointBox[CompressedData["
1:eJxV0n8w1HkYB/DFRuW3LJEfu3YuVNQo1bnqedCortTJ5bYmju64i25UXPrh
LnR+XodjKbJai66GbKoJpdzl126cwtKRhKZG5dSJFSl3nj7/3DPzne985/v5
vJ7v9/15BHvCtwdrcjic4P+umfv/6xXk5sxUFVTaxL/wqRxmz0pwy/9qyTXu
EKxYPlPt4NGujlubMsjed8HU0M3HW6yewAenD9bbBB2pEA0ALV/+GDRCetxq
T/RBCNVTKNd3uD+59hHQ9pxnYB++/47E7BE0Uw1BZuScw59a9ME01UuQfCy9
u1Wnn63/B47dlDWPTfYz/zVk1NQH5SQOwJ+0fxTyfms1Ctk6AN9QPzVcle/T
FDj3gwZ93xsYeNexI/Z6L5whbwJ2yLLjxiXd4EreWwiMyPLwfNEJd8mbAs8L
75eaLlHBXvLewy2lRFGe1MY8Dl7MmrsxfbgVWmg9B3ltP4ReXNbGfA1cJ3YJ
MTBqh29pvyaGVY12dq9QsX5amHXcQ9a8qAM+nAkXrzrlLG+J7GD9uegmMlTE
31RBHnmzsPeUu1h/bjv7Hm2876Udtb3mHqwkTwfz712Igs5m0CJvNrqZR55u
mlLAPfJmY+Bh09yR3Q0gIW8OJhzcllKjUQ+h5M3FMseIhVH1dbCKPF1MN+vL
dg+rBy55euhQ8KCCd7YBWsnTwwdTVpvDhxohnzx9tMm9rRVcq4Aw8gxw1l9N
G4bzFbCaPEO0t33ZLlrfyP7XCMOPluTt/buO5WOEC+s40VrOt1meRjhS+ULe
vaGGzZ8xqjpKxlL33mDzZ4xL/7gR0T+ris2fCTod6Kr9TLeSzZsJqkLGgyaw
ks2XCRp7N07r+FWBC3nz0OfcwYmRrutwmrx52OPovOiYazW8p/mbhyKeb2hJ
TTV8TZ4pai8+EHVp8gbcIc8UE2sNuqa7q2AZeTw8XnUoPqbrGmSTx8OfpxfH
Fl++AlPk8fBKUVNaqXY57CHPDE8UpbpYbisDBXlmmCeS2qd4lYIzeeYov3B5
UN1QAmLyzDFjopcTHlcKk+SZo7s/x8NbvwwCyZuPrs3C1eWtcmggbz42PogY
H0u6BEvIs8DBfu+YkpRLkEGeBfLq3GcfPCaHN+RZoKKnQl0cXQoB5FmipOeL
x/6q81BHniWeDGrRTdpVDIvIW4CxCeZF5wtlkE7eAtwXY6G7Y1AKavIWoFKp
r+FjJ4Xd5FnhRgPO8KiTFG6TZ4XdkyYPA+5LwYE8azyy+XthXGcBpJJnjY7P
Ez7xUcpglDxrjPYt33RgXSHsIs8GT7sINqu6ZfA7eTYo4keuuZpSAAvJs8U1
+8vctjmehZPk2WLAO7kg4FkujJBniz3aOzdprTrF8uFj/vzPjx5OFcOX5PNx
PG7Kma+XyfLio+1PH/l9l50B9dSPj686n8dmvM1g+fFR5JcTLFZnwmLyBKif
wH2y0j6L5SnAZartZ3SMs+FX8gQYd2rdFlPXbJavAMsCdiryNmTBOHkC7Dr+
o6l1YCbL2w69H4ZVnHudDv7k2eHGNInvPsdfWP52WFst98zyT4Za8uzwqdKv
ILo3gZ2HHcr0+M7qknhwJE+IfC9RQVtOPDsfIfpyDeccCk6ANPKEmFQX71B4
OZGdlxBDi/NXizWTYYw8IVomr1RZ3EqGfwGRavIa
       "]]}, {}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& }, {{{0., 
       Directive[
        AbsoluteThickness[0.1]]}, {2., 
       Directive[
        AbsoluteThickness[0.1]]}, {4., 
       Directive[
        AbsoluteThickness[0.1]]}, {6., 
       Directive[
        AbsoluteThickness[0.1]]}, {8., 
       Directive[
        AbsoluteThickness[0.1]]}, {10., 
       Directive[
        AbsoluteThickness[0.1]]}, {-2., 
       Directive[
        AbsoluteThickness[0.1]]}, {-1.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {-1., 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {1., 
       Directive[
        AbsoluteThickness[0.1]]}, {1.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {2.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {3., 
       Directive[
        AbsoluteThickness[0.1]]}, {3.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {4.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {5., 
       Directive[
        AbsoluteThickness[0.1]]}, {5.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {6.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {7., 
       Directive[
        AbsoluteThickness[0.1]]}, {7.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {8.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {9., 
       Directive[
        AbsoluteThickness[0.1]]}, {9.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {10.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {11., 
       Directive[
        AbsoluteThickness[0.1]]}, {11.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {12., 
       Directive[
        AbsoluteThickness[0.1]]}}, {{0., 
       Directive[
        AbsoluteThickness[0.1]]}, {0.2, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.4, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.6, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.8, 
       Directive[
        AbsoluteThickness[0.1]]}, {1., 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.2, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.25, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.3, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.35, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.45, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.55, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.65, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.7, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.75, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.85, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.9, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.95, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.2, 
       Directive[
        AbsoluteThickness[0.1]]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.877596239670502*^9, 3.8775963126154847`*^9}, {
   3.877597656830102*^9, 3.8775976664586487`*^9}, 3.8775977081177635`*^9, 
   3.8775979312557335`*^9, 3.8775980441090546`*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"bb34b344-2f8a-4bd2-aca9-348b3e61f6da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"stepRunge", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k1", "=", 
       RowBox[{"derivative", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k2", "=", 
       RowBox[{"derivative", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k3", "=", 
       RowBox[{"derivative", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k4", "=", 
       RowBox[{"derivative", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          FractionBox["\[CapitalDelta]t", "6"], "*", 
          RowBox[{"(", 
           RowBox[{"k1", "+", 
            RowBox[{"2", "k2"}], "+", 
            RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPoints", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox[
    RowBox[{"tmax", "-", "t0"}], "nPoints"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startingPoint", "=", 
   RowBox[{"{", 
    RowBox[{"t0", ",", "y0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solRunge", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"stepRunge", ",", "startingPoint", ",", "nPoints"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plRunge", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"solRunge", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNDS", ",", "plRunge"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8775976068132343`*^9, 3.8775976513606377`*^9}, {
  3.8775977134990187`*^9, 3.8775977353898563`*^9}, {3.87759777510753*^9, 
  3.877597915841188*^9}, {3.877598053035582*^9, 3.877598062510292*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"dabb27e7-d048-4de2-9485-2d88ddb5fe47"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0, 0, 1], Thickness[0.006], Opacity[1.], 
       LineBox[CompressedData["
1:eJwUV3k81F8Xtu/bGMaapUghoRDRuVGiJAmppJIUIVJRlIpIP1tlSfaQJdvY
yU4Mxr5LtrHvu7K+3/ev+Tyfufee5zznuefcr7jFI8N7NFRUVH/oqaj+/xv5
yoJBwfK/U4oOsh17ewtQ3S6md1XMGjIj0i9XrS3AXk2ph5jYc5DQMa+RmlmA
yHI/UXoxH5jYPIrr7FgAW42ndhuiYRBdF8PXHLcA2R1D8ataEbCg522dGLIA
mw/1+pfuR4NKwM0lCZ8FONP4UXK9+xtUTekac9stQPvWg6BF0WRYd61bb5Bf
gGe1IvILxBSgCG3Oj4gtgODnjoY5rVTw+c/gXQLXAlhII9qZ+xmQEEAAhYV5
cEllLVzuzoKH06ts7knzwPh7RGpOtBAerQezTLPNQ095ydPZyUJo9rWhUvs7
Bynfv1TNEIuA45/O13OUOdB/rH9rWqsYSK4sfLEFcxDCXBQycb8MSIuKNE63
54A7gkSz1F0J5bQe6+SEWYitj3acEa0DEb4dzUTcDKx+yZUe9K2DidNuzupr
06B9v4HS9q8O3uDSmot6pmGWdsO4qL0eDj0VefQiehpOaOir+XiTYShc7Zeq
7DS0ZGzTSC00Q07YM/zlM1PgXi97XuFWO2wY38+uejEBScT8gz+C2+HEK4e8
QfMJaPuiSStJbgdPwf8eCmhNgMR902J+1Q4YaKATmWGdgHpaTzkqfCeIpJ+o
Oxw9DgSN39zNNV2gTvSWxTeOQXqGz29buT4wuFnUd+LiKExzT/uev9MH6dyH
5z1OjILUs/OnDgX1wU7qNT4aiVGIUWeNpfzrgzUn/5NhWxT4VOdrdf3Xb2ia
2i3WSKPAM0rA0jmzP+DiZHruhyAFsrQXv0kG/IEH3wVGLjNTYCHZwIi28g8c
dkjzl/87Ag8ccPmlUgNw/RLNcEjXCFzf+eSmtDIATc+NItlCRiCatcEDd3YI
bDknHxaKjsApDVez1+ZDoKVksrSMG4F+exmlBechmD/seceKbgT42/4bJ6cM
AWdes/jW1DB8/KKn+55rGFaT4yb784dBvn5bfOPwMFQ9+Phg/McwNG2lbt7T
Goap6Fe/D8cMA8st9lStZ8OwPbPzyNxnGDwkmzj2fg/Dd+vcQy/Nh2H/1VcT
dmvD0BY1Qm9sNAzl7+XK+zlGIOWt5F2r8//f5+9YdHoEXuavqCmpDMPTrEsd
TxNHYP+87/fX+GHgGd1LHS0fgaa0n8XirMOQxZv57krfCGgeyXHaohmGeRcu
FQV2CnSnryqZrgzBfWgNm31Mgb8G4yLZXUNA9W296Pd/FFh1FF1QahmCL3TC
/fXxFKxOgjTzdUNAqrMSSe6igEmLuPZOyRDclvWFLwsUuL2J329UMAR//Ym3
vZlGoWw3MGQwawgOGW1/u6c2Ck6PTAM+Jw1BeZ54tdGVUZj8Z5T+M24ITAXO
jWnZjsL1DtcYvugheD/wUWp/1CgsVwcr2oQMgdjpfB1c/ij8e51he/vTEBTE
9VtTtYwCiyhtuo//EEw+kEodoB4DesktyyfeQ/C6Qa+xUXAMeO+FWip5DgG/
3OP54mNjYC469PbQmyHIDAzlTNUbA+qPNZ4XXw2BzkqxfPi9MRDdOHk03nUI
hoxHLn94NQa9/grnZJ8PgUsBo9Pz0DHgVw0LHHs2BFxCR4IeZI4Bm89kXfOT
IUh+aZh7tW4MbOirMqYfD4HmkHOX9sgY/HpD3lVyHII+zcgNpa0xyG5NciI+
GoLHCZX8kjzjUEfaqjezHwIWpklVniPjEK5mXaFiNwTfbNhv0GqPwzzrR7ym
7RCoNSq6LZuPw1MWe1fXh0PQdtQ0cth5HEJeWKdRbIbA5tPL0pZA7LwA1Zsv
MEyz9m2wLHkcPF8GnQIMf71KosqoHAcNZ3l6RQwrFs2JR/0eB5vMKktDDNcL
47X8VsfBw4wOF4NhC/cTlm7sE0BMDi8RxOJtDt989/DgBBxVzROoxPCnMx7f
r8MEKIh8ag7G+MkkJtXqmk6A2a0Cn2CMfzVz0+QJxwkwoc1aLsfyM7NdYT70
YQJ+cTHl8jkMwWoTvwxf3AQY+Gu5hmH6+Cqc0mMonoCZDuaFs05DIBF0126t
YwJyuk/nCD8dguL19/6jcxPAH0603Yfdw9mf7S2VopNQ2W5yKhyrl6fIvyXi
iUlgeyMUzofVU/iNCD728iTYPcA9Ln49BHra1sbuHpPg+15p96XXEIwm+T+z
j5iEnlEyJcxnCNxYc0Jv5k6C8Ru15H7fIUhr2e09OTEJW9+4jnd+HgLtYxJb
0lRTkF+QLPUhdAgGgnWFBQWmIFPruoFl+BBw3Agy/3t+CnoYHzp7YX62HztM
yUmfAmHp7sCnuZifzHuZKuqmwOZZSRaxaAiu9LyXaxydAq9G6hO85UNwomHi
+ZjgNCjMJUxfahgCWmICF8F7GjgR7+wbCnb/3MRPOd+agXcDlFgNQax/rLfc
9XgxAxpL4fuixYfh5aPXPgHBM0CxFc0TxvqOhcVgR2LDDNgrPOa0PjEMsjqR
D3tUZoH1xVnbo6bDUIEXCFPlmoPLaoIvieHDcNyPVHpWZg6qHYoPPorH+hCD
y+hl7TkYxg38UUsbBt9/XUdt3OZgIqA59m/pMJgMBtV8nZyDVWemzqWRYZhO
4VrdKp8HC5GgjVWZEWAR95QaPLEI5z9y9CcXjQBJ/ePRV2cXoZCmeTugcgS8
TKNU9hkuQkejiYxl/QjQBBacu/FwEWQ4PTfaekdgc3f2fnfkIkjuvt6fuTEC
BYKbj56lLMKo0emg2d0ReKbM6MKbvwjznse/cTJQYNlO/P2VlkX4a/ZtmJ6H
AjP9xknNNEugFe3oESZHgZS/Fpn2nEvQ+yfrytJxCjzgcShgF16CGztynodO
UmD0wgfSBaUlcHpV+FHhHAW+3Q9tmT69BNNn9DKoL2J9zSO+x0d/Ccq2ThSm
GVKgv6h0svb+Epw5+PN4yE0KfO1qWLR6sgR3h//ttFhQwHS55y/9myWYVY28
M3qfAh2HV5jOfF0CM1Ptyo+OFCB/kTpcTl6CuCZDwtJbCnzIOa5wq3cJNiL2
1/V5UUCn5bTq7tgS/PwUsxXygQIMs/qnI5ex/a9E/0n4U6Ca0UxXfW8JOCJz
2D0/UuDtAevLv1mXAR2n8s8OogCCZ9de8C8Dc3xXW1YoBYqfBVoXKCyDkVEl
t0gkBV58inS8emoZ7rUmtb6PpsCJ9JTn6+eXwRT3oqc8lgLrdflvgq8uwyXF
uIBfcRTIGav2OW65DLuTeJuQBAo8pm772O6wDD0Xnw4oJlJAft9g2OOXy7By
6t3dr0kUmD8xG4v7sAxH9A4/IydTIM3oX3JmyDLU+2tHklIoYOvAkHUpbhls
s+Jv+/+ggLQvvmg+YxkqqoPP7UulwGSiWKVf8TJw1HKOPsHw96oj9bJ1y+DP
KdYZhGHLQbW2hs5lSOVHRW4Y3r91rs9mZBk6zaYUZTE8RDAeYV5Yhvu1QQPf
sPOjFC2mk7aWQef5NYshLL6Z/qPlc0wrYFFy0WUU4ydo47Y5zrMCPQEmg+kY
/553PjRe4ivQPGtqAlh+IbEhLJJyK/CwRTUiGMvfqCSOu1ptBfqS+B2ImD7c
vZmCd8+tgJRHbOQnTL+W1ZL9NEYrQFRXoVHF9PXnapCOvb0C+3Q93OIjKFCo
si9X334FdqKodoPDMP+ZP4Jt1xW4sv/p9ukQCnB5VdQl+6yAE3K5kvSJAifT
8EZXQ1fgJ53bJgmrv1XHvQG6hBVQ7JtbjMP88Wkr/0FW1gocUj2prIr5Z1LX
7CV70wo0mpxJ/+RGAR7HdMafv1cg74AU1VVnCsAXqk8Pplbg1MuOyU7MjyHj
8d+r6FbhedJlCTorCmh5zDU/P7kKedkNDIcuUMA+Ba5L6a4CdfGvhRotzO+t
H0c7TFbhmU7Rs/3qFFgUVf539PEqLLO9HOeSxfQufrV/PGkV1vmnnvUyUaCO
0pL6OW8VLPupzGz2RmCV5YDK6epV4E5/2vhzbQQuXKu9EDG4CnF3xlnjhkfg
7xrnU0PCGrxvih0NyRuBA/ss9vYOrEHU24x6+DEC+mdyfNIU1kAz9s5mevQI
JHwyjWK6uAYj1bm5FO8RMDwaW1vqsQY4u2WmMuMRSHugKCiztAaF7hccOCeH
sTp7xvfsroFzb+eH/3qHgS6/S86LbR1i8mxt/tQPw3V6V61hqXWIMq0nMWD9
j+lblW2o+TpY+preD3iE9dffRmW05HUQS6IecpnH5nf4sJ1j7zq8K0FTBweG
IOu6vfDg+DrMkpyWShqxft7n/byIegPaJBuf/UgdgvieomOOKhvgFjUQHmc9
BOOdYkkD3zbA6bstgapyEGxaZgMLn/8Ft+fLwZlhf4A78DlIef8FZ+p5ahfn
P1B0iWE+KOgvsNo4e18x/gOszaIXHDL+glVrH7U+7g+kNhrSS439hb/Jbddf
f+iH+fqC50EG/2CzmFde1eM3OP7ytHgktQlXjYKn/gvtBZFRbYb1Y5sQ3ztM
HenWCw00zCluaBPo7u+bodzpBUnkt+RzbROS13dpCUd6obco+HX8f5tA4yYr
JVLTA6czv0f1LmxCSF14nRptD8w3PdC8vb0J7qF4h6WZbgifkx4fZ9qCk2I0
oeMd3bAmnXFkVXwLpooP//FL7IbkhPxiDqMtOBi18KHvUjfgwkl9WgVb8Kj8
Ky4rtQtKCz+8qq/eAstDsmrOYV3wsEdv/+XWLdB5PW3i7tUFv3hbrc2nt+Cd
n/rJa3e64Hlg718X4W3o4Pz8T1mwCw5mhEfsHdqGy8rEUD7mLmhvvIm8lLah
Nvwro/rfTjjCOuL9WX8be3//TTTo7oThd9OE9NfbMHR0vT3lSyf4x6cWHffb
howNj/wfPp1wssre/GfYNtBPphAXX3RCMNVKAilrGzSkHeu0zTtB13XrOGV0
Gyp9w+L3H+qE9bCSHuulbbhQlHJdS6gT4grc3RZ3tiH9teZwIkcn7KzRVu8Q
dmAtZnzh5HoHEB3YrvDr7kCy8LffvqQOIH/FP08z2YGgfulXlOIOGK8WjNa0
3IHv5vak98QOEBQ4PGPrvgOf6/xKSsM74LiWPI7Gbwf+iERyXfrYAZfsVFRC
v+4Azqrc8Ih3B3hWnPWoyN2BuEOU3DanDoia0Us2qdoBlfasW2E2HVDAa9Q8
07IDYk3KLGl3OmDO2kKIMLsDN/Dbj4sMOsCE2z3bZv8u8K7P9VspdoCDulfv
3tFd8GsozfSX6YAPVn57QRq7MNLkdY9asgPKisIvlJnuwpN0UZUa/g7oG/3m
aGS1CyaKb/P48B2wypESOuW0C/eO7f3OYu+AQ3cLKPiAXfjmLj9QTdsBmn5l
zMkRu5DqKsl7cq8dzPJrjp5K2YXPf6wi/222w7PhRuP2/F0YZGchUG20w0fW
TtcHv3Zh31MJEf2VdkhV6o/daduFHtcGI8pCO9TcotR+GtqF8A8818pm22HI
Z3pOan4XFpl564en2mEzewlfsrULdy1GtM9PtAPPwF9VQ+Y9eLX90f7vaDvI
MVHdniDsQYrt5tDMSDvoKDJ6uUnsweuwvpMSw+1w14wjFae4B9POeNbYwXZ4
5cXb9h32INOcqefOQDt8yRT+e/LiHoTFC8ta/WmHrL4DIq3X98AuJjswrb8d
yHQyZ6we7MFSknyACobH5RRttp7uwRzPRiYthqmuqQYGeuzB4ZM27jgMC3qg
PMmPe/Dw8ZzHbQwrpZ3rL4raA1fc6LlFDBt069MYpO6B6COiUTkWz4ba5NBY
IYZHCo61YHw8ZW7qv6jdA71l6fuiQ+0QZWz5hLNzDzZ/Ft9Ow/IpcH/4NX5k
D16Gynx8TmmH9uTH5aqLe9inxXFrj7F2mG9/Pt60swfXl4Ov1WN60bkjhix6
KjR2iK394nQ74HjOhLmxUaFvg0ba7HPtIJJ8TvYcngodenxEgmmxHU606xv2
i1GhpS8eI2nr7XD2geHYdykqpPTsX+xVrL6GO8YujnJUiIKvclHbbQdbqZtR
DOpUyN73Ym0SQwc8L76t0KpJhaq5fGcVWTvA67JldbguFaofEvBc4eyAWNeH
0/JXqVBfnsg9XsEOkC9n/ut9kwq1zvpe5hftgHK6JPrBu1Tov2h9Ox2JDhjy
GxXzc6BCX2xO/jtytANEYm5enfKhQp8p+za2tTsgfXTLEgVi+x++fGN6sQM0
Dn99HBpChUSeJ+v1X+kAs6wuv7NxVKjX8ZzIdez+fK2+VB1bTIUEXw16Cb/q
AGnm+da/lVTo5FBNZeK7Dii86Dt4qQ7bf3SqxtivA3q6SJs7nVRIY4hOmS+y
AwhTpxWuL1AhXp3/uIVKO+AT+/Eo7v3U6FuX/HNn+k7Yb9j2w/oQNTpT8iOh
DesnxBCHwnI5amSpkN+kxd8JLaJpHfYnqdFdlwuxljKdwKF4kLXBiBoxFZ/8
986wEz6Y8Lt4eFOj+QvPfjjGdcLb6O3Lq7PUKLjLc6FNpwsM5AscZVaoUdFg
SE+rYReIVDh9tPhHjTzUP+vVmHVB0ch0Sws9DTJxbI/4z6ELliV7L6WJ0KA9
qcxm69AusEjNvWhlQIMuXdpofTPcBfIajnaRJjQoYQt3zXS6C3YbZf06zGhQ
nP9NafxKF3xdiCNrWtMgG527dxTouqFN8dMF0bc0iFm0Pn9Zohtiqi4+NHlP
g7YXuVYaZbvB3oj5Pz9/GvRiWp7l3fFuYHn2un7rKw2SCzH98larG04X2uv2
ZNOgMioqvuhb3cBxXtqas4gGsfrrtqpbdUN/39h77XIaJCxG45hu2w0u22ak
HDIN+niswI35eTdo+/FPzrTRoLPs5uuLr7qBR6SD8UAvDSqVKXRO8uyGTLhw
7uMYFs+LWdwzoBtetTDcJ83QoPWCuaDvQd2gd6fSa2+JBqWcCksIDuuGybeq
NXa7NMhZXkKp61s35OHXxuLpaNGtz8t7ktg89IzPpO9noUWdylZ7p350g1iN
1NnzfLTom7Cpfl1WN8ybUCzf7KNFmvwxMqp53VA8EeVZcIAWuVkMaz4q7IYP
LtfjFw7TIlRVN2pT3A2mzITqg/K06CUNo4VMWTcc/NpKualMiyQmtVkzK7ph
VdqPNlidFh1UV1H4W9UNlT91DpA1aZFjzTsJ2ppuCNSj06LVpUW1dX+UWmq7
wfxPmYXaJVrkzyhXYl7XDbL2rm8djWmR9WaPUnp9N/b9pvwt6QYtkhbakCht
6AZSwHLF4B1aFDMSw+lP7oYQsfRhwgNa9LVu/sW+xm6wJFpT69vTokmdfzMP
MayoKSn+7gktut7bM+GCYar2IVT8ghaVrSSsaGHYc6o09sUbWtR7puh6GXYe
M1Ukjep7WpRe+nFtBovnT3C9u+FPi94/b7lQh/HhPnKtOjeYFjEKU7NexfiG
aqlIPomgRfW3XEeCsHyEr/N6KcbRIqfdkDdvf2H+clgZX0zG9Cb+CBXF9JD0
bj2XkUmL1hVxHQ/LuyElMiPJLp8WcamLjluVdINcjh+zbCktCvQ68pKrqBuy
6x/aTFfTotWKhAsPsPqcGNZtSGqgRXGpZ+TtsfoVb0jJ3m/D9i8wyOxPx/zJ
weAn2UuLvIPz1D2Tu+H8yUr9b+MYP2BIMozuhqbLMRm352jRUTM12jLMP1ce
vOISXaVFbeyeLr2fu8EsWK0tnJoOfZ0QK+L37oahH/zHrjPRobLb0r80XnfD
vcr1z/ycdOjdC7wbDvOz/UKWcbAwHWIk+KrUWHfDMv3HvCsH6FDDddHhxDvd
4Cz8iI9bmg5BTdhr1Wvd8FpXptdfhQ7phV6YsTvXDZ/j4szeG9IhrdVGSymx
buAvelOifY0O3dFPSwni7YaIllsi9LfpUOvL8OVclm74viM09MaODj3pr2Tg
W+2CgqtBd13f06HO+tbpe1VdoG7/uFo1gA61nYq+4ZXXBRWeBpJ/g+nQo/w3
v28nd0E9kW3iSRwdms9JCj7n3wX9rO9s7Eux86kLZNeMuuD2/rsNsr/o0Buv
1IK9s10wduK07EwDHcrCXRAmK3fB/L2dufu9dOjy2Zq2dL4uoC5/6nhnlQ5d
e4IbLOrqhINPrFyMpOlRzD+HP3/PY+9BtcEr0fL0aDPVJ2hCtROOU5kenVam
RwQTh9lM7D2n6as77q5Fj6KWQ2u6sf5rHi9r9MOMHuHwg3rBWH8O6Vg+ShNA
j9pahC1qpTuAXsl9ImOFHv1+P+f0a60N2LY2Kjf/0aPoI4LPpUfagLvCIeos
FQOSLK1n9GtqA7GLFsa/2RiQAV5pRj+xDdTvna1iOMiAepp0eIdN2+BJMGv0
TVMGxJOrPcNT0gqja6EmrCUMKL6s+VlHQAt8O33M6U8VA2pSVW+UcmuBW35N
ARn1DOjFTgjtlwct0CdBX3elhwGNna2nbjvdAq1XHp+MWGFA6dYFGW9mmqGU
qCd2RJoRha+sXtAnNYHbzoT6njwj4uuwuama0ASquh7XWlUYUad5tqrT2ybI
GSr89PQsI2J/qVnTrdEEKZxS9KW3GVFlq8vVlwWNEGpHPa0fyogiBN9rLZWQ
wagwgkE8ihH11bWHKsSQgZv+xIGVeEbEKV8t1fiWDP4R9mahWYwo52z/cX5d
Mng2/G4abGRELpkPONj7GkCTz3mG2MGImnJlKpTKGmDPgpvJ8zcjYvjDjEri
G+DFps7pQ1OMyFARNU05NIDD4bxsBzompHSHeKeCvQHknl5u0WRlQoYD1imT
a/UwUz47y8PNhGgY2bgdB+rByvTAwUJRJuT/jOtbQmY93PQO/EJ9kgk1sgSb
Rl+rh/NjNi8/OTIh243nh4ZL6kD75YHUMy5M6Ojq1nGn1DrQ5O3vW3/FhHKV
3UXvhteB2tmLJ274MqGE3FA+sxd1IJ1wdOVAIhN6mO90JUO9Dg5qTIp3pTGh
z7sWnEfk6mB/Z4zB+xwmFLmvuIhRrA4E6bnTZyuYkEnEIa52ujpgvbf6ILef
CV3XWm8paiMB005q6H0KE1IwcPlPoJYEdMH3agSmmVAYHU6v/ScJtqu7Drza
YEKX659QTL6T4K9ZgKH8LhMq51BRF4sgwerquTcjdMyInms7SusTCWYlCge0
uZmRwzlvk1B3EkwWO7L/42dG0aLhf2uekWDUSFr9hygz6t/aM7hkT4J+z/Aw
ziPMKOsK/ucDcxL0CBuRKo4xo3H+Ob5/JiToyGHbcFJjRmZP7SuGLpGAPPrS
qOccMzrjXRqYo0kCkpuyxwd9ZmTgVUAdo06Cap4ForoxM2rPyDQeViZBeWri
0PwNZvT2Oci7KJCg+MxtzlgLZpRuxiJpKUuCgn7+U1esmdHkJmt5vBQJcp60
2tI7MCN7V0U/1QMkyGT7EJ7/jBm9oLfl3y9KgtR4zXrrl8zoQvn3uZtCJEhS
3/or5MmMhNtbvszykSC+I1uq6QMzOnyvJ6GRhwQxtrYmrz8yo8zIHzFU3CSI
oJN8p/iFGc3FneB9x0mCLxF/skejmJFQtF3AdXYSBB0PGQlJYEYueSfCX7OS
IJCsj9NNZUaHIq9WrzOTwM+SEW1lMaNrq9r/FTOR4MN2mX1aITMq6tW508pI
Aq8gl8hb5czIwyYu7ziG38oqkHG1WH5VEVtjDCR4VT21WdXIjMRpXWNGMfzC
7NvhZx3MyPKsJ688tv7Z6nXTQ7+x9Ym79bUYfuyL9+4bZkYj5+QVfmDx7CXI
ub6TzMhH81ZBL8bHpthz9NQCM9ZPWlsMMb5WRhr4pTVmVFDcOM2L5WMxu3Y6
bpsZFUYlPtuP5Wvume5gTMuCZC64DjjjSHBd+H40IwsLUjcwfMaL6WWSI9pU
yMWCLvTv+W0SSGCo17P9kI8FFe67+vSgIAn0RwNlRERY0LimjNuXfZgfZEY7
zCRYUGy1exK7OAkuOKm8CpdmQYMvDqeUSpBAh2aghV+FBb27ObjUitW7Rlfh
xVUNFqSxLix4DPPD2Y+eB0K0WJBgBHd/oxIJNMVknuENWJCUQeBSGmD+uf9K
1NCEBT2Qk9+3fIYEkNFKCjRjQRu7Ru5250mgfspFiMOaBdEl8coxYn5VMvtV
zvSWBUk4kiWzH2F+iuO3OfeeBXGrzq1FYv5XnHmI9/JnQbeM734oekkCuRfc
VrTh2PpilXNeviQ49OUW6242C7rJ0nHOKJUEwh3/jFfGWNBhhmeuhFUSfBW6
uKcwy4KoPh0wqNwhgcDdmCSHZRbE+UZF/zNjHRCWtbfmdllQksxQWKxQHXBx
BcVM8rEifhtfbqOzdUCrJzfzR5cVnVnTpshF1cF0lcVrUhor6r+ifeGleT2I
fuyx8c9hReaXH3JQHtaDkbm+sdFPVsTQ9pZK73k9lP5VlR4isSIrtXJd8aB6
+HQE17FBYUU0k9mQXlcPJ0PLpKQE2dDxqBzvYUWsf1oqcc+JsaF7UdHphdAA
3xV+bGdJsaEfXa87Xug1ABc5pPWUEhv6UqJ/k3ivAUap7F1NDNhQkdLMbFlI
A/jaCDe/82JDn01/x04uNUCFyqfCC35s6CSZKOG13QDrdEzxuCA2RDp+vHWJ
gQy3o1dcImPZEMW35PARITIc76jfn1vMhqKublUwnCaDdSxid61iQ9WfohIn
sfkQZZ+3gerZ0NY3NT5fQzIwMX8jk7vZkCA5yRl3lwx/NJ4/G11mQ7vtb+/O
vcbmDevC7ZR/bOjO4ZgbWd5k0OmxvOBAxY7GXLb0j/iTIeuxgdg2OztqNIr8
B1/JMAE1LJU87IhKr1S2M5oMwuzqa95C7MjF/qa2UAIZvBKl6vGH2dFy2kup
3HQy/HwSmdN7lB3xWCv5MmSTYfE0PjpamR1NL7KK0eWTQZLTx+eeBjtS8U9o
SS0iw/X+XSeZM+zop8/3//aw+RiQ/MR86Tw7OimbfWqrnAzVz6Z18i+zI5xL
am9UFRn+ad0+9tKUHSlRZB9O/SKDHK5rn9YtdsR76RZfXy0Zxv3G3wbfY0ef
uPSbrtaRIZJlY2LiITs6UEysfFePzV9vxotqj9nRLLeI5t0GMrDR8Wf5urCj
s7omYQsYrn59iG/wFTviyqMWkyaTwXXnhJvCO3bkcKTRmBvDii90hz3+Y0eb
SbVlidj66fVr2l0f2dHp/VSUKez8b042Pw59YUfdn96d6cHiX1t8weUaxY4u
r1pZPyaRgcvuv6eN8ewIoeyu/BoykKbC+0R/sKM81r+4pGoyuFulwmMiO8pw
Of9Ts5IMypTi+Op8dqThMBHiXUaG+VuNzHyl7Oj9jecPnxWTIaH/j711NTsq
ikvZ4ygkg9m1+faf9Rg/oqTg5Vwy8HTtnuBoxfgvBL1RJ5KhwZAz6nY3O9L+
9W27JZUMb5tFabP/sCOOuX1XOJLIoKYn/4B+lB3N78+1Xf1GhiUSarw6zY6E
y5sNPSIxf1beCd1eZ0eK2bqZ4R/JwA+Pt/V32NHr814akv+Rofnn2zuxtBxo
roGq6qonGU7lxsloc3GgYG2X0fynZFhXyAn8QuBAR97vKx2zI0NaevXatDAH
MtPIPFhyD/NX0lhZwGEO5B5xdcjaiAwdEusSI0c5kBNetxkukOG/WIYPx5U5
EPWX4ffl2H3Y/Cpl1KvJgcQCt79WHSFDj5/15H4zDhQxOoP/Q02GQJYXF59a
cCD9FYbbvOsNcM77Q1btAw60VcJuvj3VAHmvf7jZPuVAcPNTdk9LA3x2muPK
8+dA4a0NvgNfG+D84s5TpmCMf7bztWjfBqCx4/h9PRzjvw/3g+cV1h+sjibs
JXKgCa5VDrHbDaB/zVFVtwLL553wr3axBmCBtTv9KxwI/fX5FBBcDy6nDzHl
bXIgeuNfR1++qYdxrRvpAdSciD+7w0vSrh4qdSo2NTk5kUTHVf1UrXp4Yej3
OVmaExmt3S8tnauDmXuSv57d4USywioOd1XqgOxrfAjXzIlI6urmQam1oBbw
vmm6kxOJ+ZTnsn2uhaSPP59U93Oi+LWY8KfPa8EzRLzCeRpbn2eZKapdCyIt
67ILNFzojXeZAe1gDXT1Vv4yFuFCl95WSDlw1cC5uesb+4250ICYvJWyWzVE
8Xi0u5tyoXs5c/cOWVbD6skfGf03uNCN0eAQFb1qiPmwdT/Eggst/ti0IgpX
w6ZURA+zAxeq9uJ2PlJWBakWfwoXP3AhwYSUCzysVUDzgT7koj8XGqU9Zn9u
rRJMiUcep3zkQt1zp+MTBiuBnuqVtOUXLtTTbiMznlMJ5pEi4d0JXGjuBnPU
+zuVwNVzy620nAu57Xl/7KiqAKs9b1Ohai5knzbxjopYAcUHM4+71HIhemXq
s7ejKsD6KdWcQhMXErOUHip+XgGV3LE3E35zIeXD9M6rihXw5OLIKd91LrRv
q249KqMc6p+wCE3940K/pPeK5WLKQSxCcePsDhdyvCOYvx5YDo3TbzP2aHGo
bsul66hTORx8f0DMCYdD531x6efVyqGn0pL6uiwOHckIsXj+vQzrh32CL4/i
kNtr2g39wDJgrLh0PEYRh4Y05ZzfvygD5TK1++MncGjBjnBUyqAMgn5yNT4+
i0PXDkTL4KnKIFXNazxYB4eKatjJjHOlUFW4tVdwAYcquPcO3O4rheX8ccW9
yzg0t5muejKvFC7lFH/5zxyHZD1MNUIel4LVMcWs9Ds4ZO2pnB5nUQqvshIb
Wi1x6GMmz1P8lVJIzfy0y/cQh3BHNK8KKJVC9VEm/pP2OMTSXCeUcbAUfqe/
VDB3xCFFRO3xnb8UWNIeWMY745Dw7qUDhTslsF924GXtCxySZhAity+WgOqP
K6HTL3HoVNGzTf3REniQfKpe3hOH1HrO194jl0BNAo98SSAOaZIMNNhjS2BA
4oPu0GccIrD7ykmElsBa3J4FbSgOnRhxswjzKwGJb9PBupE45KAicyjStQTU
xW9n2Mbg0NffR/5JO5XAlZhOUkAcDl1wFvrM+7AE3kaVb3Um49D39+IxezdK
4Os+Zd5/qTjE+NfecNeoBIgRP+SEM3HIzBCnZ6pfAiQhcR3IxiF3njhZdp0S
GPoacsciD4d0f5Z+FtYsgb8CbK7vCnHoS9WumJd6CXCGvQlKKsZh/eKLk65K
CZwKta2dr8ShK+vFab+PlIAJYWQIV4NDhpJyCcmHS8Au+Orm8Toc0uAq82uW
LAFPnka8KRmHstb4FvT2l0DEZ80jrs04ZMAzbCAuWgI53AXaUW04lJNSqaYn
XAINH4/crujEodcblscbBUpghCvu+WgPtl7V4VccXwlsBvB/ZuzHoap036fN
vCXAzemfKj2IQy4hFuRLPCVw2J+25uIIDpXqxV+WwJcAYn8+6DCGQxEuR730
uEvA1Hf+7+dJHPKOpfTW4krgEasld/4MDkl5GBQFY9jrQ69M3zwOSfTSB+di
OIr50tmdJRw6eOtz90Fsf+77anOxNRzqbHm/MInhpPMN/N5/cajPXICFgMX/
ytbWNreFQ7Q3RKtiMH5+TT2+Rns4tK7699Z7jP/rwEHtnzTc6KoD9UEylp+T
4TjVfgZu1PD4y/WHWP5WPHNF75m5UfPRXs17mD7XulaeLLBxo1ROHXwhpp/e
l005Ey5u5ODrPXPvYAnAdeqpYjw3Gi7hm7aRLgFFYaa4A3zcqOqny5FaOcxP
Axw3Pwhyo9+R0h3Pj5UAXwwv39I+brTomrb95kQJsFgIt14V50Y1dm9+DWiU
wPaBA/+VSnAjsf8OXgzQwvRPlN/7T4YbuSeOck9eKoFOa5XCZTlu5JvO7u9v
gvlJ5pTTNUVu5HLzpfK7myWQlnFh4qAqN7K73zNgblsCMY6GsX7q3Mi2WLUc
npTAp2PXbqwCNyrQZAuxdSsBl3yr5gptbiTXvTicgPn/4XM7n0PnuZHOoItq
ZkgJmJ98ohVwkRtFsJnr0MSUgFbZm3wzI25kISF76Xl2CXDURkRv3OFGJyQv
n/n8pwSofeKumd/jRo+TvBN/TpbA6vkU/K8H3GjQa/7s/tUS6G3K9/70CMtH
fVEygbUU4rvaHh15yY2cQxcFzTVKQW2cCd39wo28lIvVbFNK4UgS52ZdODdK
MbdU7y4oBTEbQo58NDeSEa/vsa4tBfr5A4d2E7hRkBiU7o2WQsvaKa6wbG60
PvERqsTLwIr+6VBTEzcSulSQLB9TBoKidd1brVg9nQTPnsoog6YT+5oPdXKj
zEcXA01Ksf5o+6vk7W9udDLFRT22vwwY2nnDlSe50elEvG8RWzkkxOQZR1Hj
ES8nt+0N3XIwLWK52ECHRzgDraw+g3Jg6zA/85cRjzyNZUINTTHJGRmPGXLg
UfVN88VD98vhjP1VLgYhPKKqoU4z9SyH0ZN/6+2O49FAOUs/Q3E5fDHWq/yq
gkdLx758/FFZDnqPYgpr1fAoTW/qycm6csj5ppMkfhqPUuTfWgl0lYMnc9i7
zot4ZDpF1M+bL4cTB+bcaC7j0XIFB23kajnMqp9+ctQIjy75axg+2CwHI4cp
C5/reNTnsxCUTF8BEt2qSOM+HlWWFz0rF6yAnkU/FRsbLJ/ZYnKuaAX4sozI
hdrhkYyg/j0fiQpY1fiwb8kJj97prB0jHamApKsDPCLOePR0soRKEZtvZo6K
bBde4NFZiD7irFwB1fF9m/Gv8YiuTWsn8FQFuJTKLbd64NHx+bbzlpoVINvz
dmrXC4+q3nDrc2lXQBCrTI+pHx69bVZrWNCrAB1J9+Z3gXi0aL2wIG5QAdun
2muyPuMRqM+KSl+pgLuPXXPZvuLRPx2TjULTClBWHMg9HIlHsyrW9MdvVADL
MsrTjsH0v/TOwONmBfwhxuXdjcOjiE83HiTeqoBMR4b819/xCJ+Y1h99pwI8
FKzzI5Px6NcxDQ3buxVgstSQX5SK6TfYIMB2rwIOE+UKujPwSN9AiMbdCuPj
8LFgNQuPbh6Ze1d9vwKa5VcLcHl4JLiPVqn/QQV8WzQplCvEI/Eakehf1hXw
LLOw8EIxHnE1Uxu9tqkAXQfhogdlWL4DdhTWhxUgLO9e9K4Sj3jCJf7cx/Di
wnDRt194dPfHRMtnDFdlnPlZRsLqf4F4KQDDIY8Sf/Y34FFIcCHLdQxbH2Up
/teE8bV80ryCna++YFtMaMOjwVxuWzMMc2U0Fx/rxCO997/SP2N8KPaKJQY9
eBTbW3IvDOObJxdcYvcbj0YTZW/ZYfl8mN8o+TCAR6JLmtacWL4306+XJg7j
0Y1sBUN3ywqQty8prR7Fo+jZw5PFFhVAKydWNjyBR6tfzf7V3q6Arrm3ZbvT
GP/izSsx5hWQnDZWJjSPRyv6SjVnzSrAzU6n/MQSHqUbaIgUXKuAS0d+lBuv
4tGb/ZYyGyYVsH+OveLxBh5pa9v20xhVQJ1te0XqDh71SKk9fn2xAiJklSvr
qHjQ+Fz5y2XdCnCY/VI5TsuDViL+uChgfiLYmleJsfAgv5rr/xEw/03JVFRp
sPOgq7pudcWq2Ptt5kD1dS4eFPkr94y8UgVYPJyqDiLwIMGfy+AuUwFKMnq/
iAI8KEA9f/z6wQpgmkn/1STMg7ZrefnpxCsgw+ZJDdMBHvT1mo1nGS/mB+u9
WrejPIiBXzdqZLscmg9bkMIUeZCVXtcphfVy+DZVTcpT4kHXmXUzLy2Ug671
h7rFkzxIdOPLrZ2hcgh5wNtgqcODxMI27kpi99/6kEvDmws8KPM7aW+rsBzU
J/saovR50I+TVxUTiOUwcj+G3GPEg6oG/n10xN6PR+/LNOnd4UHnc5q7qN3K
YcBa9FGaJQ8qdEhlTnUsB19bPBfHAx603lVIOIj1oynHrcvN9jyI9cyhL76X
yyHOraHzshsPWpg9ZaAiUQ58nx7+MQnlQTJKttGvPcpgr/jH7O1GHoTKUlfl
SSWQXhbtV9HCgw62bSd2ppSAWeVnuf0dPKiU0l9shM2TwlpXB0ofDzpj+FZ8
+jI2b9surN6b5EEvqp2Nk3uLYWJiZsuGlhfJWl85oTT2E5q5ZVmfqvKiH15/
lCv/FcIpO7upcHVeJFG5beT4pxDSa9NrK4EXuW8KlylWFIK/m4InlzYvahO7
n7b0vhD0xpV3fhjyIlPfqd03AoVQX3h6YeQhL9rO3xQchgJQ4/FoZH7Ei1yS
vnaBZAGk2Ff/kH/Mi6glwb2SpQB8Dpx78MqFFz1g/EKl0pUPOn56wwLveJGV
cdi3Vft8+HX7artBFC9KWzMbdUvKg+M/vxCdY3mRMO6ow8vAPIjn7QuIiudF
r082qKa75IFnvZnebAovivDPYInTzQPN4xa/vPN50dUwDdmZuVwoZ7TLL23h
RdPMVK73US7IW6QHj7XzojFpXHiaTC7EFC84sXXzIvOjx1dl+HLB3fGx/PU/
vKhdXmCwbT4HTv12Tl6b4kUjMS2SrTE58DP9bbgsLQFd/eBrTeLMAQY9Y8FQ
BgLaYa/7cG4nGy5PSYVRsxDQ1jntU+wz2TBxoDGki4uA7hYML9rWZgM+jO/T
axECKnLLCXnjkQ3mytNcM+IEVDy/fkPVKRuS24sDjCUJaJ6FseXE3WwADgs/
aVkCUvh+kcxxJhseeqS+71DF/pfIluVjzoY8MXdG0CAgA4MlH7atLKAuveyV
jAjo9BPBKN25LAj9u+7x6hwBiWbqzX9ty4Iqu9Puh4wJSLyzM+FLTBZwsPLs
fjIlIBapjw/rg7LgWtK4284NArqc3K6n5ZMFCyP/vWizICD5Pf1ZZqcsEDLt
eurmQECBgeX3J3SzwGotaXXciYAmWx7X66MsIH5ydbrsTEDT9hka28pZcK5R
zPHgKwKKGg53PSSZBZ9sVhYC3xDQkV9Kvd+Fs+APY439licBiUjI2dnwZIGT
5kPblv8I6I8jh3k5XRaUDmrMqAUQ0PtHQxcNd4jA/JLLJuETAV1kGAs7tE6E
6Pzc+y/CCGhA+Lpt7CQRpo3ej49GEFA++7yH1ggRlJav37sUQ0BM713ZDvcT
oUGW6q5EIgERM7JOl7QQgVDfNuyfQkA1OismDxuIcOd+wu1/aQTU130j/UYN
EVLpXAbvEgmovk1l26+CCBux582bcgjIOaNtlbqECJqw78+JAgIqoTjr5RcQ
wa9/4UbcTwJyG3ucn5ZDhAN8wddcKglo6NCXL2ZpRLDPud8z8ouAfhBOOfOk
EKHwstrVi3UEdL6+QpEtkQh0C2xd+WQCuhA38FArngiXfAeN9rcQkNVrtcrC
WCJ8PZzV7tuO1Qe5dtpHE2GsxtNwo4uAqiq0z1pEEkHe8mrrnT4CekrRJH4O
J4IrtbQB+Q8BCXvyFtJ8JcL4Gdaeg8MEVGEO8TlfiGDwfvbWm1ECsh6POBEb
SoSihsaJ3xMEpH+TRogUQgQJzoxHyjMElEh/ZvEQhv0NAzcC5wkoU1z5ZlUw
Ef4GO7rPLBHQzakD9KEYtug1ZNReI6CMVx4v4zBMFj4eEPOXgJQGrxpPYlj5
Ni/f1hYBKbtGC93DzouJW48y3sPuS6XpLQEsPstE98FMGj7UcPBtBh3G76l0
YToLAx9aIAiGHwwjwpDdV+V7zHwonVaU+ArL5zzRtbSMjQ8Z3Ax4zRZBhJxV
M21BLj60L8j6SzOmh8iJU01P8HzInD/VuxbT672rqEkzgQ9du278ZwXTc7mU
auCwIB/qeut0yAjT24xm5J7nPj4kzPJmaeI7EWrPVs0NiPEhhQcdGenJRFD0
iX+qKsGHWsosehJTiRBBfrfzWYoPEY+JD7VlEMHhig67rhwfkt6iuVOcR4S+
kMPBcQp86EQQV/XzIiKc6WPZt3ucDz3p2N9nVUoEgTuNstkn+ZBV5+GVRsxv
lfaGevt0+ZDk/IWA8l4iyGYd63DW40ORpDKu2QEihKzxmLVd4kPVQIrQHCXC
Q7fuh94mfGhXOUvWfoEIPB/M/lu6y4d005KCUhmz4FWjBl7vPh+60erevo8j
Cya5RMO/2/ChgQ3xxhzsvpWEDqfccORD5wTFNC/vx+5zglX9r1d86Nb22T45
yIKWyXOGYm/5UFsO/8lC7SxQkz3c9+IdppeN5LG7+lnAmT0zddSXD0kpHMzl
Ns+CgnIH5q9hfChIwiC47lUWsPS/0LHP4UPszvlJHdVZoOyczB6Qz4fw+xGt
cWMW3OHuacso4kNTwf5Bo53Yfh2lm0vlfGgx4ZSe3ATGJ3fB8UkjH1I7Q01l
wpINFf6W4S/G+VCZ9tVvxwyzYfbw59vhU3xIW+TLY60b2cD/q0KyeJYPmQiz
1BlZZoP9lkjmzjJWH/Nld5dn2SD8oLf69R6m35PUfylfs8HltP68Fz8/4gp8
ZTw2nA3x/W7ZiUL8yPbot7rI6Wxodv7hQhLhR+VznRE6K9lwMJ2JlkWSHykw
3vNwpMuBdsEqPj8FfuRza0ZxTTIHdnOX+tOO86P+HLa3knI5IH1Z7FuTCj+S
oRhaIuUceO39UpbrFD/y7cumUtTOAblVldOfz/OjWBMflynLHLgeYMWQc5Ef
nfu1q3bFNgfeSQc3dBjwo96Ird/RTjnQf3vZmHCVHzln2a/8eZMDHxpTbcLu
YvxaT422ReRA3oPfR4us+BEceHJSNS4HhmlZ1vqs+VEPJzuNa3IOnFC77y7s
wI8C1yrV/XJzYOy7eFC0Gz/q/k440NGQA7Oew/9oX/OjLmvShk1rDixbxN56
4MGP2Hh+xjZ15QCVqLiMwgd+VPOvWOnvEDb/doYCg/34Ud3NAeHisRxg/x2z
/i+QH1HOhTbpTOeAYKhYZWUoFj/nSmLBcg6IPx2SkgrnR58mHm+HrefAoSsx
fv9F8SPGRHdztInpoXB7ZSEWy1+iYTRlJweUOMWuGSXwoxPtfFU9VLmgPjdY
WpDEj04vnRevo80FzYZoiX2p/OiOcbWEK0Mu6Cbf+vAmgx8dc29ln2fKBQNv
0cWxLH7kQe4XFWfNhav3Bo3P5/GjsHLNIDx7LphrRf9ML+RHM48vp1Rz5IKl
+C1xfAk/8nNVLjnGlQsP90S8ncv50buLG0du43Lh8Z+B2d9VGH9n55u63Lng
8jPKENVi9WMLSJ3HsHuYeUF8PabnVSP3S/hc8HIWEWFu4kfEcUvDhxj2Mx7w
sGvlR5xpH5JPYzjoWNRUawc/ao0KYGrD9n/FmV9S7uFH7mfvrQhhOHZhX+7X
3/woyrBuUwSLn9T4R3BvgB8lxK9W9nHmQvqPyNd3R/jRyIO4JX2Mf67PzfHa
MX4USf4o68qWC8X39+nJTmF6jjPsu8WSC1Vn/xADZzF9btZ5bjLmQv2BSL61
Bcxfn6qOXqTPhRbqmy+vrfCjgX1jUyY0udA9KEwpWedHqe1i7nx7OTBQ0q+z
f5MfdUT3Vvtv5cBoeES61w4/0phbTi7ewPxyVfjFJToBFJubKaK+kAP/lPoH
sxkF0DHaP5/9MD9Q8USc5WcVQG9cQ14F/98vLUK4YZwAIryPP1bXlwM86b+f
neUVQD+DdbXWOjD/+Ib3J/MLoA/6Jy71NGF+0RFKeiyK7WdknqmqyIGjB3+z
d+8XQG00ZTPkohxQpgt3OnlQAFWriHT5ZeeAVrkg0B0RQAIJVc0n4nPA/IRg
V7CaADoXPe2m8TYH7hH6Tm5qCKB7V85d4XqeA7arYbHmpwXQ+k6kZ9SjHHie
KWAnpYPFM/2gsHAjB4IOCdAVGmN875k8e6yQA2bmBxMppgJoo6GjZPlgDkgE
HTvPYSaA1P7TLjspnAM5excD71oIIHENvuvSDDnQ0fVWmOORAGqtJuf7dmPv
wXezx+++F0CuGtea2Ryzoa/oX7fffwLowcaBITvs/fdtkcG1wF8Avbz/syzO
OBsUzcQr2IMF0K0x9/cfVbPB8JjJxYJYAcQcGRLiv4e9r4bL7rH/FEBLkU8d
hzyz4DpfI9OJUgFk9ZezZOdJFuy/2PfDokIA2b9Qpd6zzIKsgtWl/FoBpHig
w4J4JgvaAg6/sugQQMS/rzOXaLIAd+pzSP6cANo1GDSqcCVC4Fer2jtigujF
STyb971McH721sntgCCqfPScwcooE8wNo0RDDwoi6qXEunNamSDL0uVMlhVE
ijzyUwTxTKh7fvaQiqogQo/jVVYLM4DmmoQPm6Eg4qlbzNlOTYenfCPn8z0E
0ZlNrm/eKalgtrKz3uoliJKmOhLK/kuFM80CcbM+gujiN7unUnapwO19eUs8
EMOsSnM+8qmQvl7+wzdCEKmQMs9mFf6Ayc5oNotcQdQU9d7gQlcKNBN/FrgV
CKLg470ulKIUyPPrtgz9KYhWRM3J+dEp4HmWs4RcIYhkI2q8+WxSQDz3lZ1K
kyDKJtaaVVOnwPWgm01sE4JID4+ua2gkg3A2i9DDaUHEepLx/p8DyTDYmn+/
bk4QpYSr6DayJIMlJze116ogeuzKthbZmwT2H2qO7VELoS+DuBI21ySQT3Z6
fZNeCIn9SzunZJkEK7VijT+ZhNByw3O7zItJ4ELvauXCKYTmr7joRosnwdvX
R8OWhIVQi1wetWVjIpyJ7h+7JCaEztMt6B0sTATGUh/F9ANCyPnKsSD1hETw
3aI02EgLIU+N2Yx7rxIh5NmXXYqKEMqPP2n843giJNtSW3YZCqETXjK8TMTv
YPtfeuZxEyHUc1Gmi+Pbd5BLubHz6ZoQMn5/KtD683fImsgNuXRbCJnwtvsK
On+HYgubOpKdEGJtZqu/r/kdXr3hI0g5CiG5vOQzrMrf4XRMtcW7J0LoeStn
LLX0d6j5I7J92lUIrQwTjo9zf4cW03a5n++F0D5+GSWfyQT45PzaVcBXCJ0d
E5UvHUgA45AjJOcAIUQ18sb+TGcC9LV73zkeIoQKwl4EalUlQMTy8fRPYUJI
1W9s8GdRAtzCjWwuRgihV6wvL3hmJcCovnpQWpwQui/Qp08XlwDf7aaGWBOF
UMCwk+HP8ASw9g05YpMihLwSRnQrghJgvm6x5iBRCG0/GZsp8E6AzMlI/Lsc
ITQjJ7KT/CYBnBgv3KbkC6Enrm0Vk64J8PdMwr/oUiFkr6U5ddExAdx+RntU
V2D1TVyxqLZNACrFr+xT1ULo6OU5tZcPEsAzKSiUnYTVy2fxgItlAjCKBogr
Nggh6rDSlpzbCfAh2OeHSZMQsq7jX1W8mQAcbJ5Krq3YeXfL0fI1TJ+3r8qi
O4TQ98xn1ssmCUD456Jb3S2EOoNTxI4ZJcDXR07tk32Y/lZuXDmXE2DfuN1N
9gEhFCH2te/JpQSIMXswoTAshO54mYg9vZgAEu0WjiajQqjUlM4j50ICJOne
3HoxIYTWTNfjFM8ngGz51XfR00JIR8ddYkEH00PZkLN6Tgj9m1hKmDqXAMfS
9MImF4WQ7r+YOnEM5x04d4B9VQjrZ4PyodoJoPb1dJrCBubXp3tuuhgu5VJX
MdkUQj53jS6dwLCmt3LFix2s3oPpOncxXLMjfyGaShileJ7eq8Ow7hOZzipa
YZQ+v0Vli51Pnpa8NckgjFp84n/rYHwM7ohNsbEII/9K6n23dROgo1vQSYFd
GFnR9xkSMf6m+rw7xlzCqLt0hUVdLwH6qzm9X+CF0c0bvO17WP63TrLgognC
yPkcveo2ps8IkS68SkAYxS341MsbJoDVob3/VVzl8VB+X1iUylKSFjUz3nde
kUhR0qZzCMmSsiUkKdJChTZLpEKWZozIDDOyG8qWNslapGiRsiTfSoWUCgmV
fu/vz+cz973nOc/znHvvqPYyGOhWtX+OkNbXZ87wah2KgU2b2PILnbJgMHqg
xl6Ngd/VH9zXpP06JtlnGaDBwBWR6018aT+Dvr1xq13GwMCoVUGifXQePNs+
9+gyUEc+lDh7kM5DZ7O/3Cqa73PN/cmHsyC6oT7Sfj0Di//Tr917kvYfaxQD
gIHHZHbVKAXT/t8sTxEZMXDh6uOGI3QeBRnFRT1mDOwqmJJkEUP7F5zcdsqe
Xi/lV6hN511rOMFd5MjAPpVgdScx7d8B7pcaZwbqjz1cXVKYBbe2n5eQc2fg
GofPlz+W0/rrHF4s8qH1uaG6fVN7FnR/NDpZE8FAibBHPY7K2WCU+iR9STQD
pw4HKt9iZ8MVR6cm3kUGTg5UW7leKxtcHx9l70lgoELT3OW3IBs6iq40SmUw
8HBQ9qFtXtnQHDhBmFQw8FaHYfOCymyomVXWUD/MwJiGvd7+ATlAPjYZXjbK
QL0fQ7u8wnMg9NxzVtJvBqbmX1jvzMuBDb96/bwkmVgL+lNW5+VAWec81nQF
Js5Rr7PKas+BkpxjvuaaTBwwUFH8q5cLs3ZPEpZoM7E9McNS2zAXjiyIrV+g
y0SXtWVRppa5oB2byehfzcSX40U1i9xzIc/3RV20KRMtjVyv+sfkQrqBzsKm
3UzUqJtxTrIjF2q2yJz9vZeJb92eXN3+Phfe7+r+rOHFxPTVMYvDPucCFZZQ
Fu7DxOX7G/g247lgHO/DvnGUiV/VrlqPTKLvg8xNUd3+TLzcb9t+YLoYMuvG
dmAgE1Ns7/RWzxPD/dbmap/TTPzs3KGdzhLDh958DeEZJsrqRTRsWSQGVVnX
sbEIJuZRFsHTdMWQZV2TdP0SE3959FX9ZyaGOrdkifeXmfjbQKN98hYxfDrq
76WQzMSDxT/WDdiIQfqs1bMNIibO0zeSSN4uBrVLaqu905jYaLLAQMZFDKZZ
/1KTM5noaHdq+jo3MXjebJv6KIeJF9pdg7T2iiG7LapVrYCJs6i7xVYH6Xp9
e8C+mImTXy5PD/Sh642vzzlbykR9hsMlz6N0Pbm5M0tuMVHbKPKqvL8Y1Jnf
jr8tY6KfvN3mI8fFYKb9sGtGBROTdvo3x54UgxekmRpUM1FLMbPQI0AMkVsD
Cg7eZ2K1jMjsV6AYcnfbzhXUM7FXjTnFKFgMD321Tj98xEQd005Lk9Ni6D07
5dNIExOXmiVGSISIYVpCl9Wi50z0lpNm+tF4cfatG7YtTDzj+8k/hcZmt7jM
sFZarx2DI4E09nq4/3xRB61X+geZWTSObDf62vWGie6aJ+c70/uLPy+0l39H
6z/CvbCDrv/o93D5ug9MjJnv/Fs2SAyf5Z6oHuih81R1Rd+X5i/DyolJ+szE
QLfd02Po/pYsCx2u+8pEX6+UdTvo/s1xh8vP70ws2ryN3+4nhgPbdO9Tw3Te
joV8laP1i3KX1bL5xcRmZzWpIW8x5Pl9iA8dZ+IVH5Os6AN0/XP3fhf8ZWIk
q1P0ypOun5C4540EC0M6+8peuNP1cw4/lp3MwgBln/thrmLQvG22Yu1UFh40
9Qrv3iEGywYy2UuGhQ//tj7+aSeGQx3jkpflWeit6+p3x1oMV/9cbR6azcJV
rrsu2huLoVE+fC17HgtNelMPaW8QwxfWrvStC1i4t/Gi7x19MWgZzvK9RrAw
86Hk408aYrh2/tisfUtZqCiYdT6Tfg99Wb8z7PxyFhq6xmiiJL1+2HgoYwUL
PU50JPHG6PlzV3r5dg0Lm6YUFbr05EIuXE9yMmXh/YfB5fGVudA7Iph+ajML
8x5ohvwozQX1grCAy5YsXKN8VVomLxeyGTYuLTYsPD5J4q53fC5kjn1X2bKL
hUVh4/MV9uTCh6I27iF3Fkq/Q3c7B3pevaomRXuw0E1BkeW4mZ73V5zu+oP0
fqqx769o50Lqde0cw5MsHHx0l9w2kgMC70PaenEsfM08/GaQPq86VO1SbS+x
UH+F93DigRxQ7lyn4HuZhbk1Z6dPd8qBJHPZwQIhC9W07DycV+dAgnrejcV5
LMxa/svz1WA2cN/1rGfUsnDRGlH7HLdsiLDfYyH1k4XNo9N2XaeyIN2608Vj
lIVmdSswRD4Lyjfb+9T/ZuHvmeov1v7KhEGDTXHRkiqoNmX/z/BHmeCiptk6
W0EFjxkFxwqOZILur0F3VU0VTFoIBp/uZkBXUliAyW4VvOVY3q/imA5jvN/R
OXtVsM+xsui4UTooxfoLp3upYLRlvs5HrXTYfMazqslHBQUmRy/JS6ZD6X5z
aYcgFdRIrIzLupYGUWsVeZ6XVVBea+uGApk00OtME0c0qWCm9sp9TjWpoKDt
NVr4TAXN5644szk9Fb6EaG9qe6GCRc9siciwVMik7n5Y3KGCS5RSJo9sTAWl
gy0qjz6pYLdOsVTGIxGMB0lZSEsQ+ExWxuVGjxB6szx9BZMI9J0RmtLeKIRX
Txr42lIEXjw/lm9XIoQSgtvrIE3g245rLltPC+HAfUZ4jhyBLzyY0p4LhNAu
u6raTJnASJknz9buSYG6lfzezgUE/ttm6ttjlQKlO//MPMogkC1m3vi6OgW4
hTWufBUCeW1s66kKKWBma/2nbxGB73x6G31qkmFVUAl1Wp3Ahf9FvOstTAbV
rDkWihoENsrvzCgXJoPEr9f8tVoE2lhKqhwNSIbbAi/9aF0Cq9L3T5ZdnQzZ
tY9dVVYSyE0ItNi6OBkufdEOv65HYNNtF9+B+clwZMPPlterCTSRn3i78rcA
Fr8/46sFdD2bPxqfagUwV/YjvwoJ3B0i2jJwUwCTV5pV2xkRmDvePW6VJ4C3
52coBJsQ6EQsYM3mCSBJI/lakwWBhvOe3SrwEMDwkGnWWSsCXczdHRKcBGBd
MZiyxprAljMu599aC0Da1jwmy4bABTWUTsY6AbgzR8462xE4Z+mGP8q6Aqjo
SQuc5UBgpZvz8NBiARwLGjsQvIPATdKW357OE8Az0yz3Fc40H+fGBc9nCkBr
1janPhcCf7ZeaF4xTQAfsnI327vR/jruWcYY5wMesTOUdSdQqad59MoQH5LX
Sqyp3kPgnUK1y+e/8sHm6fbFS/cReDqaE3foPR8K+FJEtxeBB45q/PR+w4fp
ewvn8Q8Q6NWSatzUxoe92s4zrQ8R+HvXib8XWvhQNSo9dYoPgXmVK4UZz/jA
qC2ZKDtM4B+RS5pyEx9OxrqOHDlK4CmxX0R/Ax9atssMqPkRmBM10Ti/ng/L
2Dc/dvrT329d+PXKfT5Efdn9hnecwJlxZXZna/jw6ab8S7OTBEo43zpYWcUH
ozN3GidOEViR1M+3q+SDyMLjfmkggbErdTYZVfBhfM6s8gPBBBbNd38dcY8P
9m/LrxMhNP9ljhWqNC7K88p/FUrgL/ev2+fTWO6YUkZMGIHZ5h2K7jT2giqB
0Tl6P5vr7pPo/WqnH+KNnqfzu8Aw4SeNWS3zogoiCIyyj/thQPMJENWe2XuB
wJ7bxRXt1Xx45XX41IJoAp1HCzc+rOWD7oqFR5/FEDjtIb9+Wh0fLv6t8wq/
SKBCZ1Cc4CEf+up93dZzCbzU69kb9JgPxjyW42AcgbfSPGYXPuHT/y8eWefG
Eyi6G75jeTMf/qgd3+SaQOD+z62TJF7xwfEHCUqXCVz73tOW2cGH0rtNqx4l
Ebhiu2FCRBcfZoaf0g4VEMiYWjZjQzcf6hY8Z34REpi1eOPpGNp/9segOemp
dP483max6XwEFy6Wd0yj87uHEzVpjA8rjUP/1GbSesZnv0+YIgDuDK3hU9kE
tpc/O7NZTgD9ba39y3IJnJHI1TOaLYB072Wvk/MJ/GRqr/uPFMCE/uvmbdcI
zJzDyKnWEMAOyYhHUwtpvcP+RDzQEYDC5a47fiUEyl1P+xhrJICQqtgkizt0
ffUNilP2CeDzm6pLY2UEBl0qhQtHBODwe4ibU06gYHWSk3EAnf9VThekquh5
Cp0z2fmiANry1QLu1hGocv7Ly/7bAtC9XOms2UKg/GumZ9rcZBCWDm5vf0ng
UOSFV/JUMkxrXmQX0Upg6pRNpqJlyfCfXIxldweB2rlrXy/anAwxYY4Gye8I
XL0++b+84GT45P2DJfuNQL9rHrZ2/cmwLVp14Z3vBFr9e97jNJYM5bnb5+0b
JHAzw/OAz9QUiO++N7P2J4GDTR7Tb1IpgDuiJAL/EOguNbYpxSUFBMbU+8/T
Sfw7X/WFzZMUmOLu0JUkS6K6w5I1np0pcCTkQoepPInj0tunH/qcApvKvjWn
K5CYHV0oZyYthOFl5bVO80jssbMaUTAQgtVC+6xHqiTeXhXn5JglhKQP2lXO
aiQOT/v7ur9ICB+uTXv9RZ3ERXrqbOdyIQRhucJMTRIPzThjWN8shKseVJCt
DokxEXuMrv0Vwqj238QPuiTaBHR8HZkqAuPRV8XHVtK/j8gsn6UogtdRUT2X
9Uns/q3ELFkkApmiHzadBiRqb1mpHGouAodTj729gcSQK11ji21FkG6UFTmB
JLrvXFd22VkEa146VhDGJKYNPQyqPiiCcyLd9mITEi2eLm8/5SeCZ/vkho02
kYj1/b8GA0TgNV6p4WFO4pG8KfLUBRGU1vKNRyzo+h/uPG7liEAi1m9XhBWJ
Ch0H35gliiBJRT1BvJVEqXi/KOd0Ef3+lyhaa0Pi5GzWwHiOCJaXdDx6bEvi
ckVfPZtrIqg3vigx4EDi8Uvl/6hbIlCc4bUwxJHER2PTLFLuisC11XCVghOJ
ipdypR9WiiDvysJtac4kpkq6b8iuFcHI/p8HdXeSWHC6XmtVvQiMVjwNr3Wl
+/2uIX+Cvn8v/slNs3Mj8T/oWODVJIKOB2HlH3eTaGqvETftmQjUOC6tx/eQ
WD7fK397swh8HVcNTvUgcbdvT6ZdiwgqSAV5vieJTuajtyde0nr396kv8SKx
IbKfbd8qAvvSWqO7+0l8PkeRtb1NBFeChTstD5J4qb38o1S7CL6Ynjj55hCJ
+uXrbzjReLXCtngfH7p/k2dZ/8fn2pcU/DtM4uFZZtH/X/8sfXID9yiJjLG3
bXb0foxDXd2kH91fmOTULXQ9L73bEyX+dH2CTBmg+VyfiFM2Pk5ih2Po0lU0
34n6gytfniDxg3bsVlW6H/M4E2vPUyT2ZpcKbj8VQaKTyoFfASRugcGswUYR
vKfGzkUGkTglc7dGc4MItL82pyqfJvHdkQs9DnUiCLh5tSwvhMTApJH00BoR
1IWEv1x3hkRv+VUs6wrar81u3xvDSHT8uU6l5g7tl+JaWddztF7PrCLaS2m/
Xs9W+3aexG0lz40TCkVg6FPvPOsCidddGAFjGfT7qK3P9H4UiaUNGZVKQjpf
G+V0T8SQKDJdrnw/gfZHedu0NxySfk+/SfjvvAjenvUb4sSRuD7qwz+LYBHw
BxK6jOJJjC0LULbyF4Hc/Y7S3EQSP/al3Z2xm+ar/TfVOYmeX4Nrf586iCCE
rxI9Q0CiiWabhbqlCAZ99u72F9J+3AmYz9cTQZvygDxmkmippLFVJCUC3jmF
scEsEpmXoo4SI0Kw+Kb7ISuHRPtL82Q39Aqh4v6JMtl8EhNqrpZteSyEzMOT
9rUW0/5d0vHqjBGCawdlE3WdRDAkLm4LEsI8E1MDgxv0/Gjvrt5/UAhRC6Jn
Z9ym/ZrtJBtpJoQjD5SqfCrp/vas8BNOpMCS5fr5ZDWJ30a9Sy37U6BbsCOx
pYZEHeaxJeLWFHA4Ijq0to5Eou9wxOHCFFi/cLGydBOJLUomH5ycU2Da0XW+
wg4SMx5tnpDJToZUhrtq408SS6KC/6tSFMDaFZra7r/o/H3dvGMS/X5p2Tys
PzpKot6Z6W8Xv+PDtBPhFqp/SKyp2D2qW8iHI8/zfIMk2WggYxjkYk6/d8KH
qrRmstHwx7Y/JqeT4P23cztjF7NRKXD8jtSnRAiS3rKPWsLGcyZnP7Y1JsJc
5ryjdzTZqGW0VVB5PRHMzcXnPmqzcf9v2xV1ZxKhJLMp30CPjZfjv6a+YiXC
2R1zx78asvFORAa+3ZkAqrU5iVuc2Vgjn8q+8jMenmiNZna6sFFBNKD+5m08
nEw0u37AlY3aKWbRxo3x8Hh/39Pw3WycfNHZ8lJGPPgqaE6v3MfG6wGmtcZ2
8VC5syBwmT8bEzxe/zSr4IFX/cSFe8fY+Kb/S9muqzxQ1LFOsjjBxg8D/QY5
Ah54Tv5eui+Ajdg48KDhBA/k8nUGUkPZKMWasnjPSh44jZa6KcSyMexsjsLc
W3Ew2X3KYdFFNpqtbx2xzY2Dgsf2wVpcNh6e9/TWA34cTEod4ZvFszEmaIOe
SXAc5JqsfhHKZ+O7qdozb5nGgU1h5LsZyWy8Us7IT1wTB7/nt39LSWFjo5TM
8zytONjy5ZTcnVQ2nvii13Rkdhz85N01+ZFF6y1cMtW/mwuiP7J2ITlsjLPy
8htt5YKZp4u7vJiNAo+ouOJGLqSs+Xta4yobv6tY1Fff5ILR2w23d5ew0eNp
da5jLBe+bObUfbvORs3oad5nznIh8fp/LcE3aH3clod1neJCX3joD/5tNi5p
bziot48L3KU1S5or2Cg6+kjVzpgLuaudp4dV0f5xF2p6r+NC5cbhHp0aNt4w
Vxus0eXCwA61rLgHbJQvWaGvyubCFI/Ks4b1bGz5nnx42QIuMI44uv94yEaT
r5FvjitywSI8SmVbIxvTFt+ruiPFBfc4akLiCRsnBWdc2T/GgYCU8s6ip2x8
phN5/VU/B3JLBvgKL9h4YOVpplIzB6T/s1F61s7GrpjBtwqZHGB+7h8Mec3G
r9+bgq7zObDy57nny96wMXyrXVcDhwN7ZG9d5LxlY9uBDUPWwfT+c7d6w3s2
Vl/8j1PhzwEe2WfxrZuNL4Vr20WHOFClv3C6dQ+dr1nDtiU7OdBmVNoz0cvG
UDQ4/sGBA9+srOoKPrMxeWCOevhWms+OT5muX9g49cxQV6I5B1h7Q87OGGDj
AxeLuXNNOKB3eL57xTc6f594JlLIAcuAYvT5wcbjn3vf7FzHgb3nzVVYQ2wc
s3Vas0ifA4Hc7r9Nw2zMd9xR5LiC5pcc1Bk8wsZR1/3Jv5ZxIC97zt2lo2w0
b5K3nbSUA9XFBfw3Y2ycK/No2bElNN/yTSdjf7OxLpCMslnMge/1bx0M/rLx
YeTlsiQ1Dkx9cUrv6wSd18uFypsW0Xy7FJWEEhSGzvj6z0WVA6v68gctJSmc
ZffiQTvFAath4+d/pCj8VXywqpzGe/+9Kbw6hcLUsZVLp9Drg2ROXHSZSqGc
y2zDEhrHz1HwlptO4f25E8tr6f3zCLFFuQyFVvu+6Oirc6BG02jJITkKl0W/
PCmvwYH2Va+nMWZQOFBZtNZEk+Zr6N/zeCZdf+Oxq2/o/qZZydcFzqKQtFkg
9Wo5B1QcszM1Z9P1l1z2W7qS5rsHzr5WolBJplu3m9Zvi0/b7ui5FE69xfEf
ofX1OHUU182nMNrtn70nrX/QORmVfmUK30UOvdeh/ckXrO80Z1L4+EekVps1
zS/rZdk4i8INEmX/iuw50FHkw88jKLTQ4OS/c6b51F9xkFGl8JOnSZnpfg4Q
zWv0yhZRuGvzzRWnjnBA/03z7APqFGq//1zy7wQHPIcmP29YQmH9toBPkyM5
4Jpn/MRFi8Kn97KufaXz6bD73ONvSyl0Nj/xe2ESB0yfStXN0aGwWFJ5n4mY
A2r5knd361O448pVdvET2i93o9vDqyk8XuVam9/GgbnKYTci1lJ4Nuip+4f3
dB4jJhVdM6CQ90C3Q3aUAx/dJbLGNlI4Z+NoTDQ9f53KmB5jQqH7J26673wu
tDwLSVXZRKHJkjE/fxYX7m/4xzcxp5AVck+qbgkXMhdMXIzbSmFK460+Ln0e
7G3+fVJjJ4VfF75sxCAuuFxYd7zclcIH2ms4MfT5YoeBftZuFJZrFKj2RXHB
uGDc+9geCrPIK8rNfC6oRo25V++n8Pau5Zu23uZCt+Evyx3HKTx1IDjP8Rd9
HhQPEhc4FJ4psBpTORkHh8Js/5jHUahHzGv4ExoHx2xLW+XiKfQSTig8vRAH
kT+PXeQmUsivlCesk+nzec3Y78tCCjXw5qDgXhzclnFq3ZFKIbStWTGpLg6q
X5eVLEyj8HLUchXbJ3HQEhy0PzWTwsWnCmff6IqDsep/r7LzKayQLfq0ZSIO
JOPdSryuUdge7aP1fQp9X+ytjl1SSOHGlcVufvI8YEmfNS4ooXBt/8NHCxg8
MDaXLrlxh8I2n4Mqjfo82LJwX+yJuxRemFiGzht4sP1LvdeaexQOGkwV1Rjz
4MDFCyr3qig8xK/onrONB9xmudj79RT+dLu/v3gfDwQZ3l7hDRTGyuXix0M8
yPB/stHsMYXSCTV/e4/y4OZc7vjjJxSmaUf+cw7kQVXP95exz2g/Vou1G0J4
0HB7W7F1M4UPZ32dL3mOB51Os71evKQQvYeHmqN58EnTf2NCK4WS7t2fvDg8
+PanhbW9nUL/j/oP6ng8GG3SG5//msIfO10b+xN4IJma+LKjk8JXOrVrWpN4
IHvkV1FKF4WB9c3mkck8UDJ0jHF9S+H682PrJ4S0Pop39hHv6bw+z7BafYUH
6t3KG9930+eN4oYyvXQeLC8NYGV+pPNQsLLqZwYP1p5/PebRQ+FJueGUE1k8
2Oiw/qV6H4XKvN7YsmweWKoLi/o+U5itffDZvRweOIz+jc7/QmHc8VO5obk8
2NXgus97gJ4Hrk6SpJh+DwgqjZZ9p3B7V6PeRhr7HiRYP35Q2Fd9bp4RjYPW
nxkrGaJwrpD3YoL+/rz8+xb/nzSf58skTtH4YpdR0apfFF6tTlhRRNdLKsyI
Hh2lsPHJX6lMmk966OR9ZeMUjjilTbWj+eZv8zAK+kPh5Id3WirpfkrZdcwN
ExS2nAid1JPGg4ohtbF//+jzpVFbtSGVB/8Dy0LZBw==
        "]]},
      Annotation[#, "Charting`Private`Tag$8811#1"]& ]}, {}, {}}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], Opacity[
      0.8], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQjQo+2M+aCQI37f/vPvJjddkTKP+l/eq53sn58x7Y
mxiDwGf7laU8JZP7H0Plf9rvW3nu9Owlt+yhBjkY7Hka47/rsj1YuTGzg4Fv
Xt7uruv2aWDA5rA75sx1m6SL9mDtMzkdzpy9cz9293H7M2DA43Dt0q8fJ7+c
tv8PBvwOuzZc//Zw0TGoekGH4s988Sv/74GaL+zgG5Cj/SjvgP1ZsH4RB7GO
H8uOee61TwfbJ+agE8L2j415kz0j2HkSDvKHUth9jTfbzwabJ+lwyfjktqCD
m+xNweZJO/wRyMv6vWuZ/XmweTIOG/KNWBuSltlngs2Tc5h8bvK+js3LoeYp
OLgJWHEpi8y1PwdWr+Dw1FlO4rfKLKj5ig6fGVvav9XMtc8A61dyYJ/Gq/Dr
9CSofcoODGbzt83d1mcPiRMVB4Pr0RnW3JPsAf3Gt0A=
       "]]}, {}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& }, {{{0., 
       Directive[
        AbsoluteThickness[0.1]]}, {2., 
       Directive[
        AbsoluteThickness[0.1]]}, {4., 
       Directive[
        AbsoluteThickness[0.1]]}, {6., 
       Directive[
        AbsoluteThickness[0.1]]}, {8., 
       Directive[
        AbsoluteThickness[0.1]]}, {10., 
       Directive[
        AbsoluteThickness[0.1]]}, {-2., 
       Directive[
        AbsoluteThickness[0.1]]}, {-1.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {-1., 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {1., 
       Directive[
        AbsoluteThickness[0.1]]}, {1.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {2.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {3., 
       Directive[
        AbsoluteThickness[0.1]]}, {3.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {4.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {5., 
       Directive[
        AbsoluteThickness[0.1]]}, {5.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {6.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {7., 
       Directive[
        AbsoluteThickness[0.1]]}, {7.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {8.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {9., 
       Directive[
        AbsoluteThickness[0.1]]}, {9.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {10.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {11., 
       Directive[
        AbsoluteThickness[0.1]]}, {11.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {12., 
       Directive[
        AbsoluteThickness[0.1]]}}, {{0., 
       Directive[
        AbsoluteThickness[0.1]]}, {0.2, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.4, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.6, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.8, 
       Directive[
        AbsoluteThickness[0.1]]}, {1., 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.2, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.25, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.3, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.35, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.45, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.5, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.55, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.65, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.7, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.75, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.85, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.9, 
       Directive[
        AbsoluteThickness[0.1]]}, {0.95, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.05, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.1, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.15, 
       Directive[
        AbsoluteThickness[0.1]]}, {1.2, 
       Directive[
        AbsoluteThickness[0.1]]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.877597894948022*^9, 3.8775979394957714`*^9}, {
  3.87759805346801*^9, 3.877598062826782*^9}},
 CellLabel->
  "Out[131]=",ExpressionUUID->"42ee078d-35ae-4579-8cc5-0da64f62f0b7"]
}, Open  ]]
},
WindowSize->{1117, 927},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2. Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 408, 10, 136, "Input",ExpressionUUID->"317fbb22-4b1b-4dae-92cb-99a192784aa9"],
Cell[CellGroupData[{
Cell[991, 34, 3975, 112, 810, "Input",ExpressionUUID->"b4affade-f01e-48d0-97f3-b0bbbe8e50ee"],
Cell[4969, 148, 38108, 705, 508, "Output",ExpressionUUID->"bb34b344-2f8a-4bd2-aca9-348b3e61f6da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43114, 858, 3159, 86, 791, "Input",ExpressionUUID->"dabb27e7-d048-4de2-9485-2d88ddb5fe47"],
Cell[46276, 946, 36813, 684, 508, "Output",ExpressionUUID->"42ee078d-35ae-4579-8cc5-0da64f62f0b7"]
}, Open  ]]
}
]
*)

