(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     55672,       1087]
NotebookOptionsPosition[     54908,       1065]
NotebookOutlinePosition[     55356,       1082]
CellTagsIndexPosition[     55313,       1079]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t0", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"0.1", "*", 
           RowBox[{
            RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"3", 
           RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", 
         RowBox[{"Sin", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", "t0", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "t0", "]"}], "\[Equal]", "1"}]}], "}"}], 
      ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"x2", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], "-", 
         RowBox[{"0.1", 
          RowBox[{"x2", "[", "t", "]"}]}], "-", 
         RowBox[{"3", 
          RowBox[{"x1", "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"x1", "[", "t0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"pl1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "/.", "sol1"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x1", "[", "t", "]"}], "/.", "sol2"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.877598725317706*^9, 3.8775989449640846`*^9}, {
  3.877599309537251*^9, 3.8775993105715084`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"317fbb22-4b1b-4dae-92cb-99a192784aa9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVmXk4VV8Xx83zPFwy3ctVSlJKioa9ShRJJVEylExJKg0kyZAilCSKNBJN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         "]]},
       Annotation[#, "Charting`Private`Tag$17138#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0., 10}, {-0.4258175866094126, 0.6884635596273783}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVmXk8VN8bx0V22Q0KM4xSkVKi/Two0iKKVskWylKJFlGWorIkKSKRLfFt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         "]]},
       Annotation[#, "Charting`Private`Tag$17182#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0., 10}, {-0.4258175866094125, 0.6884628531532897}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8775988298519926`*^9, 3.877598835299276*^9}, 
   3.877598910059883*^9, 3.8775989458289537`*^9, 3.8775993115054398`*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"d3095a8c-6c3a-41a1-af98-b709af928659"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"derivative", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", 
        RowBox[{"{", 
         RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "-", 
        RowBox[{"0.1", "x2"}], "-", 
        RowBox[{"3", "x1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startPoint", "=", 
     RowBox[{"{", 
      RowBox[{"t0", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "1."}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nPoints", "=", "25"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     FractionBox[
      RowBox[{"tmax", "-", "t0"}], "nPoints"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stepRunge", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"k1", "=", 
         RowBox[{"derivative", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivative", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivative", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivative", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solRunge", "=", 
     RowBox[{"NestList", "[", 
      RowBox[{"stepRunge", ",", "startPoint", ",", "nPoints"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plRunge", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"solRunge", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t_", ",", 
           RowBox[{"{", 
            RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"t", ",", "x1"}], "}"}]}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
          RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "plRunge"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.8775985204496803`*^9, {3.8775990185470915`*^9, 3.877599327190027*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"1b819389-aa16-46bf-878c-b2ab86c09ad2"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVmXk4VV8Xx83zPFwy3ctVSlJKioa9ShRJJVEylExJKg0kyZAilCSKNBJN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        "]]},
      Annotation[#, "Charting`Private`Tag$17138#1"]& ]}, {}, {}}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], Opacity[
      0.8], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQjQ5mzQSBm/a2Ly7eDzx03R7Cf2n/askBqZyTj+1N
jEHgs/0qPo9pVvefQuV/2nc8tjPoLHxkDzXGYd7cT9qqWtftwcqNmR32KR8J
vBF6wD4NDNgcAoTi3rnordkP1j6T06GtoFPrEtOR/WfAgMdBuu4Hs9DME/v/
gwG/Q/KOKMOFkaeg6gUdVHJ5s693nNsPMV/Y4bQvr8jt7Mv7z4L1iziwPG/c
vk7ixv50sH1iDs8+Fifwid/azwh2noRDnFSjSZP5tf2zweZJOhR8UvnXZnts
vynYPGkHlcQ/0+Yt32Z/HmyejEPyOjOrX6+v22eCzZNzuHPkQbSd1GN7iHkK
DrPqgjnNPz61PwdWr+AQlPDCbV/FY3uI+YoOkywmGe3cf8M+A6xfyYGHSegY
D8s2e4h9yg5ejGzWZttO7YfEiYqDa+LNuPeyt/cDAB44tA8=
       "]]}, {}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 10}, {-0.4258175866094126, 0.6884635596273783}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8775993280549164`*^9},
 CellLabel->
  "Out[217]=",ExpressionUUID->"07a7d833-16c5-49f8-b6f3-6c0fe8a7a708"]
}, Open  ]]
},
WindowSize->{1117, 927},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2. Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2911, 88, 551, "Input",ExpressionUUID->"317fbb22-4b1b-4dae-92cb-99a192784aa9"],
Cell[3494, 112, 31186, 546, 258, "Output",ExpressionUUID->"d3095a8c-6c3a-41a1-af98-b709af928659"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34717, 663, 4010, 113, 908, "Input",ExpressionUUID->"1b819389-aa16-46bf-878c-b2ab86c09ad2"],
Cell[38730, 778, 16162, 284, 518, "Output",ExpressionUUID->"07a7d833-16c5-49f8-b6f3-6c0fe8a7a708"]
}, Open  ]]
}
]
*)

