(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     37525,        735]
NotebookOptionsPosition[     37038,        715]
NotebookOutlinePosition[     37502,        733]
CellTagsIndexPosition[     37459,        730]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"derivace", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "y"}], "+", 
     RowBox[{"Sin", "[", "t", "]"}]}], 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocStav", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tStart", ",", "y0"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{"0.", ",", "1"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"odeProNDSolve", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"derivace", "[", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"y", "[", "t", "]"}]}], "}"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "y0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solNDS", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"odeProNDSolve", ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plNDS", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "solNDS"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nKroku", "=", 
   StyleBox["10",
    FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox[
    RowBox[{"tmax", "-", "tStart"}], 
    RowBox[{"nKroku", "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krokEuler", "[", 
    RowBox[{"stav", ":", 
     RowBox[{"{", 
      RowBox[{"t_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
     RowBox[{"y", "+", 
      RowBox[{"\[CapitalDelta]t", "*", 
       RowBox[{"derivace", "[", "stav", "]"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solEuler", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krokEuler", ",", "pocStav", ",", "nKroku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plEuler", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"solEuler", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RungeKuttaKrok", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k1", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k2", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k3", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k4", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          FractionBox["\[CapitalDelta]t", "6"], "*", 
          RowBox[{"(", 
           RowBox[{"k1", "+", 
            RowBox[{"2", "k2"}], "+", 
            RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solRunge", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"RungeKuttaKrok", ",", "pocStav", ",", "nKroku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plRunge", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"solRunge", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Magenta", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNDS", ",", "plRunge"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plNDS", ",", "plEuler"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.84733596634375*^9, 3.8473361351875*^9}, {
   3.847336171265625*^9, 3.8473362738125*^9}, {3.847336316578125*^9, 
   3.847336439875*^9}, {3.847336481453125*^9, 3.847336560953125*^9}, 
   3.847337383828125*^9, {3.84733750409375*^9, 3.847337554046875*^9}},
 ExpressionUUID -> "915dbe51-8755-4013-bc78-ce5a3c1f9ac3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0], Thickness[0.006], LineBox[CompressedData["
1:eJwV2Hc81G8cAHDO+CUjqawz7pwoSrRoPh8qSUopoqSMUlYpMypCkS0rJSIR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      "]]}}, 
   {RGBColor[1, 0, 1], PointSize[0.015], 
    PointBox[{{0., 1.}, {1.1111111111111112`, 0.7217063322055064}, {
     2.2222222222222223`, 0.7823526058958999}, {3.3333333333333335`, 
     0.7335155758863608}, {4.444444444444445, 0.6422105470241557}, {
     5.555555555555555, 0.5761372847429276}, {6.666666666666666, 
     0.554060914583877}, {7.777777777777777, 0.5581672838372704}, {
     8.888888888888888, 0.5627936164742564}, {9.999999999999998, 
     0.5558893498319837}, {11.111111111111109`, 0.5420082709782509}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0.6},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.84733752415625*^9, 3.84733755459375*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0], Thickness[0.006], LineBox[CompressedData["
1:eJwV2Hc81G8cAHDO+CUjqawz7pwoSrRoPh8qSUopoqSMUlYpMypCkS0rJSIR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      "]]}}, 
   {RGBColor[1, 0, 0], PointSize[0.01], 
    PointBox[{{0., 1.}, {1.1111111111111112`, -0.11111111111111116`}, {
     2.2222222222222223`, 0.38975793912477874`}, {3.3333333333333335`, 
     0.46562403187081686`}, {4.444444444444445, 0.4054229314353763}, {
     5.555555555555555, 0.33208765222492187`}, {6.666666666666666, 
     0.2973154611949579}, {7.777777777777777, 0.29919408636308165`}, {
     8.888888888888888, 0.31180427355687235`}, {9.999999999999998, 
     0.3145649781460665}, {11.111111111111109`, 0.30511958662752486`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0.6},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.84733752415625*^9, 3.847337554609375*^9}}]
}, Open  ]]
},
WindowSize->{1161, 571},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->1.9000002145767212`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 6263, 182, 1161, "Input"],
Cell[6845, 206, 15079, 252, 484, "Output"],
Cell[21927, 460, 15095, 252, 484, "Output"]
}, Open  ]]
}
]
*)

