(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    192936,       4208]
NotebookOptionsPosition[    188365,       4124]
NotebookOutlinePosition[    188825,       4141]
CellTagsIndexPosition[    188782,       4138]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", 
   RowBox[{"vstupem", " ", "bude", " ", 
    RowBox[{"(", 
     RowBox[{"pro", " ", "kazdy", " ", "kanal"}], ")"}], " ", "zadany", " ", 
    "prenos", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"viz", " ", "prilozena", " ", "pdf"}], ",", " ", 
      RowBox[{"pouzivam", " ", "symbolickou", " ", "promennou", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"nekde", " ", "je", " ", "obvykle", " ", "s"}], ")"}]}]}], 
     ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "metodu", " ", "ukazu", " ", "na", " ", "vygenerovanem", " ", "prenosu"}],
     ",", " ", 
    RowBox[{"aby", " ", "byla", " ", "hezka", " ", "cisla"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"delam", " ", "to", " ", "proto"}], ",", " ", 
    RowBox[{
    "ze", " ", "v", " ", "elektronice", " ", "muzu", " ", "na", " ", 
     "pocatku", " ", "uvazovat", " ", "nulove", " ", "pocatecni", " ", 
     "hodnoty", " ", "a", " ", "pak", " ", "je", " ", "u", " ", "linearniho", 
     " ", "obvodu", " ", "popis", " ", "s", " ", "jednim", " ", "prenosem", 
     " ", "zcela", " ", "postacujici", " ", 
     RowBox[{"(", 
      RowBox[{
      "jinak", " ", "jsou", " ", "treba", " ", "jeste", " ", "prenosy", " ", 
       "pocatecnich", " ", "podminek"}], ")"}], " ", "a", " ", "hlavne", " ", 
     "ze", " ", "schematu", " ", "se", " ", "prenos", " ", "udela", " ", 
     "velmi", " ", "snadno"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "CAO", " ", "jsme", " ", "to", " ", "delali", " ", "pro", " ", 
    "HUS", " ", "ale", " ", "jinak", " ", "zcela", " ", "shodne", " ", 
    "pokud", " ", "zamenime", " ", "p", " ", "za", " ", "I", "*", 
    "\[Omega]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prenos", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "#"], "*", 
         RowBox[{"Prime", "[", "#", "]"}]}], "&"}], "/@", "rn"}], "]"}], "+", 
     "1"}], 
    RowBox[{"Total", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["p", "#"], "*", 
        RowBox[{"Prime", "[", 
         RowBox[{"#", "+", "n"}], "]"}]}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"rn0", "=", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "n"}], "]"}]}], ")"}]}], "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<prenos= \>\"", ",", "prenos"}], "]"}]}], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858225997797*^9}, {3.833858306310238*^9, 3.8338583210202255`*^9}, {
   3.8338583687945166`*^9, 3.833858407220055*^9}, {3.833858593834984*^9, 
   3.8338586069467363`*^9}, {3.8338586570117617`*^9, 3.833858691973414*^9}, {
   3.8338587352364635`*^9, 
   3.833858890516265*^9}},ExpressionUUID->"5fa707fc-d7d8-4d2b-8f11-\
060f7a8725d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"prenos= \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "p"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["p", "3"]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["p", "4"]}]}], 
    RowBox[{"7", "+", 
     RowBox[{"11", " ", "p"}], "+", 
     RowBox[{"13", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"17", " ", 
      SuperscriptBox["p", "3"]}], "+", 
     RowBox[{"19", " ", 
      SuperscriptBox["p", "4"]}]}]]}],
  SequenceForm[
  "prenos= ", (1 + 2 $CellContext`p + 3 $CellContext`p^2 + 5 $CellContext`p^3 + 
    7 $CellContext`p^4)/(7 + 11 $CellContext`p + 13 $CellContext`p^2 + 
   17 $CellContext`p^3 + 19 $CellContext`p^4)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.847339546765625*^9, {3.8473430164952955`*^9, 
   3.8473430438431983`*^9}},ExpressionUUID->"0c5a5c9e-eab9-4a78-b168-\
ea632f85f313"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "ale", " ", "pro", " ", "pochopeni", " ", "staci", " ", "ze", " ", 
     "odpovidajici", " ", "diferencialni", " ", "rovnice", " ", "vypada", " ",
      "nasledovne"}], ",", " ", 
    RowBox[{
    "y", " ", "je", " ", "neznama", " ", "funkce", " ", "a", " ", "u", " ", 
     "je", " ", "vstup", " ", 
     RowBox[{"(", 
      RowBox[{
      "v", " ", "nasem", " ", "pripade", " ", "vstupni", " ", "signal"}], 
      ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "uloha", " ", "je", " ", "tedy", " ", "resit", " ", "numericky", " ", 
    "takovouhle", " ", "rovnici", " ", "s", " ", "minimalnim", " ", 
    "zpozdenim", " ", 
    RowBox[{"(", 
     RowBox[{
     "jasne", " ", "pro", " ", "tri", " ", "kanaly", " ", "resit", " ", 
      "takove", " ", "tri", " ", "rovnice"}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numP", "=", 
     RowBox[{"Numerator", "[", "prenos", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"denomP", "=", 
     RowBox[{"Denominator", "[", "prenos", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lhs", "=", 
     RowBox[{"denomP", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"y", "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "i"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"p", "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"absClen_", "?", "NumericQ"}], "\[RuleDelayed]", 
         RowBox[{"absClen", "*", 
          RowBox[{"y", "[", "t", "]"}]}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs", "=", 
     RowBox[{"numP", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "i"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"p", "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"u", "'"}], "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"absClen_", "?", "NumericQ"}], "\[RuleDelayed]", 
         RowBox[{"absClen", "*", 
          RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<ekvivalentni dif. rovnice=\>\"", ",", 
       RowBox[{"lhs", "\[Equal]", "rhs"}]}], "]"}], ";"}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.8338589676660886`*^9, 3.8338590008889065`*^9}, {
  3.833859421091323*^9, 3.8338594246493764`*^9}, {3.8338594711233573`*^9, 
  3.8338597434346123`*^9}, {3.833859782573615*^9, 3.8338598885158525`*^9}, {
  3.83385995939616*^9, 3.833859994007367*^9}, {3.84733960203125*^9, 
  3.847339619*^9}},ExpressionUUID->"35ec799e-394c-4f76-ba51-f2d125ac3fb6"],

Cell[CellGroupData[{

Cell[BoxData["lhs"], "Input",
 CellChangeTimes->{{3.8473430524865046`*^9, 
  3.8473430533357687`*^9}},ExpressionUUID->"ce328250-3f5e-4caf-8983-\
0c3f1640fc9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"7", " ", 
   RowBox[{"y", "[", "t", "]"}]}], "+", 
  RowBox[{"11", " ", 
   RowBox[{"y", "[", "t", "]"}], " ", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "+", 
  RowBox[{"13", " ", 
   RowBox[{"y", "[", "t", "]"}], " ", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "+", 
  RowBox[{"17", " ", 
   RowBox[{"y", "[", "t", "]"}], " ", 
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "t", "]"}]}], "+", 
  RowBox[{"19", " ", 
   RowBox[{"y", "[", "t", "]"}], " ", 
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "t", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.847343054107145*^9},ExpressionUUID->"da9a5c10-baaf-4f1c-9d77-\
071b2a844ec7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "difoska", " ", "ale", " ", "obsahuje", " ", "derivace", " ", "vstupu", 
     " ", "a", " ", "neni", " ", "pouzitelne"}], ",", " ", 
    RowBox[{
    "numericka", " ", "ctvrta", " ", "derivace", " ", "neni", " ", "ve", " ", 
     "svete", " ", "realnych", " ", "signalu", " ", "dostupna"}], ",", " ", 
    RowBox[{
     RowBox[{"resp", ".", " ", "chyba"}], " ", "je", " ", "prilis", " ", 
     "velika"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "difosku", " ", "potrebujeme", " ", "prevest", " ", "na", " ", "soustavu",
      " ", "difosek", " ", "prvniho", " ", "radu", " ", "a", " ", "takzvanou",
      " ", "vystupni", " ", "rovnici"}], ",", " ", 
    RowBox[{
    "nikde", " ", "se", " ", "nesmi", " ", "vyskytovat", " ", "derivace", " ",
      "vstupu"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"uvazujeme", " ", "vektor", " ", 
    RowBox[{"tzv", ".", " ", "stavovych"}], " ", "promennych"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"xvect", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "#", "]"}], "&"}], "/@", "rn"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<vektor stavovych promennych je: \>\"", ",", "xvect"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 
   3.833860756445854*^9}},ExpressionUUID->"1c06ef61-64b5-4623-ac17-\
c5a0254cc5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vektor stavovych promennych je: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], ",", 
     RowBox[{"x", "[", "2", "]"}], ",", 
     RowBox[{"x", "[", "3", "]"}], ",", 
     RowBox[{"x", "[", "4", "]"}]}], "}"}]}],
  SequenceForm["vektor stavovych promennych je: ", {
    $CellContext`x[1], 
    $CellContext`x[2], 
    $CellContext`x[3], 
    $CellContext`x[4]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8473430167114077`*^9},ExpressionUUID->"ee36e6f2-14db-459c-b144-\
51d9f0902d84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "uvazujeme", " ", "stavove", " ", "rovnice", " ", "ve", " ", "tvaru", " ", 
    RowBox[{"(", 
     RowBox[{
     "nasobeni", " ", "promennou", " ", "p", " ", "znamena", " ", 
      "derivaci"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"rceStavi", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "*", 
        RowBox[{"x", "[", "i", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{"x", "[", 
         RowBox[{"i", "+", "1"}], "]"}], "+", 
        RowBox[{
         RowBox[{"b", "[", "i", "]"}], "*", "u"}]}]}], "/;", 
      RowBox[{"i", "<", "n"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceStavi", "[", "n", "]"}], ":=", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"x", "[", "n", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "[", "j", "]"}], "*", 
          RowBox[{"x", "[", "j", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}], "+", 
       RowBox[{
        RowBox[{"b", "[", "n", "]"}], "*", "u"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"stavoveRce", "=", 
    RowBox[{"rceStavi", "/@", "rn"}]}]}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.833860814354146*^9}},ExpressionUUID->"4cd105d5-6cbd-4daa-908b-\
9d6a1444a731"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", 
     RowBox[{"x", "[", "1", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"b", "[", "1", "]"}]}], "+", 
     RowBox[{"x", "[", "2", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"p", " ", 
     RowBox[{"x", "[", "2", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"b", "[", "2", "]"}]}], "+", 
     RowBox[{"x", "[", "3", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"p", " ", 
     RowBox[{"x", "[", "3", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"b", "[", "3", "]"}]}], "+", 
     RowBox[{"x", "[", "4", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"p", " ", 
     RowBox[{"x", "[", "4", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"b", "[", "4", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a", "[", "3", "]"}], " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a", "[", "4", "]"}], " ", 
      RowBox[{"x", "[", "4", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847343020760335*^9},ExpressionUUID->"a856e7f2-fd15-42e1-b09f-\
93df0e0fcf10"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vystupni", " ", "rovnici"}], ",", " ", 
    RowBox[{
    "ktera", " ", "ze", " ", "stavovych", " ", "promennych", " ", "udela", 
     " ", "vystup"}], ",", " ", 
    RowBox[{"predpokladame", " ", "ve", " ", "tvaru"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"vystup", "=", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "j", "]"}], "*", 
         RowBox[{"x", "[", "j", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "n"}], "}"}]}], "]"}], "+", 
      RowBox[{"\[Lambda]", "*", "u"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<vystup= \>\"", ",", "vystup"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.8338608956157074`*^9}},ExpressionUUID->"312f7090-f9f5-45a8-85d2-\
a2f7bbe40abd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vystup= \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"u", " ", "\[Lambda]"}], "+", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], " ", 
     RowBox[{"x", "[", "1", "]"}]}], "+", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], " ", 
     RowBox[{"x", "[", "2", "]"}]}], "+", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], " ", 
     RowBox[{"x", "[", "3", "]"}]}], "+", 
    RowBox[{
     RowBox[{"a", "[", "4", "]"}], " ", 
     RowBox[{"x", "[", "4", "]"}]}]}]}],
  SequenceForm[
  "vystup= ", $CellContext`u $CellContext`\[Lambda] + $CellContext`a[
     1] $CellContext`x[1] + $CellContext`a[2] $CellContext`x[
     2] + $CellContext`a[3] $CellContext`x[3] + $CellContext`a[
     4] $CellContext`x[4]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.847343020844914*^9},ExpressionUUID->"b9577227-bf20-4145-8629-\
afe43e970aa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dale", " ", "jedna", " ", "metoda"}], ",", " ", 
    RowBox[{"jak", " ", "nalezt", " ", "koeficienty", " ", "\[Lambda]"}], ",",
     " ", 
    RowBox[{
     RowBox[{"a", "[", "i", "]"}], " ", "a", " ", 
     RowBox[{"b", "[", "i", "]"}], " ", "tak"}], ",", " ", 
    RowBox[{
    "aby", " ", "soustave", " ", "s", " ", "vystupni", " ", "rovnici", " ", 
     "byla", " ", "ekvivalentni", " ", "puvodni", " ", "diferencialni", " ", 
     "rovnici", " ", "definovane", " ", "prenosem"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vyresime", " ", "stavove", " ", "promenne", " ", 
     RowBox[{"x", "[", "i", "]"}]}], ",", " ", 
    RowBox[{
    "dosadime", " ", "do", " ", "vystupni", " ", "rovnice", " ", "a", " ", 
     "ziskame", " ", "prenos"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{"stavoveRce", ",", "xvect"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"prenosKutta", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Together", "[", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{"vystup", "/.", "sol"}], "]"}], "/.", 
         RowBox[{"u", "\[Rule]", "1"}]}], "]"}], "//", "Simplify"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<prenos obecne= \>\"", ",", "prenosKutta"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.833860828815987*^9}, {3.83386090429062*^9, 3.833860948132308*^9}, {
   3.833860993909981*^9, 
   3.8338611365547533`*^9}},ExpressionUUID->"3953e697-68e2-4b97-8f45-\
a4a6b0a72aa8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"prenos obecne= \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "4"], " ", "\[Lambda]"}], "+", 
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "\[Lambda]"}], "+", 
           RowBox[{"b", "[", "4", "]"}]}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Lambda]"}], " ", 
            RowBox[{"a", "[", "2", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "1", "]"}], " ", 
            RowBox[{"b", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "2", "]"}], " ", 
            RowBox[{"b", "[", "4", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["p", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Lambda]"}], " ", 
            RowBox[{"a", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "1", "]"}], " ", 
            RowBox[{"b", "[", "2", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "2", "]"}], " ", 
            RowBox[{"b", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "3", "]"}], " ", 
            RowBox[{"b", "[", "4", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["p", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Lambda]"}], " ", 
            RowBox[{"a", "[", "4", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "1", "]"}], " ", 
            RowBox[{"b", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "2", "]"}], " ", 
            RowBox[{"b", "[", "2", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "3", "]"}], " ", 
            RowBox[{"b", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"a", "[", "4", "]"}], " ", 
            RowBox[{"b", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["p", "4"]}], "+", 
        RowBox[{"a", "[", "1", "]"}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"a", "[", "2", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["p", "2"], " ", 
         RowBox[{"a", "[", "3", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["p", "3"], " ", 
         RowBox[{"a", "[", "4", "]"}]}]}], ")"}]}], ")"}]}]}],
  SequenceForm[
  "prenos obecne= ", -(-$CellContext`p^4 + $CellContext`a[
      1] + $CellContext`p $CellContext`a[2] + $CellContext`p^2 $CellContext`a[
       3] + $CellContext`p^3 $CellContext`a[
       4])^(-1) ($CellContext`p^4 $CellContext`\[Lambda] + $CellContext`a[
      1] (-$CellContext`\[Lambda] + $CellContext`b[
       4]) + $CellContext`p (-$CellContext`\[Lambda] $CellContext`a[
        2] + $CellContext`a[1] $CellContext`b[3] + $CellContext`a[
        2] $CellContext`b[
        4]) + $CellContext`p^2 (-$CellContext`\[Lambda] $CellContext`a[
        3] + $CellContext`a[1] $CellContext`b[2] + $CellContext`a[
        2] $CellContext`b[3] + $CellContext`a[3] $CellContext`b[
        4]) + $CellContext`p^3 (-$CellContext`\[Lambda] $CellContext`a[
        4] + $CellContext`a[1] $CellContext`b[1] + $CellContext`a[
        2] $CellContext`b[2] + $CellContext`a[3] $CellContext`b[
        3] + $CellContext`a[4] $CellContext`b[4]))],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8473430209920197`*^9},ExpressionUUID->"caa94d74-621d-4d82-9a98-\
13e988bcef57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "dva", " ", "zlomky", " ", "se", " ", "rovnaji", " ", "pokud", " ", "je", 
     " ", "citatel", " ", "jednoho", " ", "stejnym", " ", "nasobkem", " ", 
     "citatele", " ", "druheho", " ", "a", " ", "pro", " ", "jmenovatele", 
     " ", "totez"}], ",", " ", 
    RowBox[{
    "ten", " ", "nasobek", " ", "se", " ", "tady", " ", "jmenuje", " ", 
     "psi"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "citatel", " ", "i", " ", "jmenovatel", " ", "jsou", " ", "polynomy", " ", 
    "a", " ", "pro", " ", "robnost", " ", "se", " ", "musi", " ", "rovnat", 
    " ", "koeficienty", " ", "u", " ", "odpovidajicich", " ", "si", " ", 
    "mocnin"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"num", "=", 
     RowBox[{"Numerator", "[", "prenosKutta", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"den", "=", 
     RowBox[{"Denominator", "[", "prenosKutta", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"coeff", "[", 
      RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"vCem", ",", 
        SuperscriptBox["p", "i"]}], "]"}], "/;", 
      RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"coeff", "[", 
      RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"vCem", "/.", 
        RowBox[{"p", "\[Rule]", "0"}]}], ")"}], "/;", 
      RowBox[{"i", "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceab", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"coeff", "[", 
         RowBox[{"a", ",", "#"}], "]"}], "\[Equal]", 
        RowBox[{"psi", "*", 
         RowBox[{"coeff", "[", 
          RowBox[{"b", ",", "#"}], "]"}]}]}], "&"}], "/@", "rn0"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceVys", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{
        RowBox[{"rceab", "[", 
         RowBox[{"den", ",", "denomP"}], "]"}], ",", 
        RowBox[{"rceab", "[", 
         RowBox[{"num", ",", "numP"}], "]"}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"lhs_", ",", "rhs_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"lhs", "-", "rhs"}], "\[Equal]", "0"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solpsilambda", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"Take", "[", 
        RowBox[{"rceVys", ",", "2"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceRest1", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"rceVys", "/.", "solpsilambda"}], ",", "True"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"neznRest1", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"rceRest1", ",", 
        RowBox[{"_", "[", "_", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "13", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"obory", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"Random", "[", "]"}]}], "}"}], "&"}], "/@", "neznRest1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solA", "=", 
     RowBox[{"Quiet", "@", 
      RowBox[{"FindRoot", "[", 
       RowBox[{"rceRest1", ",", "obory"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"forMin", "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "2"], "&"}], "/@", "rceRest1"}], 
        ")"}], "]"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solB", "=", 
     RowBox[{"FindMinimum", "[", 
      RowBox[{"forMin", ",", "obory", ",", 
       RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{"vys", "=", 
    RowBox[{"Union", "[", 
     RowBox[{
      RowBox[{"solB", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "solpsilambda"}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.833860828815987*^9}, {3.83386090429062*^9, 3.833860948132308*^9}, {
   3.833860993909981*^9, 3.833861044071374*^9}, {3.833861146802967*^9, 
   3.833861159914527*^9}, {3.833861200598822*^9, 3.8338612993635345`*^9}, {
   3.8338613592698865`*^9, 3.833861362333067*^9}, {3.8338614674650617`*^9, 
   3.833861540707053*^9}},ExpressionUUID->"4592c35f-38b4-470d-ad88-\
7fd77d159afd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"psi", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "19"]}]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox["7", "19"]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], "\[Rule]", 
    RowBox[{"-", "0.3684165001021612`"}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], "\[Rule]", 
    RowBox[{"-", "0.5789574561772918`"}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], "\[Rule]", 
    RowBox[{"-", "0.6842100615462214`"}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"-", "0.8947395421700864`"}]}], ",", 
   RowBox[{
    RowBox[{"b", "[", "1", "]"}], "\[Rule]", 
    RowBox[{"-", "0.148313407168402`"}]}], ",", 
   RowBox[{
    RowBox[{"b", "[", "2", "]"}], "\[Rule]", 
    RowBox[{"-", "0.06702349851604404`"}]}], ",", 
   RowBox[{
    RowBox[{"b", "[", "3", "]"}], "\[Rule]", 
    RowBox[{"-", "0.0612270894651616`"}]}], ",", 
   RowBox[{
    RowBox[{"b", "[", "4", "]"}], "\[Rule]", "0.22556690262460993`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8473430211235013`*^9},ExpressionUUID->"7789a942-dc32-41b2-a6c7-\
00d7155b35dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "tohle", " ", "vsechno", " ", "nebude", " ", "samosebou", " ", "delat", 
     " ", "tvuj", " ", "program"}], ",", " ", 
    RowBox[{
    "ten", " ", "dostane", " ", "jako", " ", "vstup", " ", "tahle", " ", 
     "cisla"}], ",", " ", 
    RowBox[{"resp", " ", "koeficienty", " ", "v", " ", "rovnicich"}], ",", 
    " ", 
    RowBox[{
    "tady", " ", "opet", " ", "zapsano", " ", "Laplaceovou", " ", 
     "symbolikou"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"vysRce", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"stavoveRce", ",", 
        RowBox[{"{", 
         RowBox[{"y", "\[Equal]", "vystup"}], "}"}]}], "]"}], "/.", "vys"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<rce pro reseni= \>\"", ",", " ", "vysRce"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.833860828815987*^9}, {3.83386090429062*^9, 3.833860948132308*^9}, {
   3.833860993909981*^9, 3.833861044071374*^9}, {3.833861146802967*^9, 
   3.833861159914527*^9}, {3.833861200598822*^9, 3.8338612582159348`*^9}, {
   3.833861553411168*^9, 3.833861560847369*^9}, {3.8338616250788546`*^9, 
   3.833861685967017*^9}, {3.833861770547535*^9, 
   3.8338617990838947`*^9}},ExpressionUUID->"e3d13318-f691-45be-8362-\
85e3a45e1c3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"rce pro reseni= \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Equal]", 
      RowBox[{
       FractionBox[
        RowBox[{"7", " ", "u"}], "19"], "-", 
       RowBox[{"0.3684165001021612`", " ", 
        RowBox[{"x", "[", "1", "]"}]}], "-", 
       RowBox[{"0.5789574561772918`", " ", 
        RowBox[{"x", "[", "2", "]"}]}], "-", 
       RowBox[{"0.6842100615462214`", " ", 
        RowBox[{"x", "[", "3", "]"}]}], "-", 
       RowBox[{"0.8947395421700864`", " ", 
        RowBox[{"x", "[", "4", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"p", " ", 
       RowBox[{"x", "[", "1", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.148313407168402`"}], " ", "u"}], "+", 
       RowBox[{"x", "[", "2", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"p", " ", 
       RowBox[{"x", "[", "2", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.06702349851604404`"}], " ", "u"}], "+", 
       RowBox[{"x", "[", "3", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"p", " ", 
       RowBox[{"x", "[", "3", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.0612270894651616`"}], " ", "u"}], "+", 
       RowBox[{"x", "[", "4", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"p", " ", 
       RowBox[{"x", "[", "4", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"0.22556690262460993`", " ", "u"}], "-", 
       RowBox[{"0.3684165001021612`", " ", 
        RowBox[{"x", "[", "1", "]"}]}], "-", 
       RowBox[{"0.5789574561772918`", " ", 
        RowBox[{"x", "[", "2", "]"}]}], "-", 
       RowBox[{"0.6842100615462214`", " ", 
        RowBox[{"x", "[", "3", "]"}]}], "-", 
       RowBox[{"0.8947395421700864`", " ", 
        RowBox[{"x", "[", "4", "]"}]}]}]}]}], "}"}]}],
  SequenceForm[
  "rce pro reseni= ", {$CellContext`y == 
    Rational[7, 19] $CellContext`u - 0.3684165001021612 $CellContext`x[1] - 
     0.5789574561772918 $CellContext`x[2] - 
     0.6842100615462214 $CellContext`x[3] - 
     0.8947395421700864 $CellContext`x[4], $CellContext`p $CellContext`x[
      1] == (-0.148313407168402) $CellContext`u + $CellContext`x[
      2], $CellContext`p $CellContext`x[
      2] == (-0.06702349851604404) $CellContext`u + $CellContext`x[
      3], $CellContext`p $CellContext`x[
      3] == (-0.0612270894651616) $CellContext`u + $CellContext`x[
      4], $CellContext`p $CellContext`x[4] == 
    0.22556690262460993` $CellContext`u - 
     0.3684165001021612 $CellContext`x[1] - 
     0.5789574561772918 $CellContext`x[2] - 
     0.6842100615462214 $CellContext`x[3] - 
     0.8947395421700864 $CellContext`x[4]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8473430211769066`*^9},ExpressionUUID->"9be1f066-a6a4-47bc-bc34-\
cebca1a3fb95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "tady", " ", "je", " ", "jen", " ", "overeni", " ", "ze", " ", "reseni", 
    " ", 
    RowBox[{"(", 
     RowBox[{"Laplaceovou", " ", "transformaci"}], ")"}], " ", "puvodni", " ",
     "rovnice", " ", "i", " ", "soustavy", " ", "difosek", " ", "da", " ", 
    "stejny", " ", "prubeh"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"vstupTry", "=", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"0.123", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"outLpl", "=", 
     RowBox[{"prenos", "*", 
      RowBox[{"(", 
       RowBox[{"lplVstup", "=", 
        RowBox[{"LaplaceTransform", "[", 
         RowBox[{"vstupTry", ",", "t", ",", "p"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"outCas", "=", 
     RowBox[{"InverseLaplaceTransform", "[", 
      RowBox[{"outLpl", ",", "p", ",", "t"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"outCas", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vystupRce", "=", 
     RowBox[{"vysRce", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stavRce", "=", 
     RowBox[{"Take", "[", 
      RowBox[{"vysRce", ",", 
       RowBox[{"-", "n"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dosIkska", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"stavRce", "/.", 
          RowBox[{"{", 
           RowBox[{"u", "->", "lplVstup"}], "}"}]}], ",", "xvect"}], "]"}], 
       "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Rule", "[", 
        RowBox[{"lhs_", ",", "rhs_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Rule", "[", 
        RowBox[{"lhs", ",", 
         RowBox[{"InverseLaplaceTransform", "[", 
          RowBox[{"rhs", ",", "p", ",", "t"}], "]"}]}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vystupStav", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"vystupRce", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{"u", "->", "vstupTry"}], "}"}]}], ")"}], "/.", 
      "dosIkska"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"vystupStav", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "pl2"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.828196240375*^9, 3.828196259046875*^9}, 
   3.82819648665625*^9, {3.82819663378125*^9, 3.828196718171875*^9}, {
   3.828196911828125*^9, 3.828196928890625*^9}, {3.828196962*^9, 
   3.82819696615625*^9}, 3.828197075296875*^9, {3.82819752015625*^9, 
   3.828197520953125*^9}, {3.82819760728125*^9, 3.8281976519375*^9}, {
   3.828197709328125*^9, 3.828197710015625*^9}, {3.828197761515625*^9, 
   3.82819777403125*^9}, 3.828270385765625*^9, {3.82827066721875*^9, 
   3.828270669140625*^9}, {3.828271233484375*^9, 3.82827123640625*^9}, {
   3.82827133946875*^9, 3.828271436734375*^9}, 3.8282765368125*^9, 
   3.828276585828125*^9, 3.828277097453125*^9, {3.828277135859375*^9, 
   3.8282771775*^9}, {3.828277228609375*^9, 3.828277232*^9}, {
   3.82827726490625*^9, 3.82827728375*^9}, {3.833858203595662*^9, 
   3.833858221853425*^9}, {3.8338583599125032`*^9, 3.833858363693946*^9}, {
   3.833859413281299*^9, 3.83385941495557*^9}, {3.833860047192874*^9, 
   3.8338601379487596`*^9}, {3.833860570312789*^9, 3.833860575112506*^9}, {
   3.8338606093919106`*^9, 3.833860707325473*^9}, {3.833860764694309*^9, 
   3.833860828815987*^9}, {3.83386090429062*^9, 3.833860948132308*^9}, {
   3.833860993909981*^9, 3.833861044071374*^9}, {3.833861146802967*^9, 
   3.833861159914527*^9}, {3.833861200598822*^9, 3.8338612582159348`*^9}, {
   3.833861553411168*^9, 3.833861560847369*^9}, {3.833861822211482*^9, 
   3.8338618968511086`*^9}},ExpressionUUID->"d7f73dea-6e7f-4418-94e1-\
378880a3af22"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3k4FF4Xx4WUdWYsJctYYsY6Q2lR6Z5slRQJ2SpJkWwpEUpFJSRJSBFC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        "]], LineBox[CompressedData["
1:eJwVlHs81dkWwI3UvTVqwiEcnD0zxiuNOb+N3mY5ntFVSUzoeEx5poyQK0pe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        "]]},
      Annotation[#, "Charting`Private`Tag$2229#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVl3k4VG8bx20p64wl+VlmJjFjncGotD43lS2lbBUSUmiRlEhCoSIkSVJo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        "]]},
      Annotation[#, "Charting`Private`Tag$2404#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.847343021562237*^9},ExpressionUUID->"8f7cf63c-9931-4efd-9990-\
ceae4ddf1fdd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Laplaceovou", " ", "transformaci", " ", "je", " ", "to", " ", "dooost", 
     " ", "overeno"}], ",", " ", 
    RowBox[{
    "tak", " ", "to", " ", "udelame", " ", "resnim", " ", "v", " ", "casove", 
     " ", "oblasti"}], ",", " ", "vidime", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ze", " ", "to", " ", "funguje"}], "..."}], " ", "tak", " ", 
     "to", " ", "udelame", " ", "Eulerem"}], ",", " ", 
    RowBox[{"Runge", "-", 
     RowBox[{
     "Kuttou", " ", "a", " ", "vnitrnim", " ", "resicem", " ", 
      "NDSolve"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tady", " ", "NDSolvem"}], ",", " ", 
    RowBox[{
    "prevedu", " ", "nasobeni", " ", "peckem", " ", "na", " ", "derivovani", 
     " ", "a", " ", "pocatecni", " ", "podminky", " ", "uvazuji", " ", 
     "nulove"}]}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"vstup", "[", "t_", "]"}], "=", "vstupTry"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"difRce", "=", 
     RowBox[{"stavRce", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "*", "x_"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"x_", "[", "i_", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"x", "[", "i", "]"}], "[", "t", "]"}]}], ",", 
        RowBox[{"u", "\[Rule]", 
         RowBox[{"vstup", "[", "t", "]"}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"neznameVyrazy", "=", 
     RowBox[{"Through", "[", 
      RowBox[{"xvect", "[", "t", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nezname", "=", "xvect"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pocs", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", "0", "]"}], "\[Equal]", "0"}], "&"}], "/@", 
      "xvect"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solCas", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"difRce", ",", "pocs"}], "]"}], ",", "nezname", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"vystupCas", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"vystupRce", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "\[Rule]", 
           RowBox[{"vstup", "[", "t", "]"}]}], ",", 
          RowBox[{
           RowBox[{"x_", "[", "i_", "]"}], "\[RuleDelayed]", 
           RowBox[{
            RowBox[{"x", "[", "i", "]"}], "[", "t", "]"}]}]}], "}"}]}], ")"}],
       "/.", "solCas"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl3", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"vystupCas", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"pl1", ",", "pl2", ",", "pl3"}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.828271587078125*^9, 3.828271611625*^9}, {
  3.82827235828125*^9, 3.82827237609375*^9}, {3.833862001871279*^9, 
  3.833862091320562*^9}, {3.833862148978369*^9, 
  3.833862150799765*^9}},ExpressionUUID->"0b6a8150-60e0-49c8-8861-\
08c2cd3df553"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "pro", " ", "Eulera", " ", "a", " ", "Runge", " ", "Kuttu", " ", 
     "potrebuju", " ", "funkci"}], ",", " ", 
    RowBox[{
    "ktera", " ", "si", " ", "bere", " ", "cas", " ", "a", " ", "vraci", " ", 
     "vektor", " ", "derivaci", " ", "stavovych", " ", "promennych"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tady", " ", "je", " ", "to", " ", "prasacky", " ", "namastene"}],
     ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ale", " ", "funguje", " ", "to"}], "..."}], " ", "proste", " ",
      "to", " ", "vraci", " ", "vektor", " ", "pravych", " ", "stran", " ", 
     "stavovych", " ", "rovnic"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "reseni", " ", "Eulerovou", " ", "metodou", " ", "je", " ", "klasika", 
     " ", "jak", " ", "jsme", " ", "to", " ", "delali", " ", "v", " ", 
     "CAO"}], ",", " ", 
    RowBox[{"ale", " ", "ukazuje", " ", "se"}], ",", " ", 
    RowBox[{
    "ze", " ", "se", " ", "od", " ", "spravneho", " ", "reseni", " ", 
     "odchyluje", " ", "a", " ", "bude", " ", "potreba", " ", "Runge", " ", 
     "Kutta"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "derivace", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"derivace", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "vect_"}], "}"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "stavRce"}], ")"}], "/.", 
        RowBox[{"MapThread", "[", 
         RowBox[{"Rule", ",", 
          RowBox[{"{", 
           RowBox[{"xvect", ",", "vect"}], "}"}]}], "]"}]}], ")"}], "/.", 
      RowBox[{"u", "\[Rule]", 
       RowBox[{"vstup", "[", "t", "]"}]}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.828273997890625*^9, {3.828274078421875*^9, 3.82827409759375*^9}, {
   3.828275308015625*^9, 3.828275321171875*^9}, {3.82827537278125*^9, 
   3.82827542053125*^9}, {3.82827562275*^9, 3.828275629359375*^9}, {
   3.828275660671875*^9, 3.828275677*^9}, {3.8282757774375*^9, 
   3.828275817578125*^9}, {3.828276548734375*^9, 3.828276555765625*^9}, {
   3.8338621149137416`*^9, 3.833862231513725*^9}, {3.8338622646678333`*^9, 
   3.8338623166038723`*^9}},ExpressionUUID->"e400178a-5b98-4ba3-b638-\
d91174eea83c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nBodu", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nUseku", "=", 
   RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"N", "@", 
    FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krokEuler", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "stav_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "der", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"der", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "stav"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"stav", "+", 
         RowBox[{"\[CapitalDelta]t", "*", "der"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocStav", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"0.", "&"}], "/@", "xvect"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solEuler", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krokEuler", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.828275846546875*^9, 3.828276120125*^9}, {
   3.828276171515625*^9, 3.82827621203125*^9}, {3.828276267171875*^9, 
   3.828276312140625*^9}, {3.82827635703125*^9, 3.828276500046875*^9}, {
   3.828276561484375*^9, 3.828276574375*^9}, {3.8282769023125*^9, 
   3.82827690378125*^9}, 3.8282770429375*^9, {3.828277123734375*^9, 
   3.8282771243125*^9}, 3.82827725546875*^9, {3.833862250869478*^9, 
   3.833862255337387*^9}},ExpressionUUID->"e403ec59-42e9-4b46-8710-\
fa994ce00350"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "protoze", " ", "nas", " ", "zajima", " ", "hodnota", " ", "vystupu", " ",
      "y", " ", "a", " ", "ne", " ", "hodnoty", " ", "stavovych", " ", 
     "promennych"}], ",", " ", 
    RowBox[{"je", " ", "udelana", " ", "funkce", " ", "vystupZeStavu"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vidime", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "se", " ", "to", " ", "odchyluje", " ", "dost"}], 
     "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "vystupZeStavu", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vystupZeStavu", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "vect_"}], "}"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"vystupRce", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ")"}], "/.", 
        RowBox[{"MapThread", "[", 
         RowBox[{"Rule", ",", 
          RowBox[{"{", 
           RowBox[{"xvect", ",", "vect"}], "}"}]}], "]"}]}], ")"}], "/.", 
      RowBox[{"u", "\[Rule]", 
       RowBox[{"vstup", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bodyEuler", "=", 
     RowBox[{"solEuler", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"vystupZeStavu", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{"bodyEuler", ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", "pl1", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.828275846546875*^9, 3.828276120125*^9}, {
   3.828276171515625*^9, 3.82827621203125*^9}, {3.828276267171875*^9, 
   3.828276312140625*^9}, {3.82827635703125*^9, 3.828276500046875*^9}, {
   3.828276561484375*^9, 3.828276574375*^9}, {3.8282769023125*^9, 
   3.82827690378125*^9}, 3.8282770429375*^9, {3.828277123734375*^9, 
   3.8282771243125*^9}, 3.82827725546875*^9, {3.833862250869478*^9, 
   3.833862255337387*^9}, {3.833862325818015*^9, 
   3.8338623775313425`*^9}},ExpressionUUID->"3fa1b32e-b24a-495c-a2c0-\
f8d9c8525003"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.009166666666666668], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJxdlHs0lGkcx8ck3RuXXCYT4z4ajJmRRPX8hFIScUor1rUtbXJJhZXtSk2r
WLmVmk7l7JaVVtHZVr0vpjrWpWhSVplhzsqtTBSjqJ334a+ec97znue8z/v7
fX/f7+c8ZpFxATvoNBotWv1Q728XP26nd2NHPSKf9Dqd8qxEU/t21FG4Je1c
ugTtyPV1bo9WINU70atQXtP09z4kqehKiLFrRT+XQFmYrRIxz+THb22TTp8f
QQL/iz51B9qQz5FgIuDyKBIU8R48U7VN/z+O6Jm+krMBbcgwNKnFy3ASOZZs
1s06IZ2uR4MJ2VAEV9yCElmPE1iPNSCr8Ce/B/EN0/VngPXz5cn6/TVo21zp
pzz6TOCcTq4KNPxjup8WWApEw8boKrFaJT/GWD0byg8zOkKX1BBT/ecABEXc
KgpvIix73s4/lTIP8kI2+0WdkhJTehZAQ05qv7StncDlKxdCsQf92rJtncSU
Pm14X7drJbNPToxT5VXakPHEtnn37G5iH9arA9LuL9z6pG7ibRBVQRfm7Ql4
fdSkm9iJ9euBTi1twn5CTnQ1ZxfeFS6ChJQtv/kadBLbcUN9EErKmkvFL4nn
XpQifYiNCL+1v7SF8MPzGUCZbePwu+paor76ohk/zhDIlIfeStEW5IHnNYI4
5tBlXo8E3RdSEzKhzulg+NXE52g5np8JMUe4TR6RcvTnDWotBm70skfiOT2I
i/0wBodNtwb7jg6gEjPKMRZ4n5c7F/krkSn2Zwl4vl5TzCseRkVq9ZY9S+Ba
2t54l7MfkB72ywQGqzf+GmIwirIYVAKmcL432OMQewwdw/6x4ZnSvs5JPIbA
I7KzOZsN/m+VYs/MMTSJ/WTD7rNzg4eejqJ76dQPZnDcbu89t+SP6CD21wzk
I62T7EMjyOle75XTDuaQlZFacUGhRO+x3+aQyiu9FrRzAN38yJ25e9Ic7DZE
JaYOK9CP2H8LoJtrr1EyXiAOBsICXGg1nokJFeg/nIclbNUcvhTr0kxc2VNR
b33BEljH5pbH/NtFhOF8rICteMfbHjZIsH6nGljBnlFJuCR+hGjHeVmBjSot
wzVHReQrXM4oXKzh8IYMb0n8JBGI87OGaNdOldcYjdQ2TVPWzLKBlxOLKl59
oJNNOE8b0KmidXy5rEmKqONtNhClYbhLZ3AmuQ7ny4Gv4opCv8dapGY+vTK9
hAOiZHctQ6tZZA3O2xb0F67/sGxci0xvoQTZQvHalS/dVmiRbjh/W3AP15c1
vNIkVeq03TyWQpDM7r3yNZ2sxDwsBY7zwZDEFTQykaJFlwtJeUb/+HWOEzzM
BxcWp4QxCjSHiUEqLjkXmJ/LJha/6SKuY17swMhrwaMB5W30AyW/3A76jrhb
rOjvRRaYH3uIraqjV2eqkJzCJd0eLGvTb4uu0uEi5skehPuMdaxXzYFgdVq5
vg7A0Ag82TrEAEPMlwOsdc13cPXRA2kCBQQPQp7JnOjHDSAH88aDUlZSz4xf
mLBJTZv/AA/2b+BkF/iw4ATmzxFiLBRJjBsmEEXJCXUEk4KnyUbr2OCOeXQE
vQMC44ghNpjqjhzIkDhCy6rvavPczWCKT0fg7di4QF9gBh3li9QE8KFRZrBw
fRUb/sK88kFhIBs2FplCAYVbLh8+R4yQLjdZsB/zy4dct9y7vc1GEDhAAcuH
O7KS77Pe6AEf8ywAIud+XOTIPGBQ8UQKIFlxPWPUeQJN3ScCiDted4mRVU80
WF9QEyoAz1iirn6cTl7HvAvAThKYla3QJTMlFFBCEM9/YtL2gkVO3Z9CeEpG
hkSesyDxuIVC+Hsw4E55M4fE8TUKobXmpEbBJ3vyK17qff/Sh56pfPJ/9R/k
yw==
       "]]}, {}}, {}, {}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3k4FF4Xx4WUdWYsJctYYsY6Q2lR6Z5slRQJ2SpJkWwpEUpFJSRJSBFC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        "]], LineBox[CompressedData["
1:eJwVlHs81dkWwI3UvTVqwiEcnD0zxiuNOb+N3mY5ntFVSUzoeEx5poyQK0pe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        "]]},
      Annotation[#, "Charting`Private`Tag$2229#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473430217783318`*^9},ExpressionUUID->"0a08d63d-9be0-48c8-ad4e-\
148b454b26d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"to", " ", "same", " ", "s", " ", "Runge", " ", "Kuttou"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "to", " ", "by", " ", "ten", " ", "navrzeny", " ", "HW", " ", "a", " ", 
     "SW", " ", "mel", " ", "delat"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "odnekud", " ", "nasat", " ", "koeficienty", " ", "a", " ", "resit", 
       " ", "Runge", " ", "Kuttou"}], "..."}], " ", "vlatne", " ", "to", " ", 
     "jde", " ", "prevest", " ", "na", " ", "nasobeni", " ", "matice", " ", 
     "vektorem", " ", "a", " ", "scitani", " ", "vektoru"}], ",", " ", 
    RowBox[{
     RowBox[{"melo", " ", "by", " ", "to", " ", "bezet", " ", "rychle"}], 
     "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "RungeKuttaStep", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nBodu", "=", "30"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nUseku", "=", 
     RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{"N", "@", 
      FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaStep", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solRungeKutta", "=", 
     RowBox[{"NestList", "[", 
      RowBox[{"RungeKuttaStep", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bodyRungeKutta", "=", 
     RowBox[{"solRungeKutta", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"vystupZeStavu", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{"bodyRungeKutta", ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", "pl1"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.828276850140625*^9, 3.8282769634375*^9}, {
  3.828277014859375*^9, 3.82827706825*^9}, {3.828277110609375*^9, 
  3.828277116203125*^9}, {3.82827719725*^9, 3.828277202125*^9}, {
  3.8338623876637077`*^9, 3.8338623973953524`*^9}, {3.833862434212247*^9, 
  3.833862497148387*^9}},ExpressionUUID->"61c181e6-52b4-4f4c-8add-\
8147689f12c8"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQ5qpBJ3Lhd8Zs+8yuCbdf15ewj/m/1lJ58ojpdX
7e9e5jht28vgwD3nbkxc3DmoPJvDg5eGv5yaZu+XBnGncTvksch19hy5sh+i
XsDhc4jGd6+r9/frfDc5VOQv7DBhd4beWp3b+yH6xRw+dN98E827df8Z294N
dy5LOCQdPrlI+chtexmwedIOHf53T9q/eGuf0/J0nluEnENdvyRXuNdn+3tg
8xUcgmasvs1S9tG+DST9TtFBWpQ5t5Txkb0e2D5lB6f/oR9f5l/Yfw2kfIOK
Qw3TBnXLFx/314HtV3PY0nz+18Hpv/ergR2o7tCSlP9Bm+fv/nNg92g4iLBE
tz0y+7K/zF8ZqELLIWEiS7KX+f79cmD3aTvopM3yfnL/q/2xIpACHQeBVT0C
3R1sDnlg9+o5HGtbkGlmxucgNq0aaKO+g7DHAgOT3XwO98HuN3D4Eul5cq8S
m8PmOyABQwc2S/NFvwMe2beD/WPoEGiiuyFSlflA9LtMoIlGDgcy711WOSt6
QB/sP2OHfafUDDp2yB1gBseiicOubMVlgnYKBwAcIdPV
       "]]}, {}}, {}, {}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3k4FF4Xx4WUdWYsJctYYsY6Q2lR6Z5slRQJ2SpJkWwpEUpFJSRJSBFC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        "]], LineBox[CompressedData["
1:eJwVlHs81dkWwI3UvTVqwiEcnD0zxiuNOb+N3mY5ntFVSUzoeEx5poyQK0pe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        "]]},
      Annotation[#, "Charting`Private`Tag$2229#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20.00000000000001}, {-8.121228400783242, 
    3.8414081381715817`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473430219475613`*^9},ExpressionUUID->"3842f8ed-e417-4c09-9a1c-\
1860f4104463"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "prevod", " ", "mezi", " ", "prenosem", " ", "a", " ", "soustavou", " ", 
     "stavovych", " ", "rovnic", " ", "a", " ", "vystupni", " ", "rovnici", 
     " ", "neni", " ", "jednoznacny"}], ",", " ", 
    RowBox[{
    "tady", " ", "je", " ", "naprogramovany", " ", "jiny", " ", "zpusob"}], 
    ",", " ", 
    RowBox[{"nevyzadujici", " ", "reseni", " ", "soustavy", " ", "rovnic"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"tzv", ".", " ", "metoda"}], " ", "postupne", " ", 
     "integrace"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vsechno", " ", "ostatni", " ", "je", " ", "shodne"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"je", " ", "mozne"}], ",", " ", 
    RowBox[{
    "ze", " ", "nektera", " ", "metoda", " ", "bude", " ", "pro", " ", 
     "numeriku", " ", "vyhodnejsi"}], ",", " ", 
    RowBox[{
    "osobne", " ", "tipuju", " ", "ze", " ", "tahle", " ", "metoda", " ", 
     "postupne", " ", "integrace"}], ",", " ", 
    RowBox[{
    "kazdopadne", " ", "je", " ", "z", " ", "toho", " ", "mozne", " ", 
     "varit", " ", "omacku", " ", "do", " ", "diplomky", " ", "ci", " ", 
     "projektu"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rn", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rn0", "=", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"coeff", "[", 
      RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"vCem", ",", 
        SuperscriptBox["p", "i"]}], "]"}], "/;", 
      RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"coeff", "[", 
      RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"vCem", "/.", 
        RowBox[{"p", "\[Rule]", "0"}]}], ")"}], "/;", 
      RowBox[{"i", "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"prenos", "=", 
      RowBox[{"<<", "\"\<prenos\>\""}]}], ";"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"prenos", "=", 
     FractionBox[
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["p", "#"], "*", 
           RowBox[{"Prime", "[", "#", "]"}]}], "&"}], "/@", "rn"}], "]"}], 
       "+", "1"}], 
      RowBox[{"Total", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["p", "#"], "*", 
          RowBox[{"Prime", "[", 
           RowBox[{"#", "+", "n"}], "]"}]}], "&"}], "/@", "rn0"}], "]"}]]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<prenos= \>\"", ",", "prenos"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numP", "=", 
     RowBox[{"Numerator", "[", "prenos", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"denomP", "=", 
     RowBox[{"Denominator", "[", "prenos", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "i_Integer", "]"}], ":=", 
     RowBox[{"coeff", "[", 
      RowBox[{"denomP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", "i_Integer", "]"}], ":=", 
     RowBox[{"coeff", "[", 
      RowBox[{"numP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "/@", "rn0"}], ",", 
      RowBox[{"b", "/@", "rn0"}], ",", "prenos"}], "}"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stavRcei", "[", "0", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "*", 
        RowBox[{"y", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"b", "[", "0", "]"}], "*", 
        RowBox[{"u", "[", "t", "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stavRcei", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "[", "i", "]"}], "*", 
        RowBox[{"y", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"b", "[", "i", "]"}], "*", 
        RowBox[{"u", "[", "t", "]"}]}], "+", 
       RowBox[{
        RowBox[{"x", "[", 
         RowBox[{"i", "-", "1"}], "]"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vstupTry", "=", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"0.123", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vstup", "[", "t_", "]"}], "=", "vstupTry"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceStavYU", "=", 
     RowBox[{"stavRcei", "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"dosVstup", "=", 
     RowBox[{"{", 
      RowBox[{"u", "\[Rule]", "vstup"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceStav", "=", 
     RowBox[{"rceStavYU", "/.", "dosVstup"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vystupniRce", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "n", "]"}], "*", 
         RowBox[{"y", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"b", "[", "n", "]"}], "*", 
         RowBox[{"u", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}]}], "\[Equal]", 
       "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solVystRov", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"vystupniRce", ",", 
        RowBox[{"y", "[", "t", "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceStavObecne", "=", 
     RowBox[{"rceStavYU", "/.", "solVystRov"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceStavU", "=", 
     RowBox[{"rceStavObecne", "/.", "dosVstup"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "reseniLaplaceovou", " ", "transformaci", " ", "z", " ", "puvodniho", 
      " ", "prenosu"}], "..."}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.828959917953125*^9, 3.828959922171875*^9}, {
   3.828959952484375*^9, 3.82896001953125*^9}, {3.8289600749375*^9, 
   3.82896014909375*^9}, {3.828960209515625*^9, 3.828960287125*^9}, {
   3.828960533171875*^9, 3.828960642484375*^9}, {3.82896070434375*^9, 
   3.82896072878125*^9}, {3.8289607653125*^9, 3.828960887171875*^9}, {
   3.828961069671875*^9, 3.828961365015625*^9}, {3.828961397875*^9, 
   3.828961440515625*^9}, {3.828961471171875*^9, 3.828961503328125*^9}, {
   3.828961617171875*^9, 3.828961711859375*^9}, {3.828962215703125*^9, 
   3.828962216609375*^9}, {3.828962409734375*^9, 3.828962428828125*^9}, {
   3.828962461453125*^9, 3.828962538453125*^9}, {3.8289625705*^9, 
   3.828962571984375*^9}, {3.82896261628125*^9, 3.82896263178125*^9}, {
   3.828962673984375*^9, 3.8289626848125*^9}, {3.828962734765625*^9, 
   3.8289627625*^9}, {3.82896283053125*^9, 3.828962861328125*^9}, {
   3.8289628974375*^9, 3.82896291571875*^9}, {3.82896303784375*^9, 
   3.82896304865625*^9}, {3.828963189765625*^9, 3.828963237453125*^9}, {
   3.828963282296875*^9, 3.82896331290625*^9}, {3.82896338734375*^9, 
   3.828963480296875*^9}, {3.828963583078125*^9, 3.828963638890625*^9}, 
   3.828963734609375*^9, {3.82896380328125*^9, 3.82896384146875*^9}, {
   3.828963906171875*^9, 3.828963982921875*^9}, {3.828964035390625*^9, 
   3.828964035953125*^9}, {3.82896407128125*^9, 3.828964083375*^9}, {
   3.828964173171875*^9, 3.828964295171875*^9}, {3.828964329640625*^9, 
   3.828964368421875*^9}, {3.828964417578125*^9, 3.828964603984375*^9}, 
   3.833858156178323*^9, 3.833859082736682*^9, {3.833859154239219*^9, 
   3.8338591975332937`*^9}, {3.8338593781983485`*^9, 
   3.8338593801044703`*^9}, {3.833862509772867*^9, 3.8338625674591722`*^9}, {
   3.8338626241899223`*^9, 3.833862637262792*^9}, {3.8338626725628567`*^9, 
   3.833862724600479*^9}},ExpressionUUID->"32526242-9348-4bdf-98e3-\
275d85e8ec78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"prenos= \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "p"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["p", "3"]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["p", "4"]}]}], 
    RowBox[{"7", "+", 
     RowBox[{"11", " ", "p"}], "+", 
     RowBox[{"13", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"17", " ", 
      SuperscriptBox["p", "3"]}], "+", 
     RowBox[{"19", " ", 
      SuperscriptBox["p", "4"]}]}]]}],
  SequenceForm[
  "prenos= ", (1 + 2 $CellContext`p + 3 $CellContext`p^2 + 5 $CellContext`p^3 + 
    7 $CellContext`p^4)/(7 + 11 $CellContext`p + 13 $CellContext`p^2 + 
   17 $CellContext`p^3 + 19 $CellContext`p^4)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.847343022025673*^9},ExpressionUUID->"acfc375e-873b-4ad2-b94e-\
9b7635ee3dec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["rceStavObecne"], "Input",ExpressionUUID->"b3c1e7b9-3344-418c-a62b-c0a258211cdb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      FractionBox["7", "19"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{"u", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "3", "]"}], "[", "t", "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["11", "19"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{"u", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "3", "]"}], "[", "t", "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["13", "19"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{"u", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "3", "]"}], "[", "t", "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "3", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["17", "19"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{"u", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"x", "[", "3", "]"}], "[", "t", "]"}]}], ")"}]}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8473430220946674`*^9},ExpressionUUID->"dcbcac4f-4ef4-44d3-932d-\
1e31f9c22a84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"rceStavYU", "\[IndentingNewLine]", "solVystRov"}], "Input",
 CellChangeTimes->{{3.847332394714082*^9, 
  3.847332395120239*^9}},ExpressionUUID->"d9236ba1-8833-4400-85a5-\
b23746d82ac1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{"7", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{"11", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{"13", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "3", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{"17", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847343022163662*^9},ExpressionUUID->"7f63fa0a-a1da-4ca2-ac32-\
b2364b131bdc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox["1", "19"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"7", " ", 
       RowBox[{"u", "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "[", "t", "]"}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8473430221949043`*^9},ExpressionUUID->"5a7db650-b8aa-4b00-9429-\
5d23038c5a0e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outLpl", "=", 
   RowBox[{"prenos", "*", 
    RowBox[{"(", 
     RowBox[{"lplVstup", "=", 
      RowBox[{"LaplaceTransform", "[", 
       RowBox[{"vstupTry", ",", "t", ",", "p"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outCas", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{"outLpl", ",", "p", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"outCas", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xvect", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "#", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"laplasiRceStav", "=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rceStavObecne", ",", "vystupniRce"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "i_", "]"}], "'"}], "[", "t", "]"}], 
       "\[RuleDelayed]", 
       RowBox[{"p", "*", 
        RowBox[{"x", "[", "i", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i_", "]"}], "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{"x", "[", "i", "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "\[RuleDelayed]", "y"}], ",", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{"LaplaceTransform", "[", 
        RowBox[{"vstupTry", ",", "t", ",", "p"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solLaplace", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"laplasiRceStav", ",", 
      RowBox[{"Union", "[", 
       RowBox[{"xvect", ",", 
        RowBox[{"{", "y", "}"}]}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solStav", "=", 
   RowBox[{"solLaplace", "/.", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"Rule", "[", 
      RowBox[{"lhs", ",", 
       RowBox[{"InverseLaplaceTransform", "[", 
        RowBox[{"rhs", ",", "p", ",", "t"}], "]"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"y", "/.", "solStav"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", "pl2"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.828959917953125*^9, 3.828959922171875*^9}, {
   3.828959952484375*^9, 3.82896001953125*^9}, {3.8289600749375*^9, 
   3.82896014909375*^9}, {3.828960209515625*^9, 3.828960287125*^9}, {
   3.828960533171875*^9, 3.828960642484375*^9}, {3.82896070434375*^9, 
   3.82896072878125*^9}, {3.8289607653125*^9, 3.828960887171875*^9}, {
   3.828961069671875*^9, 3.828961365015625*^9}, {3.828961397875*^9, 
   3.828961440515625*^9}, {3.828961471171875*^9, 3.828961503328125*^9}, {
   3.828961617171875*^9, 3.828961711859375*^9}, {3.828962215703125*^9, 
   3.828962216609375*^9}, {3.828962409734375*^9, 3.828962428828125*^9}, {
   3.828962461453125*^9, 3.828962538453125*^9}, {3.8289625705*^9, 
   3.828962571984375*^9}, {3.82896261628125*^9, 3.82896263178125*^9}, {
   3.828962673984375*^9, 3.8289626848125*^9}, {3.828962734765625*^9, 
   3.8289627625*^9}, {3.82896283053125*^9, 3.828962861328125*^9}, {
   3.8289628974375*^9, 3.82896291571875*^9}, {3.82896303784375*^9, 
   3.82896304865625*^9}, {3.828963189765625*^9, 3.828963237453125*^9}, {
   3.828963282296875*^9, 3.82896331290625*^9}, {3.82896338734375*^9, 
   3.828963480296875*^9}, {3.828963583078125*^9, 3.828963638890625*^9}, 
   3.828963734609375*^9, {3.82896380328125*^9, 3.82896384146875*^9}, {
   3.828963906171875*^9, 3.828963982921875*^9}, {3.828964035390625*^9, 
   3.828964035953125*^9}, {3.82896407128125*^9, 3.828964083375*^9}, {
   3.828964173171875*^9, 3.828964295171875*^9}, {3.828964329640625*^9, 
   3.828964368421875*^9}, {3.828964417578125*^9, 3.828964603984375*^9}, 
   3.833858156178323*^9, 3.833859082736682*^9, {3.833859154239219*^9, 
   3.8338591931659145`*^9}, {3.833859229150916*^9, 
   3.8338592389446907`*^9}},ExpressionUUID->"90d52cdb-0458-40a1-9770-\
229946d66b3e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "derivace", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stavRce", "=", "rceStavU"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"derivace", "[", 
    RowBox[{"{", 
     RowBox[{"tt_", ",", "vect_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "stavRce"}], ")"}], "/.", 
      RowBox[{"MapThread", "[", 
       RowBox[{"Rule", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Through", "[", 
           RowBox[{"xvect", "[", "t", "]"}], "]"}], ",", "vect"}], "}"}]}], 
       "]"}]}], ")"}], "/.", 
    RowBox[{"t", "\[Rule]", "tt"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nBodu", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nUseku", "=", 
   RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"N", "@", 
    FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krokEuler", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "stav_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "der", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"der", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "stav"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"stav", "+", 
         RowBox[{"\[CapitalDelta]t", "*", "der"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocStav", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"0.", "&"}], "/@", "xvect"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solEuler", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krokEuler", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vystupZeStavu", "[", 
    RowBox[{"{", 
     RowBox[{"tt_", ",", "vect_"}], "}"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"solVystRov", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Rule]", 
         RowBox[{"vstup", "[", "t", "]"}]}], "}"}]}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "\[Rule]", "tt"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}], "\[RuleDelayed]", 
        RowBox[{"Last", "[", "vect", "]"}]}]}], "}"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystupZeStavu", "[", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodyEuler", "=", 
   RowBox[{"solEuler", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"vystupZeStavu", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"bodyEuler", ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", "pl1", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "RungeKuttaStep", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nBodu", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nUseku", "=", 
   RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"N", "@", 
    FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RungeKuttaStep", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k1", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k2", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k3", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k4", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          FractionBox["\[CapitalDelta]t", "6"], "*", 
          RowBox[{"(", 
           RowBox[{"k1", "+", 
            RowBox[{"2", "k2"}], "+", 
            RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solRungeKutta", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"RungeKuttaStep", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodyRungeKutta", "=", 
   RowBox[{"solRungeKutta", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"vystupZeStavu", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"bodyRungeKutta", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", "pl1"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.828959917953125*^9, 3.828959922171875*^9}, {
   3.828959952484375*^9, 3.82896001953125*^9}, {3.8289600749375*^9, 
   3.82896014909375*^9}, {3.828960209515625*^9, 3.828960287125*^9}, {
   3.828960533171875*^9, 3.828960642484375*^9}, {3.82896070434375*^9, 
   3.82896072878125*^9}, {3.8289607653125*^9, 3.828960887171875*^9}, {
   3.828961069671875*^9, 3.828961365015625*^9}, {3.828961397875*^9, 
   3.828961440515625*^9}, {3.828961471171875*^9, 3.828961503328125*^9}, {
   3.828961617171875*^9, 3.828961711859375*^9}, {3.828962215703125*^9, 
   3.828962216609375*^9}, {3.828962409734375*^9, 3.828962428828125*^9}, {
   3.828962461453125*^9, 3.828962538453125*^9}, {3.8289625705*^9, 
   3.828962571984375*^9}, {3.82896261628125*^9, 3.82896263178125*^9}, {
   3.828962673984375*^9, 3.8289626848125*^9}, {3.828962734765625*^9, 
   3.8289627625*^9}, {3.82896283053125*^9, 3.828962861328125*^9}, {
   3.8289628974375*^9, 3.82896291571875*^9}, {3.82896303784375*^9, 
   3.82896304865625*^9}, {3.828963189765625*^9, 3.828963237453125*^9}, {
   3.828963282296875*^9, 3.82896331290625*^9}, {3.82896338734375*^9, 
   3.828963480296875*^9}, {3.828963583078125*^9, 3.828963638890625*^9}, 
   3.828963734609375*^9, {3.82896380328125*^9, 3.82896384146875*^9}, {
   3.828963906171875*^9, 3.828963982921875*^9}, {3.828964035390625*^9, 
   3.828964035953125*^9}, {3.82896407128125*^9, 3.828964083375*^9}, {
   3.828964173171875*^9, 3.828964295171875*^9}, {3.828964329640625*^9, 
   3.828964368421875*^9}, {3.828964417578125*^9, 3.828964603984375*^9}, 
   3.833858156178323*^9, 3.833859082736682*^9, {3.833859154239219*^9, 
   3.8338591931659145`*^9}, {3.833859229150916*^9, 3.833859233326742*^9}, {
   3.8338593125867915`*^9, 
   3.833859328893243*^9}},ExpressionUUID->"755cd484-404a-4626-be00-\
01e473739b42"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQ5qpBJ3Lhd8Zr9dcamiZ/15ewj/mz3DicYVyi+v
2t+9zHHatpfBwSMu++SJuHNQeTYHU9v5U7TqZu+XBnGncTscaHf4EHfkyn6I
egEHt2+SehFX7+/X+W5yqMhf2OF9/sZpfLq390P0izlsPLipRUhg6/4ztr0b
7lyWcPjjtbI+5vBtexmwedIOpQcuyP16/tY+p+XpPLcIOYe9a9Rjo7w+298D
m6/gkCN7Y5dt2Uf7NpD0O0UH69/SR/2YHtnrge1TdtC3nj71eO6F/ddAyjeo
OEiqx9seeP5xfx3YfjWH8oa/hr3Tf+9XAztQ3aH8/HeLdJ6/+8+B3aPhEPTm
A/M88y/7y/yVgSq0HOJsVHfEee7fLwd2n7YDw04W4WX3vtofKwIp0HEwXpoX
LdzB5pAHdq+eg5yj8mV5Mz4HsWnVQBv1HdLu7BZcuZvP4T7Y/QYOD3RNFY4q
szlsvgMSMHT4eNAxbUfYI/t2sH8MHb5IT1v/QJn5QPS7TKCJRg5qe2QalpwR
PaAP9p+xA/fy4uVtO+QOMINj0cQhivv2jzQ7hQMA7lfU+Q==
       "]]}, {}}, {}, {}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3k4FF4Xx4WUdWYsJctYYsY6Q2lR6Z5slRQJ2SpJkWwpEUpFJSRJSBFC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        "]], LineBox[CompressedData["
1:eJwVlHs81dkWwI3UvTVqwiEcnD0zxiuNOb+N3mY5ntFVSUzoeEx5poyQK0pe
n8jjUCmHKMmYSB5nZkxNLMbV6ISI5FVNroyuig51DjXub/7Yn/35/rPW2t+1
1v408LD7AWUlJaXv2PP3nT/O2LuH8MHx25cT45l1zXskvwluhfLB0ybRNjzo
5+bUQbOaxcN8+PiTEvHe339vtj10x0ctgw/TRTONWqfGmkv1Ag3vzfHhtMXN
lFJzFTT87fsCNx8GlMWx0WbeathlLi8f8WXAyc5oSB6jhnEFzg1hQgb4ErF5
U54aSkMnu9MDGNji6jdu3qGGUavXLm8OZqDJ4XHLufXq2Lyv5phFNAMyk5e9
Eeoa6C2X+K/OZuCs6U6FoomDKoFLD5fkMDC61TXJbZCDNdI9ieYiBh7Gv3A8
K+PgR6VvC53PMOBinDb0xlgTKx02PEgqZKD2B5+V73I1cS7/lsPMVQa+2RGl
I/PVQtG6VrPeJgYeWSRsjp5cg5UbfJYnIwOt1d4NZUu0sdludoLfyoBkzfR0
o742vtprdDXvPwxYzzp1Fe3SRtf0TN6ue2z+2UunLBu1cdkTd879QQbccgsa
EpN08Jho7EPnLAOTm99yOxd0Mb8oYSTxLQM+c1plSepcvFaheWudnIHisvx4
jikXH/3qFJe9wEA5PLMa2cNF68mqN9uVKZgYe/iNX+fitG30hPQTCh0e7W+u
eelhkEylp8OMwgW9/06GivRReM2+y9ecwrPOHo3jl/XRMyBV+nodhepJrkdk
vT46di9p1+RTsAvPFr56oI9GVcq3AtZTWNV4MsdV0wDHA5WuKuwomGvJNgTm
GeCIDpRlOVC4tmF4i+CSAfbdP1HKc2LjJwuPfagxwDabxUIHFwor82xnVe4Z
YLnuXzl5Oyk8d1r62l2Fh/t7F+JM91H4efBPo7YIHvpmbI79VUjhlM6qGUE8
Dz3g2JEd/hSkWkF8cToP7WvmI2K+peB/QhDcU8JDw0xFYEsohYNynel9nTzU
s93o7xFO4cv5hIaiRzzkyOP2TRyksCJg07naMR6qBMm9VkZS4KTprPBT8HDM
9t32vbEUbGK8Vh1QIzgkt3aZOkrBp/UHXaEWwd4bsU4n/k1hozJZJeASbNV/
a3s1gYKv03Wvu4YEyxSz1jPJFNT7TlgNWRMU11papqZScL9Xt8lkM8H84Gj+
mnQKy/dZpfh/TTC5X7Z2awaFplpxdq4TwcC6NyQjl4Jq2D2vcU+CB5N3v3fJ
o1D6ND7lpTfBmN2SAdUzFObDs7oHhQRPzcXkiAooKL0jvsIgNn77w1D3CxRS
hs8GvQ0lWHR+vQNHTKGQ7/ZFVATBmo2KhfMXKfipST040QQbV3gP7C2l4Gx1
TLTpKMGW4Zv13Musv3wXLft4gn2JCaGl5RQ0XqWeV0oiOOo2ah9QQaHiyB/C
hmSCz3k25PPKv98L/9yWRlDRsviwoorCdJmvWC+ToPIZ//qQ6xS+aNLe6Z1F
UHV/S7bZDQpxlwdOxucQ1LT6LHSqlsKB0cNaiSKCBstS7GvqKehtGJ4NyCdo
MjDGi5RQELyzVjE9S5Bfab/A/4nCSdO2tb3nCNq7LKv/8RcKIF0bcPcCQTdu
cPbRWxQejm610RET9Jq6E7LxNgVm60zPtiKC/rdN7BeaKDxZb6PiW0wwLCeD
dxsp/FEquL3jIsFovxfzx1tZvxqCccMSgolfuT6ENgo3tlXsH2Y5/aPqOuV2
CiLPxc+PlBIU9apmt92h0KdYojrFsvhKREh6BwXZeN5Sx0sEr0R32TlLKfy5
vEaRxHK1gwVvRSeFmqHUnmKWf9ISzUu7KFwqDostZBknpvuz71N4VD3cE8ty
R+Ouuh29FELuJnRastybUZ+l1sf214+7+wGbb8RbI+RBP4Wqu9e3u7P8fG20
3bkBCsaVu8vr2Hpfv+8z8BqkEK/raT/Dvk/eaTWvPcz60TBZo8aycmlB/9AI
W19J0D/UWB8fR76rLX7M1mM8uDjN+uPYfpMlfEohoO27/9UWsv1R/yWYPKPA
P/6vH3eyvo3HdOyejbH/S6HE+X4Bwa8k8Qbl4xSWPNXNs2D7syltWHFggkLU
c178oTME7Ty39BtPUnjllfs6K4/gduOLtZMvKIi3BIxm5hL0lH84XTVF4azg
pkVINkG/DmFwxCsKd5ZO9RqeJhgVTgxmZth9zlRu2pxOMGHLSUW9jMLjuogn
51IIpq181hc9R8FS1qTSzc7rhRtXTsvlFNwc9VY/Zue5LEkl+OY86zPs054G
dt6rdh0QJLynkO+z6BrC7oPks3Z9m78odEsqDy1EEmySGSkWFym0S782jmD3
5/+C4VMx
        "]]},
      Annotation[#, "Charting`Private`Tag$2787#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20.00000000000001}, {-8.121879364718257, 3.841631067796288}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473430225958905`*^9},ExpressionUUID->"ad39e4fb-0c8d-4468-a45f-\
13d713d86fca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   FractionBox["1", 
    RowBox[{"p", "+", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pr", "=", 
   RowBox[{"kp", "+", 
    FractionBox["kI", "p"], "+", 
    RowBox[{"kD", "*", "p"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "-", "y"}], ")"}], "*", "Pr", "*", "P"}], "\[Equal]", 
      "y"}], ",", "y"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kp", "\[Rule]", "2"}], ",", 
    RowBox[{"kI", "\[Rule]", "3"}], ",", 
    RowBox[{"kD", "\[Rule]", "4"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.847340079203125*^9, 3.847340137796875*^9}, {
  3.84734024359375*^9, 
  3.84734029075*^9}},ExpressionUUID->"a5e583d2-26ce-4ddd-81fb-11804a690584"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "p"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["p", "2"]}]}], ")"}], " ", "u"}], 
    RowBox[{"3", "+", 
     RowBox[{"3", " ", "p"}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["p", "2"]}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.84734026165625*^9, 3.847340291015625*^9}, 
   3.8473430226805377`*^9},ExpressionUUID->"f203224f-f713-499f-bc66-\
13b7dbbfd7f2"]
}, Open  ]]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.9000002145767212`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 4238, 99, 884, "Input",ExpressionUUID->"5fa707fc-d7d8-4d2b-8f11-060f7a8725d4"],
Cell[4821, 123, 1006, 28, 77, "Print",ExpressionUUID->"0c5a5c9e-eab9-4a78-b168-ea632f85f313"]
}, Open  ]],
Cell[5842, 154, 3108, 84, 578, "Input",ExpressionUUID->"35ec799e-394c-4f76-ba51-f2d125ac3fb6"],
Cell[CellGroupData[{
Cell[8975, 242, 159, 3, 77, "Input",ExpressionUUID->"ce328250-3f5e-4caf-8983-0c3f1640fc9e"],
Cell[9137, 247, 966, 32, 123, "Output",ExpressionUUID->"da9a5c10-baaf-4f1c-9d77-071b2a844ec7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10140, 284, 2525, 53, 351, "Input",ExpressionUUID->"1c06ef61-64b5-4623-ac17-c5a0254cc5f5"],
Cell[12668, 339, 592, 17, 43, "Print",ExpressionUUID->"ee36e6f2-14db-459c-b144-51d9f0902d84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13297, 361, 2535, 59, 203, "Input",ExpressionUUID->"4cd105d5-6cbd-4daa-908b-9d6a1444a731"],
Cell[15835, 422, 1358, 44, 137, "Output",ExpressionUUID->"a856e7f2-fd15-42e1-b09f-93df0e0fcf10"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17230, 471, 1993, 41, 203, "Input",ExpressionUUID->"312f7090-f9f5-45a8-85d2-a2f7bbe40abd"],
Cell[19226, 514, 898, 25, 43, "Print",ExpressionUUID->"b9577227-bf20-4145-8629-afe43e970aa4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20161, 544, 2957, 63, 499, "Input",ExpressionUUID->"3953e697-68e2-4b97-8f45-a4a6b0a72aa8"],
Cell[23121, 609, 3712, 95, 197, "Print",ExpressionUUID->"caa94d74-621d-4d82-9a98-13e988bcef57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26870, 709, 6011, 155, 803, "Input",ExpressionUUID->"4592c35f-38b4-470d-ad88-7fd77d159afd"],
Cell[32884, 866, 1164, 34, 182, "Output",ExpressionUUID->"7789a942-dc32-41b2-a6c7-00d7155b35dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34085, 905, 2457, 49, 240, "Input",ExpressionUUID->"e3d13318-f691-45be-8362-85e3a45e1c3b"],
Cell[36545, 956, 2816, 71, 222, "Print",ExpressionUUID->"9be1f066-a6a4-47bc-bc34-cebca1a3fb95"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39398, 1032, 4611, 111, 721, "Input",ExpressionUUID->"d7f73dea-6e7f-4418-94e1-378880a3af22"],
Cell[44012, 1145, 37569, 639, 448, "Output",ExpressionUUID->"8f7cf63c-9931-4efd-9990-ceae4ddf1fdd"]
}, Open  ]],
Cell[81596, 1787, 3659, 103, 721, "Input",ExpressionUUID->"0b6a8150-60e0-49c8-8861-08c2cd3df553"],
Cell[85258, 1892, 2497, 61, 536, "Input",ExpressionUUID->"e400178a-5b98-4ba3-b638-d91174eea83c"],
Cell[87758, 1955, 1824, 49, 392, "Input",ExpressionUUID->"e403ec59-42e9-4b46-8710-fa994ce00350"],
Cell[CellGroupData[{
Cell[89607, 2008, 2444, 63, 425, "Input",ExpressionUUID->"3fa1b32e-b24a-495c-a2c0-f8d9c8525003"],
Cell[92054, 2073, 21483, 373, 450, "Output",ExpressionUUID->"0a08d63d-9be0-48c8-ad4e-148b454b26d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113574, 2451, 4483, 117, 1063, "Input",ExpressionUUID->"61c181e6-52b4-4f4c-8add-8147689f12c8"],
Cell[118060, 2570, 20251, 352, 448, "Output",ExpressionUUID->"3842f8ed-e417-4c09-9a1c-1860f4104463"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138348, 2927, 8839, 233, 1494, "Input",ExpressionUUID->"32526242-9348-4bdf-98e3-275d85e8ec78"],
Cell[147190, 3162, 952, 27, 77, "Print",ExpressionUUID->"acfc375e-873b-4ad2-b94e-9b7635ee3dec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148179, 3194, 94, 0, 77, "Input",ExpressionUUID->"b3c1e7b9-3344-418c-a62b-c0a258211cdb"],
Cell[148276, 3196, 2407, 79, 320, "Output",ExpressionUUID->"dcbcac4f-4ef4-44d3-932d-1e31f9c22a84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150720, 3280, 200, 3, 115, "Input",ExpressionUUID->"d9236ba1-8833-4400-85a5-b23746d82ac1"],
Cell[150923, 3285, 1674, 54, 160, "Output",ExpressionUUID->"7f63fa0a-a1da-4ca2-ac32-b2364b131bdc"],
Cell[152600, 3341, 439, 15, 113, "Output",ExpressionUUID->"5a7db650-b8aa-4b00-9429-5d23038c5a0e"]
}, Open  ]],
Cell[153054, 3359, 4708, 116, 559, "Input",ExpressionUUID->"90d52cdb-0458-40a1-9770-229946d66b3e"],
Cell[CellGroupData[{
Cell[157787, 3479, 8720, 235, 1719, "Input",ExpressionUUID->"755cd484-404a-4626-be00-01e473739b42"],
Cell[166510, 3716, 20248, 351, 471, "Output",ExpressionUUID->"ad39e4fb-0c8d-4468-a45f-13d713d86fca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186795, 4072, 1011, 31, 283, "Input",ExpressionUUID->"a5e583d2-26ce-4ddd-81fb-11804a690584"],
Cell[187809, 4105, 540, 16, 129, "Output",ExpressionUUID->"f203224f-f713-499f-bc66-13b7dbbfd7f2"]
}, Open  ]]
}
]
*)

