(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80674,       1467]
NotebookOptionsPosition[     78496,       1395]
NotebookOutlinePosition[     79001,       1414]
CellTagsIndexPosition[     78958,       1411]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Eulerova metoda", "Title",
 CellChangeTimes->{{3.56206718359375*^9, 3.56206719734375*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell["\<\
Iterativn\[IAcute] aplikov\[AAcute]n\[IAcute] v\[YAcute]sledku funkce jako \
argumentu do dal\[SHacek]\[IAcute] iterace funkce\
\>", "Subtitle",
 CellChangeTimes->{{3.4631664665625*^9, 3.463166485484375*^9}, {
  3.46316652246875*^9, 3.463166542109375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.562096497171875*^9, 3.56209654825*^9}}],

Cell[TextData[{
 "Nejprve si p\:0159ipome\:0148me, co d\:011blaj\[IAcute] funkce ",
 StyleBox["Nest", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["NestList", "Program",
  FontWeight->"Bold"],
 ", kter\[EAcute] budeme pou\:017e\[IAcute]vat pro na\[SHacek]e v\[YAcute]po\
\[CHacek]ty."
}], "Text",
 CellChangeTimes->{{3.56206711365625*^9, 3.562067173921875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"g", ",", "x", ",", "5"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"Cos", ",", "x", ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.463166565046875*^9, 3.463166566*^9}}],

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"Cos", ",", 
   RowBox[{"x", "=", "0"}], ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.463166574796875*^9, 3.463166580328125*^9}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "x", "]"}]], "Input",
 CellChangeTimes->{{3.463166610984375*^9, 3.46316661478125*^9}}],

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"g", ",", "x", ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.463166596625*^9, 3.463166597125*^9}}],

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Cos", ",", 
   RowBox[{"x", "=", "0"}], ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.463166630671875*^9, 3.463166648125*^9}}],

Cell[CellGroupData[{

Cell["\<\
Nab\[IAcute]jen\[IAcute] kondenz\[AAcute]toru p\:0159es rezistor - numerick\
\[AAcute] metoda\
\>", "Subtitle",
 CellChangeTimes->{{3.463162603328125*^9, 3.463162610140625*^9}, {
  3.463163212828125*^9, 3.46316322025*^9}, {3.463217235296875*^9, 
  3.463217237828125*^9}, {3.46321727728125*^9, 3.46321728065625*^9}, {
  3.463217314296875*^9, 3.46321731803125*^9}, {3.4632185086875*^9, 
  3.463218512265625*^9}},
 Background->GrayLevel[0.85]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0009o80@0006`0002J0000W@4007T7000D1`00
5`D00;@=001B@@00mc/00215CDH00040b9l00:<3000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
X`4009h4000i1`00@`H000000016000060<000`30015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000T@0000h00000Q30f`00003N000000000000B40200000P00008000000011
0P00000000024<3K000000000?l8@043T08008@200024<3KAP000000001Ec@Y404:TA03H2dAE]JM4
0>@9A02F[dAEc@Y4E@VcA:Zf2dBZO;I4Z/89A5G[]dAEZA14ENFhA02@5dAEgkU4ZUhRA5GU^4@053A4
ENFhA5G9ADAEiKQ404aUA5GU^4AEjGY4ENFhA5E3R4AEiKQ4ZQbDA5GO^DAE0i]4ENFhA03ZXDAEjkM4
ZU:TA:Yf]d@0c:I4E@VcA5E5ZD@0W:i4Z]2XA018XdBZbZU4EEFNA:[4ZTBZHYU4ECV[A03jUTBZ^:a4
ZWZEA00h[TAEni=402JaA5GkTdAEYK94ZWZEA:XT]4@0nYI4EIVdA:YRVDAETkE4EEFNA5F=]T@0B:=4
09jfA02L[T@0T[Q4E@VcA026^TBZM[M4E@^kA5G[]dBZK<54ENFhA03>adAEgkU40?kHA5Ga]TBZj]i4
ENFhA5GGi4AEfKY4oe7TA5E5`TAEenA4Z[k4A:YLiD@0><M4om_VA00hadAEjN54ZZc7A:[fg4AE8LQ4
EF_MA:Z/adBZB<M4ZZc7A00V/DBZ[<M404aUA:Z/adAE4CY4ZZc7A:[F3TBZ[<M4ZZHFA5DQb4AEc@Y4
ZZc7A03XoD<0><M4ZQ[`@jZbaTAE=NI3Z[k4A01@g4>Zb/94053L@eE;`DAEOMY30>BkA:ZZf4>ZO;I4
EJgB@jXdZDAEOMY304:TA5E=hT=ECim4Z[[o@eEEWT@0d0A4EEFNA:[22DAEEIi4Z/89A:[>X4AEc@Y4
04:TA0030`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`<30h<001E00@0@000010000000000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
<P0000000000000000000000000000009@0000`0000100009@0000`000050020E@0003@1002R0@00
W0@003T700141P00AP000:`R6E;^8]=CLB;3Ej`ROEWV8SMKJB;^Fb<TJecL9NQLT2Q[G?d/Jea[<F]L
BcU[G;<nJe`JA6]L1d[XG7Y=Jec]D>iK8U:dFeiCOEVKE4IGHEBLDMiD8dmKEJY<UEEeBeEF]TXDEoI9
ReSfBD]I]TX;FWE;AEZZC<9J8dloFiaAAe]6Ed5LOETkGKAKOUg^FjmPJecOHnQLMfaaFfi_JeaTLVEM
8G8KHFAbF6:WLYASIW>DHne`cf=dKPUT[Vk?HieScf>;F<mSBcW?Hgd^cf>^8lmSXRD9I:`Rcf>e7iAS
o1eBHklLF6:26eiQPQ^NH4PKjUd>6cMKCQZCE4PK6E927:1?l1lSCb`Q8dmY8R=?JB9PD:`R6E8U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0005@4001S0P00Q`H002`400000000AP0000P2003l0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00P940000>000008@`=/00000
gP000000000004Q00P000080000200000000@@80000000000Q30f`000000003o24030h01001d0@00
0Q30fbP000000000EQFHA5DY7D@0l:14ZQhLA:_j^TAE@AU4Ze[4A5DY7DB[^/e4EA4QA:^Xd4AEjBm4
03C@A03L=4AE_lm4Z/hiA03Pa4BZcSU4Zfc1A02h>TAFnKe4EJ4kA5Ko_4AE^CM4082kA02h>TB[0;Y4
Z[HmA02<^D@0U41409:hA5E]C4@0V;M4ZTIHA5J7]dCodgQ4EY>eA5GGP4AFWk=4ZTB5A:^/[TAEaH=4
ZkR/A5GGP4B[a:Y4Z]9kA5HoZTCo1fQ4ZlZYA:XRGT@0EZU4ECeDA:^h[4AEKDa4ZlZYA5FAATB[g:I4
EKE0A008WDBZ]Se4EQFHA02h>TB[8Y=4EKTgA5JkSD@0a3Q403b<A03L=4B[_8Y40?@`A:]6SDBZ3RM4
ZcZ?A:XV8dB[;Y54ZShOA:/jSd@0=1i4EQFHA5DY7D@00`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`>35D030100000400000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000000@0b0000
000000000000000000000000000U000030000040000U0000300000D0081E0000_0000584001R0P00
R0H002d4000X00000da39g1@02MfGDTV9V939mIV?BQ=J?<[4VP_;MQWK2iXHV`^[f2V;_ENhBihG^L]
^5fV;_ULIRnnG1d`@E`D<lAK2SJlFbdn`UYT@<QIVd9?Em]1EEIT@5]EkChHEOXigUB1=j=D23EEEQ@c
gUBM<FMC9S1lCVH_0dbV;XY9ibgFART^5TH_;EM5=BbLA[`YUTO2:918b2NFAhDW0da39bD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000X`4005L2000I0`00f@<0000000160000J04005`10015CDH[
:T0002@0000H00000020?`00080000200020?`000800002024040T@0000h00000Q30f`00003N0000
00000000B40200000P000080000000110P00000000024<3K000000000?l8@0D3h0000=@000024<3K
5P000000000]UCi4liLWA0EQ=dA<;B94m/8EA:]25TC=<@Q4;cTGA4Q1mD>c;aQ4YAGQ@f677dAmhMU3
JB4]A5F]dT=b^cY4bXoK@n@NGTBi[nA30A=YA:O?kD<N1gA4^IL4A5KEMDC=<@Q4N9a^A>7;2dBJHfM4
YOd0A1>VATC=<@Q4;H0mA?EU3dA7FSA40jLZA2FC>dCbaS=4]_HgA>3V?4A7FSA4ELU5A9T2;D@]UCi4
liLWA0030`<30`<30`<30`<30`<30`<30h<001E01@0@0000100000@0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040<P0000000000000000000000000000009@0000`0000100009@0000`000050020
E@0007@0002R0@00EP8001X3003J0`005P0009h_gRWA;H@XJBF99@DRabFQ7P@V6acJ9cDK@B]>6ZL^
JQ^0=hhL?CZb7OXl7R5^?@DRX3_[8]4i>22R<@DRFBoB8`l]XR[M;^X/mRdb;`l]Jc4i:ih_gRTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0007l1003Y0`00N@800>8400000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q01P>@0000Q000008@`=/=0000
0000003XoD>[dW]4Xd7M@j_BNdB[b/9358N4A:_:`T>[/8a4Zl[2@d;JU4BS@Me307RKA03XoD<0N9]4
;dL?A01hVdB[PQa4@]ZDA:^274B[/8a4Zh8LA1B7Q4@_A`m4Zm9kA03XoD>[dW]400<30`<30`<30`<3
Ph4NA1A01X0@000010000?oooolQ000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0002L0000H00000@000000003oool0000002D0000<00000@0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@000;DOkCjQ6ndnDQPl@U8HDDIB66I:
XA^dCKDO]4g:8kA=6BMVBQTWDDHI9ca2bR?]?[DOkChl0000200003h0000H0000Q@400>h3001b0P00
g0@001<0000<00000@0002D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0004H0001T0000F00004E=AR/8@0L2A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE01P0@0000100000L0000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000010<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000O@400>L3001i0P00
h`@000d0002e7ndnXA_]?U8H?49B6556DQQVBZ4K]4fe7kA=bR>dCATWITXI9e566BLl@/XSkCje7ndn
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000DP00070100020000J_ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^000000000000002<B1P10@000000000000000000000000000000
1`0003CfTP20cY80Z5SV<8a8605/2QP15000052h4`000000O6dH0@4000010000D;PC04N9k3000000
O6dH0@000020cY80a4TH0@00001lKAP1H00005bh4`1/F>H`0@0000000002000090lH0N2h4`2dhI80
00000000003oooooB93/<?B:605lKAP1c;TC0040000ed`4`4;hC0000002`HaP11@@H0@D4607AO0d`
E@0000D4604001<000000000000/^A<000000000001lKAP1;;TC05j=k31lKAP1000001Bi4`0T^A<0
00000>1C605/2QP1I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000000V@9D0000E0000<H1000G1000<@800<0400010000EED7@GI01d760@00W@@00040001<0000
0000000000000000oooooooooom@0000E@0006`0000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P000?D1002e0P000`800?H300000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0208h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o24090b`0000P00000Q30f`8000000000
0>Sm@eFaNd@0j?e3Z]h^A0010H4E@0T0400000@0000800008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
m0400;<200030P00mP<00080002e7nDn]An`:bD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
m@400=@400030P005@H0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240:0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@0/3;000020000024<3K0P0000000000j?e30<31A03XoD=EIi]40041PAE02`0@0000
100000X0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E`0002@0003d0@00d`@000<2000E1P000P000;DOf62e7ja=
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80003e0@00]@8005d700330P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0`2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q03@</00008000008@`=/20000
0000003XoD>[gRi4ol?ZA000;d@00@615D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081G0000
90000?@1002c0P00G@L00<<200020000]An`:eYe^2/U0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000?D100071P00G@L001D600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q03P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240?0b`0000P00000Q30f`80000000000>Sm@`30`DCo`nY40<31A0010H4E@0l0
400000@0000>00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000m04000H6001M1`005@H00080002e7mQP
FWGHH2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000=`L009d2001d1`00fP80000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240@0i0000240000
0Q30f`d000000000Z[_ZA:/2:DCD6>U4Z`8YA5G5idBXZB]4ELGWA5K_;TAEaNM40cDbA=@HjD@0g3A4
Z[_ZA03L=4B1G^a40=`dA02bkD@3=C940;;]A5K_;T@0/^e4Z:T[A85Nk4B[0RU4Z[_ZA:/2:D@00`<3
0`<30`<30`>30000540@P10000040000ooooob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000
D000000000000000ooooooooool=0000EWDi:XEd>B[KLn<Zfg>d:m]cQRb5M2l]EWD_;BQf;bgAMXH/
dGJd:m5fhbXXMSTZEWDi:S`000080000?P0001P0000m1`00X`8006h7003C0P004`0000`000010000
9@0000`000000020900002@00000081100000000000008110000000000020000AP0006@0001H0000
ADe6:`Q04@940000>000008@`=/00000gP000000000004Q10P000080000200000000@@8000000000
0Q30f`00002I003o5D0@0100000400004@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000040b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@000500000f1`00W08007D7003K0P003@0005Ie>BZ5M3TZ
fg?S:]]c]2_KLhH/QG@_;EIe;bdXMRl]dGJ6;=5f]2_AM^<Z:7Hi:UIe>BXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0003L7003`1@00M0L002d600000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q04P>@0000Q000008@`=/=000000000:ZkjT@0d[i4
e1SYA03B_TAEaNM4ObG0A5G5idAEb<54ELGWA2a[`dCD6>U4Zkk4A:ZkjTB[_/A4PEk/A:^na4@0/^e4
;6_3A02bkDAEb<540;;]A7lU`4B1G^a40=:nA:ZkjT@0d[i400<30`<30`<30`<3P`0001A04X0@0000
10000?oooolQ000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0002D0000<00000@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo
3@0005IeHEn5M65Ofg<;H=]cgF3KLjiQQGAHHUIeF68XMUQRdGJ^HM5fgF3AMP]P:7IQGeIeHEll0000
200003h0000H0000?@L00?H5001^1`009PH001<0000<00000@0002D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@1<2A00003P000024<3K
00000=h0000000000018@@80000200000P000000044200000000008@`=/00000V@00oaE04P0@0000
100001<0000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000010<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0001@0000=PL00>h5001e1`00;@H000d0001FMF5OQGAQGm]c2f3KLmePfg>^HHEdF69FMEQR
:7IHH]5f[V7AM]ePdGH;H2QfHEmFMF5O9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000h0@00
^`<007D1000@1@00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@1@2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000003oo`Q05@</0000
8000008@`=/200000000000HZd<0f6m401R[@eE3XD@00@615D0E010000040000500002P0000<0000
0@00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000B0@0@000000000?l00000000000000000000U0000
30000040000W00006000008000000000o`000000000U000030000080000C000030000080000k0000
200001/0000@0000WQD00>hk001I0000:000000000000000ooooooooool30000WQDED1TE5E0I5Nhk
?@0000P0000K000040000><F003MC@00F@0002@00000000000000?oooooooooo0P0005/EWU3D4me=
F00003@00000000000000?oooooooooo1P000<8C_Dg>4iA=kQ>3C@hDLDdg57a=B1BLCET0000X0000
00000000003oooooooooo`<0002F5OA?8AGdCflFW4eH0000=000000000000000ooooooooool60000
P1IlCJTFLDg95X==jAJDCODF_DgS5]e=?@0000P0000l0000200003l0000H0000>P400;d3001a0@00
30D001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000V@0001d4003U0@00
]@@0000000160000500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0
B`4007/2002<B1P100000000l004800060000905l02@1O00600007[gbS1300006000062g4`000000
600000@000010000F;LC03bg4`06m/X`0?mP<A@0001LmLX`?;LC01P000040000d4VB0:e:03002?00
100009XC0S0D0000d4VB09QUDc0001P15P0004`0002D]a<0AQ<2<:0@0ED]01<0=M<1<12n4`000000
/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S2P405E;@0C000000130000T@D2<<Rh4`1lKAP1
n<jB01bh4`1RO0X`>1P:9A2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005@0002J0000=0@00</0002U10000@0005EE1d5f@0M1
VP0008h400010000C00000000000000000000?ooooooooooD00007D0000b00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`1;0@00
N`8008a860400<X`0?mP<A@0001LmLX`?;LC01P000040000d4VB0:e:03002?00100009XC0S0D0000
6;LC0000002h095ld8lJ0>Bg4`11095lB0LE05d0TG`h60XVf8lJ0=R?6P000000/6<H0@00002HIE<`
P;PC07a`BC000000000C00000S2P405E;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1
>1P:9B00000>008`0?SoofAf00P00000>PP2<6SO5`34]a<0GU[cMlBg4`0001D0g>LN02D0001XgaL0
000:020X003H]`40100002Rg4`0m6247I7H02000000U000030000040000F0000300001P0000B0000
30000040000H000030000?l0009D0000E0000<`0000d1000k0000:D400010000EED7@GI01d7<0000
SP@00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC04/1001k0P00
S4PH0@004`11095lB0LE05d0TG`h60XVf8lJ0=R?6P000000/6<H0@00002HIE<`P;PC07a`BC0H]a<0
00000;P0TGc@SaX0i;LC0440TGa81aD0G@2AO3PH2ROHSaX0f8lJ0000001@I1P1>1P:9B00000>008`
0?SoofAf00P000000002<6SO5`34]a<0GU[cMlBg4`0001D0g>LN03GC0C0@_Q<000000?1T607H]`40
800002Rg4`0m6247I7H02000000j208`J=lG0<Bg4`1NF_=ga;LC00005@3djAh09@0006SO5`0000X0
>2X00=Rg0@040000:;LC03dH8@MTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000k@0003@4000:0@00Y@@00040001EE@M1MT07@Nd0002>1000
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0B`4007/2002<B1P1
000C0440TGa81aD0G@2AO3PH2ROHSaX0f8lJ0000001@I1P1>1P:9B00000>008`0?SooaRg4`000000
^02AO=2?6P3T]a<0@@2AO4P75@1M095l>1P::=R?6P3HSaX000000?1T607H]`40800002Rg4`0m6247
I7H020000000008`J=lG0<Bg4`1NF_=ga;LC00005@3djAh0=M<1<12n4`000000T6DH0MRg0@0P0000
:;LC03dH8@MTMP08000003X80S1XgaL0a;LC05iJlgO4]a<0000E00c/7P0U0000J=lG00002P1@;000
f;L100@0000X]a<0?APQ1fAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@000090@00=0@002T1002U10000@0005EE1d5f@0M12@4008h400010000
C00000000000000000000?ooooooooooD00002T0ID<Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`8000160`00iP4003@4001n0P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`2`0000DP4008a8604001<0
i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
0;?k0000TP2HIE<`D6@H0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0
O719<000000001<0>PP2<:0@0ED]01<0000004<0002A1@8`b;PC07a]6060cY807;PC069l2S0f60Xj
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000000009D0000E00009d3003m0@00fP<006h200010000EED7@GI01d6N0`00E`800040001<0000
0000000000000000oooooooooom@0000DP1/ICd0000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P0002P300260P00D@@00?8200000000AP0005P0001<0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Y0080T000060000?ooool10000
ZlI;A:XV8dBZZXe3F9Fm@RP0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00002000000000?ooo`0000009@0000`000020000
9@0000`000080020EP000300000^0`00S08004X4003[0P001@000>Xb`RSZ<Zl^WdB_;Ym4`RSZ</8X
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
AP0009`0002@0000ADe6:`Q05P900000=000008@`=/00000eP000000000004Q10P00008000000011
0P00000000024<3K000009T00?l8@1L3?000030000024<3K10000000002[aT]4EMTjA01>RDAEfCY4
04j9A:XV8dB[aT]4ZRHSA0010H4E@1L0400000@0000F0000>P0000`000080000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000P0@380000
00000000V@00000000000000000U000030000040000U0000300000D0081F0000;0000?@2001B0P00
Q0@002D300040000jS:_;Ym4[bjOA<8XjS;2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@0003X0000<00002P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<200004PD00404003Y1@00R@@0000000160000:00001`00017A4U30P00018500101000
j@D005X400000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0608h0000;000008@`=/00000V000000000000<Q10P000000044000000Q30f`00002I003o
240I0b`0000P00000Q30f`80000000000=jSA5FQRD@0P;]4EJ69A0010H4E@1T0400000@0000H0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P0000000000081090100000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5L0000T000040D003l4003Y1@00F`@00080003WDLU4^5g9A2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<200004PD006l4003Y1@00R@@0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240J0SP0000/00000Q30f`00002H0000
00000000b44200000000@@0000024<3K000009T00?l8@1/3;000020000024<3K0P0000000000gZ=4
08j?A020^d@0SXm400430aE06`0@0000100001X0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000100009@0000`000050020E`0002@0000@1@00
KP@00>T5002:10000P000>MA_dNhGKm79@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000B1@00
@0@00>T5001J1000000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@1T0400000@0000H00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T000040D003l4003Y1@00
F`@00080003WDLU4^5g9A2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<200004PD006l4003Y1@00
R@@0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0K0100000400006P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000040000U0000300000D0081G000090000105001^1000j@D008X400020000
ie6oAkQM_dLU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0007L5002e0P00Q0D005@400000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0708h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240M0b`0000P0000
0Q30f`8000000000EKN_A000;dAE]jm40;:9A0010`<E@1d0400000@0000L00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000@0002D0000<0000
1@00P5L0000T0000MPD00;@200251@00E@@00080003DEkP[e5OAA2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000M`D007H400241@005@H0000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240N0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@1l3;000020000024<3K0P000000001E]jm408j?A5Fg[d@0`<54
0041PAE07`0@0000100001h0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0001f1@00M0@008D5000E1P00
0P000=AG_dODEmQP9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001O1@00l0D009`5000]1P00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@203
T00008@000024<3K3@0000000000[jm40=:nA2X<[T@0d[i4ZkR/A7lU`4B[^:a4ELS1A:^h[4@/Jl=4
:Pb^A:^na4@0[jm4Zkk4A=MA/DB[_/A4EZFbA2a[`dAFYK94ELS1A5JU/TAo9L14ee6aA03B_T@0[jm4
0=:nA0030`<30`<30`<30h<0000D@220400000@0002I003o:00000`0000200008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000
002I0000000U000030000080000C000030000040000k0000200005D0001@000000000000003ooooo
ooooo`d0003@Ef5OoeIQGeEF2f1EE]ePEEJ^HOmFF6;@EeQRXEQHHT]I[V5;FMePBeT;H:5HHEo@Ef5O
?00000P0000n0000600006D5003f1@00U@D002H6000C000030000040000U000030000000080T0000
90000000P440000000000000P44000000000008000160000I00005P00015CDH[240Q0T@0000h0000
0Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K000009T00?lE@200
400000@0000Q0000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000000@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000D00005h5003^1@00W0D002d6000=0000d5MQGomFHEmEEP]PEEKMH5EF[V7oEUQR
d5MHHZ5HF69;FJiQBeWMH4]I2f2QF65Od5MQGbD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
G`D009d2002L1@00fP80000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240R0i00002400000Q30f`d0000000000:n_A:/2:D@Z3:i4Z`8YA:^h[4BXZB]4
ZkR/A5K_;TB[^:a40cDbA2X<[T@0g3A40:n_A03L=4CGDK540=`dA5JU/T@3=C94EZFbA5K_;TAFYK94
Z:T[A=MA/DB[0RU40:n_A:/2:D@00`<30`<30`<30`>3oooo540RP10000040000V@00ob4000080000
HP0000`000010000900002@00000080m000000000000080m00000000000200009@0000`000020000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000d5Li:_mF>BYEE^<Z
EEJd:eEFQRcoERl]d5L_;J5H;be;FHH/BeVd:d]IhbZQF3TZd5Li:S`000080000?P0001P0001U1@00
X`8009D5003C0P004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q08`940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0R0100000400008`0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000100009@0000`000050020E@000500001N1@00
W08009`5003K0P003@000=1G>B[oESTZEEKS:UEF]2]EEXH/oeH_;M1G;bfQF2l]BeV6;4]I]2];FN<Z
XEPi:]1G>BXU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0004T4000E1000>0D00:d400000000
AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0j;XC0;00001B0@00
S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000004<00000b?/0002B09QUDc1@I1P10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000
V6EC<82h4`1lL4T`000000004`0j208`X101EBd04`000000@`0009450S38^1<0O6dH0H3>TP0L^1<0
HW`:<3HH2TP@_Q<03P02<03hoomTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000000000U@0001D0000W`@002`4003S1000W@@00040001EE@M1MT07@Il400261000
0@0004`00000000000000000003ooooooooooe0000130000@`0001H0000<0000000002D0000<0000
3P00P2P0000<00000@0004H0000X0000700004M4BD<20000S08001H3003]0P00[0D0000000160000
@04003@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240T0Z@0002H0000
0Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010D<24<3K00000000ool8@2D3F00004`000024<3K1`000000000h:2U4
EI56A:Ik<d@V=eE4EQ4jA9ISM4AF4CY46e2;A5HA>TAD;Ia4/J`cA4jDZd@NU2U4E@VcA0030`<30`<0
5D0U010000040000900002P0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000W00006000004000000000o`000000000U0000
30000040000C000030000080000k0000200001/0000@0000NbX007Pa001I0000:040000000000000
oooooooooom30000^2[C<ODZ=S9Z:`dcfB_j<d0/oCBQ;14fnb`i=dh]LCRH;KXig2dA>aL^MCa:;^Dm
M2iP?iD^iD2];W92^bh6A<0^XDFk;SA7[Bk3B9H^BTYf;/Y;CBi0CA`^ZdkR;@a@XRePDEP]YE88;M]C
/B`1EE</5UK^:aMGPB/5F0h[gUSL:RmIJb[YF9TZWeP8:liGLB_VE]@[jeDb;=aDQbbjDmH/R58O;DMA
GbggCiL]VTk8;C5=lBfoBa4^@dXX;[i8=RhcAc/^XTDf;P]4:2ik@Q0^l43_;FloaBgg?I@]RSaI;BXk
5RgG>Ld/U3Ql;60g92`n=/D[;SEP:c<dmBY<<h@ZOC99:Qhb32[3<Cd0000800006`000100000K;@00
meL005T0000T000000000000003oooooooooo`80001K:X5IPBYKEUP0000d000000000000003ooooo
ooooo`H00022:SMFXRXJE/HZ75K[:QiF22/mEPH[HEII0000:000000000000000ooooooooool30000
iRX?FH<ZdUSJ;8=GF00003@00000000000000?oooooooooo1P000?X/LELS;GaG=BfLEdL]_5Lk;NEG
6bggEcd000080000?00000P0000o0000600009l2000F0`00kP8009X5000C000030000040000U0000
30000000080U0000300000L0080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0000d6000F0`00KPH00:`500000000AP000401000d0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q09P:T0000V000008@`=/00000
W1000000001EE@E1o`00008000000011000006@000024<3K00000080000200000020?`8000020000
000000008440080o0000000000000000000002P000024<3K0`00000P00000210002``0000000082o
000P`000/<000@400Q30f`0000000?oo240W0eP0001<00000Q30f`L000000000al34A5FAATAnj/U4
9SMEA5DecDBFHgA4ECG=A1]@RdAE=Le4E2fLA0<3bTA>U:]4^OK4A5D9/d@00`<30`<3PAE09`0@0000
100002H0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000004P4040000000003o00000000000000000000
9@0000`0000200009@0000`0000100004`0000`000020000>`0000P0000K00004000095R001h<@00
F@0002P10000000000000?oooooooooo@`000<iRdc4;HcHbP6<=<nmSnS=GI?dd^6@A=Q9U>CMUIG4h
[fFj>O9U4C/]IWDlH6KU?HYVH3n[I^E0`VIc@]5V1TCFIZ55dFHdAl=V`dR/ITY:S6K:Bf=V@4dcIZ]>
nFD<D;QUH55^IJEB7fGKDlMT0UEYI1IF16@GEiQS1EPUHmiHlf8_FH9RjER`HYmH7f?>EhMSiUKZHn]E
B6CKE9iT^U?/I8QB=FE7DGIUmdn^IIY>gVDaC@MV_d/WIT=:?VJnB4aV<dMAIZ95C6H;A3eVNT8VI_10
1FI_?m]UmcfZIHXlKfDZ>beUecWTI9@hTfAP=c]T?SKLHbheMV<c=0]SC3>JHWdbGf8N<R9R`c4m0000
200001/0000@0000<VD00?MG001I00009000000000000000ooooooooool20000LV:1FIQRFeIH0000
=000000000000000ooooooooool60000VF8gE[UR6UKMHQaF0V<NEQmS?EHMHf5FF@0002P000000000
00000?oooooooooo0`000?eR3eVJH]9HlFB3EeP0000d000000000000003oooooooooo`H0000AIG5G
>VElEdaUW5MNIKaGDVGUEc9UmeLm0000200003`000080000?`0001P0000P1P005P<006l6002J1@00
4`0000`0000100009@0000`0000000209@0000`000070020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003W0P007@@003@4002e1000
000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@00
1`8008a8604001<0i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C0000001300000=Ck0000TP2HIE<`<6HH0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1
000009QUDc20^1<0O719<000000001<0>PP2<:0@0ED]01<0000004<0002A1@8`b;PC07a]607hcY80
7;PC069l2S0h60Y64;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B0000
30000040000H000030000?l0009D0000E00000H3000d1000=`<00:D400010000EED7@GI01d460`00
SP@00040001<00000000000000000000oooooooooom@0000M@000380000F000030000000000U0000
300000h0080X000030000080001B0000L0400080002Loooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00
S4PH0@00H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<0
00000;P0TG`HnQX0i;LC0440TGa81aD0G@2AO3PH2TLPnQX08?XJ0000002`HaP1000009QUDc20^1<0
O719<000000001<00002<:0@0ED]01<0000004<0002A1@8`b;PC03GC0C0@_Q<00000051T604h60Y6
800000h00S00n?ooI7H02000000j208`J=lG0<Bg4`1NF_=ga;LC00005@3XM1l09@0006SO5`0000X0
75D00=Rg0@040000:;LC03dH8@MTMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000>0<003@4001H0`00Y@@00040001EE@M1MT07@CP3002>1000
0@0004`00000000000000000003ooooooooooe00000X00008@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0440TGa81aD0G@2AO3PH2TLPnQX08?XJ0000002`HaP1000009QUDc20^1<0O719<1Rg4`000000
^02AO1Sj6P3T]a<0@@2AO4P75@1M095l>1P:B23j6P0PnQX00000051T604h60Y6800000h00S00n?oo
I7H020000000008`J=lG0<Bg4`1NF_=ga;LC00005@3XM1l0=M<1<12n4`000000l6@H0MRg0@0P0000
:;LC03dH8@MTMP08000003X80S1XgaL0a;LC05iJlgO4]a<0000E001g7`0U0000J=lG00002P0dE`00
f;L100@0000X]a<0?APQ1fAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0001I0`00=0@007H3002U10000@0005EE1d5f@0M1F@<008h400010000
C00000000000000000000?ooooooooooD00007@0000L00005P0000`0000000009@0000`0000>0020
:00000`000020000DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0
@@2AO4P75@1M095l>1P:B23j6P0PnQX00000051T604h60Y6800000h00S00n?oo6;LC0000002h095l
6?XJ0>Bg4`11095lB0LE05d0TG`h60Y98?XJ023j6P000000l6@H0MRg0@0P0000:;LC03dH8@MTMP08
000000000S1XgaL0a;LC05iJlgO4]a<0000E001g7`0ed`4`4;hC0000002@IAP1f;L10200000X]a<0
?APQ1fAf00P00000>PP2<6SO5`34]a<0GU[cMlBg4`0001D067TO02D0001XgaL0000:04aI003H]`40
100002Rg4`0m6247I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000?l0009D0000E00007D3000d1000U@<00:D400010000EED7@GI01d5e0`00SP@00040001<0000
0000000000000000oooooooooom@0000:@000240000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P0006T6000E1000]@L00:d400000000AP0001@000080000
AdA9@`<0001B0000L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0
A6<H0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000hO/0
002B09QUDc3@IQP10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`
000000004`0j208`X101EBd04`000000@`0009450S38^1<0O6dH0B3?TP0L^1<0HW`:<3HH2Ul@_Q<0
3P02<03hoomTMP08000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001D0000R0H002`4002i1P00W@@00040001EE@M1MT07@HP6002610000@0004`000000000
00000000003ooooooooooe00001e0000<P0001H0000<0000000002D0000<00003P00P2P0000<0000
0P000580001`0@000P000;goool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO1Sj6P3T]a<0
@@2AO4P75@1M095l=QP:H23j6P0PnQX000000;1S60400000V6EC<82h4`1lL4T`000000004`00008`
X101EBd04`000000@`0009450S38^1<0=M<1<12n4`000000D6@H0CHH2UlP00003P02<03hoomTMP08
000003X80S1XgaL0a;LC05iJlgO4]a<0000E08Am7`0U0000J=lG00002P2hG@00f;L100@0000X]a<0
?APQ1fAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002
E00005@0002j1P00H`@00>L6002^10000@0005EE1d5f@0M1^PH009l400010000C000000000000000
00000?ooooooooooD00004<0000]00005P0000`0000000009@0000`0000>0020:00000`000020000
DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l
=QP:H23j6P0PnQX000000;1S60400000V6EC<82h4`1lL4T`6;LC0000002h095l6?XJ0>Bg4`11095l
B0LE05d0TG`f60YQ8?XJ023j6P000000D6@H0CHH2UlP00003P02<03hoomTMP08000000000S1XgaL0
a;LC05iJlgO4]a<0000E08Am7`0ed`4`4;hC0000003`I1P1f;L10200000X]a<0?APQ1fAf00P00000
>PP2<6SO5`34]a<0GU[cMlBg4`0001D0W7lO02D0001XgaL0000:0=1O003H]`40100002Rg4`0m6247
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000>L6000/10001`L009d400010000EED7@GI01d7W1P00QP@00040001<00000000000000000000
oooooooooom@0000:0000240000F000030000000000U0000300000h0080X000030000080001B0000
L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TG`f60YQ
8?XJ023j6P000000D6@H0CHH2UlP00003P02<03hoolH]a<000000;P0TG`HnQX0i;LC0440TGa81aD0
G@2AO3HH2V8PnQX08?XJ0000003`I1P1f;L10200000X]a<0?APQ1fAf00P000000002<6SO5`34]a<0
GU[cMlBg4`0001D0W7lO03GC0C0@_Q<00000091U607H]`40800002Rg4`0m6247I7H02000000j208`
J=lG0<Bg4`1NF_=ga;LC00005@2dPAl09@0006SO5`0000X0j6400=Rg0@040000:;LC03dH8@MTMP08
000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
20L002`4000U1`00W@@00040001EE@M1MT07@@P7002610000@0004`00000000000000000003ooooo
oooooe00001d0000700001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@00
0P0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO3HH2V8PnQX0
8?XJ0000003`I1P1f;L10200000X]a<0?APQ1aRg4`000000^02AO1Sj6P3T]a<0@@2AO4P75@1M095l
=QP:Hb3j6P0PnQX00000091U607H]`40800002Rg4`0m6247I7H020000000008`J=lG0<Bg4`1NF_=g
a;LC00005@2dPAl0=M<1<12n4`000000<6HH0MRg0@0P0000:;LC03dH8@MTMP08000003X80S1XgaL0
a;LC05iJlgO4]a<0000E0<b37`0U0000J=lG00002P00I000f;L100@0000X]a<0?APQ1fAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0000T1`00
;0@004@7002M10000@0005EE1d5f@0M190L008H400010000C00000000000000000000?oooooooooo
D00002T0000Q00005P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000
AdA9@`80001>1P00LP8002`7002W0P00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2P2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000100000P000000T400000000000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000X<000000000000008<000:300061@`8@`=/00000
09T0o`Q0:@</00008000008@`=/20000000005E7bTB[9R=4EMOTA:/V8d@00@<35D0Y010000040000
:00002P0000<00000@00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h00000000000B0@0@00000000002I00000000
00000000000U000030000040000W0000600000800000000009T00000000U000030000080000C0000
30000080001K0000C0000506001e0P00:0L00:<2000200002@0000D00004000076Eo:0a`ObP<L0DY
76D5:AaUObS9KgDWI7;2:<U_3b[9KgDW4`0000`0000100009@0000`0000000209@0000`000070020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80000L1@00oP800545003M0`00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2X2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000100000P000000T400000000000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000X<000000000000008<000:300061P@8@`=/00000
09T0o`Q0:`</00008000008@`=/200000000003<YTAE]D140<bVA5GEMD@00@615D0[010000040000
:P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000B0@0@00000000002I0000000000000000000U0000
30000040000U000030000080000C000030000080001K0000C00001l500000`00C@D00=T300020000
2@0000D000040000XE<V<:5C5S/LDaHk75<V<:5C9S2/E=<jGU=^?A5BdcZ/E=<j4`0000`000010000
9@0000`0000000209@0000`000070020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000?0P00LP800>h2002W0P00000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2`2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000100000P000000T4000000
00000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000X<000000
000000008<000:300061P@8@`=/0000009T0o`Q0;@</00008000008@`=/20000000005Ga14B[9R=4
EA4jA:/V8d@00@615D0]010000040000;000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000
0000002I0000000000000000000U000030000040000U000030000080000C000030000080001K0000
C0000142001e0P00jP800:<2000200002@0000D000040000=B5o:2D/ObPU;0DY=B45:CDQObSR:gDW
OBk2:>8[3b[R:gDW4`0000`0000100009@0000`0000000209@0000`000070020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002J0@00
o@800<l1003L0`00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@2h2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000100000P000000T400000000000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000X<000000000000008<000:300061008@`=/0000009T0o`Q0;`</0000
8000008@`=/20000000005EmfT=EeGE4EGgJ@eFe@4@00@615D0_010000040000;P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h00000000000B0@0@00000000002I0000000000000000000U000030000040000U0000
30000080000C000030000080001K0000C00009h100000`00b`400=T3000200002@0000D000040000
1A]^?@DKOS:;6ghbRa]^?@DKKSgk6L0bB1/V<9DL`3;k6L0b4`0000`0000100009@0000`000000020
9@0000`000070020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003S0@00gP400303001f0P00000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0i;HC04AS604>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000>ok0000TP2HIE<`
<6HH0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0O719<000000001<0
>PP2<:0@0ED]01<0000004<0002A1@8`b;PC07a]607hcY807;PC069l2S0h60YR4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H00003000002I009D0000
E00004d2003e0@00J08006H200010000EED7@GI01d5=0P00C`800040001<00000000000000000000
oooooooooom@0000J@0001`0000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00S4PH0@00H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<000000;P0TGc@SaX0i;LC0440TGa81aD0
G@2AO3PH2V?HSaX0f8lJ0000002`HaP1000009QUDc20^1<0O719<000000001<00002<:0@0ED]01<0
000004<0002A1@8`b;PC03GC0C0@_Q<00000051T604h60YR800000h00S00n?ooI7H02000000j208`
J=lG0<Bg4`1NF_=ga;LC00005@0<Tal09@0006SO5`0000X0@7<00=Rg0@040000:;LC03dH8@MTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000
J@800?D100290P00IP800040001EE@M1MT07@FT2001?0P000@0004`00000000000000000003ooooo
oooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO3PH2V?HSaX0
f8lJ0000002`HaP1000009QUDc20^1<0O719<1Rg4`000000^02AO=2?6P3T]a<0@@2AO4P75@1M095l
>1P:I=R?6P3HSaX00000051T604h60YR800000h00S00n?ooI7H020000000008`J=lG0<Bg4`1NF_=g
a;LC00005@0<Tal0=M<1<12n4`000000l6@H0MRg0@0P0000:;LC03dH8@MTMP08000003X80S1XgaL0
a;LC05iJlgO4]a<0000E02BE7`0U0000J=lG00002P1HM@00f;L100@0000X]a<0?APQ1fAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002:0P00
m@400:L2001V0P000@0005EE1d5f@0M1RP8004l200010000C00000000000000000000?oooooooooo
D00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l>1P:I=R?6P3HSaX0
0000051T604h60YR800000h00S00n?oo6;LC0000002h095ld8lJ0>Bg4`11095lB0LE05d0TG`h60YU
f8lJ0=R?6P000000l6@H0MRg0@0P0000:;LC03dH8@MTMP08000000000S1XgaL0a;LC05iJlgO4]a<0
000E02BE7`0ed`4`4;hC0000002@IAP1f;L10200000X]a<0?APQ1fAf00P00000>PP2<6SO5`34]a<0
GU[cMlBg4`0001D0?9LO02D0001XgaL0000:071g003H]`40100002Rg4`0m6247I7H02000000U0000
30000040000F0000300001P0000B000030000040000H00003000002I009D0000E0000:H2003e0@00
aP8006H200010000EED7@GI01d6V0P00C`800040001<00000000000000000000oooooooooom@0000
:@000240000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0000<4000A0`00C`D00:T300000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000030000
00000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000004<000000?D0002B09QUDc0`IQP1000009Bg4`2_4P8`
;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`000000004`0j208`X101EBd04`000000
@`0009450S38^1<0O6dH0OS>TP0L^1<0HW`:<3HH2WX@_Q<03P02<03hoomTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000K0@002P300271000
V@<00040001EE@M1MT07@F`400220`000@0004`00000000000000000003ooooooooooe00001Y0000
700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000
000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000001Rg4`000000^02AO=2?6P3T]a<0@@2AO4P75@1M095l=QP:NmR?6P3HSaX0
00000;1S60400000V6EC<82h4`1lL4T`000000004`00008`X101EBd04`000000@`0009450S38^1<0
=M<1<12n4`000000D6@H0CHH2WXP00003P02<03hoomTMP08000003X80S1XgaL0a;LC05iJlgO4]a<0
000E0:RK7`0U0000J=lG00002P3LN`00f;L100@0000X]a<0?APQ1fAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`00000V@02E00005@000281000:0<00:P4002I0`00
0@0005EE1d5f@0M1R0@0088300010000C00000000000000000000?ooooooooooD00002P0000Q0000
5P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000
S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l=QP:NmR?6P3HSaX000000;1S60400000
V6EC<82h4`1lL4T`6;LC0000002h095ld8lJ0>Bg4`11095lB0LE05d0TG`f60Ylf8lJ0=R?6P000000
D6@H0CHH2WXP00003P02<03hoomTMP08000000000S1XgaL0a;LC05iJlgO4]a<0000E0:RK7`0ed`4`
4;hC0000003`I1P1f;L10200000X]a<0?APQ1fAf00P00000>PP2<6SO5`34]a<0GU[cMlBg4`0001D0
`9dO02D0001XgaL0000:0?Am003H]`40100002Rg4`0m6247I7H02000000U000030000040000F0000
300001P0000B000030000040000H00003000002I009D0000E0000:T4000X0`00aP@009T300010000
EED7@GI01d6Y1000PP<00040001<00000000000000000000oooooooooom@0000M00001`0000F0000
30000000000U0000300000h0080X000030000040001B0000L0400040002Loooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0
j;XC00h100070P00S4PH0@004`11095lB0LE05d0TG`f60Ylf8lJ0=R?6P000000D6@H0CHH2WXP0000
3P02<03hoolH]a<000000;P0TGc@SaX0i;LC0440TGa81aD0G@2AO3HH2WgHSaX0f8lJ0000003`I1P1
f;L10200000X]a<0?APQ1fAf00P000000002<6SO5`34]a<0GU[cMlBg4`0001D0`9dO03GC0C0@_Q<0
0000091U607H]`40800002Rg4`0m6247I7H02000000j208`J=lG0<Bg4`1NF_=ga;LC00005@3HWal0
9@0006SO5`0000X038000=Rg0@040000:;LC03dH8@MTMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<000009T00U@0001D0000a@@002P3003U1000V@<00040001EE@M1
MT07@LD400220`000@0004`00000000000000000003ooooooooooe00000Y00008@0001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000V@000143003U0@00
Z@<0000000160000500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0
3P4000L2002<B1P1000C0>Bf4`14HaP13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00000=m@000980V6EC<31V60400000U;LC0:lB0S0]01<0=M<1<12n4`000000
/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S2P405E;@0C000000130000T@D2<<Rh4`1lKAP1
n<jB01bh4`1RO0X`>1P:N12n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`00000V@02E00005@000020@00:0<001d1002I0`000@0005EE1d5f@0M1
0P40088300010000C00000000000000000000?ooooooooooD00006T0000L00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@00
1`8008a860400640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
6;LC0000002h095ld8lJ0>Bg4`11095lB0LE05d0TG`h60Yif8lJ0=R?6P000000/6<H0@00002HIE<`
P;PC07a`BC000000000C00000S2P405E;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1
>1P:N200000>008`0?SoofAf00P00000>PP2<6SO5`34]a<0GU[cMlBg4`0001D0A:@O02D0001XgaL0
000:07R4003H]`40100002Rg4`0m6247I7H02000000U000030000040000F0000300001P0000B0000
30000040000H00003000002I009D0000E00001h1000X0`00?P4009T300010000EED7@GI01d4N0@00
PP<00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00
S4PH0@004`11095lB0LE05d0TG`h60Yif8lJ0=R?6P000000/6<H0@00002HIE<`P;PC07a`BC0H]a<0
00000;P0TGc@SaX0i;LC0440TGa81aD0G@2AO3PH2W[HSaX0f8lJ0000001@I1P1>1P:N200000>008`
0?SoofAf00P000000002<6SO5`34]a<0GU[cMlBg4`0001D0A:@O03GC0C0@_Q<000000?1T607H]`40
800002Rg4`0m6247I7H02000000j208`J=lG0<Bg4`1NF_=ga;LC00005@1LYQl09@0006SO5`0000X0
T8H00=Rg0@040000:;LC03dH8@MTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000009T00U@0001D0000?`4002P3001L0@00V@<00040001EE@M1MT07@Cl100220`00
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0440TGa81aD0G@2AO3PH2W[HSaX0f8lJ0000001@I1P1>1P:N200000>008`0?SooaRg4`000000
^02AO=2?6P3T]a<0@@2AO4P75@1M095l>1P:NmR?6P3HSaX000000?1T607H]`40800002Rg4`0m6247
I7H020000000008`J=lG0<Bg4`1NF_=ga;LC00005@1LYQl0=M<1<12n4`000000T6DH0MRg0@0P0000
:;LC03dH8@MTMP08000003X80S1XgaL0a;LC05iJlgO4]a<0000E07BX7`0U0000J=lG00002P2XR000
f;L100@0000X]a<0?APQ1fAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`00000V@02E00005@0001K0@00:0<007/1002I0`000@0005EE1d5f@0M1F`40088300010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`80000:1P00gP4005L7001f0P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000@00000000000000S;XC0>Rj4`0>0@001`8008a860400000
003`00@P000H0000T0G`0905l00H0000N_O:<4<0000H0000H;LC0000000H000010000040001H]a<0
?;LC00KfbS00of0a500005cebS0l]a<0600000@0003@BI80[DX0<<08l0040000VQ<2<1@0003@BI80
V6EC<000604F0000C00009Bg4`164`8`X101EBd04`0ed`4`4;hC0000002`HaP10P0009QUDc20^1<0
O719<000000001<0>PP2<:0@0ED]01<00P0004<0002A1@8`b;PC07a]606XcY807;PC069l2S0f60Z<
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
3000002I009D0000E00007T6003e0@00ZPH006H200010000EED7@GI01d5i1P00C`800040001<0000
0000000000000000oooooooooom@0000<0000380000F000030000000000U0000300000h0080X0000
30000040001B0000L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00001000000000000002<^Q<0j;XC00h100070P00S4PH0@00bS00of0a
500005cebS0l]a<0600000@0003@BI80[DX0<<08l0040000VQ<2<1@0000H]a<000000;P0TGc@SaX0
i;LC0440TGa81aD0G@2AO3HH2XgHSaX0f8lJ0000002`HaP10P0009QUDc20^1<0O719<000000001<0
0002<:0@0ED]01<00P0004<0002A1@8`b;PC03GC0C0@_Q<00000051T604f60Z<800000h00S00n?oo
I7H02000000j208`J=lG0<Bg4`1NF_=ga;LC00005@3P[1l09@0006SO5`0000X058d00=Rg0@040000
:;LC03dH8@MTMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
09T00U@0001D0000Y@H00?D1003W1P00IP800040001EE@M1MT07@J/6001?0P000@0004`000000000
00000000003ooooooooooe0000110000?@0001H0000<0000000002D0000<00003P00P2P0000<0000
0@0004H0000X0000700004M4BD<20000EP@00306003b100050L0000000160000804001@10015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240`0T@0000h00000Q30f`00003N0000
00000000B40200000P000080000000110P00000000024<3K000000000?l8@343V00008`000024<3K
3P000000002jN9I4OV[<A:gDVTA/Ple4EO6MA901dTAElIe4Zc?GA5GaWDBbBme4NK>IA:/lhTAEN9A4
ZccRA?PlSdB[?>94EOn:A;9;gDAEohY4Zc?GA1coRTCFe=54`E2>A=PmcDAYfi94_5?<A5C3U4B_i<I4
00<30`<30`<30`<30h430aE0<@0@000010000300000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
<P0000000000000000000000000000009@0000`0000100009@0000`000050020>`0000P0000K0000
400003E;000^IP00F00004`00000000000000?oooooooooo300006==^VKaC_UXlDjBJo5>WVkBC1Ma
=DXGLIM75g5hAIi^N4FBJgQ5hfPQAiMVITTRISH0000@0000FTX006]S000m0000200003`000080000
@00001P0001D1000=0H00?84000D1`009@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000002<B1P1
0@0000000000000000000000000000001`0003CfTP20cY80Z5SV<8a8605/2QP15000052h4`000000
O6dH0@4000010000D;PC04N9k3000000O6dH0@000020cY80a4TH0@00001lKAP1?`0005bh4`1/F>H`
0@0000000002000090lH0N2h4`2dhI8000000000003oooooB93/<?B:605lKAP1c;TC0040000ed`4`
4;hC0000002`HaP12@@H0@T4607AO0d`<00000T4604001<000000000000/^A<000000000001lKAP1
;;TC05j=k31lKAP1000001Bi4`0T^A<000000>1C605/2QP1I7H02000000U000030000040000F0000
300001P0000B000030000040000H0000300004e=C@9D0000E00008/400251P00_0@00?H600010000
EED7@GI01d6;1000g`H00040001<00000000000000000000oooooooooom@0000<0000380000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P0008<1002f0@00
5@8008P200000000AP000201000D0@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0<P940000>000008@`=/00000gP000000000004Q00P000080000200000000@@8000000000
0Q30f`000000003o240c0iP0002<00000Q30f`h000000000REoT@oA65dBkK=53PklFA028`T=iY@e4
08S2@eJI0T@0R<938UC^@nmadT>[b]]301CV@j_:fd<i]OU3Zl[K@`3@14@RE>i30=04A5JI0TBDc`A4
dFH;A8h804Cb?A=4XL_a@ndT5T@<P>e3cVXPA0030`<30`<30`<30`>10H4E@3<0400000@0000b0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000000010380000000000000000000000000000002D0000<0000
0@0002D0000<00001@00P3/0000800006`00010000247000bRD005P0001<000000000000003ooooo
ooooo``0000V6ZPUBAQR8dTHWb196<<MAaYb6k/LLQ/_7g8K;2737B`QWb0/8M8Rnao8938NPRDf0000
40000:PM000C:000?@0000P0000l000020000400000H0000PP400;@1000F0P00Q08002D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP00000000000000S4PH0@40000000000000000000000000000000L0000dmY80
P<jB0:QHiS2<B1P1K0XH0A@0001@^1<0000007a]604100000@00052h4`17RN``000007a]60400000
P<jB0<A960400000O6dH0Cl0001L^1<0K5SV<040000000000P0002@?607P^1<0]>6B000000000000
ooooodR@k33dRQP1O6dH0Lbi4`010000=M<1<12n4`000000/6<H0@T4604911P1dG`=<340000911P1
000C000000000000;;TC000000000000O6dH0Bbi4`1NSN``O6dH0@00000D^A<09;TC0000003PDaP1
K0XH0FAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`0001=CDd2
E00005@0002c0@00e@400>@100160P000@0005EE1d5f@0M1/`4002l200010000C000000000000000
00000?ooooooooooD0000340000b00005P0000`0000000009@0000`0000>0020:00000`000010000
AP0002P0000L0000AdA9@`80001<1@00WP400=h5001/0P00000004H0000P0@00504004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@3@2A00003P000024<3K00000=h000000000
0018@080000200000P000000044200000000008@`=/000000000o`Q0=@>H0000S000008@`=/>0000
000004e@[dCnm@m4Ko2[A:_A34@0^ZU4LS@5A02jZDB[N_U30;ZYA2:LhT=l]:e4Za;@@`2M/TB[4]13
CXFgA:/Bd4<0P;]48YcR@`20^dB[N_U3082kA<0T24@WR[M4RVHAA<^T/TCHL1540Rb`A<j>6T@00`<3
0`<30`<30`<3PK305D0e010000040000=000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000000@0b0000
000000000000000000000000000U000030000040000U0000300000D0080k0000200001/0000@0000
XEL00?HS001H0000C000000000000000ooooooooool<0000lED]8mEDAR7EE2POeEA<7==FnaU7FO/I
^e_k6KQMC1bhGBPO^5d28[iKDRA;FEDT=P000100000>F000W2H003d000080000?00000P000100000
600004X5002M0@00g`D006d2000U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000000008a860410000
00000000000000000000000000070000=?JB083>TP2XF>H`S4PH0F`:604D0000D;PC0000001lKAP1
0@000040001@^1<0AhW/<000001lKAP10000083>TP34BAP1000007a]604o0000G;PC06aHiS010000
00000080000T3aP1h;PC0;CQTP00000000000?oooom8T>``m8XH0Ga]607<^A<00@0003GC0C0@_Q<0
00000;1S604911P12@@H0M5l3C0b00002@@H0@004`000000000002bi4`000000000007a]604/^A<0
GXg/<7a]604000005;TC02Bi4`000000h5<H0F`:605TMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<0000CDe=0U@0001D0000O0D00;h1002]1@00;`800040001EE@M1
MT07@G`5000H0P000@0004`00000000000000000003ooooooooooe00000b0000<P0001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000d0000:00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080Q000020000680000<00000@0004`0001T00003@4009d1001i1`00
50L000d1002M0@00K@H007P5000Y0:X0000000000000080o000000000000080o0000000000000000
000000000000000000000000000R000030000?oooom60000700001000015CDH[0T0000`000000000
3P0001@000000000400001@0
\>"], "Text",
 ImageSize->{266.3333333333333, 204.66094911377928`}],

Cell[CellGroupData[{

Cell["Zad\[AAcute]n\[IAcute] obvodu", "Subsubtitle",
 CellChangeTimes->{{3.562068021578125*^9, 3.562068026734375*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", " ", "=", " ", "10."}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"nap\:011bt\[IAcute]", " ", "zdroje", " ", "nap\:011bt\[IAcute]"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u0", "=", "0."}], ";"}], "  ", 
  RowBox[{"(*", 
   RowBox[{
   "po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute]", " ", "nap\:011bt\[IAcute]", 
    " ", "na", " ", "kondenz\[AAcute]toru"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", " ", "=", " ", "100."}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"odpor", " ", "rezistoru"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Cap", " ", "=", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"kapacita", " ", "kondenz\[AAcute]toru"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmin", " ", "=", " ", "0."}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute]", " ", "\[CHacek]as"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmax", " ", "=", " ", "0.001"}], ";"}], 
  RowBox[{
  "(*", "kone\[CHacek]n\[YAcute]\[CHacek]as", 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.46316277559375*^9, 3.463163002265625*^9}, {
   3.46316304715625*^9, 3.463163048734375*^9}, {3.4632043471875*^9, 
   3.463204365890625*^9}, 3.463216958578125*^9, {3.46321698984375*^9, 
   3.463216992609375*^9}, {3.463217025453125*^9, 3.4632170585*^9}, {
   3.463217160875*^9, 3.463217185265625*^9}, {3.463217229359375*^9, 
   3.463217230671875*^9}, {3.5620680890625*^9, 3.562068112734375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\:0158e\[SHacek]en\[IAcute] obvodu", "Subsubtitle",
 CellChangeTimes->{{3.562068137140625*^9, 3.562068143546875*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[TextData[{
 "Pou\:017eijeme Eulerovu metodu, kter\[AAcute] \
po\[CHacek]\[IAcute]t\[AAcute] pr\:016fb\:011bh funkce podle vzorce:\n\t\t\t",
 StyleBox["f", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") \[TildeTilde] ", "DisplayFormula"],
 StyleBox["f", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") + ", "DisplayFormula"],
 StyleBox["f", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["'(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[")\[CenterDot]\[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["\n\nV na\[SHacek]em p\:0159\[IAcute]pad\:011b bude hledanou funkc\
\[IAcute] nap\:011bt\[IAcute] ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" na konenz\[AAcute]toru, tedy:\n\t\t\t", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") \[TildeTilde] ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") + ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["'(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[")\[CenterDot]\[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["\n\nDerivaci nap\:011bt\[IAcute] ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["' vyj\[AAcute]d\:0159\[IAcute]me z obvodov\[YAcute]ch rovnic. Pou\
\:017eijeme zjednodu\[SHacek]en\[YAcute] popis z notebooku ", 
  "DisplayFormula"],
 StyleBox["CAO-Uzly-Priklad2-Kratsi.nb", "Program",
  FontWeight->"Bold"],
 StyleBox[".\nrezistor R: \t\t", "DisplayFormula"],
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") - ",
 StyleBox["uc",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") \[Equal] ",
 StyleBox["R",
  FontSlant->"Italic"],
 StyleBox["\[CenterDot]", "DisplayFormula"],
 StyleBox["i",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")\nkondenz\[AAcute]tor C: \t",
 StyleBox["i",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") \[Equal] ",
 StyleBox["Cap",
  FontSlant->"Italic"],
 StyleBox["\[CenterDot]", "DisplayFormula"],
 StyleBox["uc",
  FontSlant->"Italic"],
 "'(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")\n\nZ toho dost\[AAcute]v\[AAcute]me\n\t\t\t",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") - ",
 StyleBox["uc",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") \[Equal] ",
 StyleBox["R",
  FontSlant->"Italic"],
 StyleBox["\[CenterDot]", "DisplayFormula"],
 StyleBox["Cap",
  FontSlant->"Italic"],
 StyleBox["\[CenterDot]", "DisplayFormula"],
 StyleBox["uc",
  FontSlant->"Italic"],
 "'(",
 StyleBox["t",
  FontSlant->"Italic"],
 ");\na tedy\n\t\t\t",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["uc",
      FontSlant->"Italic"], "'"}], 
    RowBox[{"(", 
     StyleBox["t",
      FontSlant->"Italic"], ")"}]}], "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      StyleBox["u",
       FontSlant->"Italic"], 
      RowBox[{"(", 
       StyleBox["t",
        FontSlant->"Italic"], ")"}]}], "-", 
     RowBox[{
      StyleBox["uc",
       FontSlant->"Italic"], 
      RowBox[{"(", "t", ")"}]}]}], 
    RowBox[{
     StyleBox["R",
      FontSlant->"Italic"], 
     StyleBox["\[CenterDot]", "DisplayFormula"], 
     StyleBox["Cap",
      FontSlant->"Italic"]}]]}]], "Input",
  CellChangeTimes->{{3.56206901971875*^9, 3.562069050609375*^9}},
  FontWeight->"Plain"],
 "\n\nDosad\[IAcute]me-li hodnotu derivace do vzorce pro Eulerovu metodu, \
dost\[AAcute]v\[AAcute]me iterativn\[IAcute] vzorec pro \
v\[YAcute]po\[CHacek]et nap\:011bt\[IAcute] v \[CHacek]ase ",
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 " p\:0159i znalosti nap\:011bt\[IAcute] v \[CHacek]ase ",
 StyleBox["t",
  FontSlant->"Italic"],
 ":\n\n\t\t\t",
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") \[TildeTilde] ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox["(", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[") + ", "DisplayFormula"],
 Cell[BoxData[
  FractionBox[
   RowBox[{
    RowBox[{
     StyleBox["u",
      FontSlant->"Italic"], 
     RowBox[{"(", 
      StyleBox["t",
       FontSlant->"Italic"], ")"}]}], "-", 
    RowBox[{
     StyleBox["uc",
      FontSlant->"Italic"], 
     RowBox[{"(", "t", ")"}]}]}], 
   RowBox[{
    StyleBox["R",
     FontSlant->"Italic"], 
    StyleBox["\[CenterDot]", "DisplayFormula"], 
    StyleBox["Cap",
     FontSlant->"Italic"]}]]],
  CellChangeTimes->{{3.56206901971875*^9, 3.562069050609375*^9}}],
 StyleBox["\[CenterDot]\[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.562068163828125*^9, 3.56206818153125*^9}, {
  3.562068286953125*^9, 3.562068290703125*^9}, {3.56206835609375*^9, 
  3.56206872521875*^9}, {3.562068941734375*^9, 3.562069005796875*^9}, {
  3.56206905934375*^9, 3.56206908075*^9}, {3.56206912884375*^9, 
  3.562069131421875*^9}, {3.562069172515625*^9, 3.56206927425*^9}, {
  3.562070737078125*^9, 3.5620707380625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[TextData[{
 "Interval \:0159e\[SHacek]en\[IAcute] si rozd\:011bl\[IAcute]me na ",
 StyleBox["n",
  FontSlant->"Italic"],
 " = 100 men\[SHacek]\[IAcute]ch \[UAcute]sek\:016f. Ka\:017ed\[YAcute] \
\[UAcute]sek m\[AAcute] velikost ",
 StyleBox["\[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.463213686*^9, 3.463213695578125*^9}, {
   3.463216383703125*^9, 3.463216827578125*^9}, {3.463217394890625*^9, 
   3.463217490234375*^9}, {3.46321752184375*^9, 3.46321754765625*^9}, 
   3.5620689044375*^9, {3.562069383171875*^9, 3.562069432765625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"n", " ", "=", " ", "100"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "po\[CHacek]et", " ", "krok\:016f", " ", "mezi", " ", 
    "po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute]m", " ", "a", " ", 
    "kone\[CHacek]n\[YAcute]m", " ", "\[CHacek]asem"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]t", "=", 
    FractionBox["tmax", "n"]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"velikost", " ", "kroku"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.56207048178125*^9, 3.562070482078125*^9}, {
  3.5620705245625*^9, 3.562070541890625*^9}, {3.562070666921875*^9, 
  3.562070667015625*^9}}],

Cell[TextData[{
 "V jednom kroku Eulerovy metody z nap\:011bt\[IAcute] ",
 StyleBox["uc",
  FontSlant->"Italic"],
 " v \[CHacek]ase ",
 StyleBox["t",
  FontSlant->"Italic"],
 " spo\[CHacek]\[IAcute]t\[AAcute]me nov\[EAcute] nap\:011bt\[IAcute] ",
 StyleBox["uc",
  FontSlant->"Italic"],
 " v \[CHacek]ase ",
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 ". Tedy v \[CHacek]ase postoup\[IAcute]me z ",
 StyleBox["t",
  FontSlant->"Italic"],
 " do ",
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" + \[CapitalDelta]", "DisplayFormula"],
 StyleBox["t", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[", v nap\:011bt\[IAcute] postoup\[IAcute]me z ", "DisplayFormula"],
 StyleBox["uc", "DisplayFormula",
  FontSlant->"Italic"],
 StyleBox[" do ", "DisplayFormula"],
 Cell[BoxData[
  RowBox[{
   StyleBox["uc",
    FontSlant->"Italic"], 
   StyleBox["+",
    FontSlant->"Italic"], 
   RowBox[{
    StyleBox[
     FractionBox[
      RowBox[{"u", "-", "uc"}], 
      RowBox[{"R", "*", "Cap"}]],
     FontSlant->"Italic"], 
    StyleBox["*",
     FontSlant->"Italic"], 
    StyleBox[
     RowBox[{
      StyleBox["\[CapitalDelta]",
       FontSlant->"Plain"], 
      StyleBox["t",
       FontSlant->"Italic"]}]]}]}]],
  CellChangeTimes->{
   3.56206876346875*^9, {3.562069437671875*^9, 3.562069442*^9}}]
}], "Text",
 CellChangeTimes->{{3.463213686*^9, 3.463213695578125*^9}, {
   3.463216383703125*^9, 3.463216827578125*^9}, {3.463217394890625*^9, 
   3.463217490234375*^9}, {3.46321752184375*^9, 3.46321754765625*^9}, 
   3.5620689044375*^9, {3.562069383171875*^9, 3.5620694614375*^9}, {
   3.562070174078125*^9, 3.562070213265625*^9}, {3.562070251296875*^9, 
   3.562070297375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", " ", "uc_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", " ", 
     RowBox[{"uc", "+", 
      RowBox[{
       FractionBox[
        RowBox[{"u", "-", "uc"}], 
        RowBox[{"R", "*", "Cap"}]], "*", "\[CapitalDelta]t"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{"krok", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "tmin"}], ",", 
      RowBox[{"uc", "=", "u0"}]}], "}"}], ",", " ", "n"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"Vyp\[IAcute]\[SHacek]e", " ", "list", " ", 
    RowBox[{"(", "seznam", ")"}], " ", "v\[SHacek]ech", " ", 
    "iterac\[IAcute]"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.56206876346875*^9, {3.562069437671875*^9, 3.562069442*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Vykreslen\[IAcute] v\[YAcute]sledk\:016f - numerick\[AAcute] metoda\
\>", "Subsubtitle",
 CellChangeTimes->{{3.463163071140625*^9, 3.463163081515625*^9}, {
  3.463167892359375*^9, 3.463167904609375*^9}, {3.46321732575*^9, 
  3.463217337640625*^9}, {3.4632185350625*^9, 3.463218538875*^9}, {
  3.562067242546875*^9, 3.562067246265625*^9}, {3.5620688251875*^9, 
  3.562068835265625*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[
 RowBox[{"graf1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"krok", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "=", "0"}], ",", 
        RowBox[{"uc", "=", "0"}]}], "}"}], ",", " ", "n"}], "]"}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmin", ",", "tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u0", ",", "u"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.463213530375*^9, 3.4632135323125*^9}, {
  3.562070388609375*^9, 3.562070398078125*^9}, {3.562070508828125*^9, 
  3.562070511953125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Nab\[IAcute]jen\[IAcute] kondenz\[AAcute]toru p\:0159es rezistor - analytick\
\[AAcute] metoda\
\>", "Subtitle",
 CellChangeTimes->{{3.463167828515625*^9, 3.463167850875*^9}, {
  3.4632172468125*^9, 3.4632172496875*^9}, {3.4632173438125*^9, 
  3.463217367921875*^9}, {3.4632185456875*^9, 3.463218548796875*^9}},
 Background->GrayLevel[0.85]],

Cell["Zad\[AAcute]n\[IAcute] obvodu", "Subsubtitle",
 CellChangeTimes->{{3.562068021578125*^9, 3.562068026734375*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[{
 RowBox[{"ClearAll", "[", 
  RowBox[{
  "u", ",", "R", ",", "Cap", ",", "tmin", ",", "tmax", ",", "u0", ",", "rce1",
    ",", "poc1", ",", "reseni", ",", " ", "uc", ",", "t"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cap", " ", "=", " ", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmin", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u0", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.463204398015625*^9, 3.4632044091875*^9}, {
  3.4632135400625*^9, 3.46321359565625*^9}, {3.46321608996875*^9, 
  3.46321615040625*^9}, {3.562068865921875*^9, 3.56206886940625*^9}}],

Cell[CellGroupData[{

Cell["\:0158e\[SHacek]en\[IAcute] obvodu", "Subsubtitle",
 CellChangeTimes->{{3.562068137140625*^9, 3.562068143546875*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rce1", " ", "=", " ", 
   RowBox[{
    RowBox[{"uc", "[", "t", "]"}], " ", "\[Equal]", 
    RowBox[{"u", "-", 
     RowBox[{"R", "*", "Cap", "*", 
      RowBox[{
       RowBox[{"uc", "'"}], "[", "t", "]"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc1", " ", "=", " ", 
   RowBox[{
    RowBox[{"uc", "[", "0", "]"}], "\[Equal]", "u0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"reseni", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rce1", ",", "poc1"}], "}"}], ",", " ", 
    RowBox[{"uc", "[", "t", "]"}], ",", "t"}], "]"}]}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Vykreslen\[IAcute] v\[YAcute]sledk\:016f - analytick\[AAcute] metoda\
\>", "Subsubtitle",
 CellChangeTimes->{{3.463163071140625*^9, 3.463163081515625*^9}, {
  3.463167892359375*^9, 3.463167904609375*^9}, {3.46321732575*^9, 
  3.463217337640625*^9}, {3.4632185350625*^9, 3.463218538875*^9}, {
  3.562067242546875*^9, 3.562067246265625*^9}, {3.5620688379375*^9, 
  3.562068843484375*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[
 RowBox[{"graf2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"uc", "[", "t", "]"}], "/.", "reseni"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "0.001"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmin", ",", "tmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u0", ",", "u"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.463213480984375*^9, 3.463213487*^9}, {3.562070418625*^9,
   3.562070423515625*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Srovn\[AAcute]n\[IAcute] p\:0159esnosti obou metod", "Subtitle",
 CellChangeTimes->{{3.463213660140625*^9, 3.463213672625*^9}, {
  3.46321635665625*^9, 3.463216369546875*^9}},
 Background->GrayLevel[0.85]],

Cell["\<\
Analytick\[AAcute] metoda je p\:0159esn\[AAcute], proto\:017ee \:0159e\
\[SHacek]en\[IAcute] diferenci\[AAcute]ln\[IAcute] rovnice je nejprve spo\
\[CHacek]teno analyticky. V\[YAcute]sledkem je matematick\[AAcute] funkce, ze \
kter\[EAcute]  je teprve vykreslen graf. 
Numerick\[AAcute] metoda je m\[EAcute]n\:011b p\:0159esn\[AAcute] a \
p\:0159esnost z\[AAcute]vis\[IAcute] na velikosti kroku. Jemn\:011bj\[SHacek]\
\[IAcute] krok znamen\[AAcute] vy\[SHacek]\[SHacek]\[IAcute] p\:0159esnot. V\
\[YAcute]hodou je, \:017ee numerick\[AAcute] metoda funguje i tehdy, kdy \
analytick\[EAcute] \:0159e\[SHacek]en\[IAcute] nelze nal\[EAcute]zt.  \
\>", "Text",
 CellChangeTimes->{{3.463213686*^9, 3.463213695578125*^9}, {
   3.463216383703125*^9, 3.463216827578125*^9}, {3.463217394890625*^9, 
   3.463217490234375*^9}, {3.46321752184375*^9, 3.46321754765625*^9}, 
   3.5620689044375*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"graf2", ",", "graf1"}], "]"}]], "Input",
 CellChangeTimes->{{3.46321370734375*^9, 3.46321371634375*^9}, {
  3.56207043125*^9, 3.56207043365625*^9}}],

Cell[TextData[{
 "Pozorujte velikost odchylky numerick\[EAcute] metody od \
p\:0159esn\[EAcute]ho analytick\[EAcute]ho \:0159e\[SHacek]en\[IAcute] pro r\
\:016fznou velikost kroku. Zm\:011bna hodnoty prom\:011bnn\[EAcute] ",
 StyleBox["n",
  FontSlant->"Italic"],
 " nep\:0159\[IAcute]mo \[UAcute]m\:011brn\:011b ovliv\:0148uje krok v \
numerick\[EAcute] metod\:011b. \[LineSeparator]Doporu\[CHacek]ujeme vyzkou\
\[SHacek]et ",
 StyleBox["n ",
  FontSlant->"Italic"],
 "= 15,30,50,100 a 200. "
}], "Text",
 CellChangeTimes->{{3.463216877640625*^9, 3.4632169480625*^9}, {
  3.463217076546875*^9, 3.46321714553125*^9}, {3.46321756053125*^9, 
  3.463217650203125*^9}, {3.463219074*^9, 3.46321920340625*^9}, {
  3.56206888946875*^9, 3.562068889828125*^9}, {3.5620689204375*^9, 
  3.56206892446875*^9}},
 Background->RGBColor[0.87, 0.94, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Samostatn\[EAcute] \[UAcute]lohy", "Subtitle",
 CellChangeTimes->{{3.463168064*^9, 3.4631680715*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "V",
 StyleBox["ykreslete graf proudu ",
  FontWeight->"Plain"],
 StyleBox["i[t]",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 StyleBox[", kter\[YAcute] te\[CHacek]e kondenz\[AAcute]torem",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.463204464359375*^9, 3.4632044656875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[TextData[StyleBox["Vykreslete graf nap\:011bt\[IAcute] na rezistoru",
 FontWeight->"Plain"]], "Text",
 CellChangeTimes->{{3.463204473421875*^9, 3.463204474171875*^9}},
 Background->RGBColor[0.87, 0.94, 1]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 698},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 132, 2, 147, "Title"],
Cell[702, 26, 296, 6, 141, "Subtitle"],
Cell[1001, 34, 138, 2, 43, "Input"],
Cell[1142, 38, 406, 11, 66, "Text"],
Cell[1551, 51, 90, 2, 43, "Input"],
Cell[1644, 55, 152, 3, 43, "Input"],
Cell[1799, 60, 182, 4, 43, "Input"],
Cell[1984, 66, 126, 2, 43, "Input"],
Cell[2113, 70, 154, 3, 43, "Input"],
Cell[2270, 75, 183, 4, 43, "Input"],
Cell[CellGroupData[{
Cell[2478, 83, 450, 9, 98, "Subtitle"],
Cell[2931, 94, 55369, 685, 328, "Text"],
Cell[CellGroupData[{
Cell[58325, 783, 156, 2, 66, "Subsubtitle"],
Cell[58484, 787, 1735, 45, 234, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60256, 837, 161, 2, 66, "Subsubtitle"],
Cell[60420, 841, 6291, 209, 511, "Text"],
Cell[66714, 1052, 669, 15, 65, "Text"],
Cell[67386, 1069, 666, 18, 97, "Input"],
Cell[68055, 1089, 1859, 58, 102, "Text"],
Cell[69917, 1149, 923, 27, 125, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70877, 1181, 433, 8, 66, "Subsubtitle"],
Cell[71313, 1191, 797, 22, 71, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72159, 1219, 351, 7, 98, "Subtitle"],
Cell[72513, 1228, 156, 2, 66, "Subsubtitle"],
Cell[72672, 1232, 909, 22, 207, "Input"],
Cell[CellGroupData[{
Cell[73606, 1258, 161, 2, 66, "Subsubtitle"],
Cell[73770, 1262, 633, 20, 98, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74440, 1287, 434, 8, 66, "Subsubtitle"],
Cell[74877, 1297, 617, 17, 43, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75543, 1320, 211, 3, 98, "Subtitle"],
Cell[75757, 1325, 931, 15, 139, "Text"],
Cell[76691, 1342, 196, 4, 43, "Input"],
Cell[76890, 1348, 836, 18, 114, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77763, 1371, 137, 2, 98, "Subtitle"],
Cell[77903, 1375, 352, 11, 66, "Text"],
Cell[78258, 1388, 210, 3, 65, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
