(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7886,        256]
NotebookOptionsPosition[      7505,        239]
NotebookOutlinePosition[      7869,        255]
CellTagsIndexPosition[      7826,        252]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{3.687589036826801*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fder", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["y", "2"], "+", "x"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdruhader", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"fder", "[", 
       RowBox[{"x", ",", 
        RowBox[{"y", "[", "x", "]"}]}], "]"}], ",", "x"}], "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
       RowBox[{"fder", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", "y"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ftretider", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"fdruhader", "[", 
       RowBox[{"x", ",", 
        RowBox[{"y", "[", "x", "]"}]}], "]"}], ",", "x"}], "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
       RowBox[{"fder", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", "y"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fctvrtader", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"ftretider", "[", 
       RowBox[{"x", ",", 
        RowBox[{"y", "[", "x", "]"}]}], "]"}], ",", "x"}], "]"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
       RowBox[{"fder", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", "y"}]}], "}"}]}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EulerianStep", "[", "list_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"list", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "+", "stepx"}], ",", 
     RowBox[{
      RowBox[{"list", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "+", 
      RowBox[{"stepx", "*", 
       RowBox[{"fder", "[", 
        RowBox[{
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"0.5", 
       SuperscriptBox["stepx", "2"], "*", 
       RowBox[{"fdruhader", "[", 
        RowBox[{
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1.", "6"], 
       SuperscriptBox["stepx", "3"], "*", 
       RowBox[{"ftretider", "[", 
        RowBox[{
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1.", "24"], 
       SuperscriptBox["stepx", "4"], "*", 
       RowBox[{"fctvrtader", "[", 
        RowBox[{
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}]}], "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stepx", "=", ".1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstep", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"EulerianStep", ",", "poc", ",", "nstep"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"presne", "=", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"fder", "[", 
           RowBox[{"x", ",", 
            RowBox[{"y", "[", "x", "]"}]}], "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "x", "]"}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"poc", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", 
          RowBox[{"poc", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"poc", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"poc", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{"stepx", "*", "nstep"}]}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotik1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"reseni", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", 
         RowBox[{"0.12", "/", 
          SqrtBox["nstep"]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotik2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"presne", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"poc", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"poc", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"stepx", "*", "nstep"}]}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plotik1", ",", "plotik2", ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6875890419674263`*^9, 3.687589042983051*^9}}]
},
WindowSize->{863, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 291, 8, 58, "Input"],
Cell[851, 30, 2184, 73, 105, "Input"],
Cell[3038, 105, 1487, 45, 169, "Input"],
Cell[4528, 152, 2973, 85, 308, "Input"]
}
]
*)

(* End of internal cache information *)

