(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14052,        431]
NotebookOptionsPosition[     13487,        410]
NotebookOutlinePosition[     13869,        426]
CellTagsIndexPosition[     13826,        423]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "50."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nF", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fEstimated", "=", 
   RowBox[{"1.05", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"function", "[", "t_", "]"}], ":=", 
   RowBox[{"Tanh", "[", 
    RowBox[{"10.", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "*", "Pi", "*", "fEstimated", "*", "t"}], "]"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotorig", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"function", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "T"}], ",", 
        RowBox[{"2", "T"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "T"], "*", 
     RowBox[{"Quiet", "@", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"function", "[", "t", "]"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", "*", "Pi", "*", "n", "*", "f", "*", "t"}], "]"}]}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], "/;", 
    RowBox[{"n", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "0", "]"}], "=", 
   RowBox[{
    FractionBox["1", "T"], "*", 
    RowBox[{"Quiet", "@", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"function", "[", "t", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "*", "Pi", "*", "f", "*", "t"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "T"], "*", 
     RowBox[{"Quiet", "@", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"function", "[", "t", "]"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "*", "Pi", "*", "n", "*", "f", "*", "t"}], "]"}]}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], "/;", 
    RowBox[{"n", ">", "0"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6868973768125*^9, 3.686897444453125*^9}, {
  3.68689757559375*^9, 3.6868977726875*^9}, {3.686897807703125*^9, 
  3.686897826953125*^9}, {3.68689794634375*^9, 3.68689795078125*^9}, {
  3.686897989890625*^9, 3.68689800265625*^9}, {3.686898081359375*^9, 
  3.6868981266875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nFf", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"a", "[", "0", "]"}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "nFf"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "[", "i", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "*", "Pi", "*", "i", "*", "f", "*", "t"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"b", "[", "i", "]"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", "*", "Pi", "*", "i", "*", "f", "*", "t"}], "]"}]}]}], 
      ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "T"}], ",", 
       RowBox[{"3", "T"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", "plotorig"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6868978421875*^9, 3.686897978625*^9}, 3.686898304625*^9}
  ],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Simpson", "'"}], "s", " ", "integration", " ", "method"}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"aux", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"a", "*", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{"b", "*", "t"}], "+", "c"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f0", "\[Equal]", 
        RowBox[{"aux", "[", "t0", "]"}]}], ",", 
       RowBox[{"fPlus", "==", 
        RowBox[{"aux", "[", 
         RowBox[{"t0", "+", "\[CapitalDelta]t"}], "]"}]}], ",", 
       RowBox[{"fMinus", "==", 
        RowBox[{"aux", "[", 
         RowBox[{"t0", "-", "\[CapitalDelta]t"}], "]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solabc", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"eqns", ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"int", "=", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"aux", "[", "t", "]"}], "/.", "solabc"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"t0", "-", "\[CapitalDelta]t"}], ",", 
        RowBox[{"t0", "+", "\[CapitalDelta]t"}]}], "}"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.686898617359375*^9, 3.68689863584375*^9}, {
  3.686898717953125*^9, 3.686898929640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plusVahyVlevo", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["17", "24"], ",", 
     FractionBox[
      RowBox[{"-", "7"}], "24"], ",", 
     FractionBox["1", "12"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plusVahyVpravo", "=", 
   RowBox[{"Reverse", "[", "plusVahyVlevo", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahyOld", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "3"], 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], ",", 
      "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaVahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldVahy", ",", "nVah"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"oldVahy", "=", 
       RowBox[{"vahyOld", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nVah", "=", 
       RowBox[{"Length", "[", "oldVahy", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"plusVahyVlevo", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0", "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"nVah", "-", "6"}], "]"}]}], ")"}], ",", 
        "plusVahyVpravo"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"vahyOld", "[", "n", "]"}], "+", 
    RowBox[{"deltaVahy", "[", "n", "]"}]}]}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejAmpl", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejAmpl", "[", 
     RowBox[{"{", 
      RowBox[{"listDat_", ",", "i_Integer", ",", "kper_Integer"}], "}"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "T", ",", "f", ",", "dt", ",", "nTake", ",", "vazky", ",", "data", ",",
         "tabsin", ",", "tabcos"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nTake", "=", 
        RowBox[{"nHodnotim", "[", 
         RowBox[{"i", ",", "kper"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"vazky", "=", 
        RowBox[{"vahy", "[", 
         RowBox[{"nProVahy", "[", 
          RowBox[{"i", ",", "kper"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"listDat", ",", "nTake"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"f", "=", 
        RowBox[{"fonlys", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"T", "=", 
        FractionBox["1", "f"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"tabsin", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"tabSin", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "kper", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"tabcos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"tabCos", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "kper", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        FractionBox["2.", 
         RowBox[{"sr", "*", "T", "*", "kper"}]], "*", 
        RowBox[{"Abs", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"data", "*", "vazky"}], ")"}], ".", "tabsin"}], ")"}], 
           "+", 
           RowBox[{"I", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"data", "*", "vazky"}], ")"}], ".", "tabcos"}], 
             ")"}]}]}], ")"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"noiseFunction", "[", "k_", "]"}], ":=", 
    RowBox[{"k", "*", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fOriginal", "[", "t_", "]"}], ":=", 
   RowBox[{"1.56", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "*", "Pi", "*", "1.05", "*", "50", "t"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sr", "=", "48000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["1.", "sr"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"signal", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"fOriginal", "[", "#", "]"}], "+", 
        RowBox[{"noiseFunction", "[", "0.1", "]"}]}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "T"}], ",", 
      RowBox[{"1.6", "T"}], ",", "\[CapitalDelta]t"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "signal", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nAV", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"signal", ",", "nAV"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.686901787390625*^9, 3.686902024984375*^9}, 
   3.68690207771875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"weights", "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "w1", "}"}], ",", 
     RowBox[{
      RowBox[{"w1", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"#", "-", 
              FractionBox["nAV", "2."]}], "nAV"], ")"}], "2"]}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", "nAV"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      FractionBox["w1", 
       RowBox[{"Plus", "@@", "w1"}]]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"MovingAverage", "[", 
   RowBox[{"signal", ",", "weights"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.686902200921875*^9, 3.686902215953125*^9}, {
  3.6869022473125*^9, 3.686902624234375*^9}}]
},
WindowSize->{1040, 743},
WindowMargins->{{15, Automatic}, {57, Automatic}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 330, 9, 103, "Input"],
Cell[890, 31, 2768, 83, 416, "Input"],
Cell[3661, 116, 1060, 32, 151, "Input"],
Cell[4724, 150, 1719, 50, 217, "Input"],
Cell[6446, 202, 1991, 60, 330, "Input"],
Cell[8440, 264, 2455, 67, 501, "Input"],
Cell[10898, 333, 1584, 46, 329, "Input"],
Cell[12485, 381, 998, 27, 284, "Input"]
}
]
*)

(* End of internal cache information *)
