(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8536,        266]
NotebookOptionsPosition[      8087,        247]
NotebookOutlinePosition[      8635,        268]
CellTagsIndexPosition[      8592,        265]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Uz0", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ri", "=", "15.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]F", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cz", "=", 
   RowBox[{"100", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1.8", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2.", "*", 
    FractionBox["Pi", "T"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ns", "=", "480"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"i", ",", "t", ",", "ipom"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"np", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ipom", "[", "t_", "]"}], ":=", 
    RowBox[{"0.5", "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"ns", "*", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"0.5", "\[Omega]", "*", "t"}], "+", 
            RowBox[{"0.5", "Pi", "*", 
             RowBox[{"Random", "[", "]"}]}]}], "]"}], "132"]}], "]"}], 
       RowBox[{"Cosh", "[", 
        RowBox[{"1.00", "*", "ns"}], "]"}]], ")"}], "*", 
     RowBox[{"Tanh", "[", 
      FractionBox["t", 
       RowBox[{"0.1", "T"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"i", "[", "t_", "]"}], "=", 
    RowBox[{
     FractionBox["2.", "np"], 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ipom", "[", "t", "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "np", "]"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"R1", "=", "3000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"5.2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"u", ",", "e", ",", "uz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Uz0", "-", 
        RowBox[{"uz", "[", "t", "]"}]}], "Ri"], "\[Equal]", 
      RowBox[{
       RowBox[{"cz", "*", 
        RowBox[{
         RowBox[{"uz", "'"}], "[", "t", "]"}]}], "+", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"uz", "[", "0", "]"}], "==", "Uz0"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"k", "*", 
         RowBox[{"i", "[", "t", "]"}]}], "-", 
        RowBox[{"u", "[", "t", "]"}]}], "R1"], "\[Equal]", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"u", "'"}], "[", "t", "]"}]}], "+", 
       FractionBox[
        RowBox[{"u", "[", "t", "]"}], "R2"]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "*", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "e", ",", 
        RowBox[{"u", "'"}], ",", "uz"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]], "T"}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"e", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"uz", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<u [V]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<E [J]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<uz [V]\>\""}], "}"}]}]}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"pli", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"i", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}]}]}], "}"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etrue", "=", 
   RowBox[{
    RowBox[{"e", "[", "tmax", "]"}], "-", 
    RowBox[{"e", "[", "0", "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.725635030921875*^9, 3.72563503215625*^9}, 
   3.75064994525*^9, {3.750649976953125*^9, 3.750649981515625*^9}}]
},
WindowSize->{1041, 796},
WindowMargins->{{1, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 7526, 225, 1438, "Input"]
}
]
*)

(* End of internal cache information *)
