(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7203,        219]
NotebookOptionsPosition[      6536,        195]
NotebookOutlinePosition[      7019,        214]
CellTagsIndexPosition[      6976,        211]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.640412956954171*^9, {3.844920631734375*^9, 3.844920649109375*^9}},
 ExpressionUUID -> "dd49583c-1294-400f-a877-40bb7baa6120"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<data.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.63974994203125*^9, 3.639750066390625*^9}, 
   3.63975082021875*^9, {3.639751736421875*^9, 3.639751933046875*^9}, {
   3.639752055140625*^9, 3.63975205540625*^9}, {3.640412960813546*^9, 
   3.640412980282296*^9}, {3.640413089313546*^9, 3.640413093079171*^9}, {
   3.84492065571875*^9, 3.84492070284375*^9}},
 ExpressionUUID -> "33dcbdaa-edf0-4bc9-b197-714ef015dfc2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"imp", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "*", "R"}], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "+", "R"}]]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "R_", ",", "X_"}], "}"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"R", "-", 
       RowBox[{"Re", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"X", "-", 
       RowBox[{"Im", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.640413204469796*^9, 3.640413306110421*^9}, {
  3.640413365407296*^9, 3.640413508016671*^9}, {3.640413539141671*^9, 
  3.640413579876046*^9}, {3.640413866485421*^9, 3.640413889313546*^9}, {
  3.844920828953125*^9, 3.84492084934375*^9}, {3.84492088971875*^9, 
  3.844920890203125*^9}},
 ExpressionUUID -> "a44c393a-2729-4f40-8793-f79134e5f283"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"forFindMin", "=", 
    RowBox[{"Total", "[", 
     RowBox[{"err", "/@", "dat"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.640413204469796*^9, 3.640413306110421*^9}, {
  3.640413365407296*^9, 3.640413508016671*^9}, {3.640413539141671*^9, 
  3.640413579876046*^9}, {3.640413866485421*^9, 3.640413889313546*^9}, {
  3.844920828953125*^9, 3.844920833796875*^9}, {3.844920896234375*^9, 
  3.844920935671875*^9}},
 ExpressionUUID -> "a44c393a-2729-4f40-8793-f79134e5f283"],

Cell[BoxData[
 RowBox[{"min", "=", 
  RowBox[{"Quiet", "@", 
   RowBox[{
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", "forFindMin", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"R", ",", "1000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.844920959671875*^9, 3.844920968921875*^9}, {
  3.8449210658125*^9, 3.844921067296875*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"min", "=", 
   RowBox[{
    RowBox[{"NMinimize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"forFindMin", ",", 
        RowBox[{"R", ">", "0"}], ",", 
        RowBox[{"c", ">", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"R", ",", "c"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.844921082734375*^9, 3.844921109296875*^9}, 
   3.844921140015625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{
    RowBox[{"imp", "[", "f", "]"}], "/.", "min"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.640413583579171*^9, 3.640413610126046*^9}, 
   3.640413899438546*^9},
 ExpressionUUID -> "c5504793-29af-43be-9ed5-c4885adf9514"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fmin", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmax", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "vys", "]"}], ",", 
       RowBox[{"Im", "[", "vys", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "fmin", ",", "fmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dat", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}]}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<ReZ[\[CapitalOmega]]\>\"", ",", "\"\<ImZ[\[CapitalOmega]]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.009", "]"}], ",", "Red"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pict.png\>\"", ",", "%", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.640413615172921*^9, 3.640413681001046*^9}, {
  3.640413754829171*^9, 3.640413758188546*^9}, {3.640413799172921*^9, 
  3.640413812782296*^9}, {3.640414121501046*^9, 3.640414141922921*^9}},
 ExpressionUUID -> "5ea0bcfe-0897-4b5e-b0c5-8fa44af27aae"]
},
WindowSize->{1080, 617},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->2.299999952316284,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 480, 12, 173, "Input"],
Cell[1028, 34, 561, 11, 94, "Input"],
Cell[1592, 47, 1197, 34, 265, "Input"],
Cell[2792, 83, 548, 12, 134, "Input"],
Cell[3343, 97, 526, 15, 226, "Input"],
Cell[3872, 114, 473, 14, 65, "Input"],
Cell[4348, 130, 279, 7, 94, "Input"],
Cell[4630, 139, 1902, 54, 446, "Input"]
}
]
*)

