

BeginPackage["GeneticOperators`"]

DiagonalCrossover::usage=""
NPointCrossover::usage=""
UniformCrossover::usage=""

RouletteWheelSelection::usage=""
TurnajovaSelekce::usage=""

Mutation::usage=""

Inversion::usage="Inversion[string] gives the bit inversion of string."

Begin["Private`"];

Clear[RandomPositionsSelection];
RandomPositionsSelection[ number_, range_ ] := Module[{PositionArray, RangeArray},
  If[number>range, Throw["RandomPositionsSelection::You are selecting more indexes than you can"]];
  RangeArray=Range[range];
  PositionArray=Sort[Table[
      Module[{index, value},
        index=Random[Integer, {1, Length[RangeArray]}];
        value=RangeArray[[index]];
        RangeArray=Delete[RangeArray, index];
        value],
   {number}]];
   PositionArray
];

Clear[SplitString];
SplitString[string_, cutpoints_] := Module[{SplittedArray},
  SplittedArray=Table[
      Take[string, {cutpoints[[i]]+1, cutpoints[[i+1]]}]
  , {i, 1, Length[cutpoints]-1}];

  If[Last[cutpoints]<Length[string], AppendTo[SplittedArray, Take[string, {Last[cutpoints]+1, Length[string]}]]];
  PrependTo[SplittedArray, Take[string,{1,cutpoints[[1]]}]];

  SplittedArray
];



(***************************************************
 * Recombination                                   *
 ***************************************************)

Clear[DiagonalCrossover];
DiagonalCrossover[ parents_ ] := Module[{NumberOfParents, CutPositionsArray, SplittedParents},
  If [Global`debugMode, Print["DiagonalCrossover ", parents]];
  NumberOfParents=Length[parents];
  If[NumberOfParents<2, Return[parents];];

  CutPositionsArray=RandomPositionsSelection[NumberOfParents-1, Length[parents[[1]]]-1];
  SplittedParents=Table[SplitString[parents[[i1]], CutPositionsArray], {i1, 1, NumberOfParents}];

  Table[
      Flatten[ Table[
      If[(i2+i3-1)>NumberOfParents,
        SplittedParents[[(i2+i3-1)-NumberOfParents, i3]],
        SplittedParents[[i2+i3-1, i3]]]
      ,
        {i3,1,NumberOfParents}
      ]],
    {i2, 1, NumberOfParents}
  ]
];


Clear[NPointCrossover];
NPointCrossover[ parents_, NumberOfCrossoverPoints_ ] := Module[{CutPositionsArray, SplittedParents, idx},
  If [Global`debugMode, Print["NPointCrossover ", parents, NumberOfCrossoverPoints]];
  If [ Length[parents]!= 2, Throw["NPointCrossover::bad number of parents"]];
  CutPositionsArray=RandomPositionsSelection[NumberOfCrossoverPoints, Length[parents[[1]]]-1];
  SplittedParents=Table[SplitString[parents[[idx]], CutPositionsArray], {idx, 1, 2}];

  {Flatten[Table[
    If[OddQ[i2], SplittedParents[[1, idx]], SplittedParents[[2, idx]]],
    {idx, 1, NumberOfCrossoverPoints+1}]],
   Flatten[Table[
    If[EvenQ[idx], SplittedParents[[1, idx]], SplittedParents[[2, idx]]],
    {idx, 1, NumberOfCrossoverPoints+1}]]}
  ];

Clear[UniformCrossover];
UniformCrossover[ parents_ ] := Module[{idx, uniform, potomek1, potomek2},
  If [Global`debugMode, Print["UniformCrossover ", parents]];

  If [ Length[parents]!= 2, Throw["UniformCrossover::bad number of parents"]];

  uniform = Table[If[OddQ[Random[Integer, {1, 10}]], 0, 1], {idx, 1,Length[parents[[1]]]}];

  potomek1 = {}; potomek2 = {};
  Table[
    If[uniform[[i]] == 0,
      AppendTo[potomek1, parents[[1,i]]]; AppendTo[potomek2, parents[[2,i]]];
      ,
      AppendTo[potomek1, parents[[2,i]]]; AppendTo[potomek2, parents[[1,i]]];
      ]
      , {i, 1, Length[parents[[1]]]}];
      {potomek1, potomek2}
];



(***************************************************
 * Selection                                       *
 ***************************************************)

Clear[RouletteWheelSelection];
RouletteWheelSelection[gen_] :=
Module[{ruleta, temp, jmin, jmax, suma = 0.0, nahodne, tempsum, ix, i},
       (* vytvor ruletu *)
       (*
     temp = Sort[Union[gen], Last[#1] <= Last[#2] &];*)
       (*
     jmin = Last[First[temp]];*)
       (*    jmax = Last[Last[temp]];*)

       jmax = Last[NajdiMaximum[gen]];
(*       Print["jmax=", jmax];
       Throw["RouletteWheelSelection"]; *)
       ruleta = Table[jmax - Last[gen[[i]]], {i, 1, Length[gen]}];
(*       Print["ruleta=", ruleta]; *)
       Do[suma += ruleta[[i]], {i, 1, Length[ruleta]}];
       Table[
          tempsum = 0.0;
          ix = -1;
(*             Print["suma=", suma]; *)
          nahodne = Random[Real, {0.0, suma}];
          Do[tempsum += ruleta[[i]];
             If[tempsum > nahodne, ix = i; Break[]], {i, 1, Length[ruleta]}];
          If[ix == -1, Print["nahodne=", nahodne, "  suma=", suma];
             Throw["renonc"]];
          gen[[ix]]
          , {Length[gen]}]
];

Clear[TurnajovaSelekce];
TurnajovaSelekce[gen_] := Module[{vel, i1, i2},
                              vel = Length[gen];
                              Table[
                                    i1 = Random[Integer, {1, vel}];
                                    i2 = Random[Integer, {1, vel}];
                                    If[Last[gen[[i1]]] < Last[gen[[i2]]], gen[[i1]], gen[[i2]]],
                              {vel}]
];

(*
ElitePool=Null;
Clear[Elitism];
Elitism[] := Module[{},

];
*)



Clear[Mutation];
Mutation[ string_ ] := Module[{idx},
  If [Global`debugMode, Print["Mutation ", string]];
  Table[
    If[ Random[] < Global`pravdepodobnostMutace,
      1 - string[[idx]],
      string[[idx]]]
   , {idx, 1, Length[string]}]
];


(***************************************************
 * Advanced                                        *
 ***************************************************)

Clear[Inversion];
Inversion[ string_ ] := Module[{i}, Table[ 1 - string[[i]], {i, 1, Length[string]}]];

End[ ]
EndPackage[ ]

