(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10014,        291]
NotebookOptionsPosition[      8362,        261]
NotebookOutlinePosition[      8811,        278]
CellTagsIndexPosition[      8768,        275]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"234da35c-d316-41d5-9c47-6f3e137eccb5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costCoefficients", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "0.1", ",", "0.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "0.15", ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "0.08", ",", "0.006"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minMaxPowers", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "1000"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482721896609375*^9, 3.482722028265625*^9}, {
  3.4827221586875*^9, 3.48272216184375*^9}, {3.688282390202379*^9, 
  3.688282403805603*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"79ccb28a-28ca-4626-a187-2c10c954dd29"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fCost", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", "power"}], "+", 
    RowBox[{"c", "*", 
     SuperscriptBox["power", "2"]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6882824195772305`*^9, 3.688282420778433*^9}, {
  3.6882824978581686`*^9, 3.6882825041449795`*^9}, {3.688282570959897*^9, 
  3.6882825924255342`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"e33bb5ed-66c5-4bb1-8807-9856ed5a57e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fCost", "[", 
  RowBox[{"P", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6882825204158077`*^9, 3.6882825290270233`*^9}, 
   3.688282596060341*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"e254cb1e-007e-4063-82e5-61100b4b160d"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "P"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["P", "2"]}]}]], "Output",
 CellChangeTimes->{3.8751757480409684`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"66f4d899-2a7a-4b1e-83ff-3ccc1cfee667"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"powers", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"cost", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"MapThread", "[", 
    RowBox[{"fCost", ",", 
     RowBox[{"{", 
      RowBox[{"powers", ",", "costCoefficients"}], "}"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.688282620068783*^9, 3.688282641799621*^9}, 
   3.8751757639239597`*^9},ExpressionUUID->"306cb4bb-36f6-4cb2-9fce-\
16d1f2e8cfd2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fPowerConstrains", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "\[LessEqual]", "power", "\[LessEqual]", "b"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"powerConstrains", "=", 
  RowBox[{"MapThread", "[", 
   RowBox[{"fPowerConstrains", ",", 
    RowBox[{"{", 
     RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.688282714136948*^9, 
  3.688282748129408*^9}},ExpressionUUID->"4a9438b9-3cac-42a5-bf34-\
72f3be8cf65a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"desiredPower", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"conditionOfDesiredPower", "=", 
  RowBox[{"{", 
   RowBox[{"desiredPower", "\[Equal]", 
    RowBox[{"Total", "[", "powers", "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.6882827763654575`*^9, 3.6882828010447006`*^9}, {
  3.844309941484375*^9, 
  3.844309945625*^9}},ExpressionUUID->"692bcd0a-0c27-420c-b375-f72ceb540306"],

Cell[BoxData[
 RowBox[{"condionsTogether", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"powerConstrains", ",", "conditionOfDesiredPower"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.68828286884242*^9, 
  3.6882828998240747`*^9}},ExpressionUUID->"aced9c39-8e4d-40a7-880c-\
82f02692fe16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cost", "}"}], ",", "condionsTogether"}], "]"}], ",", 
    "powers"}], "]"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.8443099710625*^9, 
  3.844309993640625*^9}},ExpressionUUID->"09349f6f-2e09-42de-b17c-\
504e88ec33ff"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strmost", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "fPenale", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fPenale", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Tanh", "[", 
           RowBox[{"strmost", "*", 
            RowBox[{"(", 
             RowBox[{"x", "-", "a"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"strmost", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "b"}], ")"}]}], "]"}]}], ")"}]}], ")"}], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], "2"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fPenale", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<penale\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.844310042296875*^9, 
  3.844310042546875*^9}},ExpressionUUID->"0dbf1b99-124f-4be3-9ec9-\
ee33f72c1bde"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaleCelkovyVykon", "=", 
   RowBox[{"100", "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"desiredPower", "-", 
       RowBox[{"Total", "[", "powers", "]"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"penaleVykonovaOmezeni", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"MapThread", "[", 
     RowBox[{"fPenale", ",", 
      RowBox[{"{", 
       RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.844310083015625*^9, 
  3.844310114890625*^9}},ExpressionUUID->"1a9d1f55-e008-4f75-8856-\
4217a1be149a"],

Cell[BoxData[
 RowBox[{"FminNeomezena", "=", 
  RowBox[{
  "cost", "+", "penaleCelkovyVykon", "+", 
   "penaleVykonovaOmezeni"}]}]], "Input",
 CellChangeTimes->{{3.84431012025*^9, 
  3.844310120796875*^9}},ExpressionUUID->"ec8d7cdc-bd41-4832-bcfe-\
a712886ab605"],

Cell[BoxData[{
 RowBox[{"startHledani", "=", 
  RowBox[{"minMaxPowers", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{"a", "+", "b"}], "2."]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"zacatek", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{"powers", ",", "startHledani"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"FminNeomezena", ",", "zacatek"}], "]"}]}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.844310162046875*^9, 
  3.844310178796875*^9}},ExpressionUUID->"de3c6c6c-1aac-4add-9715-\
56d7baf506f9"]
},
WindowSize->{1260, 874},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.1 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 172, 3, 60, "Input",ExpressionUUID->"234da35c-d316-41d5-9c47-6f3e137eccb5"],
Cell[733, 25, 975, 27, 181, "Input",ExpressionUUID->"79ccb28a-28ca-4626-a187-2c10c954dd29"],
Cell[1711, 54, 566, 14, 60, "Input",ExpressionUUID->"e33bb5ed-66c5-4bb1-8807-9856ed5a57e0"],
Cell[CellGroupData[{
Cell[2302, 72, 314, 7, 60, "Input",ExpressionUUID->"e254cb1e-007e-4063-82e5-61100b4b160d"],
Cell[2619, 81, 253, 6, 68, "Output",ExpressionUUID->"66f4d899-2a7a-4b1e-83ff-3ccc1cfee667"]
}, Open  ]],
Cell[2887, 90, 574, 17, 141, "Input",ExpressionUUID->"306cb4bb-36f6-4cb2-9fce-16d1f2e8cfd2"],
Cell[3464, 109, 594, 16, 101, "Input",ExpressionUUID->"4a9438b9-3cac-42a5-bf34-72f3be8cf65a"],
Cell[4061, 127, 432, 9, 101, "Input",ExpressionUUID->"692bcd0a-0c27-420c-b375-f72ceb540306"],
Cell[4496, 138, 287, 7, 60, "Input",ExpressionUUID->"aced9c39-8e4d-40a7-880c-82f02692fe16"],
Cell[4786, 147, 353, 10, 60, "Input",ExpressionUUID->"09349f6f-2e09-42de-b17c-504e88ec33ff"],
Cell[5142, 159, 1622, 48, 381, "Input",ExpressionUUID->"0dbf1b99-124f-4be3-9ec9-ee33f72c1bde"],
Cell[6767, 209, 633, 19, 141, "Input",ExpressionUUID->"1a9d1f55-e008-4f75-8856-4217a1be149a"],
Cell[7403, 230, 263, 7, 60, "Input",ExpressionUUID->"ec8d7cdc-bd41-4832-bcfe-a712886ab605"],
Cell[7669, 239, 689, 20, 147, "Input",ExpressionUUID->"de3c6c6c-1aac-4add-9715-56d7baf506f9"]
}
]
*)

(* End of internal cache information *)

