(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     24915,        669]
NotebookOptionsPosition[     21515,        600]
NotebookOutlinePosition[     22571,        630]
CellTagsIndexPosition[     22491,        625]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"loses", "=", 
   RowBox[{
    RowBox[{"R1", "*", 
     SuperscriptBox["i1", "2"]}], "+", 
    RowBox[{"R2", "*", 
     SuperscriptBox["i2", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Uz", "=", 
   RowBox[{"750", "*", 
    SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P1", "=", 
   RowBox[{"i1", "*", 
    RowBox[{"(", 
     RowBox[{"Uz", "-", 
      RowBox[{"R1", "*", "i1"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P2", "=", 
   RowBox[{"i2", "*", 
    RowBox[{"(", 
     RowBox[{"Uz", "-", 
      RowBox[{"R2", "*", "i2"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"condition", "=", 
   RowBox[{
    RowBox[{"P1", "+", "P2"}], "\[Equal]", 
    RowBox[{"2000", "*", 
     SuperscriptBox["10", "6"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expressionToBeminimized", "=", "loses"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quiet", "@", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"expressionToBeminimized", ",", "condition"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "i2"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8751722121097817`*^9, 3.8751722196717825`*^9}, {
  3.875172383301262*^9, 3.8751725573206577`*^9}, {3.8751726046768074`*^9, 
  3.875172644915244*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"a737ad8f-a8e9-4df2-a68e-5ae9197a0999"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.345461371620796`*^6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i1", "\[Rule]", "1343.080654477175`"}], ",", 
     RowBox[{"i2", "\[Rule]", "1330.7132912821528`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8751726280970745`*^9, 3.875172646087041*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"63805479-52ef-464b-8261-c978c2a9ffe5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"<<", "Graphics`ImplicitPlot`"}]}]], "Input",
 CellChangeTimes->{{3.875155943484375*^9, 
  3.8751559463125*^9}},ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"<<", "Graphics`Graphics`"}]}]], "Input",
 CellChangeTimes->{{3.875155938859375*^9, 
  3.875155940484375*^9}},ExpressionUUID->"d5574ba4-00f1-47f3-893d-\
fa79927fb4ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"3", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8751732558736277`*^9, 3.875173263482484*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"87beaab4-22e4-425b-b802-1c3e89f623e8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6.`"}], ",", 
     RowBox[{"y", "\[Rule]", "4.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.875173273278694*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"26165986-4fb4-469b-91b2-a9dcb03ebaba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"ConstrainedMin", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", " ", "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
      RowBox[{"x", ">", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.875155931109375*^9, 3.87515593253125*^9}, 
   3.8751731924716997`*^9, {3.8751732818874807`*^9, 3.8751732832357006`*^9}},
 CellTags->"LinearProgramming",
 CellLabel->"In[49]:=",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.843699663883998*^9, {3.875155918359375*^9, 3.87515593490625*^9}, 
   3.875172686662386*^9, 3.875173193221629*^9, 3.87517328397001*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[49]=",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "1"}]},
      {"1", "0"}
     }], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LinearProgramming",
 CellLabel->"In[46]:=",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.843699663906126*^9, 3.875155918484375*^9, 
  3.875172689037224*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[46]=",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "*", 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{
    RowBox[{".02", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"0.05", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    SuperscriptBox["y", "2"], "-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{"podminka", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "45"}], "}"}]}], "]"}]}], "Input",ExpressionUUID\
->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],

Cell[BoxData[
 GraphicsBox[{{LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAvxBy3v//E8B6Fn9OjdoMwAWB+4h+
6hPAPN7bkcvCDMAU/fwjIKoTwESXnJOAfAzACDjiP1U/E8CESxvikgoMwH0C
RZ3YqhLAwmYnorxxC8Cyf1jmre0RwPZqMs9guArADhXT6B8JEcDOM8JwTOYJ
wJRQ4qZ8/Q/AL5ldgWEECcA+mQj2taANwEef9wcqHAjAIkaqVw0AC8CfbhhP
VDcHwPz20BkbIAjA7nrJrR1fBsCWpvE25gUFwJWX5Ke3mwXAJqJVi9u2AcDh
WP58ufMEwKhZsrCIcfy/w6aqY7NrBMBcJC5MeCP1v/AWopP1BQTAxN3LVJgg
678wV25Nk8IDwLi6fpsNFde/x8G2i5yfA8AYmU+WCYDBPxLJvKJ9mQPAAmDM
9y2D5D/YOiM2b6sDwCRM1MhhYfI/pToPOePPA8BHaMKVLIH6P4q29FziAATA
klJvL2FJAUBwGUS5VDgEwHsjRHwDRAVACSnHEzZwBMCVQwfehykJQL5VHEi5
ogTAUl7r7h3zDEAjRUpLX8oEwHy8lhATTRBA3DCIAQbiBMAl9xSqHgwSQLqD
k0fy5ATAXfni/6OzE0D3Oaih184EwJChUnG+QBVAh4RwL9+bBMAjST+Qt7AW
QLAbnd6uSATAsXJu3wsBGEDAVNxacdIDwFxO2zdvLxlAKiNK4N42A8AgOz3N
0DkaQHbbYdNGdALAxKXCyl4eG0B+LiHPmYkBwI8or4GJ2xtATsFGsnN2AMAa
XkwkBnAcQKOc+SlKdv6/JiNnCNHaHEBOCQ/1drH7vxenZW0vGx1AXRYRTQ+i
+L/RNtzCsDAdQEMh5DuNUfW/LTkfwQ==
     "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAvxBy3v//E8CdBQ1wjdoCQAWB+4h+
6hPAQMTmeEHYAkAU/fwjIKoTwO65UxOo0QJACDjiP1U/E8AxRJKenccCQH0C
RZ3YqhLANajOXoa7AkCyf1jmre0RwKGRieg7rwJADhXT6B8JEcDzJ2Y876QC
QJRQ4qZ8/Q/AfAS1Z/yeAkA+mQj2taANwDJNpgutnwJAIkaqVw0AC8C3c+dn
6agCQPz20BkbIAjAuN/759u7AkCWpvE25gUFwB0VMGiR2AJAJqJVi9u2AcAb
hIunpv0CQKhZsrCIcfy/DdsFfRYoA0BcJC5MeCP1v+bq/FA5UwNAxN3LVJgg
679XDmZ5/HgDQLi6fpsNFde/Igj8sEqSA0AYmU+WCYDBPxfno6CTlwNAAmDM
9y2D5D8hQHXFW4EDQCRM1MhhYfI/fnhDgcBIA0BHaMKVLIH6P109mhHj5wJA
klJvL2FJAUDvU3nRNFoCQHsjRHwDRAVAkcX+DKWcAUCVQwfehykJQAZNCwu0
rQBAUl7r7h3zDEAuv3Jp4Br/P3y8lhATTRBA5ksNfMR6/D8l9xSqHgwSQIot
BjjZgPk/Xfni/6OzE0BecOK5QzX2P5ChUnG+QBVAFwb8pimi8j8jST+Qt7AW
QIQekhuUpu0/sXJu3wsBGEC7/b3rJavlP1xO2zdvLxlAfm9i0tza2j8gOz3N
0DkaQJokqRM9JsQ/xKXCyl4eG0AYSDI12iK7v48or4GJ2xtAu9GGz9aB178a
XkwkBnAcQJrjgpoO8uO/JiNnCNHaHECwiNbvi9/rvxenZW0vGx1AKyVHyri5
8b/RNtzCsDAdQLELXOnpSPW/rVgcaA==
     "]]}, {}, {LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAMFq3HteyP0Cq6BKfhR85wI1G582n
uD9AwPTb8s7ROcBX0SSwD8o/QEzo+aAgmDrAi9NBVfDmP0B9HUtibHI7wPRb
t56LB0BAtIY4QFphPMBt7cQYHyFAQFPCBwl5ZT3Aqq703gVAQEAUh1YLOX8+
wJBYZOcJZEBAeFLpoeauP8CvKKQ27IxAQMyc601SekDAUJLaTWW6QEBLotxP
MyhBwHYpy6cl7EBAKPge1/XgQcD5I+ZD1iFBQOxvHXZcpELAiEJtPhlbQUBi
1mJvCnJDwAoSpHSKl0FArDN8ooFJRMDtZewzwNZBQC7ZWt0gKkXAANKc8ksY
QkCvePmmIhNGwDfoTRG7W0JAoQBhlpwDR8CFMUyjl6BCQHXRyUZ/+kfAAVvQ
PGnmQkAXe4n2lvZIwJj3lMW1LENA6qzY2oz2ScAvlFlOAnNDQGBGWi7p+ErA
q73d59O4Q0BMHMr7FfxLwPkG3Hmw/UNAsil6oWL+TMAwHY2YH0FEQHvRawUI
/k3AQ4k9V6uCREBQ2wVtLflOwCbdhRbhwURAzvXL5u3tT8CorLxMUv5EQCKx
GhgvbVDAN8tDR5U3RUCtkfd+Sd5QwLrFXuNFbUVA4SrMxFNJUcDgXE89Bp9F
QA5duyJirVHAgcaFVH/MRUCoPGnKkglSwKCWxaNh9UVA1vVUMxFdUsCGQDWs
ZRlGQF70JEgZp1LAwwFlckw4RkBqCghj+uZSwDyTcuzfUUZAdOsXCRocU8Bq
BYlg82VGQDKY21X2RVPAhIYXs2N0RkCk9ZsJKGRTwOpLNqQXfUZAJr0nL2R2
U8AYQs77/39GQOva2U99fFPAgagpIA==
     "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAMFq3HteyP0DF3B4L7h05wI1G582n
uD9AGIm9UxV+OMBX0SSwD8o/QEJwN3EJ7zfAi9NBVfDmP0CzqL4VtHA3wPRb
t56LB0BAHO0gtC4CN8Bt7cQYHyFAQBFVU8qPojbAqq703gVAQED8zOYd7VA2
wJBYZOcJZEBAaGMHgF0MNsCvKKQ27IxAQCXcATP60zXAUJLaTWW6QEAq0cj+
36Y1wHYpy6cl7EBA3swEATCENcD5I+ZD1iFBQJXd2UQQazXAiEJtPhlbQUBs
euctrFo1wAoSpHSKl0FA/ZMVwTRSNcDtZewzwNZBQD2kl9TgUDXAANKc8ksY
QkASDkQv7VU1wDfoTRG7W0JA6XUInpxgNcCFMUyjl6BCQAJq9AQ4cDXAAVvQ
PGnmQkA53RdwDoQ1wJj3lMW1LENAh6NTJ3WbNcAvlFlOAnNDQPSbPMfHtTXA
q73d59O4Q0CIxFhgaNI1wPkG3Hmw/UNAfARInb/wNcAwHY2YH0FEQIZE1+88
EDbAQ4k9V6uCREDAm4jEVjA2wCbdhRbhwURAiHrDu4pQNsCorLxMUv5EQGso
oOddcDbAN8tDR5U3RUBTBhcNXY82wLrFXuNFbUVAFG5C5xytNsDgXE89Bp9F
QEqyVms6yTbAgcaFVH/MRUA4APQLW+M2wKCWxaNh9UVArHF/+iz7NsCGQDWs
ZRlGQAeMQWVnEDfAwwFlckw4RkAIKR+xyiI3wDyTcuzfUUZAfwrdrSAyN8Bq
BYlg82VGQAgd/cM8PjfAhIYXs2N0RkDb2WUb/EY3wOpLNqQXfUZAf6QnukVM
N8AYQs77/39GQDTn2JoKTjfA/7gctw==
     "]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.8436996639529943`*^9, 
  3.8751559186875*^9},ExpressionUUID->"bad380df-5f1f-4f82-8d37-427ebc24ec48"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"fce", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{"podminka", "\[Equal]", "0"}]}], "}"}], "]"}], "//", "N"}]}], 
  ";"}]}], "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "res"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Element]", "Reals"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7.288691475657751`", ",", 
     RowBox[{"-", "1.4684090963636374`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.023120364927266`", ",", 
     RowBox[{"-", "23.092495749238093`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8436996641222625`*^9, 
  3.875155919203125*^9},ExpressionUUID->"81efd811-368e-429d-b6d2-\
c34855317e43"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{"podminka", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "20"}], ",", "45"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", ".03", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DisplayTogether", "::", "\<\"obslt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The DisplayTogether and \
DisplayTogetherArray functions are obsolete in Version 6. GraphicsArray and \
Show may be used directly in the same role.\\\\\\\"\\\", \
\\\"MT\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.87515591925*^9},ExpressionUUID->"8e7323b5-5f9b-4c0e-9251-8be77e50fa6c"],

Cell[BoxData[
 GraphicsBox[{{{LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAcUUY9f//M8Dgh562O086wHKQf9UQ
9DPA/5Rm6zozOsDL8lJVWNAzwDCp9QvC3znAyBjs6xSVM8B0EtF5alY5wJkk
JDyuQjPAGo6MHtSZOMD+IhhftNkywICJeyqWrTfAXJcr6N5aMsByn4xgKpY2
wHDJAaQLxzHATbKXlNNYNcDcOJ8UPR8xwLhVcS6A+zPAxH5ZrZhkMMBo+7uw
qYQywKVPWKPJMC/AYAUHcDL7MMBh2ec0DXgtwAE8sq6FzC7A5dHsyv6hK8BV
3FeZT5orwFiz9GbUsSnA3ithAWhuKMBGvxWz8aonwG+pdkRMVyXARk+dFOKQ
JcAQMtGnK2MiwA5XQ3lSZyPAvBH9rqA/H8Dp/bnpCjIhwAzhLSwiNRrApoKt
2c/pHcDt8wJPXsAVwPbsyo2nZxnA6MJWiqj4EcBGV+hBf+UUwN4m+dOU4A3A
Gt4hSDlrEMCXYPJ58V0JwKFXHlJUAQjAagO/bdNWBsB87WzJK7b+v/O8pht8
kwTA+NpSq13L67/jZLc/zsQDwGCYcUo2i8I/Wx6MspqZA8B4Jw/pudLxP6kP
WLXrzAPArLFznJZBAEDF3EM21SkEwLyKNVaIJAdAYCTKm2eJBMBEQqAzJ4YN
QJXsMiYzzwTAhAnnNqWtEUDV57e1SuYEwNJLcXTfTBRAhiQ0FC2/BMCCgxiF
LJwWQNXNAdFzTgTADrLKYIKXGECQ9N20D4wDwHi4+tRpOxpAMKn5R+RyAsAy
iRqUBIUbQPU+jCahAAHAQPG1ORJyHEAdWjOvg2v+v9pnaDr0AB1A3gCfZ0Yr
+r/YO8u4sDAdQEltvykoUvW/GmYxow==
      "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAcUUY9f//M8Dg87cx7zwZQHKQf9UQ
9DPA7O1lhUgsGUDL8lJVWNAzwOuFWVJ/+hhAyBjs6xSVM8DZpDA6FKgYQJkk
JDyuQjPApj40O941GED+IhhftNkywFJol7sLpRdAXJcr6N5aMsDiZ+dHJPcW
QHDJAaQLxzHAWMdrWAsuFkDcOJ8UPR8xwPW/oJsETBVAxH5ZrZhkMMDL6TOA
ulMUQKVPWKPJMC/AQl6JD0hIE0Bh2ec0DXgtwLG3c6VHLRJA5dHsyv6hK8DP
cvK76AYRQFiz9GbUsSnAd+Ctqx+0D0BGvxWz8aonwHR0dakIWQ1ARk+dFOKQ
JcDWJGeSXwoLQA5XQ3lSZyPAaAmQa9zYCEDp/bnpCjIhwHucHGq+2AZApoKt
2c/pHcA6ILeI+CEFQPbsyo2nZxnAN2AxCLPOA0BGV+hBf+UUwPSB/Njw9QJA
Gt4hSDlrEMBuWEM6pKACQKFXHlJUAQjAwdiuuNO8AkB87WzJK7b+v9GRQCY0
GgNA+NpSq13L67/vpYiEjXcDQGCYcUo2i8I/oCpogHSXA0B4Jw/pudLxPyfo
JdnaTQNArLFznJZBAEB8CHOaAoMCQLyKNVaIJAdADsj/EXgwAUBEQqAzJ4YN
QMxNXlAPuf4/hAnnNqWtEUDepI8eTCz6P9JLcXTfTBRAooa2xnPj9D+CgxiF
LJwWQOSQnIy3Gu4/DrLKYIKXGEBVIM8ab7bhP3i4+tRpOxpA4jLdnI3uwz8y
iRqUBIUbQMSn3GNc5M6/QPG1ORJyHECG/qW3QBPkv9pnaDr0AB1AQHyfZ5XI
77/YO8u4sDAdQAd+Ht5OSPW/TGglGg==
      "]]}, {}, {LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAA7pg7IdeyP0CA+gI0oh85wPxRadCn
uD9A4buLG8/ROcCzRqCyD8o/QMg2SLcgmDrAkluyV/DmP0B7OG1ybHI7wDwH
6J+LB0BA1iE2TVphPMAv6+sZHyFAQKIpEhR5ZT3ACfsP4AVAQEAw1wEVOX8+
wCMEcugJZEBAwfyFquauP8DfW6I37IxAQIPPyVFSekDAlpDHTmW6QED9V1hT
MyhBwGJUpagl7EBAAhBA2vXgQcAG/qtE1iFBQN0X6HhcpELAuHEdPxlbQUCS
ydhxCnJDwERiPXWKl0FAAoadpIFJRMAWy200wNZBQBWCJt8gKkXA0GkF80sY
QkBNt22oIhNGwMf7nBG7W0JAeqh7l5wDR8CMNoGjl6BCQKeHiEd/+kfAxvTq
PGnmQkBF6en2lvZIwJj3lMW1LENA6qzY2oz2ScBq+j5OAnNDQBAI+C3p+ErA
pLio59O4Q0C1RgT7FfxLwGnzjHmw/UNAHPhPoGL+TMBghSSYH0FEQD4s3QMI
/k3AGiS8VquCRECdbBNrLflOwOyM7BXhwURAjzp35O3tT8B4fQxMUv5EQDZb
wBYvbVDAKvF9RpU3RUAC5W59Sd5QwM6ahOJFbUVAbT4Xw1NJUcCaXmI8Bp9F
QKa83CBirVHAUZOHU3/MRUBJ5mPIkglSwA3rt6Jh9UVArVQsMRFdUsAn9Bmr
ZRlGQLTZ3EUZp1LAAQQ+cUw4RkB9pKRg+uZSwPTnQevfUUZAmrqdBhocU8Bn
wVBf82VGQEJiT1P2RVPA1svZsWN0RkD1twIHKGRTwDJG9aIXfUZAmZ2GLGR2
U8C5Ioz6/39GQP0XNk19fFPAVSUmUA==
      "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAA7pg7IdeyP0CL9Sh+0R05wPxRadCn
uD9AU2gCMxV+OMCzRqCyD8o/QL41zWIJ7zfAkluyV/DmP0Cm8GQNtHA3wDwH
6J+LB0BAUsvEri4CN8Av6+sZHyFAQJ4juMaPojbACfsP4AVAQEDk72wb7VA2
wCMEcugJZEBAycNSfl0MNsDfW6I37IxAQPJQ2DH60zXAlpDHTmW6QEBXLQP+
36Y1wGJUpagl7EBA8WKHADCENcAG/qtE1iFBQO5nkEQQazXAuHEdPxlbQUDL
tcItrFo1wERiPXWKl0FAjcQJwTRSNcAWy200wNZBQJ6gm9TgUDXA0GkF80sY
QkAxm1Av7VU1wMf7nBG7W0JAXNUXnpxgNcCMNoGjl6BCQD8JAgU4cDXAxvTq
PGnmQkDXGiBwDoQ1wJj3lMW1LENAh6NTJ3WbNcBq+j5OAnNDQJ0mMsfHtTXA
pLio59O4Q0DmLEJgaNI1wGnzjHmw/UNAPBQknb/wNcBghSSYH0FEQOwrpe88
EDbAGiS8VquCRECp5EfEVjA2wOyM7BXhwURAgv1zu4pQNsB4fQxMUv5EQKID
QuddcDbAKvF9RpU3RUCslaoMXY82wM6ahOJFbUVAOETI5hytNsCaXmI8Bp9F
QIiSz2o6yTbAUZOHU3/MRUDX2GALW+M2wA3rt6Jh9UVArFbh+Sz7NsAn9Bmr
ZRlGQD+ymWRnEDfAAQQ+cUw4RkBq4W6wyiI3wPTnQevfUUZAjL0lrSAyN8Bn
wVBf82VGQGlGQMM8PjfA1svZsWN0RkATBKUa/EY3wDJG9aIXfUZAm2RkuUVM
N8C5Ioz6/39GQJTYFJoKTjfAg9oivA==
      "]]}}, 
   {Hue[0], PointSize[0.03], 
    PointBox[{{7.288691475657751, -1.4684090963636374`}, {
     32.023120364927266`, -23.092495749238093`}}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.8436996643384323`*^9, 
  3.8751559194375*^9},ExpressionUUID->"993617da-9b25-4ee5-b6bb-0f5a7196a829"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "-", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"], "-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"expr", "+", 
    RowBox[{"\[Lambda]", "*", "g"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0", "\[Equal]", 
     RowBox[{"D", "[", 
      RowBox[{"lagrange", ",", "#"}], "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], 
    "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.875174104422234*^9, 3.875174208893548*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"7ada0e89-d4f8-4e65-a924-8ddf11b99556"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.8751742096122427`*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"d34c8c1c-ee81-4cee-bc63-f3c3de903389"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.875174209627857*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"5dbb780a-1023-400d-9510-fd0830209e94"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.875174209627857*^9}},
 CellLabel->"Out[40]=",ExpressionUUID->"2691dda0-71c8-4de6-85df-d0a2b3f46411"]
}, Open  ]]
},
WindowSize->{1006, 646},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification:>2.05 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearProgramming"->{
  Cell[4128, 134, 709, 19, 99, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
   CellTags->"LinearProgramming"],
  Cell[4840, 155, 456, 11, 67, "Output",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646",
   CellTags->"LinearProgramming"],
  Cell[5333, 171, 525, 18, 182, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
   CellTags->"LinearProgramming"],
  Cell[5861, 191, 273, 6, 67, "Output",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5",
   CellTags->"LinearProgramming"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearProgramming", 21945, 613}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1763, 52, 539, "Input",ExpressionUUID->"a737ad8f-a8e9-4df2-a68e-5ae9197a0999"],
Cell[2346, 76, 393, 9, 72, "Output",ExpressionUUID->"63805479-52ef-464b-8261-c978c2a9ffe5"]
}, Open  ]],
Cell[2754, 88, 215, 4, 58, "Input",ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],
Cell[2972, 94, 215, 5, 58, "Input",ExpressionUUID->"d5574ba4-00f1-47f3-893d-fa79927fb4ff"],
Cell[CellGroupData[{
Cell[3212, 103, 563, 16, 99, "Input",ExpressionUUID->"87beaab4-22e4-425b-b802-1c3e89f623e8"],
Cell[3778, 121, 313, 8, 67, "Output",ExpressionUUID->"26165986-4fb4-469b-91b2-a9dcb03ebaba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4128, 134, 709, 19, 99, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
 CellTags->"LinearProgramming"],
Cell[4840, 155, 456, 11, 67, "Output",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5333, 171, 525, 18, 182, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
 CellTags->"LinearProgramming"],
Cell[5861, 191, 273, 6, 67, "Output",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6171, 202, 700, 21, 139, "Input",ExpressionUUID->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],
Cell[6874, 225, 4745, 105, 921, "Output",ExpressionUUID->"bad380df-5f1f-4f82-8d37-427ebc24ec48"]
}, Open  ]],
Cell[11634, 333, 646, 18, 179, "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],
Cell[CellGroupData[{
Cell[12305, 355, 368, 11, 58, "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],
Cell[12676, 368, 410, 11, 67, "Output",ExpressionUUID->"81efd811-368e-429d-b6d2-c34855317e43"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13123, 384, 581, 16, 179, "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],
Cell[13707, 402, 426, 8, 126, "Message",ExpressionUUID->"8e7323b5-5f9b-4c0e-9251-8be77e50fa6c"],
Cell[14136, 412, 4893, 108, 921, "Output",ExpressionUUID->"993617da-9b25-4ee5-b6bb-0f5a7196a829"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19066, 525, 928, 26, 259, "Input",ExpressionUUID->"7ada0e89-d4f8-4e65-a924-8ddf11b99556"],
Cell[19997, 553, 594, 16, 98, "Output",ExpressionUUID->"d34c8c1c-ee81-4cee-bc63-f3c3de903389"],
Cell[20594, 571, 663, 19, 115, "Output",ExpressionUUID->"5dbb780a-1023-400d-9510-fd0830209e94"],
Cell[21260, 592, 239, 5, 93, "Output",ExpressionUUID->"2691dda0-71c8-4de6-85df-d0a2b3f46411"]
}, Open  ]]
}
]
*)

