(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50109,       1163]
NotebookOptionsPosition[     46057,       1084]
NotebookOutlinePosition[     47114,       1114]
CellTagsIndexPosition[     47033,       1109]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"loses", "=", 
   RowBox[{
    RowBox[{"R1", "*", 
     SuperscriptBox["i1", "2"]}], "+", 
    RowBox[{"R2", "*", 
     SuperscriptBox["i2", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Uz", "=", 
   RowBox[{"750", "*", 
    SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P1", "=", 
   RowBox[{"i1", "*", 
    RowBox[{"(", 
     RowBox[{"Uz", "-", 
      RowBox[{"R1", "*", "i1"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P2", "=", 
   RowBox[{"i2", "*", 
    RowBox[{"(", 
     RowBox[{"Uz", "-", 
      RowBox[{"R2", "*", "i2"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"condition", "=", 
   RowBox[{
    RowBox[{"P1", "+", "P2"}], "\[Equal]", 
    RowBox[{"2000", "*", 
     SuperscriptBox["10", "6"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expressionToBeminimized", "=", "loses"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quiet", "@", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"expressionToBeminimized", ",", "condition"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "i2"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8751722121097817`*^9, 3.8751722196717825`*^9}, {
  3.875172383301262*^9, 3.8751725573206577`*^9}, {3.8751726046768074`*^9, 
  3.875172644915244*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"a737ad8f-a8e9-4df2-a68e-5ae9197a0999"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.345461371620796`*^6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i1", "\[Rule]", "1343.080654477175`"}], ",", 
     RowBox[{"i2", "\[Rule]", "1330.7132912821528`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8751726280970745`*^9, 3.875172646087041*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"63805479-52ef-464b-8261-c978c2a9ffe5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"<<", "Graphics`ImplicitPlot`"}]}]], "Input",
 CellChangeTimes->{{3.875155943484375*^9, 
  3.8751559463125*^9}},ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"<<", "Graphics`Graphics`"}]}]], "Input",
 CellChangeTimes->{{3.875155938859375*^9, 
  3.875155940484375*^9}},ExpressionUUID->"d5574ba4-00f1-47f3-893d-\
fa79927fb4ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"3", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8751732558736277`*^9, 3.875173263482484*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"87beaab4-22e4-425b-b802-1c3e89f623e8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6.`"}], ",", 
     RowBox[{"y", "\[Rule]", "4.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.875173273278694*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"26165986-4fb4-469b-91b2-a9dcb03ebaba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"ConstrainedMin", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", " ", "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
      RowBox[{"x", ">", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.875155931109375*^9, 3.87515593253125*^9}, 
   3.8751731924716997`*^9, {3.8751732818874807`*^9, 3.8751732832357006`*^9}},
 CellTags->"LinearProgramming",
 CellLabel->"In[49]:=",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.843699663883998*^9, {3.875155918359375*^9, 3.87515593490625*^9}, 
   3.875172686662386*^9, 3.875173193221629*^9, 3.87517328397001*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[49]=",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "1"}]},
      {"1", "0"}
     }], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LinearProgramming",
 CellLabel->"In[46]:=",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.843699663906126*^9, 3.875155918484375*^9, 
  3.875172689037224*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[46]=",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "*", 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{
    RowBox[{".02", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"0.05", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    SuperscriptBox["y", "2"], "-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{"podminka", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "45"}], "}"}]}], "]"}]}], "Input",ExpressionUUID\
->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],

Cell[BoxData[
 GraphicsBox[{{LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAvxBy3v//E8B6Fn9OjdoMwAWB+4h+
6hPAPN7bkcvCDMAU/fwjIKoTwESXnJOAfAzACDjiP1U/E8CESxvikgoMwH0C
RZ3YqhLAwmYnorxxC8Cyf1jmre0RwPZqMs9guArADhXT6B8JEcDOM8JwTOYJ
wJRQ4qZ8/Q/AL5ldgWEECcA+mQj2taANwEef9wcqHAjAIkaqVw0AC8CfbhhP
VDcHwPz20BkbIAjA7nrJrR1fBsCWpvE25gUFwJWX5Ke3mwXAJqJVi9u2AcDh
WP58ufMEwKhZsrCIcfy/w6aqY7NrBMBcJC5MeCP1v/AWopP1BQTAxN3LVJgg
678wV25Nk8IDwLi6fpsNFde/x8G2i5yfA8AYmU+WCYDBPxLJvKJ9mQPAAmDM
9y2D5D/YOiM2b6sDwCRM1MhhYfI/pToPOePPA8BHaMKVLIH6P4q29FziAATA
klJvL2FJAUBwGUS5VDgEwHsjRHwDRAVACSnHEzZwBMCVQwfehykJQL5VHEi5
ogTAUl7r7h3zDEAjRUpLX8oEwHy8lhATTRBA3DCIAQbiBMAl9xSqHgwSQLqD
k0fy5ATAXfni/6OzE0D3Oaih184EwJChUnG+QBVAh4RwL9+bBMAjST+Qt7AW
QLAbnd6uSATAsXJu3wsBGEDAVNxacdIDwFxO2zdvLxlAKiNK4N42A8AgOz3N
0DkaQHbbYdNGdALAxKXCyl4eG0B+LiHPmYkBwI8or4GJ2xtATsFGsnN2AMAa
XkwkBnAcQKOc+SlKdv6/JiNnCNHaHEBOCQ/1drH7vxenZW0vGx1AXRYRTQ+i
+L/RNtzCsDAdQEMh5DuNUfW/LTkfwQ==
     "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAvxBy3v//E8CdBQ1wjdoCQAWB+4h+
6hPAQMTmeEHYAkAU/fwjIKoTwO65UxOo0QJACDjiP1U/E8AxRJKenccCQH0C
RZ3YqhLANajOXoa7AkCyf1jmre0RwKGRieg7rwJADhXT6B8JEcDzJ2Y876QC
QJRQ4qZ8/Q/AfAS1Z/yeAkA+mQj2taANwDJNpgutnwJAIkaqVw0AC8C3c+dn
6agCQPz20BkbIAjAuN/759u7AkCWpvE25gUFwB0VMGiR2AJAJqJVi9u2AcAb
hIunpv0CQKhZsrCIcfy/DdsFfRYoA0BcJC5MeCP1v+bq/FA5UwNAxN3LVJgg
679XDmZ5/HgDQLi6fpsNFde/Igj8sEqSA0AYmU+WCYDBPxfno6CTlwNAAmDM
9y2D5D8hQHXFW4EDQCRM1MhhYfI/fnhDgcBIA0BHaMKVLIH6P109mhHj5wJA
klJvL2FJAUDvU3nRNFoCQHsjRHwDRAVAkcX+DKWcAUCVQwfehykJQAZNCwu0
rQBAUl7r7h3zDEAuv3Jp4Br/P3y8lhATTRBA5ksNfMR6/D8l9xSqHgwSQIot
BjjZgPk/Xfni/6OzE0BecOK5QzX2P5ChUnG+QBVAFwb8pimi8j8jST+Qt7AW
QIQekhuUpu0/sXJu3wsBGEC7/b3rJavlP1xO2zdvLxlAfm9i0tza2j8gOz3N
0DkaQJokqRM9JsQ/xKXCyl4eG0AYSDI12iK7v48or4GJ2xtAu9GGz9aB178a
XkwkBnAcQJrjgpoO8uO/JiNnCNHaHECwiNbvi9/rvxenZW0vGx1AKyVHyri5
8b/RNtzCsDAdQLELXOnpSPW/rVgcaA==
     "]]}, {}, {LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAMFq3HteyP0Cq6BKfhR85wI1G582n
uD9AwPTb8s7ROcBX0SSwD8o/QEzo+aAgmDrAi9NBVfDmP0B9HUtibHI7wPRb
t56LB0BAtIY4QFphPMBt7cQYHyFAQFPCBwl5ZT3Aqq703gVAQEAUh1YLOX8+
wJBYZOcJZEBAeFLpoeauP8CvKKQ27IxAQMyc601SekDAUJLaTWW6QEBLotxP
MyhBwHYpy6cl7EBAKPge1/XgQcD5I+ZD1iFBQOxvHXZcpELAiEJtPhlbQUBi
1mJvCnJDwAoSpHSKl0FArDN8ooFJRMDtZewzwNZBQC7ZWt0gKkXAANKc8ksY
QkCvePmmIhNGwDfoTRG7W0JAoQBhlpwDR8CFMUyjl6BCQHXRyUZ/+kfAAVvQ
PGnmQkAXe4n2lvZIwJj3lMW1LENA6qzY2oz2ScAvlFlOAnNDQGBGWi7p+ErA
q73d59O4Q0BMHMr7FfxLwPkG3Hmw/UNAsil6oWL+TMAwHY2YH0FEQHvRawUI
/k3AQ4k9V6uCREBQ2wVtLflOwCbdhRbhwURAzvXL5u3tT8CorLxMUv5EQCKx
GhgvbVDAN8tDR5U3RUCtkfd+Sd5QwLrFXuNFbUVA4SrMxFNJUcDgXE89Bp9F
QA5duyJirVHAgcaFVH/MRUCoPGnKkglSwKCWxaNh9UVA1vVUMxFdUsCGQDWs
ZRlGQF70JEgZp1LAwwFlckw4RkBqCghj+uZSwDyTcuzfUUZAdOsXCRocU8Bq
BYlg82VGQDKY21X2RVPAhIYXs2N0RkCk9ZsJKGRTwOpLNqQXfUZAJr0nL2R2
U8AYQs77/39GQOva2U99fFPAgagpIA==
     "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAMFq3HteyP0DF3B4L7h05wI1G582n
uD9AGIm9UxV+OMBX0SSwD8o/QEJwN3EJ7zfAi9NBVfDmP0CzqL4VtHA3wPRb
t56LB0BAHO0gtC4CN8Bt7cQYHyFAQBFVU8qPojbAqq703gVAQED8zOYd7VA2
wJBYZOcJZEBAaGMHgF0MNsCvKKQ27IxAQCXcATP60zXAUJLaTWW6QEAq0cj+
36Y1wHYpy6cl7EBA3swEATCENcD5I+ZD1iFBQJXd2UQQazXAiEJtPhlbQUBs
euctrFo1wAoSpHSKl0FA/ZMVwTRSNcDtZewzwNZBQD2kl9TgUDXAANKc8ksY
QkASDkQv7VU1wDfoTRG7W0JA6XUInpxgNcCFMUyjl6BCQAJq9AQ4cDXAAVvQ
PGnmQkA53RdwDoQ1wJj3lMW1LENAh6NTJ3WbNcAvlFlOAnNDQPSbPMfHtTXA
q73d59O4Q0CIxFhgaNI1wPkG3Hmw/UNAfARInb/wNcAwHY2YH0FEQIZE1+88
EDbAQ4k9V6uCREDAm4jEVjA2wCbdhRbhwURAiHrDu4pQNsCorLxMUv5EQGso
oOddcDbAN8tDR5U3RUBTBhcNXY82wLrFXuNFbUVAFG5C5xytNsDgXE89Bp9F
QEqyVms6yTbAgcaFVH/MRUA4APQLW+M2wKCWxaNh9UVArHF/+iz7NsCGQDWs
ZRlGQAeMQWVnEDfAwwFlckw4RkAIKR+xyiI3wDyTcuzfUUZAfwrdrSAyN8Bq
BYlg82VGQAgd/cM8PjfAhIYXs2N0RkDb2WUb/EY3wOpLNqQXfUZAf6QnukVM
N8AYQs77/39GQDTn2JoKTjfA/7gctw==
     "]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.8436996639529943`*^9, 
  3.8751559186875*^9},ExpressionUUID->"bad380df-5f1f-4f82-8d37-427ebc24ec48"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"fce", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{"podminka", "\[Equal]", "0"}]}], "}"}], "]"}], "//", "N"}]}], 
  ";"}]}], "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "res"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Element]", "Reals"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7.288691475657751`", ",", 
     RowBox[{"-", "1.4684090963636374`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.023120364927266`", ",", 
     RowBox[{"-", "23.092495749238093`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8436996641222625`*^9, 
  3.875155919203125*^9},ExpressionUUID->"81efd811-368e-429d-b6d2-\
c34855317e43"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{"podminka", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "20"}], ",", "45"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", ".03", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DisplayTogether", "::", "\<\"obslt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The DisplayTogether and \
DisplayTogetherArray functions are obsolete in Version 6. GraphicsArray and \
Show may be used directly in the same role.\\\\\\\"\\\", \
\\\"MT\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.87515591925*^9},ExpressionUUID->"8e7323b5-5f9b-4c0e-9251-8be77e50fa6c"],

Cell[BoxData[
 GraphicsBox[{{{LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAcUUY9f//M8Dgh562O086wHKQf9UQ
9DPA/5Rm6zozOsDL8lJVWNAzwDCp9QvC3znAyBjs6xSVM8B0EtF5alY5wJkk
JDyuQjPAGo6MHtSZOMD+IhhftNkywICJeyqWrTfAXJcr6N5aMsByn4xgKpY2
wHDJAaQLxzHATbKXlNNYNcDcOJ8UPR8xwLhVcS6A+zPAxH5ZrZhkMMBo+7uw
qYQywKVPWKPJMC/AYAUHcDL7MMBh2ec0DXgtwAE8sq6FzC7A5dHsyv6hK8BV
3FeZT5orwFiz9GbUsSnA3ithAWhuKMBGvxWz8aonwG+pdkRMVyXARk+dFOKQ
JcAQMtGnK2MiwA5XQ3lSZyPAvBH9rqA/H8Dp/bnpCjIhwAzhLSwiNRrApoKt
2c/pHcDt8wJPXsAVwPbsyo2nZxnA6MJWiqj4EcBGV+hBf+UUwN4m+dOU4A3A
Gt4hSDlrEMCXYPJ58V0JwKFXHlJUAQjAagO/bdNWBsB87WzJK7b+v/O8pht8
kwTA+NpSq13L67/jZLc/zsQDwGCYcUo2i8I/Wx6MspqZA8B4Jw/pudLxP6kP
WLXrzAPArLFznJZBAEDF3EM21SkEwLyKNVaIJAdAYCTKm2eJBMBEQqAzJ4YN
QJXsMiYzzwTAhAnnNqWtEUDV57e1SuYEwNJLcXTfTBRAhiQ0FC2/BMCCgxiF
LJwWQNXNAdFzTgTADrLKYIKXGECQ9N20D4wDwHi4+tRpOxpAMKn5R+RyAsAy
iRqUBIUbQPU+jCahAAHAQPG1ORJyHEAdWjOvg2v+v9pnaDr0AB1A3gCfZ0Yr
+r/YO8u4sDAdQEltvykoUvW/GmYxow==
      "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAcUUY9f//M8Dg87cx7zwZQHKQf9UQ
9DPA7O1lhUgsGUDL8lJVWNAzwOuFWVJ/+hhAyBjs6xSVM8DZpDA6FKgYQJkk
JDyuQjPApj40O941GED+IhhftNkywFJol7sLpRdAXJcr6N5aMsDiZ+dHJPcW
QHDJAaQLxzHAWMdrWAsuFkDcOJ8UPR8xwPW/oJsETBVAxH5ZrZhkMMDL6TOA
ulMUQKVPWKPJMC/AQl6JD0hIE0Bh2ec0DXgtwLG3c6VHLRJA5dHsyv6hK8DP
cvK76AYRQFiz9GbUsSnAd+Ctqx+0D0BGvxWz8aonwHR0dakIWQ1ARk+dFOKQ
JcDWJGeSXwoLQA5XQ3lSZyPAaAmQa9zYCEDp/bnpCjIhwHucHGq+2AZApoKt
2c/pHcA6ILeI+CEFQPbsyo2nZxnAN2AxCLPOA0BGV+hBf+UUwPSB/Njw9QJA
Gt4hSDlrEMBuWEM6pKACQKFXHlJUAQjAwdiuuNO8AkB87WzJK7b+v9GRQCY0
GgNA+NpSq13L67/vpYiEjXcDQGCYcUo2i8I/oCpogHSXA0B4Jw/pudLxPyfo
JdnaTQNArLFznJZBAEB8CHOaAoMCQLyKNVaIJAdADsj/EXgwAUBEQqAzJ4YN
QMxNXlAPuf4/hAnnNqWtEUDepI8eTCz6P9JLcXTfTBRAooa2xnPj9D+CgxiF
LJwWQOSQnIy3Gu4/DrLKYIKXGEBVIM8ab7bhP3i4+tRpOxpA4jLdnI3uwz8y
iRqUBIUbQMSn3GNc5M6/QPG1ORJyHECG/qW3QBPkv9pnaDr0AB1AQHyfZ5XI
77/YO8u4sDAdQAd+Ht5OSPW/TGglGg==
      "]]}, {}, {LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAA7pg7IdeyP0CA+gI0oh85wPxRadCn
uD9A4buLG8/ROcCzRqCyD8o/QMg2SLcgmDrAkluyV/DmP0B7OG1ybHI7wDwH
6J+LB0BA1iE2TVphPMAv6+sZHyFAQKIpEhR5ZT3ACfsP4AVAQEAw1wEVOX8+
wCMEcugJZEBAwfyFquauP8DfW6I37IxAQIPPyVFSekDAlpDHTmW6QED9V1hT
MyhBwGJUpagl7EBAAhBA2vXgQcAG/qtE1iFBQN0X6HhcpELAuHEdPxlbQUCS
ydhxCnJDwERiPXWKl0FAAoadpIFJRMAWy200wNZBQBWCJt8gKkXA0GkF80sY
QkBNt22oIhNGwMf7nBG7W0JAeqh7l5wDR8CMNoGjl6BCQKeHiEd/+kfAxvTq
PGnmQkBF6en2lvZIwJj3lMW1LENA6qzY2oz2ScBq+j5OAnNDQBAI+C3p+ErA
pLio59O4Q0C1RgT7FfxLwGnzjHmw/UNAHPhPoGL+TMBghSSYH0FEQD4s3QMI
/k3AGiS8VquCRECdbBNrLflOwOyM7BXhwURAjzp35O3tT8B4fQxMUv5EQDZb
wBYvbVDAKvF9RpU3RUAC5W59Sd5QwM6ahOJFbUVAbT4Xw1NJUcCaXmI8Bp9F
QKa83CBirVHAUZOHU3/MRUBJ5mPIkglSwA3rt6Jh9UVArVQsMRFdUsAn9Bmr
ZRlGQLTZ3EUZp1LAAQQ+cUw4RkB9pKRg+uZSwPTnQevfUUZAmrqdBhocU8Bn
wVBf82VGQEJiT1P2RVPA1svZsWN0RkD1twIHKGRTwDJG9aIXfUZAmZ2GLGR2
U8C5Ioz6/39GQP0XNk19fFPAVSUmUA==
      "]], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAA7pg7IdeyP0CL9Sh+0R05wPxRadCn
uD9AU2gCMxV+OMCzRqCyD8o/QL41zWIJ7zfAkluyV/DmP0Cm8GQNtHA3wDwH
6J+LB0BAUsvEri4CN8Av6+sZHyFAQJ4juMaPojbACfsP4AVAQEDk72wb7VA2
wCMEcugJZEBAycNSfl0MNsDfW6I37IxAQPJQ2DH60zXAlpDHTmW6QEBXLQP+
36Y1wGJUpagl7EBA8WKHADCENcAG/qtE1iFBQO5nkEQQazXAuHEdPxlbQUDL
tcItrFo1wERiPXWKl0FAjcQJwTRSNcAWy200wNZBQJ6gm9TgUDXA0GkF80sY
QkAxm1Av7VU1wMf7nBG7W0JAXNUXnpxgNcCMNoGjl6BCQD8JAgU4cDXAxvTq
PGnmQkDXGiBwDoQ1wJj3lMW1LENAh6NTJ3WbNcBq+j5OAnNDQJ0mMsfHtTXA
pLio59O4Q0DmLEJgaNI1wGnzjHmw/UNAPBQknb/wNcBghSSYH0FEQOwrpe88
EDbAGiS8VquCRECp5EfEVjA2wOyM7BXhwURAgv1zu4pQNsB4fQxMUv5EQKID
QuddcDbAKvF9RpU3RUCslaoMXY82wM6ahOJFbUVAOETI5hytNsCaXmI8Bp9F
QIiSz2o6yTbAUZOHU3/MRUDX2GALW+M2wA3rt6Jh9UVArFbh+Sz7NsAn9Bmr
ZRlGQD+ymWRnEDfAAQQ+cUw4RkBq4W6wyiI3wPTnQevfUUZAjL0lrSAyN8Bn
wVBf82VGQGlGQMM8PjfA1svZsWN0RkATBKUa/EY3wDJG9aIXfUZAm2RkuUVM
N8C5Ioz6/39GQJTYFJoKTjfAg9oivA==
      "]]}}, 
   {Hue[0], PointSize[0.03], 
    PointBox[{{7.288691475657751, -1.4684090963636374`}, {
     32.023120364927266`, -23.092495749238093`}}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.8436996643384323`*^9, 
  3.8751559194375*^9},ExpressionUUID->"993617da-9b25-4ee5-b6bb-0f5a7196a829"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"x", "-", 
    RowBox[{"2", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"], "-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"expr", "+", 
    RowBox[{"\[Lambda]", "*", "g"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"0", "\[Equal]", 
     RowBox[{"D", "[", 
      RowBox[{"lagrange", ",", "#"}], "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], 
    "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"expr", "/.", "%"}]}], "Input",
 CellChangeTimes->{{3.875174104422234*^9, 3.875174208893548*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"7ada0e89-d4f8-4e65-a924-8ddf11b99556"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.8751742096122427`*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"d34c8c1c-ee81-4cee-bc63-f3c3de903389"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.875174209627857*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"5dbb780a-1023-400d-9510-fd0830209e94"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{{3.8751741435445547`*^9, 3.875174209627857*^9}},
 CellLabel->"Out[40]=",ExpressionUUID->"2691dda0-71c8-4de6-85df-d0a2b3f46411"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.875174871685972*^9, 3.8751748872284126`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"48168a0d-de88-464e-a0ff-78a2b91bcfd4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2ndcT98bAPD20u7T3tqTSEVxDimjkNIkEhoiVEhCKSqSlopIpKGSJFLo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       "]]},
     Annotation[#, "Charting`Private`Tag$23525#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-15, 15}, {-0.9999999999998128, 0.9999999999998128}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8751748804319963`*^9, 3.8751748877127647`*^9}},
 CellLabel->"Out[49]=",ExpressionUUID->"09918a3d-4155-4f55-a9b5-e39f9990b29e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "12.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", 
       FractionBox[
        RowBox[{"80", "+", "210"}], "2"]}], ")"}], "2"], 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{"k", "*", 
          RowBox[{"(", 
           RowBox[{"x", "-", "80"}], ")"}]}], "]"}], "-", 
        RowBox[{"Tanh", "[", 
         RowBox[{"k", "*", 
          RowBox[{"(", 
           RowBox[{"x", "-", "210"}], ")"}]}], "]"}]}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "300"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"toBeMinimized", "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"0.001", 
      RowBox[{"(", 
       RowBox[{"x", "+", "150"}], ")"}]}], "]"}], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"x", "+", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"toBeMinimized", ",", 
     RowBox[{"80", "<", "x", "<", "210"}]}], "}"}], ",", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"toBeMinimized", "+", 
    RowBox[{"100", "expr"}]}], ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.875174789510248*^9, 3.8751748697017317`*^9}, {
  3.8751749077113914`*^9, 3.875174946210497*^9}, {3.8751750131996584`*^9, 
  3.875175035166912*^9}, {3.875175119004947*^9, 3.8751752833630757`*^9}, {
  3.875175317407648*^9, 3.8751753189856663`*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"4ee3ed9f-5601-4e21-89bc-05ea2d9bdb6f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1Qsw1GsfB3A5ObwilVKHIqTEKekqa3e/JbSlXHZdShHFyR/FnzhC6YLc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       "]]},
     Annotation[#, "Charting`Private`Tag$30441#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 300}, {0., 48049.996204081726`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.875174818860971*^9, 3.875174834797863*^9}, {
   3.875174924413365*^9, 3.8751749464604816`*^9}, 3.87517503585435*^9, 
   3.8751751198642673`*^9, 3.8751751791608105`*^9, {3.875175211409895*^9, 
   3.875175233407039*^9}, {3.8751752638102026`*^9, 3.875175283644326*^9}, 
   3.8751753196262555`*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"e40d16eb-d74c-43a4-a092-f8b9c9dc4247"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"79.24032320254753`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "80.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.875174818860971*^9, 3.875174834797863*^9}, {
   3.875174924413365*^9, 3.8751749464604816`*^9}, 3.87517503585435*^9, 
   3.8751751198642673`*^9, 3.8751751791608105`*^9, {3.875175211409895*^9, 
   3.875175233407039*^9}, {3.8751752638102026`*^9, 3.875175283644326*^9}, 
   3.8751753197043514`*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"ddb9bc84-1bbe-4174-a552-f9ca7875ce6b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"79.95468243775653`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "80.67382200483137`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.875174818860971*^9, 3.875174834797863*^9}, {
   3.875174924413365*^9, 3.8751749464604816`*^9}, 3.87517503585435*^9, 
   3.8751751198642673`*^9, 3.8751751791608105`*^9, {3.875175211409895*^9, 
   3.875175233407039*^9}, {3.8751752638102026`*^9, 3.875175283644326*^9}, 
   3.8751753197668457`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"d2dab2cf-0986-4eec-99f1-a080b3a64b62"]
}, Open  ]]
},
WindowSize->{1242, 913},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification:>2.05 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearProgramming"->{
  Cell[4128, 134, 709, 19, 99, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
   CellTags->"LinearProgramming"],
  Cell[4840, 155, 456, 11, 67, "Output",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646",
   CellTags->"LinearProgramming"],
  Cell[5333, 171, 525, 18, 182, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
   CellTags->"LinearProgramming"],
  Cell[5861, 191, 273, 6, 67, "Output",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5",
   CellTags->"LinearProgramming"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearProgramming", 46487, 1097}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1763, 52, 539, "Input",ExpressionUUID->"a737ad8f-a8e9-4df2-a68e-5ae9197a0999"],
Cell[2346, 76, 393, 9, 72, "Output",ExpressionUUID->"63805479-52ef-464b-8261-c978c2a9ffe5"]
}, Open  ]],
Cell[2754, 88, 215, 4, 58, "Input",ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],
Cell[2972, 94, 215, 5, 58, "Input",ExpressionUUID->"d5574ba4-00f1-47f3-893d-fa79927fb4ff"],
Cell[CellGroupData[{
Cell[3212, 103, 563, 16, 99, "Input",ExpressionUUID->"87beaab4-22e4-425b-b802-1c3e89f623e8"],
Cell[3778, 121, 313, 8, 67, "Output",ExpressionUUID->"26165986-4fb4-469b-91b2-a9dcb03ebaba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4128, 134, 709, 19, 99, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
 CellTags->"LinearProgramming"],
Cell[4840, 155, 456, 11, 67, "Output",ExpressionUUID->"b8b2cad9-6dbd-490b-9f17-273d33b29646",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5333, 171, 525, 18, 182, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
 CellTags->"LinearProgramming"],
Cell[5861, 191, 273, 6, 67, "Output",ExpressionUUID->"c6b470f8-610e-4f59-b880-82c8cda57ce5",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6171, 202, 700, 21, 139, "Input",ExpressionUUID->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],
Cell[6874, 225, 4745, 105, 921, "Output",ExpressionUUID->"bad380df-5f1f-4f82-8d37-427ebc24ec48"]
}, Open  ]],
Cell[11634, 333, 646, 18, 179, "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],
Cell[CellGroupData[{
Cell[12305, 355, 368, 11, 58, "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],
Cell[12676, 368, 410, 11, 67, "Output",ExpressionUUID->"81efd811-368e-429d-b6d2-c34855317e43"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13123, 384, 581, 16, 179, "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],
Cell[13707, 402, 426, 8, 126, "Message",ExpressionUUID->"8e7323b5-5f9b-4c0e-9251-8be77e50fa6c"],
Cell[14136, 412, 4893, 108, 921, "Output",ExpressionUUID->"993617da-9b25-4ee5-b6bb-0f5a7196a829"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19066, 525, 928, 26, 259, "Input",ExpressionUUID->"7ada0e89-d4f8-4e65-a924-8ddf11b99556"],
Cell[19997, 553, 594, 16, 98, "Output",ExpressionUUID->"d34c8c1c-ee81-4cee-bc63-f3c3de903389"],
Cell[20594, 571, 663, 19, 115, "Output",ExpressionUUID->"5dbb780a-1023-400d-9510-fd0830209e94"],
Cell[21260, 592, 239, 5, 93, "Output",ExpressionUUID->"2691dda0-71c8-4de6-85df-d0a2b3f46411"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21536, 602, 341, 8, 58, "Input",ExpressionUUID->"48168a0d-de88-464e-a0ff-78a2b91bcfd4"],
Cell[21880, 612, 15999, 279, 517, "Output",ExpressionUUID->"09918a3d-4155-4f55-a9b5-e39f9990b29e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37916, 896, 1797, 53, 335, "Input",ExpressionUUID->"4ee3ed9f-5601-4e21-89bc-05ea2d9bdb6f"],
Cell[39716, 951, 5209, 104, 496, "Output",ExpressionUUID->"e40d16eb-d74c-43a4-a092-f8b9c9dc4247"],
Cell[44928, 1057, 548, 11, 93, "Output",ExpressionUUID->"ddb9bc84-1bbe-4174-a552-f9ca7875ce6b"],
Cell[45479, 1070, 562, 11, 126, "Output",ExpressionUUID->"d2dab2cf-0986-4eec-99f1-a080b3a64b62"]
}, Open  ]]
}
]
*)

