(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14303,        356]
NotebookOptionsPosition[     13031,        328]
NotebookOutlinePosition[     13512,        346]
CellTagsIndexPosition[     13469,        343]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", "pom"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{
  3.640412956954171*^9},ExpressionUUID->"dd49583c-1294-400f-a877-\
40bb7baa6120"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<data.xls\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.63974994203125*^9, 3.639750066390625*^9}, 
   3.63975082021875*^9, {3.639751736421875*^9, 3.639751933046875*^9}, {
   3.639752055140625*^9, 3.63975205540625*^9}, {3.640412960813546*^9, 
   3.640412980282296*^9}, {3.640413089313546*^9, 
   3.640413093079171*^9}},ExpressionUUID->"33dcbdaa-edf0-4bc9-b197-\
714ef015dfc2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"imp", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "*", "R"}], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]], "+", "R"}]]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "R_", ",", "X_"}], "}"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"R", "-", 
       RowBox[{"Re", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"X", "-", 
       RowBox[{"Im", "[", 
        RowBox[{"imp", "[", "f", "]"}], "]"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"forFindMin", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"err", "/@", "dat"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"{", "forFindMin", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"R", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.640413204469796*^9, 3.640413306110421*^9}, {
  3.640413365407296*^9, 3.640413508016671*^9}, {3.640413539141671*^9, 
  3.640413579876046*^9}, {3.640413866485421*^9, 
  3.640413889313546*^9}},ExpressionUUID->"a44c393a-2729-4f40-8793-\
f79134e5f283"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum","sszero",
   "\"The step size in the search has become less than the tolerance \
prescribed by the PrecisionGoal option, but the gradient is larger than the \
tolerance specified by the AccuracyGoal option. There is a possibility that \
the method has stalled at a point that is not a local minimum.\"",2,9,1,
   28799100740733594556,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8443065116961966`*^9},ExpressionUUID->"a92cc6a5-81e5-48ce-ade5-\
6d67af16e9d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"R", "\[Rule]", "43.581725466095385`"}], ",", 
   RowBox[{"c", "\[Rule]", "2.866341924601739`*^-6"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8443065117430286`*^9},ExpressionUUID->"be3db43d-064f-4e81-8dec-\
f00e76390728"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{
    RowBox[{"imp", "[", "f", "]"}], "/.", "min"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.640413583579171*^9, 3.640413610126046*^9}, 
   3.640413899438546*^9},ExpressionUUID->"c5504793-29af-43be-9ed5-\
c4885adf9514"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fmin", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmax", "=", 
   RowBox[{"dat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "vys", "]"}], ",", 
       RowBox[{"Im", "[", "vys", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "fmin", ",", "fmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dat", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}]}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<ReZ[\[CapitalOmega]]\>\"", ",", "\"\<ImZ[\[CapitalOmega]]\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.009", "]"}], ",", "Red"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pict.png\>\"", ",", "%", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.640413615172921*^9, 3.640413681001046*^9}, {
  3.640413754829171*^9, 3.640413758188546*^9}, {3.640413799172921*^9, 
  3.640413812782296*^9}, {3.640414121501046*^9, 
  3.640414141922921*^9}},ExpressionUUID->"5ea0bcfe-0897-4b5e-b0c5-\
8fa44af27aae"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.009], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAA6Ugu/yFtRkAMyF7v/njrv6Tfvg6c
a0ZAa4Ko+wCk67+dgCbChvdFQCHlJ9U+HfO/KjqSy3+wRkCHbYsyG+T6v1In
oImwOUVADk+vlGUI/r/7XG3F/mJFQAeZZOQsrALAa5p3nKJbRkAa+ie4WFEK
wF5LyAc960RAukkMAivHDcBiEFg5tBhFQMFu2LYoMxLAVp+rrdivRUB56SYx
CEwXwC/dJAaBdURAtcNfkzUKHcCSy39Iv41EQEBqEyf3ayLAb4EExY/RRECG
yVTBqIQmwMdLN4lBoENAaJHtfD/VK8Bcj8L1KLxBQPaX3ZOHZS7A+FPjpZvU
QEBXW7G/7D4xwDnWxW00QD5AT6+UZYizNMC6awn5oFc5QPcGX5hMtTTA3GgA
b4EkNkAy5q4l5GM1wJEPejarPjJAZF3cRgO4NcDrc7UV+4sqQOOlm8QgwDPA
RIts5/tpJEALtaZ5x2kywOhqK/aXLSBAtTf4wmQ6McC7Jw8LtaYVQLU3+MJk
ai3AWW5pNSRuD0CDL0ymCuYowNLj9zb9WQdAUWuad5wiJsDnNXaJ6i36P81Y
NJ2dPCLA7uvAOSNK8T9eS8gHPdsdwNI6qpog6uQ/FHmSdM2EGcBu3c1THXLR
P8Tr+gW7oRTADOVEuwopvz8Cmggbnh4OwHDOiNLe4LM/RpT2Bl8YB8BQGf8+
48KxP62jqgmiLgLAJhk5C3vasT+r56T3jS/3v636XG3F/rI/fzDw3Hu47L9X
eJeL+E60P/cBSG3i5N6/ZQETuHU3tz92w7ZFmQ3CP+Z6Hic=
       "]]}, {}}, {}, {}, {}, {}}, {{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwVkHk41G0fxSdk37JlJzvZzaDEfWNISmUpS/Q8JSGVKEKlCJN9TbIMIqLJ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       "]]},
     Annotation[#, "Charting`Private`Tag$2354#1"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"ReZ[\[CapitalOmega]]\"", TraditionalForm], 
    FormBox["\"ImZ[\[CapitalOmega]]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 45.3789}, {-21.7188, 0.14104}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8443065120086236`*^9},ExpressionUUID->"e9fc390d-19ce-480d-92fe-\
aa11dd5e6896"],

Cell[BoxData["\<\"pict.png\"\>"], "Output",
 CellChangeTimes->{
  3.844306512727173*^9},ExpressionUUID->"94181f4c-5a14-43e4-84e9-\
da94ab0cf15b"]
}, Open  ]]
},
WindowSize->{1080, 617},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 482, 13, 160, "Input",ExpressionUUID->"dd49583c-1294-400f-a877-40bb7baa6120"],
Cell[1030, 35, 515, 11, 43, "Input",ExpressionUUID->"33dcbdaa-edf0-4bc9-b197-714ef015dfc2"],
Cell[CellGroupData[{
Cell[1570, 50, 1639, 50, 219, "Input",ExpressionUUID->"a44c393a-2729-4f40-8793-f79134e5f283"],
Cell[3212, 102, 533, 11, 94, "Message",ExpressionUUID->"a92cc6a5-81e5-48ce-ade5-6d67af16e9d1"],
Cell[3748, 115, 276, 7, 54, "Output",ExpressionUUID->"be3db43d-064f-4e81-8dec-f00e76390728"]
}, Open  ]],
Cell[4039, 125, 277, 7, 43, "Input",ExpressionUUID->"c5504793-29af-43be-9ed5-c4885adf9514"],
Cell[CellGroupData[{
Cell[4341, 136, 1903, 55, 247, "Input",ExpressionUUID->"5ea0bcfe-0897-4b5e-b0c5-8fa44af27aae"],
Cell[6247, 193, 6620, 127, 338, "Output",ExpressionUUID->"e9fc390d-19ce-480d-92fe-aa11dd5e6896"],
Cell[12870, 322, 145, 3, 49, "Output",ExpressionUUID->"94181f4c-5a14-43e4-84e9-da94ab0cf15b"]
}, Open  ]]
}
]
*)

