(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13936,        455]
NotebookOptionsPosition[     13005,        420]
NotebookOutlinePosition[     13469,        438]
CellTagsIndexPosition[     13426,        435]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.844310745671875*^9, 3.844310746265625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.", ",", 
       RowBox[{"2", "Pi"}], ",", 
       FractionBox["Pi", "5"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"int", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.844310763796875*^9, 3.844310837640625*^9}, {
  3.844310890125*^9, 3.844310920953125*^9}, {3.84431096853125*^9, 
  3.8443110161875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"int", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xmin", ",", "xmax"}], "}"}], "=", 
   RowBox[{"int", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"int", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", 
      RowBox[{"2", "xmax"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.84431103209375*^9, 3.84431103546875*^9}, {
  3.844311116*^9, 3.844311209625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data2D", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", 
         RowBox[{"2", "y"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.", ",", 
       RowBox[{"2", "Pi"}], ",", 
       FractionBox["Pi", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0.", ",", 
       RowBox[{"2", "Pi"}], ",", 
       FractionBox["Pi", "5"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2DProInterpolaci", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"data2D", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"int2D", "=", 
  RowBox[{
  "Interpolation", "[", "data2DProInterpolaci", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ymin", ",", "ymax"}], "}"}]}], "}"}], "=", 
  RowBox[{"int2D", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"int2D", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.844311223453125*^9, 3.8443112610625*^9}, {
   3.844311323140625*^9, 3.844311491328125*^9}, 3.844311890734375*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}]}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{
  3.844311261734375*^9, {3.844311359765625*^9, 3.844311419140625*^9}, {
   3.844311467265625*^9, 3.844311491921875*^9}, 3.84431189125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.844311261734375*^9, {3.844311359765625*^9, 3.844311419140625*^9}, {
   3.844311467265625*^9, 3.844311491921875*^9}, 3.84431189125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fOskliva", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", "x"}], "]"}], "2"]}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"fOskliva", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"reseni", " ", "pomoci", " ", "FindRoot"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"resX", "[", "y_", "]"}], ":=", 
    RowBox[{"x", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"fOskliva", "[", "x", "]"}], "\[Equal]", "y"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vys", "=", 
     RowBox[{"Timing", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"resX", "[", "y", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
        RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<trvalo to \>\"", ",", 
      RowBox[{"vys", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Timing", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"resX", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "3"}]]}], "}"}]}], "]"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.84431200125*^9, 3.844312076234375*^9}}],

Cell[BoxData["3.282`"], "Output",
 CellChangeTimes->{{3.84431202765625*^9, 3.84431207978125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "reseni", " ", "pomoci", " ", "vyreseni", " ", "v", " ", "nekolika", " ", 
    "bodech", " ", "a", " ", "dale", " ", "interpolace"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"body", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"resX", "[", "y", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nahr", "=", 
     RowBox[{"Interpolation", "[", "body", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"nahr", "[", "y", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", 
         SuperscriptBox["10", 
          RowBox[{"-", "3"}]]}], "}"}]}], "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"nahr", "[", "y", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
       RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", " ", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], "]"}], ";"}],
     "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.844312174984375*^9, 3.844312194359375*^9}}],

Cell[BoxData["0.015000000000000277`"], "Output",
 CellChangeTimes->{3.84431219515625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"1", "+", 
        RowBox[{"0.1", "#"}], "+", 
        RowBox[{"0.05", 
         SuperscriptBox["#", "2"]}], "+", 
        RowBox[{"0.2", "*", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}]}], "}"}], "&"}], 
    "/@", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "5", ",", "0.5"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"errBod", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"y", "-", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         SuperscriptBox["x", "2"]}]}], ")"}]}], ")"}], "2"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"celkErr", "=", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"errBod", "/@", "data"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"0", "\[Equal]", 
     RowBox[{"D", "[", 
      RowBox[{"celkErr", ",", "#"}], "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nahrada", "=", 
   RowBox[{
    RowBox[{"a", "+", 
     RowBox[{"b", "*", "x"}], "+", 
     RowBox[{"c", "*", 
      SuperscriptBox["x", "2"]}]}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", "%", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", 
    RowBox[{"Plot", "[", 
     RowBox[{"nahrada", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"nahrada", ",", 
   RowBox[{"Fit", "[", 
    RowBox[{"data", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x", ",", 
       SuperscriptBox["x", "2"]}], "}"}], ",", "x"}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{
  3.844312311875*^9, {3.84431239546875*^9, 3.844312586671875*^9}, {
   3.84431276809375*^9, 3.844312824734375*^9}, {3.844312868640625*^9, 
   3.844312982640625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.9925909584397569`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.10732493910967691`", " ", "x"}], "+", 
    RowBox[{"0.049979186016153976`", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{"0.9925909584397572`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.10732493910967693`", " ", "x"}], "+", 
    RowBox[{"0.04997918601615397`", " ", 
     SuperscriptBox["x", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.844312994296875*^9}]
}, Open  ]]
},
WindowSize->{1182, 641},
WindowMargins->{{27, Automatic}, {Automatic, 27}},
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->2.200000047683716,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 396, 10, 138, "Input"],
Cell[956, 32, 932, 29, 174, "Input"],
Cell[1891, 63, 743, 23, 138, "Input"],
Cell[CellGroupData[{
Cell[2659, 90, 1638, 50, 249, "Input"],
Cell[4300, 142, 510, 15, 91, "Output"],
Cell[4813, 159, 368, 9, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5218, 173, 2325, 70, 460, "Input"],
Cell[7546, 245, 97, 1, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7680, 251, 1844, 52, 403, "Input"],
Cell[9527, 305, 89, 1, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9653, 311, 2841, 93, 496, "Input"],
Cell[12497, 406, 492, 11, 140, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
