(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14614,        414]
NotebookOptionsPosition[     13215,        383]
NotebookOutlinePosition[     13698,        401]
CellTagsIndexPosition[     13655,        398]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"8b06c617-c35d-4ee0-b196-d0225e58b247"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 
  3.689476074453125*^9}},ExpressionUUID->"71cf384a-dc53-4dab-8e65-\
828b927e5f1b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a = \"\>", "\[InvisibleSpace]", "5.208333333333334`*^-7", 
   "\[InvisibleSpace]", "\<\"  \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a = ", 5.208333333333334*^-7, 
   "  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8152796873824353`*^9, 3.8278959915943546`*^9, 
  3.828688866863964*^9, 3.8479383063283167`*^9, 
  3.878714590170436*^9},ExpressionUUID->"ffe1ccdb-7fbf-401d-962d-\
be16849175b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]x = \"\>", "\[InvisibleSpace]", 
   "0.02666666666666667`", "\[InvisibleSpace]", "\<\"  m\"\>"}],
  SequenceForm["\[CapitalDelta]x = ", 0.02666666666666667, "  m"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8152796873824353`*^9, 3.8278959915943546`*^9, 
  3.828688866863964*^9, 3.8479383063283167`*^9, 
  3.8787145901860867`*^9},ExpressionUUID->"aedb32dc-9e48-4a20-b59c-\
14d5a172e5ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]tmax = \"\>", "\[InvisibleSpace]", 
   "682.6666666666667`", "\[InvisibleSpace]", "\<\"  s\"\>"}],
  SequenceForm["\[CapitalDelta]tmax = ", 682.6666666666667, "  s"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8152796873824353`*^9, 3.8278959915943546`*^9, 
  3.828688866863964*^9, 3.8479383063283167`*^9, 
  3.878714590201677*^9},ExpressionUUID->"fb2577f8-75b6-4795-8ca4-\
88f548d449d4"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], "=", 
   RowBox[{"T1", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"T2", "-", "T1"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]1", "*", 
         RowBox[{"(", 
          RowBox[{"To1", "-", "T1"}], ")"}]}]}], ",", "T1"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], "=", 
   RowBox[{"Tn", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Tnminus"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]n", "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Ton"}], ")"}]}]}], ",", "Tn"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Tpom", "}"}], ",", 
     RowBox[{
      RowBox[{"Tpom", "=", 
       RowBox[{"ListConvolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Fo", ",", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}], 
        "]"}]}], ";", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fTn", "[", 
         RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ";", 
      RowBox[{"PrependTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"6", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotik", "[", 
    RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"nel", "=", 
        RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i"}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"lispom", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
           RowBox[{"list", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"lispom", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Ton", "-", "2"}], ",", 
             RowBox[{"To1", "+", "2"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"tpopis", "=", 
          RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<t=\>\"", "<>", 
           RowBox[{"ToString", "[", "tpopis", "]"}], "<>", "\"\< s\>\""}]}]}],
         ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 
   3.68947628559375*^9}},ExpressionUUID->"14a35896-778c-47bf-935b-\
fb458da16594"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 
   3.689476362265625*^9}},ExpressionUUID->"8f333374-b797-405f-9d4b-\
996ff7e56d40"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"plots", "[", 
    RowBox[{"[", "i", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"1302dfc3-6d38-4308-8007-ea86d2de122c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`i$$], 1, 37, 1}}, Typeset`size$$ = {
    522., {164., 172.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i$4049$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`i$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`i$$, $CellContext`i$4049$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Part[$CellContext`plots, $CellContext`i$$], 
      "Specifications" :> {{$CellContext`i$$, 1, 37, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{591., {225., 234.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.8152796882067413`*^9, 3.8278959942812176`*^9, 
  3.828688867581365*^9, 3.8479383071250052`*^9, 
  3.8787145935099716`*^9},ExpressionUUID->"f035d96c-c3d6-482c-968d-\
97ac1cf6a0a5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Ttry", "=", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       SubscriptBox["T", "i"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     RowBox[{"ClearAll", "[", "Fo", "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ListConvolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", 
     RowBox[{"ListCorrelate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", "%"}], "===", "%%"}]}], "*)"}]], "Input",
 CellChangeTimes->{
  3.689476233734375*^9},ExpressionUUID->"a7a5ee20-fe09-4c30-9999-\
ce9989dea529"]
},
WindowSize->{1003, 740},
WindowMargins->{{24, Automatic}, {Automatic, 40}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 387, 10, 98, "Input",ExpressionUUID->"8b06c617-c35d-4ee0-b196-d0225e58b247"],
Cell[CellGroupData[{
Cell[957, 34, 1960, 54, 532, "Input",ExpressionUUID->"71cf384a-dc53-4dab-8e65-828b927e5f1b"],
Cell[CellGroupData[{
Cell[2942, 92, 604, 13, 32, "Print",ExpressionUUID->"ffe1ccdb-7fbf-401d-962d-be16849175b4"],
Cell[3549, 107, 459, 9, 32, "Print",ExpressionUUID->"aedb32dc-9e48-4a20-b59c-14d5a172e5ed"],
Cell[4011, 118, 459, 9, 32, "Print",ExpressionUUID->"fb2577f8-75b6-4795-8ca4-88f548d449d4"]
}, Open  ]]
}, Open  ]],
Cell[4497, 131, 4992, 146, 771, "Input",ExpressionUUID->"14a35896-778c-47bf-935b-fb458da16594"],
Cell[9492, 279, 597, 18, 70, "Input",ExpressionUUID->"8f333374-b797-405f-9d4b-996ff7e56d40"],
Cell[CellGroupData[{
Cell[10114, 301, 311, 8, 41, "Input",ExpressionUUID->"1302dfc3-6d38-4308-8007-ea86d2de122c"],
Cell[10428, 311, 1741, 36, 485, "Output",ExpressionUUID->"f035d96c-c3d6-482c-968d-97ac1cf6a0a5"]
}, Open  ]],
Cell[12184, 350, 1027, 31, 154, "Input",ExpressionUUID->"a7a5ee20-fe09-4c30-9999-ce9989dea529"]
}
]
*)

