(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86974,       2004]
NotebookOptionsPosition[     84735,       1965]
NotebookOutlinePosition[     85217,       1983]
CellTagsIndexPosition[     85174,       1980]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.638255496078125*^9, 3.638255503171875*^9}, {
  3.753346012453125*^9, 
  3.753346012859375*^9}},ExpressionUUID->"215eb9ea-b69b-4be9-a9cd-\
0ec30aa71a3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", 
    RowBox[{"listDat_", ",", "sr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
       RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
       "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
       ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
       "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0."}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"aclist", "[", 
                RowBox[{"[", 
                 RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
               RowBox[{"aclist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
            ")"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", 
             RowBox[{"0", "+", 
              RowBox[{"1.", "*", 
               SuperscriptBox["nOkno", "2"]}]}]], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "y1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", "y2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       FractionBox[
        RowBox[{"y1", "+", 
         RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
         RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
         RowBox[{"2", " ", "x2", " ", "y3"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"y1", "-", 
           RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       RowBox[{"Total", "[", 
        SuperscriptBox[
         RowBox[{"Take", "[", 
          RowBox[{"listDat", ",", 
           RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["y1", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "y1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox[
          RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["10", "6"], 
         SuperscriptBox["sr", "2"], 
         FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}, {3.7239556183125*^9, 
   3.723955630328125*^9}, {3.753346122546875*^9, 3.753346124640625*^9}, {
   3.7533479519375*^9, 3.753347957625*^9}, {3.75349614084375*^9, 
   3.753496211984375*^9}},ExpressionUUID->"823b6015-adaf-4e73-9ca7-\
c2813b7ba6f6"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kperSampl", "=", "2.4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k\[Omega]", "=", "1.0456"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"2", "*", 
      RowBox[{"Round", "[", 
       FractionBox["48000", 
        RowBox[{"2", "*", "50"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"k\[Omega]", "*", "2.", "*", "Pi", "*", "fnom"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tnom", "=", 
     FractionBox["Tnom", "sr"]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"trialfce", "[", "t_", "]"}], ":=", 
     RowBox[{"1", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"\[Omega]", "*", "t"}], "+", "0.123"}], "]"}], "+", 
        RowBox[{"0.1", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"3", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], "]"}]}], 
        "+", 
        RowBox[{"0.05", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"7", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], "]"}]}], 
        "+", 
        RowBox[{"0.01", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"11", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.591248592265625*^9, 3.591248638765625*^9, {3.591248692484375*^9, 
   3.591248693125*^9}, {3.59124894825*^9, 3.591248998703125*^9}, {
   3.591249110484375*^9, 3.59124911196875*^9}, {3.591249147203125*^9, 
   3.591249147359375*^9}, 3.591249182125*^9, {3.591249215109375*^9, 
   3.591249239984375*^9}, 3.591249279671875*^9, {3.591250220390625*^9, 
   3.59125022371875*^9}, {3.591250276796875*^9, 3.59125032821875*^9}, {
   3.59125275034375*^9, 3.591252751078125*^9}, {3.59126424884375*^9, 
   3.591264249921875*^9}, {3.638254013921875*^9, 3.63825401484375*^9}, {
   3.638254666953125*^9, 3.638254695921875*^9}, {3.638254752515625*^9, 
   3.638254786796875*^9}, {3.638254821578125*^9, 3.63825495734375*^9}, {
   3.63825712134375*^9, 3.638257333140625*^9}, {3.638257389265625*^9, 
   3.6382577399375*^9}, {3.63825778628125*^9, 3.638257824234375*^9}, {
   3.638257915125*^9, 3.638258024171875*^9}, {3.638258059921875*^9, 
   3.6382580603125*^9}, {3.63825816075*^9, 3.63825827640625*^9}, {
   3.63825832834375*^9, 3.638258365515625*^9}, {3.6382585934375*^9, 
   3.638258595328125*^9}, 3.638258908015625*^9, 3.6382589783125*^9, {
   3.638259009859375*^9, 3.638259016359375*^9}, {3.63825905259375*^9, 
   3.6382590629375*^9}, {3.638259104640625*^9, 3.638259110703125*^9}, {
   3.63825916878125*^9, 3.638259177984375*^9}, {3.75334611496875*^9, 
   3.753346115625*^9}, {3.7533472788125*^9, 3.7533473130625*^9}, {
   3.753347348578125*^9, 3.75334736903125*^9}, {3.75335138578125*^9, 
   3.753351402640625*^9}, 3.753351481109375*^9, 3.753410711984375*^9, {
   3.753417918595194*^9, 3.7534179208759327`*^9}, {3.75342022144497*^9, 
   3.753420227677865*^9}, 3.753422680269084*^9, {3.7534227164949503`*^9, 
   3.7534227644993*^9}, 3.7534229938048162`*^9, {3.7534230933751726`*^9, 
   3.753423121681023*^9}, {3.7534232027244883`*^9, 3.753423208145096*^9}, {
   3.753496675609375*^9, 3.75349669621875*^9}, {3.753669086375*^9, 
   3.753669091015625*^9}, {3.753669188078125*^9, 3.75366919225*^9}, {
   3.75367075028125*^9, 3.753670771703125*^9}, 3.75368187884375*^9, {
   3.75375938753125*^9, 
   3.753759399546875*^9}},ExpressionUUID->"78a246c8-036e-4d7c-8217-\
da1a4fc24674"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejPruchody", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejPruchody", "[", 
    RowBox[{"{", 
     RowBox[{"listDat_", ",", "sr_", ",", "kNula_", ",", "nAV_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "datsSCasy", ",", "minU", ",", "maxU", ",", "ampl", ",", "kolemNuly", 
       ",", "gathered", ",", 
       RowBox[{"kGatger", "=", "0.02"}], ",", "prusecik", ",", "t", ",", 
       "perioda", ",", "f", ",", "selectMozne", ",", "vybrane"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datsSCasy", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{
         RowBox[{"Thread", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[CapitalDelta]tnom", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Range", "[", 
                RowBox[{"Length", "[", "listDat", "]"}], "]"}], "-", "1"}], 
              ")"}]}], ",", "listDat"}], "}"}], "]"}], ",", 
         RowBox[{"Round", "[", "nAV", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"minU", ",", "maxU"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "#", "]"}], ",", 
           RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", "datsSCasy"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ampl", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"minU", ",", "maxU"}], "}"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kolemNuly", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"datsSCasy", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", 
           RowBox[{"kNula", "*", "ampl"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gathered", "=", 
       RowBox[{"Gather", "[", 
        RowBox[{"kolemNuly", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"#1", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"#2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<", 
           RowBox[{"kGatger", "*", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"prusecik", "[", "data_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "fit", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"fit", "=", 
           RowBox[{"Fit", "[", 
            RowBox[{"data", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"t", "/.", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"fit", "\[Equal]", "0"}], ",", "t"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"selectMozne", "[", "periody_", "]"}], ":=", 
       RowBox[{"Select", "[", 
        RowBox[{"periody", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "-", "Tnom"}], "]"}], "<", 
           RowBox[{"0.2", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"selectMozne", ":=", 
         RowBox[{"#", "&"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"vybrane", "=", 
       RowBox[{"selectMozne", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"prusecik", "/@", "gathered"}], ",", "3", ",", "1"}], 
          "]"}], "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a_", ",", "_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"b", "-", "a"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"perioda", "=", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[GreaterEqual]", "1"}], 
         ",", 
         RowBox[{"Mean", "[", "vybrane", "]"}], ",", 
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[LessEqual]", "1"}], ",", 
         FractionBox["0.04", "k\[Omega]"]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox["1.", "perioda"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", "1.", ",", 
        FractionBox["perioda", "Tnom"]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753347907296875*^9, 3.7533479268125*^9}, {
   3.753347964890625*^9, 3.753348165671875*^9}, {3.75334820690625*^9, 
   3.75334827159375*^9}, 3.75334830603125*^9, {3.753348345578125*^9, 
   3.75334834590625*^9}, {3.753348403796875*^9, 3.753348405296875*^9}, {
   3.7533485530625*^9, 3.753348680421875*^9}, 3.753349193640625*^9, {
   3.753349249625*^9, 3.753349257703125*^9}, {3.75334936328125*^9, 
   3.753349499484375*^9}, {3.75334953078125*^9, 3.753349554421875*^9}, {
   3.7533496896875*^9, 3.7533497893125*^9}, {3.753349829921875*^9, 
   3.75334985675*^9}, {3.753349895078125*^9, 3.753349932140625*^9}, {
   3.753350013984375*^9, 3.753350085234375*^9}, {3.753350124390625*^9, 
   3.753350352671875*^9}, {3.753350643375*^9, 3.7533506814375*^9}, {
   3.753351209046875*^9, 3.753351288375*^9}, {3.7533513275625*^9, 
   3.753351380453125*^9}, 3.753351440390625*^9, 3.753351471515625*^9, 
   3.75341075709375*^9, 3.75341079340625*^9, {3.753411184578125*^9, 
   3.753411188578125*^9}, {3.753496474484375*^9, 3.753496616125*^9}, 
   3.753496660140625*^9, 3.753496998484375*^9, {3.753497047640625*^9, 
   3.75349705746875*^9}, 3.7534972045625*^9, {3.7535825184375*^9, 
   3.7535826315*^9}, {3.753759091046875*^9, 
   3.753759092859375*^9}},ExpressionUUID->"5ea509df-331d-4d99-bdb0-\
bfcf37877543"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "dejData", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejData", "[", 
    RowBox[{"{", 
     RowBox[{"fce_", ",", 
      RowBox[{"{", 
       RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
     "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"datsFce", ",", "sum", ",", "rnp", ",", "ampl", ",", "dats"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datsFce", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"(", 
         RowBox[{"rnp", "=", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", 
            RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
           "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ampl", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"0.5", "*", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ".", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Min", "[", "#", "]"}], ",", 
             RowBox[{"Max", "[", "#", "]"}]}], "}"}]}]}], "&"}], "@", 
        RowBox[{"(", "datsFce", ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sum", "[", "seedRandom_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"SeedRandom", "[", "seedRandom", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"k", "*", "ampl", "*", 
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0.0", ",", "\[Sigma]SumK"}], "]"}], "]"}]}], "&"}], "/@",
            "rnp"}]}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dats", "=", 
       RowBox[{"datsFce", "+", 
        RowBox[{"sum", "[", "SR", "]"}]}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pompom", "=", 
   RowBox[{"dejData", "[", 
    RowBox[{"{", 
     RowBox[{"trialfce", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [-]\>\"", ",", "\"\<signal\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.9", "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.75335151846875*^9, 3.75335153778125*^9}, {
   3.753351589234375*^9, 3.753351654671875*^9}, {3.75335173928125*^9, 
   3.753351879859375*^9}, {3.753351984734375*^9, 3.75335210346875*^9}, {
   3.753352140734375*^9, 3.75335224896875*^9}, 3.753409775671875*^9, {
   3.753409933765625*^9, 3.753410003765625*^9}, {3.75341003684375*^9, 
   3.75341011884375*^9}, {3.75341031828125*^9, 3.753410319546875*^9}, {
   3.753410460609375*^9, 3.753410462234375*^9}, {3.753410598078125*^9, 
   3.753410623609375*^9}, {3.753670809625*^9, 
   3.753670812203125*^9}},ExpressionUUID->"827f3a01-034d-43ac-a86e-\
7b268845f659"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejGrafy", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejGrafy", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "data", ",", "pl1", ",", "Nx5", ",", "pruchody", ",", "ukp1", ",", 
       "ukp2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"dejData", "[", "pars", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pl1", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"data", ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<i [-]\>\"", ",", "\"\<signal\>\""}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
            RowBox[{"Opacity", "[", "0.9", "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Nx5", "=", 
       RowBox[{"vydejNx5", "[", 
        RowBox[{"data", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pruchody", "=", 
       RowBox[{"vydejPruchody", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "sr", ",", "kNula", ",", "nAV"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ukp1", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"pl1", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"data", ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"PointSize", "[", "0.003", "]"}]}]}], "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<\[Delta]f= \>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"0.001", "*", 
             RowBox[{"Round", "[", 
              RowBox[{"1000", 
               RowBox[{"Nx5", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "<>", 
           "\"\< %\>\""}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ukp2", "=", 
       RowBox[{"Show", "[", 
        RowBox[{"pl1", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{"data", ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"PointSize", "[", "0.003", "]"}]}]}], "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<\[Delta]f= \>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"0.001", "*", 
             RowBox[{"Round", "[", 
              RowBox[{"1000", 
               RowBox[{"pruchody", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "<>", 
           "\"\< %\>\""}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"ukp1", ",", "ukp2"}], "}"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vydejGrafy", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"trialfce", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.2", ",", "0.6"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0.02"}], "}"}]}], "}"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.753410846515625*^9, 3.75341116921875*^9}, {
   3.753411205984375*^9, 3.75341130259375*^9}, {3.75341134671875*^9, 
   3.753411465234375*^9}, 3.753411502953125*^9, 3.753422947799989*^9, 
   3.753496883890625*^9, {3.7534981695625*^9, 3.753498195015625*^9}, {
   3.7536692203125*^9, 3.753669248984375*^9}, 
   3.753670821765625*^9},ExpressionUUID->"2bea3057-6332-4670-98b1-\
dfb7b9ce14d4"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "\[IndentingNewLine]",
     "fce", " ", "je", " ", "puvodni", " ", "signal", " ", "bez", " ", 
    "sumu"}], ",", " ", 
   RowBox[{
   "jako", " ", "funkce", " ", "casu", "\[IndentingNewLine]", "SR", " ", 
    "urcuje", " ", 
    RowBox[{"SeedRandom", "[", "SR", "]"}], " ", "pro", " ", "generovani", 
    " ", "Gaussovskeho", " ", "sumu", "\[IndentingNewLine]", "\[Sigma]SumK", 
    " ", "smerodatna", " ", "odchylka", " ", "sumu", "\[IndentingNewLine]", 
    RowBox[{"k", ":", " ", 
     RowBox[{
     "sumy", " ", "jsou", " ", "nasobeny", " ", "k", " ", "a", " ", 
      "amplitudou", " ", "sumu"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
   "nAV", " ", "delka", " ", "okna", " ", "MovingAverage", " ", "pro", " ", 
    "filtraci", " ", "pri", " ", "pouziti", " ", "pruchodu", " ", "nulou", 
    "\[IndentingNewLine]", 
    RowBox[{"kNula", ":", " ", 
     RowBox[{
     "udava", " ", "hladinu", " ", "kolik", " ", "bodu", " ", "bereme", " ", 
      "pro", " ", "Fit", " ", "ze", " ", "ktereho", " ", "bereme", " ", 
      "casy", " ", "pruchodu", " ", "nulou"}]}]}]}], "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.753411697984375*^9, 3.75341177403125*^9}, {
  3.753411832546875*^9, 
  3.7534120035*^9}},ExpressionUUID->"8884e628-3c30-4b37-bc72-e192bb9c1394"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejFourier", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejFourier", "[", 
    RowBox[{"listDat_", ",", "sr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "pdata", ",", "n", ",", "pos", ",", "fr", ",", "frpos", ",", 
       "nx", ",", "frekv"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pdata", "=", "listDat"}], ";", "\[IndentingNewLine]", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "pdata", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"f", " ", "=", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"Fourier", "[", "pdata", "]"}], "]"}]}], ";", "\n", "       ", 
      RowBox[{"pos", " ", "=", " ", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"f", ",", " ", 
          RowBox[{"Max", "[", "f", "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fr", " ", "=", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"Fourier", "[", 
         RowBox[{
          RowBox[{"pdata", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"2", " ", "Pi", " ", "I", " ", 
             RowBox[{"(", 
              RowBox[{"pos", " ", "-", " ", "2"}], ")"}], " ", 
             RowBox[{
              RowBox[{"N", "[", 
               RowBox[{"Range", "[", 
                RowBox[{"0", ",", " ", 
                 RowBox[{"n", " ", "-", " ", "1"}]}], "]"}], "]"}], "/", 
              "n"}]}], "]"}]}], ",", " ", 
          RowBox[{"FourierParameters", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"2", "/", "n"}]}], "}"}]}]}], "]"}], "]"}]}], ";", "\n", 
      "        ", 
      RowBox[{"frpos", " ", "=", " ", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"fr", ",", " ", 
          RowBox[{"Max", "[", "fr", "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       RowBox[{"N", "[", 
        RowBox[{"n", "/", 
         RowBox[{"(", 
          RowBox[{"pos", " ", "-", " ", "2", " ", "+", " ", 
           RowBox[{"2", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"frpos", " ", "-", " ", "1"}], ")"}], "/", "n"}]}]}], 
          ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"frekv", "=", 
         FractionBox[
          RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["frekv", "fnom"]}], ")"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pompom", "=", 
   RowBox[{"dejData", "[", 
    RowBox[{"{", 
     RowBox[{"trialfce", ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "0.2", ",", "0.2"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejFourier", "[", 
  RowBox[{"pompom", ",", "sr"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7537591640625*^9, 
  3.753759171234375*^9}},ExpressionUUID->"9892647f-5ed8-43b9-9f42-\
0dd04fab5844"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50.908851360571425`", ",", "2.742297278857153`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.75367093934375*^9, {3.753674175578125*^9, 3.75367420465625*^9}, 
   3.7536786995*^9, 3.75368196146875*^9, 3.75375917403125*^9, 
   3.753759428046875*^9, 3.8158828186624537`*^9, 
   3.828671427721989*^9},ExpressionUUID->"e03f2a83-c095-422e-b151-\
5fe85e394715"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejChybyAll", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejChybyAll", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pars", ":", 
       RowBox[{"{", 
        RowBox[{"fce_", ",", 
         RowBox[{"{", 
          RowBox[{"SR_Integer", ",", "\[Sigma]SumK_", ",", "k_"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "data", ",", "pl1", ",", "Nx5", ",", "pruchody", ",", "ukp1", ",", 
       "ukp2", ",", "fourier"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"dejData", "[", "pars", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Nx5", "=", 
       RowBox[{"vydejNx5", "[", 
        RowBox[{"data", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pruchody", "=", 
       RowBox[{"vydejPruchody", "[", 
        RowBox[{"{", 
         RowBox[{"data", ",", "sr", ",", "kNula", ",", "nAV"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fourier", "=", 
       RowBox[{"vydejFourier", "[", 
        RowBox[{"data", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Nx5", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"pruchody", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"fourier", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vydejChybyAll", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"trialfce", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.04"}], "}"}]}], "}"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.75366995759375*^9, 3.75366996946875*^9}, {
   3.753670016609375*^9, 3.753670075484375*^9}, 
   3.75375921703125*^9},ExpressionUUID->"40eefa2a-fef9-4a34-9fc2-\
ae539e0999be"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.753669971390625*^9, 
  3.75366999153125*^9}},ExpressionUUID->"a7cb7476-cb8a-4831-8104-\
eeddb2b87a0d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "zpracujChybySRAll", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zpracujChybySRAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pars", ":", 
        RowBox[{"{", 
         RowBox[{"fce_", ",", 
          RowBox[{"{", 
           RowBox[{"\[Sigma]SumK_", ",", "k_"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"nAV_", ",", "kNula_"}], "}"}]}], "}"}], ",", "nChyb_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "dataChyby", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataChyby", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"vydejChybyAll", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"fce", ",", 
              RowBox[{"{", 
               RowBox[{"#", ",", "\[Sigma]SumK", ",", "k"}], "}"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"nAV", ",", "kNula"}], "}"}]}], "}"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "nChyb", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Mean", "[", "dataChyby", "]"}], ",", 
        RowBox[{"Mean", "[", 
         RowBox[{"Abs", "/@", "dataChyby"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"First", "[", "#", "]"}], "]"}], "&"}], "/@", 
            "dataChyby"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}], "/@", 
            "dataChyby"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"Last", "[", "#", "]"}], "]"}], "&"}], "/@", 
            "dataChyby"}], "]"}]}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zpracujChybySRAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"trialfce", ",", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "0.6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "0.02"}], "}"}]}], "}"}], ",", "5"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.753670127890625*^9, 3.753670179015625*^9}, {
   3.753670215734375*^9, 3.7536702653125*^9}, 3.75367043465625*^9, 
   3.7536708869375*^9, 
   3.753671315296875*^9},ExpressionUUID->"fd961a1e-0228-47e9-a8dc-\
b56f16cbcde0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kmin", "=", 
   RowBox[{"1.", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kmax", "=", "1.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nKacek", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kacka", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"kmin", "*", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["kmax", "kmin"], ")"}], 
       FractionBox[
        RowBox[{"#", "-", "1"}], "nKacek"]]}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"Round", "[", 
      RowBox[{"nKacek", "+", "1"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.75349808278125*^9, 3.75349813396875*^9}, {
   3.7534982040625*^9, 3.75349829921875*^9}, {3.753674161125*^9, 
   3.7536741620625*^9}, 
   3.753759231234375*^9},ExpressionUUID->"46a32688-1a86-40fe-b1a3-\
95fcfb80503f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataChybAll", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"Quiet", "@", 
        RowBox[{"zpracujChybySRAll", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"trialfce", ",", 
              RowBox[{"{", 
               RowBox[{
                StyleBox["0.4",
                 FontColor->RGBColor[1, 0, 0]], ",", "k"}], "}"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"10", ",", "0.02"}], "}"}]}], "}"}], ",", "100"}], 
         "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "kacka"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataChybAll", ">>", "\"\<dataChybVH2\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.753670298890625*^9, 3.753670327171875*^9}, {
   3.753670452734375*^9, 3.75367045428125*^9}, 3.753670897484375*^9, 
   3.753671305421875*^9, {3.75367413778125*^9, 3.753674142375*^9}, 
   3.75367484471875*^9, 3.753681983*^9, {3.7537592643125*^9, 
   3.7537592661875*^9}},ExpressionUUID->"aa938d0e-fa7a-4001-8922-\
473e0e109112"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"<<", "\"\<dataChybVH2\>\""}], ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errNase", "=", 
   RowBox[{"vys", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k_", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", 
         RowBox[{"{", 
          RowBox[{"e_", ",", "f_", ",", "g_"}], "}"}]}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"k", ",", "e"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errZeroCrossing", "=", 
   RowBox[{"vys", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k_", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", 
         RowBox[{"{", 
          RowBox[{"e_", ",", "f_", ",", "g_"}], "}"}]}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"k", ",", "f"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errFourier", "=", 
   RowBox[{"vys", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k_", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", 
         RowBox[{"{", 
          RowBox[{"e_", ",", "f_", ",", "g_"}], "}"}]}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"k", ",", "g"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"procmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plNase", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"errNase", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0.0001", ",", "procmax"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kNoise [-]\>\"", ",", "\"\<\[Delta]f [%]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*StyleBox[\"statistical\",FontColor->RGBColor[1, 0, 0]]\)  \!\
\(\*StyleBox[\"zero\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"crossing\",FontColor->GrayLevel[\
0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"FFT\",FontColor->RGBColor[0, 0, \
1]]\)\>\""}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plZC", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"errZeroCrossing", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0.0001", ",", "procmax"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kNoise [-]\>\"", ",", "\"\<\[Delta]f [%]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*StyleBox[\"statistical\",FontColor->RGBColor[1, 0, 0]]\)  \!\
\(\*StyleBox[\"zero\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"crossing\",FontColor->GrayLevel[\
0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"FFT\",FontColor->RGBColor[0, 0, \
1]]\)\>\""}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plFourier", "=", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{"errFourier", ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0.0001", ",", "procmax"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kNoise [-]\>\"", ",", "\"\<\[Delta]f [%]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<\!\(\*StyleBox[\"statistical\",FontColor->RGBColor[1, 0, 0]]\)  \!\
\(\*StyleBox[\"zero\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"crossing\",FontColor->GrayLevel[\
0]]\)\!\(\*StyleBox[\" \
\",FontColor->GrayLevel[0]]\)\!\(\*StyleBox[\"FFT\",FontColor->RGBColor[0, 0, \
1]]\)\>\""}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vysobr1a", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plNase", ",", "plZC", ",", "plFourier", ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.75367038775*^9, 3.753670388765625*^9}, {
  3.753670537703125*^9, 3.75367070540625*^9}, {3.753674885234375*^9, 
  3.753674977203125*^9}, {3.753759282890625*^9, 
  3.753759307578125*^9}},ExpressionUUID->"7eaf29ec-60a2-430b-bc37-\
6f987e617bdd"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
      LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAoP+PmYqhG8BLSD7AzYgawGnXdIuH
NhrAvd+ltckIGcAxr1l9hMsYwNrt/qNKjxfA+oY+b4FgF8A0uHdMPBoWwMNe
I2F+9RXApaku+jqoFMCLNghTe4oUwLJ/IFJVOBPAVA7tRHgfE8A/cuPD5ckR
wB3m0TZ1tBHAJOFAyXlcEMDlvbYockkQwDWoqDaD3w3AWys3Nd68DcBi4u6W
CgcLwOzaABnY5grAV6v33TovCMB9isr80RAIwH1ZMJ7cVwXADzqU4Ms6BcDz
4/CklIMCwKDpXcTFZALAIbex8Mxd/79lMk9Qfx3/v0mQy2urtPm/hZHiF3Nx
+b/K4Hgg6g30v6fwdd9mxfO/T6f3+x/T7L+WnxJOtTLsv0TcOSOFmuG/1l05
3Zza4L/wHx60x9PJv4BwgLERCsa/RxarBmtewj91luQRUFbHP3L5nvefV94/
sS6x/A==
       "]]}}, {}, {}, {}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], Thickness[Large], 
      LineBox[{{-6.907755278982137, -6.444736639380254}, {-6.553251437193333, \
-6.082099887582096}, {-6.1987475954045275`, -5.722010414922781}, \
{-5.844243753615723, -5.328141516019545}, {-5.489739911826919, \
-4.973322009124449}, {-5.135236070038114, -4.618459893202234}, \
{-4.78073222824931, -4.263481045548769}, {-4.426228386460505, \
-3.911318517123725}, {-4.0717245446717, -3.554386134545287}, \
{-3.7172207028828956`, -3.1967817339406124`}, {-3.362716861094091, \
-2.837518863075478}, {-3.0082130193052863`, -2.5457771033495553`}, \
{-2.653709177516482, -2.17150301469225}, {-2.2992053357276774`, \
-1.6308569183860773`}, {-1.9447014939388734`, -0.6784989773511629}, \
{-1.6636880360809856`, 2.995732273553991}}]}}, {}, {}, {}, {}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], Thickness[Large], 
      LineBox[{{-6.907755278982137, 0.995530535262821}, {-6.840059008606873, 
       2.995732273553991}}], 
      LineBox[{{-6.266443865779792, 2.995732273553991}, {-6.1987475954045275`,
        0.995530535262821}, {-6.131051325029263, 2.995732273553991}}], 
      LineBox[{{-5.557436182202183, 2.995732273553991}, {-5.489739911826919, 
       0.995530535262821}, {-5.135236070038114, 
       0.995530535262821}, {-5.06753979966285, 2.995732273553991}}], 
      LineBox[{{-2.721041756364304, 2.995732273553991}, {-2.653709177516482, 
       1.008795992060366}, {-2.5863766010967706`, 2.995732273553991}}], 
      LineBox[{{-2.011318163879088, 2.995732273553991}, {-1.9447014939388734`,
        1.0348103812509386`}, {-1.8780848264069405`, 
       2.995732273553991}}]}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"kNoise [-]\"", TraditionalForm], 
    FormBox["\"\[Delta]f [%]\"", TraditionalForm]},
  AxesOrigin->{-7.168555631339785, -9.14931000874853},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->FrontEndValueCache[{
     Charting`ScaledTickValues[{Log, Exp}], 
     Charting`ScaledTickValues[{Log, Exp}]}, {{{-6.907755278982137, 
       Directive[
        AbsoluteThickness[0.1]]}, {-5.298317366548036, 
       Directive[
        AbsoluteThickness[0.1]]}, {-4.605170185988091, 
       Directive[
        AbsoluteThickness[0.1]]}, {-2.995732273553991, 
       Directive[
        AbsoluteThickness[0.1]]}, {-2.3025850929940455`, 
       Directive[
        AbsoluteThickness[0.1]]}, {-0.6931471805599453, 
       Directive[
        AbsoluteThickness[0.1]]}, {0., 
       Directive[
        AbsoluteThickness[0.1]]}}, {{-6.907755278982137, 
       Directive[
        AbsoluteThickness[0.1]]}, {-4.605170185988091, 
       Directive[
        AbsoluteThickness[0.1]]}, {-2.3025850929940455`, 
       Directive[
        AbsoluteThickness[0.1]]}, {0., 
       Directive[
        AbsoluteThickness[0.1]]}, {2.302585092994046, 
       Directive[
        AbsoluteThickness[0.1]]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
   "\"\\!\\(\\*StyleBox[\\\"statistical\\\",FontColor->RGBColor[1, 0, 0]]\\)  \
\\!\\(\\*StyleBox[\\\"zero\\\",FontColor->GrayLevel[0]]\\)\\!\\(\\*StyleBox[\\\
\" \\\",FontColor->GrayLevel[0]]\\)\\!\\(\\*StyleBox[\\\"crossing\\\",\
FontColor->GrayLevel[0]]\\)\\!\\(\\*StyleBox[\\\" \
\\\",FontColor->GrayLevel[0]]\\)\\!\\(\\*StyleBox[\\\"FFT\\\",FontColor->\
RGBColor[0, 0, 1]]\\)\"", TraditionalForm],
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.005\"", 0.005, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{
  3.75367127528125*^9, 3.753674529234375*^9, 3.75367488865625*^9, {
   3.753674928515625*^9, 3.7536749775625*^9}, 3.75367870065625*^9, 
   3.753681962546875*^9, 3.753759584546875*^9, 3.81588288662212*^9, 
   3.8286714944406824`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"1ec3d0d7-6adc-44b0-b8ea-61dfdb0bb00d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exp", "[", "vysobr1a", "]"}]], "Input",
 CellChangeTimes->{{3.753670499984375*^9, 3.753670501453125*^9}, {
  3.7536749876875*^9, 3.75367499503125*^9}, {3.753759311625*^9, 
  3.75375931184375*^9}},ExpressionUUID->"f2a9575c-096e-4dd6-9f76-\
21ac94ca38f1"],

Cell[BoxData["\<\"vysobr1a.png\"\>"], "Output",
 CellChangeTimes->{3.753671275328125*^9, 3.753674529296875*^9, 
  3.75367499865625*^9, 3.753678701515625*^9, 3.753681964828125*^9, 
  3.753759587046875*^9, 3.815882887735218*^9, 
  3.828671495331098*^9},ExpressionUUID->"72ef172f-8e02-4a94-8762-\
6cef3d2518ea"]
}, Open  ]]
},
WindowSize->{1107, 639},
WindowMargins->{{13, Automatic}, {Automatic, 6}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4000000953674316`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1450, 40, 209, "Input",ExpressionUUID->"215eb9ea-b69b-4be9-a9cd-0ec30aa71a3c"],
Cell[1998, 62, 13003, 312, 1173, "Input",ExpressionUUID->"823b6015-adaf-4e73-9ca7-c2813b7ba6f6"],
Cell[15004, 376, 3857, 82, 458, "Input",ExpressionUUID->"78a246c8-036e-4d7c-8217-da1a4fc24674"],
Cell[18864, 460, 6484, 162, 654, "Input",ExpressionUUID->"5ea509df-331d-4d99-bdb0-bfcf37877543"],
Cell[25351, 624, 3505, 89, 377, "Input",ExpressionUUID->"827f3a01-034d-43ac-a86e-7b268845f659"],
Cell[28859, 715, 4084, 100, 461, "Input",ExpressionUUID->"2bea3057-6332-4670-98b1-dfb7b9ce14d4"],
Cell[32946, 817, 1652, 38, 237, "Input",ExpressionUUID->"8884e628-3c30-4b37-bc72-e192bb9c1394"],
Cell[CellGroupData[{
Cell[34623, 859, 3283, 87, 459, "Input",ExpressionUUID->"9892647f-5ed8-43b9-9f42-0dd04fab5844"],
Cell[37909, 948, 393, 8, 46, "Output",ExpressionUUID->"e03f2a83-c095-422e-b151-5fe85e394715"]
}, Open  ]],
Cell[38317, 959, 2165, 59, 293, "Input",ExpressionUUID->"40eefa2a-fef9-4a34-9fc2-ae539e0999be"],
Cell[40485, 1020, 151, 3, 40, "Input",ExpressionUUID->"a7cb7476-cb8a-4831-8104-eeddb2b87a0d"],
Cell[40639, 1025, 2735, 79, 265, "Input",ExpressionUUID->"fd961a1e-0228-47e9-a8dc-b56f16cbcde0"],
Cell[43377, 1106, 927, 27, 164, "Input",ExpressionUUID->"46a32688-1a86-40fe-b1a3-95fcfb80503f"],
Cell[44307, 1135, 1188, 32, 97, "Input",ExpressionUUID->"aa938d0e-fa7a-4001-8922-473e0e109112"],
Cell[CellGroupData[{
Cell[45520, 1171, 5159, 134, 433, "Input",ExpressionUUID->"7eaf29ec-60a2-430b-bc37-6f987e617bdd"],
Cell[50682, 1307, 33412, 638, 334, 20095, 419, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"1ec3d0d7-6adc-44b0-b8ea-61dfdb0bb00d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84131, 1950, 277, 5, 40, "Input",ExpressionUUID->"f2a9575c-096e-4dd6-9f76-21ac94ca38f1"],
Cell[84411, 1957, 308, 5, 46, "Output",ExpressionUUID->"72ef172f-8e02-4a94-8762-6cef3d2518ea"]
}, Open  ]]
}
]
*)

