(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     21163,        581]
NotebookOptionsPosition[     19376,        545]
NotebookOutlinePosition[     19836,        562]
CellTagsIndexPosition[     19793,        559]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"255edb4f-da29-4b0a-88e2-e224bba41b2b"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f0", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T0", "=", 
     FractionBox["1", "f0"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]0", "=", 
     RowBox[{"2", "*", "Pi", "*", "f0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"230.", "*", 
       SqrtBox["2"], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"\[Omega]0", "*", "t"}], "+", "0.332"}], "]"}]}], "+", 
      RowBox[{"0.1", "*", "230.", "*", 
       SqrtBox["2"], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"3", "\[Omega]0", "*", "t"}], "+", 
         RowBox[{"3", "*", "0.332"}]}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"level", "=", 
     RowBox[{"0.1", "*", "230.", "*", 
      SqrtBox["2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f1", "[", "t", "]"}], ",", "level"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0.", ",", 
        RowBox[{"2", "T0"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.848536769890625*^9, 3.848536770078125*^9}, {
   3.848536820078125*^9, 3.84853717015625*^9}, {3.848537259796875*^9, 
   3.848537394515625*^9}, {3.84853747965625*^9, 3.848537529484375*^9}, {
   3.848537562234375*^9, 3.8485375625625*^9}, {3.848537627203125*^9, 
   3.848537643375*^9}, {3.848537753234375*^9, 3.848537894203125*^9}, {
   3.848537936734375*^9, 3.848537944890625*^9}, {3.848537994359375*^9, 
   3.848538034453125*^9}, {3.848538086765625*^9, 3.848538108953125*^9}, {
   3.84853820278125*^9, 3.84853822175*^9}, {3.848547429515625*^9, 
   3.84854743303125*^9}, 
   3.848547466671875*^9},ExpressionUUID->"ab96ebf2-04df-4dd4-b391-\
450b5a3e6951"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sr", "=", "32000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["1.", "sr"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ksif", "=", "1.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]SumK", "=", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aSum", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataCista", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"f1", "[", 
        RowBox[{"t", "*", "ksif"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", 
       RowBox[{"3.6", "T0"}], ",", "\[CapitalDelta]t"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"dataCista", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"u", "+", 
        RowBox[{"aSum", "*", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"0.0", ",", "\[Sigma]SumK"}], "]"}], "]"}]}]}]}], 
      "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"data", ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.004", "]"}]}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.848538126125*^9, 3.848538188859375*^9}, {
   3.848538226734375*^9, 3.848538299265625*^9}, {3.8485383864375*^9, 
   3.84853846028125*^9}, {3.84853849996875*^9, 3.848538660640625*^9}, 
   3.8485474708125*^9, {3.84854762221875*^9, 
   3.848547655859375*^9}},ExpressionUUID->"a58b8e3c-8871-4acc-82dd-\
2ec4ed266012"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejPruchody", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejPruchody", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"{", 
       RowBox[{"kNula_", ",", "nAV_"}], "}"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "amplituda", ",", "dataFiltrovana", ",", "test", ",", "bodyKolemNuly", 
        ",", "testGather", ",", 
        RowBox[{"kGather", "=", "0.2"}], ",", "skupiny", ",", "prusecik", ",",
         "pruseciky", ",", "trojice", ",", "dejPeriodu"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dataFiltrovana", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{"data", ",", "nAV"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"amplituda", "=", 
        RowBox[{"Max", "@", 
         RowBox[{"Abs", "[", 
          RowBox[{"Last", "/@", "dataFiltrovana"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"test", "[", 
         RowBox[{"{", 
          RowBox[{"t_", ",", "u_"}], "}"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Abs", "[", "u", "]"}], "\[LessEqual]", 
         RowBox[{"kNula", "*", "amplituda"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"bodyKolemNuly", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"dataFiltrovana", ",", "test"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"testGather", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t1_", ",", "u1_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t2_", ",", "u2_"}], "}"}]}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"t1", "-", "t2"}], "]"}], "\[LessEqual]", 
         RowBox[{"kGather", "*", "T0"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"skupiny", "=", 
        RowBox[{"Gather", "[", 
         RowBox[{"bodyKolemNuly", ",", "testGather"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"prusecik", "[", "skupina_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", "fit", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"fit", "=", 
            RowBox[{"Fit", "[", 
             RowBox[{"skupina", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"t", "/.", 
            RowBox[{
             RowBox[{"Solve", "[", 
              RowBox[{"fit", "\[Equal]", "0"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"pruseciky", "=", 
        RowBox[{"prusecik", "/@", "skupiny"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"trojice", "=", 
        RowBox[{"Partition", "[", 
         RowBox[{"pruseciky", ",", "3", ",", "1"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dejPeriodu", "[", 
         RowBox[{"{", 
          RowBox[{"t1_", ",", "t2_", ",", "t3_"}], "}"}], "]"}], ":=", 
        RowBox[{"t3", "-", "t1"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Mean", "[", 
        RowBox[{"dejPeriodu", "/@", "trojice"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"vydejPruchody", "[", 
     RowBox[{"data", ",", 
      RowBox[{"{", 
       RowBox[{"0.05", ",", "1"}], "}"}]}], "]"}], "-", 
    FractionBox["T0", "ksif"]}], 
   FractionBox["T0", "ksif"]], "*", "100"}]}], "Input",
 CellChangeTimes->{{3.848547662171875*^9, 3.848547702296875*^9}, {
   3.848547798328125*^9, 3.84854780025*^9}, {3.848547895203125*^9, 
   3.848547926*^9}, {3.84854796034375*^9, 3.8485480016875*^9}, {
   3.848548040328125*^9, 3.84854807475*^9}, {3.848548127296875*^9, 
   3.848548131578125*^9}, {3.848548164546875*^9, 3.8485482721875*^9}, {
   3.8485483135*^9, 3.848548365109375*^9}, 3.8485484101875*^9, {
   3.848548496296875*^9, 3.848548661890625*^9}, {3.848548693421875*^9, 
   3.848548720828125*^9}, {3.848548760453125*^9, 3.8485488264375*^9}, {
   3.848548950421875*^9, 3.848549066234375*^9}, {3.848549105453125*^9, 
   3.848549129875*^9}, {3.84854918978125*^9, 3.84854925121875*^9}, {
   3.848549305234375*^9, 3.848549352375*^9}, {3.84854955796875*^9, 
   3.84854960715625*^9}},ExpressionUUID->"691ff5e9-7309-4e44-97d8-\
4febab2df7c5"],

Cell[BoxData[
 RowBox[{"-", "0.0015007143491542474`"}]], "Output",
 CellChangeTimes->{
  3.848548075265625*^9, 3.84854812878125*^9, {3.8485483174375*^9, 
   3.848548344984375*^9}, 3.848548406140625*^9, 3.848548723296875*^9, {
   3.848548781515625*^9, 3.848548827953125*^9}, 3.84854906721875*^9, 
   3.848549130703125*^9, 3.848549219484375*^9, 3.84854925215625*^9, {
   3.848549340265625*^9, 3.848549352875*^9}, {3.848549563875*^9, 
   3.848549607484375*^9}, 
   3.8787148464801464`*^9},ExpressionUUID->"de89e0c0-8959-4509-bed9-\
456a161c8ded"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pom", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["a", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "10", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Partition", "[", 
  RowBox[{"pom", ",", "3", ",", "1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.848549361390625*^9, 
  3.848549396890625*^9}},ExpressionUUID->"93d6842c-4af8-436d-ad7b-\
65baa3d269d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["a", "1"], ",", 
   SubscriptBox["a", "2"], ",", 
   SubscriptBox["a", "3"], ",", 
   SubscriptBox["a", "4"], ",", 
   SubscriptBox["a", "5"], ",", 
   SubscriptBox["a", "6"], ",", 
   SubscriptBox["a", "7"], ",", 
   SubscriptBox["a", "8"], ",", 
   SubscriptBox["a", "9"], ",", 
   SubscriptBox["a", "10"]}], "}"}]], "Output",
 CellChangeTimes->{{3.848549375046875*^9, 3.848549397296875*^9}, 
   3.8787148465491395`*^9},ExpressionUUID->"d2532842-051b-49d5-9b19-\
ad24b2fb9c93"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", 
     SubscriptBox["a", "2"], ",", 
     SubscriptBox["a", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "2"], ",", 
     SubscriptBox["a", "3"], ",", 
     SubscriptBox["a", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "3"], ",", 
     SubscriptBox["a", "4"], ",", 
     SubscriptBox["a", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "4"], ",", 
     SubscriptBox["a", "5"], ",", 
     SubscriptBox["a", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "5"], ",", 
     SubscriptBox["a", "6"], ",", 
     SubscriptBox["a", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "6"], ",", 
     SubscriptBox["a", "7"], ",", 
     SubscriptBox["a", "8"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "7"], ",", 
     SubscriptBox["a", "8"], ",", 
     SubscriptBox["a", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "8"], ",", 
     SubscriptBox["a", "9"], ",", 
     SubscriptBox["a", "10"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.848549375046875*^9, 3.848549397296875*^9}, 
   3.8787148465647607`*^9},ExpressionUUID->"c8417f1d-9957-44bc-a071-\
72722546da68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gather"], "Input",
 CellChangeTimes->{{3.8485484126875*^9, 
  3.848548415765625*^9}},ExpressionUUID->"5358fd50-c1b1-4059-9bb4-\
328316f55a25"],

Cell[BoxData["Gather"], "Output",
 CellChangeTimes->{
  3.878714846611625*^9},ExpressionUUID->"138e8b18-de26-4a04-ac82-\
165406c4e329"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Take", "[", 
    RowBox[{"data", ",", "5"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Max", "[", "%", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.84854789*^9, 3.848547891203125*^9}, {
  3.848548025890625*^9, 3.848548032375*^9}, {3.848548083328125*^9, 
  3.84854810328125*^9}},ExpressionUUID->"21728f79-e97a-4d26-a215-\
1c21b173af46"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "133.80203108688082`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00003125`", ",", "137.1710348711589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0000625`", ",", "142.01020949883065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00009375`", ",", "144.11657230745976`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000125`", ",", "147.05155507879064`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.848548032625*^9, {3.848548085234375*^9, 3.848548103828125*^9}, 
   3.878714846649377*^9},ExpressionUUID->"4d6d55ce-07b3-4d9a-9909-\
b642962afe09"],

Cell[BoxData["147.05155507879064`"], "Output",
 CellChangeTimes->{
  3.848548032625*^9, {3.848548085234375*^9, 3.848548103828125*^9}, 
   3.878714846664998*^9},ExpressionUUID->"01fb0a4b-871e-4ddd-840c-\
a6c261308428"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejPruchody", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejPruchody", "[", 
    RowBox[{"{", 
     RowBox[{"listDat_", ",", "sr_", ",", "kNula_", ",", "nAV_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "datsSCasy", ",", "minU", ",", "maxU", ",", "ampl", ",", "kolemNuly", 
       ",", "gathered", ",", 
       RowBox[{"kGatger", "=", "0.02"}], ",", "prusecik", ",", "t", ",", 
       "perioda", ",", "f", ",", "selectMozne", ",", "vybrane"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"datsSCasy", "=", 
       RowBox[{"MovingAverage", "[", 
        RowBox[{
         RowBox[{"Thread", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[CapitalDelta]tnom", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Range", "[", 
                RowBox[{"Length", "[", "listDat", "]"}], "]"}], "-", "1"}], 
              ")"}]}], ",", "listDat"}], "}"}], "]"}], ",", 
         RowBox[{"Round", "[", "nAV", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"minU", ",", "maxU"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "#", "]"}], ",", 
           RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", "datsSCasy"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ampl", "=", 
       RowBox[{"0.5", "*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"minU", ",", "maxU"}], "}"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kolemNuly", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"datsSCasy", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", 
           RowBox[{"kNula", "*", "ampl"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gathered", "=", 
       RowBox[{"Gather", "[", 
        RowBox[{"kolemNuly", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"#1", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"#2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<", 
           RowBox[{"kGatger", "*", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"prusecik", "[", "data_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "fit", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"fit", "=", 
           RowBox[{"Fit", "[", 
            RowBox[{"data", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", "t"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"t", "/.", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"fit", "\[Equal]", "0"}], ",", "t"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"selectMozne", "[", "periody_", "]"}], ":=", 
       RowBox[{"Select", "[", 
        RowBox[{"periody", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"#", "-", "Tnom"}], "]"}], "<", 
           RowBox[{"0.2", "Tnom"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"selectMozne", ":=", 
         RowBox[{"#", "&"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"vybrane", "=", 
       RowBox[{"selectMozne", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"prusecik", "/@", "gathered"}], ",", "3", ",", "1"}], 
          "]"}], "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a_", ",", "_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"b", "-", "a"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"perioda", "=", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[GreaterEqual]", "1"}], 
         ",", 
         RowBox[{"Mean", "[", "vybrane", "]"}], ",", 
         RowBox[{
          RowBox[{"Length", "[", "vybrane", "]"}], "\[LessEqual]", "1"}], ",", 
         FractionBox["0.04", "k\[Omega]"]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox["1.", "perioda"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", "1.", ",", 
        FractionBox["perioda", "Tnom"]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",ExpressionUUID->"14b7d637-429c-400d-b027-\
44740a25c12e"]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.7000001668930054`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 387, 10, 116, "Input",ExpressionUUID->"255edb4f-da29-4b0a-88e2-e224bba41b2b"],
Cell[948, 32, 1995, 51, 407, "Input",ExpressionUUID->"ab96ebf2-04df-4dd4-b391-450b5a3e6951"],
Cell[2946, 85, 1927, 53, 452, "Input",ExpressionUUID->"a58b8e3c-8871-4acc-82dd-2ec4ed266012"],
Cell[CellGroupData[{
Cell[4898, 142, 4554, 109, 785, "Input",ExpressionUUID->"691ff5e9-7309-4e44-97d8-4febab2df7c5"],
Cell[9455, 253, 543, 10, 55, "Output",ExpressionUUID->"de89e0c0-8959-4509-bed9-456a161c8ded"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10035, 268, 378, 10, 83, "Input",ExpressionUUID->"93d6842c-4af8-436d-ad7b-65baa3d269d9"],
Cell[10416, 280, 535, 15, 55, "Output",ExpressionUUID->"d2532842-051b-49d5-9b19-ad24b2fb9c93"],
Cell[10954, 297, 1357, 45, 89, "Output",ExpressionUUID->"c8417f1d-9957-44bc-a071-72722546da68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12348, 347, 156, 3, 49, "Input",ExpressionUUID->"5358fd50-c1b1-4059-9bb4-328316f55a25"],
Cell[12507, 352, 135, 3, 55, "Output",ExpressionUUID->"138e8b18-de26-4a04-ac82-165406c4e329"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12679, 360, 600, 12, 380, "Input",ExpressionUUID->"21728f79-e97a-4d26-a215-1c21b173af46"],
Cell[13282, 374, 650, 17, 89, "Output",ExpressionUUID->"4d6d55ce-07b3-4d9a-9909-b642962afe09"],
Cell[13935, 393, 217, 4, 55, "Output",ExpressionUUID->"01fb0a4b-871e-4ddd-840c-a6c261308428"]
}, Open  ]],
Cell[14167, 400, 5205, 143, 119, "Input",ExpressionUUID->"14b7d637-429c-400d-b027-44740a25c12e"]
}
]
*)

