(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7770,        233]
NotebookOptionsPosition[      7015,        212]
NotebookOutlinePosition[      7498,        230]
CellTagsIndexPosition[      7455,        227]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.688870452015625*^9},ExpressionUUID->"5abf666e-d282-48bc-9021-\
3b59d333e7fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fNom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tnom", "=", 
   FractionBox["1", "fNom"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]Nom", "=", 
   RowBox[{"2", "*", "Pi", "*", "fNom"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zload", "=", 
   RowBox[{"100.", "+", 
    RowBox[{"10.", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Zline", "=", 
   RowBox[{"0.1", "+", 
    RowBox[{"3.2", "I"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Usource", "=", "230"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Iload", "=", 
   FractionBox["Usource", 
    RowBox[{"Zload", "+", "Zline"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Uload", "=", 
   RowBox[{"Iload", "*", "Zload"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sload", "=", 
   RowBox[{
    RowBox[{"Conjugate", "[", "Iload", "]"}], "*", "Uload"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uReal", "[", 
    RowBox[{"t_", ",", "\[Omega]_"}], "]"}], ":=", 
   RowBox[{"Im", "[", 
    RowBox[{"Uload", "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", "\[Omega]", "*", "t"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IReal", "[", 
    RowBox[{"t_", ",", "\[Omega]_"}], "]"}], ":=", 
   RowBox[{"Im", "[", 
    RowBox[{"Iload", "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", "\[Omega]", "*", "t"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dejPhasor", "[", 
    RowBox[{"fce_", ",", "\[Omega]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", "=", 
        FractionBox[
         RowBox[{"2.", "Pi"}], "\[Omega]"]}], ",", "a", ",", "b"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{
        FractionBox["2", "T"], "*", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"fce", "[", "t", "]"}], "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"\[Omega]", "*", "t"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"b", "=", 
       RowBox[{
        FractionBox["2", "T"], "*", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"fce", "[", "t", "]"}], "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Omega]", "*", "t"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"b", "+", 
       RowBox[{"I", "*", "a"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dejPhasor", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"IReal", "[", 
      RowBox[{"#", ",", "\[Omega]Nom"}], "]"}], "&"}], ",", "\[Omega]Nom"}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.688870455296875*^9, 3.688870532125*^9}, {
   3.6888705665625*^9, 3.6888707233125*^9}, 3.6888707670625*^9, {
   3.68887084878125*^9, 3.68887114621875*^9}, 
   3.688871179171875*^9},ExpressionUUID->"391efed4-2b4b-4e4c-8b16-\
2eb651d6e95c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyhodnot", "[", "ksi_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Omega]", "=", 
        RowBox[{"ksi", "*", "\[Omega]Nom"}]}], ",", "iph", ",", "uph", ",", 
       "S", ",", "\[CapitalDelta]P", ",", "\[CapitalDelta]Q"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"iph", "=", 
       RowBox[{"dejPhasor", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"IReal", "[", 
           RowBox[{"#", ",", "\[Omega]"}], "]"}], "&"}], ",", "\[Omega]Nom"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"uph", "=", 
       RowBox[{"dejPhasor", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"uReal", "[", 
           RowBox[{"#", ",", "\[Omega]"}], "]"}], "&"}], ",", "\[Omega]Nom"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"S", "=", 
       RowBox[{
        RowBox[{"Conjugate", "[", "iph", "]"}], "*", "uph"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[CapitalDelta]P", ",", "\[CapitalDelta]Q"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Sload", "-", "S"}], "]"}], ",", 
         RowBox[{"Im", "[", 
          RowBox[{"Sload", "-", "S"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<\[Delta]P= \>\"", ",", 
        RowBox[{
         FractionBox["\[CapitalDelta]P", 
          RowBox[{"Re", "[", "Sload", "]"}]], "*", "100"}], ",", 
        "\"\< %,  \[Delta]Q= \>\"", ",", 
        RowBox[{
         FractionBox["\[CapitalDelta]Q", 
          RowBox[{"Im", "[", "Sload", "]"}]], "*", "100"}], ",", 
        "\"\< %\>\""}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vyhodnot", "[", "1.05", "]"}]}], "Input",
 CellChangeTimes->{{3.688871196015625*^9, 3.688871258734375*^9}, {
  3.688871364296875*^9, 3.68887147684375*^9}, {3.688871512046875*^9, 
  3.68887171715625*^9}},ExpressionUUID->"73be3ccf-69bb-4fa1-af23-\
283c06164200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Delta]P= \"\>", "\[InvisibleSpace]", "5.5671863190689`", 
   "\[InvisibleSpace]", "\<\" %,  \[Delta]Q= \"\>", "\[InvisibleSpace]", 
   "0.8787667230031273`", "\[InvisibleSpace]", "\<\" %\"\>"}],
  SequenceForm[
  "\[Delta]P= ", 5.5671863190689, " %,  \[Delta]Q= ", 0.8787667230031273, 
   " %"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.847938871343852*^9},ExpressionUUID->"87d4985c-d8ff-44e8-8613-\
842bf4648528"]
}, Open  ]]
},
WindowSize->{1090, 778},
WindowMargins->{{11, Automatic}, {Automatic, 20}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.3999992609024048`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 461, 14, 125, "Input",ExpressionUUID->"5abf666e-d282-48bc-9021-3b59d333e7fa"],
Cell[1021, 36, 3342, 100, 664, "Input",ExpressionUUID->"391efed4-2b4b-4e4c-8b16-2eb651d6e95c"],
Cell[CellGroupData[{
Cell[4388, 140, 2130, 56, 289, "Input",ExpressionUUID->"73be3ccf-69bb-4fa1-af23-283c06164200"],
Cell[6521, 198, 478, 11, 32, "Print",ExpressionUUID->"87d4985c-d8ff-44e8-8613-842bf4648528"]
}, Open  ]]
}
]
*)

