(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13137,        328]
NotebookOptionsPosition[     12368,        307]
NotebookOutlinePosition[     12850,        325]
CellTagsIndexPosition[     12807,        322]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7208615645625*^9, 
  3.7208615731875*^9}},ExpressionUUID->"a33bba55-d9af-44ac-8dc1-c6fe57beddf2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"57", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"1", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sk", "=", 
   RowBox[{"Pi", "*", 
    FractionBox[
     SuperscriptBox["d", "2"], "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "=", 
   FractionBox["i", "Sk"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ee", "=", 
   FractionBox["J", "\[Gamma]"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qv", "=", 
   RowBox[{"Ee", "*", "J"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pout", "=", 
   RowBox[{
    RowBox[{"\[Alpha]", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"T", "[", "x", "]"}], "-", "To"}], ")"}]}], "+", 
    RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"T", "[", "x", "]"}], "+", "273"}], ")"}], "4"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"To", "+", "273"}], ")"}], "4"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvOut", "=", 
   RowBox[{"Pout", "*", 
    FractionBox[
     RowBox[{"Pi", "*", "d"}], "Sk"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvCelk", "=", 
   RowBox[{
    RowBox[{"-", "Qv"}], "+", "Pout"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delka", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{"\[Lambda]", "*", 
     RowBox[{
      RowBox[{"T", "''"}], "[", "x", "]"}]}], "\[Equal]", "QvCelk"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eqn", ",", 
        RowBox[{
         RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT"}]}], "}"}], 
      ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"endValue", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"T", "[", "delka", "]"}], "/.", 
    RowBox[{"sol", "[", "derT", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"dder", "=", 
  RowBox[{"der", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"endValue", "[", "der", "]"}], "==", "To"}], ",", 
     RowBox[{"{", 
      RowBox[{"der", ",", "10000"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"sol", "[", "dder", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "pom"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
  3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
  3.7208620900625*^9}, {3.720862139265625*^9, 
  3.720862742015625*^9}},ExpressionUUID->"a52db167-47fe-4403-a8fc-\
488681e11b6d"],

Cell[BoxData["797.5754620991094`"], "Output",
 CellChangeTimes->{
  3.8479382574124513`*^9},ExpressionUUID->"d26b958a-c696-4759-a898-\
e596a30e8303"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwl2Hk4VN//APAp0vKJ7EtI9kRURiXpfQgVaSGFREhzk1CpCKUiZS+ULC0U
ElGEhIREEY11zJ0xg2QZKZGd3/k+v7/u83ruPHPPfZ/zXmYUXbys3BZTKBTR
RRTK/64T6oeUPxdb7xS5WDNOoVBRYaqU9F6pzeDrueiy7TYqEne4k64oZQwG
nGvSGd5UVLWtclhQygomvku91+BS0eoMRxF+KReQTSm8Wv1RD5mxtZQXJM/D
qwez8weub0XklFj2rOQNUGhJnC+f2o4yQkO9ZyTvwTeNoOr5nwhtSbnM/4GR
Cg6iD9k3xPeg8gShJ+mLsiHpi8vbpQH70dPuHUN1gW9gWiBV7vROK7TtieVj
JYciUCvryjtna4O6f63y3//zPaxXOPXHQ9oWeb9p2/rrdAVYqvpGjw3ao1d+
nQmFLZXgSGfmng89ji4tL4rsl/gEJ+T3Td+iO6F+rUXRX0M/w1MX4MsWc0a9
0ioq0k11sPyMtEyslAtSEJlV6FtZD+++63qS/K6IP8VonduVb5Bqd9O9eNQV
vZvU6VZzagJrIY8g0/KT6BPvYuGFh98h6TZzjrzlhv6ckty56BsdjtO6NwRt
PYVcTNOiq4abQV2gplThyymUOXyKxlZthaDpTZvdbGioM2f4+Zn1rUCJVjMw
O0pDKz19eie1W0GefldVzY6Gzv267iy2rRVek/WPuh1oaPtI8rE95q2wyqJD
af9JGvr6m37gjWcrKMY4nhs5T0O//u7cdquoFcS0x9cdi6Yh3WnJ5dp72+CF
kM+y9moaiogvfCG3vw32F0km3quhob6NR8z/s24Dz83WzH21NPSQFh/e79AG
A0qJHmVfaWihRUwozbsNjP1dv0TR8fNyhcWkE9rgojblwmgXDbm6rZBf/LMN
THoM/cqmaKiUklX2e6gNEn1s5/fP0JBk8l7Hrt/48x+FdbtmaaiOfvtx6XQb
POU/9nJmgYZ00FKly0LtoOlh164iQKCZ1fzqPL12SLSUkt8mSqDYprmNbcHt
8HjS8YSLBoH429xbcu60Q5l6z8Gq9QS6xGy/HBLVDiEfNeeUtAhk3/e6nJrQ
DqzEFXfY2gRSmnXbF/uyHaoyFnmaUQn0Rv0b7SC9HUz+DHowdhKIfvXRoy8K
HVDvZg0rrQlkEvyfcapKB2i6xmWaHCZQ4R3fH34aHXDoS3KDvw2BEuOstDR0
O8Bdh9+i7yiBXLIESkLNOqD5o45YtgOBRls9W03OdsDOtYKMaTcCiW6AlR9K
OqA72cfg+WUCSfQ239j1oQMED3cPpPoSSDqJmPpc1QF8ympXH/sRaM3ye31N
9R2wZ/dG23h/Aq3/0VvRze6ALY4H6ReuEWhXSthFAT4GWOk2sGduEchHsI1t
acGAJHNFu23xBLpc7W5DP8CAHm2vStH7BLriv/D1yGEG6C6KF+FhBw2se+d0
nAGq6YRzUgKBIj75x57zYgDf6U2feUkEeh6ouCc+lgFDRw+/tE8lUNuwx2uS
yQDKzW1tLq8IRAlaHVbJYcDp51V2GrkE0hStdcn8wYCBY2l3f2EHbVEW9xlh
gPuHE2suviaQxjXGpf/4OqFhtOXl+QICBQib7di+vhPKrHLv65QQKD31r/ha
nU6g2oU5cbG/U58OL6F2gia9hLz7nkBqdrOPvht2guRBubFfpQRqfPpm0elD
naDb133/4Qe8v7oKnx/4doJB8J3svGoC7ftU/zgwsBPksz6WWH7C8Th6xdf1
RiesW3EwcAC73r9VQyeiE2IzvBTkPxPoYnV4RM3jTjiY9L7dp45AtTaTh8Zr
OsF7c4x0XwOBvHy/k1YSTHCd9WE2tuL9KE2//UOGCTSL4maDNgL1LfhTfdcw
IWWElZWO7RCqFpGizoTt1k3jvu0EMr/vb9Cvz4QlJlbzqxj4fQpUEwMdmXDs
XBNjKUmg7olpU2FXJlip7ahwxk4xaPqTSmNCT3xYSAm2eNWVvbXeTLj2vjGb
YBFoMb1xUvQmE6ZLZs4WsQnEHvE7mpnBBLE1XSVruPh86h7gM8hmgsmsb/Qp
bJvLKrkNeUwY6Bs3zsGun/8m8PcdE47/TTDb2k2gEkGVQsN6JoQ4B1cY9uB8
OjTl3NTEBEJua0QA9qb4b4KurUw4v6RhSwl2ppyf2202EzzOpa7b3Eug+5rf
xJt/M2FYeuyq+A8CWXmlVbiN4/XmVBiZYwvm+3pMTjFBJ9K75yp28Hblank+
Eia3X6nqxT6/1/cCIUFCdobev9Q+AmlHWirMyJCwZlgurxF7oEnpa+QaEkbi
f+6ZwT5h26CUr07CWTl1qQM/CWRJU6LP6ZMwt+uA2gD2WolPQX47SRD+kq22
sp9AY5U0nXFjEqbEtES0sZPX5ETwLEjYNRP9zBPbu/6AAXGQBJ9kH8tIbJMr
owM9h0lYvdyfk4XNa926m3kcr89iuLobu+Jm5/gRFxK4KnaSc9hxmwKf0U+R
INfUd0hygEA7IisXffEiITCVFmqKLWzglmfqQ4Jbvf31Y9i9/UudPvqS0Nbg
5eaNHWFiWVp8nQRFh4Wh+9gnRkfcqbdI2DLkF5WJTX1yTyYvjIR9RyRl32Ev
269XqxlNwpFHLXdrscmZ9ksZsSRsry4YbcPOe3FFVTmBhNraQsNe7OCj8i2P
kkn4lN15/je27ZKKG6ufksDxXntvBlsr32XT/eckvJe4nbRkEOe38xKOSBYJ
/Uki0ULYLUKZUZGvSPjBV+YhiZ1Zam64PJ8Epf1hVHnsAPfhoeAiEhau+PUp
YR+UjkmklJJQFxZ2Qx1bpWbz3oAKEioCy5ZpYk9eaJ2YqMb7c1jUbwN2vaJv
+oU6EjoE7zRrYz9pXG0z0kCCyktFaR1sn8AyvjN0Ev5okmb/u79H88SbvjYS
NGOKnbSw5RiLnV2YJLxqL3TRwP596/kqdhcJuxe3H1DFrqbuKbfrJSF3lYz6
WuyE7kGP1n4S4hYC+mWwPWIiZQ8NkxDzfXGcKDbaufFL/R8SNoRkaazAFufR
fff8I+GnjM8LCnb/w4vq1dMkrIt2EvuH41e6W7oNFkiw6PWgDWLHjJcEv+dj
wUPp5Ocs7JNpx3W3LmOBpeZwQyP2fwupMdoiLAjqHyPzsNnZppAlwQLluy+r
HmO/se8fVl3NAh/x4LhIbPvCDRbyyix4n5445oatfbJpKkGdBTb5HTcPYi8W
vZAprsWCvvhtc/rYWWeLl6zUY8Gd9uOvlmNflT1WEKrPggpd5b4RfF6t6uZc
+HayQP/EimWt2NMquyqmzVgQqbxzRTK2OdlwZcCWBQnKBsvksU3d7oTXHGdB
SVHigwmcX+iXSXKaCwt2KIx1NWFvpZSWHfdgQebxuKRr2CoqWRT6NRZc3BNW
3oDzdW2Om0huMAsC1hVLPMKW3aKoFHGHBburu1TPYovuSdhlFsuCz4py55Zi
L5y5dasknQVrRffma+H6MD1m9ODBSxbQPE3oo7je/Aucy/DJY8GR0/pZRdi8
aJ867RIWFK0XDjHE7sx3WZnWgJ/v4t2nj+tVwczOe+FjLKi+NXF0nEOg3ODp
VGKKBT8zwwQysLMEC/NN51nQLSvleRT7qcKG1oWlbHBgyRIFXQSK2iUr7SPL
Bl/1lqVOuN4S4RMpDsZseLlvevwSk0Cu4vmv9HezYSFWgSqO7Zji+UFyHxtO
VBtq5nXi+pv7g9NkwwZG5UmTXlz/jZublU1Ps2GJq4OSYQeB5GXzXmyIYUMS
Gop43YLXYxMbWRTHBj9bs2PG2FtiLp0zesiGtMbWlfRmAu1fYqhvk8qG7vK7
Mr/ouN+O1NUGFLBBih7AkP6O+0lVz8+vHWzIkpT5uw33L8/5mq82LDYcelA4
VlSP56ttWbldXDYMTYcy9LDFX3lf/jvIBtu9Nfu0v+L9TpgTkJ1jQ71YHkME
98NMDyk1d8UuGMrcGJmG+ys1Y3r5mGoXhBsvqxTG/shlDQeu7wL3jWKdAVU4
/keevb2r2wXl3ZX5hyrxeTfaZPrOtAvY924L/sL92lPC4uQy9y6w8Xpm/wf3
e2r51dT0N13weKTFXikP51fzlf67RV1QahT+2AHPE8kDl7QDS7ug+d7b+Hg8
f/BJeJVY13TBln9u9/ly8Px2xolO6eyC2NXUgcYXBCpeufZ6DoUDpta+LRpp
OP4llNdL13FA/r7Ox+44nD+f5q0D13NAQHk39W8srqdNs/9GtTgg8bzJdjF2
6Y/JHexNHPA30i+Uu4vPs8if2gIDDlzsdaw0isTzHY3LcT7AAePmIQXLEJzv
EpXCpZc4YH41dITwwf2zVU1PzY8D4ysLCg9fwPNAfLhdjD8Hnte6G8B5Aq2T
sEk9GcSB9suXAoW9cfzE+3UFwzhwNoS/N+0M/n4xoaOOKRwwCx/YHuVCIGtR
+xRKNQf+Zu5ade4AgSRXjWqYinDBInCfpZcqrm8Zg0UhYlyIO0bcUFIh0AXU
Y1ojwYV074lHLUoEajrX4rx7NRdeDHlG6a0lUHhL4cO9ylygMCrMBlfjep/o
v3y/HhfOTrLkFIQJNKiyZOCIHRdcZNwcC/E8X75dOpN4ygXf/NxNSXU0RDGS
/8lI40JPfoF232caMt6tpGaRzoUy/iquDv498dla69mGl1x4LT1z+kMlDTV5
oCejBVy4Gd66uPE9DfU8IhICarnQQZM6kpdDQ8v43t2OGeHCr6H+6/4xNHTo
q93pYsNuWJg1+qlrRUMCUXejUxu7Qceujre26RT6GntpVY5jD6TJXD+sCaeQ
//wles9UDwioT947HOWGLJPOTheE9UL8g9DGubaTaEXKNbc36j9ALXYw22DW
Fc8ToXrmJT+Acar/3Hp5V9Sx29BpsXkfBL2v8+jY6IJeKwvV9/3og/vPZlbX
yDmjnE2tKW6Xf4LAaWGx+GUnUOyzojfCEv1wtrKkQf3ecXTHfrcimdsPSknl
+r3j9uipccOYERqAiSUJqyadbdGzaM//WsgBkAU3v3BPG1QnJBBK8RoEvbWU
2ZZQKzTfZO5gOT8IJ0I+79OTOYDWTGb51DwcgrjsQH93qz3oxKFFo4z1PFgu
pXGq+q0RqhA0LXPewIOT/XkOyQ+MkMKX27cHdLAv/qv29DNCbGNhhSkqD5S5
bwYXGxohB6rCPmngQUHtu7D+KoSOShmmH7Hmgblt2Barp4D2s3ztm/158Gg5
kzP/1QC9eliqeuwqDwISs/UsogyQ4BHKn+4gHohfvHI24qABqv8WGjoawgOP
qemQ4ZbtaG/F/QKRGB48L1tjv56lj0zSCoQOPuPBBtUz4VFDW9Ezp0lGezoP
+C+sEdLI2Yr45HY8d3rBg38RkReKPbeiyrgqA69XPPg4EtX39s8WhG7Riahi
Hsgwsz00J/TQE2NJquR7HqhM1POfLdZDC/N2CyllPPh98va1ND89VH6ZG59T
yQNLXoXcyAwVyVNVnfU+8eB7lx7wl1FRwG9Cq+wzfv8OPROhq1REZmdPmHzh
wZbKUk1BoCKD078r6+t5YBj6//+H/B85AG5t
       "]]},
     Annotation[#, "Charting`Private`Tag$2494#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.9}, {0., 199.3182488114918}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8479382575374227`*^9},ExpressionUUID->"f4c102f0-b70e-4d2d-b431-\
382e5c047711"]
}, Open  ]]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.9500001668930054`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 575, 16, 167, "Input",ExpressionUUID->"a33bba55-d9af-44ac-8dc1-c6fe57beddf2"],
Cell[CellGroupData[{
Cell[1145, 40, 3971, 122, 1085, "Input",ExpressionUUID->"a52db167-47fe-4403-a8fc-488681e11b6d"],
Cell[5119, 164, 149, 3, 87, "Output",ExpressionUUID->"d26b958a-c696-4759-a898-e596a30e8303"],
Cell[5271, 169, 7081, 135, 485, "Output",ExpressionUUID->"f4c102f0-b70e-4d2d-b431-382e5c047711"]
}, Open  ]]
}
]
*)

