(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10319,        279]
NotebookOptionsPosition[      9075,        252]
NotebookOutlinePosition[      9536,        269]
CellTagsIndexPosition[      9493,        266]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"NewtonStep", "[", 
   RowBox[{"f_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]]}]}]], "Input",ExpressionUUID-\
>"18417611-74de-4db9-a098-0d008362c6d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NewtonIteration", "[", 
    RowBox[{"f_", ",", "init_", ",", "opt___"}], "]"}], ":=", "\n", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NewtonStep", "[", 
       RowBox[{"f", ",", "#"}], "]"}], "&"}], ",", "init", ",", "opt"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.482723645625*^9, 
  3.482723650671875*^9}},ExpressionUUID->"f83b8741-9185-4d0a-9ccb-\
d91b7d91ec38"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NewtonPlot", "[", 
    RowBox[{"f_", ",", "x0_", ",", "n_", ",", "opt___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "data", "}"}], ",", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"NestList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "-", 
           FractionBox[
            RowBox[{"f", "[", "#1", "]"}], 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "#1", "]"}]]}], "&"}], ",", "x0",
          ",", "n"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"ListPlot", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "data", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "data", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"f", "[", 
                  RowBox[{
                  "data", "\[LeftDoubleBracket]", "i", 
                   "\[RightDoubleBracket]"}], "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", "data", "]"}]}], "}"}]}], "]"}], ",", 
           "1"}], "]"}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "0", ",", "1"}], "]"}], "}"}]}], ",", "opt", 
         ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<f[x]\>\""}], "}"}]}], ",", 
         RowBox[{"PlotRange", "->", "All"}]}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.48272349740625*^9, {3.48272369140625*^9, 3.482723708109375*^9}, {
   3.4827237899375*^9, 3.4827237980625*^9}, 
   3.7657722142173977`*^9},ExpressionUUID->"5f462afc-8ee5-4882-a12b-\
3edc6f6c0a7f"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"Log", "[", "x", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "1."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "5"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.482723564515625*^9, 3.482723584421875*^9}, 
   3.482723911515625*^9},ExpressionUUID->"fb9369e6-785b-40c1-8da0-\
edf90db9500a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "11"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
        RowBox[{"Hue", "[", "0", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<f[x]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.482723603703125*^9, 3.482723626328125*^9}, 
   3.4827237180625*^9},ExpressionUUID->"14f1ecb2-32e5-474a-99dc-a7d213fe7800"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"theroot", "=", 
  RowBox[{"NewtonIteration", "[", 
   RowBox[{"f", ",", "x0", ",", "10"}], "]"}]}]], "Input",ExpressionUUID->\
"b85f41f3-d823-4437-8c77-d9a27071070c"],

Cell[BoxData["0.6529186404192047`"], "Output",
 CellChangeTimes->{
  3.8109628590213985`*^9},ExpressionUUID->"1f0d9bab-a70b-48d2-8691-\
a97a0be7d93a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", 
   RowBox[{"NewtonPlot", "[", 
    RowBox[{"f", ",", "3.", ",", "4"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.482723509125*^9, 3.482723522*^9}, 3.4827235946875*^9, {
   3.7657721812877116`*^9, 
   3.7657721883173065`*^9}},ExpressionUUID->"a7fcba09-e497-4460-8f9d-\
f2cbdda5fc79"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {Hue[0, 1, 1], Thickness[0.006], Opacity[1.], LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAAe0PZbEgGwT8AAAAAAAAAwBJkr6il
OMI/u7EKTOfd/r9YWaGv8PHEP2tUKbCaiPy/79tUCqIaxT+GvHgd92f8v4Ze
CGVTQ8U/7tH/y4tH/L+zY28atpTFP6JCU2ZaB/y/Dm49hXs3xj9iGwX1dIn7
v8WC2VoGfcc/MPLaQfGW+r8yrBEGHAjKP4gkSmNa0vi/yS7FYM0wyj8Gbwi2
V7f4v2CxeLt+Wco/QizhbHic+L+Ntt9w4arKP5sNPi0iZ/i/6MCt26ZNyz8+
3NR5Cv73v57VSbExk8w/eHrSo9Ax978L/4FcRx7PP1RC95yervW/mGlXXixG
zz+TsqU+upf1vyTULGARbs8/wcPizeyA9b8+qddj273PP7OCRa6VU/W/uamW
tbcu0D8T3Mx87/n0v+1T7LxLztA/gOu4c45K9L9VqJfLcw3SP8WHZ9n8+fK/
JVHu6MOL1D+kq9rl0Ifwv3fOOT+Y9Nk/8bUlEOyd578XtBHeAQHfP9nzioWj
Xd+/tuJDzM884j98X5CydmTOv8JqnRtZ7OQ/gAKW2zGsZT/1Jj0PrW3nPzDe
aB7os8w/AvmrEBsl6j9xh3zGDMrdPzb/YLZTruw/KaDdU70z5j/MhDTOxirv
P4YV/jgOg+0/H5Dr+anu8D+J9ZYzNNPyP+v3397VMPI/MP+aBxW89j+k6rvK
Do7zP1iXM3AgHPs/Dh2n7+Tk9D8bvBjEKY7/P4xptWagJPY/3lVDgf7rAUD2
QKvkaH/3P/+uDBI1VARAdDLEtBbD+D8VV6SksKcGQN+uxIvRIfo/c45BSstD
CUD7atSbKXr7PzpTnp926wtAK0EH/ma7/D/aEsyWMHsOQEeiIWexF/4/BETf
jBitEEB3HV8i4Vz/P9LXXrywDxJALOxVC9dNAECyZ7QrOHYTQBMP8AjE+gBA
VyT0kIMHFUAEv5uvI5wBQCKOpp+0iRZAazS72QlLAkDAwVUMJTkYQKtJYqC+
9gJAcx18sNjtGUD16xoQ5pYDQHW5NXv8kBtAtVNHA5REBEBCyQr7f2QdQH9I
hZ+05gRAkwJr+SslH0Ah3UrYo4UFQJaw8qxGdCBAOjeElBkyBkA45Kz4qm8h
QFwez/kB0wZAdq1Pn1dgIkD1yo3icIEHQMqthw3zayNAmARedFIkCEAiajfP
JmwkQBPetaICxAhAgllfIEZtJUAC+T2/AR0JQAAAAAAAACZAe8XCbQ==
        "]]},
      Annotation[#, "Charting`Private`Tag$2190#1"]& ]}, {}, {}}, {{}, {{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], LineBox[{{3., 0.}, {3., 10.09861228866811}, {1.4054822702102985`, 
       0.}, {1.4054822702102985`, 2.31576090858215}, {0.7480558634560526, 
       0.}, {0.7480558634560526, 0.2693099548194032}, {0.6529910969509941, 
       0.}, {0.6529910969509941, 0.00020558882662724542`}, {
       0.6529186400996597, 0.}, {
       0.6529186400996597, -9.066838946303335*^-10}}]}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"f[x]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.810962859090389*^9},ExpressionUUID->"910e4a09-e05a-4e41-b0fe-\
de9a3340c4d3"]
}, Open  ]]
},
WindowSize->{767, 599},
WindowMargins->{{39, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.3000000715255737`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 340, 10, 66, "Input",ExpressionUUID->"18417611-74de-4db9-a098-0d008362c6d1"],
Cell[888, 32, 458, 13, 63, "Input",ExpressionUUID->"f83b8741-9185-4d0a-9ccb-d91b7d91ec38"],
Cell[1349, 47, 2330, 62, 234, "Input",ExpressionUUID->"5f462afc-8ee5-4882-a12b-3edc6f6c0a7f"],
Cell[3682, 111, 535, 15, 113, "Input",ExpressionUUID->"fb9369e6-785b-40c1-8da0-edf90db9500a"],
Cell[4220, 128, 805, 22, 63, "Input",ExpressionUUID->"14f1ecb2-32e5-474a-99dc-a7d213fe7800"],
Cell[CellGroupData[{
Cell[5050, 154, 190, 4, 37, "Input",ExpressionUUID->"b85f41f3-d823-4437-8c77-d9a27071070c"],
Cell[5243, 160, 150, 3, 43, "Output",ExpressionUUID->"1f0d9bab-a70b-48d2-8691-a97a0be7d93a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5430, 168, 394, 9, 37, "Input",ExpressionUUID->"a7fcba09-e497-4460-8f9d-f2cbdda5fc79"],
Cell[5827, 179, 3232, 70, 327, "Output",ExpressionUUID->"910e4a09-e05a-4e41-b0fe-de9a3340c4d3"]
}, Open  ]]
}
]
*)

