(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      5440,        179]
NotebookOptionsPosition[      5009,        161]
NotebookOutlinePosition[      5389,        177]
CellTagsIndexPosition[      5346,        174]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"57.", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To", "=", 
   RowBox[{"20", "+", "273"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "60"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"1", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delka", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Spovrch", "=", 
   RowBox[{"Pi", "*", "d", "*", "delka"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sprurez", "=", 
   FractionBox[
    RowBox[{"Pi", "*", 
     SuperscriptBox["d", "2"]}], "4"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ro", "=", 
   FractionBox["delka", 
    RowBox[{"\[Gamma]", "*", "Sprurez"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]R", "=", "0.0004"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "T_", "]"}], ":=", 
   RowBox[{"Ro", "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[Alpha]R", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pk", "[", "T_", "]"}], ":=", 
   RowBox[{"Spovrch", "*", "\[Alpha]", "*", 
    RowBox[{"(", 
     RowBox[{"T", "-", "To"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", "T_", "]"}], ":=", 
   RowBox[{"Spovrch", "*", "\[Epsilon]", "*", "\[Sigma]", "*", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["T", "4"], "-", 
      SuperscriptBox["To", "4"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pel", "[", "T_", "]"}], ":=", 
   RowBox[{
    RowBox[{"R", "[", "T", "]"}], "*", 
    SuperscriptBox["proud", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TzKonvekce", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Pel", "[", "T", "]"}], "-", 
      RowBox[{"Pr", "[", "T", "]"}]}], 
     RowBox[{"\[Alpha]", "*", "Sprurez"}]], "+", "To"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TzOdporu", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "\[Alpha]R"], "*", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Pk", "[", "T", "]"}], "+", 
        RowBox[{"Pr", "[", "T", "]"}]}], 
       RowBox[{"Ro", "*", 
        SuperscriptBox["proud", "2"]}]], "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TzeSalani", "[", "T_", "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Pel", "[", "T", "]"}], "-", 
        RowBox[{"Pk", "[", "T", "]"}]}], 
       RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", "Spovrch"}]], "+", 
      SuperscriptBox["To", "4"]}], ")"}], 
    FractionBox["1", "4"]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.748747339578125*^9, 3.748747800109375*^9}, {
  3.748747864390625*^9, 3.748747902328125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{"TzKonvekce", ",", "400.", ",", "5"}], "]"}], "-", 
  "273"}]], "Input",
 CellChangeTimes->{{3.74874791953125*^9, 3.748747920515625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{"TzOdporu", ",", "400.", ",", "5"}], "]"}], "-", "273"}]], "Input",
 CellChangeTimes->{{3.748747932296875*^9, 3.748747932765625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{"TzeSalani", ",", "400.", ",", "5"}], "]"}], "-", "273"}]], "Input",
 CellChangeTimes->{{3.748747807625*^9, 3.748747834984375*^9}, {
  3.748747875484375*^9, 3.748747896734375*^9}}]
},
WindowSize->{1072, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 330, 9, 103, "Input"],
Cell[890, 31, 3467, 108, 780, "Input"],
Cell[4360, 141, 200, 5, 46, "Input"],
Cell[4563, 148, 196, 4, 46, "Input"],
Cell[4762, 154, 243, 5, 46, "Input"]
}
]
*)

(* End of internal cache information *)
