(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12030,        349]
NotebookOptionsPosition[     11514,        329]
NotebookOutlinePosition[     11915,        346]
CellTagsIndexPosition[     11872,        343]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aijMax", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrix", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "aijMax"}], ",", "aijMax"}], "}"}], "]"}], "&"}], "[", 
      "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "mf"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
   3.676092820640625*^9, 3.676092822828125*^9}, 3.6845844423125*^9, {
   3.68458740925*^9, 3.68458747246875*^9}, {3.684587519296875*^9, 
   3.68458757484375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"linFunction", "[", 
    RowBox[{"vect_List", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "#", "]"}], "==", "rnm"}], "&"}], ")"}]}], 
    "]"}], ":=", 
   RowBox[{"matrix", ".", "vect"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "an", " ", "example", " ", "of", " ", "a", " ", "linear", " ", "vector", 
    " ", "function"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"vect1", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vect2", "=", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"linFunction", "[", "vect1", "]"}], "+", 
      RowBox[{"linFunction", "[", "vect2", "]"}]}], "==", 
     RowBox[{"linFunction", "[", 
      RowBox[{"vect1", "+", "vect2"}], "]"}]}], "]"}], "//", "Simplify"}], 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "first", " ", "condition", " ", "of", " ", "linearity"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"linFunction", "[", 
      RowBox[{"\[Lambda]", "*", "vect1"}], "]"}], "\[Equal]", 
     RowBox[{"\[Lambda]", "*", 
      RowBox[{"linFunction", "[", "vect1", "]"}]}]}], "]"}], "//", 
   "Simplify"}], 
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "second", " ", "condition", " ", "of", " ", "linearity"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68458738978125*^9, 3.6845873994375*^9}, {
  3.684587588078125*^9, 3.684587811375*^9}, {3.68458805509375*^9, 
  3.684588068921875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"price", "[", "distance_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{"0.1", "*", "distance"}], "+", 
    RowBox[{"0.01", 
     SuperscriptBox["distance", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalDistance", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"price", "[", "distance", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"distance", ",", "0", ",", "totalDistance"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Blue"}], " ", "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<distance [km]\>\"", ",", "\"\<price [crown]\>\""}], "}"}]}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nTickets", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"price1Ticket", "=", 
   RowBox[{"price", "[", "totalDistance", "]"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "we", " ", "buy", " ", "ticket", " ", "for", " ", "all", " ", "the", " ", 
    "journey"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"priceNTickets", "=", 
   RowBox[{"nTickets", "*", 
    RowBox[{"price", "[", 
     FractionBox["totalDistance", "nTickets"], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<price1Ticket= \>\"", ",", "price1Ticket", ",", 
    "\"\<, priceNTickets= \>\"", ",", "priceNTickets"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "buy", " ", "nTickets", " ", "for", " ", "nTickets", " ", 
     "smaller", " ", "yourneys"}], ",", " ", 
    RowBox[{"together", " ", "the", " ", "same", " ", "distance"}]}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68458819453125*^9, 3.684588485453125*^9}, {
   3.6845885183125*^9, 3.68458860096875*^9}, 3.684588647890625*^9, 
   3.684588691796875*^9, {3.684590787265625*^9, 3.68459080115625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"price", "[", "distance_", "]"}], ":=", 
   RowBox[{".1", "+", 
    RowBox[{"0.1", "*", 
     SqrtBox["distance"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalDistance", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"price", "[", "distance", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"distance", ",", "0", ",", "totalDistance"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Blue"}], " ", "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<distance [km]\>\"", ",", "\"\<price [crown]\>\""}], "}"}]}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nTickets", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"price1Ticket", "=", 
   RowBox[{"price", "[", "totalDistance", "]"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "we", " ", "buy", " ", "ticket", " ", "for", " ", "all", " ", "the", " ", 
    "journey"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"priceNTickets", "=", 
   RowBox[{"nTickets", "*", 
    RowBox[{"price", "[", 
     FractionBox["totalDistance", "nTickets"], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<price1Ticket= \>\"", ",", "price1Ticket", ",", 
    "\"\<, priceNTickets= \>\"", ",", "priceNTickets"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "buy", " ", "nTickets", " ", "for", " ", "nTickets", " ", 
     "smaller", " ", "yourneys"}], ",", " ", 
    RowBox[{"together", " ", "the", " ", "same", " ", "distance"}]}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68458819453125*^9, 3.684588485453125*^9}, {
  3.6845885183125*^9, 3.68458867*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"price", "[", "distance_", "]"}], ":=", 
   RowBox[{"0.2", "*", "distance"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totalDistance", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"price", "[", "distance", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"distance", ",", "0", ",", "totalDistance"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Blue"}], " ", "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<distance [km]\>\"", ",", "\"\<price [crown]\>\""}], "}"}]}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nTickets", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"price1Ticket", "=", 
   RowBox[{"price", "[", "totalDistance", "]"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "we", " ", "buy", " ", "ticket", " ", "for", " ", "all", " ", "the", " ", 
    "journey"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"priceNTickets", "=", 
   RowBox[{"nTickets", "*", 
    RowBox[{"price", "[", 
     FractionBox["totalDistance", "nTickets"], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<price1Ticket= \>\"", ",", "price1Ticket", ",", 
    "\"\<, priceNTickets= \>\"", ",", "priceNTickets"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "buy", " ", "nTickets", " ", "for", " ", "nTickets", " ", 
     "smaller", " ", "yourneys"}], ",", " ", 
    RowBox[{"together", " ", "the", " ", "same", " ", "distance"}]}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68458819453125*^9, 3.684588485453125*^9}, {
  3.6845885183125*^9, 3.68458867*^9}, {3.684588707609375*^9, 
  3.684588711109375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "another", " ", "important", " ", "usage", " ", "of", " ", "linearity", 
    " ", "phenomenon"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"rulesForBasicObjects", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"nzred", "*", "blap"}], "\[Rule]", "knaf"}], ",", 
      RowBox[{
       RowBox[{"knaf", "*", "nzred"}], "\[Rule]", "blap"}], ",", 
      RowBox[{
       RowBox[{"knaf", "*", "knaf"}], "\[Rule]", "knaf"}], ",", 
      RowBox[{
       RowBox[{"blap", "*", "blap"}], "\[Rule]", "nzred"}], ",", 
      RowBox[{
       RowBox[{"nzred", "*", "nzred"}], "\[Rule]", 
       RowBox[{"0.5", "nzred"}]}], ",", 
      RowBox[{
       RowBox[{"blap", "*", "knaf"}], "\[Rule]", 
       RowBox[{
        RowBox[{"0.5", "blap"}], "+", 
        RowBox[{"0.5", "nzred"}]}]}]}], "}"}]}], ";", 
   RowBox[{"(*", 
    RowBox[{
    "defining", " ", "of", " ", "multiplication", " ", "for", " ", "objects", 
     " ", 
     RowBox[{"{", 
      RowBox[{"blap", ",", " ", "nzred", ",", " ", "knaf"}], "}"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "knaf"}], "+", 
         RowBox[{"3", "blap"}], "-", 
         RowBox[{"1", "nzred"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"0.5", "knaf"}], "+", "blap"}], ")"}]}], "]"}], "//.", 
     "rulesForBasicObjects"}], "//", "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.68458918415625*^9, 3.68458948696875*^9}, {
  3.684589529203125*^9, 3.684589531203125*^9}, {3.68459047309375*^9, 
  3.684590505171875*^9}}]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1368, 39, 271, "Input"],
Cell[1916, 61, 1722, 50, 271, "Input"],
Cell[3641, 113, 2155, 55, 360, "Input"],
Cell[5799, 170, 2004, 53, 365, "Input"],
Cell[7806, 225, 2012, 52, 357, "Input"],
Cell[9821, 279, 1689, 48, 344, "Input"]
}
]
*)

(* End of internal cache information *)
