(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21490,        581]
NotebookOptionsPosition[     20645,        553]
NotebookOutlinePosition[     21046,        570]
CellTagsIndexPosition[     21003,        567]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMat2", "=", 
   RowBox[{"Det", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<determinant= \>\"", ",", "detMat2"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"invEps", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"Inverse", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"invEps", "[", "\[Epsilon]", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 3.676092822828125*^9}, {3.6851971430625*^9, 
  3.685197182328125*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "We", " ", "see", " ", "the", " ", "dependance", " ", "of", " ", "the", 
    " ", "inverse", " ", "matrix", " ", "as", " ", "an", " ", "expression", 
    " ", "containing", " ", 
    RowBox[{"\[Epsilon]", ".", " ", "Generally"}]}], ",", " ", 
   RowBox[{
   "all", " ", "the", " ", "terms", " ", "of", " ", "the", " ", "matrix", " ",
     "is", " ", "known", " ", "only", " ", "approximately"}], ",", " ", "so", 
   ",", " ", 
   RowBox[{
   "the", " ", "determinant", " ", "and", " ", "the", " ", "inverse", " ", 
    "matrix", " ", "can", " ", "be", " ", "assumed", " ", "as", " ", "a", " ",
     "function", " ", "of", " ", 
    SuperscriptBox["n", "2"], " ", "terms", " ", 
    SubscriptBox["\[Epsilon]", 
     RowBox[{"i", ",", "j"}]]}], ",", " ", "i", ",", "j", ",", " ", "1", ",", 
   "2", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "..."}], "n"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MatrixRank", "[", "mat2", "]"}], ".", "\[IndentingNewLine]", 
       SuperscriptBox["n", "2"]}], " ", "variables"}], " ", "=", 
     RowBox[{">", " ", "possible"}]}]}], ",", " ", 
   RowBox[{
   "but", " ", "not", " ", "easy", " ", "way", " ", "how", " ", "to", " ", 
    "study", " ", "the", " ", "changes", " ", "of", " ", "the", " ", 
    "inverse", " ", "matris", " ", "and", " ", "solution", " ", "of", " ", 
    "the", " ", "seto", " ", "of", " ", "equations"}]}], " ", 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.685197212703125*^9, 3.68519741396875*^9}, {
  3.685197474984375*^9, 3.685197519828125*^9}, {3.6851975590625*^9, 
  3.6851976230625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"norm1", "[", "vect_", "]"}], ":=", 
   SqrtBox[
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         SuperscriptBox["#", "2"], "]"}], "&"}], "/@", "vect"}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm2", "[", "vect_", "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "vect", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm3", "[", "vect_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"Abs", "/@", "vect"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm2D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}], "]"}], 
         "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm2D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.685197385390625*^9, 3.685197390046875*^9}, {
   3.6851976698125*^9, 3.685197746046875*^9}, {3.6851977818125*^9, 
   3.68519782909375*^9}, {3.685197876890625*^9, 3.685197915140625*^9}, {
   3.6851979521875*^9, 3.68519802796875*^9}, {3.6851980934375*^9, 
   3.685198098390625*^9}, {3.685198132078125*^9, 3.685198283140625*^9}, {
   3.685198362140625*^9, 3.68519836546875*^9}, {3.685198423984375*^9, 
   3.68519843240625*^9}, 3.685199038140625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm3D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "\[Equal]", "1"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], 
          "]"}], "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm3D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68519851934375*^9, 3.685198525078125*^9}, {
  3.685198564015625*^9, 3.685198610578125*^9}, {3.6851986656875*^9, 
  3.685198666375*^9}, {3.685198705796875*^9, 3.685198710421875*^9}, {
  3.685198750140625*^9, 3.68519875815625*^9}, {3.68519880321875*^9, 
  3.6851988208125*^9}, {3.685198851578125*^9, 3.685198877265625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm1", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"N", "@", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mat", "/.", 
          RowBox[{
           RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
           SuperscriptBox[
            RowBox[{"Abs", "[", "term", "]"}], "2"]}]}], ")"}], "/.", 
        RowBox[{"List", "\[Rule]", "Plus"}]}]]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Plus", "@@", "#"}], "&"}], ")"}], "/@", 
       RowBox[{"(", 
        RowBox[{"mat", "/.", 
         RowBox[{
          RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
          RowBox[{"Abs", "[", "term", "]"}]}]}], ")"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2a", "[", "mat_", "]"}], ":=", 
   RowBox[{"matNorm2", "[", 
    RowBox[{"Transpose", "@", "mat"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = \>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"matNorm2", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}], ",", 
     RowBox[{"matNorm2a", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6851991203125*^9, 3.6851993145625*^9}, {
   3.68519934696875*^9, 3.685199381390625*^9}, {3.685199412125*^9, 
   3.685199441796875*^9}, {3.685199512*^9, 3.685199656984375*^9}, {
   3.68519972671875*^9, 3.68519975721875*^9}, {3.68520000603125*^9, 
   3.685200017375*^9}, 3.6852002675625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm3", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"N", "[", "#", "]"}], "]"}], "&"}], "@", 
       RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm2a", ",", "matNorm3"}], 
    "}"}], "[", 
   RowBox[{"mat2", "[", "0", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.685199839890625*^9, {3.68519987946875*^9, 3.685199990328125*^9}, {
   3.685200040390625*^9, 3.685200087734375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{"mat_", ",", "matNorm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"matNorm", "[", 
     RowBox[{"Inverse", "@", 
      RowBox[{"N", "@", "mat"}]}], "]"}], "*", 
    RowBox[{"matNorm", "[", 
     RowBox[{"N", "@", "mat"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{
     RowBox[{"mat2", "[", "0", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm3"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.68520046784375*^9, 3.685200492265625*^9}, {
   3.68520052959375*^9, 3.685200676875*^9}, 3.685202460703125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exactMatrix", "=", 
   RowBox[{"mat2", "[", "0", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixRank", "=", 
   RowBox[{"MatrixRank", "[", "exactMatrix", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "=", 
   RowBox[{
    StyleBox["0.2",
     FontColor->RGBColor[1, 0, 0]], "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"matrixRank", ",", "matrixRank"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"knownMatrix", "=", 
   RowBox[{"exactMatrix", "+", "matrixOfErrors"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"knownMatrix", "//", "mf"}], ",", 
    RowBox[{"exactMatrix", "//", "mf"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"variablesToSolve", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["x", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"rhsVector", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.68520071415625*^9, 3.68520077615625*^9}, {
  3.68520082040625*^9, 3.685200990734375*^9}, {3.68520118575*^9, 
  3.685201205921875*^9}, {3.68520130540625*^9, 3.685201306640625*^9}, {
  3.68520136265625*^9, 3.685201404375*^9}, {3.685204244234375*^9, 
  3.685204283921875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "how", " ", "to", " ", "get", " ", "list", " ", "of", " ", "equations", 
    " ", "from", " ", "vectors", " ", "and", " ", "matrices"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"equations", "[", "mat_", "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"mat", ".", "variablesToSolve"}], "==", "rhsVector"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"mf", "/@", 
      RowBox[{"(", 
       RowBox[{"equations", "/@", 
        RowBox[{"{", 
         RowBox[{"exactMatrix", ",", "knownMatrix"}], "}"}]}], ")"}]}], "]"}],
     ";"}]}]}]], "Input",
 CellChangeTimes->{{3.685201310125*^9, 3.685201356921875*^9}, {
  3.685201429109375*^9, 3.685201523296875*^9}, {3.68520186425*^9, 
  3.685201890625*^9}, {3.685202028171875*^9, 3.685202073734375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"how", " ", "to", " ", "get", " ", "rhsVector", " ", 
    RowBox[{"(", "b", ")"}], " ", "and", " ", "the", " ", "matrix", " ", 
    RowBox[{"(", "mat", ")"}], " ", "from", " ", "a", " ", "list", " ", "of", 
    " ", "equations", " ", "and", " ", "known", " ", "variablesToSolve"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "m"}], "}"}], "=", 
     RowBox[{
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"equations", "[", "exactMatrix", "]"}], ",", 
        "variablesToSolve"}], "]"}], "//", "Normal"}]}], ";"}], 
   "\[IndentingNewLine]", "b", "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "m"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68520172828125*^9, 3.6852017331875*^9}, {
  3.685201774875*^9, 3.6852018498125*^9}, {3.685201894171875*^9, 
  3.685201895046875*^9}, {3.68520195796875*^9, 3.685202045859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrors", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["exactMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrors", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685202113484375*^9, 3.68520217209375*^9}, {
  3.685202205671875*^9, 3.685202264234375*^9}, {3.68520229925*^9, 
  3.68520231340625*^9}, {3.685202375609375*^9, 3.6852024411875*^9}, {
  3.6852025109375*^9, 3.685202512359375*^9}, {3.685202563421875*^9, 
  3.685202816453125*^9}, {3.6852028650625*^9, 3.6852028746875*^9}, {
  3.68520302125*^9, 3.685203044*^9}, {3.685203136203125*^9, 
  3.685203221390625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrorsKnown", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["knownMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrorsKnown", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.685203252265625*^9, 3.68520326675*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"So", ",", " ", 
   RowBox[{"it", " ", "looks", " ", "like", " ", "a", " ", 
    RowBox[{
     StyleBox["joke",
      FontColor->RGBColor[1, 0, 0]], ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
          "for", " ", "the", " ", "comparison", " ", "of", " ", "errors", " ",
            "we", " ", "have", " ", "to", " ", "know", " ", "the", " ", "the",
            " ", "condition", " ", "number", " ", "of", " ", "the", " ", 
           StyleBox["exactMatrix",
            FontColor->RGBColor[1, 0, 0]]}], " ", "..."}], " ", "but", " ", 
         "knowing", " ", "it", " ", "we", " ", 
         RowBox[{"don", "'"}], "t", " ", "need", " ", "anything", " ", 
         "related", " ", "to", " ", "condition", " ", "numbers", " ", "etc"}],
         "..."}], "\[IndentingNewLine]", "..."}], " ", "but", " ", "we", " ", 
      "can", " ", "believe", " ", "that", " ", "for", " ", "small", " ", 
      "matrixNorm", " ", "of", " ", "matrixOfErrors", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "try", " ", "to", " ", "decrease", " ", "the", " ", "value", " ", 
         StyleBox["0.2",
          FontColor->RGBColor[1, 0, 0]], " ", "in", " ", "the", " ", 
         "definition", " ", "of", " ", "matrixOfErrors", " ", "the", " ", 
         "difference", " ", "of", " ", 
         RowBox[{"cond", "[", "exactMatrix", "]"}], " ", "and", " ", 
         RowBox[{"cond", "[", "knownMatrix", "]"}], " ", "is", " ", "small", 
         " ", "and", " ", "reasonable"}], "..."}], " ", ")"}]}]}]}]}], " ", 
  "\[IndentingNewLine]", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.68520388903125*^9, 3.68520408*^9}, {3.6852043109375*^9, 
  3.68520442140625*^9}, {3.68520445565625*^9, 3.68520450884375*^9}}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.68520451846875*^9}]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1384, 40, 353, "Input"],
Cell[1932, 62, 1660, 37, 273, "Input"],
Cell[3595, 101, 2249, 60, 255, "Input"],
Cell[5847, 163, 1657, 40, 159, "Input"],
Cell[7507, 205, 1967, 52, 540, "Input"],
Cell[9477, 259, 803, 22, 209, "Input"],
Cell[10283, 283, 693, 19, 120, "Input"],
Cell[10979, 304, 1824, 52, 433, "Input"],
Cell[12806, 358, 920, 25, 164, "Input"],
Cell[13729, 385, 988, 22, 299, "Input"],
Cell[14720, 409, 2196, 52, 739, "Input"],
Cell[16919, 463, 1817, 46, 694, "Input"],
Cell[18739, 511, 1813, 37, 523, "Input"],
Cell[20555, 550, 86, 1, 120, "Input"]
}
]
*)

(* End of internal cache information *)
