(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      3836,        146]
NotebookOptionsPosition[      3183,        119]
NotebookOutlinePosition[      3562,        135]
CellTagsIndexPosition[      3519,        132]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.716083705234375*^9, 3.716083708140625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x0", "*", 
     SuperscriptBox["q", "i"]}], "+", 
    RowBox[{"b", "*", 
     FractionBox[
      RowBox[{
       SuperscriptBox["q", "i"], "-", "1"}], 
      RowBox[{"q", "-", "1"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xinf", "=", 
   RowBox[{"b", "*", 
    FractionBox[
     RowBox[{"-", "1"}], 
     RowBox[{"q", "-", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"xinf", "/.", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"1", "-", "a"}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.685242367765625*^9, 3.685242446390625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "i", "]"}], "-", 
    RowBox[{"x", "[", 
     RowBox[{"i", "-", "1"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.685242450296875*^9, 3.685242459984375*^9}, {
  3.685242509890625*^9, 3.68524251071875*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["q", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "i"}]], " ", 
  RowBox[{"(", 
   RowBox[{"b", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", "x0"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.685242455953125*^9, 3.685242460859375*^9}, 
   3.68524251690625*^9, {3.716083627953125*^9, 3.7160836474375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"denom", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "i", "]"}], "-", "xinf"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.685242481984375*^9, 3.68524251403125*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["q", "i"], " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", "x0"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "q"}]]], "Output",
 CellChangeTimes->{{3.685242483640625*^9, 3.685242514671875*^9}, {
  3.71608363559375*^9, 3.716083650265625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["num", "denom"]], "Input",
 CellChangeTimes->{{3.685242524125*^9, 3.68524252659375*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "q"}], "q"]], "Output",
 CellChangeTimes->{3.685242527140625*^9, 3.71608365415625*^9}]
}, Open  ]]
},
WindowSize->{904, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 224, 5, 75, "Input"],
Cell[772, 27, 690, 23, 177, "Input"],
Cell[CellGroupData[{
Cell[1487, 54, 306, 8, 46, "Input"],
Cell[1796, 64, 406, 13, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2239, 82, 210, 6, 46, "Input"],
Cell[2452, 90, 407, 13, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2896, 108, 115, 2, 70, "Input"],
Cell[3014, 112, 153, 4, 70, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
