(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28120,        727]
NotebookOptionsPosition[     27395,        702]
NotebookOutlinePosition[     27796,        719]
CellTagsIndexPosition[     27753,        716]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "1.691"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"originalEqn", "=", 
    RowBox[{
     RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"note", ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"rhs", " ", 
        RowBox[{"(", 
         RowBox[{"i", ".", "e", ".", " ", "b"}], ")"}], " ", 
        RowBox[{"doesn", "'"}], "t", " ", "influe", " ", "the", " ", 
        "convergence"}], "..."}], " ", "in", " ", "engineering", " ", "we", 
      " ", "can", " ", "understand", " ", "rhs", " ", "to", " ", "be", " ", 
      "an", " ", "INPUT", " ", "and", " ", "in", " ", "case", " ", "of", " ", 
      "LINEAR", " ", "systems", " ", "facts", " ", "like", " ", 
      "\"\<it conveges or not\>\"", " ", 
      RowBox[{"don", "'"}], "t", " ", "depend", " ", "on", " ", "inputs", " ", 
      RowBox[{"(", 
       RowBox[{
       "in", " ", "case", " ", "of", " ", "ODEs", " ", "initial", " ", 
        "values", " ", "are", " ", "inputs", " ", "as", " ", "well"}], 
       ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"depend", " ", "only", " ", "on", " ", "the", " ", "SYSTEM"}], 
      "..."}], " ", "and", " ", "in", " ", "this", " ", "maybe", " ", "the", 
     " ", "simpliest", " ", "example", " ", "the", " ", "system", " ", "has", 
     " ", "only", " ", "one", " ", "parameter", " ", "a"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xExact", "=", 
   FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<condition of convergence, i.e. Abs[q=1-a]<1: \>\"", ",", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"q", "=", 
      RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.778317754078125*^9, 3.778317814984375*^9}, {
  3.778317881203125*^9, 3.778318212640625*^9}, {3.77831830896875*^9, 
  3.778318328921875*^9}, {3.778321595625*^9, 3.77832160065625*^9}, {
  3.778323447328125*^9, 3.7783234646875*^9}, {3.77832514778125*^9, 
  3.778325150046875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "can", " ", "see", " ", "that", " ", "the", " ", "iterative", 
     " ", "process", " ", "converges", " ", "to", " ", "the", " ", "exact", 
     " ", "root"}], ",", "\[IndentingNewLine]", 
    RowBox[{
    "Mathematica", " ", "syntaxis", " ", "using", " ", "integer", " ", 
     "parameter"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "10."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "=", "x0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "i_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", 
       RowBox[{"x", "[", 
        RowBox[{"i", "-", "1"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "40"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.77831823990625*^9, 3.77831830653125*^9}, {
   3.778318407890625*^9, 3.778318503359375*^9}, {3.778318542078125*^9, 
   3.778318716296875*^9}, 3.778318973625*^9, 3.778323482265625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "can", " ", "see", " ", "that", " ", "the", " ", "iterative", 
     " ", "process", " ", "converges", " ", "to", " ", "the", " ", "exact", 
     " ", "root"}], ",", "\[IndentingNewLine]", 
    RowBox[{
    "Mathemetica", " ", "syntaxis", " ", "using", " ", "nesting", " ", "of", 
     " ", "functions"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "10."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778318748734375*^9, 3.77831883015625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"In", " ", "case", " ", "of", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"q", "=", 
       RowBox[{"1", "-", "a"}]}], "]"}]}], ">", 
    RowBox[{"1", " ", "the", " ", "iterative", " ", "process", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "converge"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "2.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<condition of convergence, i.e. Abs[q=1-a]<1: \>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"q", "=", 
         RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", 
     RowBox[{"xExact", "+", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778319213796875*^9, 3.77831937140625*^9}, 
   3.778321235421875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Of", " ", "course"}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{
              "we", " ", "can", " ", "transform", " ", "the", " ", "original",
                " ", "equation", " ", "into", " ", "a", " ", "form", " ", 
               "for", " ", "which", " ", "our", " ", "iterative", " ", 
               "process", " ", "converges"}], "..."}], " ", "but", " ", "is", 
             " ", "a", " ", "nice", " ", 
             RowBox[{"joke", ":", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "to", " ", "find", " ", "a", " ", "proper", " ", 
                   "tansformation", " ", "factor", " ", "for", " ", "lhs", 
                   " ", "and", " ", "rhs", " ", "we", " ", "need", " ", 
                   "DIVISION"}], "..."}], " ", "moreover", " ", "we", " ", 
                 "used", " ", "DIVISION", " ", 
                 StyleBox["twice",
                  FontSlant->"Italic"], " ", "and", " ", "our", " ", 
                 "motivation", " ", "had", " ", "been", " ", "to", " ", 
                 "avoid", " ", "DIVISION", " ", "in", " ", "the", " ", 
                 "process", " ", "of", " ", "the", " ", "solution", " ", "of",
                  " ", "the", " ", "original", " ", "equation"}], "..."}], 
               "\[IndentingNewLine]", "/", 
               RowBox[{"But", ":", " ", 
                RowBox[{
                "we", " ", "have", " ", "used", " ", "division", " ", 
                 "twice"}]}]}]}]}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{
              "but", " ", "we", " ", "need", " ", "one", " ", "division", " ", 
               RowBox[{"(", 
                RowBox[{"evaluation", " ", "of", " ", 
                 FractionBox["1", "factor"], " ", "and", " ", "two", " ", 
                 "multiplications"}], ")"}], " ", "and", " ", "we", " ", 
               "have", " ", "used", " ", "division", " ", "by", " ", "an", 
               " ", "INTEGER", " ", "number"}], "..."}], " ", "it", " ", 
             "can", " ", "be", " ", "profitable", " ", "in", " ", "the", " ", 
             RowBox[{"end", ":", "-"}]}]}], ")"}], "/", "\[IndentingNewLine]", 
          RowBox[{"Look", ":", " ", 
           RowBox[{
           "IAP", " ", "really", " ", "is", " ", "not", " ", "a", " ", 
            "course", " ", "on", " ", "Mathematics", " ", "and", " ", "it", 
            " ", "is", " ", "not", " ", "a", " ", "course", " ", "for", " ", 
            "Scientists"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"really", ".", "\[IndentingNewLine]", "So"}], " ", "we", 
            " ", "can", " ", "play", " ", "with", " ", "computers", " ", 
            "and", " ", "solutions", " ", "and", " ", "we", " ", "can", " ", 
            "be", " ", "free", " ", "in", " ", "our", " ", "games"}], "..."}],
           " ", "and", " ", "one", " ", "of", " ", "our", " ", "game", " ", 
          "is", " ", "to", " ", "find", " ", 
          RowBox[{
           StyleBox["patterns",
            FontSlant->"Italic"], ".", " ", "There"}], " ", "are", " ", 
          "more", " ", "than", " ", "one", " ", "reason", " ", "why", " ", 
          "we", " ", "should", " ", "play", " ", "with", " ", 
          RowBox[{"patterns", ":", " ", 
           RowBox[{
            RowBox[{"1", "/", " ", "pattern"}], " ", "recognition", " ", "is",
             " ", "an", " ", "essential", " ", "part", " ", "of", " ", "not", 
            " ", "only", " ", 
            StyleBox["artifical",
             FontSlant->"Italic"], " ", "intelligence"}]}]}], ",", " ", 
         RowBox[{"but", " ", "of", " ", 
          StyleBox["intelligence",
           FontSlant->"Italic"], " ", "in", " ", 
          RowBox[{
           RowBox[{"general", ".", "\[IndentingNewLine]", "2"}], "/", " ", 
           "seaarching"}], " ", "for", " ", "patterns", " ", "is", " ", "an", 
          " ", "effective", " ", 
          StyleBox["gymm",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["lessons",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["for",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["our",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["brains",
           FontSlant->"Italic"], 
          StyleBox["\[IndentingNewLine]",
           FontSlant->"Italic"], 
          StyleBox[
           RowBox[{"3", "/", " ", "patterns"}],
           FontSlant->"Italic"], 
          StyleBox[
           RowBox[{
            StyleBox[" ",
             FontSlant->"Italic"], " "}]], "are", " ", "usefull", " ", 
          "objects", " ", "in", " ", "Wolfram", " ", "Mathematica"}], ",", 
         " ", 
         RowBox[{"SW", " ", "of", " ", "my", " ", 
          RowBox[{"heart", ":", "-"}]}]}], ")"}], "\[IndentingNewLine]", 
       RowBox[{"4", "/", " ", "There"}], " ", "are", " ", "many", " ", 
       "\"\<pseudo-rules\>\"", " ", "for", " ", 
       RowBox[{"Engineers", ".", " ", "\"\<Pseudo\>\""}], " ", "because", " ", 
       RowBox[{"haven", "'"}], "t", " ", "been", " ", "proved"}], ",", " ", 
      RowBox[{
      "but", " ", "\"\<rules\>\"", " ", "because", " ", "are", " ", "usefull",
        " ", "in", " ", "the", " ", 
       RowBox[{"praxis", ".", " ", "Of"}], " ", "course", " ", "we", " ", 
       "have", " ", "to", " ", "remember"}], ",", " ", 
      RowBox[{"that", " ", "they", " ", "are", " ", 
       RowBox[{"\"\<pseudo\>\"", ".", " ", "The"}], " ", "prove", " ", "that",
        " ", "\"\<There must exist at least one function without Lebesque's \
integral value\>\"", " ", "is", " ", "a", " ", "nice", " ", "topic", " ", 
       "for", " ", "conversation"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
        "but", " ", "for", " ", "Engineers", " ", "it", " ", "can", " ", "be",
          " ", "maybe"}], "..."}], " ", "a", " ", 
       RowBox[{
        RowBox[{"hobby", ".", "\[IndentingNewLine]", "5"}], "/", "Next"}], 
       " ", "more", " ", "than", " ", "10", " ", "good", " ", "reasons", " ", 
       "why", " ", "understanding", " ", "understanding", " ", "patterns", 
       " ", "is", " ", 
       RowBox[{"profitable", ":", "-"}]}]}], ")"}], ")"}], "   ", 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aOrig", "=", "2.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bOrig", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"aOrig", "*", "x"}], "\[Equal]", "bOrig"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qOrig", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["bOrig", "aOrig"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<condition of convergence of the original eqquation, i.e. \
Abs[q=1-a]<1: \>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"qOig", "=", 
         RowBox[{"1", "-", "aOrig"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"factor", "=", 
     RowBox[{"Round", "[", "aOrig", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<original eqn: \>\"", ",", "originalEqn", ",", 
      "\"\< has been transformed into: \>\"", ",", 
      RowBox[{
       RowBox[{
        FractionBox["aOrig", "factor"], "*", "x"}], "\[Equal]", 
       FractionBox["bOrig", "factor"]}], ",", 
      "\"\< using facor = Round[a]= \>\"", ",", "factor"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"we", " ", "need", " ", "DIVISION", " ", 
     RowBox[{"twice", ":", " ", 
      RowBox[{"for", " ", "a", " ", "and", " ", "for", " ", "b"}]}]}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     FractionBox["aOrig", "factor"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     FractionBox["bOrig", "factor"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<condition of convergence of transformed eqn, i.e. Abs[q=1-a]<1: \
\>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"q", "=", 
         RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "10."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.778320787125*^9, 3.77832087621875*^9}, {
   3.778321124328125*^9, 3.77832112671875*^9}, {3.77832115921875*^9, 
   3.7783212535*^9}, {3.77832130690625*^9, 3.7783215855625*^9}, {
   3.778321617421875*^9, 3.778321680625*^9}, {3.778321715296875*^9, 
   3.77832223996875*^9}, {3.778322275625*^9, 3.7783224076875*^9}, {
   3.77832247346875*^9, 3.778322550453125*^9}, {3.778322964859375*^9, 
   3.778323049234375*^9}, 3.778323292640625*^9, {3.778323516078125*^9, 
   3.778323615875*^9}, {3.778323678984375*^9, 3.778323737578125*^9}, {
   3.77832377559375*^9, 3.778323801296875*^9}, {3.77832383721875*^9, 
   3.7783238681875*^9}, 3.77837297609375*^9, {3.778373111078125*^9, 
   3.77837311175*^9}, {3.77837316775*^9, 3.77837321175*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Ok", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"let", "'"}], "s", " ", "move", " ", "to", " ", "next", " ", 
      "task"}], "..."}], "\[IndentingNewLine]", 
    RowBox[{"Let", "'"}], "s", " ", "accept", " ", "as", " ", "a", " ", 
    "fact", " ", "that", " ", "we", " ", "can", " ", "solve", " ", 
    "ewuations", " ", "of", " ", "form", " ", 
    RowBox[{"\"\<a*x\[Equal]b\>\"", ".", "\[IndentingNewLine]", "We"}], " ", 
    "are", " ", "searching", " ", "for", " ", "x", " ", "value"}], ",", " ", 
   RowBox[{
   "it", " ", "means", " ", "x", " ", "valie", " ", "is", " ", "an", " ", 
    RowBox[{"output", ".", " ", "So"}]}], ",", " ", 
   RowBox[{"a", " ", "and", " ", "b", " ", "values", " ", "are", " ", 
    RowBox[{"inputs", ".", " ", "\[IndentingNewLine]", "Our"}], " ", "inputs",
     " ", "are", " ", "outputs", " ", "of", " ", "other", " ", "systems"}], 
   ",", " ", 
   RowBox[{
   "in", " ", "engineering", " ", "area", " ", "mainly", " ", "digital", " ", 
    "data", " ", "as", " ", "outputs", " ", "of", " ", "digital", " ", 
    "mearuring", " ", 
    RowBox[{
    "devices", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "Keeping"}],
     " ", "Newtonian", " ", 
    StyleBox["smooth",
     FontSlant->"Italic"], " ", "description", " ", "of", " ", "our", " ", 
    "technical", " ", "engineeing", " ", "problems"}], ",", " ", 
   RowBox[{"we", " ", "can", " ", "understand", " ", "that", " ", 
    StyleBox["ALL",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["inputs",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["are",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    RowBox[{
     StyleBox["eroneous",
      FontSlant->"Italic"], ".", " ", "The"}], " ", "probability", " ", 
    "that", " ", "fo", " ", "example", " ", "current", " ", "is", " ", "a", 
    " ", "discrete", " ", 
    RowBox[{"(", 
     RowBox[{"digital", " ", "representation"}], ")"}], " ", "value", " ", 
    "is", " ", "0.", " ", "\[IndentingNewLine]", "So"}], ",", " ", 
   RowBox[{"we", " ", "shoud", " ", "search", " ", 
    RowBox[{"(", 
     RowBox[{
     "wanting", " ", "pay", " ", "no", " ", "money", " ", "and", " ", "not", 
      " ", "to", " ", "be", " ", "in", " ", "prison"}], ")"}], " ", "for", 
    " ", "the", " ", "inecurracy", " ", "of", " ", "x", " ", "as", " ", "a", 
    " ", "function", " ", "of", " ", "inecuracies", " ", "of", " ", "a", " ", 
    "and", " ", "b"}]}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.77832286265625*^9, 3.778322947703125*^9}, {
  3.7783230746875*^9, 3.778323099890625*^9}, {3.778323153203125*^9, 
  3.778323233484375*^9}, {3.77832331446875*^9, 3.778323406875*^9}, {
  3.7783239813125*^9, 3.77832403125*^9}, {3.7783248524375*^9, 
  3.77832501165625*^9}, {3.778372955421875*^9, 3.77837295590625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Brutal", " ", "force", " ", "solution"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "use", " ", "Solve", " ", "command", " ",
      "or", " ", "division"}], ",", " ", 
    RowBox[{
    "now", " ", "we", " ", "want", " ", "to", " ", "show", " ", "other", " ", 
     "poblems", " ", "than", " ", "solution", " ", "of", " ", "an", " ", 
     "equation"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "1.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.778325018203125*^9, 3.7783251676875*^9}, {
  3.77837262459375*^9, 3.7783726258125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "now", " ", "we", " ", "involve", " ", "inaccuracies", " ", "of", " ", 
    StyleBox["a",
     FontSlant->"Italic"], " ", "and", " ", 
    StyleBox["b",
     FontSlant->"Italic"], " ", "into", " ", "the", " ", "game"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]aMax", "=", 
     RowBox[{"0.02", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]bMax", "=", 
     RowBox[{"0.02", "*", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xab", "[", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}], "]"}], ":=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataab", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}], "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"a", "-", "\[CapitalDelta]aMax"}], ",", 
          RowBox[{"a", "+", "\[CapitalDelta]aMax"}], ",", 
          "\[CapitalDelta]aMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"b", "-", "\[CapitalDelta]bMax"}], ",", 
          RowBox[{"b", "+", "\[CapitalDelta]bMax"}], ",", 
          "\[CapitalDelta]bMax"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"solutions", "=", 
    RowBox[{"xab", "/@", "dataab"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"minx", ",", "maxx"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Min", "[", "#", "]"}], ",", 
         RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", "solutions"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<we can be sure that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{"minx", ",", "maxx"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778325213578125*^9, 3.778325590171875*^9}, {
   3.77837206265625*^9, 3.7783721235625*^9}, 3.778372656375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"error", " ", "using", " ", "Taylor", " ", "series"}], ",", " ", 
    RowBox[{
    "for", " ", "small", " ", "\[CapitalDelta]aMax", " ", "and", " ", 
     "\[CapitalDelta]bMax", " ", "values", " ", "nearly", " ", "the", " ", 
     "same", " ", "result"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]x", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"ain", ",", "bin"}], "]"}], ",", "ain"}], "]"}], "*", 
         "\[CapitalDelta]aMax"}], "]"}], "+", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"ain", ",", "bin"}], "]"}], ",", "bin"}], "]"}], "*", 
         "\[CapitalDelta]bMax"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ain", "\[Rule]", "a"}], ",", 
        RowBox[{"bin", "\[Rule]", "b"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<we hope that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xExact", "-", "\[CapitalDelta]x"}], ",", 
       RowBox[{"xExact", "+", "\[CapitalDelta]x"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.77837215015625*^9, 3.77837218584375*^9}, {
  3.77837222378125*^9, 3.778372588609375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"statistical", " ", "access"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]xStatistical", "=", 
     SqrtBox[
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"ain", ",", "bin"}], "]"}], ",", "ain"}], "]"}], "*", 
           "\[CapitalDelta]aMax"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"ain", ",", "bin"}], "]"}], ",", "bin"}], "]"}], "*", 
           "\[CapitalDelta]bMax"}], ")"}], "2"]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ain", "\[Rule]", "a"}], ",", 
         RowBox[{"bin", "\[Rule]", "b"}]}], "}"}]}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<according the statistical distibution of errors of a and be there is \
some probability that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xExact", "-", "\[CapitalDelta]xStatistical"}], ",", 
       RowBox[{"xExact", "+", "\[CapitalDelta]xStatistical"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778372669671875*^9, 3.778372811390625*^9}, {
   3.77837284753125*^9, 3.7783728998125*^9}, 3.778373233609375*^9}]
},
WindowSize->{1148, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
Magnification->1.7000001668930054`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 411, 12, 136, "Input"],
Cell[959, 34, 2412, 58, 427, "Input"],
Cell[3374, 94, 1258, 32, 223, "Input"],
Cell[4635, 128, 907, 22, 194, "Input"],
Cell[5545, 152, 1942, 54, 428, "Input"],
Cell[7490, 208, 10403, 238, 1745, "Input"],
Cell[17896, 448, 2945, 63, 397, "Input"],
Cell[20844, 513, 1209, 32, 282, "Input"],
Cell[22056, 547, 2211, 62, 311, "Input"],
Cell[24270, 611, 1639, 46, 224, "Input"],
Cell[25912, 659, 1479, 41, 211, "Input"]
}
]
*)

(* End of internal cache information *)
