(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    224262,       3913]
NotebookOptionsPosition[    222974,       3889]
NotebookOutlinePosition[    223422,       3906]
CellTagsIndexPosition[    223379,       3903]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",ExpressionUUID->"53ac1e39-ecaa-489b-\
a3ab-3216763c924c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "matematicke", " ", "kyvadlo", " ", "s", " ", "pruznym", " ", "zavesem", 
    " ", "je", " ", "popsano", " ", "soustavou", " ", "rovnic"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"g", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"fi", "[", "t", "]"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["fi", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["l", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"l", "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["fi", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "g"}], " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"fi", "[", "t", "]"}], "]"}]}], "+", 
       RowBox[{"k", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "l0"}], "+", 
          RowBox[{"l", "[", "t", "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"l", "[", "t", "]"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["fi", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["l", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["fi", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["l", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"fi", "[", "0", "]"}], "\[Equal]", "fi0"}], ",", 
     RowBox[{
      RowBox[{"l", "[", "0", "]"}], "\[Equal]", "l0"}]}], "}"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"vstupni", " ", "zadane", " ", "hodnoty", " ", "jsou", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"m", "\[Rule]", ".1"}], ",", 
       RowBox[{"fi0", "\[Rule]", "0.01"}], ",", 
       RowBox[{"l0", "\[Rule]", ".1"}]}], "}"}], " ", "a", " ", "ma", " ", 
     "platit", " ", 
     SqrtBox[
      FractionBox["k", "m"]]}], "==", 
    SqrtBox[
     FractionBox["g", "l0"]]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"rovnice", " ", "vyreste"}], ",", " ", 
    RowBox[{
    "zobrazte", " ", "prubehy", " ", "a", " ", "najdete", " ", "periodu", " ",
      "kmitu", " ", 
     RowBox[{"fi", "[", "t", "]"}], " ", "a", " ", 
     RowBox[{"l", "[", "t", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "pro", " ", "jakou", " ", "hodnotu", " ", "k", " ", "bude", " ", "perioda",
     " ", 
    RowBox[{"fi", "[", "t", "]"}], " ", "nejmene", " ", "zaviset", " ", "na", 
    " ", 
    RowBox[{"fi0", "?"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.914386369220974*^9, 3.914386441521967*^9}, {
  3.9143864861864147`*^9, 3.9143865403619194`*^9}, {3.914386621313848*^9, 
  3.9143866661406507`*^9}, {3.914475305217726*^9, 3.914475334116001*^9}, {
  3.914555169357911*^9, 
  3.914555230248618*^9}},ExpressionUUID->"6a527266-c315-43e2-943a-\
26ad3f372b44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "jsou", " ", "dany", " ", "parametricke", " ", "rovnice", " ", "krivky", 
      " ", 
      RowBox[{"x", "[", "t_", "]"}]}], ":=", 
     RowBox[{"t", "+", 
      RowBox[{"0.4", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"Pi", "*", "t"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"y", "[", "t_", "]"}], ":=", 
     RowBox[{"t", "+", 
      RowBox[{"0.4", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"E", "*", "t"}], "]"}]}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"zobrazte", " ", "body"}], ",", " ", 
    RowBox[{
    "ktere", " ", "lezi", " ", "na", " ", "normale", " ", "ke", " ", "krivce",
      " ", "a", " ", "jsou", " ", "od", " ", "bodu", " ", "krivky"}], ",", 
    " ", 
    RowBox[{"kterym", " ", "prislusna", " ", "normala", " ", "prochazi"}], 
    ",", " ", 
    RowBox[{"vzdaleny", " ", 
     RowBox[{"2.5", ".", " ", "Krivku"}], " ", "zobrazte", " ", "cerne"}], 
    ",", " ", 
    RowBox[{
    "bod", " ", "na", " ", "normale", " ", "na", " ", "jedne", " ", "strane", 
     " ", "cervene", " ", "a", " ", "na", " ", "druhe", " ", "strane", " ", 
     "modre"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vysledek", " ", "ma", " ", "vypadat", " ", "takto", " ", 
    GraphicsBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
         0.3]], LineBox[CompressedData["
1:eJws2Hk4lG8XB/BZxEihIqRkaVUi+SmKc5dKRbK0SdEiyVZJki1UhLRItuwR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          "]]},
        Annotation[#, "Charting`Private`Tag$4143#1"]& ]}, {{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
          Opacity[0.3]], LineBox[CompressedData["
1:eJwV0Hs41GkbB3CreqWwSDmTDiPsuxc1S+mtO6G0IzlFOS2tHHKqWFuIRg4h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           "]], LineBox[CompressedData["
1:eJwV1Hs0lNsbB3BHHftFJGm6uavQBaPcRnp2/SgiHR0mKUKSS8koilLKoQsl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           "]], LineBox[CompressedData["
1:eJwV13c8lV8YAPBrj3tvCZWEUDIimRXyHCMrq4WGEcoMqRQtkRIyGlK0rhFC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           "]], LineBox[CompressedData["
1:eJwV1Hs4VFsUAHDOzHAOam5mUp4JfaTH5523pegmJXlX8oie6jbKo8cgkhBJ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           "]], LineBox[CompressedData["
1:eJwd13k81M8bAPDFYhe7dhe7iKTIUSQkoT6PO3eHK4VE5Ug504FyVu5Ujtyi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           "]], LineBox[CompressedData["
1:eJwd1Hk4VWsXAHBKSlz2sc025WTuypAhyrWI5IRKg6RBJMNnzHiliG4RUaZU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           "]], LineBox[CompressedData["
1:eJwd2Hk8VF8bAPCxhBAzZrkzlplJQrJmr5gn+74UZUvSImRJdiK7qOylqFQo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           "]], LineBox[CompressedData["
1:eJwV1Hk4ldkfAPB7b5ZI9rrveyLcUaO0GmGkfMPljpCEMqhoJjRGUe5wk/ol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           "]], LineBox[CompressedData["
1:eJwV13c8Vm8UAHAaQuV9bd55L+8byihSKtUhI7N+hVIi0hZFCUmEUClkZEQp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           "]], LineBox[CompressedData["
1:eJwd1Xk4VdsbB3CUIindBlxDa+/TOmQuXRXJS0KzXMM1hJSSUOmGNEmZpSQK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           "]], LineBox[CompressedData["
1:eJwV03k0lnkbB3BUetXECHPflof7vh/L8xgqow2N+b4UqlGYJgopevBmraZG
yJaEDJFUlkm2xzTVK1rVoFTWXhKV7LI1tmSpEPN7/7jO73zO+Z7zu65znYt1
9bMTSUlISESS+v+b/yDFfraFQnl0qFZsJoM+30b5L8Th6qM2bpcZ5E0f1pFo
pZDwpDU+O5uB/6vz7xYSR8n1X3yby6BwTYb9UuL3p5wO8vMZNPR3+CsQ11bE
KbpdYSDlXryaR1x8pDIi6yoD3YaTWQLivzftu991ncGfMxfvrSGOmP7jL+YG
A0s362MbiePdpqJdihh0m0527iBWdklT+/0WA6fjvaPuxB7NI7+23mHgUe2f
G0j8ttYyVaWYgVnSgMQZYgOzuQiHBwzOLMqQFBPb2HgZpJQwUOa15ZUSZ6i9
y3lRxiA1Y2q0mfjBm4bWr8tJfq7vgEIbhWXmTudjKxiMnPwp7TviPel36Ioq
BhE1j71/Iq7eNOW4oJaB6s7G0YvEuyIztYLqGdDr5i+VEouN66/cbmCQo2Q1
0kdsdMJrdKyRwfe8f7sat1OIFAfc9GhmkGV9JMqdeErhjmFWC4P4xLpNycQ1
htN+rW3EvPGkCeIRc0OeTTcD97B828oOCudD9YxXDzJ4cP+pkWQnhRWSmxK9
hxmI9gzeNiHOH3uamTPKoMxC2+cWsYLHsz6FCTJPvEXR/S4K2xRPz4/MMghy
jNCX7KZgJ4hfojXP4NQSr7VWxJEOWVW7JVlczZUee0PsnNu778kiFlMdyR+W
91AoWOgxlCLLIvCRqm9tHwXjrSs+6zIsXDUuaGr2U7gRY16ylmOxx3FO9zjx
7mxrYzNNFrqW5ZqGAxSaR8t+dhCwiLtdePf6Owr1Rxvkwlex+E5r4vHbIQov
ps/iMVgMPlTRthmm0GCcurnGjEVTxEDNX8QvQ0cXNGxkUeCb3p0+QqGlf93p
disWDlZbBAfeU1A1+qFl3IbFFe8vhzBBwbvvlIncPhaylrzKMuJ7Y/cN5d1Y
eO+z3Wk2ScGMsX+9XMRiY6mM6uYpCtIrs7SU/sOi0dLIQPSJguW1Z5VKB1m8
2S499HKWQmF5y6R0OHGp5cE0aRq9pyYNxJksii19VpsupsH84WuXnMWiKqli
WTdxZ51ANTyHhb6jjYS+DI1Lhy7n7Mpnodeh/7xuKQ3Xot+SpAvIvI0qUVby
NHKfRhZtL2XRIDe+V5JH41EqNZbRxkLiXwuTnhC31itWhnawuP6nenmsOo1I
N3+zfV0shhbf5GiGxqBLNcPvZXEw1vSxKZ/GqhOtYVlDLAyVfD8VC2lkf3Xr
dsIM2ecWI58D62h8ab+wg6/M4Rfn7ry962mwd4OdWVUOqS1pE/ZGNLqHpyfV
eRy0ffoqN5vQCPw1sIlmOSTqBn9v/AON2sSzPy4WcthAy2dYW9KQOhC5rG49
h5K45ND1DjTqesNjZRw46C0yFX8IplHY9DJLeI6Df0B62/IQGpXlR6nBFA6y
erWvDUNpDJzLF169wOHRzBbVgHAaovsD2vrpHMJkEspkomg8PTd9UjebQ7t5
01LbBBqZNhady29wCDKIueuVRaN4idA1tZaDmudzj6JqGiWz9ebRUnzwZsJO
qNWSfOJ6q58X8kEbh+yJekbD4bhEOyvNR4rixHanehpuMsKSezJ83O0elpN/
SWPcfsWOnq/5eOIsEZrRRfZ1zuSDpgYfRUy6rOlnGlRIVPMOEz56bh7zDtVV
hsXehyNHD/HhJU5O7YtThlSMSvP6Jj4+5sWtEE0o46h0uDdroInaer8Ftl4q
2BSz5HRrgib2M5HS1zpUsGTYzlSpRxNn9gdHV7iqwmR2V+FaEy1o39wW8qJf
FbKaW88Mx2lhsUSA5yoPNTi1mos/N2khtSYiVDChBqmWYMUeVhvSq98VvzrG
Q4Z1V161SBuu8no9JnM8+DZImmTmamPnnvovefHq4DO/Ob7u10Y4s2b7MSUN
qPfUcFWcDna4Nh/pytNAk1vQw2gXHbw3TZORVWEwdbF3aOq8DslZ173dzSA9
zPZgYZUORB2Hje5dYrDl5FEt/1kdSJj2mlm2M9BwzHOvEggQ9VXb9TJlFj7/
0y30sxWgb2w+d8aehftz82uegQJo7q6uuJXAwrRwmCnJEEA7bHxtYBWLZa80
Z76UCTA0w4pHZ1l8I7II+bZDgMDWvWkr9TmIUjpznacFaGsSz+x34fAywVnv
iJIQM768/FV7OXhOeos6iTdkHzCaJTYc0Anc+o0QGXoRS8+6chDOc+tYSoiH
c+G/lIo4xJdVSdXQQhy3Opek4M2hTMtujlIToveFZd+VAA5VlG7wBU6Isz4B
BYePcXhacNhnnlh1nZvnhkCS739j6s4X4vqjG1nPgjhke/4eYagphFKJ+5bR
EPIf9WNSrZYQjk7ehStPcrATp05+EpB+c1LDPhJnXY6ecRYKUXVZxqw0ikNl
DNPziPjSoCBzWzSHuPbPznG6QoiblRu9T3P4r4vCZ56eEJXFExar48jdPJFT
jiCujtEumCEe8FPk9REHTX3rERvP4WLn38+v6QtRE11/yzaBw+II6oT8CiEu
f/SZpc+Qu1aXUj5CnGziZ9JJ7ND8+uxr4hhbHBYncrDXqB43WSnEP7IfkDs=

           "]]},
         Annotation[#, 
          "Charting`Private`Tag$4168#1"]& ], {}}, {{}, {}, {}}}, {{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
          Opacity[0.3]], LineBox[CompressedData["
1:eJwV03k01esaB3Bh798PhbI1oHOiwpa2ebx434U6hQzlhDoZM2UeMkS4p46O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           "]], LineBox[CompressedData["
1:eJwV1Xk4VVsbAPDt4CKuXFOTTBUllFlcXqpjyPRlyBQZMpNSyZRUVEr6hI/M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           "]], LineBox[CompressedData["
1:eJwV13k8VF8UAHBjG0t2SraEREmKEOXcylpCskQUJamUFlGSlh+iUGTfokhE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           "]], LineBox[CompressedData["
1:eJwV1Xk8lGsbB/DHYIw9W2ksWbJTtkPZ7kf2pZJKspSERHLinFSUsTsRk7UR
Mk8p4pVTUlLucZClOFJO0VuUZOm8FaEUeq/5Yz7z+X5+13XN/dz3PTPqwdHe
oTSCIIrhxX9n1evT7WgUis48frfWiEay5E9ne4D3mqdMjhrSSJ7lttlw8OLL
ndrPDMDtqlL5YGaZmU+PPo0k5+Oyu8EPdObi2vTARrZMCUEKlXuFZWFdsERt
iB/4sbwfu0UHHB+wtgGcUVaeztMGt5DvFYUo1O1AO9qhBfMTK09mgsUKvJ17
10M+YpJME6bQ+I4A6Rea4NMTdengjvgPXeMa4DSNG/J0CmVtexSzoA7rP7Nv
ylOEQiHGV4vU1CBfmX49DW7SH4hyWwf50TEvNoNCTvMyT39TBavKXv8sSiHb
ewouT5VpJGE5I1MjRqHk/oTddDBv4dzXSHEK/fXFdsZaCZzuTBKSFJqxk+6v
Wwv9u020n4LJmhbZfxXh8x7F5dZIUcj9Jv2tAd+e1+ciV1Hou1GJ1q3VUD9w
a9d6eQr157hbj8rBvIiqcmUFWG+N7SsTvhnMVMXVFDKaNRFLlwVvumTKVKSQ
yTd3IQsZWJ9ySKWdMoUWosJiG6Rgnmee11YVCvUR5w4xwcTJbF6gKoUOCNHH
kyXBOZcZKWoUitKSjfeXANfnLL1YTyEN4zhJAzFYX+PR3E9aFDrZssa5UhTy
zCx1ug6FcL4bXQPMsn0YaqpHoUDJBGVNBuTHzaKSjKBfo4/jQId+s6ptPb9Q
aL2mfuUyDepffQrrtID9TK+1rgDzzkdot1pSaE/0Wh8nvpct+qo3U+jThg6F
YgHwtzwLd1sKDc++afIlwAGJMxcdKMTZyjiwa0WAZF3UYvs5UkhetKeZyfcF
6VIZJwrlPV+hv1sWIMmozRLhzhSyDM6PSgQTey8P3nClUM8z/dihJQGSZ155
0MCNQkXWLm53wKzV5B9l4PTS05IXwGShzp0Qdwo1fpbaHwwmpDt/O+FBoQ2V
dapMfp6sVkCBZ31TA6X5/UHC2a1gzyCdTBG+L+loD4IrfbaX0/j1MXmGr8CR
Wg2XCH6uc/3wEFhORCpbgJ8LGVZ1g83PKhwU5ucu63zSwMfCZPoV+HnbwwAv
sEjZiVAN/nq2OuZLgXUtYt+Z8J8nYbH1IKzXJF6ifC+/fliGEwnPy+z3+PaI
75T2nB4X+D597Rz4xO9vu6auBE4MbyxYDfvDeq8XwIb9U3R523uEv3/NtmMd
9nCfzP2lbGB/iSevt5rDeanot7FD+edRfXSuCM73Izuv/Q6YODixc9IM9jNp
7qUEnB8huZHtY0yhkchzDZh/ni593gG6FJr4W0TEVRBylX1Nk3DfrTzUBcfg
vrDGJwpeDlYgd7JhX9ImsOz3X61/L0VrNZUsBdlQP0PbLBGcjx6nGVSnKgmS
RInR4YHCRFQbtLFjUw/Y8Rdz9t0zaOVDLpHfC+5azKsePo04T7qaPveDP59s
mlNOQBXHbP7T+BxM7A9RKDmBmkfse4+M8/tvCQzGHUPu9RFXUwSEoP5l8ZlD
zqjZwlgrwgbMYx7OGbNFsqKZPy1JMKmin/rWCIVW5JaIOoIJ10MvpDbgNcOi
ync9wOztpwKfeOPlZbHcLf7gK2JZd0rC8ZWQ8N3S8eCz4aumbsVjKjTcquQB
OPjbyOFrCdg82nq6vxVsE0kTu3gaF30tzBB/CE5WDC9LTsQ5FXWF2X1gznPq
QHUS1hWa9GgZAafR6Y6n0rCcod/5tzRhknCzb9KSP4d/pAgPb/EED0y1zmWf
wysZNa1LXmDjl/0VwjmY6z0xd283+IFTYeZCDh5OnHF33A9O8x0xjmTjBNf/
SWfFgL/UFtg752FLdufIB44wybJi1Yy8KcQOZ9XOyP4LJh7W+Kwuwk3GjUYC
M2C3lswK9yLsOtew+GUe+iOVO6puFuFc2vzs+E+wiqntUVYx3pHkg3/I0UnW
zZ9Kr2Q4WNVgOnrGBqx3DdMcONhHfGGX5hY6SXz44/VULAeHyA9l7HWB3MBs
5OszDk4dHBsb2AH5g7t5M/kluG7Nm77FMLBrnqWrUCleKBBxVcqDer+Ewi/G
pVi3k52TXwy+kpbgGViKDZe196wqAyfwMgRul2IvubH4NVXQb//FzzuoDIsk
ETEBLWD3mD07K8uxYfWoePsHqBf0ljB+XI67p06Jpc9A/k449vJsORaKftHq
+RVymoapq90lLGczFD5JEyFZvnNtgf2XsPEa1+++TBGSF1bvqBtdgTkF0w4a
7uAqjy12rApsv2OU0+AlQhIef03Qz4PpITzPPdAflPlnzZ8VuNM/8XxOCOT4
SIjmpwpc+cK/wzcRXOj9T91yBY5hMtSZ6eC8G81j4lzcEO4a8yYb5gc3yzvp
cLG3jx4juQTyCc1nbXu5WKXJKlW8UYQkE3d2nQjl4vn3btLL98EbZ716f+Xi
j3/73p5rg/pW0x/b07n4Xrx96MITsFleSjybi/UtU04QQzD/+5Mo+xIunoop
aFo1Cnlvg0JxLRcHTS49d/gI6183rbH+Nhc/1GhtCZuH+himifMDLv79xob3
uUuQd1eP/mjn4qzxJW8syID/g+U+h8dcLOw8JjovxiBZXSeLlJ9ycVEwR9pE
lgG/R3F9qUNcrNj+T3jsWgZJ3nMSjx/h4uP93sz7alBvtO718jsu3lrfriuu
C/P+1R0Un+ZiWfOxC0Ebof9tZPzlj1zceDck+r4F5Mb9vm2zXNwt/rNe1Q7s
oTh7eIGLD2w/FJzhBPPE/ttVuMjFPq92ZC54Qs5L8Xdagnn6MTpHdsG8fQ5a
cStc/PnqKcdJf8jTFMr1CArbX1F+F3EQfKfRyl+AwkmmDPG5CLDKcavv4Ivx
crxTxxjk/wEpQwMc
           "]], LineBox[CompressedData["
1:eJwd2Hk81M8bAHD3LvZi3YuSI4WoRJHmUZSiSERFSunrTKFSIamQShS5SoUK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           "]], LineBox[CompressedData["
1:eJwV0nk8VV0XB/AbIeTZ955TmkxXKoqUMVRnITJEUZKSNCiVMmVIF6lIKCky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           "]], LineBox[CompressedData["
1:eJwd13c8lf8XAHCVjGtd93KfO6xrZWYkiXCyUmYyQkmhjKiMVKJomKlUUiSl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           "]], LineBox[CompressedData["
1:eJwV1Hk4lVkYAHBjuUnp+6L5FmuyZI2bhonwWpJKKMXYsmWJipJGpc0uKlNG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           "]], LineBox[CompressedData["
1:eJwV13c8VW8YAHAayAy59x7zHDtRVkjSIyUqSeJnlJkUklAKlTIKqSgrK0Iy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           "]], LineBox[CompressedData["
1:eJwV1Xs0VlkfB3DkEilK49nnuZ6MMFQKlfGib4VEMql4lGtuUfSMREQPUZFL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           "]], LineBox[CompressedData["
1:eJwd1ns8lOkXAHAhokQskvZ9n+gdptCF3OWUKdqwViIkKZdsLclWbkW5lSJR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           "]]},
         Annotation[#, "Charting`Private`Tag$4193#1"]& ], {}}, {{}, {}, {}}}},
     Axes->{False, False},
     AxesLabel->{None, None},
     AxesOrigin->{0, 0},
     DisplayFunction->Identity,
     FrameLabel->{{None, None}, {None, None}},
     FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
     GridLinesStyle->Directive[
       GrayLevel[0.5, 0.4]],
     Method->{"ScalingFunctions" -> None},
     PlotRange->All,
     PlotRangeClipping->True,
     PlotRangePadding->{{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}},
     Ticks->{Automatic, Automatic}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"20", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.914386818932426*^9, 3.914387039996606*^9}, {
  3.914474982456797*^9, 
  3.914474993180028*^9}},ExpressionUUID->"86b4169a-98f9-464d-8473-\
3ae8776fbb1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "vstup", " ", "obvodu", " ", "podle", " ", "obrazku", " ", "jsou", " ", 
     "data", " ", 
     RowBox[{"uin", ".", "csv"}], " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "u"}], "}"}]}], ",", " ", 
    RowBox[{
    "najdete", " ", "vystupni", " ", "napeti", " ", "pro", " ", "nulove", " ",
      "pocatecni", " ", "podminky"}], ",", " ", 
    RowBox[{"derivovat", " ", "vstup", " ", "je", " ", "zakazano"}], ",", " ",
     "vite", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "R", "*", "c"}], "=", "1"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "zobrazte", " ", "vstupni", " ", "a", " ", "vystupni", " ", "napeti", " ", 
    "v", " ", "jednom", " ", "grafu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9143871443615575`*^9, 3.914387250610461*^9}, {
   3.9143872894144883`*^9, 3.9143873403335886`*^9}, {3.9143897672392445`*^9, 
   3.9143897825596933`*^9}, {3.9143898200008993`*^9, 3.9143902974045973`*^9}, 
   3.9144747356679783`*^9, {3.9144749726660504`*^9, 
   3.914474975643832*^9}},ExpressionUUID->"36ffcd3a-802b-4c20-bd84-\
e1d4eeac3368"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"data", " ", 
     RowBox[{"uin", ".", "csv"}], " ", "jsou", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "u"}], "}"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "najdete", " ", "zakladni", " ", "periodu", " ", "signalu", " ", "a", 
      " ", "proklad", " ", "funkcemi", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"i", "*", "\[Omega]0", "*", "t"}], "]"}], "a", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"i", "*", "\[Omega]0", "*", "t"}], "]"}], " ", "vite"}], "-", 
     "li"}], ",", " ", 
    RowBox[{
    "ze", " ", "signal", " ", "neobsahuje", " ", "vyssi", " ", "harmonicke", 
     " ", "nez", " ", "patou"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "zobrazte", " ", "signal", " ", "a", " ", "proklad", " ", "v", " ", 
    "jednom", " ", "grafu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"5", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.914390328937291*^9, 3.9143904484595423`*^9}, {
  3.914474960592836*^9, 
  3.914474966579838*^9}},ExpressionUUID->"bcdda54a-1996-42f1-9ac7-\
e46b93da7508"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"je", " ", "dana", " ", "matice", " ", "A"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", GridBox[{
         {"1", "2", "3"},
         {"19", "17", "13"},
         {"113", "71", "29"}
        }], ")"}], " ", "a", " ", "vektor", " ", "pravych", " ", "stran", " ",
       "bV"}], "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"najdete", " ", "matici", " ", "V"}], "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"b", "0", "0"},
         {"0", "c", "0"},
         {"0", "0", "d"}
        }], ")"}], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["takovou",
       FontWeight->"Plain"]}]}], 
    StyleBox[",",
     FontWeight->"Plain"], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    RowBox[{
     RowBox[{
      StyleBox["aby",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["matice",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox[
       RowBox[{"V", ".", "A"}],
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["mela",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["nejmensi",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["cislo",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["podminenosti",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], 
      StyleBox["pouzivajici",
       FontWeight->"Plain"], 
      StyleBox[" ",
       FontWeight->"Plain"], "Frobeniovu", " ", "neboli", " ", "Hilbertovu"}],
      "-", 
     RowBox[{"Schmidtou", " ", "normu"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "najdete", " ", "reseni", " ", "soustavy", " ", "pro", " ", "bV", " ", 
     "a", " ", "1.01", "*", "bV", " ", "pro", " ", 
     RowBox[{"A", ".", " ", "matici"}], " ", "a", " ", "pro", " ", "soustavu",
      " ", 
     RowBox[{"V", ".", "A", ".", "x"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"V", ".", "bV"}], " ", "a", " ", 
     RowBox[{"V", ".", "A", ".", "x"}]}], "\[Equal]", 
    RowBox[{"1.01", "bV"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.91439061322444*^9, 3.9143907666273136`*^9}, {
   3.914391735172736*^9, 3.914392015723544*^9}, {3.9143921306555147`*^9, 
   3.9143921311451464`*^9}, {3.914392212267459*^9, 3.914392242512081*^9}, {
   3.9143922742594204`*^9, 3.914392393312614*^9}, 3.9144711296571302`*^9, 
   3.914474800828921*^9, {3.9144748985128465`*^9, 3.914474911507868*^9}, {
   3.914555318626328*^9, 
   3.9145554381712027`*^9}},ExpressionUUID->"cd7cf4af-6621-49d0-909a-\
714775ebec94"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"napiste", " ", "funkci"}], ",", " ", 
    RowBox[{
    "ktera", " ", "ma", " ", "parametr", " ", "ctvercovou", " ", "matici", 
     " ", "A", " ", 
     RowBox[{"(", 
      RowBox[{"jedno", ",", " ", 
       RowBox[{"jak", " ", "velikou"}]}], ")"}], "a", " ", "vraci", " ", 
     "diagonalni", " ", "matici", " ", "V", " ", "plnici", " ", "totez", " ", 
     "jako", " ", "predchozi", " ", "pripad"}], ",", " ", 
    RowBox[{
    "funkci", " ", "otestujte", " ", "na", " ", "puvodni", " ", "matici", " ",
      "A"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"15", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.91439061322444*^9, 3.9143907666273136`*^9}, {
   3.914391735172736*^9, 3.914392015723544*^9}, {3.9143921306555147`*^9, 
   3.9143921311451464`*^9}, {3.914392212267459*^9, 3.914392242512081*^9}, {
   3.9143922742594204`*^9, 3.914392393312614*^9}, 3.9144711296571302`*^9, 
   3.914474800828921*^9, {3.9144748985128465`*^9, 
   3.914474940315852*^9}},ExpressionUUID->"ed8d9932-660d-46b1-8c4f-\
06d95c1e6e15"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Soubor", " ", 
     RowBox[{"A", ".", "csv"}], " ", "obsahuje", " ", "matici"}], ",", " ", 
    RowBox[{"jejiz", " ", "prvky", " ", "jsou", " ", "vsechny"}], ",", " ", 
    RowBox[{"az", " ", "na", " ", "jeden"}], ",", " ", 
    RowBox[{"cela", " ", 
     RowBox[{"cisla", ".", " ", "Vektor"}], " ", "pravych", " ", "stran", " ",
      "b", " ", "ma", " ", "matici", " ", "A", " ", "odpovidajici", " ", 
     "delku", " ", "a", " ", "obsahuje", " ", "same", " ", "jednicky"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Oznacme", " ", "Ax", " ", "matici"}], ",", " ", 
    RowBox[{
    "ktera", " ", "ma", " ", "celociselne", " ", "prvky", " ", "shodne", " ", 
     "s", " ", "matici", " ", "A", " ", "ale", " ", "na", " ", "pozici"}], 
    ",", " ", 
    RowBox[{
    "kde", " ", "je", " ", "v", " ", "matici", " ", "necelociselny", " ", 
     "prvek"}], ",", " ", 
    RowBox[{"je", " ", "x"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"budiz", " ", "v", " ", "vektor", " ", "takovy"}], ",", " ", 
    RowBox[{
     RowBox[{"pro", " ", "ktery", " ", "plati", " ", 
      RowBox[{"Ax", ".", "v"}]}], "=", "b"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "funkce", " ", "soucet", " ", "necht", " ", "vraci", " ", "soucet", " ", 
      "prvku", " ", "vektoru", " ", "v", " ", "a", " ", "vytvorte", " ", 
      "graf", " ", "vyrazu", " ", 
      RowBox[{"soucet", "[", "x", "]"}], " ", "pro"}], " ", "-", "10"}], "<", 
    "x", "<", "10"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.914392514943268*^9, 3.9143925195056095`*^9}, {
   3.914392599306224*^9, 3.914392738666132*^9}, {3.9143927740031176`*^9, 
   3.914392897386035*^9}, {3.914392951163001*^9, 3.9143929679460025`*^9}, {
   3.914394397571119*^9, 3.9143944136651154`*^9}, {3.9143947816298575`*^9, 
   3.914394801462646*^9}, 3.914403878134862*^9, {3.9144711912880287`*^9, 
   3.9144711932711945`*^9}, {3.914471243958175*^9, 3.914471270118162*^9}, 
   3.914471405264038*^9, {3.9144714778089695`*^9, 3.914471513958017*^9}, {
   3.914471558985111*^9, 3.9144715616258736`*^9}, {3.914471617554758*^9, 
   3.9144716573918066`*^9}, {3.9144717017976475`*^9, 3.914471964718699*^9}, {
   3.9144719973307166`*^9, 3.9144720728305883`*^9}, {3.9144722255355406`*^9, 
   3.9144722415105677`*^9}, 3.914474373662159*^9, 3.914474810036639*^9, {
   3.9144748861288843`*^9, 
   3.914474891491846*^9}},ExpressionUUID->"8f5575d0-806e-4b31-a2aa-\
688c9d8db71e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "funkci", " ", "sinus", " ", "chceme", " ", "aproximovat", " ", 
      "tabulkou", " ", "na", " ", "intervalu"}], " ", "<", "0"}], ",", 
    RowBox[{
     FractionBox["Pi", "2"], ">"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "kolik", " ", "hodnot", " ", "musi", " ", "tabulka", " ", "obsahovat", 
     " ", "aby", " ", "absolutni", " ", "hodnota", " ", "absolutni", " ", 
     "chyby", " ", "aproximace", " ", "byla", " ", "mensi", " ", "nez", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "6", " "}]], "v", " ", "pripade", " ", "linearni"}], ",", 
    " ", 
    RowBox[{"kvadraticke", " ", "a", " ", "kubicke", " ", 
     RowBox[{"interpolace", "?"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.914473049158012*^9, 3.914473606462195*^9}, {
   3.9144742075182934`*^9, 3.91447422355653*^9}, 3.9144743902131505`*^9, 
   3.914474816692911*^9, {3.914474872680894*^9, 
   3.9144748790121093`*^9}},ExpressionUUID->"e12a09eb-d491-496b-aa96-\
21404ab8c7b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "zadany", " ", "obvod", " ", "vyreste", " ", "az", " ", "do", " ", 
    "kvaziustaleneho", " ", "stavu", " ", "a", " ", "najdete", " ", "rozkmit",
     " ", "vystupniho", " ", "napeti"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"15", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iD", "[", "uD_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"19.", "uD"}], "]"}], "-", "1"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]F", "=", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"4700", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cD", "=", 
     RowBox[{"2.2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "180"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uz", "=", 
     RowBox[{"230", "*", 
      SqrtBox["2."], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.914555489393524*^9, 
  3.9145554895028734`*^9}},ExpressionUUID->"0ed16ecd-fb32-4ed6-b1ce-\
b16d190de11e"]
},
WindowSize->{1319, 820},
WindowMargins->{{-1698, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.3,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 413, 11, 202, "Input",ExpressionUUID->"53ac1e39-ecaa-489b-a3ab-3216763c924c"],
Cell[974, 33, 3689, 101, 637, "Input",ExpressionUUID->"6a527266-c315-43e2-943a-26ad3f372b44"],
Cell[4666, 136, 206067, 3427, 605, "Input",ExpressionUUID->"86b4169a-98f9-464d-8473-3ae8776fbb1d"],
Cell[210736, 3565, 1247, 29, 247, "Input",ExpressionUUID->"36ffcd3a-802b-4c20-bd84-e1d4eeac3368"],
Cell[211986, 3596, 1156, 29, 292, "Input",ExpressionUUID->"bcdda54a-1996-42f1-9ac7-e46b93da7508"],
Cell[213145, 3627, 2973, 92, 504, "Input",ExpressionUUID->"cd7cf4af-6621-49d0-909a-714775ebec94"],
Cell[216121, 3721, 1106, 24, 202, "Input",ExpressionUUID->"ed8d9932-660d-46b1-8c4f-06d95c1e6e15"],
Cell[217230, 3747, 2679, 54, 517, "Input",ExpressionUUID->"8f5575d0-806e-4b31-a2aa-688c9d8db71e"],
Cell[219912, 3803, 1180, 27, 309, "Input",ExpressionUUID->"e12a09eb-d491-496b-aa96-21404ab8c7b5"],
Cell[221095, 3832, 1875, 55, 712, "Input",ExpressionUUID->"0ed16ecd-fb32-4ed6-b1ce-b16d190de11e"]
}
]
*)

