(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11114,        328]
NotebookOptionsPosition[     10035,        306]
NotebookOutlinePosition[     10495,        323]
CellTagsIndexPosition[     10452,        320]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.879405195331682*^9, 
  3.8794051968210196`*^9}},ExpressionUUID->"f7ca2243-5a36-40ec-bfc6-\
9c74fa36d1cc"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<datatui.csv\>\"", " ", "jsou", " ", 
    "trojice", " ", 
    RowBox[{"{", 
     RowBox[{"cas", ",", 
      RowBox[{"napeti", " ", "proud"}]}], "}"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"urcete", " ", "frekvenci"}], ",", " ", "periodu", ",", " ", 
    RowBox[{
     RowBox[{
     "cinny", " ", "vykon", " ", "a", " ", "THD", " ", "napeti", " ", 
      "vite"}], "-", 
     RowBox[{
     "li", " ", "ze", " ", "nejvyssi", " ", "harmonicka", " ", "je", " ", 
      "patnacta"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"20", "bodu"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.882853098644782*^9, 3.88285318202919*^9}, {
  3.8828532718542905`*^9, 
  3.882853285405478*^9}},ExpressionUUID->"28bfbd1d-5b36-45eb-87de-\
b3840287c933"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "0.985"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f0", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"k", "*", "f0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f0"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"230", "*", 
      FractionBox[
       SqrtBox["2."], "i"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"i", "*", "\[Omega]", "*", "t"}], "+", 
        RowBox[{"i", "*", "0.123"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "15"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"i", "[", "t_", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"10", "*", 
      FractionBox[
       SqrtBox["2."], "i"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"i", "*", "\[Omega]", "*", "t"}], "+", 
        RowBox[{
         SqrtBox["i"], "*", "0.123"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "15"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"u", "[", "#", "]"}], "+", 
        RowBox[{"10", "rn"}]}], ",", 
       RowBox[{
        RowBox[{"i", "[", "#", "]"}], "+", 
        RowBox[{"0.2", "rn"}]}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0.", ",", 
      RowBox[{"3.56", "T"}], ",", 
      FractionBox["T", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"data", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "i"}], "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<datatui.csv\>\"", ",", "data"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.882852473182371*^9, 3.8828529498096666`*^9}, 
   3.882852980838139*^9, {3.8828530593668275`*^9, 
   3.8828530645304427`*^9}},ExpressionUUID->"9c4b35d1-0a18-4bf8-894f-\
863de7b03373"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Priklad", " ", "za", " ", "10", " ", "bodu", "\[IndentingNewLine]", 
    "urcite", " ", "pro", " ", "jake", " ", "hodnoty", "  ", "k", " ", 
    "system", " ", "je", " ", "stabilni"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x1", "[", "t", "]"}]}], "+", 
       RowBox[{"k", "*", 
        RowBox[{"x2", "[", "t", "]"}]}], "+", "10"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], 
        RowBox[{"x1", "[", "t", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"x2", "[", "t", "]"}]}], "-", "5"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.88285328976646*^9, 
  3.8828532899826965`*^9}},ExpressionUUID->"099e036c-733b-4cff-8224-\
7fb4b37c9af8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "najdete", " ", "analyticky", " ", "proklad", " ", "fce", " ", "Erf"}], 
    ",", " ", 
    RowBox[{"na", " ", "intervalu", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], ")"}], " ", "ma", " ", "byt", " ", 
     "absolutni", " ", "chyba", " ", "mensi", " ", "nez", " ", "0.001"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", " ", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.882853417186254*^9, 
  3.8828534223032255`*^9}},ExpressionUUID->"c9fbb71b-9678-4333-a4eb-\
f7eb2c3ccce2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "v", " ", "souboru", " ", "\"\<zarovky.zip\>\"", " ", "jsou", " ", 
     "charateristiky", " ", "tri", " ", "zarovek"}], ",", " ", 
    RowBox[{"vzdy", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"u", ",", "i"}], "}"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "najdete", " ", "charakteristiku", " ", "kdyz", " ", "spojime", " ", 
     "zarovky", " ", "1", " ", "a", " ", "2", " ", "paralelne", " ", "a", " ",
      "to", " ", "cele", " ", "seriove"}], ",", " ", 
    RowBox[{
    "charakteristiky", " ", "predtim", " ", "vhodne", " ", "prolozte", " ", 
     "analytickym", " ", "vyrazem"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "urcete", " ", "vykony", " ", "takto", " ", "zapojenych", " ", 
     "zarovek"}], ",", " ", 
    RowBox[{
     RowBox[{
     "pokud", " ", "je", " ", "na", " ", "kombinaci", " ", "zapojeno", " ", 
      "napeti", " ", "U"}], "=", 
     RowBox[{"36", "V"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"15", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.88285354398765*^9, 
  3.882853717219198*^9}},ExpressionUUID->"9ba5a7e1-9a46-4d06-a540-\
5b3f6f5a3d6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"15", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "na", " ", "seriovou", " ", "kombinaci", " ", "civky", " ", "a", " ", 
     "rezistoru", " ", "pripojime", " ", "napeti", " ", "v", " ", "zase", " ",
      "t"}], "=", "0"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "pro", " ", "jakou", " ", "hodnotu", " ", "fi", " ", "bude", " ", "mit", 
    " ", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"t", "=", "0"}], "T"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"i", "[", "t", "]"}], "2"], 
      RowBox[{"\[DifferentialD]", "t"}], " ", "nejmensi", " ", 
      RowBox[{"hodnotu", "?"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", "1."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "314"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{"230", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"\[Omega]", "*", "t"}], "+", "fi"}], "]"}]}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.882853836639181*^9, 3.8828540159718285`*^9}, 
   3.8828560904632564`*^9},ExpressionUUID->"90098cf6-f84c-4fc8-a8f6-\
db001b8bd081"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "pro", " ", "jaky", " ", "minimalni", " ", "pocet", " ", "bodu", " ", 
    "pri", " ", "vypoctu", " ", "integralu", " ", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"t", "=", "0"}], "Pi"], 
     RowBox[{"t", "*", 
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"\[DifferentialD]", "t"}], " ", "pomoci", " ", "Simpsonovy", 
      " ", "metody", " ", "bude", " ", "chyba", " ", "vysledku", " ", "mensi",
       " ", "nez", " ", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], "?"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.882854122868722*^9, 
  3.8828542422857103`*^9}},ExpressionUUID->"a7b185f8-a551-4e63-9601-\
adc059ccf3ee"]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5000001192092896`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 458, 12, 102, "Input",ExpressionUUID->"f7ca2243-5a36-40ec-bfc6-9c74fa36d1cc"],
Cell[1019, 34, 905, 25, 160, "Input",ExpressionUUID->"28bfbd1d-5b36-45eb-87de-b3840287c933"],
Cell[1927, 61, 2707, 85, 580, "Input",ExpressionUUID->"9c4b35d1-0a18-4bf8-894f-863de7b03373"],
Cell[4637, 148, 1046, 31, 131, "Input",ExpressionUUID->"099e036c-733b-4cff-8224-7fb4b37c9af8"],
Cell[5686, 181, 614, 17, 102, "Input",ExpressionUUID->"c9fbb71b-9678-4333-a4eb-f7eb2c3ccce2"],
Cell[6303, 200, 1286, 33, 189, "Input",ExpressionUUID->"9ba5a7e1-9a46-4d06-a540-5b3f6f5a3d6d"],
Cell[7592, 235, 1618, 46, 331, "Input",ExpressionUUID->"90098cf6-f84c-4fc8-a8f6-db001b8bd081"],
Cell[9213, 283, 818, 21, 110, "Input",ExpressionUUID->"a7b185f8-a551-4e63-9601-adc059ccf3ee"]
}
]
*)

