(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28897,        836]
NotebookOptionsPosition[     27391,        787]
NotebookOutlinePosition[     27896,        806]
CellTagsIndexPosition[     27853,        803]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
P\:0159evod do Fourierovy \:0159ady - upraveno\
\>", "Title",
 CellChangeTimes->{{3.4920229805*^9, 3.49202300578125*^9}, {
   3.4920230615625*^9, 3.492023062703125*^9}, 3.4932444100625*^9, {
   3.4932469361875*^9, 3.49324694271875*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"NMaximize", "::", "\"\<cvmit\>\""}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<ncvb\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4622052014429674`*^9, 3.462205206934167*^9}, {
  3.467349761203125*^9, 3.467349765296875*^9}, {3.4685625505*^9, 
  3.46856257653125*^9}, {3.561815629347362*^9, 3.561815630425487*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Popis funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")"
}], "Subtitle",
 CellChangeTimes->{{3.492024019484375*^9, 3.4920240240625*^9}, {
   3.493235129734375*^9, 3.49323513575*^9}, 3.493246633171875*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"perioda", "=", "2."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zlom", "=", 
    RowBox[{"0.5", "*", "perioda"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Tanh", "[", "t", "]"}], "/;", 
      RowBox[{"0", "\[LessEqual]", "t", "<", "zlom"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"2.", "t"}], "]"}]}], "/;", 
      RowBox[{"zlom", "\[LessEqual]", "t", "<", "perioda"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"100", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "Pi", "*", 
         RowBox[{"t", "/", "perioda"}]}], "]"}]}], "]"}], "+", "1"}], "/;", 
    RowBox[{"0", "\[LessEqual]", "t", "<", "zlom"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "t_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"100", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", "Pi", "*", 
          RowBox[{"t", "/", "perioda"}]}], "]"}]}], "]"}], "+", "1"}], "/;", 
     RowBox[{"zlom", "\[LessEqual]", "t", "<", "perioda"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "perioda"}], "*", "t"}], "+", "1"}], "/;", 
      RowBox[{"0", "\[LessEqual]", "t", "<", "zlom"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"perioda", "*", "t"}], "-", "3"}], "/;", 
      RowBox[{"zlom", "\[LessEqual]", "t", "<", "perioda"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "-", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "\[GreaterEqual]", "perioda"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "+", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "<", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rngMax", "=", 
   RowBox[{
    RowBox[{"NMaximize", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rngMin", "=", 
   RowBox[{
    RowBox[{"NMinimize", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rng", "=", 
   RowBox[{"1.4", "*", 
    RowBox[{"{", 
     RowBox[{"rngMin", ",", "rngMax"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Hue", "[", "0.63", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nb", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"f", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["perioda", "nb"], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"2", "nb"}], "]"}], "-", "nb"}], ")"}]}], ")"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.007", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.462200921422367*^9, 3.462201373323167*^9}, 
   3.4622015758111672`*^9, {3.462201749049167*^9, 3.4622017749295673`*^9}, {
   3.462201818344367*^9, 3.462201854146367*^9}, {3.4622020769923673`*^9, 
   3.4622021260699673`*^9}, {3.4622036998143673`*^9, 
   3.4622038088895674`*^9}, {3.462204107910367*^9, 3.462204117239167*^9}, {
   3.4622042449563675`*^9, 3.462204292130767*^9}, {3.467920612390625*^9, 
   3.4679206168125*^9}, {3.467920677953125*^9, 3.46792072146875*^9}, {
   3.467920799609375*^9, 3.467920800875*^9}, {3.46792083609375*^9, 
   3.46792083734375*^9}, {3.46792148828125*^9, 3.467921505625*^9}, {
   3.4679217656875*^9, 3.46792177640625*^9}, {3.467923206234375*^9, 
   3.467923214921875*^9}, {3.467923647296875*^9, 3.46792364859375*^9}, {
   3.467923725359375*^9, 3.4679237266875*^9}, {3.467924514921875*^9, 
   3.467924523671875*^9}, {3.467924574515625*^9, 3.467924587125*^9}, {
   3.468516150421875*^9, 3.46851616328125*^9}, {3.468522018796875*^9, 
   3.468522055328125*^9}, {3.468528183109375*^9, 3.46852819478125*^9}, {
   3.468528229875*^9, 3.468528263671875*^9}, {3.46852832890625*^9, 
   3.46852837571875*^9}, {3.468528413390625*^9, 3.468528413515625*^9}, {
   3.468528455*^9, 3.46852845509375*^9}, {3.468528541828125*^9, 
   3.46852857178125*^9}, {3.4685286085625*^9, 3.46852862196875*^9}, {
   3.49324642434375*^9, 3.493246432234375*^9}, {3.493246515546875*^9, 
   3.49324654365625*^9}}],

Cell[TextData[{
 "Funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") m\[AAcute] tento pr\:016fb\:011bh:"
}], "Text",
 CellChangeTimes->{{3.492024554953125*^9, 3.492024562765625*^9}, {
  3.492024871328125*^9, 3.492024875671875*^9}, {3.49324655934375*^9, 
  3.493246566359375*^9}, {3.493246638453125*^9, 3.49324664021875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<u[t]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.492023118671875*^9, 3.492023119*^9}, {
  3.492024745765625*^9, 3.492024763703125*^9}, {3.49202482796875*^9, 
  3.49202483815625*^9}, {3.49202772325*^9, 3.492027724734375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Rozklad ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") do Fourierovy \:0159ady"
}], "Subtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}, {
  3.4932469811875*^9, 3.493246982515625*^9}},
 Background->GrayLevel[0.85]],

Cell["\<\
Budeme po\[CHacek]\[IAcute]tat koeficienty pro prvn\[IAcute]ch 50 harmonick\
\[YAcute]ch funkc\[IAcute].\
\>", "Text",
 CellChangeTimes->{{3.492028971484375*^9, 3.49202900815625*^9}, {
  3.492029183859375*^9, 3.492029189046875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nHarm", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", "nHarm", "]"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "Zaj\[IAcute]m\[AAcute]-li v\[AAcute]s, co obsahuj\[IAcute] seznamy (angl. \
Lists) ",
 StyleBox["siny", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["cosiny", "Program",
  FontWeight->"Bold"],
 ", sta\[CHacek]\[IAcute] odstranit st\:0159edn\[IAcute]k na konci \:0159\
\[AAcute]dku."
}], "Text",
 CellChangeTimes->{{3.492029099828125*^9, 3.4920291366875*^9}, {
  3.49202925021875*^9, 3.492029278796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sinus", "[", "n_", "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"siny", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"sinus", ",", "rn"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cosinus", "[", "n_", "]"}], ":=", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cosiny", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"cosinus", ",", "rn"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.493244584984375*^9}],

Cell[TextData[{
 "Spo\[CHacek]\[IAcute]t\[AAcute]me koeficienty ",
 StyleBox["a",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ",
 StyleBox["b",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ulo\:017e\[IAcute]me je do seznam\:016f ",
 StyleBox["aenka", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["beenka", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.492029374953125*^9, 3.49202941209375*^9}, {
   3.492029899703125*^9, 3.4920299030625*^9}, 3.493246651359375*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{
    FractionBox["1", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n_", "]"}], ":=", 
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "*", 
        RowBox[{"cosinus", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], ";"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Definice", " ", "funkce", " ", "pro", " ", "v\[YAcute]po\[CHacek]et", " ", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], ".", " ", "Zat\[IAcute]m"}], " ", "se", 
    " ", "v\[YAcute]po\[CHacek]et", " ", 
    RowBox[{"neprov\[AAcute]d\[IAcute]", "."}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aenka", "=", 
    RowBox[{"Map", "[", 
     RowBox[{"a", ",", "rn"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Teprva", " ", "te\:010f", " ", "se", " ", "prov\[AAcute]d\[IAcute]", " ", 
    RowBox[{"v\[YAcute]po\[CHacek]et", ".", " ", "50"}], "x", " ", "se", " ", 
    "zavol\[AAcute]", " ", 
    RowBox[{"a", "[", "n", "]"}], " ", "a", " ", "v\[YAcute]sledky", " ", 
    "se", " ", "ulo\:017e\[IAcute]", " ", "do", " ", "seznamu", " ", 
    RowBox[{"aenka", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "n_", "]"}], ":=", 
   RowBox[{
    FractionBox["2", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "t", "]"}], "*", 
       RowBox[{"sinus", "[", "n", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beenka", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"b", ",", "rn"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4622021503123674`*^9, 3.462202313332367*^9}, {
   3.4622025729319673`*^9, 3.462202668686767*^9}, {3.4622027175771675`*^9, 
   3.462202741491967*^9}, {3.4622029929015675`*^9, 3.4622030169879675`*^9}, {
   3.462203106672367*^9, 3.462203112257167*^9}, {3.462203236698367*^9, 
   3.4622032389135675`*^9}, {3.462203335493167*^9, 3.462203337583567*^9}, {
   3.4622033873631673`*^9, 3.4622034681087675`*^9}, 3.462203818031167*^9, {
   3.4622038516647673`*^9, 3.462203870993167*^9}, {3.462204158984767*^9, 
   3.4622041663791676`*^9}, {3.462204359444767*^9, 3.462204362408767*^9}, {
   3.4622044390671673`*^9, 3.462204446695567*^9}, {3.462856015390625*^9, 
   3.46285604153125*^9}, {3.46792166071875*^9, 3.4679216688125*^9}, {
   3.467921811390625*^9, 3.467921823546875*^9}, {3.4679218895625*^9, 
   3.46792190365625*^9}, 3.467921939234375*^9, {3.467922450296875*^9, 
   3.467922491625*^9}, {3.467922568296875*^9, 3.467922596109375*^9}, {
   3.46792269428125*^9, 3.467922759359375*^9}, {3.467922805078125*^9, 
   3.46792286815625*^9}, {3.46792293*^9, 3.467923026328125*^9}, {
   3.467923123203125*^9, 3.4679231334375*^9}, {3.467923986515625*^9, 
   3.46792399403125*^9}, {3.4679241378125*^9, 3.46792425875*^9}, {
   3.46792432134375*^9, 3.467924322375*^9}, {3.4679243834375*^9, 
   3.46792439015625*^9}, {3.4679244713125*^9, 3.4679244824375*^9}, {
   3.46792463*^9, 3.46792463978125*^9}, {3.46792477475*^9, 
   3.467924815390625*^9}, {3.4679248771875*^9, 3.4679248928125*^9}, {
   3.467924935953125*^9, 3.46792497184375*^9}, {3.467925083328125*^9, 
   3.467925138796875*^9}, {3.46792538715625*^9, 3.46792539809375*^9}, {
   3.468517664765625*^9, 3.468517744953125*^9}, {3.46851780703125*^9, 
   3.468517812921875*^9}, {3.468519313703125*^9, 3.468519313828125*^9}, {
   3.46851936775*^9, 3.4685193903125*^9}, 3.49324452603125*^9, {
   3.49324456096875*^9, 3.493244611046875*^9}}],

Cell[TextData[{
 "Slo\:017e\[IAcute]me harmonick\[EAcute] funkce, abychom vytvo\:0159ili \
aproximaci ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "). \n\nPou\:017eit\[IAcute] vzorce\n",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"nahradaVstup", "[", "n_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "n"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "i", "]"}], "*", 
         RowBox[{"cosinus", "[", "i", "]"}]}], "+", 
        RowBox[{
         RowBox[{"b", "[", "i", "]"}], "*", 
         RowBox[{"sinus", "[", "i", "]"}]}]}], ")"}]}]}]}], ";"}]],
  FontWeight->"Bold"],
 "\nby ale bylo v\[YAcute]po\[CHacek]etn\:011b \
n\[AAcute]ro\[CHacek]n\[EAcute] - p\:0159i ka\:017ed\[EAcute]m \
zavol\[AAcute]n\[IAcute] funkce ",
 StyleBox["nahradaVstup", "Program",
  FontWeight->"Bold"],
 " by se znova a znova po\[CHacek]\[IAcute]taly v\[SHacek]echny koeficienty ",
 StyleBox["a[i]", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["b[i]", "Program",
  FontWeight->"Bold"],
 ", tedy znova a znova bychom integrovali. Proto jsme v\[SHacek]echny \
koeficienty (jednou) p\:0159edpo\[CHacek]\[IAcute]tali a ulo\:017eili do \
seznam\:016f ",
 StyleBox["aenka", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["beenka", "Program",
  FontWeight->"Bold"],
 " a te\:010f je pou\:017eijeme:"
}], "Text",
 CellChangeTimes->{{3.49203145075*^9, 3.492031611359375*^9}, {
  3.49203164534375*^9, 3.49203174634375*^9}, {3.49203208028125*^9, 
  3.492032117234375*^9}, {3.492032462953125*^9, 3.49203247153125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nahrada", "[", "n_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"Apply", "[", 
     RowBox[{"Plus", ",", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"aenka", "*", "cosiny"}], "+", 
         RowBox[{"beenka", "*", "siny"}]}], ",", "n"}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.49324470528125*^9, 3.4932447125*^9}}],

Cell[TextData[{
 "T\[IAcute]m je hotov\[YAcute] rozklad ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") na sou\[CHacek]et harmonick\[YAcute]ch funkc\[IAcute]."
}], "Text",
 CellChangeTimes->{{3.492028647125*^9, 3.4920287179375*^9}, {
  3.493244660046875*^9, 3.49324466146875*^9}},
 Background->RGBColor[0.87, 0.94, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Zobrazen\[IAcute] v\[YAcute]sledku p\:0159evodu ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") do Fourierovy \:0159ady"
}], "Subtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}, {
  3.49202873028125*^9, 3.49202876028125*^9}, {3.4920755953125*^9, 
  3.492075598578125*^9}, {3.493244681109375*^9, 3.493244682375*^9}},
 Background->GrayLevel[0.85]],

Cell["P\:0159\[IAcute]prava na zobrazov\[AAcute]n\[IAcute].", "Text",
 CellChangeTimes->{{3.4920278798125*^9, 3.492027902234375*^9}, 
   3.493246740671875*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"harmonicke", "=", 
   RowBox[{
    RowBox[{"aenka", "*", "cosiny"}], "+", 
    RowBox[{"beenka", "*", "siny"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pln", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahrada", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<f[t]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pln1", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nahrada", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plHarm", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"harmonicke", "[", 
      RowBox[{"[", "n", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Green"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", 
     RowBox[{"pln", "[", "n", "]"}], ",", "  ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"u\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\>\""}], "}"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys2", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", 
     RowBox[{"plHarm", "[", "n", "]"}], ",", 
     RowBox[{"pln1", "[", "n", "]"}], ",", 
     RowBox[{"pln", "[", "n", "]"}], ",", "  ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"u\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\>\""}], "}"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4685195363125*^9, 3.46851954096875*^9}, 
   3.46851981403125*^9, {3.468519853328125*^9, 3.468519860140625*^9}, {
   3.4685198999375*^9, 3.468519901609375*^9}, {3.46851999571875*^9, 
   3.468520059625*^9}, {3.4685202535*^9, 3.468520254375*^9}, {
   3.468520371375*^9, 3.468520439296875*^9}, {3.468520487796875*^9, 
   3.468520491890625*^9}, {3.468520538125*^9, 3.468520558640625*^9}, {
   3.46852059225*^9, 3.46852059371875*^9}, {3.46852062865625*^9, 
   3.46852064334375*^9}, {3.468522078890625*^9, 3.468522079484375*^9}, {
   3.49324464184375*^9, 3.493244649984375*^9}, 3.493244709296875*^9, {
   3.493245000859375*^9, 3.49324516478125*^9}, {3.498758231671875*^9, 
   3.49875823515625*^9}}],

Cell[TextData[{
 "Mod\:0159e je funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), \[CHacek]ern\:011b je jej\[IAcute] aproximace pomoc\[IAcute] \
sou\[CHacek]tu ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch funkc\[IAcute]. Nult\[AAcute] harmonick\[AAcute] je \
stejnosm\:011brn\[AAcute] slo\:017eka, tedy koeficient ",
 StyleBox["a0", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
   3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
   3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
   3.4679215163125*^9, 3.467921516703125*^9}, {3.467921598078125*^9, 
   3.467921613671875*^9}, {3.46792268246875*^9, 3.467922711375*^9}, {
   3.468517762578125*^9, 3.468517768734375*^9}, {3.4685202625*^9, 
   3.468520269390625*^9}, {3.4919421591875*^9, 3.491942176046875*^9}, {
   3.491942260203125*^9, 3.491942273578125*^9}, {3.4919423271875*^9, 
   3.4919423275*^9}, 3.491942402859375*^9, {3.491984441140625*^9, 
   3.491984441625*^9}, {3.49202693828125*^9, 3.4920269553125*^9}, {
   3.492027651984375*^9, 3.492027706625*^9}, {3.49202779096875*^9, 
   3.492027831015625*^9}, {3.492040699609375*^9, 3.49204072534375*^9}, {
   3.493245226578125*^9, 3.4932452395*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
  3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
  3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
  3.4679215163125*^9, 3.467921516703125*^9}, {3.467921598078125*^9, 
  3.467921613671875*^9}, {3.46792268246875*^9, 3.467922711375*^9}, {
  3.468517762578125*^9, 3.468517768734375*^9}, {3.4685202625*^9, 
  3.468520269390625*^9}, {3.49324518715625*^9, 3.493245195984375*^9}}],

Cell[TextData[{
 "V n\[AAcute]sleduj\[IAcute]c\[IAcute]m grafu je pro n\[AAcute]zornost nav\
\[IAcute]c \[SHacek]ediv\:011b zobrazena aproximace pomoc\[IAcute] ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["-1",
  FontWeight->"Bold"],
 " harmonick\[YAcute]ch funkc\[IAcute] a zelen\:011b je zobrazna ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-t\[AAcute] harmonick\[AAcute] funkce. \n   \n\
P\:0159i\[CHacek]ten\[IAcute]m zelen\[EAcute] \[CHacek]\[AAcute]ry k \
\[SHacek]ediv\[EAcute] \[CHacek]\[AAcute]\:0159e obdr\:017e\[IAcute]me \
\[CHacek]ernou \[CHacek]\[AAcute]ru. Pov\[SHacek]imn\:011bme si, \:017ee obd\
\[EAcute]ln\[IAcute]kov\[YAcute] pr\:016fb\:011bh se skl\[AAcute]d\[AAcute] \
ze sou\[CHacek]tu pouze lich\[YAcute]ch harmonick\[YAcute]ch funkc\[IAcute] \
(sud\[EAcute] harmonick\[EAcute] jsou nulov\[EAcute])."
}], "Text",
 CellChangeTimes->{{3.492027975296875*^9, 3.49202811228125*^9}, {
  3.49202835103125*^9, 3.49202835346875*^9}, {3.49202841603125*^9, 
  3.492028509796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys2", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "Na z\[AAcute]v\:011br zobrazme spektrum sign\[AAcute]lu (tj. amplitudy prvn\
\[IAcute]ch ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch):"
}], "Text",
 CellChangeTimes->{{3.498760372796875*^9, 3.498760426625*^9}, {
  3.498760545890625*^9, 3.49876056796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fazory", "=", 
   RowBox[{"aenka", "+", 
    RowBox[{"I", "*", "beenka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplitudy", "=", 
   RowBox[{"Abs", "[", "fazory", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"amplitudy", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Blue"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.498760430421875*^9, 3.498760528171875*^9}, {
  3.498760616125*^9, 3.49876065209375*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 698},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 282, 6, 147, "Title"],
Cell[852, 30, 613, 13, 98, "Input"],
Cell[CellGroupData[{
Cell[1490, 47, 300, 11, 98, "Subtitle"],
Cell[1793, 60, 5944, 163, 610, "Input"],
Cell[7740, 225, 409, 12, 97, "Text"],
Cell[8152, 239, 609, 16, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8798, 260, 299, 11, 147, "Subtitle"],
Cell[9100, 273, 280, 6, 97, "Text"],
Cell[9383, 281, 180, 5, 106, "Input"],
Cell[9566, 288, 469, 13, 99, "Text"],
Cell[10038, 303, 763, 25, 282, "Input"],
Cell[10804, 330, 767, 29, 99, "Text"],
Cell[11574, 361, 3996, 89, 453, "Input"],
Cell[15573, 452, 1701, 50, 279, "Text"],
Cell[17277, 504, 424, 13, 64, "Input"],
Cell[17704, 519, 361, 11, 97, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18102, 535, 429, 12, 147, "Subtitle"],
Cell[18534, 549, 197, 3, 97, "Text"],
Cell[18734, 554, 4248, 121, 349, "Input"],
Cell[22985, 677, 1403, 31, 99, "Text"],
Cell[24391, 710, 684, 12, 64, "Input"],
Cell[25078, 724, 1085, 23, 246, "Text"],
Cell[26166, 749, 191, 5, 64, "Input"],
Cell[26360, 756, 358, 10, 99, "Text"],
Cell[26721, 768, 642, 15, 147, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
