(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    213590,       3517]
NotebookOptionsPosition[    210043,       3416]
NotebookOutlinePosition[    210486,       3433]
CellTagsIndexPosition[    210443,       3430]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
P\:0159evod do Fourierovy \:0159ady + HUS\
\>", "Title",
 CellChangeTimes->{{3.4920229805*^9, 3.49202300578125*^9}, {
  3.4920230615625*^9, 3.492023062703125*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell[TextData[{
 "V tomto notebooku demonstrujeme dva p\:0159\[IAcute]stupy \
\:0159e\[SHacek]en\[IAcute] jednoduch\[EAcute]ho obvodu:\n1) Klasick\[EAcute] \
\:0159e\[SHacek]en\[IAcute] pomoc\[IAcute] diferenci\[AAcute]ln\[IAcute]ch \
rovnic (",
 StyleBox["NDSolve", "Program",
  FontWeight->"Bold"],
 ")\n2) \:0158e\[SHacek]en\[IAcute] pomoc\[IAcute] rozkladu na sou\[CHacek]et \
harmonick\[YAcute]ch funkc\[IAcute] s n\[AAcute]slednou aplikac\[IAcute] HUS.\
\nPoznamenejme, \:017ee pro to, abychom mohli pou\:017e\[IAcute]t rozklad na \
sou\[CHacek]et harmonick\[YAcute]ch funkc\[IAcute], mus\[IAcute] m\[IAcute]t \
vstupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["periodick\[YAcute]",
  FontSlant->"Italic"],
 " pr\:016fb\:011bh."
}], "Text",
 CellChangeTimes->{{3.492023696171875*^9, 3.492023817796875*^9}, {
  3.49202385175*^9, 3.492023942140625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"NMaximize", "::", "\"\<cvmit\>\""}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<ncvb\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4622052014429674`*^9, 3.462205206934167*^9}, {
  3.467349761203125*^9, 3.467349765296875*^9}, {3.4685625505*^9, 
  3.46856257653125*^9}, {3.49202405909375*^9, 3.492024059453125*^9}, {
  3.561815638206737*^9, 3.561815638769237*^9}, {3.561815704456737*^9, 
  3.561815704831737*^9}}],

Cell[CellGroupData[{

Cell["Zad\[AAcute]n\[IAcute] obvodu", "Subtitle",
 CellChangeTimes->{{3.492024019484375*^9, 3.4920240240625*^9}},
 Background->GrayLevel[0.85]],

Cell["\<\
Uva\:017eujme RC \[CHacek]l\[AAcute]nek, co\:017e je zn\[AAcute]m\[YAcute] \
jednoduch\[YAcute] obvod, kter\[YAcute] jsme u\:017e \:0159e\[SHacek]ili.\
\>", "Text",
 CellChangeTimes->{{3.492023945390625*^9, 3.492023994984375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@000:PX0@0006`0002J0000W@4007T7000D1`00
5`D00;@=001B@@00mc/00215CDH00040::P00<L3000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
X`4009h4000i1`00@`H000000016000060<000`30015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000T@0000h00000Q30f`00003N000000000000B40200000P00008000000011
0P00000000024<3K000000000?l8@043T08008@200024<3KAP000000001Ec@Y404:TA03H2dAE]JM4
0>@9A02F[dAEc@Y4E@VcA:Zf2dBZO;I4Z/89A5G[]dAEZA14ENFhA02@5dAEgkU4ZUhRA5GU^4@053A4
ENFhA5G9ADAEiKQ404aUA5GU^4AEjGY4ENFhA5E3R4AEiKQ4ZQbDA5GO^DAE0i]4ENFhA03ZXDAEjkM4
ZU:TA:Yf]d@0c:I4E@VcA5E5ZD@0W:i4Z]2XA018XdBZbZU4EEFNA:[4ZTBZHYU4ECV[A03jUTBZ^:a4
ZWZEA00h[TAEni=402JaA5GkTdAEYK94ZWZEA:XT]4@0nYI4EIVdA:YRVDAETkE4EEFNA5F=]T@0B:=4
09jfA02L[T@0T[Q4E@VcA026^TBZM[M4E@^kA5G[]dBZK<54ENFhA03>adAEgkU40?kHA5Ga]TBZj]i4
ENFhA5GGi4AEfKY4oe7TA5E5`TAEenA4Z[k4A:YLiD@0><M4om_VA00hadAEjN54ZZc7A:[fg4AE8LQ4
EF_MA:Z/adBZB<M4ZZc7A00V/DBZ[<M404aUA:Z/adAE4CY4ZZc7A:[F3TBZ[<M4ZZHFA5DQb4AEc@Y4
ZZc7A03XoD<0><M4ZQ[`@jZbaTAE=NI3Z[k4A01@g4>Zb/94053L@eE;`DAEOMY30>BkA:ZZf4>ZO;I4
EJgB@jXdZDAEOMY304:TA5E=hT=ECim4Z[[o@eEEWT@0d0A4EEFNA:[22DAEEIi4Z/89A:[>X4AEc@Y4
04:TA0030`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`<30h<@4AE00@0@000010000000000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
<P0000000000000000000000000000009@0000`0000100009@0000`000050020E@0003@1002R0@00
W0@003T700141P00AP000:`R6E;^8]=CLB;3Ej`ROEWV8SMKJB;^Fb<TJecL9NQLT2Q[G?d/Jea[<F]L
BcU[G;<nJe`JA6]L1d[XG7Y=Jec]D>iK8U:dFeiCOEVKE4IGHEBLDMiD8dmKEJY<UEEeBeEF]TXDEoI9
ReSfBD]I]TX;FWE;AEZZC<9J8dloFiaAAe]6Ed5LOETkGKAKOUg^FjmPJecOHnQLMfaaFfi_JeaTLVEM
8G8KHFAbF6:WLYASIW>DHne`cf=dKPUT[Vk?HieScf>;F<mSBcW?Hgd^cf>^8lmSXRD9I:`Rcf>e7iAS
o1eBHklLF6:26eiQPQ^NH4PKjUd>6cMKCQZCE4PK6E927:1?l1lSCb`Q8dmY8R=?JB9PD:`R6E8U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0005@4001S0P00Q`H002`400000000AP0000P2003l0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00P940000>000008@`=/00000
gP000000000004Q00P000080000200000000@@80000000000Q30f`000000003o24030h01001d0@00
0Q30fbP000000000EQFHA5DY7D@0l:14ZQhLA:_j^TAE@AU4Ze[4A5DY7DB[^/e4EA4QA:^Xd4AEjBm4
03C@A03L=4AE_lm4Z/hiA03Pa4BZcSU4Zfc1A02h>TAFnKe4EJ4kA5Ko_4AE^CM4082kA02h>TB[0;Y4
Z[HmA02<^D@0U41409:hA5E]C4@0V;M4ZTIHA5J7]dCodgQ4EY>eA5GGP4AFWk=4ZTB5A:^/[TAEaH=4
ZkR/A5GGP4B[a:Y4Z]9kA5HoZTCo1fQ4ZlZYA:XRGT@0EZU4ECeDA:^h[4AEKDa4ZlZYA5FAATB[g:I4
EKE0A008WDBZ]Se4EQFHA02h>TB[8Y=4EKTgA5JkSD@0a3Q403b<A03L=4B[_8Y40?@`A:]6SDBZ3RM4
ZcZ?A:XV8dB[;Y54ZShOA:/jSd@0=1i4EQFHA5DY7D@00`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`>35D030100000400000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000000@0b0000
000000000000000000000000000U000030000040000U0000300000D0081E0000_0000584001R0P00
R0H002d4000X00000da39g1@02MfGDTV9V939mIV?BQ=J?<[4VP_;MQWK2iXHV`^[f2V;_ENhBihG^L]
^5fV;_ULIRnnG1d`@E`D<lAK2SJlFbdn`UYT@<QIVd9?Em]1EEIT@5]EkChHEOXigUB1=j=D23EEEQ@c
gUBM<FMC9S1lCVH_0dbV;XY9ibgFART^5TH_;EM5=BbLA[`YUTO2:918b2NFAhDW0da39bD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000X`4005L2000I0`00f@<0000000160000J04005`10015CDH[
:T0002@0000H00000020?`00080000200020?`000800002024040T@0000h00000Q30f`00003N0000
00000000B40200000P000080000000110P00000000024<3K000000000?l8@0D3h0000=@000024<3K
5P000000000]UCi4liLWA0EQ=dA<;B94m/8EA:]25TC=<@Q4;cTGA4Q1mD>c;aQ4YAGQ@f677dAmhMU3
JB4]A5F]dT=b^cY4bXoK@n@NGTBi[nA30A=YA:O?kD<N1gA4^IL4A5KEMDC=<@Q4N9a^A>7;2dBJHfM4
YOd0A1>VATC=<@Q4;H0mA?EU3dA7FSA40jLZA2FC>dCbaS=4]_HgA>3V?4A7FSA4ELU5A9T2;D@]UCi4
liLWA0030`<30`<30`<30`<30`<30`<30h<001E01@0@0000100000@0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040<P0000000000000000000000000000009@0000`0000100009@0000`000050020
E@0007@0002R0@00EP8001X3003J0`005P0009h_gRWA;H@XJBF99@DRabFQ7P@V6acJ9cDK@B]>6ZL^
JQ^0=hhL?CZb7OXl7R5^?@DRX3_[8]4i>22R<@DRFBoB8`l]XR[M;^X/mRdb;`l]Jc4i:ih_gRTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0007l1003Y0`00N@800>8400000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q01P>@0000Q000008@`=/=0000
0000003XoD>[dW]4Xd7M@j_BNdB[b/9358N4A:_:`T>[/8a4Zl[2@d;JU4BS@Me307RKA03XoD<0N9]4
;dL?A01hVdB[PQa4@]ZDA:^274B[/8a4Zh8LA1B7Q4@_A`m4Zm9kA03XoD>[dW]400<30`<30`<30`<3
P`0001A01X0@000010000?oooolQ000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0002L0000H00000@000000003oool0000002D0000<00000@0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@000;DOkCjQ6ndnDQPl@U8HDDIB66I:
XA^dCKDO]4g:8kA=6BMVBQTWDDHI9ca2bR?]?[DOkChl0000200003h0000H0000Q@400>h3001b0P00
g0@001<0000<00000@0002D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0004H0001T0000F00004E=AR/8@0L2A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE01P0@0000100000L0000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000010<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000O@400>L3001i0P00
h`@000d0002e7ndnXA_]?U8H?49B6556DQQVBZ4K]4fe7kA=bR>dCATWITXI9e566BLl@/XSkCje7ndn
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000DP00070100020000J_ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^000000000000002<B1P10@000000000000000000000000000000
1`0008SeTP3DcI80Z5SV<8a8605/2QP15000052h4`000000O6dH0@4000010000D;PC04N9k3000000
O6dH0@00003DcI80a4TH0@00001lKAP1H00005bh4`1/F>H`0@0000000002000090lH0N2h4`08hI80
00000000003oooooB93/<?B:605lKAP1c;TC0040000ed`4`4;hC0000002`HaP11@@H0@D4607AO0d`
E@0000D4604001<000000000000/^A<000000000001lKAP1;;TC05j=k31lKAP1000001Bi4`0T^A<0
00000>1C605/2QP1I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000000V@9D0000E0000<H1000G1000<@800<0400010000EED7@GI01d760@00W@@00040001<0000
0000000000000000oooooooooom@0000E@0006`0000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P000?D1002e0P000`800?H300000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0208h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o24090b`0000P00000Q30f`8000000000
0>Sm@eFaNd@0j?e3Z]h^A0010H4E@0T0400000@0000800008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
m0400;<200030P00mP<00080002e7nDn]An`:bD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
m@400=@400030P005@H0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240:0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@0/3;000020000024<3K0P0000000000j?e30<31A03XoD=EIi]40041PAE02`0@0000
100000X0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E`0002@0003d0@00d`@000<2000E1P000P000;DOf62e7ja=
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80003e0@00]@8005d700330P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0`2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q03@</00008000008@`=/20000
0000003XoD>[gRi4ol?ZA000;d@00@615D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081G0000
90000?@1002c0P00G@L00<<200020000]An`:eYe^2/U0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000?D100071P00G@L001D600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q03P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240?0b`0000P00000Q30f`80000000000>Sm@`30`DCo`nY40<31A0010H4E@0l0
400000@0000>00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000m04000H6001M1`005@H00080002e7mQP
FWGHH2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000=`L009d2001d1`00fP80000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240@0i0000240000
0Q30f`d000000000Z[_ZA:/2:DCD6>U4Z`8YA5G5idBXZB]4ELGWA5K_;TAEaNM40cDbA=@HjD@0g3A4
Z[_ZA03L=4B1G^a40=`dA02bkD@3=C940;;]A5K_;T@0/^e4Z:T[A85Nk4B[0RU4Z[_ZA:/2:D@00`<3
0`<30`<30`>3P@20540@P10000040000ooooob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000
D000000000000000ooooooooool=0000EWDi:XEd>B[KLn<Zfg>d:m]cQRb5M2l]EWD_;BQf;bgAMXH/
dGJd:m5fhbXXMSTZEWDi:S`000080000?P0001P0000m1`00X`8006h7003C0P004`0000`000010000
9@0000`000000020900002@00000081100000000000008110000000000020000AP0006@0001H0000
ADe6:`Q04@940000>000008@`=/00000gP000000000004Q10P000080000200000000@@8000000000
0Q30f`00002I003o5D0@0100000400004@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000040b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@000500000f1`00W08007D7003K0P003@0005Ie>BZ5M3TZ
fg?S:]]c]2_KLhH/QG@_;EIe;bdXMRl]dGJ6;=5f]2_AM^<Z:7Hi:UIe>BXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0003L7003`1@00M0L002d600000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q04P>@0000Q000008@`=/=000000000:ZkjT@0d[i4
e1SYA03B_TAEaNM4ObG0A5G5idAEb<54ELGWA2a[`dCD6>U4Zkk4A:ZkjTB[_/A4PEk/A:^na4@0/^e4
;6_3A02bkDAEb<540;;]A7lU`4B1G^a40=:nA:ZkjT@0d[i400<30`<30`<30`<3Ph4NA1A04X0@0000
10000?oooolQ000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0002D0000<00000@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo
3@0005IeHEn5M65Ofg<;H=]cgF3KLjiQQGAHHUIeF68XMUQRdGJ^HM5fgF3AMP]P:7IQGeIeHEll0000
200003h0000H0000?@L00?H5001^1`009PH001<0000<00000@0002D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@1<2A00003P000024<3K
00000=h0000000000018@@80000200000P000000044200000000008@`=/00000V@00oaE04P0@0000
100001<0000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000010<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0001@0000=PL00>h5001e1`00;@H000d0001FMF5OQGAQGm]c2f3KLmePfg>^HHEdF69FMEQR
:7IHH]5f[V7AM]ePdGH;H2QfHEmFMF5O9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000h0@00
^`<007D1000@1@00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@1@2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000003oo`Q05@</0000
8000008@`=/200000000000HZd<0f6m401R[@eE3XD@00@615D0E010000040000500002P0000<0000
0@00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000B0@0@000000000?l00000000000000000000U0000
30000040000W00006000008000000000o`000000000U000030000080000C000030000080000k0000
200001/0000@0000WQD00>hk001I0000:000000000000000ooooooooool30000WQDED1TE5E0I5Nhk
?@0000P0000K000040000><F003MC@00F@0002@00000000000000?oooooooooo0P0005/EWU3D4me=
F00003@00000000000000?oooooooooo1P000<8C_Dg>4iA=kQ>3C@hDLDdg57a=B1BLCET0000X0000
00000000003oooooooooo`<0002F5OA?8AGdCflFW4eH0000=000000000000000ooooooooool60000
P1IlCJTFLDg95X==jAJDCODF_DgS5]e=?@0000P0000l0000200003l0000H0000>P400;d3001a0@00
30D001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000V@0001d4003U0@00
]@@0000000160000500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0
B`4007/2002<B1P1000C0>Bf4`14HaP13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00000a_0400980V6EC<31V60430000U;LC0:lB0S0]01<0=M<1<12n4`000000
/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S0F5P41;@0C000000130000T@D2<<Rh4`1lKAP1
C<jB01bh4`1RO0X`@QX:BA2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005@0002J0000=0@00</0002U10000@0005EE1d5f@0M1
VP0008h400010000C00000000000000000000?ooooooooooD00007D0000b00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`1;0@00
N`8008a860400640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
6;LC0000002h095lj<TI0>Bg4`11095lB0LE05d0TGa26PY:l<TI0?396@000000/6<H0@00002HIE<`
P;PC07a`BC000000000C00000S0F5P41;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1
@QX:BB00000>008`0?SoofAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0g?lK02D00010haL0
000:020X003H]`40100002Rg4`2c627/I7H02000000U000030000040000F0000300001P0000B0000
30000040000H000030000?l0009D0000E0000<`0000d1000k0000:D400010000EED7@GI01d7<0000
SP@00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC04/1001k0P00
S4PH0@004`11095lB0LE05d0TGa26PY:l<TI0?396@000000/6<H0@00002HIE<`P;PC07a`BC0H]a<0
00000;P0TGcXbAT0i;LC0440TGa81aD0G@2AO48J2T_`bAT0l<TI0000001@I1P1@QX:BB00000>008`
0?SoofAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0g?lK03GC0C0@_Q<000000?1T607H]`40
800002Rg4`2c627/I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@3d0A`09@00043S5`0000X0
>2X00=Rg0@040000:;LC0;<H8NaTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000k@0003@4000:0@00Y@@00040001EE@M1MT07@Nd0002>1000
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0B`4007/2002<B1P1
000C0440TGa81aD0G@2AO48J2T_`bAT0l<TI0000001@I1P1@QX:BB00000>008`0?SooaRg4`000000
^02AO>S96@3T]a<0@@2AO4P75@1M095l@QX:C?396@3`bAT000000?1T607H]`40800002Rg4`2c627/
I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@3d0A`0=M<1<12n4`000000T6DH0MRg0@0P0000
:;LC0;<H8NaTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E00`4700U0000@><G00002P1@;000
f;L100@0000X]a<0/aPQk6Af00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@000090@00=0@002T1002U10000@0005EE1d5f@0M12@4008h400010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`8000160`00iP4003@4001n0P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`2`0000DP4008a8604001<0
i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
03bl0@00TP2HIE<`D6@H0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0
O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]607DcI807;PC069l2S1J50[G
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000000009D0000E00009d3003m0@00fP<006h200010000EED7@GI01d6N0`00E`800040001<0000
0000000000000000oooooooooom@0000DP0003d0000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P0002P300260P00D@@00?8200000000AP0005P0001<0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Y0080T000060000?ooool10000
ZlI;A:XV8dBZZXe3F9Fm@RP0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00002000000000?ooo`0000009@0000`000020000
9@0000`000080020EP000300000^0`00S08004X4003[0P001@000>Xb`RSZ<Zl^WdB_;Ym4`RSZ</8X
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
AP0009`0002@0000ADe6:`Q05P900000=000008@`=/00000eP000000000004Q10P00008000000011
0P00000000024<3K000009T00?l8@1L3?000030000024<3K10000000002[aT]4EMTjA01>RDAEfCY4
04j9A:XV8dB[aT]4ZRHSA0010H4E@1L0400000@0000F0000>P0000`000080000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000P0@380000
00000000V@00000000000000000U000030000040000U0000300000D0081F0000;0000?@2001B0P00
Q0@002D300040000jS:_;Ym4[bjOA<8XjS;2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@0003X0000<00002P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<200004PD00404003Y1@00R@@0000000160000:00001`00017A4U30P00018500101000
j@D005X400000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0608h0000;000008@`=/00000V000000000000<Q10P000000044000000Q30f`00002I003o
240I0b`0000P00000Q30f`80000000000=jSA5FQRD@0P;]4EJ69A0010H4E@1T0400000@0000H0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P0000000000081090100000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5L0000T000040D003l4003Y1@00F`@00080003WDLU4^5g9A2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<200004PD006l4003Y1@00R@@0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240J0SP0000/00000Q30f`00002H0000
00000000b44200000000@@0000024<3K000009T00?l8@1/3;000020000024<3K0P0000000000gZ=4
08j?A020^d@0SXm400430aE06`0@0000100001X0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000100009@0000`000050020E`0002@0000@1@00
KP@00>T5002:10000P000>MA_dNhGKm79@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000B1@00
@0@00>T5001J1000000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@1T0400000@0000H00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T000040D003l4003Y1@00
F`@00080003WDLU4^5g9A2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<200004PD006l4003Y1@00
R@@0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0K0100000400006P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000040000U0000300000D0081G000090000105001^1000j@D008X400020000
ie6oAkQM_dLU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0007L5002e0P00Q0D005@400000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0708h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240M0b`0000P0000
0Q30f`8000000000EKN_A000;dAE]jm40;:9A0010`<E@1d0400000@0000L00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000@0002D0000<0000
1@00P5L0000T0000MPD00;@200251@00E@@00080003DEkP[e5OAA2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000M`D007H400241@005@H0000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240N0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@1l3;000020000024<3K0P000000001E]jm408j?A5Fg[d@0`<54
0041PAE07`0@0000100001h0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0001f1@00M0@008D5000E1P00
0P000=AG_dODEmQP9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001O1@00l0D009`5000]1P00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@203
T00008@000024<3K3@0000000000[jm40=:nA2X<[T@0d[i4ZkR/A7lU`4B[^:a4ELS1A:^h[4@/Jl=4
:Pb^A:^na4@0[jm4Zkk4A=MA/DB[_/A4EZFbA2a[`dAFYK94ELS1A5JU/TAo9L14ee6aA03B_T@0[jm4
0=:nA0030`<30`<30`<30h>114DD@220400000@0002I003o:00000`0000200008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000
002I0000000U000030000080000C000030000040000k0000200005D0001@000000000000003ooooo
ooooo`d0003@Ef5OoeIQGeEF2f1EE]ePEEJ^HOmFF6;@EeQRXEQHHT]I[V5;FMePBeT;H:5HHEo@Ef5O
?00000P0000n0000600006D5003f1@00U@D002H6000C000030000040000U000030000000080T0000
90000000P440000000000000P44000000000008000160000I00005P00015CDH[240Q0T@0000h0000
0Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K000009T00?lE@200
400000@0000Q0000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000000@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000D00005h5003^1@00W0D002d6000=0000d5MQGomFHEmEEP]PEEKMH5EF[V7oEUQR
d5MHHZ5HF69;FJiQBeWMH4]I2f2QF65Od5MQGbD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
G`D009d2002L1@00fP80000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240R0i00002400000Q30f`d0000000000:n_A:/2:D@Z3:i4Z`8YA:^h[4BXZB]4
ZkR/A5K_;TB[^:a40cDbA2X<[T@0g3A40:n_A03L=4CGDK540=`dA5JU/T@3=C94EZFbA5K_;TAFYK94
Z:T[A=MA/DB[0RU40:n_A:/2:D@00`<30`<30`<30`>3_a<0540RP10000040000V@00ob4000080000
HP0000`000010000900002@00000080m000000000000080m00000000000200009@0000`000020000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000d5Li:_mF>BYEE^<Z
EEJd:eEFQRcoERl]d5L_;J5H;be;FHH/BeVd:d]IhbZQF3TZd5Li:S`000080000?P0001P0001U1@00
X`8009D5003C0P004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q08`940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0R0100000400008`0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000100009@0000`000050020E@000500001N1@00
W08009`5003K0P003@000=1G>B[oESTZEEKS:UEF]2]EEXH/oeH_;M1G;bfQF2l]BeV6;4]I]2];FN<Z
XEPi:]1G>BXU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0004T4000E1000>0D00:d400000000
AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0j;XC0;00001B0@00
S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000004<00000MK`1002B09QUDc1@I1P10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000
V6EC<82h4`1lL4T`000000004`0j208`5QH10Bd04`000000@`0009450S38^1<0O6dH0MC=TP0L^1<0
HW`:<5XD2^D@_Q<03P02<03hoomTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000000000U@0001D0000W`@002`4003S1000W@@00040001EE@M1MT07@Il400261000
0@0004`00000000000000000003ooooooooooe0000130000@`0001H0000<0000000002D0000<0000
3P00P2P0000<00000@0004H0000X0000700004M4BD<20000S08001H3003]0P00[0D0000000160000
@04003@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240T0Z@0002H0000
0Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010@024<3K00000000ool8@2D3F00004`000024<3K1`000000000h:2U4
EI56A:Ik<d@V=eE4EQ4jA9ISM4AF4CY46e2;A5HA>TAD;Ia4/J`cA4jDZd@NU2U4E@VcA0030`<30`<3
5D0U010000040000900002P0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000W00006000004000000000o`000000000U0000
30000040000C000030000080000k0000200001/0000@0000NbX007Pa001I0000:040000000000000
oooooooooom30000^2[C<ODZ=S9Z:`dcfB_j<d0/oCBQ;14fnb`i=dh]LCRH;KXig2dA>aL^MCa:;^Dm
M2iP?iD^iD2];W92^bh6A<0^XDFk;SA7[Bk3B9H^BTYf;/Y;CBi0CA`^ZdkR;@a@XRePDEP]YE88;M]C
/B`1EE</5UK^:aMGPB/5F0h[gUSL:RmIJb[YF9TZWeP8:liGLB_VE]@[jeDb;=aDQbbjDmH/R58O;DMA
GbggCiL]VTk8;C5=lBfoBa4^@dXX;[i8=RhcAc/^XTDf;P]4:2ik@Q0^l43_;FloaBgg?I@]RSaI;BXk
5RgG>Ld/U3Ql;60g92`n=/D[;SEP:c<dmBY<<h@ZOC99:Qhb32[3<Cd0000800006`000100000K;@00
meL005T0000T000000000000003oooooooooo`80001K:X5IPBYKEUP0000d000000000000003ooooo
ooooo`H00022:SMFXRXJE/HZ75K[:QiF22/mEPH[HEII0000:000000000000000ooooooooool30000
iRX?FH<ZdUSJ;8=GF00003@00000000000000?oooooooooo1P000?X/LELS;GaG=BfLEdL]_5Lk;NEG
6bggEcd000080000?00000P0000o0000600009l2000F0`00kP8009X5000C000030000040000U0000
30000000080U0000300000L0080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0000d6000F0`00KPH00:`500000000AP000401000d0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q09P:T0000V000008@`=/00000
W1000000001EE@E1o`00008000000011000006@000024<3K00000080000200000020?`8000020000
000000008440080o0000000000000000000002P000024<3K0`00000P00000210002``0000000082o
000P`000/<000@400Q30f`0000000?oo240W0eP0001<00000Q30f`L000000000al34A5FAATAnj/U4
9SMEA5DecDBFHgA4ECG=A1]@RdAE=Le4E2fLA0<3bTA>U:]4^OK4A5D9/d@00`<30`<30aE09`0@0000
100002H0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000004P4040000000003o00000000000000000000
9@0000`0000200009@0000`0000100004`0000`000020000>`0000P0000K00004000095R001h<@00
F@0002P10000000000000?oooooooooo@`000<iRdc4;HcHbP6<=<nmSnS=GI?dd^6@A=Q9U>CMUIG4h
[fFj>O9U4C/]IWDlH6KU?HYVH3n[I^E0`VIc@]5V1TCFIZ55dFHdAl=V`dR/ITY:S6K:Bf=V@4dcIZ]>
nFD<D;QUH55^IJEB7fGKDlMT0UEYI1IF16@GEiQS1EPUHmiHlf8_FH9RjER`HYmH7f?>EhMSiUKZHn]E
B6CKE9iT^U?/I8QB=FE7DGIUmdn^IIY>gVDaC@MV_d/WIT=:?VJnB4aV<dMAIZ95C6H;A3eVNT8VI_10
1FI_?m]UmcfZIHXlKfDZ>beUecWTI9@hTfAP=c]T?SKLHbheMV<c=0]SC3>JHWdbGf8N<R9R`c4m0000
200001/0000@0000<VD00?MG001I00009000000000000000ooooooooool20000LV:1FIQRFeIH0000
=000000000000000ooooooooool60000VF8gE[UR6UKMHQaF0V<NEQmS?EHMHf5FF@0002P000000000
00000?oooooooooo0`000?eR3eVJH]9HlFB3EeP0000d000000000000003oooooooooo`H0000AIG5G
>VElEdaUW5MNIKaGDVGUEc9UmeLm0000200003`000080000?`0001P0000P1P005P<006l6002J1@00
4`0000`0000100009@0000`0000000209@0000`000070020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003W0P007@@003@4002e1000
000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@00
1`8008a8604001<0i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C00000013000004hS2`00TP2HIE<`d6HH0@40002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1
000009QUDc20^1<0O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]605dcY80
7;PC069l2S126PY/4;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B0000
30000040000H000030000?l0009D0000E00000H3000d1000=`<00:D400010000EED7@GI01d460`00
SP@00040001<00000000000000000000oooooooooom@0000M@000380000F000030000000000U0000
300000h0080X000030000080001B0000L0400080002moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00
S4PH0@00H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<0
00000;P0TGc8bAT0i;LC0440TGa81aD0G@2AO48J2Vg@bAT0d<TI0000002`HaP1000009QUDc20^1<0
O719<000000001<00002<1HF0@4]01<0000004<0002A1@8`b;PC03GC0C0@_Q<00000051T60526PY/
800000h00S00n?ooI7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@1@M2409@00043S5`0000X0
75D00=Rg0@040000:;LC0;<H8NaTMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000>0<006/4001I0`00]P@00040001EE@M1MT07@CP3002W1000
0@0004`00000000000000000003ooooooooooe00000a00008P0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0440TGa81aD0G@2AO48J2Vg@bAT0d<TI0000002`HaP1000009QUDc20^1<0O719<1Rg4`000000
^02AO<S96@3T]a<0@@2AO4P75@1M095l@QX:K]396@3@bAT00000051T60526PY/800000h00S00n?oo
I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@1@M240=M<1<12n4`000000l6@H0MRg0@0P0000
:;LC0;<H8NaTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E06Qf8@0U0000@><G00002P0dE`00
f;L100@0000X]a<0/aPQk6Af00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0001J0`00=0@007X3002U10000@0005EE1d5f@0M1FP<008h400010000
C00000000000000000000?ooooooooooD00002P0000Q00005P0000`0000000009@0000`0000>0020
:00000`000020000DP00070100020000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0
@@2AO4P75@1M095l@QX:K]396@3@bAT00000051T60526PY/800000h00S00n?oo6;LC0000002h095l
b<TI0>Bg4`11095lB0LE05d0TGa26PY_d<TI0=396@000000l6@H0MRg0@0P0000:;LC0;<H8NaTMP08
000000000S10haL0a;LC05iJlgO4]a<0000E06Qf8@0ed`4`4;hC0000002@IAP1f;L10200000X]a<0
/aPQk6Af00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0P7PQ02D00010haL0000:04aI003H]`40
100002Rg4`2c627/I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000?l0009D0000E00007/3000d1000V0<00:D400010000EED7@GI01d5k0`00SP@00040001<0000
0000000000000000oooooooooom@0000M00001`0000F000030000000000U0000300000h0080X0000
30000080001B0000L0400080002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`11095l
B0LE05d0TGa26PY_d<TI0=396@000000l6@H0MRg0@0P0000:;LC0;<H8N`H]a<000000;P0TGc8bAT0
i;LC0440TGa81aD0G@2AO48J2W3@bAT0d<TI0000002@IAP1f;L10200000X]a<0/aPQk6Af00P00000
0002<43S5`34]a<0GU[cMlBg4`0001D0P7PQ03GC0C0@_Q<00000031V607H]`40800002Rg4`2c627/
I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@2HNR409@00043S5`0000X0I5/00=Rg0@040000
:;LC0;<H8NaTMP08000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001D0000U`<003@4002g0`00Y@@00040001EE@M1MT07@IL3002>10000@0004`000000000
00000000003ooooooooooe00000Y00008@0001H0000<0000000002D0000<00003P00P2P0000<0000
0P0004H0000X0000700004M4BD<20000J@H001D4002e1`00[@@0000000160000500000P00017A4U3
0`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0>Bf4`14HaP1
3P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`0000278`/00980
V6EC<=1V60410000U;LC0:lB0S0]01<0=M<1<12n4`000000/6<H0@00002HIE<`P;PC07a`BC000000
000C03X80S0F5P41;@0C000000130000T@D2<<Rh4`1lKAP1M<jB01bh4`1RO0X`FQ@:oQ2n4`0>008`
0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002
E00005@000281P00;0@00;T6002M10000@0005EE1d5f@0M1R0H008H400010000C000000000000000
00000?ooooooooooD00007D0000b00005P0000`0000000009@0000`0000>0020:00000`000020000
DP00070100020000_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a860400640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095lb<TI0>Bg4`11095l
B0LE05d0TGaJ50[od<TI0=396@000000/6<H0@00002HIE<`P;PC07a`BC000000000C00000S0F5P41
;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1FQ@:oR00000>008`0?SoofAf00P00000
>PP2<43S5`34]a<0GU[cMlBg4`0001D017lQ02D00010haL0000:0=1O003H]`40100002Rg4`2c627/
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000;X6001S1000f`H00:h400010000EED7@GI01d6j1P00W`@00040001<00000000000000000000
oooooooooom@0000<P000280000F000030000000000U0000300000h0080X000030000080001B0000
L0400080002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGaJ50[o
d<TI0=396@000000/6<H0@00002HIE<`P;PC07a`BC0H]a<000000;P0TGc8bAT0i;LC0440TGa81aD0
G@2AO5XD2P3@bAT0d<TI0000001@I1P1FQ@:oR00000>008`0?SoofAf00P000000002<43S5`34]a<0
GU[cMlBg4`0001D017lQ03GC0C0@_Q<000000?1T607H]`40800002Rg4`2c627/I7H02000000j208`
@><G0<Bg4`1NF_=ga;LC00005@0LPB409@00043S5`0000X0j6400=Rg0@040000:;LC0;<H8NaTMP08
000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
g0H002`4003l1P00W@@00040001EE@M1MT07@M`6002610000@0004`00000000000000000003ooooo
oooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO5XD2P3@bAT0
d<TI0000001@I1P1FQ@:oR00000>008`0?SooaRg4`000000^02AO<S96@3T]a<0@@2AO4P75@1M095l
FQ@:0M396@3@bAT000000?1T607H]`40800002Rg4`2c627/I7H020000000008`@><G0<Bg4`1NF_=g
a;LC00005@0LPB40=M<1<12n4`000000T6DH0MRg0@0P0000:;LC0;<H8NaTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E03B38@0U0000@><G00002P00I000f;L100@0000X]a<0/aPQk6Af00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0003m1P00
;0@001X7002M10000@0005EE1d5f@0M1o@H008H400010000C00000000000000000000?oooooooooo
D00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000020000DP00070100020000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095lFQ@:0M396@3@bAT0
00000?1T607H]`40800002Rg4`2c627/6;LC0000002h095lb<TI0>Bg4`11095lB0LE05d0TGaJ50X2
d<TI0=396@000000T6DH0MRg0@0P0000:;LC0;<H8NaTMP08000000000S10haL0a;LC05iJlgO4]a<0
000E03B38@0ed`4`4;hC0000000`IQP1f;L10200000X]a<0/aPQk6Af00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D0C8DQ02D00010haL0000:01QV003H]`40100002Rg4`2c627/I7H02000000U0000
30000080000F0000300001P0000B000030000040000H000030000?l0009D0000E00001T7000/1000
>@L009d400010000EED7@GI01d4I1`00QP@00040001<00000000000000000000oooooooooom@0000
:@000240000F000030000000000U0000300000h0080X00003000008000160000:00001`00017A4U3
0P0004h6001b0P00;0L00:L200000000AP0001@100080@00ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0:0:T0000V000008@`=/00000W1000000001EE@E1o`00008000000011
000006@000024<3K0000004000020000002@@00000000000000000008440080o0000000000000000
000002P000024<3K0`00000P00000210002P`00000000000000P`000X<000H400Q30f`000000V@3o
240Y0b`0000P00000Q30f`8000000000EDO:A:/V8dAEenA4ZbHSA0010`<E@2T0400000@0000X0000
:00000`0000100008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P000000000018101000000000009T0000000000000
000002D0000<00000@0002L0000H00000P0000000000V@00000002D0000<00000P0001<0000<0000
0P0005/0001<0000D0H007D2000X1`00X`800080000900001@0000@0000LIGlX371o:0a`1BTLI@DY
76Eo:<U_MBMTL/8XbFl?:/U_MBLC000030000040000U000030000000080U0000300000L0080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0001`5003n0P00D@D00=d300000000AP0001@100080@00ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0:P:T0000V000008@`=/00000W1000000001EE@E1o`00008000000011
000006@000024<3K0000004000020000002@@00000000000000000008440080o0000000000000000
000002P000024<3K0`00000P00000210002P`00000000000000P`000X<000H610Q30f`000000V@3o
240[0b`0000P00000Q30f`80000000000<bVA5Fe@4@0c:I4EMEeA0010H4E@2/0400000@0000Z0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P000000000018101000000000009T0000000000000000002D0000<0000
0@0002D0000<00000P0001<0000<00000P0005/0001<00007`D00003001=1@00f@<0008000090000
1@0000@0002QDbH`XE<F>aaC5S/LDbH`XE<V<:aDdcYNDfhm4E;C>ZaDdcXC000030000040000U0000
30000000080U0000300000L0080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0000l2001b0P00kP800:L200000000AP0001@100080@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0;0:T0000V000008@`=/00000
W1000000001EE@E1o`00008000000011000006@000024<3K0000004000020000002@@00000000000
000000008440080o0000000000000000000002P000024<3K0`00000P00000210002P`00000000000
000P`000X<000H400Q30f`000000V@3o240]0b`0000P00000Q30f`8000000000EO44A:/V8dAE4CY4
ZbHSA0010H4E@2d0400000@0000/00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000181010000000000
09T0000000000000000002D0000<00000@0002D0000<00000P0001<0000<00000P0005/0001<0000
4@8007D2003Z0P00X`800080000900001@0000@0000e8GlX9Bao:2D/1BTe8@DY=B5o:>8[MBMm;/8X
hR/?:^8[MBLC000030000040000U000030000000080U0000300000L0080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0009X1003m0P00
c`400=`300000000AP0001@100080@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0;P:T0000V000008@`=/00000W1000000001EE@E1o`00008000000011000006@000024<3K
0000004000020000002@@00000000000000000008440080o0000000000000000000002P000024<3K
0`00000P00000210002P`00000000000000P`000X<000H610Q30f`000000V@3o240_0b`0000P0000
0Q30f`8000000000EGgJ@eGEMDAEOMY3EKE0A0010H4E@2l0400000@0000^00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P000000000018101000000000009T0000000000000000002D0000<00000@0002D0000<0000
0P0001<0000<00000P0005/0001<0000WP400003003;0@00f@<00080000900001@0000@000056fhm
1A]n<X/KOS:;6fhm1A]^?O/I`3986bH`UAc0<_/I`38C000030000040000U000030000000080U0000
300000L0080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000><1003N0@00<0<007H200000000AP0001@000080000AdA9@`<0001B0000
L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0A6<H0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000TR<;002B09QUDc3@IQP1
0@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`000000004`0j208`
5QH10Bd04`000000@`0009450S38^1<0O6dH0GC>TP0L^1<0HW`:<48J2X/@_Q<03P02<03hoomTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000
>0800?D1001C0P00IP800040001EE@M1MT07@CP2001?0P000@0004`00000000000000000003ooooo
oooooe00001Y0000700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@000;goool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO>S96@3T]a<0@@2AO4P75@1M095l
@QX:S?396@3`bAT000000;1S60400000V6EC<82h4`1lL4T`000000004`00008`5QH10Bd04`000000
@`0009450S38^1<0=M<1<12n4`000000D6@H0D8J2X/P00003P02<03hoomTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E08bD8@0U0000@><G00002P1HM@00f;L100@0000X]a<0/aPQk6Af00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0001C0P00
;08007`2001g0P000@0005EE1d5f@0M1E08006P200010000C00000000000000000000?oooooooooo
D0000580000Y00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l@QX:S?396@3`bAT0
00000;1S60400000V6EC<82h4`1lL4T`6;LC0000002h095lj<TI0>Bg4`11095lB0LE05d0TGa26PZ=
l<TI0?396@000000D6@H0D8J2X/P00003P02<03hoomTMP08000000000S10haL0a;LC05iJlgO4]a<0
000E08bD8@0ed`4`4;hC0000003`I1P1f;L10200000X]a<0/aPQk6Af00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D0Y9HQ02D00010haL0000:071g003H]`40100002Rg4`2c627/I7H02000000U0000
30000040000F0000300001P0000B000030000040000H00003000002I009D0000E00007d2003e0@00
W@8006H200010000EED7@GI01d5m0P00C`800040001<00000000000000000000oooooooooom@0000
:0000240000F000030000000000U0000300000h0080X000030000040001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000040000
00000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGa26PZ=l<TI0?396@000000
D6@H0D8J2X/P00003P02<03hoolH]a<000000;P0TGcXbAT0i;LC0440TGa81aD0G@2AO48J2Xk`bAT0
l<TI0000003`I1P1f;L10200000X]a<0/aPQk6Af00P000000002<43S5`34]a<0GU[cMlBg4`0001D0
Y9HQ03GC0C0@_Q<00000091U607H]`40800002Rg4`2c627/I7H02000000j208`@><G0<Bg4`1NF_=g
a;LC00005@2lV2409@00043S5`0000X0R7T00=Rg0@040000:;LC0;<H8NaTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000WP800?D1002k0P00
IP800040001EE@M1MT07@Ih2001?0P000@0004`00000000000000000003ooooooooooe00001d0000
700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO48J2Xk`bAT0l<TI0000003`I1P1
f;L10200000X]a<0/aPQk1Rg4`000000^02AO>S96@3T]a<0@@2AO4P75@1M095l@QX:So396@3`bAT0
0000091U607H]`40800002Rg4`2c627/I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@2lV240
=M<1<12n4`000000<6HH0MRg0@0P0000:;LC0;<H8NaTMP08000003X80S10haL0a;LC05iJlgO4]a<0
000E0=BJ8@0U0000@><G00002P2PN`00f;L100@0000X]a<0/aPQk6Af00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002j0P00m@400=X2001V0P00
0@0005EE1d5f@0M1^P8004l200010000C00000000000000000000?ooooooooooD00002T0000Q0000
5P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000AdA9@`8000031000
4@<004l5002Y0`00000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000
S;XC0>Rj4`0>0@001`8008a8604001<0i;HC04AS604>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000009DS2`00TP2HIE<`d6HH0@40002D]a<0[a82<2d04`0ed`4`
4;hC0000002`HaP1000009QUDc20^1<0O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`
b;PC07a]605dcY807;PC069l2S1J50XM4;hC00h00S00n?ooI7H02000000U000030000040000F0000
300001P0000B000030000040000H00003000002I009D0000E00005D4000X0`00L0@009T300010000
EED7@GI01d5E1000PP<00040001<00000000000000000000oooooooooom@0000J@0001`0000F0000
30000000000U0000300000h0080X000030000040001B0000L0400040002moooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0
j;XC00h100070P00S4PH0@00H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C0000000H]a<000000;P0TGcXbAT0i;LC0440TGa81aD0G@2AO5XD2Qk`bAT0l<TI0000002`HaP1
000009QUDc20^1<0O719<000000001<00002<1HF0@4]01<0000004<0002A1@8`b;PC03GC0C0@_Q<0
0000051T605J50XM800000h00S00n?ooI7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@10Wb40
9@00043S5`0000X038000=Rg0@040000:;LC0;<H8NaTMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<000009T00U@0001D0000L@@005l3002N1000ZP<00040001EE@M1
MT07@G44002K0`000@0004`00000000000000000003ooooooooooe0000130000;@0001H0000<0000
000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
3P4000L2002<B1P1000C0440TGa81aD0G@2AO5XD2Qk`bAT0l<TI0000002`HaP1000009QUDc20^1<0
O719<1Rg4`000000^02AO>S96@3T]a<0@@2AO4P75@1M095lFQ@:7o396@3`bAT00000051T605J50XM
800000h00S00n?ooI7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@10Wb40=M<1<12n4`000000
l6@H0MRg0@0P0000:;LC0;<H8NaTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E05RQ8@0U0000
@><G00002P0TPP00f;L100@0000X]a<0/aPQk6Af00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`00000V@02E00005@0002N1000:0<00;h4002I0`000@0005EE1d5f@0M1
WP@0088300010000C00000000000000000000?ooooooooooD00002P0000Q00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@00
1`8008a8604001<0@@2AO4P75@1M095lFQ@:7o396@3`bAT00000051T605J50XM800000h00S00n?oo
6;LC0000002h095lj<TI0>Bg4`11095lB0LE05d0TGaJ50XPl<TI0?396@000000l6@H0MRg0@0P0000
:;LC0;<H8NaTMP08000000000S10haL0a;LC05iJlgO4]a<0000E05RQ8@0ed`4`4;hC0000002@IAP1
f;L10200000X]a<0/aPQk6Af00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0L:<Q02D00010haL0
000:03b4003H]`40100002Rg4`2c627/I7H02000000U000030000040000F0000300001P0000B0000
30000040000H00003000002I009D0000E0000;l4000X0`00g0@009T300010000EED7@GI01d6o1000
PP<00040001<00000000000000000000oooooooooom@0000M00001`0000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00
S4PH0@004`11095lB0LE05d0TGaJ50XPl<TI0?396@000000l6@H0MRg0@0P0000:;LC0;<H8N`H]a<0
00000;P0TGcXbAT0i;LC0440TGa81aD0G@2AO5XD2R7`bAT0l<TI0000002@IAP1f;L10200000X]a<0
/aPQk6Af00P000000002<43S5`34]a<0GU[cMlBg4`0001D0L:<Q03GC0C0@_Q<00000031V607H]`40
800002Rg4`2c627/I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@28YB409@00043S5`0000X0
E8H00=Rg0@040000:;LC0;<H8NaTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000009T00U@0001D0000f`@002P3003k1000V@<00040001EE@M1MT07@M/400220`00
0@0004`00000000000000000003ooooooooooe00000Y00008@0001H0000<0000000002D0000<0000
3P00P2P0000<00000@0004H0000X0000700004M4BD<20000V@000143003U0@00Z@<0000000160000
500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0>Bf4`14HaP13P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
@`00002^8`/00980V6EC<=1V60410000U;LC0:lB0S0]01<0=M<1<12n4`000000/6<H0@00002HIE<`
P;PC07a`BC000000000C03X80S0F5P41;@0C000000130000T@D2<<Rh4`1lKAP1M<jB01bh4`1RO0X`
@QX:YQ2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`00000V@02E00005@0003Z0000:0<000D1002I0`000@0005EE1d5f@0M1jP00088300010000
C00000000000000000000?ooooooooooD00006T0000L00005P0000`0000000009@0000`0000>0020
:00000`000010000DP00070100010000_Oooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a860400640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095l
j<TI0>Bg4`11095lB0LE05d0TGa26PZWl<TI0?396@000000/6<H0@00002HIE<`P;PC07a`BC000000
000C00000S0F5P41;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1@QX:YR00000>008`
0?SoofAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0m:TQ02D00010haL0000:0<2:003H]`40
100002Rg4`2c627/I7H02000000U000030000040000F0000300001P0000B000030000040000H0000
3000002I009D0000E00000H1001O0`00>`400:X300010000EED7@GI01d460@00V`<00040001<0000
0000000000000000oooooooooom@0000E@000300000F000030000000000U0000300000h0080X0000
30000040001B0000L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`11095l
B0LE05d0TGa26PZWl<TI0?396@000000/6<H0@00002HIE<`P;PC07a`BC0H]a<000000;P0TGcXbAT0
i;LC0440TGa81aD0G@2AO48J2ZS`bAT0l<TI0000001@I1P1@QX:YR00000>008`0?SoofAf00P00000
0002<43S5`34]a<0GU[cMlBg4`0001D0m:TQ03GC0C0@_Q<000000?1T607H]`40800002Rg4`2c627/
I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@0<[2409@00043S5`0000X0f8`00=Rg0@040000
:;LC0;<H8NaTMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
09T00U@0001D0000=P4002P3001F0@00V@<00040001EE@M1MT07@CH100220`000@0004`000000000
00000000003ooooooooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<0000
0@000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0
G@2AO48J2ZS`bAT0l<TI0000001@I1P1@QX:YR00000>008`0?SooaRg4`000000^02AO>S96@3T]a<0
@@2AO4P75@1M095l@QX:ZO396@3`bAT000000?1T607H]`40800002Rg4`2c627/I7H020000000008`
@><G0<Bg4`1NF_=ga;LC00005@0<[240=M<1<12n4`000000T6DH0MRg0@0P0000:;LC0;<H8NaTMP08
000003X80S10haL0a;LC05iJlgO4]a<0000E02B^8@0U0000@><G00002P3`SP00f;L100@0000X]a<0
/aPQk6Af00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02
E00005@0001G0@00:0<007@1002I0`000@0005EE1d5f@0M1E`40088300010000C000000000000000
00000?ooooooooooD00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000010000
DP00070100010000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l
@QX:ZO396@3`bAT000000?1T607H]`40800002Rg4`2c627/6;LC0000002h095lj<TI0>Bg4`11095l
B0LE05d0TGa26PZZl<TI0?396@000000T6DH0MRg0@0P0000:;LC0;<H8NaTMP08000000000S10haL0
a;LC05iJlgO4]a<0000E02B^8@0ed`4`4;hC0000000`IQP1f;L10200000X]a<0/aPQk6Af00P00000
>PP2<43S5`34]a<0GU[cMlBg4`0001D0?;0Q02D00010haL0000:00RA003H]`40100002Rg4`2c627/
I7H02000000U000030000040000F0000300001P0000B000030000040000H00003000002I009D0000
E00007<1000X0`00T`4009T300010000EED7@GI01d5c0@00PP<00040001<00000000000000000000
oooooooooom@0000:@000240000F000030000000000U0000300000h0080X00003000004000160000
:00001`00017A4U30P0000X6003N0@00E`L007H200000000AP0001@000080000AdA9@`<0001B0000
L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00001000000000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0A6<H0@h00S2moooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<00P0004<000008b<;002B09QUDc3`I1P1
2@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60420000V6EC<82h4`1lL4T`000000004`0j208`
5QH10Bd04`020000@`0009450S38^1<0O6dH0Oc=TP0L^1<0HW`:<5XD2S8@_Q<03P02<03hoomTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000
N@H00?D1002Z1P00IP800040001EE@M1MT07@GT6001?0P000@0004`00000000000000000003ooooo
oooooe00000`0000<P0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP00004000000000000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<00P0001Rg4`000000^02AO>S96@3T]a<0@@2AO4P75@1M095l
FQ@:<o396@3`bAT000000;1S60420000V6EC<82h4`1lL4T`000000004`00008`5QH10Bd04`020000
@`0009450S38^1<0=M<1<12n4`000000D6@H0EXD2S8P00003P02<03hoomTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E0:Rd8@0U0000@><G00002P1dU@00f;L100@0000X]a<0/aPQk6Af00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002U1P00
m@400>L6001V0P000@0005EE1d5f@0M1Z`H004l200010000C00000000000000000000?oooooooooo
D0000440000m00005P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000
AdA9@`80001F1000<0H00?84000D1`00000004H0000P0@00504004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@302A00003P000024<3K00000=h0000000000018@08000020000
0P000000044200000000008@`=/000000000o`Q0<@>H0000S000008@`=/>000000000;YhUTAnJ/a4
[MBJA6b3cDAElIe4T07BA5GaWDB[<mM4EO6MA;9;gDAi/iU4ZccRA5EhU4B[?>94n3b?A:/lhTAEohY4
/T_MA5GoRTB[<mM47?n:A=KDdDC1D8i4f3g=A6WKTTBlDla4E<>DA:oTaT@00`<30`<30`<30`<3P@00
5D0a010000040000<000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000000@0b00000000000000000000
00000000000U000030000040000U0000300000D0080k0000200001/0000@0000=D/002iV001H0000
C000000000000000ooooooooool<0000HdfjI_5>nFSaCY9[lDjNK]9<5g4eBQMaUdLGLGQ5WVihAI9[
N4GSJ257UfIVBB9V=P000100001JBP00Jf<003d000080000?00000P000100000600005@4000d1P00
lP@001@7000U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000000008a8604100000000000000000000
0000000000070000R?FB0=C=TP2XF>H`S4PH0F`:604D0000D;PC0000001lKAP10@000040001@^1<0
AhW/<000001lKAP100000=C=TP34BAP1000007a]604o0000G;PC06aHiS01000000000080000T3aP1
h;PC00SQTP00000000000?oooom8T>``m8XH0Ga]607<^A<00@0003GC0C0@_Q<000000;1S604911P1
2@@H0M5l3C0`00002@@H0@004`000000000002bi4`000000000007a]604/^A<0GXg/<7a]60400000
5;TC02Bi4`000000h5<H0F`:605TMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<0000CDe=0U@0001D0000R`@008D6002l1000mPH00040001EE@M1MT07@H/4003O1P00
0@0004`00000000000000000003ooooooooooe00000`0000<P0001H0000<0000000002D0000<0000
3P00P2P0000<00000@0004H0000X0000700004M4BD<20000P`400;H1000E0P00R080000000160000
804001@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240b0T@0000h0000
0Q30f`00003N000000000000B40200000P000080000000110P00000000024<3K000000000?l8@3<3
V00008`000024<3K3P0000000029GnA3m4HGA;]/dD>3_aI408S2@gVU3D@0R<93EYT2A028`T<RE>i3
kg7B@j_:fd<05>I3Zl[K@cVenD>[b]]30=04A29DkT<0d0A4EYT2A9C?14CAIP]4SPP0A?8m4dBQbo53
kB@FA0b0kD?>JR1400<30`<30`<30`<30h41PAE0<`0@000010000380000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040<P0000000000000000000000000000009@0000`0000100009@0000`000050020
>`0000P0000K0000400008@L003:9@00F00004`00000000000000?oooooooooo300002HJZ2E9668S
BARO84TH`ae76W8K^aab6blOLQ//8L<M;26O82`QdR;k7lPT<Qj29CH0000@0000Z1d001<X000m0000
200003`000080000@00001P000220@00]04001H200240P009@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
00000000002<B1P10@0000000000000000000000000000001`0008SeTP3DcI80Z5SV<8a8605/2QP1
5000052h4`000000O6dH0@4000010000D;PC04N9k3000000O6dH0@00003DcI80a4TH0@00001lKAP1
?`0005bh4`1/F>H`0@0000000002000090lH0N2h4`08hI8000000000003oooooB93/<?B:605lKAP1
c;TC0040000ed`4`4;hC0000002`HaP12@@H0@T4607AO0d`<@0000T4604001<000000000000/^A<0
00000000001lKAP1;;TC05j=k31lKAP1000001Bi4`0T^A<000000>1C605/2QP1I7H02000000U0000
30000040000F0000300001P0000B000030000040000H0000300004e=C@9D0000E0000;<1003E0@00
i04004H200010000EED7@GI01d6c0@00;`800040001<00000000000000000000oooooooooom@0000
<@000380000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0004`5002N0@00gPD006`200000000AP000201000D0@00ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0=0940000>000008@`=/00000gP000000000004Q00P00008000020000
0000@@80000000000Q30f`000000003o240e0iP0002<00000Q30f`h000000000CE2_A?ke3dA_l:]4
Zm4<A02jZDAb=0E40;ZYA:]jnD<0^ZU48YcR@gbd[DB[4]1309fbA:/Bd4=>QKM4Za;@@`20^d@RW>93
082kA:]jnD<0P;]4`2@8A2N:]dB:IQ54bjBbA=Q`4D@2;;14cXhJA0030`<30`<30`<30`>1>4<E@3D0
400000@0000d00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000010380000000000000000000000000
000002D0000<00000@0002D0000<00001@00P3/0000800006`000100002QE`00mR<005P0001<0000
00000000003oooooooooo``0003aEBdSeEA68MED:1oEE4`LdeKk6DMInaVkFo/I^5e<7;QM:1nhG@8R
_U]B94]IEB@f0000400000iH002L9P00?@0000P0000l000020000400000H0000BPD009d1003O1@00
K@8002D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000S4PH0@40000000000000000000000000
000000L00028mI80e<fB0:QHiS2<B1P1K0XH0A@0001@^1<0000007a]604100000@00052h4`17RN``
000007a]60400000e<fB0<A960400000O6dH0Cl0001L^1<0K5SV<040000000000P0002@?607P^1<0
2>6B000000000000ooooodR@k33dRQP1O6dH0Lbi4`010000=M<1<12n4`000000/6<H0@T4604911P1
dG`=<380000911P1000C000000000000;;TC000000000000O6dH0Bbi4`1NSN``O6dH0@00000D^A<0
9;TC0000003PDaP1K0XH0FAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0001=CDd2E00005@0001l1@00_P400:d5000_0P000@0005EE1d5f@0M1O0D001P200010000
C00000000000000000000?ooooooooooD0000380000b00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0003@0000X0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P24000080000HP0000`000010000C00006@0000=0@00W@4007T7000D1`003@4009d1001]1P00
N0D002T0ZP00000000000000P3l0000000000000P3l0000000000000000000000000000000000000
00000280000<0000ooooodH0000L0000400004E=AR/2@00030000000000>000050000000000@0000
5000
\>"], "Text",
 ImageSize->{254.33333333333331`, 195.43967981703832`}],

Cell[TextData[{
 "Rezistor ",
 StyleBox["R",
  FontSlant->"Italic"],
 " nech\:0165 m\[AAcute] hodnotu 30 k\[CapitalOmega], kondez\[AAcute]tor ",
 StyleBox["C",
  FontSlant->"Italic"],
 " kapacitu 10 \[Mu]F. Obvod nech\:0165 je buzen obd\[EAcute]ln\[IAcute]kov\
\[YAcute]m nap\:011bt\[IAcute]m ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") s periodou 2",
 StyleBox["s",
  FontSlant->"Italic"],
 " (frekvence 0,5 Hz)."
}], "Text",
 CellChangeTimes->{{3.492024401546875*^9, 3.492024545203125*^9}, {
  3.492027111265625*^9, 3.4920271279375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"soucastky", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"R", "\[Rule]", 
        RowBox[{"30", "*", 
         SuperscriptBox["10", "3"]}]}], ",", 
       RowBox[{"c", "\[Rule]", 
        RowBox[{"10", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "6"}]]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"perioda", "=", "2."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frekv", "=", 
     FractionBox["1", "perioda"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"100", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", "Pi", "*", 
          RowBox[{"t", "/", "perioda"}]}], "]"}]}], "]"}], "+", "1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", 
          RowBox[{"Hue", "[", "0.63", "]"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nb", "=", "500"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"u", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["perioda", "nb"], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Range", "[", 
             RowBox[{"2", "nb"}], "]"}], "-", "nb"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "0.63", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.007", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.462200921422367*^9, 3.462201373323167*^9}, 
   3.4622015758111672`*^9, {3.462201749049167*^9, 3.4622017749295673`*^9}, {
   3.462201818344367*^9, 3.462201854146367*^9}, {3.4622020769923673`*^9, 
   3.4622021260699673`*^9}, {3.4622036998143673`*^9, 
   3.4622038088895674`*^9}, {3.462204107910367*^9, 3.462204117239167*^9}, {
   3.4622042449563675`*^9, 3.462204292130767*^9}, {3.467920612390625*^9, 
   3.4679206168125*^9}, {3.467920677953125*^9, 3.46792072146875*^9}, {
   3.467920799609375*^9, 3.467920800875*^9}, {3.46792083609375*^9, 
   3.46792083734375*^9}, {3.46792148828125*^9, 3.467921505625*^9}, {
   3.4679217656875*^9, 3.46792177640625*^9}, {3.467923206234375*^9, 
   3.467923214921875*^9}, {3.467923647296875*^9, 3.46792364859375*^9}, {
   3.467923725359375*^9, 3.4679237266875*^9}, {3.467924514921875*^9, 
   3.467924523671875*^9}, {3.467924574515625*^9, 3.467924587125*^9}, {
   3.468516150421875*^9, 3.46851616328125*^9}, {3.468522018796875*^9, 
   3.468522055328125*^9}, {3.468528183109375*^9, 3.46852819478125*^9}, {
   3.468528229875*^9, 3.468528263671875*^9}, {3.46852832890625*^9, 
   3.46852837571875*^9}, {3.468528413390625*^9, 3.468528413515625*^9}, {
   3.468528455*^9, 3.46852845509375*^9}, {3.468528541828125*^9, 
   3.46852857178125*^9}, {3.4685286085625*^9, 3.46852862196875*^9}, {
   3.491936602265625*^9, 3.491936618140625*^9}, {3.4919399031875*^9, 
   3.491939938765625*^9}, {3.4919419666875*^9, 3.4919420519375*^9}, {
   3.492022384671875*^9, 3.492022410140625*^9}, {3.49202311528125*^9, 
   3.49202311659375*^9}, 3.49202405671875*^9, {3.4920241225*^9, 
   3.4920241279375*^9}, {3.492024157984375*^9, 3.492024175046875*^9}, {
   3.4920247603125*^9, 3.492024777875*^9}, {3.492024826109375*^9, 
   3.49202484790625*^9}}],

Cell[TextData[{
 "Vstupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") m\[AAcute] tento pr\:016fb\:011bh :"
}], "Text",
 CellChangeTimes->{{3.492024554953125*^9, 3.492024562765625*^9}, {
  3.492024871328125*^9, 3.492024875671875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<u[t]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.492023118671875*^9, 3.492023119*^9}, {
  3.492024745765625*^9, 3.492024763703125*^9}, {3.49202482796875*^9, 
  3.49202483815625*^9}, {3.49202772325*^9, 3.492027724734375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Klasick\[EAcute] \:0159e\[SHacek]en\[IAcute] - NDSolve", "Subtitle",
 CellChangeTimes->{{3.491908443046875*^9, 3.4919084549375*^9}, {
  3.49202627215625*^9, 3.492026273609375*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Proto\:017ee obvodem te\[CHacek]e jeden proud, m\:016f\:017eeme pou\:017e\
\[IAcute]t zjednodu\[SHacek]en\[YAcute] popis, kdy vynech\[AAcute]me rovnice \
pro uzly. Proud obvodem ozna\[CHacek]\[IAcute]me ",
 StyleBox["i",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "). Rovn\:011b\:017e vyu\:017eijeme faktu, \:017ee pro nap\:011bt\[IAcute] \
uzlu 1 plat\[IAcute]: ",
 StyleBox["u",
  FontSlant->"Italic"],
 "1(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")==",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellChangeTimes->{{3.492024615734375*^9, 3.492024692*^9}, {
  3.4920248940625*^9, 3.492024899140625*^9}, {3.49202504465625*^9, 
  3.492025106390625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0009o80@0006`0002J0000W@4007T7000D1`00
5`D00;@=001B@@00mc/00215CDH00040b9l00:<3000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
X`4009h4000i1`00@`H000000016000060<000`30015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000T@0000h00000Q30f`00003N000000000000B40200000P00008000000011
0P00000000024<3K000000000?l8@043T08008@200024<3KAP000000001Ec@Y404:TA03H2dAE]JM4
0>@9A02F[dAEc@Y4E@VcA:Zf2dBZO;I4Z/89A5G[]dAEZA14ENFhA02@5dAEgkU4ZUhRA5GU^4@053A4
ENFhA5G9ADAEiKQ404aUA5GU^4AEjGY4ENFhA5E3R4AEiKQ4ZQbDA5GO^DAE0i]4ENFhA03ZXDAEjkM4
ZU:TA:Yf]d@0c:I4E@VcA5E5ZD@0W:i4Z]2XA018XdBZbZU4EEFNA:[4ZTBZHYU4ECV[A03jUTBZ^:a4
ZWZEA00h[TAEni=402JaA5GkTdAEYK94ZWZEA:XT]4@0nYI4EIVdA:YRVDAETkE4EEFNA5F=]T@0B:=4
09jfA02L[T@0T[Q4E@VcA026^TBZM[M4E@^kA5G[]dBZK<54ENFhA03>adAEgkU40?kHA5Ga]TBZj]i4
ENFhA5GGi4AEfKY4oe7TA5E5`TAEenA4Z[k4A:YLiD@0><M4om_VA00hadAEjN54ZZc7A:[fg4AE8LQ4
EF_MA:Z/adBZB<M4ZZc7A00V/DBZ[<M404aUA:Z/adAE4CY4ZZc7A:[F3TBZ[<M4ZZHFA5DQb4AEc@Y4
ZZc7A03XoD<0><M4ZQ[`@jZbaTAE=NI3Z[k4A01@g4>Zb/94053L@eE;`DAEOMY30>BkA:ZZf4>ZO;I4
EJgB@jXdZDAEOMY304:TA5E=hT=ECim4Z[[o@eEEWT@0d0A4EEFNA:[22DAEEIi4Z/89A:[>X4AEc@Y4
04:TA0030`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`<30h<@4AE00@0@000010000000000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
<P0000000000000000000000000000009@0000`0000100009@0000`000050020E@0003@1002R0@00
W0@003T700141P00AP000:`R6E;^8]=CLB;3Ej`ROEWV8SMKJB;^Fb<TJecL9NQLT2Q[G?d/Jea[<F]L
BcU[G;<nJe`JA6]L1d[XG7Y=Jec]D>iK8U:dFeiCOEVKE4IGHEBLDMiD8dmKEJY<UEEeBeEF]TXDEoI9
ReSfBD]I]TX;FWE;AEZZC<9J8dloFiaAAe]6Ed5LOETkGKAKOUg^FjmPJecOHnQLMfaaFfi_JeaTLVEM
8G8KHFAbF6:WLYASIW>DHne`cf=dKPUT[Vk?HieScf>;F<mSBcW?Hgd^cf>^8lmSXRD9I:`Rcf>e7iAS
o1eBHklLF6:26eiQPQ^NH4PKjUd>6cMKCQZCE4PK6E927:1?l1lSCb`Q8dmY8R=?JB9PD:`R6E8U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0005@4001S0P00Q`H002`400000000AP0000P2003l0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00P940000>000008@`=/00000
gP000000000004Q00P000080000200000000@@80000000000Q30f`000000003o24030h01001d0@00
0Q30fbP000000000EQFHA5DY7D@0l:14ZQhLA:_j^TAE@AU4Ze[4A5DY7DB[^/e4EA4QA:^Xd4AEjBm4
03C@A03L=4AE_lm4Z/hiA03Pa4BZcSU4Zfc1A02h>TAFnKe4EJ4kA5Ko_4AE^CM4082kA02h>TB[0;Y4
Z[HmA02<^D@0U41409:hA5E]C4@0V;M4ZTIHA5J7]dCodgQ4EY>eA5GGP4AFWk=4ZTB5A:^/[TAEaH=4
ZkR/A5GGP4B[a:Y4Z]9kA5HoZTCo1fQ4ZlZYA:XRGT@0EZU4ECeDA:^h[4AEKDa4ZlZYA5FAATB[g:I4
EKE0A008WDBZ]Se4EQFHA02h>TB[8Y=4EKTgA5JkSD@0a3Q403b<A03L=4B[_8Y40?@`A:]6SDBZ3RM4
ZcZ?A:XV8dB[;Y54ZShOA:/jSd@0=1i4EQFHA5DY7D@00`<30`<30`<30`<30`<30`<30`<30`<30`<3
0`<30`<30`<30`>35D030100000400000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000000@0b0000
000000000000000000000000000U000030000040000U0000300000D0081E0000_0000584001R0P00
R0H002d4000X00000da39g1@02MfGDTV9V939mIV?BQ=J?<[4VP_;MQWK2iXHV`^[f2V;_ENhBihG^L]
^5fV;_ULIRnnG1d`@E`D<lAK2SJlFbdn`UYT@<QIVd9?Em]1EEIT@5]EkChHEOXigUB1=j=D23EEEQ@c
gUBM<FMC9S1lCVH_0dbV;XY9ibgFART^5TH_;EM5=BbLA[`YUTO2:918b2NFAhDW0da39bD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000X`4005L2000I0`00f@<0000000160000J04005`10015CDH[
:T0002@0000H00000020?`00080000200020?`000800002024040T@0000h00000Q30f`00003N0000
00000000B40200000P000080000000110P00000000024<3K000000000?l8@0D3h0000=@000024<3K
5P000000000]UCi4liLWA0EQ=dA<;B94m/8EA:]25TC=<@Q4;cTGA4Q1mD>c;aQ4YAGQ@f677dAmhMU3
JB4]A5F]dT=b^cY4bXoK@n@NGTBi[nA30A=YA:O?kD<N1gA4^IL4A5KEMDC=<@Q4N9a^A>7;2dBJHfM4
YOd0A1>VATC=<@Q4;H0mA?EU3dA7FSA40jLZA2FC>dCbaS=4]_HgA>3V?4A7FSA4ELU5A9T2;D@]UCi4
liLWA0030`<30`<30`<30`<30`<30`<30h<001E01@0@0000100000@0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040<P0000000000000000000000000000009@0000`0000100009@0000`000050020
E@0007@0002R0@00EP8001X3003J0`005P0009h_gRWA;H@XJBF99@DRabFQ7P@V6acJ9cDK@B]>6ZL^
JQ^0=hhL?CZb7OXl7R5^?@DRX3_[8]4i>22R<@DRFBoB8`l]XR[M;^X/mRdb;`l]Jc4i:ih_gRTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0007l1003Y0`00N@800>8400000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q01P>@0000Q000008@`=/=0000
0000003XoD>[dW]4Xd7M@j_BNdB[b/9358N4A:_:`T>[/8a4Zl[2@d;JU4BS@Me307RKA03XoD<0N9]4
;dL?A01hVdB[PQa4@]ZDA:^274B[/8a4Zh8LA1B7Q4@_A`m4Zm9kA03XoD>[dW]400<30`<30`<30`<3
Ph4IA1A01X0@000010000?oooolQ000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0002L0000H00000@000000003oool0000002D0000<00000@0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@000;DOkCjQ6ndnDQPl@U8HDDIB66I:
XA^dCKDO]4g:8kA=6BMVBQTWDDHI9ca2bR?]?[DOkChl0000200003h0000H0000Q@400>h3001b0P00
g0@001<0000<00000@0002D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0004H0001T0000F00004E=AR/8@0L2A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE01P0@0000100000L0000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000010<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000O@400>L3001i0P00
h`@000d0002e7ndnXA_]?U8H?49B6556DQQVBZ4K]4fe7kA=bR>dCATWITXI9e566BLl@/XSkCje7ndn
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000DP00070100020000J_ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^000000000000002<B1P10@000000000000000000000000000000
1`0008SeTP3DcI80Z5SV<8a8605/2QP15000052h4`000000O6dH0@4000010000D;PC04N9k3000000
O6dH0@00003DcI80a4TH0@00001lKAP1H00005bh4`1/F>H`0@0000000002000090lH0N2h4`08hI80
00000000003oooooB93/<?B:605lKAP1c;TC0040000ed`4`4;hC0000002`HaP11@@H0@D4607AO0d`
E@0000D4604001<000000000000/^A<000000000001lKAP1;;TC05j=k31lKAP1000001Bi4`0T^A<0
00000>1C605/2QP1I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000000V@9D0000E0000<H1000G1000<@800<0400010000EED7@GI01d760@00W@@00040001<0000
0000000000000000oooooooooom@0000E@0006`0000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P000?D1002e0P000`800?H300000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0208h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o24090b`0000P00000Q30f`8000000000
0>Sm@eFaNd@0j?e3Z]h^A0010H4E@0T0400000@0000800008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
m0400;<200030P00mP<00080002e7nDn]An`:bD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
m@400=@400030P005@H0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240:0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@0/3;000020000024<3K0P0000000000j?e30<31A03XoD=EIi]40041PAE02`0@0000
100000X0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E`0002@0003d0@00d`@000<2000E1P000P000;DOf62e7ja=
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80003e0@00]@8005d700330P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0`2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q03@</00008000008@`=/20000
0000003XoD>[gRi4ol?ZA000;d@00@615D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081G0000
90000?@1002c0P00G@L00<<200020000]An`:eYe^2/U0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000?D100071P00G@L001D600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q03P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240?0b`0000P00000Q30f`80000000000>Sm@`30`DCo`nY40<31A0010H4E@0l0
400000@0000>00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000m04000H6001M1`005@H00080002e7mQP
FWGHH2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000=`L009d2001d1`00fP80000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240@0i0000240000
0Q30f`d000000000Z[_ZA:/2:DCD6>U4Z`8YA5G5idBXZB]4ELGWA5K_;TAEaNM40cDbA=@HjD@0g3A4
Z[_ZA03L=4B1G^a40=`dA02bkD@3=C940;;]A5K_;T@0/^e4Z:T[A85Nk4B[0RU4Z[_ZA:/2:D@00`<3
0`<30`<30`>3P@00540@P10000040000ooooob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000
D000000000000000ooooooooool=0000EWDi:XEd>B[KLn<Zfg>d:m]cQRb5M2l]EWD_;BQf;bgAMXH/
dGJd:m5fhbXXMSTZEWDi:S`000080000?P0001P0000m1`00X`8006h7003C0P004`0000`000010000
9@0000`000000020900002@00000081100000000000008110000000000020000AP0006@0001H0000
ADe6:`Q04@940000>000008@`=/00000gP000000000004Q10P000080000200000000@@8000000000
0Q30f`00002I003o5D0@0100000400004@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000040b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@000500000f1`00W08007D7003K0P003@0005Ie>BZ5M3TZ
fg?S:]]c]2_KLhH/QG@_;EIe;bdXMRl]dGJ6;=5f]2_AM^<Z:7Hi:UIe>BXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0003L7003`1@00M0L002d600000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q04P>@0000Q000008@`=/=000000000:ZkjT@0d[i4
e1SYA03B_TAEaNM4ObG0A5G5idAEb<54ELGWA2a[`dCD6>U4Zkk4A:ZkjTB[_/A4PEk/A:^na4@0/^e4
;6_3A02bkDAEb<540;;]A7lU`4B1G^a40=:nA:ZkjT@0d[i400<30`<30`<30`<3Ph4001A04X0@0000
10000?oooolQ000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0002D0000<00000@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo
3@0005IeHEn5M65Ofg<;H=]cgF3KLjiQQGAHHUIeF68XMUQRdGJ^HM5fgF3AMP]P:7IQGeIeHEll0000
200003h0000H0000?@L00?H5001^1`009PH001<0000<00000@0002D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@1<2A00003P000024<3K
00000=h0000000000018@@80000200000P000000044200000000008@`=/00000V@00oaE04P0@0000
100001<0000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000010<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0001@0000=PL00>h5001e1`00;@H000d0001FMF5OQGAQGm]c2f3KLmePfg>^HHEdF69FMEQR
:7IHH]5f[V7AM]ePdGH;H2QfHEmFMF5O9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000h0@00
^`<007D1000@1@00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@1@2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000003oo`Q05@</0000
8000008@`=/200000000000HZd<0f6m401R[@eE3XD@00@615D0E010000040000500002P0000<0000
0@00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000B0@0@000000000?l00000000000000000000U0000
30000040000W00006000008000000000o`000000000U000030000080000C000030000080000k0000
200001/0000@0000WQD00>hk001I0000:000000000000000ooooooooool30000WQDED1TE5E0I5Nhk
?@0000P0000K000040000><F003MC@00F@0002@00000000000000?oooooooooo0P0005/EWU3D4me=
F00003@00000000000000?oooooooooo1P000<8C_Dg>4iA=kQ>3C@hDLDdg57a=B1BLCET0000X0000
00000000003oooooooooo`<0002F5OA?8AGdCflFW4eH0000=000000000000000ooooooooool60000
P1IlCJTFLDg95X==jAJDCODF_DgS5]e=?@0000P0000l0000200003l0000H0000>P400;d3001a0@00
30D001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000V@0001d4003U0@00
]@@0000000160000500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0
B`4007/2002<B1P1000C0>Bf4`14HaP13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00001k_0400980V6EC<31V60430000U;LC0:lB0S0]01<0=M<1<12n4`000000
/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S0F5P41;@0C000000130000T@D2<<Rh4`1lKAP1
C<jB01bh4`1RO0X`jQH:La2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005@0002J0000=0@00</0002U10000@0005EE1d5f@0M1
VP0008h400010000C00000000000000000000?ooooooooooD00007D0000b00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`1;0@00
N`8008a860400640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
6;LC0000002h095lZ<TI0>Bg4`11095lB0LE05d0TGcZ5PYd/<TI0;396@000000/6<H0@00002HIE<`
P;PC07a`BC000000000C00000S0F5P41;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1
jQH:Lb00000>008`0?SoofAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0g?lK02D00010haL0
000:020X003H]`40100002Rg4`165B5?I7H02000000U000030000040000F0000300001P0000B0000
30000040000H000030000?l0009D0000E0000<`0000d1000k0000:D400010000EED7@GI01d7<0000
SP@00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC04/1001k0P00
S4PH0@004`11095lB0LE05d0TGcZ5PYd/<TI0;396@000000/6<H0@00002HIE<`P;PC07a`BC0H]a<0
00000;P0TGbXbAT0i;LC0440TGa81aD0G@2AO>XF2WF`bAT0/<TI0000001@I1P1jQH:Lb00000>008`
0?SoofAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0g?lK03GC0C0@_Q<000000?1T607H]`40
800002Rg4`165B5?I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@3d0A`09@00043S5`0000X0
>2X00=Rg0@040000:;LC04HE8DmTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000k@0003@4000:0@00Y@@00040001EE@M1MT07@Nd0002>1000
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0B`4007/2002<B1P1
000C0440TGa81aD0G@2AO>XF2WF`bAT0/<TI0000001@I1P1jQH:Lb00000>008`0?SooaRg4`000000
^02AO:S96@3T]a<0@@2AO4P75@1M095ljQH:M[396@2`bAT000000?1T607H]`40800002Rg4`165B5?
I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@3d0A`0=M<1<12n4`000000T6DH0MRg0@0P0000
:;LC04HE8DmTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E00`4700U0000@><G00002P1@;000
f;L100@0000X]a<0AQDQCfAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@000090@00=0@002T1002U10000@0005EE1d5f@0M12@4008h400010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`8000160`00iP4003@4001n0P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`2`0000DP4008a8604001<0
i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
04Fl0@00TP2HIE<`D6@H0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0
O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]607DcI807;PC069l2S1e6@Z=
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000000009D0000E00009d3003m0@00fP<006h200010000EED7@GI01d6N0`00E`800040001<0000
0000000000000000oooooooooom@0000DP0003d0000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P0002P300260P00D@@00?8200000000AP0005P0001<0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Y0080T000060000?ooool10000
ZlI;A:XV8dBZZXe3F9Fm@RP0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00002000000000?ooo`0000009@0000`000020000
9@0000`000080020EP000300000^0`00S08004X4003[0P001@000>Xb`RSZ<Zl^WdB_;Ym4`RSZ</8X
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
AP0009`0002@0000ADe6:`Q05P900000=000008@`=/00000eP000000000004Q10P00008000000011
0P00000000024<3K000009T00?l8@1L3?000030000024<3K10000000002[aT]4EMTjA01>RDAEfCY4
04j9A:XV8dB[aT]4ZRHSA0010H4E@1L0400000@0000F0000>P0000`000080000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000P0@380000
00000000V@00000000000000000U000030000040000U0000300000D0081F0000;0000?@2001B0P00
Q0@002D300040000jS:_;Ym4[bjOA<8XjS;2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@0003X0000<00002P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<200004PD00404003Y1@00R@@0000000160000:00001`00017A4U30P00018500101000
j@D005X400000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0608h0000;000008@`=/00000V000000000000<Q10P000000044000000Q30f`00002I003o
240I0b`0000P00000Q30f`80000000000=jSA5FQRD@0P;]4EJ69A0010H4E@1T0400000@0000H0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P0000000000081090100000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5L0000T000040D003l4003Y1@00F`@00080003WDLU4^5g9A2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<200004PD006l4003Y1@00R@@0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240J0SP0000/00000Q30f`00002H0000
00000000b44200000000@@0000024<3K000009T00?l8@1/3;000020000024<3K0P0000000000gZ=4
08j?A020^d@0SXm400430aE06`0@0000100001X0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000100009@0000`000050020E`0002@0000@1@00
KP@00>T5002:10000P000>MA_dNhGKm79@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000B1@00
@0@00>T5001J1000000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@1T0400000@0000H00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T000040D003l4003Y1@00
F`@00080003WDLU4^5g9A2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<200004PD006l4003Y1@00
R@@0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0K0100000400006P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000040000U0000300000D0081G000090000105001^1000j@D008X400020000
ie6oAkQM_dLU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0007L5002e0P00Q0D005@400000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0708h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240M0b`0000P0000
0Q30f`8000000000EKN_A000;dAE]jm40;:9A0010`<E@1d0400000@0000L00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000@0002D0000<0000
1@00P5L0000T0000MPD00;@200251@00E@@00080003DEkP[e5OAA2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000M`D007H400241@005@H0000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240N0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@1l3;000020000024<3K0P000000001E]jm408j?A5Fg[d@0`<54
0041PAE07`0@0000100001h0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0001f1@00M0@008D5000E1P00
0P000=AG_dODEmQP9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001O1@00l0D009`5000]1P00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@203
T00008@000024<3K3@0000000000[jm40=:nA2X<[T@0d[i4ZkR/A7lU`4B[^:a4ELS1A:^h[4@/Jl=4
:Pb^A:^na4@0[jm4Zkk4A=MA/DB[_/A4EZFbA2a[`dAFYK94ELS1A5JU/TAo9L14ee6aA03B_T@0[jm4
0=:nA0030`<30`<30`<30h<10@0D@220400000@0002I003o:00000`0000200008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000
002I0000000U000030000080000C000030000040000k0000200005D0001@000000000000003ooooo
ooooo`d0003@Ef5OoeIQGeEF2f1EE]ePEEJ^HOmFF6;@EeQRXEQHHT]I[V5;FMePBeT;H:5HHEo@Ef5O
?00000P0000n0000600006D5003f1@00U@D002H6000C000030000040000U000030000000080T0000
90000000P440000000000000P44000000000008000160000I00005P00015CDH[240Q0T@0000h0000
0Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K000009T00?lE@200
400000@0000Q0000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000000@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000D00005h5003^1@00W0D002d6000=0000d5MQGomFHEmEEP]PEEKMH5EF[V7oEUQR
d5MHHZ5HF69;FJiQBeWMH4]I2f2QF65Od5MQGbD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
G`D009d2002L1@00fP80000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240R0i00002400000Q30f`d0000000000:n_A:/2:D@Z3:i4Z`8YA:^h[4BXZB]4
ZkR/A5K_;TB[^:a40cDbA2X<[T@0g3A40:n_A03L=4CGDK540=`dA5JU/T@3=C94EZFbA5K_;TAFYK94
Z:T[A=MA/DB[0RU40:n_A:/2:D@00`<30`<30`<30`>30000540RP10000040000V@00ob4000080000
HP0000`000010000900002@00000080m000000000000080m00000000000200009@0000`000020000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000d5Li:_mF>BYEE^<Z
EEJd:eEFQRcoERl]d5L_;J5H;be;FHH/BeVd:d]IhbZQF3TZd5Li:S`000080000?P0001P0001U1@00
X`8009D5003C0P004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q08`940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0R0100000400008`0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000100009@0000`000050020E@000500001N1@00
W08009`5003K0P003@000=1G>B[oESTZEEKS:UEF]2]EEXH/oeH_;M1G;bfQF2l]BeV6;4]I]2];FN<Z
XEPi:]1G>BXU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0004T4000E1000>0D00:d400000000
AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0j;XC0;00001B0@00
S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000004<00000D;`1002B09QUDc1@I1P10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000
V6EC<82h4`1lL4T`000000004`0j208`5QH10Bd04`000000@`0009450S38^1<0O6dH0MC=TP0L^1<0
HW`:<7DI2Y/@_Q<03P02<03hoomTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000000000U@0001D0000W`@002`4003S1000W@@00040001EE@M1MT07@Il400261000
0@0004`00000000000000000003ooooooooooe0000130000@`0001H0000<0000000002D0000<0000
3P00P2P0000<00000@0004H0000X0000700004M4BD<20000S08001H3003]0P00[0D0000000160000
@04003@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240T0Z@0002H0000
0Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010@024<3K00000000ool8@2D3F00004`000024<3K1`000000000h:2U4
EI56A:Ik<d@V=eE4EQ4jA9ISM4AF4CY46e2;A5HA>TAD;Ia4/J`cA4jDZd@NU2U4E@VcA0030`<30`<3
5D0U010000040000900002P0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000W00006000004000000000o`000000000U0000
30000040000C000030000080000k0000200001/0000@0000NbX007Pa001I0000:040000000000000
oooooooooom30000^2[C<ODZ=S9Z:`dcfB_j<d0/oCBQ;14fnb`i=dh]LCRH;KXig2dA>aL^MCa:;^Dm
M2iP?iD^iD2];W92^bh6A<0^XDFk;SA7[Bk3B9H^BTYf;/Y;CBi0CA`^ZdkR;@a@XRePDEP]YE88;M]C
/B`1EE</5UK^:aMGPB/5F0h[gUSL:RmIJb[YF9TZWeP8:liGLB_VE]@[jeDb;=aDQbbjDmH/R58O;DMA
GbggCiL]VTk8;C5=lBfoBa4^@dXX;[i8=RhcAc/^XTDf;P]4:2ik@Q0^l43_;FloaBgg?I@]RSaI;BXk
5RgG>Ld/U3Ql;60g92`n=/D[;SEP:c<dmBY<<h@ZOC99:Qhb32[3<Cd0000800006`000100000K;@00
meL005T0000T000000000000003oooooooooo`80001K:X5IPBYKEUP0000d000000000000003ooooo
ooooo`H00022:SMFXRXJE/HZ75K[:QiF22/mEPH[HEII0000:000000000000000ooooooooool30000
iRX?FH<ZdUSJ;8=GF00003@00000000000000?oooooooooo1P000?X/LELS;GaG=BfLEdL]_5Lk;NEG
6bggEcd000080000?00000P0000o0000600009l2000F0`00kP8009X5000C000030000040000U0000
30000000080U0000300000L0080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0000d6000F0`00KPH00:`500000000AP000401000d0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q09P:T0000V000008@`=/00000
W1000000001EE@E1o`00008000000011000006@000024<3K00000080000200000020?`8000020000
000000008440080o0000000000000000000002P000024<3K0`00000P00000210002``0000000082o
000P`000/<000@400Q30f`0000000?oo240W0eP0001<00000Q30f`L000000000al34A5FAATAnj/U4
9SMEA5DecDBFHgA4ECG=A1]@RdAE=Le4E2fLA0<3bTA>U:]4^OK4A5D9/d@00`<30`<3PAE09`0@0000
100002H0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000004P4040000000003o00000000000000000000
9@0000`0000200009@0000`0000100004`0000`000020000>`0000P0000K00004000095R001h<@00
F@0002P10000000000000?oooooooooo@`000<iRdc4;HcHbP6<=<nmSnS=GI?dd^6@A=Q9U>CMUIG4h
[fFj>O9U4C/]IWDlH6KU?HYVH3n[I^E0`VIc@]5V1TCFIZ55dFHdAl=V`dR/ITY:S6K:Bf=V@4dcIZ]>
nFD<D;QUH55^IJEB7fGKDlMT0UEYI1IF16@GEiQS1EPUHmiHlf8_FH9RjER`HYmH7f?>EhMSiUKZHn]E
B6CKE9iT^U?/I8QB=FE7DGIUmdn^IIY>gVDaC@MV_d/WIT=:?VJnB4aV<dMAIZ95C6H;A3eVNT8VI_10
1FI_?m]UmcfZIHXlKfDZ>beUecWTI9@hTfAP=c]T?SKLHbheMV<c=0]SC3>JHWdbGf8N<R9R`c4m0000
200001/0000@0000<VD00?MG001I00009000000000000000ooooooooool20000LV:1FIQRFeIH0000
=000000000000000ooooooooool60000VF8gE[UR6UKMHQaF0V<NEQmS?EHMHf5FF@0002P000000000
00000?oooooooooo0`000?eR3eVJH]9HlFB3EeP0000d000000000000003oooooooooo`H0000AIG5G
>VElEdaUW5MNIKaGDVGUEc9UmeLm0000200003`000080000?`0001P0000P1P005P<006l6002J1@00
4`0000`0000100009@0000`0000000209@0000`000070020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003W0P007@@003@4002e1000
000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@00
1`8008a8604001<0i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C00000013000002hS2`00TP2HIE<`<6HH0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1
000009QUDc20^1<0O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]605<cY80
7;PC069l2S3Z5PZD4;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B0000
30000040000H000030000?l0009D0000E00000H3000d1000=`<00:D400010000EED7@GI01d460`00
SP@00040001<00000000000000000000oooooooooom@0000M@000380000F000030000000000U0000
300000h0080X000030000080001B0000L0400080002Loooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00
S4PH0@00H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<0
00000;P0TGc8bAT0i;LC0440TGa81aD0G@2AO>XF2YG@bAT0d<TI0000002`HaP1000009QUDc20^1<0
O719<000000001<00002<1HF0@4]01<0000004<0002A1@8`b;PC03GC0C0@_Q<00000051T607Z5PZD
800000h00S00n?ooI7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@1@M2409@00043S5`0000X0
75D00=Rg0@040000:;LC04HE8DmTMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000>0<003@4001H0`00Y@@00040001EE@M1MT07@CP3002>1000
0@0004`00000000000000000003ooooooooooe00000X00008@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0440TGa81aD0G@2AO>XF2YG@bAT0d<TI0000002`HaP1000009QUDc20^1<0O719<1Rg4`000000
^02AO<S96@3T]a<0@@2AO4P75@1M095ljQH:U]396@3@bAT00000051T607Z5PZD800000h00S00n?oo
I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@1@M240=M<1<12n4`000000l6@H0MRg0@0P0000
:;LC04HE8DmTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E06Qf8@0U0000@><G00002P0dE`00
f;L100@0000X]a<0AQDQCfAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0001I0`00=0@007H3002U10000@0005EE1d5f@0M1F@<008h400010000
C00000000000000000000?ooooooooooD00007@0000L00005P0000`0000000009@0000`0000>0020
:00000`000020000DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0
@@2AO4P75@1M095ljQH:U]396@3@bAT00000051T607Z5PZD800000h00S00n?oo6;LC0000002h095l
b<TI0>Bg4`11095lB0LE05d0TGcZ5PZGd<TI0=396@000000l6@H0MRg0@0P0000:;LC04HE8DmTMP08
000000000S10haL0a;LC05iJlgO4]a<0000E06Qf8@0ed`4`4;hC0000002@IAP1f;L10200000X]a<0
AQDQCfAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0P7PQ02D00010haL0000:04aI003H]`40
100002Rg4`165B5?I7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000?l0009D0000E00007D3000d1000U@<00:D400010000EED7@GI01d5e0`00SP@00040001<0000
0000000000000000oooooooooom@0000:@000240000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P0006T6000E1000]@L00:d400000000AP0001@000080000
AdA9@`<0001B0000L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0
A6<H0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000>B<;
002B09QUDc3@IQP10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`
000000004`0j208`5QH10Bd04`000000@`0009450S38^1<0O6dH0GC>TP0L^1<0HW`:<7DI2[8@_Q<0
3P02<03hoomTMP08000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001D0000R0H002`4002i1P00W@@00040001EE@M1MT07@HP6002610000@0004`000000000
00000000003ooooooooooe00001e0000<P0001H0000<0000000002D0000<00003P00P2P0000<0000
0P000580001`0@000P000;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO<S96@3T]a<0
@@2AO4P75@1M095lMAT:/m396@3@bAT000000;1S60400000V6EC<82h4`1lL4T`000000004`00008`
5QH10Bd04`000000@`0009450S38^1<0=M<1<12n4`000000D6@H0GDI2[8P00003P02<03hoomTMP08
000003X80S10haL0a;LC05iJlgO4]a<0000E0>al8@0U0000@><G00002P2hG@00f;L100@0000X]a<0
AQDQCfAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002
E00005@0002j1P00H`@00=/6002^10000@0005EE1d5f@0M1^PH009l400010000C000000000000000
00000?ooooooooooD0000380000R00005P0000`0000000009@0000`0000>0020:00000`000020000
DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095l
MAT:/m396@3@bAT000000;1S60400000V6EC<82h4`1lL4T`6;LC0000002h095lb<TI0>Bg4`11095l
B0LE05d0TGae6@Zdd<TI0=396@000000D6@H0GDI2[8P00003P02<03hoomTMP08000000000S10haL0
a;LC05iJlgO4]a<0000E0>al8@0ed`4`4;hC0000003`I1P1f;L10200000X]a<0AQDQCfAf00P00000
>PP2<43S5`34]a<0GU[cMlBg4`0001D017lQ02D00010haL0000:0=1O003H]`40100002Rg4`165B5?
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000=`6000/1000o0H009d400010000EED7@GI01d7L1P00QP@00040001<00000000000000000000
oooooooooom@0000:0000240000F000030000000000U0000300000h0080X000030000080001B0000
L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGae6@Zd
d<TI0=396@000000D6@H0GDI2[8P00003P02<03hoolH]a<000000;P0TGc8bAT0i;LC0440TGa81aD0
G@2AO7DI2[G@bAT0d<TI0000003`I1P1f;L10200000X]a<0AQDQCfAf00P000000002<43S5`34]a<0
GU[cMlBg4`0001D017lQ03GC0C0@_Q<00000091U607H]`40800002Rg4`165B5?I7H02000000j208`
@><G0<Bg4`1NF_=ga;LC00005@0LPB409@00043S5`0000X0j6400=Rg0@040000:;LC04HE8DmTMP08
000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
o@H002`4000J1`00W@@00040001EE@M1MT07@Od6002610000@0004`00000000000000000003ooooo
oooooe00001d0000700001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@00
0P0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO7DI2[G@bAT0
d<TI0000003`I1P1f;L10200000X]a<0AQDQCaRg4`000000^02AO<S96@3T]a<0@@2AO4P75@1M095l
MAT:]]396@3@bAT00000091U607H]`40800002Rg4`165B5?I7H020000000008`@><G0<Bg4`1NF_=g
a;LC00005@0LPB40=M<1<12n4`000000<6HH0MRg0@0P0000:;LC04HE8DmTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E03B38@0U0000@><G00002P00I000f;L100@0000X]a<0AQDQCfAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0000I1`00
;0@003T7002M10000@0005EE1d5f@0M16@L008H400010000C00000000000000000000?oooooooooo
D00002T0000Q00005P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000
AdA9@`80001>1P00LP8002`7002W0P00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2P2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000100000P000000T400000000000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000X<000000000000008<000:300061P@8@`=/00000
09T0o`Q0:@</00008000008@`=/20000000005E7bTB[9R=4EMOTA:/V8d@00@<35D0Y010000040000
:00002P0000<00000@00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h00000000000B0@0@00000000002I00000000
00000000000U000030000040000W0000600000800000000009T00000000U000030000080000C0000
30000080001K0000C0000506001e0P00:0L00:<2000200002@0000D00004000076Eo:0a`ObP<L0DY
76D5:AaUObS9KgDWI7;2:<U_3b[9KgDW4`0000`0000100009@0000`0000000209@0000`000070020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80000L1@00oP800545003M0`00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2X2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000100000P000000T400000000000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000X<000000000000008<000:300061P@8@`=/00000
09T0o`Q0:`</00008000008@`=/200000000003<YTAE]D140<bVA5GEMD@00@615D0[010000040000
:P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000B0@0@00000000002I0000000000000000000U0000
30000040000U000030000080000C000030000080001K0000C00001l500000`00C@D00=T300020000
2@0000D000040000XE<V<:5C5S/LDaHk75<V<:5C9S2/E=<jGU=^?A5BdcZ/E=<j4`0000`000010000
9@0000`0000000209@0000`000070020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000?0P00LP800>h2002W0P00000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2`2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000100000P000000T4000000
00000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000X<000000
000000008<000:300061008@`=/0000009T0o`Q0;@</00008000008@`=/20000000005Ga14B[9R=4
EA4jA:/V8d@00@615D0]010000040000;000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000
0000002I0000000000000000000U000030000040000U000030000080000C000030000080001K0000
C0000142001e0P00jP800:<2000200002@0000D000040000=B5o:2D/ObPU;0DY=B45:CDQObSR:gDW
OBk2:>8[3b[R:gDW4`0000`0000100009@0000`0000000209@0000`000070020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002J0@00
o@800<l1003L0`00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@2h2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000100000P000000T400000000000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000X<000000000000008<000:300061008@`=/0000009T0o`Q0;`</0000
8000008@`=/20000000005EmfT=EeGE4EGgJ@eFe@4@00@615D0_010000040000;P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h00000000000B0@0@00000000002I0000000000000000000U000030000040000U0000
30000080000C000030000080001K0000C00009h100000`00b`400=T3000200002@0000D000040000
1A]^?@DKOS:;6ghbRa]^?@DKKSgk6L0bB1/V<9DL`3;k6L0b4`0000`0000100009@0000`000000020
9@0000`000070020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003S0@00gP400303001f0P00000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0i;HC04AS604>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C00000013000002HS2`00TP2HIE<`
<6HH0@00002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0O719<000000001<0
>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]605<cY807;PC069l2S3Z5PZ`4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H00003000002I009D0000
E00004d2003e0@00J08006H200010000EED7@GI01d5=0P00C`800040001<00000000000000000000
oooooooooom@0000J@0001`0000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00S4PH0@00H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<000000;P0TGbXbAT0i;LC0440TGa81aD0
G@2AO>XF2[6`bAT0/<TI0000002`HaP1000009QUDc20^1<0O719<000000001<00002<1HF0@4]01<0
000004<0002A1@8`b;PC03GC0C0@_Q<00000051T607Z5PZ`800000h00S00n?ooI7H02000000j208`
@><G0<Bg4`1NF_=ga;LC00005@1dTR409@00043S5`0000X0@7<00=Rg0@040000:;LC04HE8DmTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000
J@800?D100290P00IP800040001EE@M1MT07@FT2001?0P000@0004`00000000000000000003ooooo
oooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO>XF2[6`bAT0
/<TI0000002`HaP1000009QUDc20^1<0O719<1Rg4`000000^02AO:S96@3T]a<0@@2AO4P75@1M095l
jQH:/[396@2`bAT00000051T607Z5PZ`800000h00S00n?ooI7H020000000008`@><G0<Bg4`1NF_=g
a;LC00005@1dTR40=M<1<12n4`000000l6@H0MRg0@0P0000:;LC04HE8DmTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E08bD8@0U0000@><G00002P1HM@00f;L100@0000X]a<0AQDQCfAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002:0P00
m@400:L2001V0P000@0005EE1d5f@0M1RP8004l200010000C00000000000000000000?oooooooooo
D00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0`00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095ljQH:/[396@2`bAT0
0000051T607Z5PZ`800000h00S00n?oo6;LC0000002h095lZ<TI0>Bg4`11095lB0LE05d0TGcZ5PZc
/<TI0;396@000000l6@H0MRg0@0P0000:;LC04HE8DmTMP08000000000S10haL0a;LC05iJlgO4]a<0
000E08bD8@0ed`4`4;hC0000002@IAP1f;L10200000X]a<0AQDQCfAf00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D0Y9HQ02D00010haL0000:071g003H]`40100002Rg4`165B5?I7H02000000U0000
30000040000F0000300001P0000B000030000040000H00003000002I009D0000E0000:H2003e0@00
aP8006H200010000EED7@GI01d6V0P00C`800040001<00000000000000000000oooooooooom@0000
:@000240000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0000<4000A0`00C`D00:T300000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000030000
00000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000Q2<;002B09QUDc0`IQP1000009Bg4`2_4P8`
;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`000000004`0j208`5QH10Bd04`000000
@`0009450S38^1<0O6dH0Dc>TP0L^1<0HW`:<7DI2/d@_Q<03P02<03hoomTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000K0@002P300271000
V@<00040001EE@M1MT07@F`400220`000@0004`00000000000000000003ooooooooooe00001Y0000
700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000
000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000001Rg4`000000^02AO:S96@3T]a<0@@2AO4P75@1M095lMAT:c[396@2`bAT0
00000;1S60400000V6EC<82h4`1lL4T`000000004`00008`5QH10Bd04`000000@`0009450S38^1<0
=M<1<12n4`000000D6@H0GDI2/dP00003P02<03hoomTMP08000003X80S10haL0a;LC05iJlgO4]a<0
000E012K8@0U0000@><G00002P3LN`00f;L100@0000X]a<0AQDQCfAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`00000V@02E00005@000281000:0<00:P4002I0`00
0@0005EE1d5f@0M1R0@0088300010000C00000000000000000000?ooooooooooD00002P0000Q0000
5P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000
S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095lMAT:c[396@2`bAT000000;1S60400000
V6EC<82h4`1lL4T`6;LC0000002h095lZ<TI0>Bg4`11095lB0LE05d0TGae6@[?/<TI0;396@000000
D6@H0GDI2/dP00003P02<03hoomTMP08000000000S10haL0a;LC05iJlgO4]a<0000E012K8@0ed`4`
4;hC0000003`I1P1f;L10200000X]a<0AQDQCfAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0
:9dQ02D00010haL0000:0?Am003H]`40100002Rg4`165B5?I7H02000000U000030000040000F0000
300001P0000B000030000040000H00003000002I009D0000E0000:T4000X0`00aP@009T300010000
EED7@GI01d6Y1000PP<00040001<00000000000000000000oooooooooom@0000M00001`0000F0000
30000000000U0000300000h0080X000030000040001B0000L0400040002Loooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0
j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGae6@[?/<TI0;396@000000D6@H0GDI2/dP0000
3P02<03hoolH]a<000000;P0TGbXbAT0i;LC0440TGa81aD0G@2AO7DI2]2`bAT0/<TI0000003`I1P1
f;L10200000X]a<0AQDQCfAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0:9dQ03GC0C0@_Q<0
0000091U607H]`40800002Rg4`165B5?I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@10Wb40
9@00043S5`0000X038000=Rg0@040000:;LC04HE8DmTMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<000009T00U@0001D0000a@@002P3003U1000V@<00040001EE@M1
MT07@LD400220`000@0004`00000000000000000003ooooooooooe00000Y00008@0001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000V@000143003U0@00
Z@<0000000160000500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<0
3P4000L2002<B1P1000C0>Bf4`14HaP13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00002B8`/00980V6EC<31V60400000U;LC0:lB0S0]01<0=M<1<12n4`000000
/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S0F5P41;@0C000000130000T@D2<<Rh4`1lKAP1
C<jB01bh4`1RO0X`jQH:aQ2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`00000V@02E00005@000020@00:0<001d1002I0`000@0005EE1d5f@0M1
0P40088300010000C00000000000000000000?ooooooooooD00006T0000L00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000`00000000000000S;XC0>Rj4`0>0@00
1`8008a860400640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
6;LC0000002h095lZ<TI0>Bg4`11095lB0LE05d0TGcZ5P[7/<TI0;396@000000/6<H0@00002HIE<`
P;PC07a`BC000000000C00000S0F5P41;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000001@I1P1
jQH:aR00000>008`0?SoofAf00P00000>PP2<43S5`34]a<0GU[cMlBg4`0001D0[:<Q02D00010haL0
000:07R4003H]`40100002Rg4`165B5?I7H02000000U000030000040000F0000300001P0000B0000
30000040000H00003000002I009D0000E00001h1000X0`00?P4009T300010000EED7@GI01d4N0@00
PP<00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00003000000000000002<^Q<0j;XC00h100070P00
S4PH0@004`11095lB0LE05d0TGcZ5P[7/<TI0;396@000000/6<H0@00002HIE<`P;PC07a`BC0H]a<0
00000;P0TGbXbAT0i;LC0440TGa81aD0G@2AO>XF2/R`bAT0/<TI0000001@I1P1jQH:aR00000>008`
0?SoofAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0[:<Q03GC0C0@_Q<000000?1T607H]`40
800002Rg4`165B5?I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@34YB409@00043S5`0000X0
T8H00=Rg0@040000:;LC04HE8DmTMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<000009T00U@0001D0000?`4002P3001L0@00V@<00040001EE@M1MT07@Cl100220`00
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P1
000C0440TGa81aD0G@2AO>XF2/R`bAT0/<TI0000001@I1P1jQH:aR00000>008`0?SooaRg4`000000
^02AO:S96@3T]a<0@@2AO4P75@1M095ljQH:bK396@2`bAT000000?1T607H]`40800002Rg4`165B5?
I7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@34YB40=M<1<12n4`000000T6DH0MRg0@0P0000
:;LC04HE8DmTMP08000003X80S10haL0a;LC05iJlgO4]a<0000E0=bW8@0U0000@><G00002P2XR000
f;L100@0000X]a<0AQDQCfAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`00000V@02E00005@0001K0@00:0<007/1002I0`000@0005EE1d5f@0M1F`40088300010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`80000:1P00gP4005L7001f0P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000@00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0
i;HC04AS604>008`_Oooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C008000130000
09hS2`00TP2HIE<`l6@H0@D0002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP10P0009QUDc20^1<0
O719<000000001<0>PP2<1HF0@4]01<00P0004<0002A1@8`b;PC07a]607lcI807;PC069l2S1e6@[O
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
3000002I009D0000E00007T6003e0@00ZPH006H200010000EED7@GI01d5i1P00C`800040001<0000
0000000000000000oooooooooom@0000<0000380000F000030000000000U0000300000h0080X0000
30000040001B0000L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00001000000000000002<^Q<0j;XC00h100070P00S4PH0@00H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0080000H]a<000000;P0TGbXbAT0
i;LC0440TGa81aD0G@2AO7DI2^2`bAT0/<TI0000002`HaP10P0009QUDc20^1<0O719<000000001<0
0002<1HF0@4]01<00P0004<0002A1@8`b;PC03GC0C0@_Q<00000051T605e6@[O800000h00S00n?oo
I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@18[2409@00043S5`0000X058d00=Rg0@040000
:;LC04HE8DmTMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
09T00U@0001D0000Y@H00?D1003W1P00IP800040001EE@M1MT07@J/6001?0P000@0004`000000000
00000000003ooooooooooe0000110000?@0001H0000<0000000002D0000<00003P00P2P0000<0000
0@0004H0000X0000700004M4BD<20000EP@00306003b100050L0000000160000804001@10015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240`0T@0000h00000Q30f`00003N0000
00000000B40200000P000080000000110P00000000024<3K000000000?l8@343V00008`000024<3K
3P000000002jN9I4OV[<A:gDVTA/Ple4EO6MA901dTAElIe4Zc?GA5GaWDBbBme4NK>IA:/lhTAEN9A4
ZccRA?PlSdB[?>94EOn:A;9;gDAEohY4Zc?GA1coRTCFe=54`E2>A=PmcDAYfi94_5?<A5C3U4B_i<I4
00<30`<30`<30`<30h4101E0<@0@000010000300000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
<P0000000000000000000000000000009@0000`0000100009@0000`000050020>`0000P0000K0000
400003E;000^IP00F00004`00000000000000?oooooooooo300006==^VKaC_UXlDjBJo5>WVkBC1Ma
=DXGLIM75g5hAIi^N4FBJgQ5hfPQAiMVITTRISH0000@0000FTX006]S000m0000200003`000080000
@00001P0001D1000=0H00?84000D1`009@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000002<B1P1
0@0000000000000000000000000000001`0008SeTP3DcI80Z5SV<8a8605/2QP15000052h4`000000
O6dH0@4000010000D;PC04N9k3000000O6dH0@00003DcI80a4TH0@00001lKAP1?`0005bh4`1/F>H`
0@0000000002000090lH0N2h4`08hI8000000000003oooooB93/<?B:605lKAP1c;TC0040000ed`4`
4;hC0000002`HaP12@@H0@T4607AO0d`<00000T4604001<000000000000/^A<000000000001lKAP1
;;TC05j=k31lKAP1000001Bi4`0T^A<000000>1C605/2QP1I7H02000000U000030000040000F0000
300001P0000B000030000040000H0000300004e=C@9D0000E00008/400251P00_0@00?H600010000
EED7@GI01d6;1000g`H00040001<00000000000000000000oooooooooom@0000<0000380000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P0008<1002f0@00
5@8008P200000000AP000201000D0@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0<P940000>000008@`=/00000gP000000000004Q00P000080000200000000@@8000000000
0Q30f`000000003o240c0iP0002<00000Q30f`h000000000REoT@oA65dBkK=53PklFA028`T=iY@e4
08S2@eJI0T@0R<938UC^@nmadT>[b]]301CV@j_:fd<i]OU3Zl[K@`3@14@RE>i30=04A5JI0TBDc`A4
dFH;A8h804Cb?A=4XL_a@ndT5T@<P>e3cVXPA0030`<30`<30`<30`>1000E@3<0400000@0000b0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000000010380000000000000000000000000000002D0000<0000
0@0002D0000<00001@00P3/0000800006`00010000247000bRD005P0001<000000000000003ooooo
ooooo``0000V6ZPUBAQR8dTHWb196<<MAaYb6k/LLQ/_7g8K;2737B`QWb0/8M8Rnao8938NPRDf0000
40000:PM000C:000?@0000P0000l000020000400000H0000PP400;@1000F0P00Q08002D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP00000000000000S4PH0@40000000000000000000000000000000L00028mI80
e<fB0:QHiS2<B1P1K0XH0A@0001@^1<0000007a]604100000@00052h4`17RN``000007a]60400000
e<fB0<A960400000O6dH0Cl0001L^1<0K5SV<040000000000P0002@?607P^1<02>6B000000000000
ooooodR@k33dRQP1O6dH0Lbi4`010000=M<1<12n4`000000/6<H0@T4604911P1dG`=<340000911P1
000C000000000000;;TC000000000000O6dH0Bbi4`1NSN``O6dH0@00000D^A<09;TC0000003PDaP1
K0XH0FAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`0001=CDd2
E00005@0002c0@00e@400>@100160P000@0005EE1d5f@0M1/`4002l200010000C000000000000000
00000?ooooooooooD0000340000b00005P0000`0000000009@0000`0000>0020:00000`000010000
AP0002P0000L0000AdA9@`80001<1@00WP400=h5001/0P00000004H0000P0@00504004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@3@2A00003P000024<3K00000=h000000000
0018@080000200000P000000044200000000008@`=/000000000o`Q0=@>H0000S000008@`=/>0000
000004e@[dCnm@m4Ko2[A:_A34@0^ZU4LS@5A02jZDB[N_U30;ZYA2:LhT=l]:e4Za;@@`2M/TB[4]13
CXFgA:/Bd4<0P;]48YcR@`20^dB[N_U3082kA<0T24@WR[M4RVHAA<^T/TCHL1540Rb`A<j>6T@00`<3
0`<30`<30`<3P@005D0e010000040000=000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000000@0b0000
000000000000000000000000000U000030000040000U0000300000D0080k0000200001/0000@0000
XEL00?HS001H0000C000000000000000ooooooooool<0000lED]8mEDAR7EE2POeEA<7==FnaU7FO/I
^e_k6KQMC1bhGBPO^5d28[iKDRA;FEDT=P000100000>F000W2H003d000080000?00000P000100000
600004X5002M0@00g`D006d2000U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000000008a860410000
00000000000000000000000000070000R?FB0=C=TP2XF>H`S4PH0F`:604D0000D;PC0000001lKAP1
0@000040001@^1<0AhW/<000001lKAP100000=C=TP34BAP1000007a]604o0000G;PC06aHiS010000
00000080000T3aP1h;PC00SQTP00000000000?oooom8T>``m8XH0Ga]607<^A<00@0003GC0C0@_Q<0
00000;1S604911P12@@H0M5l3C0b00002@@H0@004`000000000002bi4`000000000007a]604/^A<0
GXg/<7a]604000005;TC02Bi4`000000h5<H0F`:605TMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<0000CDe=0U@0001D0000O0D00;h1002]1@00;`800040001EE@M1
MT07@G`5000H0P000@0004`00000000000000000003ooooooooooe00000b0000<P0001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000d0000:00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080Q000020000680000<00000@0004`0001T00003@4009d1001i1`00
50L000d1002M0@00K@H007P5000Y0:X0000000000000080o000000000000080o0000000000000000
000000000000000000000000000R000030000?oooom60000700001000015CDH[0T0000`000000000
3P0001@000000000400001@0
\>"], "Text",
 ImageSize->{239.66666666666666`, 184.16923956546594`}],

Cell["Rovnice sou\[CHacek]\[AAcute]stek :", "Text",
 CellChangeTimes->{{3.4920251964375*^9, 3.4920252045*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rezistorR", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t", "]"}], "-", 
     RowBox[{"u2", "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{"R", "*", 
     RowBox[{"i", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kondC", "=", 
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], "\[Equal]", 
    RowBox[{"c", "*", 
     RowBox[{
      RowBox[{"u2", "'"}], "[", "t", "]"}]}]}]}], ";"}]}], "Input"],

Cell["Po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute] podm\[IAcute]nky :", "Text",
 CellChangeTimes->{{3.49202523125*^9, 3.492025236125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"poc1", "=", 
   RowBox[{
    RowBox[{"u2", "[", 
     RowBox[{"-", "perioda"}], "]"}], "\[Equal]", "0"}]}], ";"}]], "Input"],

Cell["\:0158e\[SHacek]en\[IAcute] :", "Text",
 CellChangeTimes->{{3.492025260078125*^9, 3.492025263640625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rovnice", "=", 
   RowBox[{"{", 
    RowBox[{"rezistorR", ",", "kondC", ",", "poc1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceDosad", "=", 
   RowBox[{"rovnice", "/.", "soucastky"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "[", "t", "]"}], ",", 
     RowBox[{"u2", "[", "t", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reseni", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"rceDosad", ",", "nezname", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nDSolvePlot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"u2", "[", "t", "]"}], "/.", "reseni"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Red"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.49189568178125*^9, 3.49189586384375*^9}, {
   3.4918960064375*^9, 3.491896095078125*^9}, {3.49189614434375*^9, 
   3.4918961975625*^9}, {3.4918962430625*^9, 3.491896255734375*^9}, {
   3.491896299546875*^9, 3.491896300328125*^9}, 3.491908471046875*^9, {
   3.491931034703125*^9, 3.49193103634375*^9}, 3.491931069921875*^9, {
   3.49202242678125*^9, 3.492022426890625*^9}, {3.49202522421875*^9, 
   3.49202527440625*^9}, {3.49202632009375*^9, 3.492026325828125*^9}}],

Cell["\<\
Zobrazme v\[YAcute]sledky. Vstupn\[IAcute] nap\:011bt\[IAcute] je mod\:0159e, \
v\[YAcute]stup je \[CHacek]erven\:011b.\
\>", "Text",
 CellChangeTimes->{{3.49202645465625*^9, 3.49202649378125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "nDSolvePlot", ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"u\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\), \!\(\*
StyleBox[\"u2\",
FontFamily->\"Courier New\",
FontColor->RGBColor[1., 0., 0.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[1., 0., 0.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[1., 0., 0.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[1., 0., 0.]]\)\>\""}], "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.492026333421875*^9, 3.492026365*^9}, 
   3.49202640390625*^9, {3.49202774515625*^9, 3.492027771265625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Fourierova \:0159ada + HUS", "Subtitle",
 CellChangeTimes->{{3.49202627965625*^9, 3.492026290328125*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Vstupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") rozlo\:017e\[IAcute]me na sou\[CHacek]et harmonick\[YAcute]ch funkc\
\[IAcute]. Potom na obvod aplikujeme ka\:017edou harmonickou zvl\[AAcute]\
\[SHacek]\:0165 a spo\[CHacek]\[IAcute]t\[AAcute]me pro ni pr\:016fb\:011bh \
na v\[YAcute]stupu. Jednotliv\[EAcute] v\[YAcute]stupn\[IAcute] pr\:016fb\
\:011bhy pot\[EAcute] poskl\[AAcute]d\[AAcute]me (pos\[CHacek]\[IAcute]t\
\[AAcute]me), \[CHacek]\[IAcute]m\:017e z\[IAcute]sk\[AAcute]me \
v\[YAcute]stup pro ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellChangeTimes->{{3.492028971484375*^9, 3.49202900815625*^9}, {
  3.492029183859375*^9, 3.492029189046875*^9}, {3.492041089125*^9, 
  3.492041246921875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[TextData[{
 "Rozklad ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") do Fourierovy \:0159ady"
}], "Subsubtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell["\<\
Budeme po\[CHacek]\[IAcute]tat koeficienty pro prvn\[IAcute]ch 50 harmonick\
\[YAcute]ch funkc\[IAcute].\
\>", "Text",
 CellChangeTimes->{{3.492028971484375*^9, 3.49202900815625*^9}, {
  3.492029183859375*^9, 3.492029189046875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nHarm", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", "nHarm", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4920290409375*^9, 3.49202904584375*^9}}],

Cell[TextData[{
 "Zaj\[IAcute]m\[AAcute]-li v\[AAcute]s, co obsahuj\[IAcute] seznamy (angl. \
Lists) ",
 StyleBox["siny", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["cosiny", "Program",
  FontWeight->"Bold"],
 ", sta\[CHacek]\[IAcute] odstranit st\:0159edn\[IAcute]k na konci \:0159\
\[AAcute]dku."
}], "Text",
 CellChangeTimes->{{3.492029099828125*^9, 3.4920291366875*^9}, {
  3.49202925021875*^9, 3.492029278796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sinus", "[", "n_", "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"siny", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"sinus", ",", "rn"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cosinus", "[", "n_", "]"}], ":=", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "n"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cosiny", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"cosinus", ",", "rn"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.49202931065625*^9}],

Cell[TextData[{
 "Spo\[CHacek]\[IAcute]t\[AAcute]me koeficienty ",
 StyleBox["a",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ",
 StyleBox["b",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ulo\:017e\[IAcute]me je do seznam\:016f ",
 StyleBox["aenka", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["beenka", "Program",
  FontWeight->"Bold"],
 ". "
}], "Text",
 CellChangeTimes->{{3.492029374953125*^9, 3.49202941209375*^9}, {
  3.492029899703125*^9, 3.4920299030625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{
    FractionBox["1", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n_", "]"}], ":=", 
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "*", 
        RowBox[{"cosinus", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], ";"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Definice", " ", "funkce", " ", "pro", " ", "v\[YAcute]po\[CHacek]et", " ", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], ".", " ", "Zat\[IAcute]m"}], " ", "se", 
    " ", "v\[YAcute]po\[CHacek]et", " ", 
    RowBox[{"neprov\[AAcute]d\[IAcute]", "."}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aenka", "=", 
    RowBox[{"Map", "[", 
     RowBox[{"a", ",", "rn"}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "Teprva", " ", "te\:010f", " ", "se", " ", "prov\[AAcute]d\[IAcute]", " ", 
    RowBox[{"v\[YAcute]po\[CHacek]et", ".", " ", "50"}], "x", " ", "se", " ", 
    "zavol\[AAcute]", " ", 
    RowBox[{"a", "[", "n", "]"}], " ", "a", " ", "v\[YAcute]sledky", " ", 
    "se", " ", "ulo\:017e\[IAcute]", " ", "do", " ", "seznamu", " ", 
    RowBox[{"aenka", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "n_", "]"}], ":=", 
   RowBox[{
    FractionBox["2", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "*", 
       RowBox[{"sinus", "[", "n", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beenka", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"b", ",", "rn"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4622021503123674`*^9, 3.462202313332367*^9}, {
   3.4622025729319673`*^9, 3.462202668686767*^9}, {3.4622027175771675`*^9, 
   3.462202741491967*^9}, {3.4622029929015675`*^9, 3.4622030169879675`*^9}, {
   3.462203106672367*^9, 3.462203112257167*^9}, {3.462203236698367*^9, 
   3.4622032389135675`*^9}, {3.462203335493167*^9, 3.462203337583567*^9}, {
   3.4622033873631673`*^9, 3.4622034681087675`*^9}, 3.462203818031167*^9, {
   3.4622038516647673`*^9, 3.462203870993167*^9}, {3.462204158984767*^9, 
   3.4622041663791676`*^9}, {3.462204359444767*^9, 3.462204362408767*^9}, {
   3.4622044390671673`*^9, 3.462204446695567*^9}, {3.462856015390625*^9, 
   3.46285604153125*^9}, {3.46792166071875*^9, 3.4679216688125*^9}, {
   3.467921811390625*^9, 3.467921823546875*^9}, {3.4679218895625*^9, 
   3.46792190365625*^9}, 3.467921939234375*^9, {3.467922450296875*^9, 
   3.467922491625*^9}, {3.467922568296875*^9, 3.467922596109375*^9}, {
   3.46792269428125*^9, 3.467922759359375*^9}, {3.467922805078125*^9, 
   3.46792286815625*^9}, {3.46792293*^9, 3.467923026328125*^9}, {
   3.467923123203125*^9, 3.4679231334375*^9}, {3.467923986515625*^9, 
   3.46792399403125*^9}, {3.4679241378125*^9, 3.46792425875*^9}, {
   3.46792432134375*^9, 3.467924322375*^9}, {3.4679243834375*^9, 
   3.46792439015625*^9}, {3.4679244713125*^9, 3.4679244824375*^9}, {
   3.46792463*^9, 3.46792463978125*^9}, {3.46792477475*^9, 
   3.467924815390625*^9}, {3.4679248771875*^9, 3.4679248928125*^9}, {
   3.467924935953125*^9, 3.46792497184375*^9}, {3.467925083328125*^9, 
   3.467925138796875*^9}, {3.46792538715625*^9, 3.46792539809375*^9}, {
   3.468517664765625*^9, 3.468517744953125*^9}, {3.46851780703125*^9, 
   3.468517812921875*^9}, {3.468519313703125*^9, 3.468519313828125*^9}, {
   3.46851936775*^9, 3.4685193903125*^9}, {3.491941037640625*^9, 
   3.491941044234375*^9}, {3.49194137946875*^9, 3.491941380484375*^9}, {
   3.491946229359375*^9, 3.491946239828125*^9}, {3.4919464963125*^9, 
   3.491946502359375*^9}, {3.491946560296875*^9, 3.4919465660625*^9}, {
   3.49194661146875*^9, 3.491946616953125*^9}, {3.4920073760625*^9, 
   3.49200738128125*^9}, {3.492022439640625*^9, 3.4920224436875*^9}, {
   3.492028965703125*^9, 3.492028969578125*^9}, {3.492029227046875*^9, 
   3.4920292469375*^9}, 3.492029306625*^9, {3.492029347765625*^9, 
   3.492029359453125*^9}, {3.492029526*^9, 3.492029569875*^9}, {
   3.492029993515625*^9, 3.492030002734375*^9}, {3.492031882421875*^9, 
   3.4920320090625*^9}, {3.49203903665625*^9, 3.49203904559375*^9}}],

Cell[TextData[{
 "Slo\:017e\[IAcute]me harmonick\[EAcute] funkce, abychom vytvo\:0159ili \
aproximaci ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "). \n\nPou\:017eit\[IAcute] vzorce\n",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"nahradaVstup", "[", "n_", "]"}], ":=", 
    RowBox[{"a0", "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "n"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "i", "]"}], "*", 
         RowBox[{"cosinus", "[", "i", "]"}]}], "+", 
        RowBox[{
         RowBox[{"b", "[", "i", "]"}], "*", 
         RowBox[{"sinus", "[", "i", "]"}]}]}], ")"}]}]}]}], ";"}]],
  FontWeight->"Bold"],
 "\nby ale bylo v\[YAcute]po\[CHacek]etn\:011b \
n\[AAcute]ro\[CHacek]n\[EAcute] - p\:0159i ka\:017ed\[EAcute]m \
zavol\[AAcute]n\[IAcute] funkce ",
 StyleBox["nahradaVstup", "Program",
  FontWeight->"Bold"],
 " by se znova a znova po\[CHacek]\[IAcute]taly v\[SHacek]echny koeficienty ",
 StyleBox["a[i]", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["b[i]", "Program",
  FontWeight->"Bold"],
 ", tedy znova a znova bychom integrovali. Proto jsme v\[SHacek]echny \
koeficienty (jednou) p\:0159edpo\[CHacek]\[IAcute]tali a ulo\:017eili do \
seznam\:016f ",
 StyleBox["aenka", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["beenka", "Program",
  FontWeight->"Bold"],
 " a te\:010f je pou\:017eijeme:"
}], "Text",
 CellChangeTimes->{{3.49203145075*^9, 3.492031611359375*^9}, {
  3.49203164534375*^9, 3.49203174634375*^9}, {3.49203208028125*^9, 
  3.492032117234375*^9}, {3.492032462953125*^9, 3.49203247153125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nahradaVstup", "[", "n_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"Apply", "[", 
     RowBox[{"Plus", ",", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"aenka", "*", "cosiny"}], "+", 
         RowBox[{"beenka", "*", "siny"}]}], ",", "n"}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.49203173709375*^9, 3.49203173825*^9}}],

Cell[TextData[{
 "T\[IAcute]m je hotov\[YAcute] rozklad ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") na sou\[CHacek]et harmonick\[YAcute]ch funkc\[IAcute]."
}], "Text",
 CellChangeTimes->{{3.492028647125*^9, 3.4920287179375*^9}},
 Background->RGBColor[0.87, 0.94, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Zobrazen\[IAcute] v\[YAcute]sledku p\:0159evodu ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") do Fourierovy \:0159ady"
}], "Subsubtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}, {
  3.49202873028125*^9, 3.49202876028125*^9}, {3.4920755953125*^9, 
  3.492075598578125*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[TextData[{
 "Tato \[CHacek]\[AAcute]st nen\[IAcute] nutn\[AAcute]. \
Uv\[AAcute]d\[IAcute]me ji pouze pro ty, koho zaj\[IAcute]m\[AAcute], jak \
vypad\[AAcute] aproximace ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") pomoc\[IAcute] sou\[CHacek]tu harmonick\[YAcute]ch funkc\[IAcute]. \
M\:016f\:017eete p\:0159esko\[CHacek]it rovnou na HUS."
}], "Text",
 CellChangeTimes->{{3.492028762984375*^9, 3.492028930171875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell["P\:0159\[IAcute]prava na zobrazov\[AAcute]n\[IAcute].", "Text",
 CellChangeTimes->{{3.4920278798125*^9, 3.492027902234375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"harmonicke", "=", 
   RowBox[{
    RowBox[{"aenka", "*", "cosiny"}], "+", 
    RowBox[{"beenka", "*", "siny"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pln", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahradaVstup", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<u[t]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pln1", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahradaVstup", "[", 
      RowBox[{"n", "-", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plHarm", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"harmonicke", "[", 
      RowBox[{"[", "n", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Green"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", 
     RowBox[{"pln", "[", "n", "]"}], ",", "  ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"u\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\>\""}], "}"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys2", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", 
     RowBox[{"plHarm", "[", "n", "]"}], ",", 
     RowBox[{"pln1", "[", "n", "]"}], ",", 
     RowBox[{"pln", "[", "n", "]"}], ",", "  ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"u\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"(\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\"t\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\!\(\*
StyleBox[\")\",
FontFamily->\"Courier New\",
FontColor->RGBColor[0., 0., 1.]]\)\>\""}], "}"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.4"}], ",", "2.4"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4685195363125*^9, 3.46851954096875*^9}, 
   3.46851981403125*^9, {3.468519853328125*^9, 3.468519860140625*^9}, {
   3.4685198999375*^9, 3.468519901609375*^9}, {3.46851999571875*^9, 
   3.468520059625*^9}, {3.4685202535*^9, 3.468520254375*^9}, {
   3.468520371375*^9, 3.468520439296875*^9}, {3.468520487796875*^9, 
   3.468520491890625*^9}, {3.468520538125*^9, 3.468520558640625*^9}, {
   3.46852059225*^9, 3.46852059371875*^9}, {3.46852062865625*^9, 
   3.46852064334375*^9}, {3.468522078890625*^9, 3.468522079484375*^9}, {
   3.49194095228125*^9, 3.49194096896875*^9}, 3.491941042484375*^9, 
   3.491941374203125*^9, {3.49194148628125*^9, 3.491941501453125*^9}, {
   3.491941857390625*^9, 3.4919418599375*^9}, {3.49194212521875*^9, 
   3.491942140671875*^9}, {3.491942234546875*^9, 3.491942237296875*^9}, {
   3.49200740171875*^9, 3.492007408234375*^9}, {3.4920074506875*^9, 
   3.49200746046875*^9}, 3.492007647*^9, {3.492022487859375*^9, 
   3.492022496875*^9}, 3.492026846515625*^9, {3.4920276818125*^9, 
   3.492027683796875*^9}, {3.49202823453125*^9, 3.49202826159375*^9}, {
   3.492028323921875*^9, 3.492028328078125*^9}, {3.49203807771875*^9, 
   3.492038080828125*^9}}],

Cell[TextData[{
 "Mod\:0159e je nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), \[CHacek]ern\:011b je jeho aproximace pomoc\[IAcute] sou\[CHacek]tu ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch funkc\[IAcute]. Nult\[AAcute] harmonick\[AAcute] je \
stejnosm\:011brn\[AAcute] slo\:017eka, tedy koeficient ",
 StyleBox["a0", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
   3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
   3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
   3.4679215163125*^9, 3.467921516703125*^9}, {3.467921598078125*^9, 
   3.467921613671875*^9}, {3.46792268246875*^9, 3.467922711375*^9}, {
   3.468517762578125*^9, 3.468517768734375*^9}, {3.4685202625*^9, 
   3.468520269390625*^9}, {3.4919421591875*^9, 3.491942176046875*^9}, {
   3.491942260203125*^9, 3.491942273578125*^9}, {3.4919423271875*^9, 
   3.4919423275*^9}, 3.491942402859375*^9, {3.491984441140625*^9, 
   3.491984441625*^9}, {3.49202693828125*^9, 3.4920269553125*^9}, {
   3.492027651984375*^9, 3.492027706625*^9}, {3.49202779096875*^9, 
   3.492027831015625*^9}, {3.492040699609375*^9, 3.49204072534375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[TextData[{
 "V n\[AAcute]sleduj\[IAcute]c\[IAcute]m grafu je pro n\[AAcute]zornost nav\
\[IAcute]c \[SHacek]ediv\:011b zobrazena aproximace pomoc\[IAcute] ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["-1",
  FontWeight->"Bold"],
 " harmonick\[YAcute]ch funkc\[IAcute] a zelen\:011b je zobrazna ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-t\[AAcute] harmonick\[AAcute] funkce. \n   \n\
P\:0159i\[CHacek]ten\[IAcute]m zelen\[EAcute] \[CHacek]\[AAcute]ry k \
\[SHacek]ediv\[EAcute] \[CHacek]\[AAcute]\:0159e obdr\:017e\[IAcute]me \
\[CHacek]ernou \[CHacek]\[AAcute]ru. Pov\[SHacek]imn\:011bme si, \:017ee obd\
\[EAcute]ln\[IAcute]kov\[YAcute] pr\:016fb\:011bh se skl\[AAcute]d\[AAcute] \
ze sou\[CHacek]tu pouze lich\[YAcute]ch harmonick\[YAcute]ch funkc\[IAcute] \
(sud\[EAcute] harmonick\[EAcute] jsou nulov\[EAcute])."
}], "Text",
 CellChangeTimes->{{3.492027975296875*^9, 3.49202811228125*^9}, {
  3.49202835103125*^9, 3.49202835346875*^9}, {3.49202841603125*^9, 
  3.492028509796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys2", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["HUS", "Subsubtitle",
 CellChangeTimes->{{3.492026756140625*^9, 3.49202675634375*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[TextData[{
 "F\[AAcute]zory harmonick\[YAcute]ch funkc\[IAcute], ze kter\[YAcute]ch je \
skl\[AAcute]d\[AAcute]no vstupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), ulo\:017e\[IAcute]me do seznamu (listu) ",
 StyleBox["fazoryVstup", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492036525296875*^9, 3.492036529*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"fazoryVstup", "=", 
   RowBox[{"beenka", "+", 
    RowBox[{"I", "*", "aenka"}]}]}], ";"}]], "Input"],

Cell[TextData[{
 "Kruhov\[AAcute] frekvence z\[AAcute]kladn\[IAcute] harmonick\[EAcute] je \
\[Omega]. \n\nKruhov\[AAcute] frekvence \[Omega]",
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontSlant->"Italic"],
 " ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-t\[EAcute] harmonick\[EAcute] funkce je ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-n\[AAcute]sobkem \[Omega]."
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035628921875*^9, 3.492035634421875*^9}, {3.492035670171875*^9, 
  3.4920357449375*^9}, {3.492036587875*^9, 3.49203659728125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"omega1", "=", 
   RowBox[{"2", "*", "Pi", "*", "frekv"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"omega", "[", "n_", "]"}], ":=", 
   RowBox[{"n", "*", "omega1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.492038011953125*^9, 3.492038020765625*^9}}],

Cell["\<\
Obvod budeme \:0159e\[SHacek]it jako impedan\[CHacek]n\[IAcute] d\:011bli\
\[CHacek] pro jednotliv\[EAcute] frekvence.\
\>", "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203594990625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0004b<0@0006`0001i0@00U04000<7001=1`00
Z0`0084=003j?P00[cd00215CDH00040S4`000<2000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
m@4009T100030P00<@L0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@043;000020000024<3K0P0000000000j?e3EC_UA03XoD>Y4]130041PAE00@0@0000
10000000000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003d0@00V04000<2000a1`000P000;DOUW:e7o/I
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`8000011@00GP@00>L6001/1000000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@082>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q00`</00008000008@`=/20000
00000:/0XD@0X8a4EPgLA02PS4@00@615D030100000400000P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081G0000
90000005001M1000j0H006`400020000NE18A_m]B4HU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000?D1000S1`00i`H0034700000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0108h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o24050b`0000P00000Q30f`80000000000>Sm@j/ZiDB[o=]4ES_UA0010H4E@0D0
400000@0000400008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000m0400247003W1P00<@L00080002e7hib
mffFLRD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000`PH004H4003o1P00P`@0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`000800002024060i0000240000
0Q30f`d00000000000GLA5FQRD@ZH]Y4EJ69A:/>fDCDm8Y4Z`kIA:ZGS4B[3]U4PCZ>A2YRfT@0SXm4
00GLA02>SdCGYme408j?A5KkgTB1>Xi4E__NA:ZGS4AFnmi4e?B:A=NWgDAEXHU400GLA5FQRD@00`<3
0`<30`<30`>30@615406P10000040000ooooob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00001000000000?ooo`0000009@0000`000010000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000nfg9A2Y]bDB0K7=5
P6a4AX1/5TLZKKm7nffoAla^_dMfKaI7MVm4AWI_LdG<K/U4nfg9A3`000080000?P0001P000381P00
C0@00?P6001l10004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q01`940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D060100000400001`0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000200009@0000`000050020E@00050000301P00
A@@00?l6002410003@000?]]bD@ZKLU4P6acAH1/A4J0K1I7:VfoAo]]_dO<K[m7MVlFAgI_A4IfKg=5
c6k9A?]]bD@U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<86000;1`00o`H004P700000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q020>@0000
Q000008@`=/=000000000005g4B[?>94:V;JA:/lhTB[3]U4:Y3SA:/>fD@0<nE4Z`kIA=OEiT@ZH]Y4
ERWXA005g4AF:NQ4ejOMA5HYj4AFnmi4emGVA5KkgT@0<nE4E__NA2Z@hdCGYme4ZccRA005g4B[?>94
00<30`<30`<30`<3Ph430aA0280@000010000?oooolQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000@0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@000?]]5g4ZKAMaP6c1LH1/TW:0K6=c:Vd=M?]]3GC<KPed
MVmSLgI_TW9fKl5ac6hGLO]]5g4l0000200003h0000H0000b0H00147003h1P00@@L001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@0T2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE0200@0000100000T0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0001@0000`0H000X7003o1P00B@L000d0003kKAMa
:VdGLH1/`G60K99bP6aSLbY]3GCkK@edc6h=M7I_Hg=fKi9bMVo1LLa^5g7kKAMa9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002J0P00nP400=P2003Y1P00000004H0000D0@00204004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@0X2Y00009P000024<3K000009`@00000000
EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l200000P00000000000211
0020?`000000000000000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;30
0041008@`=/00000003oo`Q02`</00008000008@`=/200000000000h;T@0N?m303P^A:]Pg4@00@61
5D0;0100000400002P0002P0000<00000@00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000040000W00006000008000000000o`000000000U0000
30000080000C000030000080000k0000200001/0000@0000bB/00>LO001I0000:000000000000000
ooooooooool30000bB^TKD@[Y6e4:nLO?@0000P0000K0000400000h]001/J`00F@0002@000000000
00000?oooooooooo0P0008H[;Fko:Fa[F00003@00000000000000?oooooooooo1P000>dYC6_i:B=[
6BXAJcTZofYR:P][LbX[JeT0000X000000000000003oooooooooo`<00031:h=]C2^3KIX/:f]H0000
=000000000000000ooooooooool60000Zb`;Jm@/of[d;15[52dSJb0]C6/>;Fa[?@0000P0000l0000
200003l0000H0000W@800?`1003D0P00i@H001<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000c`8001d4000L1000]@@0000000160000500000P00017A4U30`000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000<000000000000008bj4`3X^Q<03P4000L2002<B1P10000000000d48000600003@I00eL7@0=
600007[gbS1300006000062g4`000000600000@000010000F;LC03bg4`06m/X`0?mP<A@0001LmLX`
?;LC01P000040000[4VB0:e:033H7@0=100009XC0S0D0000[4VB09QUDc0001P15P0004`0002D]a<0
AQ<2<1HF0@4]01<0=M<1<12n4`000000/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S0F5P41
;@0C000000130000T@D2<<Rh4`1lKAP1C<jB01bh4`1RO0X`DaX:ea2n4`0>008`0?SoofAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0003_0P00
=0@00203002U10000@0005EE1d5f@0M1k`8008h400010000C00000000000000000000?oooooooooo
D00007D0000b00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0`00000000000000S;XC0>Rj4`0>0@001`8008a860400<X`0?mP<A@0001LmLX`?;LC01P000040000
[4VB0:e:033H7@0=100009XC0S0D00006;LC0000002h095lh1lJ0>Bg4`11095lB0LE05d0TGaC6P[H
j1lJ0>PO6P000000/6<H0@00002HIE<`P;PC07a`BC000000000C00000S0F5P41;@0C000000130000
T@D2<<Rh4`0ed`4`4;hC0000001@I1P1DaX:eb00000>008`0?SoofAf00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D06?HQ02D00010haL0000:0=@C003H]`40100002Rg4`3c4R5MI7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000?l0009D0000E0000243000d1000
@@<00:D400010000EED7@GI01d4Q0`00SP@00040001<00000000000000000000oooooooooom@0000
:0000240000F000030000000000U0000300000h0080X000030000040001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000030000
00000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGaC6P[Hj1lJ0>PO6P000000
/6<H0@00002HIE<`P;PC07a`BC0H]a<000000;P0TGcP7aX0i;LC0440TGa81aD0G@2AO5<J2]WX7aX0
j1lJ0000001@I1P1DaX:eb00000>008`0?SoofAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0
6?HQ03GC0C0@_Q<000000?1T607H]`40800002Rg4`3c4R5MI7H02000000j208`@><G0<Bg4`1NF_=g
a;LC00005@0`n2409@00043S5`0000X0k1D00=Rg0@040000:;LC0?<B8EeTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000@P<003@4001O0`00
Y@@00040001EE@M1MT07@D83002>10000@0004`00000000000000000003ooooooooooe00001d0000
700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000<000000000
000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO5<J2]WX7aX0j1lJ0000001@I1P1
DaX:eb00000>008`0?SooaRg4`000000^02AO>0O6P3T]a<0@@2AO4P75@1M095lDaX:f^PO6P3X7aX0
00000?1T607H]`40800002Rg4`3c4R5MI7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@0`n240
=M<1<12n4`000000T6DH0MRg0@0P0000:;LC0?<B8EeTMP08000003X80S10haL0a;LC05iJlgO4]a<0
000E04Sj8@0U0000@><G00002P046000f;L100@0000X]a<0la8QGFAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005@0001N0`00=0@007h3002U1000
0@0005EE1d5f@0M1GP<008h400010000C00000000000000000000?ooooooooooD00002T0000Q0000
5P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000AdA9@`80003C0`00
/`800<84001;0`00000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000
S;XC0>Rj4`2`0000DP4008a8604001<0i;HC04AS604>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000007T03@00TP2HIE<`D6@H0@00002D]a<0[a82<2d04`0ed`4`
4;hC0000002`HaP1000009QUDc20^1<0O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`
b;PC07a]607DcI807;PC069l2S3K4P[T4;hC00h00S00n?ooI7H02000000U000030000040000F0000
300001P0000B000030000040000H000030000000009D0000E00002X4003:0P00I`@003/300010000
EED7@GI01d4[100090<00040001<00000000000000000000oooooooooom@0000DP0003d0000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P0009`4002S1@00
L`D00>`500000000AP0002P0000L0000AdA9@`80002L1000X`D007<5002m1@00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0`2>00002`000024<3K
000009P0000000000038@@80000000110000008@`=/00000V@00o`Q03@</00008000008@`=/20000
000005DWUDAEmkE4ELV/A5Gg]D@00@615D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@2@0@0000000000V@00000000000000000U000030000040000U0000300000D0081G0000
900009/4002Q1@00M0D00;d500020000S4[dFUeFm5XU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0009`4003B1@00L`D00>`500000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q03P8h0000;000008@`=/00000V000000000000<Q10P00000004400000
0Q30f`00002I003o240?0b`0000P00000Q30f`8000000000EBNEA03T^dAEbJa40>BkA0010H4E@0l0
400000@0000>00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P0000000000081090100000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000V`@00=45001d1@00k@D00080002<B^YM
GEKZGBD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000W0@00:<5001c1@00_@D0000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D0=010000040000
3000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@00000000000000000U0000
30000040000U0000300000D0081G0000900009/4002Q1@00M0D00;d500020000S4[dFUeFm5XU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0009`4003B1@00L`D00>`500000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E03`0@0000100000h0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0@0003P000000000>000000000000P40T0400000000009T000000000000000009@0000`000010000
9@0000`000050020E`0002@0002K1000d@D007@5003]1@000P0008a:jUeME^YM9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`8000011@00V@4000l5002f1@00000004H0002X0000W00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@102>00002`000024<3K000009P000000000
0018@@80000000110000008@`=/00000V@00o`Q04@</00008000008@`=/2000000000:/0XDB[4]13
Z`2QA5Gg]D@00@<35D0A0100000400004000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000040000U0000300000D0081G000090000005002H0@00
3`D00;L500020000NE3k6GU@m5XU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000045003H1@00
3`D0030700000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q04P8h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240C0b`0000P00000Q30f`8000000000Z`2QA03T^dB[0:54Zb[UA0010`<E@1<0400000@0000B0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5L0000T000000D00=L5000?1@00<@L00080001iD>YMNE2>LRD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000j@@000/7000V1@00B0L0000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240D0i00002400000Q30f`d000000000
EORPA:/lhTAoEIm4ZccRA002WT@ZT>=400:NA00ciD@00Yi4emGVA7mEWdAF:NQ4EORPA5HYj4@/Vj94
ERWXA:_^XdCGeNI4ZnjSA00ciDB[kZ=4:Y3SA2bKXTB[?>94EORPA:/lhT@00`<30`<30`<30`>3PLI2
540DP10000040000V@00obP0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00002000000000000V@0000009@0000`000020000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000ME0GLJ=?5g7iC/5a
nDjBL_U>Hg>SC`edME0=M4IA3GC`DF=cl56BL_1A`G56DAMaME0GLC`000080000?P0001P0003_1000
4@L001l500111`004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q05@940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0D0100000400005@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000100009@0000`000050020E@000500003X1000
2PL002L500191`003@0007E@5g6SCaManDk1LOU>TW;iCV=cXdl=M7E@3GA6D@edl55SLo1ATW;`DL5a
AU4GLGE@5g4U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000>T4001610009PD008<400000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q05P>@0000
Q000008@`=/=0000000005GhX4AEXHU4OeFOA5FQRD@00Yi4e?B:A002WTBZUha400:NA84jSTAoEIm4
08j?A5GhX4@0SXm4;9^RA02>SdB[kZ=4PCZ>A:_^XdBZUha4ZnjSA=CdRT@/Vj94EJ69A5GhX4AEXHU4
00<30`<30`<30`<3P`<30aA05X0@0000100009T00?lQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000P0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@0007E@bDBSClU4nDicAOU>A4KiCQI7XdnoAgE@_dM6DKm7
l54FAo1AA4K`DG=5AU79A7E@bD@l0000200003h0000H0000k`@004`4000O1@00O0@001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@1L2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE05P0@0000100001L0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5D0001@0000j0@004D4000W1@00Q0@000d0001eD<U4
Xdo9A?U>LdGiCTA6nDhFAj=?_dMeD;m7AU6oAo1A5TO`DDA6l55cADIAbDAeD<U49@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003D0`00M`D00<84000?1P00000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000000000000000000S;XC0>Rj4`2`0000DP4008a8604001<0i;HC04AS604>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C00000013000008D03@00TP2HIE<`
D6@H0@40002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0O719<000000001<0
>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]607DcI807;PC069l2S1C6P[Y4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000000009D0000
E00002T4002>1@00K@@00?l500010000EED7@GI01d4Y1000j0D00040001<00000000000000000000
oooooooooom@0000@`3ood<0000F000030000000000U0000300000h0080X00003000004000160000
:00001`00017A4U30P000286001g1@00K`L000l600000000AP0001@000080000AdA9@`<0001B0000
L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC00h100070P00S4PH0@004`3T]Q<0A6<H0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000T00=002B09QUDc3@IQP1
0@0009Bg4`2_4P8`;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`000000004`0j208`
5QH10Bd04`000000@`0009450S38^1<0O6dH0GC>TP0L^1<0HW`:<=/B2_d@_Q<03P02<03hoomTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
@PH008h5001c1P00o`D00040001EE@M1MT07@D86003X1@000@0004`00000000000000000003ooooo
oooooe00001e0?oo<P0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@000;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<03P4000L2002<B1P1001Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO>0O6P3T]a<0@@2AO4P75@1M095l
fa8:o^PO6P3X7aX000000;1S60400000V6EC<82h4`1lL4T`000000004`00008`5QH10Bd04`000000
@`0009450S38^1<0=M<1<12n4`000000D6@H0M/B2_dP00003P02<03hoomTMP08000003X80S10haL0
a;LC05iJlgO4]a<0000E03PF8P0U0000@><G00002P3d<`00f;L100@0000X]a<0la8QGFAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0001d1P00
a@D009D6000@1P000@0005EE1d5f@0M1M0H0004600010000C00000000000000000000?oooooooooo
D0000380oolR00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1000000000000000S;XC0>Rj4`0>0@001`8008a8604001<0@@2AO4P75@1M095lfa8:o^PO6P3X7aX0
00000;1S60400000V6EC<82h4`1lL4T`6;LC0000002h095lh1lJ0>Bg4`11095lB0LE05d0TGcK4P[o
j1lJ0>PO6P000000D6@H0M/B2_dP00003P02<03hoomTMP08000000000S10haL0a;LC05iJlgO4]a<0
000E03PF8P0ed`4`4;hC0000003`I1P1f;L10200000X]a<0la8QGFAf00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D0D1PR02D00010haL0000:00`f003H]`40100002Rg4`3c4R5MI7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000?l0009D0000E00009H6002>1@00
]PH00?l500010000EED7@GI01d6F1P00j0D00040001<00000000000000000000oooooooooom@0000
:03oob40000F000030000000000U0000300000h0080X000030000040001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000040000
00000000002<^Q<0j;XC00h100070P00S4PH0@004`11095lB0LE05d0TGcK4P[oj1lJ0>PO6P000000
D6@H0M/B2_dP00003P02<03hoolH]a<000000;P0TGcP7aX0i;LC0440TGa81aD0G@2AO=/B2P3X7aX0
j1lJ0000003`I1P1f;L10200000X]a<0la8QGFAf00P000000002<43S5`34]a<0GU[cMlBg4`0001D0
D1PR03GC0C0@_Q<00000091U607H]`40800002Rg4`3c4R5MI7H02000000j208`@><G0<Bg4`1NF_=g
a;LC00005@1X6R809@00043S5`0000X093P00=Rg0@040000:;LC0?<B8EeTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000]`H008h5003D1P00
o`D00040001EE@M1MT07@KL6003X1@000@0004`00000000000000000003ooooooooooe00001d0?oo
700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@000@0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<03P4000L2002<B1P1000C0440TGa81aD0G@2AO=/B2P3X7aX0j1lJ0000003`I1P1
f;L10200000X]a<0la8QGARg4`000000^02AO>0O6P3T]a<0@@2AO4P75@1M095lfa8:0NPO6P3X7aX0
0000091U607H]`40800002Rg4`3c4R5MI7H020000000008`@><G0<Bg4`1NF_=ga;LC00005@1X6R80
=M<1<12n4`000000<6HH0MRg0@0P0000:;LC0?<B8EeTMP08000003X80S10haL0a;LC05iJlgO4]a<0
000E080L8P0U0000@><G00002P0l>P00f;L100@0000X]a<0la8QGFAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005@0003C1P00SPD00?<6003o1@00
0@0005EE1d5f@0M1d`H00>P500010000C00000000000000000000?ooooooooooD00002T0oolQ0000
5P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000AdA9@`80003e0@00
V@4000h5002W0@00000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@1P2>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000
V@00o`Q06@</00008000008@`=/200000000003XoD>[4]130?2PA:/Bd4<00@<35D0I010000040000
6000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000040000U0000300000D0081G000090000?@1002H0@003`D00:L100020000]Aok6G1@naTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000=84001^0P00?PD009L300000000AP0005P0001<0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Y0080T000060000?ooool10000
01BKA:]:7DA@UKe2ZZZ=@bP0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00002000000000?ooo`0000009@0000`000020000
9@0000`000080020EP000300003H1000M08003L5002@0`001@00089=BbN2C@0iKe<0>FmCBbN2CD/W
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
AP0009`0002@0000ADe6:`Q06P900000=000008@`=/00000eP000000000004Q10P00008000000011
0P00000000024<3K000009T00?l8@1/3?000030000024<3K10000000000059]4ZdXMA00DVd@086A4
ENfVA00PI4AEkJI4ZdXMA0010H4E@1/0400000@0000J0000>P0000`000080000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000P0@380000
00000000V@00000000000000000U000030000040000U0000300000D0081F0000;00009h4000j0P00
L@D00<X300040000PTe;9h9=03U_D`0iKe=;9bD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@0003X0000<00002P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000O`400>P3001i0P00hP@0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240L0i00002400000Q30f`d0000000000>Sm@eFaNdBS@Me3
EK5kA:_:`T=YMXA4Zl[2@`2PS4B[b/93UlVDA:=1gD=EIi]40>Sm@eEWVd@_A`m4EFNKA:^274BGbIA4
Zh8LA02PS4B[PQa4JGJ4A2m73dAE/G]40>Sm@eFaNd@00`<30`<30`<30`>3P@00540LP10000040000
ooooob4000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
9@0000`0000200004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
]AoU?Z4KiCiB63A2DQQ8AU8HGDZQ6ja=]An/CLXS[4dI9ee:6BM8AQTW=4;:8nDn]AoU?S`000080000
?P0001P000250@00kP<00782003K10004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q07@940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0L010000040000
7@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000100009@0000`000050020
E@000500001m0@00i`<007T2003R10003@000;DOiCjQ6nDnDQPd@U8HB4IB65e:XA^/CKDO[4g:8ja=
6BMMBQTWB4HI9cA2bR?U?[DOiChU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<0001B0000L0400040001Zoooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000000008a860410000
00000000000000000000000000070000R?FB0=C=TP2XF>H`S4PH0F`:604D0000D;PC0000001lKAP1
0@000040001@^1<0AhW/<000001lKAP100000=C=TP34BAP1000007a]605P0000G;PC06aHiS010000
00000080000T3aP1h;PC00SQTP00000000000?oooom8T>``m8XH0Ga]607<^A<00@0003GC0C0@_Q<0
00000;1S604511P11@@H0M5l3C1E00001@@H0@004`000000000002bi4`000000000007a]604/^A<0
GXg/<7a]604000005;TC02Bi4`000000h5<H0F`:605TMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<0000002I0U@0001D0000aP4001L4000a0P00`0@00040001EE@M1
MT07@LH1002M10000@0004`00000000000000000003ooooooooooe00001E0000K00001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000k@D00:L4000[1P00
j@H0000000160000504000P10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240N0Z@0002H00000Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/00000
0P0000800000080o0P00008000000000000P@@00P3l000000000000000000000:000008@`=/30000
0200000084000;3000000000P;l00230002``0010@024<3K00000000ool8@1l3;000020000024<3K
0P000000001EOL54ZgZEA5Em`DB[H=a40041PAE07`0@0000100001h0000X000030000080000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000004P4040000000003o000000000000000000009@0000`000020000
9`0001P00001000000000?l0000000009@0000`0000100004`0000`000020000>`0000P0000K0000
40000?YP002fBP00F@0002P00000000000000?oooooooooo0`000?YPY6edH:A]M62fBSd000080000
6`000100000oHP00K6/005T0000T000000000000003oooooooooo`80002gH2e^<5m/JeP0000d0000
00000000003oooooooooo`H0000NGda[:ElSJdUO4F]ZGomZTUl;JjAO:f]I0000:000000000000000
ooooooooool30000lF23KGePPfg:HB][F00003@00000000000000?oooooooooo1P000=aQ2f/5H_mZ
9F8AJdER8f]AHTa[?f9/Jcd000080000?00000P0000o000060000?05002Y10009`H00>D6000C0000
30000040000U000030000000080U0000300000L0080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000=00002P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000208@0000P0001R000030000040001<0000I00007T1002D0@000`L004d7001i0@00
U04008/5002j1@00:@2Z0000000000000020?`00000000000020?`00000000000000000000000000
00000000000000008P0000`0003oooooAP0001`0000@0000ADe6:`90000<0000000000h0000D0000
00000100000D0000
\>"], "Text",
 ImageSize->{231., 221.0390143737166}],

Cell[TextData[{
 "Koeficient ",
 StyleBox["a0", "Program",
  FontWeight->"Bold"],
 " p\:0159edstavuje stejnosm\:011brnou slo\:017eku ve vstupn\[IAcute]m sign\
\[AAcute]lu. Mus\[IAcute]me proto stanovit p\:0159enos pro obvod ve stejnosm\
\:011brn\[EAcute]m stavu. Tedy, rozpoj\[IAcute]me kondenz\[AAcute]tory a \
zkratujeme c\[IAcute]vky a obdr\:017e\[IAcute]me: "
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0002kX0@0006`0001i0@00U04000<7001=1`00
Z0`0084=003j?P00[cd00215CDH00040j2h00481000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
m@4009T100030P00<@L0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@043;000020000024<3K0P0000000000j?e3EC_UA03XoD>Y4]130041PAE00@0@0000
10000000000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003d0@00V04000<2000a1`000P000;DOUW:e7o/I
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`8000011@00GP@00>L6001/1000000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@082>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q00`</00008000008@`=/20000
00000:/0XD@0X8a4EPgLA02PS4@00@615D030100000400000P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081G0000
90000005001M1000j0H006`400020000NE18A_m]B4HU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000?D1000S1`00i`H0034700000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0108h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o24050b`0000P00000Q30f`80000000000>Sm@j/ZiDB[o=]4ES_UA0010H4E@0D0
400000@0000400008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000m0400247003W1P00<@L00080002e7hib
mffFLRD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000`PH004H4003o1P00P`@0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`000800002024060i0000240000
0Q30f`d00000000000GLA5FQRD@ZH]Y4EJ69A:/>fDCDm8Y4Z`kIA:ZGS4B[3]U4PCZ>A2YRfT@0SXm4
00GLA02>SdCGYme408j?A5KkgTB1>Xi4E__NA:ZGS4AFnmi4e?B:A=NWgDAEXHU400GLA5FQRD@00`<3
0`<30`<30`>3PLI25406P10000040000ooooob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00001000000000?ooo`0000009@0000`000010000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000nfg9A2Y]bDB0K7=5
P6a4AX1/5TLZKKm7nffoAla^_dMfKaI7MVm4AWI_LdG<K/U4nfg9A3`000080000?P0001P000381P00
C0@00?P6001l10004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q01`940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D060100000400001`0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000200009@0000`000050020E@00050000301P00
A@@00?l6002410003@000?]]bD@ZKLU4P6acAH1/A4J0K1I7:VfoAo]]_dO<K[m7MVlFAgI_A4IfKg=5
c6k9A?]]bD@U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<86000;1`00o`H004P700000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q020>@0000
Q000008@`=/=000000000005g4B[?>94:V;JA:/lhTB[3]U4:Y3SA:/>fD@0<nE4Z`kIA=OEiT@ZH]Y4
ERWXA005g4AF:NQ4ejOMA5HYj4AFnmi4emGVA5KkgT@0<nE4E__NA2Z@hdCGYme4ZccRA005g4B[?>94
00<30`<30`<30`<3PoP<0QA0280@000010000?oooolQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000@0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@000?]]5g4ZKAMaP6c1LH1/TW:0K6=c:Vd=M?]]3GC<KPed
MVmSLgI_TW9fKl5ac6hGLO]]5g4l0000200003h0000H0000b0H00147003h1P00@@L001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@0T2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE0200@0000100000T0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0001@0000`0H000X7003o1P00B@L000d0003kKAMa
:VdGLH1/`G60K99bP6aSLbY]3GCkK@edc6h=M7I_Hg=fKi9bMVo1LLa^5g7kKAMa9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002J0P00nP400=P2003Y1P00000004H0000D0@00204004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@0X2Y00009P000024<3K000009`@00000000
EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l200000P00000000000211
0020?`000000000000000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;30
0041008@`=/00000003oo`Q02`</00008000008@`=/200000000000h;T@0N?m303P^A:]Pg4@00@61
5D0;0100000400002P0002P0000<00000@00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000040000W00006000008000000000o`000000000U0000
30000080000C000030000080000k0000200001/0000@0000bB/00>LO001I0000:000000000000000
ooooooooool30000bB^TKD@[Y6e4:nLO?@0000P0000K0000400000h]001/J`00F@0002@000000000
00000?oooooooooo0P0008H[;Fko:Fa[F00003@00000000000000?oooooooooo1P000>dYC6_i:B=[
6BXAJcTZofYR:P][LbX[JeT0000X000000000000003oooooooooo`<00031:h=]C2^3KIX/:f]H0000
=000000000000000ooooooooool60000Zb`;Jm@/of[d;15[52dSJb0]C6/>;Fa[?@0000P0000l0000
200003l0000H0000W@800?`1003D0P00i@H001<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000c`8001d4000L1000]@@0000000160000500000P00017A4U30`000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP00004000000000000008bj4`3X^Q<03P4000L2002<B1P1000C0>Bf4`14HaP13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002aJP/00980V6EC<?1T60430000
U;LC0:lB0S0]01<0=M<1<12n4`000000/6<H0@00002HIE<`P;PC07a`BC000000000C03X80S0F5P41
;@0C000000130000T@D2<<Rh4`1lKAP1o<fB01bh4`1RO0X`8aX:@12n4`0>008`0?SoofAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0003_0P00
=0@00203002U10000@0005EE1d5f@0M1k`8008h400010000C00000000000000000000?oooooooooo
D0000640000b00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0@00000000000000S;XC0>Rj4`0>0@001`8008a860400640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095lh=lK0>Bg4`11095lB0LE05d0TG`S6PY1
j=lK0>SO6`000000/6<H0@00002HIE<`P;PC07a`BC000000000C00000S0F5P41;@0C000000130000
T@D2<<Rh4`0ed`4`4;hC0000001@I1P18aX:@200000>008`0?SoofAf00P00000>PP2<43S5`34]a<0
GU[cMlBg4`0001D0d?<K02D00010haL0000:0=@C003H]`40100002Rg4`2@6B43I7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000?l0009D0000E0000243001[1000
@P<00;H400010000EED7@GI01d4Q0`00Y`@00040001<00000000000000000000oooooooooom@0000
<0000280000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P000=<3002c0P00`P@004/300000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000
00000000002<^Q<0j;XC0;00001B0@00S4PH0@004`3T]Q<0A6<H0@h00S2moooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000FVX;002B09QUDc1@I1P1000009Bg4`2_4P8`
;@0C03GC0C0@_Q<000000;1S60400000V6EC<82h4`1lL4T`000000004`0j208`5QH10Bd04`000000
@`0009450S38^1<0O6dH0MC=TP0L^1<0HW`:<7@J2ZL@_Q<03P02<03hoomTMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000:P@00<X2001W1000
>`<00040001EE@M1MT07@B/4000T0`000@0004`00000000000000000003ooooooooooe00001B0000
?@0001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000
0@D009T1000?1@00K0@0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240<0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@0d3;000020000024<3K0P000000002[0:54Za;@@`3`X4@0X8a40041PAE03@0@0000
100000`0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003o1000V04000l5001/10000P0007U@naU`D4Q6
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000R1P00M`D006l7000?1P00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000P00000000000000S;XC0>Rj4`0>0@001`8008a8604001<0
i;HC04AS604>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
06EZ2`00TP2HIE<`l6@H0@80002D]a<0[a82<2d04`0ed`4`4;hC0000002`HaP1000009QUDc20^1<0
O719<000000001<0>PP2<1HF0@4]01<0000004<0002A1@8`b;PC07a]607lcI807;PC069l2S0S6PY;
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000?l0009D0000E0000486002>1@00L`H00?l500010000EED7@GI01d521P00j0D00040001<0000
0000000000000000oooooooooom@0000M@000380000F000030000000000U0000300000h0080X0000
30000040001B0000L0400040002moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00002000000000000002<^Q<0j;XC00h100070P00S4PH0@00H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<000000;P0TGcPga/0
i;LC0440TGa81aD0G@2AO2<J2TcXga/0j=lK0000002`HaP1000009QUDc20^1<0O719<000000001<0
0002<1HF0@4]01<0000004<0002A1@8`b;PC03GC0C0@_Q<00000051T604S6PY;800000h00S00n?oo
I7H02000000j208`@><G0<Bg4`1NF_=ga;LC00005@2@o1/09@00043S5`0000X0U1`00=Rg0@040000
:;LC090I8@=TMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001H0000M0H00<D5002g1P0040H00040001EE@M1MT07@G@600011P000P0004`000000000
00000000003ooooooooooe00000b03008P000280000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P000?D1002I0@003PD00:L100000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q03P8h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o240?0b`0000P00000Q30f`8000000000
0>Sm@j/Bd4<0l:14Za;@@`010`<E@0l0400000@0000>00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T0000
m04009P1000?1@00Y`400080002e7o/IL53k6BD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
dP@006h2000n1@00U`<0000000160000F00004`00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000202T00P2@0000H0000ooooo`40000059]4ZdXMA52E_D:ZZXe3:00000`000020000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080000W0000
6000008000000000oooo0000000U000030000080000U0000300000P0081F0000<0000=P4001d0P00
=`D0090300050000PTe;9h9=03U_D`0iKe=;9h9=BbLU0000300000L0080U000030000000080T0000
90000000P440000000000000P44000000000008000160000W00009000015CDH[240@0T00000d0000
0Q30f`00003F000000000000B44200000P000000044200000000008@`=/00000V@00o`Q04@<l0000
<000008@`=/400000000000DVdB[BQe401BKA00PI4AEkJI4021TA5G]YTB[BQe40041PAE04@0@0000
10000100000j0000300000P0000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000002010<P000000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5H0000/0000WP@003X2001a1@00bP<000@00022CD/WPTd0>FmC03U_Dd/W
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`000010000>P0000`0000:00008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001o0@00j0<007T2003R1000
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@183
T00008@000024<3K3@0000000000j?e3EK5kA:=1gD=E/G]4Zl[2@fUfQ4B[b/930:2<A:_:`T>GbIA4
Xd7M@eEWVd@0j?e3EFNKA2m73dAEIi]4Zh8LA9O9U4B[PQa40:2<A:^274AYMXA4;dL?A5FaNd@0j?e3
EK5kA0030`<30`<30`<30h<10H4D@1:0400000@0003ooooo8@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080000U000030000080000C000030000040000k0000
200005D0001@000000000000003oooooooooo`d0002e7nDnXA_U?U8H=49B64Q6DQQMBZ4K[4fe7ja=
bR>/CATWGDXI9dQ66BLd@/XSiCje7nDn?00000P0000n0000600008D1003^0`00LP800=/4000C0000
30000040000U000030000000080T000090000000P440000000000000P44000000000008000160000
I00005P00015CDH[240C0T@0000h00000Q30f`00003N000000000000B44200000P00008000000011
0P00000000024<3K000009T00?lE@180400000@0000C0000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000000@38000000000000V@000000
00000000000U000030000040000U0000300000D0081E0000D00007d1003W0`00N@800>84000=0000
]AoU?Z4KiCiB63A2DQQ8AU8HGDZQ6ja=]An/CLXS[4dI9ee:6BM8AQTW=4;:8nDn]AoU?RD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`000580001`0@000@0006[oool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP00000000000000S4PH0@40000000000000000000000000000000L00028mI80
e<fB0:QHiS2<B1P1K0XH0A@0001@^1<0000007a]604100000@00052h4`17RN``000007a]60400000
e<fB0<A960400000O6dH0F00001L^1<0K5SV<040000000000P0002@?607P^1<02>6B000000000000
ooooodR@k33dRQP1O6dH0Lbi4`010000=M<1<12n4`000000/6<H0@D4604511P1dG`=<5D0000511P1
000C000000000000;;TC000000000000O6dH0Bbi4`1NSN``O6dH0@00000D^A<09;TC0000003PDaP1
K0XH0FAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`0000009T2
E00005@000360@005`@00342003010000@0005EE1d5f@0M1aP4009d400010000C000000000000000
00000?ooooooooooD00005D0001/00005P0000`0000000009@0000`0000>0020:00000`000010000
AP0002P0000L0000AdA9@`80003]1@00Y`@002/6003Y1P00000004H0000D0@00204004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@1@2Y00009P000024<3K000009`@00000000
EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l200000P00000000000211
0020?`000000000000000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;30
0041008@`=/00000003oo`Q05@</00008000008@`=/20000000005Em`DB[NYE4EGg1A:]Pg4@00@61
5D0E010000040000500002P0000<00000P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000W00006000004000000000o`000000000U0000
30000040000C000030000080000k0000200001/0000@0000nV000;I:001I0000:000000000000000
ooooooooool30000nV2TKGAPY6edH;I:?@0000P0000K0000400003mR001/J`00F@0002@000000000
00000?oooooooooo0P000;MP;Fh`Gfa[F00003@00000000000000?oooooooooo1P0001iOC6/YGb=[
BElAJfYOofZBG`][Y5l[JeT0000X000000000000003oooooooooo`<0003aH8=]OF23KLYQ:f]H0000
=000000000000000ooooooooool60000g64;J`ERofXUHQ5[AF8SJe5RC6/oHVa[?@0000P0000l0000
200003l0000H0000l0D00:T4000W1P00i@H001<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000d0000
:00004E=AR/Z@000900001P00000080o0000P0000800080o0000P000080Q000020000680000<0000
0@0004`0001T0000N@4009@100031`00C@L007T1002D0@00R`D00;X5000Y0:X0000000000000080o
000000000000080o0000000000000000000000000000000000000000000R000030000?oooom60000
700001000015CDH[0T0000`0000000003P0001@000000000400001@0
\>"], "Text",
 ImageSize->{227.66666666666666`, 217.84941820670775`}],

Cell[TextData[{
 "P\:0159es rezistor nete\[CHacek]e \:017e\[AAcute]dn\[YAcute] proud, nen\
\[IAcute] tedy na n\:011bm \:017e\[AAcute]dn\[YAcute] \[UAcute]bytek \
nap\:011bt\[IAcute], a proto ",
 StyleBox["u", "Program",
  FontWeight->"Bold"],
 StyleBox["20", "Program",
  FontWeight->"Bold"],
 "==",
 StyleBox["a0", "Program",
  FontWeight->"Bold"],
 ". Stejnosm\:011brn\[YAcute] p\:0159enos je proto jednotkov\[YAcute]."
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
   3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
   3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
   3.492037154546875*^9, 3.492037206140625*^9}, 3.492037366859375*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"prenos0", "=", "1"}], ";"}]], "Input"],

Cell[TextData[{
 "Impedance kondenz\[AAcute]toru je z\[AAcute]visl\[AAcute] na frekvenci. Pro \
\[Omega]",
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontSlant->"Italic"],
 " je rovna"
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037408421875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Zc", "[", "n_", "]"}], ":=", 
   FractionBox["1", 
    RowBox[{"I", "*", 
     RowBox[{"omega", "[", "n", "]"}], "*", "c"}]]}], ";"}]], "Input"],

Cell[TextData[{
 "P\:0159enos obvodu pro frekvenci \[Omega]",
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontSlant->"Italic"],
 " je tedy roven:"
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920381836875*^9, 3.4920382024375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"prenos", "[", "n_", "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"Zc", "[", "n", "]"}], 
     RowBox[{"R", "+", 
      RowBox[{"Zc", "[", "n", "]"}]}]], "/.", "soucastky"}]}], ";"}]], "Input"],

Cell[TextData[{
 "P\:0159enosy pro jednotliv\[EAcute] frekvence spo\[CHacek]\[IAcute]t\
\[AAcute]me a ulo\:017e\[IAcute]me do seznamu ",
 StyleBox["prenosy", "Program",
  FontWeight->"Bold"],
 ":"
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920374785625*^9, 3.492037508953125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"prenosy", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"prenos", ",", "rn"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.492038811578125*^9, 3.492038817125*^9}}],

Cell[TextData[{
 "Pro ka\:017edou frekvenci spo\[CHacek]\[IAcute]t\[AAcute]me f\[AAcute]zor v\
\[YAcute]stupn\[IAcute]ho nap\:011bt\[IAcute] jako sou\[CHacek]in \
f\[AAcute]zoru vstupn\[IAcute]ho nap\:011bt\[IAcute] a p\:0159enosu na dan\
\[EAcute] frekvenci. \n\nSou\[CHacek]iny m\:016f\:017eeme prov\[EAcute]st \
hromadn\:011b vyn\[AAcute]soben\[IAcute]m seznam\:016f ",
 StyleBox["fazoryVstup", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["prenosy;", "Program",
  FontWeight->"Bold"],
 " dostaneme seznam sou\[CHacek]in\:016f (v\:017edy ",
 StyleBox["i",
  FontSlant->"Italic"],
 "-t\[AAcute] polo\:017eka prvn\[IAcute]ho seznamu se \
vyn\[AAcute]sob\[IAcute] s ",
 StyleBox["i",
  FontSlant->"Italic"],
 "-tou polo\:017ekou druh\[EAcute]ho seznamu):"
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920374785625*^9, 3.492037508953125*^9}, {3.4920375681875*^9, 
  3.49203757809375*^9}, {3.49203761609375*^9, 3.4920377086875*^9}, {
  3.4920378448125*^9, 3.492037916703125*^9}, {3.492038230359375*^9, 
  3.492038240015625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"fazoryVystup", "=", 
   RowBox[{"fazoryVstup", "*", "prenosy"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.492038822453125*^9, 3.492038835609375*^9}}],

Cell[TextData[{
 "Harmonickou funkci o kruhov\[EAcute] frekvenci \[Omega]",
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontSlant->"Italic"],
 " obdr\:017e\[IAcute]me tak, \:017ee jej\[IAcute] f\[AAcute]zor \
vyn\[AAcute]sob\[IAcute]me v\[YAcute]razem ",
 Cell[BoxData[
  SuperscriptBox["E", 
   RowBox[{"I", "*", 
    RowBox[{"omega", "[", "n", "]"}], "*", "t"}]]],
  CellChangeTimes->{{3.491941214546875*^9, 3.4919413581875*^9}, {
    3.491941675125*^9, 3.491941677375*^9}, {3.4919418035625*^9, 
    3.491941825359375*^9}, {3.4919498609375*^9, 3.4919498674375*^9}, {
    3.491949941203125*^9, 3.491949947796875*^9}, {3.4920325791875*^9, 
    3.492032686484375*^9}, {3.49203277121875*^9, 3.492032793375*^9}, 
    3.492035605171875*^9, {3.4920357714375*^9, 3.49203577828125*^9}, {
    3.492037209234375*^9, 3.49203722346875*^9}, {3.492037257609375*^9, 
    3.492037262921875*^9}, {3.49203741875*^9, 3.492037469078125*^9}, {
    3.492037518984375*^9, 3.492037535796875*^9}, {3.492038411546875*^9, 
    3.49203844278125*^9}, {3.492038491421875*^9, 3.49203850925*^9}, {
    3.492038546203125*^9, 3.492038555421875*^9}, {3.4920387120625*^9, 
    3.492038718390625*^9}, 3.4920387529375*^9, 3.4920388086875*^9, {
    3.492039179578125*^9, 3.492039189078125*^9}, {3.4920394559375*^9, 
    3.492039526625*^9}, {3.492039650265625*^9, 3.4920396561875*^9}}],
 " a vybereme imagin\[AAcute]rn\[IAcute] \[CHacek]\[AAcute]st. Jednotliv\
\[EAcute] harmonick\[EAcute] funkce, z nich\:017e se skl\[AAcute]d\[AAcute] v\
\[YAcute]stupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "2(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), ulo\:017e\[IAcute]me do seznamu ",
 StyleBox["harmVystupy", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920374785625*^9, 3.492037508953125*^9}, {3.4920375681875*^9, 
  3.49203757809375*^9}, {3.49203761609375*^9, 3.4920377086875*^9}, {
  3.4920378448125*^9, 3.492037916703125*^9}, {3.492038230359375*^9, 
  3.492038240015625*^9}, {3.49203970540625*^9, 3.49203977121875*^9}, {
  3.49203980196875*^9, 3.492040014203125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "n_", "]"}], ":=", 
   SuperscriptBox["E", 
    RowBox[{"I", "*", 
     RowBox[{"omega", "[", "n", "]"}], "*", "t"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eenka", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"e", ",", "rn"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"harmVystupy", "=", 
   RowBox[{"Im", "[", 
    RowBox[{"fazoryVystup", "*", "eenka"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.491941214546875*^9, 3.4919413581875*^9}, {
   3.491941675125*^9, 3.491941677375*^9}, {3.4919418035625*^9, 
   3.491941825359375*^9}, {3.4919498609375*^9, 3.4919498674375*^9}, {
   3.491949941203125*^9, 3.491949947796875*^9}, {3.4920325791875*^9, 
   3.492032686484375*^9}, {3.49203277121875*^9, 3.492032793375*^9}, 
   3.492035605171875*^9, {3.4920357714375*^9, 3.49203577828125*^9}, {
   3.492037209234375*^9, 3.49203722346875*^9}, {3.492037257609375*^9, 
   3.492037262921875*^9}, {3.49203741875*^9, 3.492037469078125*^9}, {
   3.492037518984375*^9, 3.492037535796875*^9}, {3.492038411546875*^9, 
   3.49203844278125*^9}, {3.492038491421875*^9, 3.49203850925*^9}, {
   3.492038546203125*^9, 3.492038555421875*^9}, {3.4920387120625*^9, 
   3.492038718390625*^9}, 3.4920387529375*^9, 3.4920388086875*^9, {
   3.492039179578125*^9, 3.492039189078125*^9}, {3.4920394559375*^9, 
   3.492039526625*^9}, {3.492039650265625*^9, 3.4920396561875*^9}, {
   3.49203999275*^9, 3.49204002078125*^9}}],

Cell[TextData[{
 "V\[YAcute]stupn\[IAcute] nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "2(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") slo\:017e\[IAcute]me z ",
 StyleBox["n",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch funkc\[IAcute]."
}], "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920374785625*^9, 3.492037508953125*^9}, {3.4920375681875*^9, 
  3.49203757809375*^9}, {3.49203761609375*^9, 3.4920377086875*^9}, {
  3.4920378448125*^9, 3.492037916703125*^9}, {3.492038230359375*^9, 
  3.492038240015625*^9}, {3.49203970540625*^9, 3.49203977121875*^9}, {
  3.49203980196875*^9, 3.4920400736875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nahradaVystup", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a0", "*", "prenos0"}], "+", 
    RowBox[{"Apply", "[", 
     RowBox[{"Plus", ",", 
      RowBox[{"Take", "[", 
       RowBox[{"harmVystupy", ",", "n"}], "]"}]}], "]"}]}]}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Zobrazen\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "2(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") slo\:017een\[EAcute] z harmonick\[YAcute]ch funkc\[IAcute]"
}], "Subsubtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}, {
  3.49202873028125*^9, 3.49202876028125*^9}, {3.4920755953125*^9, 
  3.492075598578125*^9}, {3.4920758321875*^9, 3.492075854109375*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell["\<\
Zb\[YAcute]v\[AAcute] zobrazit v\[YAcute]sledek. Prove\:010fme p\:0159\
\[IAcute]pravu k zobrazen\[IAcute].\
\>", "Text",
 CellChangeTimes->{{3.49203549528125*^9, 3.49203557196875*^9}, {
  3.492035837265625*^9, 3.49203591046875*^9}, {3.492037005609375*^9, 
  3.492037069296875*^9}, {3.492037101453125*^9, 3.492037109515625*^9}, {
  3.492037154546875*^9, 3.492037206140625*^9}, {3.4920373349375*^9, 
  3.4920373375*^9}, {3.492037377359375*^9, 3.492037443671875*^9}, {
  3.4920374785625*^9, 3.492037508953125*^9}, {3.4920375681875*^9, 
  3.49203757809375*^9}, {3.49203761609375*^9, 3.4920377086875*^9}, {
  3.4920378448125*^9, 3.492037916703125*^9}, {3.492038230359375*^9, 
  3.492038240015625*^9}, {3.49203970540625*^9, 3.49203977121875*^9}, {
  3.49203980196875*^9, 3.4920400736875*^9}, {3.49204093309375*^9, 
  3.492040951109375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fourierPlot", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahradaVystup", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<u[t]\>\""}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fourierPlotn1", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahradaVystup", "[", 
      RowBox[{"n", "-", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<u[t]\>\""}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"plHarmVystup", "[", "n_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"harmVystupy", "[", 
      RowBox[{"[", "n", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Green"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys3", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"nDSolvePlot", ",", 
     RowBox[{"fourierPlot", "[", "n", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys4", "[", "n_", "]"}], ":=", 
   RowBox[{"Show", "[", 
    RowBox[{"nDSolvePlot", ",", 
     RowBox[{"fourierPlotn1", "[", "n", "]"}], ",", 
     RowBox[{"plHarmVystup", "[", "n", "]"}], ",", 
     RowBox[{"fourierPlot", "[", "n", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.49204018228125*^9, 3.4920402059375*^9}, {
  3.4920403159375*^9, 3.49204040834375*^9}}],

Cell[TextData[{
 "\[CapitalCHacek]erven\:011b je nap\:011bt\[IAcute] ",
 StyleBox["u",
  FontSlant->"Italic"],
 "2(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), jak ho spo\[CHacek]\[IAcute]tala NDSolve. \[CapitalCHacek]ern\:011b je \
aproximace ",
 StyleBox["u",
  FontSlant->"Italic"],
 "2(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") pomoc\[IAcute] sou\[CHacek]tu ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch funkc\[IAcute]. Nult\[AAcute] harmonick\[AAcute] je \
stejnosm\:011brn\[AAcute] slo\:017eka, tedy sou\[CHacek]in ",
 StyleBox["a0*prenos0", "Program",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
   3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
   3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
   3.4679215163125*^9, 3.467921516703125*^9}, {3.467921598078125*^9, 
   3.467921613671875*^9}, {3.46792268246875*^9, 3.467922711375*^9}, {
   3.468517762578125*^9, 3.468517768734375*^9}, {3.4685202625*^9, 
   3.468520269390625*^9}, {3.4919421591875*^9, 3.491942176046875*^9}, {
   3.491942260203125*^9, 3.491942273578125*^9}, {3.4919423271875*^9, 
   3.4919423275*^9}, 3.491942402859375*^9, {3.491984441140625*^9, 
   3.491984441625*^9}, {3.49202693828125*^9, 3.4920269553125*^9}, {
   3.492027651984375*^9, 3.492027706625*^9}, {3.49202779096875*^9, 
   3.492027831015625*^9}, {3.492040699609375*^9, 3.49204072534375*^9}, {
   3.492040798546875*^9, 3.492040860984375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys3", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.491941553578125*^9, 3.49194156271875*^9}, 
   3.491941596328125*^9, {3.49194188503125*^9, 3.49194188696875*^9}, {
   3.491942377578125*^9, 3.49194238121875*^9}, {3.492040220734375*^9, 
   3.49204025440625*^9}, {3.4920403126875*^9, 3.49204033396875*^9}, {
   3.4920404759375*^9, 3.49204047621875*^9}}],

Cell[TextData[{
 "V n\[AAcute]sleduj\[IAcute]c\[IAcute]m grafu je pro n\[AAcute]zornost nav\
\[IAcute]c \[SHacek]ediv\:011b zobrazena aproximace pomoc\[IAcute] ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["-1",
  FontWeight->"Bold"],
 " harmonick\[YAcute]ch funkc\[IAcute] a zelen\:011b je zobrazna ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-t\[AAcute] harmonick\[AAcute] funkce. \n   \n\
P\:0159i\[CHacek]ten\[IAcute]m zelen\[EAcute] \[CHacek]\[AAcute]ry k \
\[SHacek]ediv\[EAcute] \[CHacek]\[AAcute]\:0159e obdr\:017e\[IAcute]me \
\[CHacek]ernou \[CHacek]\[AAcute]ru."
}], "Text",
 CellChangeTimes->{{3.492027975296875*^9, 3.49202811228125*^9}, {
  3.49202835103125*^9, 3.49202835346875*^9}, {3.49202841603125*^9, 
  3.492028509796875*^9}, {3.492040766515625*^9, 3.492040767015625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys4", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.492040303296875*^9, 3.49204030340625*^9}, {
  3.4920404623125*^9, 3.492040462640625*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1276, 702},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 209, 5, 147, "Title"],
Cell[779, 29, 895, 18, 140, "Text"],
Cell[1677, 49, 710, 15, 98, "Input"],
Cell[CellGroupData[{
Cell[2412, 68, 143, 2, 98, "Subtitle"],
Cell[2558, 72, 278, 5, 65, "Text"],
Cell[2839, 79, 58267, 721, 315, "Text"],
Cell[61109, 802, 624, 21, 90, "Text"],
Cell[61736, 825, 3884, 91, 294, "Input"],
Cell[65623, 918, 346, 11, 65, "Text"],
Cell[65972, 931, 609, 16, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66618, 952, 219, 3, 98, "Subtitle"],
Cell[66840, 957, 798, 27, 90, "Text"],
Cell[67641, 986, 55371, 685, 298, "Text"],
Cell[123015, 1673, 148, 2, 65, "Text"],
Cell[123166, 1677, 464, 15, 71, "Input"],
Cell[123633, 1694, 173, 2, 65, "Text"],
Cell[123809, 1698, 159, 5, 64, "Input"],
Cell[123971, 1705, 149, 2, 97, "Text"],
Cell[124123, 1709, 1606, 41, 228, "Input"],
Cell[125732, 1752, 245, 5, 97, "Text"],
Cell[125980, 1759, 1235, 38, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127252, 1802, 144, 2, 147, "Subtitle"],
Cell[127399, 1806, 903, 24, 135, "Text"],
Cell[CellGroupData[{
Cell[128327, 1834, 263, 10, 100, "Subsubtitle"],
Cell[128593, 1846, 280, 6, 97, "Text"],
Cell[128876, 1854, 243, 6, 106, "Input"],
Cell[129122, 1862, 469, 13, 99, "Text"],
Cell[129594, 1877, 762, 25, 282, "Input"],
Cell[130359, 1904, 745, 29, 99, "Text"],
Cell[131107, 1935, 4644, 98, 453, "Input"],
Cell[135754, 2035, 1701, 50, 279, "Text"],
Cell[137458, 2087, 430, 13, 64, "Input"],
Cell[137891, 2102, 313, 10, 97, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138241, 2117, 397, 12, 100, "Subsubtitle"],
Cell[138641, 2131, 507, 13, 135, "Text"],
Cell[139151, 2146, 171, 2, 97, "Text"],
Cell[139325, 2150, 4717, 127, 349, "Input"],
Cell[144045, 2279, 1361, 29, 99, "Text"],
Cell[145409, 2310, 190, 5, 64, "Input"],
Cell[145602, 2317, 1085, 23, 246, "Text"],
Cell[146690, 2342, 191, 5, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146918, 2352, 129, 2, 99, "Subsubtitle"],
Cell[147050, 2356, 510, 15, 99, "Text"],
Cell[147563, 2373, 135, 4, 64, "Input"],
Cell[147701, 2379, 643, 18, 171, "Text"],
Cell[148347, 2399, 311, 8, 106, "Input"],
Cell[148661, 2409, 292, 6, 97, "Text"],
Cell[148956, 2417, 26591, 330, 529, "Text"],
Cell[175550, 2749, 620, 12, 136, "Text"],
Cell[176173, 2763, 16361, 203, 522, "Text"],
Cell[192537, 2968, 752, 17, 99, "Text"],
Cell[193292, 2987, 73, 2, 64, "Input"],
Cell[193368, 2991, 600, 14, 97, "Text"],
Cell[193971, 3007, 191, 6, 109, "Input"],
Cell[194165, 3015, 606, 14, 97, "Text"],
Cell[194774, 3031, 250, 8, 108, "Input"],
Cell[195027, 3041, 637, 13, 99, "Text"],
Cell[195667, 3056, 198, 5, 64, "Input"],
Cell[195868, 3063, 1388, 29, 210, "Text"],
Cell[197259, 3094, 184, 4, 64, "Input"],
Cell[197446, 3100, 2475, 49, 139, "Text"],
Cell[199924, 3151, 1486, 30, 150, "Input"],
Cell[201413, 3183, 976, 22, 97, "Text"],
Cell[202392, 3207, 302, 9, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202731, 3221, 447, 12, 100, "Subsubtitle"],
Cell[203181, 3235, 883, 15, 97, "Text"],
Cell[204067, 3252, 2649, 77, 349, "Input"],
Cell[206719, 3331, 1579, 37, 138, "Text"],
Cell[208301, 3370, 514, 10, 64, "Input"],
Cell[208818, 3382, 879, 20, 210, "Text"],
Cell[209700, 3404, 303, 7, 64, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
