(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24033,        638]
NotebookOptionsPosition[     22827,        600]
NotebookOutlinePosition[     23270,        617]
CellTagsIndexPosition[     23227,        614]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Komprese obrazov\[EAcute]ho sign\[AAcute]lu ", "Title",
 CellChangeTimes->{{3.491820394453125*^9, 3.491820462390625*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell["\<\
V tomto notebooku si demonstrujeme my\[SHacek]lenku komprese \
obrazov\[EAcute]ho sign\[AAcute]lu pomoc\[IAcute] harmonick\[YAcute]ch funkc\
\[IAcute]. Pou\:017eijeme k tomu upraven\[YAcute] p\:016fvodn\[IAcute] \
notebook, ve kter\[EAcute]m jsme demonstrovali p\:0159evod do Fourierov\
\[YAcute]ch \:0159ad. 

V praxi se pro kompresi pou\:017e\[IAcute]v\[AAcute] pov\:011bt\[SHacek]inou \
Diskr\[EAcute]tn\[IAcute] kosinov\[AAcute] tranformace (DCT), ta je ale p\
\:0159\[IAcute]buzn\[AAcute] s demonstrovan\[YAcute]m p\:0159evodem. Rovn\
\:011b\:017e se v praxi zpravidla komprimuj\[IAcute] \
\[CHacek]tvercov\[EAcute] plochy 8x8 pixel\:016f (zde budeme komprimovat prou\
\:017eek 1x20 pixel\:016f).\
\>", "Text",
 CellChangeTimes->{{3.4918205809375*^9, 3.491820775296875*^9}, {
  3.491821139125*^9, 3.491821159984375*^9}, {3.49182120340625*^9, 
  3.491821233078125*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"NMaximize", "::", "cvmit"}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<slwcon\>\""}], ",", 
   RowBox[{"NIntegrate", "::", "\"\<ncvb\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4622052014429674`*^9, 3.462205206934167*^9}, {
   3.467349761203125*^9, 3.467349765296875*^9}, {3.491717638859375*^9, 
   3.491717668484375*^9}, {3.4918203904375*^9, 3.49182039265625*^9}, {
   3.49182054015625*^9, 3.491820542828125*^9}, 3.491860026125*^9, {
   3.561815717066112*^9, 3.561815722628612*^9}}],

Cell[TextData[{
 "Vytvo\:0159me si 2 sady vzork\:016f. Sada ",
 StyleBox["vzorky1", "Program",
  FontWeight->"Bold"],
 " p\:0159edstavuje prou\:017eek pixel\:016f z fotografie - p\:0159echody \
jasu nejsou p\:0159\[IAcute]li\[SHacek] ostr\[EAcute]. Sada ",
 StyleBox["vzorky2", "Program",
  FontWeight->"Bold"],
 " p\:0159edstavuje prou\:017eek pixel\:016f z n\:011bjak\[EAcute] \[CHacek]\
\[AAcute]rov\[EAcute] grafiky - uprost\:0159ed b\[IAcute]l\[EAcute]ho pruhu \
(hodnota jasu 10) jsou 4 pixely \[CHacek]ern\[EAcute] (hodnota jasu 0), pravd\
\:011bpodobn\:011b tento prou\:017eek p\:0159e\:0165ala svisl\[AAcute] \
\[CHacek]ern\[AAcute] \[CHacek]\[AAcute]ra o tlou\[SHacek]\:0165ce 4 pixel\
\:016f."
}], "Text",
 CellChangeTimes->{{3.49182146728125*^9, 3.4918216518125*^9}, {
  3.49182840825*^9, 3.49182843215625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"perioda", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vzorky1", "=", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "5", ",", "4", ",", "3", ",", "3", ",", "5", ",", "7", ",", "8",
      ",", "8", ",", "9", ",", "7", ",", "6", ",", "4", ",", "3", ",", "1", 
     ",", "0", ",", "2", ",", "4", ",", "6", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vzorky2", "=", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
     ",", "10", ",", "0", ",", "0", ",", "0", ",", "0", ",", "10", ",", "10", 
     ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10"}], 
    "}"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "Pro dal\[SHacek]\[IAcute] pr\[AAcute]ci vyberme nejprve sadu ",
 StyleBox["vzorky1", "Program",
  FontWeight->"Bold"],
 " (\"fotografie\")."
}], "Text",
 CellChangeTimes->{{3.491821690578125*^9, 3.49182171709375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vzorky", "=", "vzorky1"}], ";"}]], "Input",
 CellChangeTimes->{{3.4918248340625*^9, 3.49182483596875*^9}, {
  3.49182499378125*^9, 3.491824995171875*^9}}],

Cell["Prove\:010fme p\:0159\[IAcute]pravn\[EAcute] pr\[AAcute]ce :", "Text",
 CellChangeTimes->{{3.491821781390625*^9, 3.491821794296875*^9}, {
  3.49182846096875*^9, 3.491828462515625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"vzorky", "[", 
     RowBox[{"[", 
      RowBox[{"(", 
       RowBox[{"IntegerPart", "[", 
        RowBox[{"t", "+", "1"}], "]"}], ")"}], "]"}], "]"}], "/;", 
    RowBox[{"0.0", "\[LessEqual]", "t", "<", "perioda"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "-", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "\[GreaterEqual]", "perioda"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "+", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "<", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Hue", "[", "0.63", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<pixel\>\"", ",", "\"\<jas pixelu\>\""}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nb", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"f", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["perioda", "nb"], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Range", "[", "nb", "]"}], "-", "1"}], ")"}]}], ")"}]}], 
     ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.007", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<pixel\>\"", ",", "\"\<jas pixelu\>\""}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"k", "+", "0.5"}], "]"}], "/", "10"}], "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "+", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "19"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.462200921422367*^9, 3.462201373323167*^9}, 
   3.4622015758111672`*^9, {3.462201749049167*^9, 3.4622017749295673`*^9}, {
   3.462201818344367*^9, 3.462201854146367*^9}, {3.4622020769923673`*^9, 
   3.4622021260699673`*^9}, {3.4622036998143673`*^9, 
   3.4622038088895674`*^9}, {3.462204107910367*^9, 3.462204117239167*^9}, {
   3.4622042449563675`*^9, 3.462204292130767*^9}, {3.491676431953125*^9, 
   3.49167663103125*^9}, {3.49167673478125*^9, 3.491676734859375*^9}, {
   3.491676817046875*^9, 3.491676823953125*^9}, {3.491676889578125*^9, 
   3.49167689571875*^9}, {3.491677022515625*^9, 3.491677093671875*^9}, {
   3.491690440890625*^9, 3.491690504609375*^9}, {3.4916917225625*^9, 
   3.49169172878125*^9}, {3.491691768671875*^9, 3.4916917688125*^9}, {
   3.4917177236875*^9, 3.49171794184375*^9}, {3.491718071078125*^9, 
   3.49171807309375*^9}, {3.4917181203125*^9, 3.491718123359375*^9}, {
   3.491718162484375*^9, 3.491718175953125*^9}, {3.491718224828125*^9, 
   3.4917182270625*^9}, 3.49171829875*^9, {3.491718332453125*^9, 
   3.491718332796875*^9}, 3.491718376875*^9, 3.49171842365625*^9, {
   3.491718514046875*^9, 3.49171856965625*^9}, {3.49171878140625*^9, 
   3.491718825078125*^9}, {3.49171887784375*^9, 3.491718935984375*^9}, {
   3.491718966515625*^9, 3.4917190635*^9}, {3.491720159*^9, 
   3.49172017571875*^9}, {3.49172027034375*^9, 3.491720325734375*^9}, 
   3.491720359625*^9, {3.491720391921875*^9, 3.49172041784375*^9}, {
   3.491721334078125*^9, 3.491721414875*^9}, {3.4917214888125*^9, 
   3.491721515484375*^9}, {3.491724531921875*^9, 3.49172454328125*^9}, {
   3.491724835140625*^9, 3.491724843328125*^9}, {3.491724921078125*^9, 
   3.491724934125*^9}, {3.491725103375*^9, 3.491725107578125*^9}, {
   3.491725170234375*^9, 3.49172519625*^9}, {3.4917254371875*^9, 
   3.4917254408125*^9}, {3.491725803046875*^9, 3.49172580453125*^9}, 
   3.49172590665625*^9, {3.491726027390625*^9, 3.49172602996875*^9}, {
   3.491726063625*^9, 3.49172608159375*^9}, {3.49172638021875*^9, 
   3.49172638034375*^9}, {3.491726416453125*^9, 3.491726419390625*^9}, {
   3.49172880784375*^9, 3.491728835484375*^9}, {3.491728878265625*^9, 
   3.491728928328125*^9}, {3.49172895940625*^9, 3.491728975671875*^9}, {
   3.491820294859375*^9, 3.49182030096875*^9}, 3.49182034540625*^9, {
   3.491820538859375*^9, 3.491820545515625*^9}, 3.49182168265625*^9, {
   3.49182173321875*^9, 3.49182176446875*^9}, {3.49182850215625*^9, 
   3.49182850928125*^9}, 3.4918293851875*^9}],

Cell["Prou\:017eek pixel\:016f vypad\[AAcute] takto :", "Text",
 CellChangeTimes->{{3.491821821015625*^9, 3.491821829046875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData["gr1"], "Input",
 CellChangeTimes->{{3.49182175703125*^9, 3.491821761453125*^9}}],

Cell["\<\
Vykresleme si prou\:017eek pixel\:016f (pod osou x) spole\[CHacek]n\:011b s \
hodnotami jasu ka\:017ed\[EAcute]ho pixelu (nad osou x) :\
\>", "Text",
 CellChangeTimes->{{3.491821855875*^9, 3.49182188725*^9}, {3.4918284776875*^9,
   3.49182849846875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pl2", ",", "gr1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[TextData[{
 "Nyn\[IAcute] spo\[CHacek]\[IAcute]t\[AAcute]me koeficienty ",
 StyleBox["an",
  FontSlant->"Italic"],
 " a ",
 StyleBox["bn",
  FontSlant->"Italic"],
 " pro prvn\[IAcute]ch 50 harmonick\[YAcute]ch funkc\[IAcute]. V \
podstat\:011b podv\[AAcute]d\[IAcute]me - on\:011bch 20 pixel\:016f jsme \
prohl\[AAcute]sili za periodu a tv\[AAcute]\:0159\[IAcute]me se, \:017ee se t\
\:011bchto 20 pixel\:016f periodicky opakuje. Pak n\[AAcute]m nic nebr\
\[AAcute]n\[IAcute], abychom na takto definovanou \"periodickou\" funkci \
aplikovali zn\[AAcute]m\[YAcute] postup."
}], "Text",
 CellChangeTimes->{{3.491822644890625*^9, 3.491822698484375*^9}, {
  3.49182273040625*^9, 3.4918227603125*^9}, {3.49182917128125*^9, 
  3.49182934490625*^9}, {3.491860047796875*^9, 3.4918600486875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nHarm", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", "nHarm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"siny", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "#"}], "]"}], "&"}], "/@",
     "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cosiny", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "#"}], "]"}], "&"}], "/@",
     "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{
    FractionBox["1", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"an", ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "*", 
        RowBox[{"cosiny", "[", 
         RowBox[{"[", "#", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aenka", "=", 
   RowBox[{"an", "/@", "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bn", ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "*", 
        RowBox[{"siny", "[", 
         RowBox[{"[", "#", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beenka", "=", 
   RowBox[{"bn", "/@", "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nahrada", ":=", 
   RowBox[{
    RowBox[{"a0", "+", 
     RowBox[{"Plus", "@@", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"aenka", "*", "cosiny"}], "+", 
         RowBox[{"beenka", "*", "siny"}]}], ",", "#"}], "]"}]}]}], "&"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4622021503123674`*^9, 3.462202313332367*^9}, {
   3.4622025729319673`*^9, 3.462202668686767*^9}, {3.4622027175771675`*^9, 
   3.462202741491967*^9}, {3.4622029929015675`*^9, 3.4622030169879675`*^9}, {
   3.462203106672367*^9, 3.462203112257167*^9}, {3.462203236698367*^9, 
   3.4622032389135675`*^9}, {3.462203335493167*^9, 3.462203337583567*^9}, {
   3.4622033873631673`*^9, 3.4622034681087675`*^9}, 3.462203818031167*^9, {
   3.4622038516647673`*^9, 3.462203870993167*^9}, {3.462204158984767*^9, 
   3.4622041663791676`*^9}, {3.462204359444767*^9, 3.462204362408767*^9}, {
   3.4622044390671673`*^9, 3.462204446695567*^9}, {3.462856015390625*^9, 
   3.46285604153125*^9}, {3.491677195765625*^9, 3.491677201609375*^9}, {
   3.491726242328125*^9, 3.49172627859375*^9}, {3.4917263161875*^9, 
   3.49172631703125*^9}, {3.4917307169375*^9, 3.49173078221875*^9}, {
   3.491730927015625*^9, 3.49173093978125*^9}}],

Cell["\<\
Provedeme p\:0159\[IAcute]pravy na zobrazen\[IAcute] :\
\>", "Text",
 CellChangeTimes->{{3.491823821109375*^9, 3.49182383040625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pln", ":=", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nahrada", "[", "#", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<f[t]\>\""}], "}"}]}]}], "]"}], "&"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"bodyn", ":=", 
  RowBox[{
   RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", "+", "0.5"}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"nahrada", "[", "#", "]"}], "/.", 
           RowBox[{"t", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"k", "+", "0.5"}], ")"}]}]}], ")"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "19"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Orange", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grn", ":=", 
   RowBox[{
    RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"nahrada", "[", "#", "]"}], "/.", 
             RowBox[{"t", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"k", "+", "0.5"}], ")"}]}]}], ")"}], "/", "10"}], 
          "]"}], ",", 
         RowBox[{"Rectangle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", 
             RowBox[{"-", "3.1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"k", "+", "1"}], ",", 
             RowBox[{"-", "2.1"}]}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "19"}], "}"}]}], "]"}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vys", ":=", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"pl2", ",", 
      RowBox[{"pln", "[", "#", "]"}], ",", "gr1", ",", 
      RowBox[{"grn", "[", "#", "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "12"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vys2", ":=", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"pl2", ",", 
      RowBox[{"pln", "[", "#", "]"}], ",", 
      RowBox[{"bodyn", "[", "#", "]"}], ",", "gr1", ",", 
      RowBox[{"grn", "[", "#", "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "12"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], "&"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.491691816296875*^9, {3.491720922546875*^9, 3.49172098871875*^9}, {
   3.491721055328125*^9, 3.491721060140625*^9}, 3.491725029140625*^9, {
   3.4918229918125*^9, 3.49182313128125*^9}, {3.491823252078125*^9, 
   3.49182325240625*^9}, {3.491823358625*^9, 3.491823384671875*^9}, {
   3.4918234696875*^9, 3.491823499625*^9}, {3.4918235378125*^9, 
   3.491823557359375*^9}, {3.491823595171875*^9, 3.49182361153125*^9}, 
   3.49182373621875*^9}],

Cell["\<\
Zobrazme v\[YAcute]sledky. Nad osou x  je jas ka\:017ed\[EAcute]ho vzorku mod\
\:0159e a aproximace tohoto pr\:016fb\:011bhu pomoc\[IAcute] sou\[CHacek]tu \
harmonick\[YAcute]ch funkc\[IAcute] je \[CHacek]ern\:011b. Pod osou x jsou \
dva prou\:017eky pixel\:016f - horn\[IAcute] prou\:017eek je origin\[AAcute]l \
a spodn\[IAcute] prou\:017eek je jeho aproximace (kter\[AAcute] \
odpov\[IAcute]d\[AAcute] \[CHacek]ern\[EAcute] \[CHacek]\[AAcute]\:0159e nad \
osou).\
\>", "Text",
 CellChangeTimes->{{3.491823854953125*^9, 3.491824036015625*^9}, {
  3.491824091578125*^9, 3.491824097140625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
  3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
  3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
  3.491720798703125*^9, 3.49172082109375*^9}, {3.491721010546875*^9, 
  3.491721018890625*^9}, {3.49172113384375*^9, 3.49172115184375*^9}, {
  3.491724710515625*^9, 3.491724733671875*^9}, {3.491724821140625*^9, 
  3.49172482271875*^9}, {3.49172498625*^9, 3.491724986359375*^9}, {
  3.491725975515625*^9, 3.491725975984375*^9}, {3.491728721484375*^9, 
  3.49172872159375*^9}, {3.491823148734375*^9, 3.491823156609375*^9}, {
  3.491823654859375*^9, 3.49182368528125*^9}, {3.491823717046875*^9, 
  3.491823739375*^9}}],

Cell[TextData[{
 "U sady pixel\:016f ",
 StyleBox["vzorky1", "Program",
  FontWeight->"Bold"],
 " si pov\[SHacek]imn\:011bme, \:017ee ji\:017e pouh\[EAcute] prvn\[IAcute] \
dv\:011b harmonick\[EAcute] funkce za\[CHacek]\[IAcute]naj\[IAcute] uspokojiv\
\:011b aproximovat origin\[AAcute]l. V tomto p\:0159\[IAcute]pad\:011b by n\
\[AAcute]m sta\[CHacek]ilo ulo\:017eit pouh\[YAcute]ch 5 hodnot koeficient\
\:016f ",
 StyleBox["a",
  FontSlant->"Italic"],
 "0, ",
 StyleBox["a",
  FontSlant->"Italic"],
 "1, ",
 StyleBox["b",
  FontSlant->"Italic"],
 "1, ",
 StyleBox["a",
  FontSlant->"Italic"],
 "2 a ",
 StyleBox["b",
  FontSlant->"Italic"],
 "2. \[CapitalSHacek]est harmonick\[YAcute]ch aproximuje pr\:016fb\:011bh dob\
\:0159e a deset harmonick\[YAcute]ch velmi dob\:0159e (pouh\[YAcute]m okem \
prakticky nerozeznateln\:011b).\n\nJako aproxima\[CHacek]n\[IAcute] hodnotu \
jsme brali poka\:017ed\[EAcute] hodnotu aproxima\[CHacek]n\[IAcute] funkce \
\"uprost\:0159ed pixelu\", tedy pracovali jsme s oran\:017eov\:011b zv\
\[YAcute]razn\:011bn\[YAcute]mi hodnotami na n\[AAcute]sleduj\[IAcute]c\
\[IAcute]m grafu:"
}], "Text",
 CellChangeTimes->{{3.4918242628125*^9, 3.4918245101875*^9}, {
   3.4918245666875*^9, 3.49182472828125*^9}, 3.49182808946875*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys2", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.491823675953125*^9, 3.49182367996875*^9}}],

Cell[TextData[{
 "Nyn\[IAcute] si v\[SHacek]e znova vyzkou\[SHacek]ejte pro sadu pixel\:016f ",
 StyleBox["vzorky2", "Program",
  FontWeight->"Bold"],
 " (sta\[CHacek]\[IAcute] upravit p\:0159i\:0159azen\[IAcute] ",
 StyleBox["vzorky = vzorky2", "Program",
  FontWeight->"Bold"],
 ";)"
}], "Text",
 CellChangeTimes->{{3.491828117546875*^9, 3.491828198015625*^9}},
 Background->RGBColor[0.87, 0.94, 1]]
}, Open  ]]
},
WindowSize->{1272, 698},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 163, 2, 147, "Title"],
Cell[733, 26, 921, 17, 163, "Text"],
Cell[1657, 45, 728, 15, 98, "Input"],
Cell[2388, 62, 861, 17, 115, "Text"],
Cell[3252, 81, 740, 18, 98, "Input"],
Cell[3995, 101, 273, 7, 66, "Text"],
Cell[4271, 110, 189, 4, 43, "Input"],
Cell[4463, 116, 228, 3, 65, "Text"],
Cell[4694, 121, 5374, 127, 272, "Input"],
Cell[10071, 250, 167, 2, 65, "Text"],
Cell[10241, 254, 94, 1, 64, "Input"],
Cell[10338, 257, 302, 6, 97, "Text"],
Cell[10643, 265, 358, 12, 64, "Input"],
Cell[11004, 279, 830, 17, 135, "Text"],
Cell[11837, 298, 3259, 91, 675, "Input"],
Cell[15099, 391, 181, 4, 97, "Text"],
Cell[15283, 397, 3992, 114, 349, "Input"],
Cell[19278, 513, 642, 11, 135, "Text"],
Cell[19923, 526, 925, 16, 64, "Input"],
Cell[20851, 544, 1297, 33, 283, "Text"],
Cell[22151, 579, 256, 6, 64, "Input"],
Cell[22410, 587, 401, 10, 99, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
