(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16840,        527]
NotebookOptionsPosition[     15498,        482]
NotebookOutlinePosition[     16003,        501]
CellTagsIndexPosition[     15960,        498]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["P\:0159evod do Fourierovy \:0159ady", "Title",
 CellChangeTimes->{{3.4920229805*^9, 3.49202300578125*^9}, {
  3.4920230615625*^9, 3.492023062703125*^9}, {3.493235078765625*^9, 
  3.493235079203125*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"NMaximize", "::", "\"\<cvmit\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.4622052014429674`*^9, 3.462205206934167*^9}, {
  3.467349761203125*^9, 3.467349765296875*^9}, {3.561815622097362*^9, 
  3.561815623144237*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Popis funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ")"
}], "Subtitle",
 CellChangeTimes->{{3.492024019484375*^9, 3.4920240240625*^9}, {
  3.493235129734375*^9, 3.49323513575*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"perioda", "=", "2."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zlom", "=", 
   RowBox[{"0.5", "*", "perioda"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Tanh", "[", "t", "]"}], "/;", 
    RowBox[{"0", "\[LessEqual]", "t", "<", "zlom"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      RowBox[{"2.", "t"}], "]"}]}], "/;", 
    RowBox[{"zlom", "\[LessEqual]", "t", "<", "perioda"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "-", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "\[GreaterEqual]", "perioda"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"t", "+", "perioda"}], "]"}], "/;", 
    RowBox[{"t", "<", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rngMax", "=", 
   RowBox[{
    RowBox[{"NMaximize", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rngMin", "=", 
   RowBox[{
    RowBox[{"NMinimize", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rng", "=", 
   RowBox[{"1.4", "*", 
    RowBox[{"{", 
     RowBox[{"rngMin", ",", "rngMax"}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.462200921422367*^9, 3.462201373323167*^9}, 
   3.4622015758111672`*^9, {3.462201749049167*^9, 3.4622017749295673`*^9}, {
   3.462201818344367*^9, 3.462201854146367*^9}, {3.4622020769923673`*^9, 
   3.4622021260699673`*^9}, {3.4622036998143673`*^9, 
   3.4622038088895674`*^9}, {3.462204107910367*^9, 3.462204117239167*^9}, {
   3.4622042449563675`*^9, 3.462204292130767*^9}, {3.493239091609375*^9, 
   3.49323909790625*^9}}],

Cell[TextData[{
 "Takto vypad\[AAcute] funkce ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "):"
}], "Text",
 CellChangeTimes->{{3.49323910046875*^9, 3.493239126171875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Hue", "[", "0.63", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t\>\"", ",", "\"\<f[t]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "rng"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nb", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pl2", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"f", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["perioda", "nb"], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"2", "nb"}], "]"}], "-", "nb"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "0.63", "]"}], ",", 
       RowBox[{"PointSize", "[", "0.007", "]"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<f[t]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "rng"}], "}"}]}]}], "]"}]}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["P\:0159evod do Fourierovy \:0159ady", "Subtitle",
 CellChangeTimes->{{3.49202627965625*^9, 3.492026290328125*^9}, {
  3.49323519221875*^9, 3.493235204625*^9}},
 Background->GrayLevel[0.85]],

Cell["\<\
Budeme po\[CHacek]\[IAcute]tat koeficienty pro prvn\[IAcute]ch 50 harmonick\
\[YAcute]ch funkc\[IAcute].\
\>", "Text",
 CellChangeTimes->{{3.492028971484375*^9, 3.49202900815625*^9}, {
  3.492029183859375*^9, 3.492029189046875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nHarm", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", "nHarm", "]"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "Zaj\[IAcute]m\[AAcute]-li v\[AAcute]s, co obsahuj\[IAcute] seznamy (angl. \
Lists) ",
 StyleBox["siny", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["cosiny", "Program",
  FontWeight->"Bold"],
 ", sta\[CHacek]\[IAcute] odstranit st\:0159edn\[IAcute]k na konci \:0159\
\[AAcute]dku."
}], "Text",
 CellChangeTimes->{{3.492029099828125*^9, 3.4920291366875*^9}, {
  3.49202925021875*^9, 3.492029278796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"siny", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "#"}], "]"}], "&"}], "/@",
     "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cosiny", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "Pi"}], "perioda"], "*", "t", "*", "#"}], "]"}], "&"}], "/@",
     "rn"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.493239157109375*^9, 3.493239171328125*^9}}],

Cell[TextData[{
 "Spo\[CHacek]\[IAcute]t\[AAcute]me koeficienty ",
 StyleBox["a",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ",
 StyleBox["b",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times New Roman",
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " a ulo\:017e\[IAcute]me je do seznam\:016f ",
 StyleBox["aenka", "Program",
  FontWeight->"Bold"],
 " a ",
 StyleBox["beenka", "Program",
  FontWeight->"Bold"],
 ". "
}], "Text",
 CellChangeTimes->{{3.492029374953125*^9, 3.49202941209375*^9}, {
  3.492029899703125*^9, 3.4920299030625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{
    FractionBox["1", "perioda"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"an", ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "*", 
        RowBox[{"cosiny", "[", 
         RowBox[{"[", "#", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aenka", "=", 
   RowBox[{"an", "/@", "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bn", ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "perioda"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "*", 
        RowBox[{"siny", "[", 
         RowBox[{"[", "#", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "perioda"}], "}"}]}], "]"}]}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beenka", "=", 
   RowBox[{"bn", "/@", "rn"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.49323534684375*^9, 3.493235347859375*^9}}],

Cell[TextData[{
 "Slo\:017e\[IAcute]me harmonick\[EAcute] funkce, abychom vytvo\:0159ili \
aproximaci ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "):"
}], "Text",
 CellChangeTimes->{{3.49203145075*^9, 3.492031611359375*^9}, {
  3.49203164534375*^9, 3.49203174634375*^9}, {3.49203208028125*^9, 
  3.492032117234375*^9}, {3.492032462953125*^9, 3.49203247153125*^9}, {
  3.493235352859375*^9, 3.49323535634375*^9}, {3.493239203140625*^9, 
  3.493239217703125*^9}, {3.493239266640625*^9, 3.493239269484375*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"nahrada", ":=", 
   RowBox[{
    RowBox[{"a0", "+", 
     RowBox[{"Plus", "@@", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"aenka", "*", "cosiny"}], "+", 
         RowBox[{"beenka", "*", "siny"}]}], ",", "#"}], "]"}]}]}], "&"}]}], 
  ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Zobrazen\[IAcute] v\[YAcute]sledku p\:0159evodu ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 ") do Fourierovy \:0159ady"
}], "Subtitle",
 CellChangeTimes->{{3.492026699109375*^9, 3.49202673840625*^9}, {
  3.49202873028125*^9, 3.49202876028125*^9}, {3.4920755953125*^9, 
  3.492075598578125*^9}, {3.493238738828125*^9, 3.493238740421875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pln", ":=", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nahrada", "[", "#", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "perioda"}], ",", "perioda"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t\>\"", ",", "\"\<f[t]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "rng"}], "}"}]}]}], "]"}], "&"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4622021503123674`*^9, 3.462202313332367*^9}, {
   3.4622025729319673`*^9, 3.462202668686767*^9}, {3.4622027175771675`*^9, 
   3.462202741491967*^9}, {3.4622029929015675`*^9, 3.4622030169879675`*^9}, {
   3.462203106672367*^9, 3.462203112257167*^9}, {3.462203236698367*^9, 
   3.4622032389135675`*^9}, {3.462203335493167*^9, 3.462203337583567*^9}, {
   3.4622033873631673`*^9, 3.4622034681087675`*^9}, 3.462203818031167*^9, {
   3.4622038516647673`*^9, 3.462203870993167*^9}, {3.462204158984767*^9, 
   3.4622041663791676`*^9}, {3.462204359444767*^9, 3.462204362408767*^9}, {
   3.4622044390671673`*^9, 3.462204446695567*^9}, {3.462856015390625*^9, 
   3.46285604153125*^9}, 3.49323522884375*^9, {3.493235283390625*^9, 
   3.49323529125*^9}, 3.493235340140625*^9, 3.4932387140625*^9, {
   3.493238744953125*^9, 3.4932387454375*^9}}],

Cell[TextData[{
 "Mod\:0159e je ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["t",
  FontSlant->"Italic"],
 "), \[CHacek]ern\:011b je jej\[IAcute] aproximace pomoc\[IAcute] \
sou\[CHacek]tu ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch funkc\[IAcute]."
}], "Text",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
   3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
   3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}, {
   3.4679215163125*^9, 3.467921516703125*^9}, {3.467921598078125*^9, 
   3.467921613671875*^9}, {3.46792268246875*^9, 3.467922711375*^9}, {
   3.468517762578125*^9, 3.468517768734375*^9}, {3.4685202625*^9, 
   3.468520269390625*^9}, {3.4919421591875*^9, 3.491942176046875*^9}, {
   3.491942260203125*^9, 3.491942273578125*^9}, {3.4919423271875*^9, 
   3.4919423275*^9}, 3.491942402859375*^9, {3.491984441140625*^9, 
   3.491984441625*^9}, {3.49202693828125*^9, 3.4920269553125*^9}, {
   3.492027651984375*^9, 3.492027706625*^9}, {3.49202779096875*^9, 
   3.492027831015625*^9}, {3.492040699609375*^9, 3.49204072534375*^9}, {
   3.4932387755*^9, 3.493238788640625*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vys", ":=", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"pln", "[", "#", "]"}], ",", "pl2"}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"vys", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "nHarm", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.462203472227167*^9, 3.4622034859551673`*^9}, {
  3.4622038772799673`*^9, 3.4622039847639675`*^9}, {3.462204209528767*^9, 
  3.4622042224767675`*^9}, {3.462204348165967*^9, 3.462204349382767*^9}}],

Cell[TextData[{
 "Na z\[AAcute]v\:011br zobrazme spektrum sign\[AAcute]lu (tj. amplitudy prvn\
\[IAcute]ch ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " harmonick\[YAcute]ch):"
}], "Text",
 CellChangeTimes->{{3.498760372796875*^9, 3.498760426625*^9}, {
  3.498760545890625*^9, 3.49876056796875*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fazory", "=", 
   RowBox[{"aenka", "+", 
    RowBox[{"I", "*", "beenka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplitudy", "=", 
   RowBox[{"Abs", "[", "fazory", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"amplitudy", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Blue"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.498760430421875*^9, 3.498760528171875*^9}, {
  3.498760616125*^9, 3.49876065209375*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 698},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 244, 4, 147, "Title"],
Cell[814, 28, 447, 10, 98, "Input"],
Cell[CellGroupData[{
Cell[1286, 42, 277, 11, 98, "Subtitle"],
Cell[1566, 55, 2363, 68, 287, "Input"],
Cell[3932, 125, 253, 10, 65, "Text"],
Cell[4188, 137, 1583, 47, 190, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5808, 189, 195, 3, 98, "Subtitle"],
Cell[6006, 194, 280, 6, 97, "Text"],
Cell[6289, 202, 180, 5, 106, "Input"],
Cell[6472, 209, 469, 13, 99, "Text"],
Cell[6944, 224, 567, 19, 199, "Input"],
Cell[7514, 245, 745, 29, 99, "Text"],
Cell[8262, 276, 1392, 45, 372, "Input"],
Cell[9657, 323, 589, 15, 97, "Text"],
Cell[10249, 340, 321, 11, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10607, 356, 432, 12, 147, "Subtitle"],
Cell[11042, 370, 1572, 33, 106, "Input"],
Cell[12617, 405, 1246, 27, 99, "Text"],
Cell[13866, 434, 598, 15, 106, "Input"],
Cell[14467, 451, 358, 10, 99, "Text"],
Cell[14828, 463, 642, 15, 147, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
