(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    317654,       4245]
NotebookOptionsPosition[    316335,       4201]
NotebookOutlinePosition[    316716,       4217]
CellTagsIndexPosition[    316673,       4214]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Veden\[IAcute]", "Title",
 CellChangeTimes->{{3.5617544020625*^9, 3.561754418328125*^9}},
 Background->RGBColor[1, 0.9, 0.8]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4684391078401613`*^9, 3.468439111515446*^9}, {
  3.4689383790796003`*^9, 3.4689383876284*^9}, {3.561815734659862*^9, 
  3.561815735081737*^9}}],

Cell[TextData[{
 "Pokud je \:0159et\:011bz c\[IAcute]vek a kondenz\[AAcute]tor\:016f a c\
\[IAcute]vek nekone\[CHacek]n\[YAcute], po\[CHacek]\[IAcute]n\[AAcute] \
indexem ",
 StyleBox["i",
  FontSlant->"Italic"],
 " = 1 a jev\[IAcute] se z hlediska vstupn\[IAcute]ch svorek jako impedance ",
 StyleBox["Z",
  FontSlant->"Italic"],
 ", pak p\:0159id\[AAcute]n\[IAcute] jednoho dal\[SHacek]\[IAcute]ho \
\[CHacek]l\[AAcute]nku \:0159et\:011bzu s indexem ",
 StyleBox["i",
  FontSlant->"Italic"],
 " = 0 nezm\:011bn\[IAcute] impedanci a z hlediska vstupn\[IAcute]ch svorek \
bude m\[IAcute]t \:0159et\:011bz op\:011bt impedanci ",
 StyleBox["Z:",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.561806256175487*^9, 3.561806256472362*^9}, {
  3.561806860909862*^9, 3.561806861237987*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@000IYD0@0006`000390000E@0001d;00331`00
Y0H000`2000cGP00U4400215CDH00040E9X107l;000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
n@800:43001=2@00[`<0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@043;000020000024<3K0P000000001EkCm40?aYA5EO54F[fVU40041PAE00@0@0000
10000000000Q000020000680000<00000@0002@0000T00000000?P00000000000000?P0000000000
0P0005l0000h00000@0003P000000000>000000000000P40I0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003h0P00W`<004d9002_0`000P000?XG?1d/BSPM
9@0000`0000700209@0000`000000020900002@00000001100000000000000110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000A1@00U`800>P5003P0P00000004H0000X0000
700004M4BD<200004@D009L2003X1@00/@80000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`000800002024020SP0000/00000Q30f`00002H000000000000b4420000
0000@@0000024<3K000009T00?l8@0<3;000020000024<3K0P000000001EcJ=4EN4XA5E_^dAEhBQ4
00430aE00`0@000010000080000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40T0400000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0000@1@00U@800>T5002a0P00
0P000=mA<BZ`GC4Z9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000A1@00aP800>P5003P0P00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0@2
>00002`000024<3K000009P0000000000038@@80000000110000008@`=/00000V@00o`Q01@</0000
8000008@`=/20000000005G=XdB[^SA4EFnkA:^j=4@00@615D050100000400001000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@2@0@0000000000V@00000000000000000U000030000040000U0000
300000D0081G00009000010500340P00j@D00>0200020000ge4W;K1M9bdU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000145002G0P00j0D00;4200000000AP0004@0000h0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P1E00`0@000010000080000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000P40T0400000000009T000000000000000009@0000`0000100009@0000`000050020
E`0002@0000@1@00U@800>T5002a0P000P000=mA<BZ`GC4Z9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80000A1@00aP800>P5003P0P00000004H000140000>00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080E@0D0400000@0000400008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000000003P000000000
0081090100000000002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T0000
40D00<@2003Y1@00h0800080003ODBL]/5dW;BD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
o0<009T1000U1@00eP40000000160000:00001`00017A4U30P000?`3002I0@00J0@00=H100000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q01P8h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o24070eP0001<0000
0Q30f`L000000000Zf:0A:^2id>[HX14mF_J@nd5Pd@0d<m304N6A03@cd<2R8U40=3?@eH[S4CeJmY3
ER^<A:^2id<00`<30`<3@QE01`0@0000100000H0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40
b0000000000009T000000000000000009@0000`0000100009@0000`000050020E@0003P0003k0`00
U`4006T4003F0@001`0002Y0jA`Z@4HKNd7b6Aa3lQVlA?8I3TI66`i6jA`U0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0005/4002I0@00a`@00=H100000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q0208h0000;000008@`=/00000V0000000000004Q1
0P000000044000000Q30f`00002I003o24090eP0001<00000Q30f`L00000000003b<A:^2id<0?8a4
mF_J@d;OST@0d<m3EB2BA03@cd=GHIE40=3?@j/4V4CeJmY3Z`BHA:^2id<00`<30`<3@QE02@0@0000
100000P0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E@0003P0001J1000U`400<L4003F0@001`0001I6jA`FATHK
J4Ob6@U9lQVYB_8Ind]66o];jA`U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000;T4002I0@00
9@D00=H100000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q02P8h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240;0eP0001<00000Q30f`L000000000Z`BHA:^2id>[19Q4mF_J@nfWVT@0d<m30>VMA03@cd<2:Z54
0=3?@eK=XdCeJmY3E/fSA:^2id<00`<30`<301E02`0@0000100000X0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000P40b0000000000009T000000000000000009@0000`0000100009@0000`000050020
E@0003P0002h1000U`4002H5003F0@001`000?];jAckBdHKC4gb6Ne>lQV=D?8Ige566mmAjA`U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000?`3002I0@00J0@00=H100000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E01`0@0000100000H0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0@0003P000000000>000000000000P40b0000000000009T000000000000000009@0000`000010000
9@0000`000050020E@0003P0003k0`00U`4006T4003F0@001`0002Y0jA`Z@4HKNd7b6Aa3lQVlA?8I
3TI66`i6jA`U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0005/4002I0@00a`@00=H100000000
AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E02@0@0000
100000P0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E@0003P0001J1000U`400<L4003F0@001`0001I6jA`FATHK
J4Ob6@U9lQVYB_8Ind]66o];jA`U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000;T4002I0@00
9@D00=H100000000AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P1E02`0@0000100000X0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E@0003P0002h1000U`4002H5003F0@00
1`000?];jAckBdHKC4gb6Ne>lQV=D?8Ige566mmAjA`U0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0003P700290`00M@L00<H300000000AP000=@000380000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q030>@0000Q000008@`=/=0000000005G<jTAEgF=4ObWYA5GMHd@0e^M4
DXAVA03Fid@0bVU40=KWA:d?KDAo:NU4Z[I_A5G<jTBZ]Vm4;6o/A:ZfKdB[`^e4[@m]A:_2kD@0bVU4
Zl;]A5:4IT@/Kna4EMeSA5G<jTAEgF=400<30`<30`<30`<3Pk/C01A0380@0000100009T00?lQ0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0002L0000H0000
0@000000000009T0000002D0000<00000@0001<0000<00000@0003/000080000E@00050000000000
00000?oooooooooo3@0005mel3R=M?0hhg>J>N=cJc[SLc`kSGCV>emeiS/`M^HkfWHl>mYfJc[JMYXi
<7K`>5mel3Pl0000200003h0000H0000?PL008l3001^1`00_`<001<0000<00000@0002D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@0d2
A00003P000024<3K00000=h0000000000018@@80000200000P000000044200000000008@`=/00000
V@00oaE0300@0000100000d0000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000010<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5D0001@0000=PL008L3001e1`00aP<000d0001OMO0hSGC`>>=cVSWSLf/j
hg<l>hediS]OMNHk<7KV>mYf?3_JMV/jfWJJ>C1fl3QOMO0h9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`8000260`00R@<00<<300360`00000004H0003D0000b00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@0h3T00008@000024<3K3@000000001F8fU4ZoiSA:SMIDB[oV=4
ZcISA:RUITB[=V=4E^]YA:/fHd@3<Fe4Z=eUA03HKdAF8fU40=Q_A0=YK4@0f6m4011_A0<aKD@046m4
E^]YA00@KdBXYFI40fU/A:_nHdAF8fU4ZoiSA0030`<30`<30`<30h?24`0D@0j0400000@0002I003o
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080000U0000
30000040000C000030000040000k0000200005D0001@000000000000003oooooooooo`d00011>_Ph
L3Wh><HhXSW6>7<jaSQ5>g0ikS]1>^hk4c_^>k`kAC^l>g<j_3^R>A<kn3Q1>_Ph?00000P0000n0000
600008`3002?0`00_0<00;l3000C000030000040000U000030000000080T000090000000P4400000
00000000P44000000000008000160000I00005P00015CDH[240?0T@0000h00000Q30f`00003N0000
00000000B44200000P000080000000110P00000000024<3K000009T00?lE@0h0400000@0000?0000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000000@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
D00008D300280`00``<00<L3000=0000@C[h>70in3S6>:8iaSQc>/HhAC]`>Nhk@C[^>a<kkS^l>dDk
_3]c>[`kXSTC>oPh@C[h>2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000U0D00>42000k1P00
N@<0000000160000500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000000008bj4`3X^Q<0
J@000<T0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00002h=PX004`0V6EC<=aQNP420000U;LC0:lB0S0]01<0=M<1<12n4`000000
?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1
X7Aj0Abh4`1RO0X`aPh:3a2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`000000002E00005@0002c1@00n0800?L5001Y0`000@0005EE1d5f@0M1
/`D0058300010000C00000000000000000000?ooooooooooD00004<0001300005P0000`000000000
9@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80003E1@00V@400?h6003F0@00
000004H0000X0000700004M4BD<20000e@D009T100111P00eP40000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240@0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@143F00004`000024<3K1`0000000000P;]4
Zh;W@`20^dCeJmY3@R>nA03@cd=EI<540=3?@eNUa4@0d<m3ZdS7A?E[fT>[B<M4Zh;W@`030`<30`<0
5D0A0100000400004000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000080000U0000300000D0081E0000>0000=@5002G0@00@PH00=H100070000
^5gY7;QMAQ/:Go8IZf3b6D]RlQVMHdHKWF?Y72D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
=0H009T1002P1P00eP40000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240B0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@1<3F00004`000024<3K1`000000001EFLM4Zh;W@eEIadCeJmY3Uoc9A03@cd>Z?Le4
0=3?@jand4@0d<m302;CA?E[fT<08]=4Zh;W@`030`<30`<05D0C0100000400004P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081E0000>00003<6002G0@00X0H00=H100070000YF?Y7:ESAQ_gI?8IUfKb6CQXlQV9JDHK
RFWY72D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000TPH009T1003n1P00eP40000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240D0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@1D3F00004`000024<3K
1`00000000008]=4Zh;W@`0RddCeJmY3@/GEA03@cd=E1]U40=3?@eM7g4@0d<m3Zn[NA?E[fT>[j]i4
Zh;W@`030`<30`<05D0E0100000400005000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>0000946002G0@00
o`H00=H100070000RFWY78UYAQ_KJ_8IO6cb6Aa^lQU^KdHKKVoY72D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000e@D009T100111P00eP40000000160000A00003P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000205D0A0100000400004000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
>0000=@5002G0@00@PH00=H100070000^5gY7;QMAQ/:Go8IZf3b6D]RlQVMHdHKWF?Y72D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000=0H009T1002P1P00eP40000000160000A00003P00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000205D0C0100000400004P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081E0000>00003<6002G0@00X0H00=H100070000YF?Y7:ESAQ_gI?8IUfKb6CQXlQV9JDHK
RFWY72D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000TPH009T1003n1P00eP40000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D0E010000040000
5000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000>0000946002G0@00o`H00=H100070000RFWY78UYAQ_KJ_8I
O6cb6Aa^lQU^KdHKKVoY72D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000[PL009T1003F2000
eP40000000160000:00001`00017A4U30P000:h7002I0@006@P00=H100000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q05P8h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o240G0eP0001<00000Q30f`L000000000
ZhcfA:^2id>[S?I4mF_J@nd_nD@0d<m3077lA03@cd<2/_m40=3?@j/Z0DGeJmY3ZbX1AJ^2id<00`<3
0`<301E05`0@0000100001H0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40I0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E@0003P0002/1`00U`4001X8003F0@00
1`000:0mM@jP?J<=B3ki31Ton@cY?oT<TT2S3I90M@hU0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0000`8002I0@00N0P00=H100000000AP000=@000380000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0608h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240I0eP0001<00000Q30f`L00000000003<1AJ^2id<0<`55mF_J@j640TD0d<m3
:bD4A@3@cd>[a@E50=3?@eDG1dGeJmY3EAL7AJ^2id<00`<30`<301E06@0@0000100001P0000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0P0003P000000000>000000000000P40I0000000000009T000000000000000009@0000`000020000
9@0000`000050020E@0003P0000;2000U`4007T8003F0@001`0009I0M@jF@:<=?d7i30m2n@cO@_T<
R4>S3HQ3M@hU0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0006/8002I0@00ePP00=H100000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q06P8h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240K0eP0001<0000
0Q30f`L000000000EAL7AJ^2id=E5`M5mF_J@oIX24D0d<m3P0T:A@3@cd<0ZP]50=3?@j[k34GeJmY3
Z_/<AJ^2id<00`<30`<301E06`0@0000100001X0000Q000020000680000<00000@0002@0000T0000
0000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40
I0000000000009T000000000000000009@0000`0000200009@0000`000050020E@0003P0001Y2000
U`400=L8003F0@001`0008Q3M@j8@j<=<DCi3055n@cAAOT<NTJS3GY6M@hU0000300000L0080U0000
30000000080T00009000000004400000000000000440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000:h7002I0@006@P00=H100000000AP0004@0000h0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P1E05`0@0000100001H0000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000
>000000000000P40I0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@0003P0002/1`00U`4001X8003F0@001`000:0mM@jP?J<=B3ki31Ton@cY?oT<TT2S3I90M@hU0000
300000L0080U000030000000080T00009000000004400000000000000440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0000`8002I0@00N0P00=H100000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E06@0@0000100001P0000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0P0003P000000000>000000000000P40I0000000000009T000000000000000009@0000`000020000
9@0000`000050020E@0003P0000;2000U`4007T8003F0@001`0009I0M@jF@:<=?d7i30m2n@cO@_T<
R4>S3HQ3M@hU0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0006/8002I0@00ePP00=H100000000
AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E06`0@0000
100001X0000Q000020000680000<00000@0002@0000T00000000?P00000000000000?P0000000000
0P0005l0000h00000P0003P000000000>000000000000P40I0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@0003P0001Y2000U`400=L8003F0@001`0008Q3M@j8@j<=
<DCi3055n@cAAOT<NTJS3GY6M@hU0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000>/6002G0P00
`PL00>0200000000AP0002P0000L0000AdA9@`80003[1P00U`800<87002a0P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@1`2>00002`000024<3K
000009P0000000000038@@80000000110000008@`=/00000V@00o`Q07@</00008000008@`=/20000
000005GkgTAEhBQ4EIgfA5GQ:4@00@<35D0M0100000400007000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@2@0@0000000000V@00000000000000000U000030000080000U0000300000D0081G0000
90000>T6002E0P00`PL00;4200020000MVla:TMk<BXU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000>/600360P00`PL00>0200000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q07P8h0000;000008@`=/00000V000000000000<Q10P00000004400000
0Q30f`00002I003o240O0b`0000P00000Q30f`8000000000EO_NA:^j=4AEWOI4ZkXdA001000E@1l0
400000@0000N00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P0000000000081090100000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000j@H00<@200321`00h0800080001fKbL]
Ag/W;BD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000j`H009L200321`00/@80000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D0M010000040000
7000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@2@0@0000000000V@00000000000000000U0000
30000080000U0000300000D0081G000090000>T6002E0P00`PL00;4200020000MVla:TMk<BXU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000>/600360P00`PL00>0200000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E07`0@0000100001h0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000P40T0400000000009T000000000000000009@0000`000020000
9@0000`000050020E`0002@0003Y1P00a0800<87003P0P000P0007I_9be7NbL]9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80000i0`00U`800104003P0P00000004H0000X0000700004M4BD<20000
>@<009L2000@1000/@80000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240P0SP0000/00000Q30f`00002H000000000000b44200000000@@0000024<3K
000009T00?l8@243;000020000024<3K0P000000001EPE54EN4XA:]RP4AEhBQ40041PAE08@0@0000
10000200000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000P40T0400000000009T00000000000000000
9@0000`0000200009@0000`000050020E`0002@0000h0`00U@800144002a0P000P0005Td<BXZ@34Z
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000i0`00aP800104003P0P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@282>00002`000024<3K
000009P0000000000038@@80000000110000008@`=/00000V@00o`Q08`</00008000008@`=/20000
000005F1DDB[^SA4Zf:0A:^j=4@00@005D0S0100000400008P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@2@0@0000000000V@00000000000000000U000030000080000U0000300000D0081G0000
900003P300340P004@@00>0200020000FC@W;BY09bdU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0003T3002G0P0040@00;4200000000AP0004@0000h0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P1E08@0@000010000200000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000200009@0000`000050020E`0002@0000h0`00
U@800144002a0P000P0005Td<BXZ@34Z9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000i0`00
aP800104003P0P00000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@2<0400000@0000R00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000>0<00<@2000A1000
h0800080001I=2L]:T0W;BD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<2000060D00<P1003R1@00
eP40000000160000Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240T0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@2D3
;000020000024<3K0P000000001EcJ=4Zh;W@eE_^dB[P^M3004001E09@0@0000100002@0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000P40b0000000000009T000000000000000009@0000`000020000
9@0000`000050020E`0002@0000F1@00a`400><5003F0@000P000=mAjAb`GNTL9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003i0P00b04000X4003F0@00000004H0002X0000W00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@2H2>00002`000024<3K000009P000000000
0018@@80000000110000008@`=/00000V@00o`Q09`</00008000008@`=/20000000005G]?dAEaNM3
EG>0A:Z2id<00@005D0W0100000400009P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081G000090000?P200370@00
2`@00=L100020000m2oa7390jA`U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<T800380@00
C@T00=H100000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0:08h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240Y0b`0000P00000Q30f`8000000000Zo/<AJ^2id=FGaA5Zh;W@`01000E@2T0400000@0000X0000
8@0000P0001R000030000040000T00009000000003h000000000000003h0000000000080001O0000
>0000080000h0000000003P000000000008106@000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T0000b0P00<L1001=2@00eP400080001jAWD>;4Ye3RD0000<0000
1`00P2D0000<00000000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000G`D008T3002K1@00aP<0000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240Z0i00002400000Q30f`d000000000
EIj_A:_nHdAonje4ZoiSA02X[4BXYFI40:R/A5K[JD@0Z:a40c5]A7ok[D@0f6m4EIj_A03HKd@/@K54
0=Q_A:^D/T@3<Fe4ZiBbA5K[JDB[U;94Z:EVA2a1/DB[oV=4EIj_A:_nHd@00`<30`<30`<30`>3:P00
540ZP10000040000V@00ob4000080000HP0000`000010000900002@00000080m000000000000080m
00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000
ooooooooool=0000b5Oh>?IFn3Q<EZ8iC5Ic>TaFAC_fE^hkb5O^>iUHkS]3FDDk@eUc>T=IXSVIF?Ph
b5Oh>3`000080000?P0001P0001T1@00S`<009D5002o0`004`0000`0000100009@0000`000000020
900002@00000081100000000000008110000000000020000AP0006@0001H0000ADe6:`Q0:`940000
>000008@`=/00000gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o
5D0Z010000040000:`0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000040b0000000000009T000000000000000009@0000`000020000
9@0000`000050020E@000500001M1@00R0<009`500370`003@000<QGn3SfE_PhC5JR>DaFLcY<ETDk
mUK^>lQGkS^IF>hk@eU5>d=ILcY3FJ8iVESh><QGn3PU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0003P7002`0@00M@L00>d100000000AP000=@000380000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0;0>@0000Q000008@`=/=0000000005G<jT@0R=]3ObWYA028fd<0e^M4
n]GP@`3FidAEHNM30=KWA;3/kD=o:NU4Zc[c@eG<jTB[>_=3;6o/A:/jld>[`^e4/>c]@j_2kDAEHNM3
Zl;]A?[Eh4</Kna408SK@eG<jT@0R=]300<30`<30`<30`<3PbT001A0;80@0000100009T00?lQ0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0002D0000<0000
0@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo3@0005meJA^=M6TK
hg<C7>=ciAcSLkHMSGAP7UmeH1h`MV0NfWJf7MYfiAcJMQ<L<7IY6emeJA/l0000200003h0000H0000
?PL00;H1001^1`00iP4001<0000<00000@0002D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0004H0001T0000F00004E=AR/8@2d2A00003P000024<3K00000=h000000000
0018@@80000200000P000000044200000000008@`=/00000V@00oaE0;00@0000100002d0000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00010<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000
=PL00:l1001e1`00kP4000d0001OMFTKSGAY6n=c4acSLnDLhg>f7HedH1iOMF0N<7IP7]Yf]QgJM^DL
fWHC731fJA]OMFTK9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`8000260`00/@400<<3003^0@00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2h3
T00008@000024<3K3@000000001F8fU4Zl[K@jSMIDB[b]]3ZcISA:DHhD>[=V=40:CW@j/fHdAK;ni3
Z=eUA5Imld=F8fU4EWgc@`=YK4AFOO=3011_A5/_kT<046m40:CW@`0@KdBU6>530fU/A:_:fd=F8fU4
Zl[K@`030`<30`<30`<30h<0000D@2j0400000@0002I003o8@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080000U000030000040000C000030000040000k0000
200005D0001@000000000000003oooooooooo`d00011>W8KL3Ub6lHh71c6>>dLaSRn7G0iJ1i1>VPN
4c]X7[`k_Qfl>ndL_3/L71<kLQ]1>W8K?00000P0000n0000600008`3002g0@00_0<00>L1000C0000
30000040000U000030000000080T000090000000P440000000000000P44000000000008000160000
I00005P00015CDH[240_0T@0000h00000Q30f`00003N000000000000B44200000P00008000000011
0P00000000024<3K000009T00?lE@2h0400000@0000_0000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000000@38000000000000V@000000
00000000000U000030000080000U0000300000D0081E0000D00008D3002_0@00``<00>h1000=0000
@CYb6g0iLQ_6>1`LaSS]7<Hh_Qe`>FPN@CYX7Q<kJ1jl>khM_3_]7;`k71`C>g8K@CYb6bD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000G`D00;41002K1@00kP40000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240`0i00002400000Q30f`d000000000
EIj_A:_:fd=onje4Zl[K@`2X[4BU6>530:R/A02Tid<0Z:a4Fbo^@gok[DAFOO=3EIj_A5Imld</@K54
EWgc@j^D/TAK;ni3ZiBbA02Tid>[U;94YASQ@ba1/DB[b]]3EIj_A:_:fd<00`<30`<30`<30`>30000
540`P10000040000V@00ob4000080000HP0000`000010000900002@00000080m000000000000080m
00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000
ooooooooool=0000b5Mb6oIFLQ]<EQ`LC5K]74aF_QgfEVPNb5MX7YUHJ1i3FKhM@eW]74=I71bIF78K
b5Mb6c`000080000?P0001P0001T1@00]`4009D5003W0@004`0000`0000100009@0000`000000020
900002@00000081100000000000008110000000000020000AP0006@0001H0000ADe6:`Q0<@940000
>000008@`=/00000gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o
5D0`010000040000<@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000040b0000000000009T000000000000000009@0000`000020000
9@0000`000050020E@000500001M1@00[`4009`5003^0@003@000<QGLQ_fEW8KC5HL74aFkAa<E[hM
mUIX7/QGJ1jIF6PN@eVn7D=IkAa3FA`LVEQb6lQGLQ/U0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0004l7003<0P00G@L00:h300000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0<P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240c0b`0000P00000Q30f`80000000000<CZA:^j=4@0a>Y4ZmYYA001000E@3<0
400000@0000b00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000CPL00</2001M1`00[`<00080001JMBL]
FWE_>RD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000MPD00<`200241@00[P<0000000160000
Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240d0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@3D3;000020000024<3K
0P000000002[YZm4ZkXdA:^V[dB[fVU4004001E0=@0@0000100003@0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000P40b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E`0002@0001e1@00b`8008@5002_0`000P000<aG9bg<Eflj9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80002N0`00c0800:`3002^0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@3H2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q0=`</00008000008@`=/200000000000dJDB[^SA403AYA:_JJD@00@00
5D0g010000040000=P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000080000U0000300000D0081G0000900009d3003;0P00[0<00:l300020000
ACXW;DDjKcXU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0004l700380@00G@L00:X200000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0>08h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240i0b`0000P0000
0Q30f`80000000000<CZA:^2id<0a>Y4EN4XA001000E@3T0400000@0000h00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5L0000T0000CPL00<L1001M1`00Z`800080001JMNTLFWDa:RD0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000MPD00<P100241@00ZP80000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240j0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@3/3;000020000024<3K0P000000002[YZm4Zh;W@j^V[dAEhBQ4
004001E0>`0@0000100003X0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000P0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E`0002@0001e1@00a`4008@5002[0P00
0P000<aGjAc<Ec4Z9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002N0`00b0400:`3002Z0P00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@3`2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q0?@</0000
8000008@`=/200000000000dJDB[P^M303AYA5GQ:4@00@005D0m010000040000?000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081G0000900009d300370@00[0<00:/200020000AC[Y74Dj<BXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000;/3003Q0P00H`@007T300000000AP0001@000080000AdA9@`<0001B0000
L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00000000000000000002<^Q<0j;XC06T0003:0000/2]j0@004`3T]Q<0d61j0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000J3H:001<09QUDc3LHGX1
0@0009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`
b`/11bd04`000000@`0009450S38^1<016mj0J1dNP4L^1<0HW`:<<dC2XT@_Q<03P02<03hoomTMP08
000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000
fP<00?P2000N1000J@<00040001EE@M1MT07@MX3001B0`000@0004`00000000000000000003ooooo
oooooe0000130000@`0001H0000<0000000002D0000<00003P00P2P0000<00000P0004H0000X0000
700004M4BD<20000K@L00>T2000D2000P@<0000000160000500000P00017A4U30`000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP00000000000000000008bj4`3X^Q<0J@000<T0002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00001Z=PX004`0V6EC<=aQNP410000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`aPh:?A2n4`0>008`0?SoofAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`000000002E00005@0002<1`00
00<00=07001a0`000@0005EE1d5f@0M1S0L005X300010000C00000000000000000000?oooooooooo
D00004<0001300005P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000
AdA9@`80000a1000nP000?44002B0@00000004H0000D0000200004M4BD<30000DP00070100020000
W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0000000000000000S;XC0>Rj4`210000m`000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`0000000000
000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C00000013000006Tf2P00C02HIE<`g65j0@00002D]a<0
[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0
000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S3=4`Z@4;hC00h00S00n?ooI7H02000000U0000
30000080000F0000300001P0000B000030000040000H000030000000009D0000E00007@4000@0@00
[0@0084100010000EED7@GI01d5e1000JP400040001<00000000000000000000oooooooooom@0000
C00003P0000F000030000000000U0000300000h0080X00003000008000160000:00001`00017A4U3
0P0000X6003j0000b@H0098100000000AP0001@000080000AdA9@`<0001B0000L0400080002Loooo
0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000
00000000002<^Q<0j;XC0840003g0000/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000R3H:001<09QUDc3LHGX1000009Bg4`2_4P8`
;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000
@`0009450S38^1<016mj0J1dNP4L^1<0HW`:<<H>2T@@_Q<03P02<03hoomTMP08000002D0000<0000
0P0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000C0H0010100241P00
P@400040001EE@M1MT07@Dd6001Z0@000@0004`00000000000000000003ooooooooooe00001<0000
>00001H0000<0000000002D0000<00003P00P2P0000<00000P0004H0000X0000700004M4BD<20000
h`L00?X0002R2000TP40000000160000500000P00017A4U30`000580001`0@000P0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000
000008bj4`3X^Q<0P@000?L0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00002C=PX004`0V6EC<=aQNP400000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`cA<:Ua2n4`0>008`0?SoofAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`000000002E00005@0000U2000404005d800210@00
0@0005EE1d5f@0M19PP006X100010000C00000000000000000000?ooooooooooD00004`0000h0000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80003a1P00
b0400;/7003F0@00000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@3h2>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000
V@00o`Q0?`</00008000008@`=/2000000000:_ZgTB[P^M3ZhcfA:^2id<00@005D0o010000040000
?P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081G000090000>l600370@00_0L00=H100020000KVoY73mkjA`U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0005T8000/0P00;`T0004300000000AP0001@000080000
AdA9@`<0001B0000L0400080001Zoooo0000000000000000_08000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00000000000000;0[NP41000000000000000000000000000000070000
179j0J1dNP6XF>H`/2]j0NQWNP4D0000D;PC00000004KgX10@000040001@^1<0AhW/<0000004KgX1
00000:1dNP7X;7X1000000A_NP5P0000G;PC06aHiS010000000000800020LGX1h;PC0=AcNP400000
00000?oooom8T>``X8ij0@A_NP7<^A<00@0003GC0C0@_Q<0000003aQNP4917X12@Aj0M5l3C0V8000
2@Aj0@004`000000000002bi4`000000000000A_NP4/^A<0GXg/<0A_NP4000005;TC02Bi4`000000
T2mj0NQWNP5TMP08000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<0000
00000U@0001D0000N0P004D2000=2@00kP800040001EE@M1MT07@GP8003>0P000@0004`000000000
00000000003ooooooooooe00000V8000UP0001H0000<0000000002D0000<00003P00P2P0000<0000
0P0004H0000X0000700004M4BD<20000h@8008T3000N0`00aP<0000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`000800002024000i00002400000Q30f`d000000000
Zm`oA:_nHdCmUSa4ZoiSA03`>DBXYFI40?0iA5K[JD@0l3U40c5]A?fF?4@0f6m4Zm`oA03HKdAH8T=4
0=Q_A5G9AD@3<Fe4ELU5A5K[JDAEbDE4Z:EVA5PR@dB[oV=4Zm`oA:_nHd@00`<30`<30`<30`>30000
5400P10000040000ooooobP0000<00000@00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00001000000000?ooo`0000009@0000`000010000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000l2oh>1h_n3Qd;Z8i
M2ic>W@^AC/N;nhkl2o^>l4`kS][<DDkJc5c>V/aXSW1<?Phl2oh>3`000080000?P0001P0003W0P00
S`<001L3002o0`004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q00@940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D000100000400000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000200009@0000`000050020E@000500003P0P00
R0<001h300370`003@000?0_n3PN;oPhM2jR>G@^LcYd;TDk7Ro^>o0_kS_1<>hkJc55>f/aLcY[<J8i
`C3h>?0_n3PU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000>82002`0@007P<00>d100000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00P>@0000
Q000008@`=/=00000000003n?d@0R=]3D[PlA028fd=E4CY4n]GP@eDA>TAEHNM3EA4jA;3/kD=B^3a4
Zc[c@`3n?dB[>_=3[D=3A:/jld>ZjTE4/>c]@j[ZADAEHNM3Z^Y5A?[Eh4>]@d=408SK@`3n?d@0R=]3
00<30`<30`<30`<3P`0001A00X0@000010000?oooolQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000@0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@000?P_JA/W;fTKOBhC77d^iAam;[HM9bmP7_P_H1k9<60N
Lc6f7G<aiAac<A<LbC1Y6oP_JA/l0000200003h0000H0000i`800;H1000H0`00iP4001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@0<2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE00P0@0000100000<0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0001@0000h0800:l1000O0`00kP4000d0003h;fTK
9bmY6gd^4aam;^DLOBjf7BL_H1kh;f0NbC1P7W<a]Qec<NDLLc4C7<T`JA_h;fTK9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003W2000J`8001l;00030`00000004H0000D0000200004M4BD<30000
DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00002`00000000000000S;XC0>Rj4`0H0P001P@00;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000<Df2P00C02HIE<`
g65j0@00002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S3=4`ZT4;hC00h00S00n?oo
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000000009D0000
U000038900220P007@/00?<200010000EED7@GI01d4b2@00g08000`0001<00000000000000000000
oooooooooomT0000H@1T0200J@1^06H0J@1^06T0M01e06d0;0000380000I000070000380000Q0000
70000380000L000070000380001>00005P0000`0000000009@0000`0000>0020:00000`000020000
AP0002P0000L0000AdA9@`80000Q0@00V@L004d9002V1`00000004H0002X0000W00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@0@2>00002`000024<3K000009P000000000
0018@@80000000110000008@`=/00000V@00o`Q01@</00008000008@`=/200000000002XTd<0l_=4
ZfLDA@3bld@00@005D050100000400001000024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h0000000000020@1T0000
00000000V@00000000000000000U000030000080000U0000300000D0081G0000900001l1002G1`00
CPT00:L700020000=`Wi?31:nC`U0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000185002?1P00
j@D00=P600000000AP0002P0000L0000AdA9@`80000B1@00S`H00>T5002Y1P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0H2>00002`000024<3K
000009P0000000000038@@80000000110000008@`=/00000V@00o`Q01`</00008000008@`=/20000
0000003NXdAEMM=4082kA5Eedd@00@005D070100000400001P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@2@0@0000000000V@00000000000000000U000030000080000U0000300000D0081G0000
90000105002=1P00j@D00:T600020000ie6cJKQM/fTU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000185002n1P00j@D00=P600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0208h0000;000008@`=/00000V000000000000<Q10P00000004400000
0Q30f`00002I003o24090b`0000P00000Q30f`80000000000=jSA01RfD@0P;]406;IA001000E@0T0
400000@0000800008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P0000000000081090100000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T000040D00;d6003Y1@00f@H00080003WDJU/
^5fYK2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<200004PD008l6003Y1@00Z@H0000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D07010000040000
1P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@2@0@0000000000V@00000000000000000U0000
30000080000U0000300000D0081G000090000105002=1P00j@D00:T600020000ie6cJKQM/fTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000185002n1P00j@D00=P600000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E02@0@0000100000P0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000P40T0400000000009T000000000000000009@0000`000020000
9@0000`000050020E`0002@0000@1@00_@H00>T5003I1P000P000>MAZFbhGJU/9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80003m0`00T@D002H5003>1@00000004H0000X0000700004M4BD<20000
o@<00945001Y1000cPD0000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240:0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@0/3F00004`000024<3K1`000000001ELh14E^FhA5EcP4BXWkE4UaJ3A:_h/TBZEhI4
ZoRbA:bHRDB[n;9403b<A:RO]D@0?8a4E^FhA0030`<30`<05D0;0100000400002P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081E0000>0000?/3002@1@00J@@00<h500070000<T1[G390b5Z4@GEI94=eFLE4METFA/QJ
5TI[G2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000G0@0094500371000cPD0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240=0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@0`3F00004`000024<3K
1`000000002[C8a4E^FhA:]<S4BXWkE4kNn>A:_h/T@0<I94ZoRbA09bUDB[n;94EQFHA:RO]DAF5IQ4
E^FhA0030`<30`<05D0<0100000400003@00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>00005X4002@1@00
b0@00<h5000700007dI[G1m6b5Y`AgEI4DUeFK5:MET3C<QJ0da[G2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000^P@00945000V1@00cPD0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240?0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@0h3F00004`000024<3K1`000000001E5IQ4E^FhA5DEV4BXWkE4
UkRJA:_h/TBZnIe4ZoRbA:`jXDB[n;940=jSA:RO]D@0gZ=4E^FhA0030`<30`<05D0>010000040000
3`00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000>0000;P4002@1@009PD00<h5000700000da[G0=<b5YECGEI
mDieFII@MEWWDLQJie5[G2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000o@<00945001Y1000
cPD0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0;0100000400002P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000080000U0000300000D0081E0000>0000?/3002@1@00J@@00<h500070000
<T1[G390b5Z4@GEI94=eFLE4METFA/QJ5TI[G2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
G0@0094500371000cPD0000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0<0100000400003@00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>00005X4002@1@00
b0@00<h5000700007dI[G1m6b5Y`AgEI4DUeFK5:MET3C<QJ0da[G2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000^P@00945000V1@00cPD0000000160000A00003P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000205D0>0100000400003`00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
>0000;P4002@1@009PD00<h5000700000da[G0=<b5YECGEImDieFII@MEWWDLQJie5[G2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000>0L00847001e1`00_PL0000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240@0i00002400000Q30f`d000000000
0=gZA5Gcl4@Z>^U4EO?`A:_VidCDA_94ZnKWA:[YldB[i^M4PHceA2XjjD@0h?I40=gZA03PmTCGOna4
0>3fA5KCkDB1S?E4E]?]A:[YldAFdne4e4KbA=Mok4AElo140=gZA5Gcl4@00`<30`<30`<30`>30000
540@P10000040000V@00obP0000<00000@00024000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009`0001P00001000000000000V@0000009@0000`000010000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000IgEbN9IdLWS/Laai
k7?]NNac_gZFM6QkIgEXNcQfJ7_RM[mjhWK]NN9f77ThMW9hIgEbN3`000080000?P0001P0000n1`00
Q`L006l7002g1`004`0000`0000100009@0000`000000020900002@0000008110000000000000811
0000000000020000AP0006@0001H0000ADe6:`Q04@940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0@0100000400004@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000040
b0000000000009T000000000000000009@0000`0000200009@0000`000050020E@000500000g1`00
O`L007H7002n1`003@0006MeLWRFM79hk7<LNNackGW/LkmjUWAXNfMeJ7/hMVQkhWJoN^9fkGWRMQai
>7IbN6MeLWPU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0008L300211`00a0<00;h700000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q04P>@0000
Q000008@`=/=000000000:]4JD@01?54oOiUA004lD@0F6=4OeObA01HHdAEn_=405QSA2bMmDCmoVE4
Zo3fA:]4JDB[l?I4F8Y/A:_`mTAE<Fm4;9geA5DaKdAEn_=4EC5_A7mGlTAHRVa400CaA:]4JD@01?54
00<30`<30`<30`<3P`0001A04X0@0000100009T00?lQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000@0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@0004XjNWQh>GYhcSPTNLhhmWW>><MjN3UaNdXjLG/K>g5k
aC_7N/DkmWW5>bAi6c]jN4XjNWPl0000200003h0000H0000S0<008L7002m0`00^0L001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@1<2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE04P0@0000100001<0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0001@0000Q@<0080700340`00_`L000d0001:>WYh
N3UjN<hh97W>>?IicSS7NWPiLG]:>W5k6c]aNlDkag[5>oIiaC/TNA/kNWQ:>WYh9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002E1@00f@H003`6001a1`00000004H0000D0000200004M4BD<30000
DP00070100020000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000b@000;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000><f2P00C02HIE<`
g65j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S363PYX4;hC00h00S00n?oo
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000000009D0000
E0000;@5003`1P00n0D0064700010000EED7@GI01d6d1@00BPL00040001<00000000000000000000
oooooooooom@0000@`0004<0000F000030000000000U0000300000h0080X00003000008000160000
:00001`00017A4U30P000=H5002A1@00o`H00<h500000000AP0002P0000L0000AdA9@`80003F1@00
T@D00486003>1@00000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@1@2>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000
V@00o`Q05@=H0000C000008@`=/7000000000:^@^dAFiKQ4Zi2kA:RO]DC]<ki4ZoRbA01e`DB[n;94
0[K4A:_h/TAFFLM4Z9neA5IIadAFiKQ400<30`<30`0E@1D0400000@0000D00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0000h0000e0D0090500121P00cPD000L00031GF]L`Eg8FQ9OMEVcH7EIDf9eFJESb5ZUHf]L
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000e1P00T@D00:06003>1@00000004H0003D0000
b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@1H2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q05`=H0000C000008@`=/70000
0000001ZadAFiKQ406[7A:RO]DA23LY4ZoRbA5E>cDB[n;94Eho@A:_h/TB[<]=4Z9neA:/bddAFiKQ4
00<30`<30`0E@1L0400000@0000F00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000<`H00905002Q1P00
cPD000L0002]Hf]L[F?8F_mTMEVPIWEI@6QeFI9Yb5ZBJF]L9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80002C1P00T@D00?l6003>1@00000004H0003D0000b00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@1P2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q06@=H0000C000008@`=/7000000000:/bddAFiKQ4Zc;CA:RO]DC]eME4
ZoRbA00GfDB[n;940USLA:_h/TAFnmi4Z9neA5KkgTAFiKQ400<30`<30`0E@1T0400000@0000H0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5D0000h0000T@H00905003o1P00cPD000L0002BJF]LTVW8F^=ZMEV4K7EI
96ieFGI_b5YfKf]L9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003F1@00T@D00486003>1@00
000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o0000P000080E@1D0
400000@0000D00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0000h0000e0D0090500121P00cPD000L00031GF]L
`Eg8FQ9OMEVcH7EIDf9eFJESb5ZUHf]L9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000e1P00
T@D00:06003>1@00000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@1L0400000@0000F00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000<`H00905002Q1P00
cPD000L0002]Hf]L[F?8F_mTMEVPIWEI@6QeFI9Yb5ZBJF]L9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80002C1P00T@D00?l6003>1@00000004H000140000>00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080E@1T0400000@0000H00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000
T@H00905003o1P00cPD000L0002BJF]LTVW8F^=ZMEV4K7EI96ieFGI_b5YfKf]L9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002^1`00T@D00=L8003>1@00000004H0000X0000700004M4BD<20000
[PL00945000J2000cPD0000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240J0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@1/3F00004`000024<3K1`000000001EWOI4E^FhA5FMmTBXWkE4Ud3iA:_h/TBZPOa4
ZoRbA:c2odB[n;9403<1AJRO]D@0<`55E^FhA0030`<30`<05D0K0100000400006P00024000080000
HP0000`000010000900002@00000000n000000000000000n0000000000020000G`0003P000020000
>0000000000h0000000000020@1T000000000000V@00000000000000000U000030000080000U0000
300000D0081E0000>0000:d7002@1@006PP00<h500070000Y3df;Z@mI2e=?[//7Cnk;>do^bbF@6@]
UT0f;RD0000<00001`00P2D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<200003@P00945001i2000cPD0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240L0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@1d3F00004`000024<3K
1`000000001E>`55E^FhA5Dk0DFXWkE4mX`2AJ_h/TB0;@A5ZoRbA03>1DF[n;94ZQl7AJRO]DBZ7`M5
E^FhA0030`<30`<05D0M0100000400007000024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h0000000000020@1T0000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>00000`8002@1@00
N@P00<h500070000VT0f;YY0I2e3@K//4d:k;>=2^bb<@f@]S4<f;RD0000<00001`00P2D0000<0000
0000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000J`P00945003G2000cPD0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240N0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@1l3F00004`000024<3K1`000000002[7`M5E^FhA:/O1dFXWkE4
C748AJ_h/TCF4@Y5ZoRbA5Jb2dF[n;9400@=AJRO]D@010e5E^FhA0030`<30`<05D0O010000040000
7P00024000080000HP0000`000010000900002@00000000n000000000000000n0000000000020000
G`0003P000020000>0000000000h0000000000020@1T000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000>00006X8002@1@00e`P00<h500070000S4<f;Xa3I2deA;//
1DFk;=I5^banAV@]OTHf;RD0000<00001`00P2D0000<00000000P2@0000T00000000@@0000000000
0000@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000[PL00945000J2000
cPD0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0K0100000400006P00024000080000HP0000`000010000900002@00000000n000000000000000n
0000000000020000G`0003P000020000>0000000000h0000000000020@1T000000000000V@000000
00000000000U000030000080000U0000300000D0081E0000>0000:d7002@1@006PP00<h500070000
Y3df;Z@mI2e=?[//7Cnk;>do^bbF@6@]UT0f;RD0000<00001`00P2D0000<00000000P2@0000T0000
0000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
3@P00945001i2000cPD0000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0M0100000400007000024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h0000000000020@1T0000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>00000`8002@1@00
N@P00<h500070000VT0f;YY0I2e3@K//4d:k;>=2^bb<@f@]S4<f;RD0000<00001`00P2D0000<0000
0000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000J`P00945003G2000cPD0000000160000A00003P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000205D0O0100000400007P00024000080000HP0000`000010000
900002@00000000n000000000000000n0000000000020000G`0003P000020000>0000000000h0000
000000020@1T000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
>00006X8002@1@00e`P00<h500070000S4<f;Xa3I2deA;//1DFk;=I5^banAV@]OTHf;RD0000<0000
1`00P2D0000<00000000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000j`H008l600321`00f0H0000000160000:00001`00017A4U3
0P000>/6002?1P00`PL00:T600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0808h0000;000008@`=/00000V000000000000<Q10P00000004400000
0Q30f`00002I003o240Q0b`0000P00000Q30f`800000000000cOA5Eedd@0[_I4EGGCA0010`<E@240
400000@0000P00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P0000000000081090100000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000jPH008d600331`00Z@H00080001nKk=Y
Cg^cJBD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000j`H00;h600321`00f0H0000000160000
Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240R0SP0000/0000
0Q30f`00002H000000000000b44200000000@@0000024<3K000009T00?l8@2<3;000020000024<3K
0P00000000003=m406;IA02^mT@0H]U4004001E08`0@000010000280000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000P40T0400000000009T000000000000000009@0000`0000200009@0000`000050020
E`0002@0003Z1P00_@H00<<7003I1P000P0007i_ZFa?NjU/9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80003[1P00S`H00<87002Y1P00000004H000140000>00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080E@240400000@0000P00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
0081090100000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
jPH008d600331`00Z@H00080001nKk=YCg^cJBD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
j`H00;h600321`00f0H0000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0S0100000400008P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@2@0@00
00000000V@00000000000000000U000030000080000U0000300000D0081G000090000>X6002m1P00
``L00=T600020000OVnYK4mkZF`U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0003X3002?1P00
4@@00=P600000000AP0002P0000L0000AdA9@`80000j0`00S`H00144002Y1P00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2@2>00002`000024<3K
000009P0000000000038@@80000000110000008@`=/00000V@00o`Q09@</00008000008@`=/20000
00000:^RDDAEMM=4EW>0A5Eedd@00@005D0U0100000400009000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@2@0@0000000000V@00000000000000000U000030000080000U0000300000D0081G0000
900003P3002=1P004@@00:T600020000HCBcJC90/fTU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0003X3002n1P004@@00=P600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q09P8h0000;000008@`=/00000V000000000000<Q10P00000004400000
0Q30f`00002I003o240W0b`0000P00000Q30f`8000000000Zj9AA01RfDAFLh1406;IA001000E@2L0
400000@0000V00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P0000000000081090100000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000>0<00;d6000A1000f@H00080001Q=:U/
<T2YK2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000>P<008l6000A1000Z@H0000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D0U010000040000
9000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@2@0@0000000000V@00000000000000000U0000
30000080000U0000300000D0081G0000900003P3002=1P004@@00:T600020000HCBcJC90/fTU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0003X3002n1P004@@00=P600000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E09`0@0000100002H0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000P40T0400000000009T000000000000000009@0000`000020000
9@0000`000050020E`0002@0000h0`00_@H00144003I1P000P00064dZF`b@:U/9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80000H1@00`0D00><5003>1@00000004H0002X0000W00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@2P2>00002`000024<3K000009P000000000
0018@@80000000110000008@`=/00000V@00o`Q0:@</00008000008@`=/200000000003NXdAEiKQ4
082kA5GU^4@00@005D0Y010000040000:000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081G0000900001L5002o1@00
h`D00<h500020000ie5[G;QMJe`U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P00024100301@00
<P800<h500000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0:`8h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240Z0b`0000P00000Q30f`80000000000:RC@eGU^4AEc@Y4ENFhA001000E@2X0400000@0000[0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T00007`400;l5000b0P00cPD00080001]4V]L[29[G2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000bPP00<05001=2@00cPD0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240]0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@2`3;000020000024<3K0P000000000010e5
ENFhA:]W54EEiKQ4004001E0;00@0000100002d0000Q000020000680000<00000@0002@0000T0000
0000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40
I0000000000009T000000000000000009@0000`0000200009@0000`000050020E`0002@000382000
_`D004h9003>1@000P0007i6=Rh`BSH^9@0000`0000700209@0000`000000020900002@000000011
00000000000000110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001O1@00
P@L009`5002n1`00000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@2l3T00008@000024<3K3@0000000000[jm400CaA2X<[T@01?54ZkR/A7mGlTB[^:a4
EO[cA:^h[4@/WOE4:Pb^A:_`mT@0[jm4Zo3fA=MA/DB[l?I4EZFbA2bMmDAFYK94EO[cA5JU/TAoEo94
ee6aA004lD@0[jm400CaA0030`<30`<30`<30h<0000D@2n0400000@0002I003o8@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080000U000030000040000C0000
30000040000k0000200005D0001@000000000000003oooooooooo`d0003@EgYhoeIjN5EF97UEE_Ii
EEK7N_mFLG_@Eg5kXEQaNd]IagY;FOIiBeTTNJ5HNWS@EgYh?00000P0000n0000600006D500271`00
U@D00;P7000C000030000040000U000030000000080T000090000000P440000000000000P4400000
0000008000160000I00005P00015CDH[240^0T@0000h00000Q30f`00003N000000000000B4420000
0P000080000000110P00000000024<3K000009T00?lE@2l0400000@0000^0000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000000@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000D00005h500201`00
W0D00;l7000=0000d5MjN?mFNWQEERAiEEKfNEEFag[oEW5kd5MaNj5HLG];FLMjBeWfND]I97VQF7Yh
d5MjN2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000>0L00:P5001e1`00i@D0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240a0i0000240000
0Q30f`d0000000000=gZA:_V]D@Z>^U4ZnJeA:_Vid@Z>[M4ZnKWA03M^4B[i^M4egnjA2XjjDAFdk]4
0=gZA5KC^dCGOna4E]>kA5KCkDCGOkY4E]?]A03M^4AFdne4:SZgA=Mok4B[i[E40=gZA:_V]D@00`<3
0`<30`<30`>30000540aP10000040000V@00ob4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009@0000`0000100004`0000`000010000>`0000P0001E0000
D000000000000000ooooooooool=0000IgG/FYIdk5[/LiIKk7=WG>ac>5fFM>9MIgGRGCQfhUgRMSQM
hWIWG>9fUU/hM^aJIgG/FS`000080000?P0001P0000n1`00[PD006l7003O1@004`0000`000010000
9@0000`000000020900002@00000081100000000000008110000000000020000AP0006@0001H0000
ADe6:`Q0<0940000>000008@`=/00000gP000000000004Q10P000080000200000000@@8000000000
0Q30f`00002I003o5D0a010000040000<00002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000040b0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@000500000g1`00Y`D007H7003V1@003@0006Mek5ZFM>aJ
k7>FFnacIec/LcQMUWCRGFMehUdhM^9MhWHhGN9fIecRMYIK>7K/FVMek5XU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0008L3002Y1@00a0<00>H500000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q0<P>@0000Q000008@`=/=000000000:]4JDAEmkE4
oOiUA5Gg]D@0F6=4e4ZgA01HHdBZkKQ405QSA86@^TCmoVE40>BkA:]4JD@0i;]4F8Y/A03T^dAE<Fm4
PI2jA5DaKdBZkKQ4EC5_A=A:]dAHRVa4EONeA:]4JDAEmkE400<30`<30`<30`<3P`0001A0<X0@0000
100009T00?lQ000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0002D0000<00000@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo
3@0004Xjm5Yh>OAJcSRNFlhhKec>>45MN3WZGDXjjUdK>nYMaC]1GLDkKec5>iiK6c_dFTXjm5Xl0000
200003h0000H0000S0<00:l5002m0`00g`D001<0000<00000@0002D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@3<2A00003P000024<3K
00000=h0000000000018@@80000200000P000000044200000000008@`=/00000V@00oaE0<P0@0000
100003<0000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000010<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0001@0000Q@<00:P500340`00iPD000d0001:>_AJN3WdF/hhWU_>>6mLcSQ1GGPijUe:>^YM
6c_ZGLDk@Eg5>fmLaC^NFa/km5Y:>_AJ9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001O1@00
Z@D009`5003V1@00000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@3@3T00008@000024<3K3@0000000000[jm4EONeA2X<[TAEmkE4ZkR/A=A:]dB[^:a4
Z^fhA:^h[4B1T;Y4:Pb^A03T^d@0[jm40>BkA=MA/D@0i;]4EZFbA86@^TAFYK94Z^fhA5JU/TCDB[M4
ee6aA5Gg]D@0[jm4EONeA0030`<30`<30`<30h<0000D@3B0400000@0002I003o8@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080000U000030000040000C0000
30000040000k0000200005D0001@000000000000003oooooooooo`d0003@EoAJoeKdFUEFWU]EEVmL
EEI1GOmFjUg@EnYMXESZGD]I@Ee;FFmLBeVNFj5Hm5[@EoAJ?00000P0000n0000600006D5002_1@00
U@D00=l5000C000030000040000U000030000000080T000090000000P440000000000000P4400000
0000008000160000I00005P00015CDH[240e0T@0000h00000Q30f`00003N000000000000B4420000
0P000080000000110P00000000024<3K000009T00?lE@3@0400000@0000e0000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000000@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000D00005h5002X1@00
W0D00>H5000=0000d5OdF_mFm5YEEYiKEEI_G5EF@EgoE^YMd5OZGJ5HjUe;FD5MBeU_G4]IWU^QF?AJ
d5OdFRD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000D0L00<@6001M1`00YPL0000000160000
Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240f0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@3L3;000020000024<3K
0P000000002[e>Y406;IA:_DjT@0l_=4004001E0=`0@0000100003H0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000P40b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E`0002@0001>1`00``H005h7002W1`000P0006=eZFaSMO5i9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80001g1@00a0H008@5002V1`00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@3P2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q0>@</00008000008@`=/20000000005Fg[d@0H]U4EKN_A03bld@00@00
5D0i010000040000>000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000080000U0000300000D0081G0000900007H500331P00Q@D00:L700020000
e5NYK=AGlGTU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0009l300341P00[0<00:H700000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0>P8h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240k0b`0000P0000
0Q30f`8000000000EEEYA01RfDAEEFU40?;cA001000E@3/0400000@0000j00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5L0000T0000W@<00<<6002]0`00Y`L00080001>>ZU/CS[aNBD0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000D0L00<05001M1`00XPH0000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240l0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@3d3;000020000024<3K0P000000002[e>Y4ENFhA:_DjTAEMM=4
004001E0?@0@0000100003`0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000P0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E`0002@0001>1`00_`D005h7002S1P00
0P0006=eJeaSMK=Y9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001g1@00`0D008@5002R1P00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@3h2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q0?`</0000
8000008@`=/20000000005Fg[dAEiKQ4EKN_A5Eedd@00@005D0o010000040000?P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081G0000900007H5002o1@00Q@D00:<600020000e5M[G=AG/fTU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0009l300301@00[0<00:8600000000AP000:P0002L0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q00@8h0000;000008@`=/00000V0000000000004Q1
0P000000044000000Q30f`00002I003o24000b`0000P00000Q30f`8000000000EEEYA5GU^4AEEFU4
EGGCA001000E@000400000@0000100008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000W@<00;l5002]0`00
X`H00080001>>V]LCSZcJBD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000_0<00=T6001S1000
L@L0000000160000500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000000008bj4`3X^Q<0
J@000<X0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00003]G`/004`0V6EC<=aQNP410000U;LC0:lB0S0]01<0=M<1<12n4`000000
?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1
X7Aj0Abh4`1RO0X`cA<:hQ2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`000000002E00005@0003K0`00l0H001l4001Q1`000@0005EE1d5f@0M1
f`<004X700010000C00000000000000000000?ooooooooooD00004<0001300005P0000`000000000
9@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80001^1`00hPH001D8001i1`00
000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000
b@000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C0000001300000>]O2`00C02HIE<`g65j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1
000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X1
7;PC069l2S363PZF4;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B0000
30000040000H000030000000009D0000E00008d7003h1P00d@L006T700010000EED7@GI01d6=1`00
DPL00040001<00000000000000000000oooooooooom@0000@`0004<0000F000030000000000U0000
300000h0080X00003000008000160000:00001`00017A4U30P000384003b1000l@@008X500000000
AP0001@000080000AdA9@`<0001B0000L0400080002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0j;XC0840003g0000
/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000004<00000_b<;001<09QUDc3LHGX1000009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000
V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<016mj0J1dNP4L^1<0
HW`:<<dC2^T@_Q<03P02<03hoomTMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<000000000U@0001D0000M0@000T5002/1000NPD00040001EE@M1MT07@GD4001S1@00
0@0004`00000000000000000003ooooooooooe00001<0000>00001H0000<0000000002D0000<0000
3P00P2P0000<00000P0004H0000X0000700004M4BD<200002PH00?8400391P00RPD0000000160000
500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000000008bj4`3X^Q<0P@000?L0002`:gX1
000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
@`0000318`/004`0V6EC<=aQNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`
P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`
aPh:WA2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`000000002E00005@0001=1P002@D008D6001j1@000@0005EE1d5f@0M1CPH006<500010000
C00000000000000000000?ooooooooooD00004`0000h00005P0000`0000000009@0000`0000>0020
:00000`000020000AP0002P0000L0000AdA9@`80003S1`00lP@00:88002:1@00000004H0000D0000
200004M4BD<30000DP00070100020000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`210000m`000;0[NP4001<0
i;HC0=1PNP4>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
0=DS2`00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0
O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S3=4`[`
4;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000000009D0000E00002H800091@00GPP007X500010000EED7@GI01d4W2000H`D00040001<0000
0000000000000000oooooooooom@0000C00003P0000F000030000000000U0000300000h0080X0000
3000008000160000:00001`00017A4U30P000?4600301@00_0L00<h500000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00`8h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o24020b`0000P00000Q30f`8000000000
EO_NA5GU^4AEWOI4ENFhA001000E@080400000@0000300008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
l0H00;l5002l1`00cPD00080001fKf]LAg][G2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
F@P002@6000`2@00n@H0000000160000500000P00017A4U30`000580001`0@000P0006[oool00000
00000000002l0P0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000
/2]j0@40000000000000000000000000000000L00004LWX1X7Aj0JQHiS2`:gX1j6Mj0A@0001@^1<0
000000A_NP4100000@00052h4`17RN``000000A_NP400000X7Aj0NP/NP40000016mj0F00001L^1<0
K5SV<040000000000P00081aNP7P^1<0e7=j0@0000000000ooooodR@k32PSWX116mj0Lbi4`010000
=M<1<12n4`000000?65j0@T4NP4917X1dG`=<2HP000917X1000C000000000000;;TC000000000000
16mj0Bbi4`1NSN``16mj0@00000D^A<09;TC0000002@;gX1j6Mj0FAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`000000002E00005@0001h2000?@H000d9003V1P00
0@0005EE1d5f@0M1N0P00<H600010000C00000000000000000000?ooooooooooD00002HP002F0000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`8000090@00
P@L004D1002n1`00000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@0@3T00008@000024<3K3@000000002ZQY=300CaA4okS4<01?54EJf7@gmGlTAE[HM3
EO[cA5F]Qd</WOE4Co^<@j_`mTBZQY=3Zo3fA0DBVT>[l?I4062O@bbMmD@0H9m3EO[cA01PWd=oEo94
1A:J@`04lDBZQY=300CaA0030`<30`<30`<30h<0000D@0B0400000@0003ooooo:00000`000010000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080000W0000
6000004000000000oooo0000000U000030000040000C000030000040000k0000200005D0001@0000
00000000003oooooooooo`d0001Y4WYhV15jN>h@97W^4?IikQ37NYPALG]Y4W5k>a=aNn@Cag[T4oIi
i1<TNC/CNWQY4WYh?00000P0000n0000600000h100271`00?`400;P7000C000030000040000U0000
30000000080T000090000000P440000000000000P44000000000008000160000I00005P00015CDH[
24050T@0000h00000Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K
000009T00?lE@0@0400000@000050000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000000@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000D00000L100201`00AP400;l7000=0000JA9jN9PANWS^42Ai
kQ3fNNh@agZH4G5kJA9aNc/CLG_T4lMji1?fNN@C97Tk4gYhJA9jN2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<200002@400:P500150@00i@D0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`000800002024060i00002400000Q30f`d000000000ZXJC@j_V]DA?nha3
ZnJeA5F]Qd<Z>[M4EJf7@`3M^4AE[HM3egnjA4okS4=Fdk]4ZXJC@eKC^d@54YY3E]>kA01PWd?GOkY4
062O@`3M^4@0H9m3:SZgA0DBVT>[i[E4ZXJC@j_V]D@00`<30`<30`<30`>300005406P10000040000
ooooob4000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
9@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
JA;/FYPAk5[^49IKkQ1WG>h@>5fH4N9MJA;RGC/ChUgT4cQMi1=WG>@CUU/k4naJJA;/FS`000080000
?P0001P0000>0@00[PD003l1003O1@004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q01`940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D06010000040000
1`0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@00050000070@00Y`D004H1003V1@003@0006TBk5ZH4NaJkQ2FFnh@Iec^43QMV17RGFTBhUdk4n9M
i1<hGN@CIecT4iIK>a?/FVTBk5XU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000>L8001S1P00
80/00?/600000000AP0001@000080000AdA9@`<0001B0000L0400080002Loooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000;000000000000002<^Q<0
j;XC01P200061000/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000004<00000?<01001<09QUDc3LHGX1000009Bg4`2_4P8`;@0C03GC0C0@_Q<0
000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<0
16mj0J1dNP4L^1<0HW`:<<dC2_d@_Q<03P02<03hoomTMP08000002D0000<00000P0001H0000<0000
60000180000<00000@0001P0000<000000000U@0002D0000<PT007X6000M2`00j`H00040001EE@M1
MT07@C89003D1P00300004`00000000000000000003oooooooooof@0001Q06@0801Y06h0IP1Y06h0
J@1d07D0K@0/0000<P0001T0000L0000<P000240000L0000<P0001`0000L0000<P0004h0000F0000
30000000000U0000300000h0080X00003000008000160000:00001`00017A4U30P0002@2002A1@00
C@<00<h500000000AP0002P0000L0000AdA9@`80000T0P00T@D00902003>1@00000004H0003D0000
b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0P2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q02@=H0000C000008@`=/70000
000005G=2TAFiKQ4ELd:A:RO]DCI4a14ZoRbA02F5TB[n;940QPMA:_h/TBZGR94Z9neA:YN8TAFiKQ4
00<30`<30`0E@0T0400000@0000800008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h00008`800905002A0P00
cPD000L0002/8V]L[2;8F_dSMEVN9GEI?RMeFI0Xb5Z@:6]L9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`8000230P00T@D00>l2003>1@00000004H0003D0000b00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@0X2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q02`=H0000C000008@`=/70000000000208TAFiKQ4080RA:RO]DB4aRM4
ZoRbA:]8;TB[n;94[LXdA:_h/TAE4CY4Z9neA5DA>TAFiKQ400<30`<30`0E@0/0400000@0000:0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5D0000h0000PP800905003`0P00cPD000L0002H:6]LV2S8F^XYMEV;:gEI
:beeFGd^b5Ym;V]L9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003R0P00T@D004d3003>1@00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0d2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q030=H0000
C000008@`=/70000000005DA>TAFiKQ4EA4jA:RO]DCIEcm4ZoRbA03JADB[n;940Ua<A:_h/TBZXU54
Z9neA:ZRDDAFiKQ400<30`<30`0E@0`0400000@0000=00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000
h0800905001>0`00cPD000L0001m;V]LOBk8F/h_MEU_<GEI3c=eFF4db5YQ=6]L9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80000T0P00T@D00902003>1@00000004H000140000>00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P000080E@0T0400000@0000800008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0000h00008`800905002A0P00cPD000L0002/8V]L[2;8F_dSMEVN9GEI?RMeFI0Xb5Z@:6]L
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`8000230P00T@D00>l2003>1@00000004H000140000
>00004E=AR/Z@000900001P00000080o0000P0000800080o0000P000080E@0/0400000@0000:0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5D0000h0000PP800905003`0P00cPD000L0002H:6]LV2S8F^XYMEV;:gEI
:beeFGd^b5Ym;V]L9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003R0P00T@D004d3003>1@00
000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o0000P000080E@0`0
400000@0000=00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0000h0000h0800905001>0`00cPD000L0001m;V]L
OBk8F/h_MEU_<GEI3c=eFF4db5YQ=6]L9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002^0@00
P@L00>/1002n1`00000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@0l3T00008@000024<3K3@000000002ZE^I300CaA4o;gd<01?54EGgJ@gmGlTAEOMY3
EO[cA5EmfT</WOE4Cl_O@j_`mTBZE^I3Zo3fA0GRk4>[l?I4033b@bbMmD@0<?93EO[cA00`lT=oEo94
1N;/@`04lDBZE^I300CaA0030`<30`<30`<30h<0000D@0n0400000@0002I003o:00000`000010000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080000W0000
6000004000000000002I0000000U000030000040000C000030000040000k0000200005D0001@0000
00000000003oooooooooo`d0003377YhlQ]jN4PK97U86oIiB1_7N_8KLG_3775kUAeaNchNagXn7_Ii
?QhTNIDMNWS377Yh?00000P0000n000060000;@100271`00i0400;P7000C000030000040000U0000
30000000080T000090000000P440000000000000P44000000000008000160000I00005P00015CDH[
240>0T@0000h00000Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K
000009T00?lE@0l0400000@0000>0000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000000@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000D0000:d100201`00k0400;l7000=0000`aajN?8KNWQ86bAi
B1_fNDPKag[b6g5k`aaaNiDMLG/n7/Mj?QkfNChN97VE7GYh`aajN2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000H@4008l6000h0P00f0H0000000160000:00001`00017A4U30P000641002?1P00
>0800:T600000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q04@8h0000;000008@`=/00000V000000000000<Q10P000000044000000Q30f`00002I003o
240@0b`0000P00000Q30f`8000000000Za:g@eEeddAFc@Y4EGGCA001000E@100400000@0000A0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P0000000000081090100000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T0000H04008d6000i0P00Z@H00080003K5[=Y[2:cJBD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000H@400;h6000h0P00f0H0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240C0SP0000/00000Q30f`00002H0000
00000000b44200000000@@0000024<3K000009T00?l8@183;000020000024<3K0P000000002[4[M3
06;IA5K=2T@0H]U4004001E04P0@0000100001<0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000200009@0000`000050020E`0002@0001P0@00
_@H003T2003I1P000P000=/FZFb/8ZU/9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001Q0@00
S`H003P2002Y1P00000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@100400000@0000A00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000H04008d6000i0P00
Z@H00080003K5[=Y[2:cJBD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000H@400;h6000h0P00
f0H0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0B0100000400004`00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000080000U0000300000D0081G000090000601002m1P00>@800=T600020000
faJYK:`RZF`U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P00040300301@002P@00<h500000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0508h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240E0b`0000P0000
0Q30f`8000000000Zj9AA5GU^4AFLh14ENFhA001000E@1D0400000@0000D00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5L0000T0000?P<00;l5000;1000cPD00080001Q=6]L<T1[G2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000[P400:T5003[0@00iPD0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240F0i00002400000Q30f`d000000000ZUKV@eGg]DA?bmm3
EONeA5EmfT?DB[M4EGgJ@j[]^4AEOMY3PI2jA4o;gd<0i;]4ZUKV@`3T^d@5h^a30>BkA00`lT>1T;Y4
033b@j[]^4@0<?93e4ZgA0GRk4=EmkE4ZUKV@eGg]D@00`<30`<30`<30`>30000540FP10000040000
V@00ob4000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
9@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
`acdF_8Km5Y86iiKB1]_G4PK@Egb6nYM`acZGIDMjUdn7T5M?Qi_G3hNWU^E7OAJ`acdFS`000080000
?P0001P0002d0@00[`D00>@1003O1@004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q05`940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0F010000040000
5`0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@000500002]0@00Z0D00>`1003V1@003@000<<Lm5[b6oAJB1^NFdPKKea86d5MlQ_ZGL<LjUfE7NYM
?Qi1GChNKe`n7YiKUAgdF/<Lm5XU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<H100341P00
e0400:H700000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0608h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240I0b`0000P00000Q30f`800000000007SV@`1RfD@0N>I30?;cA001000E@1T0400000@0000H0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T0000a@400<<6003D0@00Y`L0008000377:U/aacaNBD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000aP400<05003D0@00XPH0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240J0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@1/3;000020000024<3K0P0000000000N>I3
ENFhA01hiT=EMM=4004001E06`0@0000100001X0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000>000000000000P40
b0000000000009T000000000000000009@0000`0000200009@0000`000050020E`0002@000350@00
_`D00=@1002S1P000P000<LLJec77;=Y9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003S0@00
f@H008/2001a1`00000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000
S;XC0>Rj4`1Y0000bP000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000005_00@00C02HIE<`g65j0@40002D]a<0[a82<2d04`0ed`4`
4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`
b;PC00A_NP6PM7X17;PC069l2S363P[34;hC00h00S00n?ooI7H02000000U000030000080000F0000
300001P0000B000030000040000H000030000000009D0000E00000<2003`1P00A`80064700010000
EED7@GI01d430P00BPL00040001<00000000000000000000oooooooooom@0000@`0004<0000F0000
30000000000U0000300000h0080X00003000008000160000:00001`00017A4U30P0005X2003b1000
6@<008X500000000AP0001@000080000AdA9@`<0001B0000L0400080002Loooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0
j;XC0840003g0000/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000004<00000I/01001<09QUDc3LHGX1000009Bg4`2_4P8`;@0C03GC0C0@_Q<0
000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<0
16mj0J1dNP4L^1<0HW`:<<dC2QH@_Q<03P02<03hoomTMP08000002D0000<00000P0001H0000<0000
60000180000<00000@0001P0000<000000000U@0001D0000W08000T5003D0P00NPD00040001EE@M1
MT07@Id2001S1@000@0004`00000000000000000003ooooooooooe00001<0000>00001H0000<0000
000002D0000<00003P00P2P0000<00000P0004H0000X0000700004M4BD<20000h@800142000N0`00
I`<0000000160000P04007@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240L0Q0100040@000Q30f`00002N6000000005EE1D7o0000o`00008000000011000006@000024<3K
00000080000200000020?`8000020000000000008440080o0000000000000000000002P000024<3K
0`00000P00000210002``0000000082o000P`000/<000@40I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010@024<3K000000000?l8@1d3;000020000024<3K0P000000001EkCm4
09P5A5G]?dB[AUQ4004001E07@0@0000100001`0000X000030000040000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000004P40400000000000000000000000000000009@0000`0000100009`0001P000020000
00000000000000009@0000`0000200004`0000`000020000>`0000P0000K0000400003H`003T8@00
F@0002P00000000000000?oooooooooo0`0003H`QCFa;hDe/BoT8Cd0000800006`000100001/;P00
6b@005T0000T000000000000003oooooooooo`80003d;e/QNc4K95P0000d000000000000003ooooo
ooooo`H0002=<C`TPS5T968aMRA1<HPT6C5l90LaG2AI0000:000000000000000ooooooooool30000
^Rl48Rh`12;Q;U`TF00003@00000000000000?oooooooooo1P000<l^O2BV;XPTQRif96H^I2AJ;S`T
K2hK93d0000800006`000100001k<@00CC<005T0000T000000000000003oooooooooo`80003d;`hf
K2i=<eP0000d000000000000003oooooooooo`H0001J;RdcIRh4<hH^lc:V;^4bcbk/<^4^33=I0000
:000000000000000ooooooooool30000;S1T=KX_I3D7<@`cF00003@00000000000000?oooooooooo
1P0001Tak391<N4bHS7c<X8a13>=<BdcNc5=<cd000080000?00000P0000o000060000>@2000D0P00
6`<006<3000C000030000040000U000030000000080U0000300000L0080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000742001d0P00
6@<000`300000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000002<^Q<0
j;XC06T0003:0000/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000004<00000G<01001<09QUDc3LHGX1000009Bg4`2_4P8`;@0C03GC0C0@_Q<0
000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<0
16mj0J1dNP4L^1<0HW`:<<H>2//@_Q<03P02<03hoomTMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<000000000U@0001D0000T08008/2003=0P00o0800040001EE@M1
MT07@I02003U0P000@0004`00000000000000000003ooooooooooe00001J0000>00001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000204000P600150@00
GPL0000000160000P04007@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240N0Q0100040@000Q30f`00002N6000000005EE1D7o0000o`00008000000011000006@000024<3K
00000080000200000020?`8000020000000000008440080o0000000000000000000002P000024<3K
0`00000P00000210002``0000000082o000P`000/<000@40I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010@024<3K000000000?l8@1l3;000020000024<3K0P000000001EII=3
0<31A5EUTd=E5n]4004001E07`0@0000100001h0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000004P40
400000000000000000000000000000009@0000`0000100009@0000`0000200004`0000`000020000
>`0000P0000K000040000:PB001NH@00F@0002P00000000000000?oooooooooo0`000:PBog@R4_md
8Q9NHCd0000800006`000100003N4000UF<005T0000T000000000000003oooooooooo`80001U4]EP
kA>EHeP0000d000000000000003oooooooooo`H0003o4kISla?NHm<Cl6>c4`9TRQ?fHgPCeV=I0000
:000000000000000ooooooooool30000:a9nHIlBOV5B4MISF00003@00000000000000?oooooooooo
1P00040AmV<H4@9Tma3`HmL@gV?<4;ISgQ2EHcd0000800006`000100003]4`00ag8005T0000T0000
00000000003oooooooooo`80001U4XQegQ37LUP0000d000000000000003oooooooooo`H0003<4:Mb
ea1nL_L@KG8H4E]b@15VLU8AQW9I0000:000000000000000ooooooooool30000Wa;NM2/BgWAh4hIb
F00003@00000000000000?oooooooooo1P0008XCIW:c4e]bda=]L_<COW;o4jMbkA?7LSd000080000
?00000P0000o0000600000/1000;1P00@P4005X7000C000030000040000U000030000000080U0000
300000L0080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000<P0001[1P00K`4000<700000000AP0001@000080000AdA9@`<0001B0000
L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00000000000000000002<^Q<0j;XC08L000040@00/2]j0@004`3T]Q<0d61j0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000ML01001<09QUDc3LHGX1
000009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`
b`/11bd04`000000@`0009450S38^1<016mj0J1dNP4L^1<0HW`:<<dC2Ql@_Q<03P02<03hoomTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000
b@00088600060@00l`H00040001EE@M1MT07@LT0003L1P000@0004`00000000000000000003ooooo
oooooe00001J0000>00001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000
700004M4BD<20000n`800?<5001T0`00M0L0000000160000[0400:010015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240P0Q0100040@000Q30f`00002N6000000005EE1D7o0000
o`00008000000011000006@000024<3K00000080000200000020?`8000020000000000008440080o
0000000000000000000002P000024<3K0`00000P00000210002``0000000082o000P`000/<000@40
I000008@`=/000000P0000800000080o0P00008000000000000P@@00P3l000000000000000000000
:000008@`=/300000200000084000;3000000000P;l00230002``0010@024<3K000000000?l8@243
F00004`000024<3K1`000000002T<5A40<31A2oAAdCTRlE4ENdoA4ZPcDAEkCm4l7oFA5G]?dCH?Mm4
K9I7A<8iidAL[e=4EAO[A0030`<30`<05D0Q0100000400008000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
0000000B0@0@0000000000000000000000000000000U000030000040000U000030000080000C0000
30000080000k0000200001/0000@0000_3@005YQ001I00008040000000000000oooooooooom10000
VSAaHA@dg66E<e5R7C?BHZdbGF=6<_9SiS6?I8ha=FE1<N5UoC2EI/4`D6N@<11XJS3DJ4d`WVTm<6YZ
=c0jJcd`26a><=5/JC2HKHl`FVjn<1Q_n33?Kc/aPW27<Beag37BLCXbKG:O<P9c3C><Lh8c3GCn<h=d
PCC^M9dd0WEA=6me;3AEMJ4ci7@O<fIdY3;OLc4bCG?7<K9bIC4?LPhaI76n<;5`NC3hKcd`>6l<<7=^
i2nYKLT_g6bh;`]//RlgJkP_Gf[9;h]YibnkJ0l`kfM2<2MWP31VI/P`ZVDI<OITMC5:I=TaYF=6<PYS
_39gHSXckf71<g=QCc@2HG8djf0m0000200001/0000@0000iC4001UQ001I00009000000000000000
ooooooooool200002CGFH9TcY6=H0000=000000000000000ooooooooool60000R3?4Hf0cdF<o<l5S
7S>`Ha4cR6<R<fMSF@0002P00000000000000?oooooooooo0`0005/d166L=6EQl36NHEP0000d0000
00000000003oooooooooo`H0003;<J5QZc65HJPaHF6U<CaQ`34LHNDa6F4m0000200001/0000@0000
QC<00;9b001I00009000000000000000ooooooooool20000j3B7MLDa=GEH0000=000000000000000
ooooooooool60000XC4aMHHa47F:<NadSS77M:ha[7CC<K1dF@0002P00000000000000?oooooooooo
0`0007hdmW@k=5Ie3S?]LUP0000d000000000000003oooooooooo`H0003m</ab2c>TLR`cU79=<hAb
MC>ALXDc/W8m0000200003`000080000?`0001P0003i0P002`H005<3001J1`004`0000`000010000
9@0000`0000000209@0000`000070020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`8000280P00J`H0030300031`00000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000bP000;0[NP4001<0
i;HC0=1PNP4>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
07_00@00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0
O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S363P[D
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000000009D0000E0000:P200221P00i@800?<600010000EED7@GI01d6X0P00g0H00040001<0000
0000000000000000oooooooooom@0000FP0003P0000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P0003h2003_0P00_0800;0600000000AP000;P1002/0@00
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q08P8L0@004040008@`=/00000
WQT00000001EE@E1o`000?l0000200000000@@00000200000020@000@41T00000Q30f`0000020000
0P000000P3l200000P000000000002110020?`000000000000000000000X00000Q30f`<000008000
000P@000/<0000000020_`008<000;300041@6@000024<3K00000080000200000020?`8000020000
000000008440080o0000000000000000000002P000024<3K0`00000P00000210002``0000000082o
000P`000/<000@400Q30f`000000003o240S0eP0001<00000Q30f`L000000000eTHXA5Fe@4AJfaU4
H=aEA5FY44ASL854EJT@A<dXVTAEZA14>X>bA=fF6D@e`LQ4:[0WA026dd@00`<30`<301E08`0@0000
10000280000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000004P4040000000000000000000000000000000
9@0000`0000100009@0000`0000200004`0000`000020000>`0000P0000K000040000?TY002k<000
F@0004P00000000000000?oooooooooo2`000>`YcS2K:ELaBRW[<O`XQC;l:8DbPbQ=<XDXBS;E::Xa
:2TC<GdYQC2::G4`?@0000P0000K0000400005XX003_<`00F@0003P00000000000000?oooooooooo
1`0001dXQSCH9d0eX2OO=B8W/cEK9a4eXRME==lW_C<m0000200001/0000@00009bL005Tg001I0000
@000000000000000ooooooooool900004bNI=mLVKcRM9TXiVRIH>APV>3TL9RTiERI:>9@VLSNW9S8g
?@0000P0000K0000400003lV003L>P00F@0003000000000000000?oooooooooo1@000?hU0ScC9N@l
D2G;?7/UiC^l9Klj?@0000P0000K0000400008dU001/?P00F@0003000000000000000?oooooooooo
1@00050UjClm9GU0^BAX@<dTe3l99ELn?@0000P0000K0000400000PU0004@P00F@0002P000000000
00000?oooooooooo0`000=0T5TA;90Q4Q2Cf@Cd0000800006`000100002_9000XdD005T0000`0000
00000000003oooooooooo`D0002R94E6SBBfA`LT[TLM93Y6:RBHACd0000800006`000100001j9000
A4T005T0000`000000000000003oooooooooo`D0001]9<9:JbAHBnHSET_X8ke:mB<oBCd000080000
6`000100001W9000id`005T0000`000000000000003oooooooooo`D0001V90i=K2CkC^LSoDkQ8`e=
hB?VC3d0000800006`000100001g9000RU0005T0000`000000000000003oooooooooo`D0002098eA
T2BMDP/TY5;k8i9AlR>>D3d0000800006`000100002Z9000:U@005T0000`000000000000003ooooo
ooooo`D0003=9>AEeR@lEU8TBUI89>mE9B@eE3d0000800006`00010000009@00bUL005T0000`0000
00000000003oooooooooo`D000069OaGA2GIFL0TjUV190YHO2CHEcd0000800006`00010000219@00
He/005T0000`000000000000003oooooooooo`D0002I9OmKgBE^GEXUQUdF9AALoBAhFcd000080000
6`000100000^9P00m5h005T0000`000000000000003oooooooooo`D0001H9[EOZBKhH2PV6F7E9M9O
ZbD@Gcd0000800006`000100000A9`00N68005T0000h000000000000003oooooooooo`L0000o9a9S
ObOJHk<WLF@e9iaT02L3I<0V>F>A9YiR?@0000P0000K0000400003hX003UI@00F@00040000000000
00000?oooooooooo2@0004dX2FJE:;EVgbQIIaDYaVNN:05XIRR@IaXXj6K@9cYV`RLEISd000080000
6`000100003B:@007fT005T0000X000000000000003oooooooooo`<0003G:BMYIRU^JF4YIVTm0000
200001/0000@0000@RL009Xa001I00009000000000000000ooooooooool200003BXS<=4YAc=H0000
=000000000000000ooooooooool60000cRU/<jhYR3>::HDcIBV2<dTYHS=<:ChcF@0002P000000000
00000?oooooooooo0`0007lYTC3P:M4`P2L@<UP0000d000000000000003oooooooooo`H0001P9b4b
=bLD<RHWm34E9m<a8RN[<D8WVS4m0000200001/0000@0000^RT009YV001I00009000000000000000
ooooooooool20000j2VoJB@W?6QH0000=000000000000000ooooooooool6000012LZJ?PV0VP:9n5W
6bO1Id@W]FMT9lMWF@0002P00000000000000?oooooooooo0`000;hY46UL:DiY=BVQIUP0000d0000
00000000003oooooooooo`H0000c:GaVCbUMIW@YFfJI:EUV^2UeI[XYVVHm0000200003`000080000
?`0001P0000l0P0000<00:<2002N1P004`0000`0000100009@0000`0000000209@0000`000070020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`8000260`00mP000<<3001f0@00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2@2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000200000P000000P3l200000P000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000
003oo`Q09@</00008000008@`=/200000000000dJDAEQGY303AYA01P^4<00@005D0U010000040000
900002P0000<00000P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h00000000000B0@0@000000000?l000000000
00000000000U000030000080000W00006000004000000000o`000000000U000030000040000C0000
30000080000k0000200001/0000@0000R3X00:4?001I0000:000000000000000ooooooooool30000
R3Yo5P<jOaH3>Z4??@0000P0000K000040000<dk00185000F@0002@00000000000000?oooooooooo
0P0004Dj21Nn>4PDF00003@00000000000000?oooooooooo1P000:`h9aBh>?lCf3S]4oPhfa<Q>NLC
<ST755T0000X000000000000003oooooooooo`<00020>UlF2cYO5UTk1aAH0000=000000000000000
ooooooooool60000JS_W4i<kfa>c>ndCdc_o4mlk9aC=>dPD?@0000P0000l0000200003l0000H0000
R@<00?P000300`00LP4001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
i`8007/0000510004`40000000160000500000P00017A4U30`000580001`0@000P0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<0g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00002?`04004`0V6EC<7aRNP400000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`cA<::a2n4`0>008`0?SoofAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005P0000]0`00TP00064300030@00
0@0005EE1d5f@0M1;@<00>`000020000C00000000000000000000?ooooooooooD00006T0800L0000
6@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<0g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:;70T7`1`91l0
000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0
=M<1<12n4`000000g65j0LdC2R/P00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0
000E02c]8P0U0000L>PG00002P1PC@40f;L100@0000X]a<0F10QUFAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`0003o0002E0000600001R0`00TP000>@300030@00
0@0005EE1d5f@0M1HP<00>`000030000C00000000000000000000?ooooooooooE00003d0800a0000
>00001T0000b00005P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000
AdA9@`80002^0@00kP@00>/1001_1@00000004H0000D0@00204004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2H2Y00009P000024<3K000009`@00000000EED5@Ol000020000
0000@@00001T00000Q30f`00000200000P000000P3l200000P000000000002110020?`0000000000
00000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000
003oo`Q09`</00008000008@`=/20000000005DeiT=EEIi4ECGV@jXL[D@00@<35D0W010000040000
9P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h00000000000B0@0@000000000?l00000000000000000000U0000
30000080000U000030000040000C000030000080000k0000200001/0000@00000Qd002=?001I0000
:000000000000000ooooooooool300000Qd1EW`L0EIl72=??@0000P0000K0000400004LN003:D`00
F@0002@00000000000000?oooooooooo0P000;lLReHh6lYCF00003@00000000000000?oooooooooo
1P0002HKZU<a6h5CDA]_Dg8KGE>J6fUC[1^9DeT0000X000000000000003oooooooooo`<0003i7>5E
QAcQEM8MRE=H0000=000000000000000ooooooooool60000i1eYD`dNGE<]7VmCCAj1DeTNZU=77/YC
?@0000P0000l0000200003l0000H0000/0400?04003X0@00J`D001<0000<00000@0002D0000<0000
0000P2D0000<00001`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<200003P4007@4000/0P0030D0000000160000500000P00017A4U3
0`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1000C0>Bf4`3@H7X1
3P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002F`04004`0
V6EC<7aRNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000
000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`aPh:hQ2n4`0>008`
0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002
E00005P0001E0@00R`@008T1003l10000@0005EE1d5f@0M1E@400>D400020000C000000000000000
00000?ooooooooooD00006T0800L00006@0001H0000<0000000002D0000<00003P00P2P0000<0000
0P000580001`0@000P0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1001Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO6PT7`3T]a<0
@@2AO4P75@1M095laPh:hg0T7`1`91l0000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`
b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000g65j0LH>2^8P00003P02<03hoomTMP08
000003X80S1`j1L0a;LC05iJlgO4]a<0000E03ce8P0U0000L>PG00002P1`E@40f;L100@0000X]a<0
F10QUFAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002
E0000600002:0@00R`@000`2003l10000@0005EE1d5f@0M1RP400>D400030000C000000000000000
00000?ooooooooooE00003d0800`0000>00001T0000b00005P0000`0000000009@0000`0000>0020
:00000`000020000AP0002P0000L0000AdA9@`80001O1@00mP0009`5001f0@00000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2P2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l20000
0P000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000/<000000
0020_`008<000;3000410`8@`=/00000003oo`Q0:@</00008000008@`=/2000000000:^V[dAEQGY3
ZjJ_A01P^4<00@005D0Y010000040000:000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000U000030000040000C000030000080000k0000
200001/0000@00003UP00:4?001I0000:000000000000000ooooooooool300003UQo5XUGOaJ9Ej4?
?@0000P0000K0000400005=I00185000F@0002@00000000000000?oooooooooo0P000<aG21M4ETPD
F00003@00000000000000?oooooooooo1P00039F9a@nE_lCGUK]4giFfa>WE^LC^EH755T0000X0000
00000000003oooooooooo`<00006F5lFTUMO5]mH1aAH0000=000000000000000ooooooooool60000
lESW4aUIfa<jFNdCFUWo4fEI9aACFDPD?@0000P0000l0000200003l0000H0000H@D00?P0002H1@00
LP4001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000_`@007/0003M1@00
4`40000000160000500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00002L`04004`0V6EC<7aRNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000
?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1
b7Aj0Abh4`1RO0X`cA<:>A2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005P000051@00TP0003T500030@000@0005EE1d5f@0M1
1@D00>`000020000C00000000000000000000?ooooooooooD00006T0800L00006@0001H0000<0000
000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:>W0T7`1`91l0000003aQNP400000
V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000
g65j0LdC2STP00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E04cm8P0U0000
L>PG00002P20G@40f;L100@0000X]a<0F10QUFAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`0003o0002E0000600000j1@00TP000;`500030@000@0005EE1d5f@0M1
>PD00>`000030000C00000000000000000000?ooooooooooE00003d0800b0000>00001T0000b0000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80000g1`00
mP0007@7001f0@00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@2/2Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;3000410P8@`=/00000003oo`Q0:P</0000
8000008@`=/20000000005FcjTAEQGY3EK?ZA01P^4<00@005D0Z010000040000:`00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h00000000000B0@0@000000000?l00000000000000000000U000030000080000U0000
30000040000C000030000080000k0000200001/0000@0000UGD00:4?001I0000:000000000000000
ooooooooool30000UGEo5PmeOaH?MJ4??@0000P0000K000040000=Yf00185000F@0002@000000000
00000?oooooooooo0P00059e21O;LdPDF00003@00000000000000?oooooooooo1P000;Uc9aC4LolC
i7?]4`Edfa<]M>LC?g@755T0000X000000000000003oooooooooo`<0002<MElF67EO5VEf1aAH0000
=000000000000000ooooooooool60000MgKW4j1ffa?0M^dCh7Ko4naf9aCJMTPD?@0000P0000l0000
200003l0000H0000>PL00?P0001a1`00LP4001<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000V0H007/0002e1`004`40000000160000500000P00017A4U30`000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002b`04004`0V6EC<7aRNP400000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`aPh:l12n4`0>008`0?SoofAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E00005P0003N1P00
TP00018700030@000@0005EE1d5f@0M1gPH00>`000020000C00000000000000000000?oooooooooo
D00006T0800L00006@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@00
0P0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095l
aPh:lG0T7`1`91l0000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000
@`0009450S38^1<0=M<1<12n4`000000g65j0LH>2_0P00003P02<03hoomTMP08000003X80S1`j1L0
a;LC05iJlgO4]a<0000E05`58`0U0000L>PG00002P2@I@40f;L100@0000X]a<0F10QUFAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E0000600000C1`00
TP0009D700030@000@0005EE1d5f@0M14`L00>`000030000C00000000000000000000?oooooooooo
E00003d0800c0000>00001T0000b00005P0000`0000000009@0000`0000>0020:00000`000020000
AP0002P0000L0000AdA9@`80001J2P00mP0009L:001f0@00000004H0000D0@00204004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@2d2Y00009P000024<3K000009`@00000000
EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l200000P00000000000211
0020?`000000000000000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;30
00410P8@`=/00000003oo`Q0;0</00008000008@`=/2000000000:^;9dEEQGY3Zh/WA@1P^4<00@00
5D0/010000040000;@00024000080000HP0000`000010000900002@00000000n000000000000000n
0000000000020000G`0003P000020000>0000000000h00000000000B0@08000000000?l000000000
00000000000U000030000080000U000030000040000C000030000080000k0000200001/0000@0000
i5<00=47001I0000:000000000000000ooooooooool30000i5=02j5C@0^QDm47?@0000P0000K0000
400008ID000T2P00F@0002@00000000000000?oooooooooo0P000<9CQ0_nDR@:F00003@000000000
00000?oooooooooo1P000?IB50[kDP0:2e?g2AaCkPT`Do@9>E<42UT0000X000000000000003ooooo
ooooo`<0003ODc0;YE<`2daD10YH0000=000000000000000ooooooooool60000EECd2FUDkPUiE?L9
RE@02XmD50Z6E2@:?@0000P0000l0000200003l0000H0000G@X00?P0002D2P00LP4001<0000<0000
0@0002D0000<00000000P2D0000<00001`00P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000^`T007/0003I2P004`40000000160000
500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1
000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
@`00002n`04004`0V6EC<1aSNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`
P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1l7Aj0Abh4`1RO0X`
cA<:BA2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005P0003/2@00U000020:00050@000@0005EE1d5f@0M1k0T00>h000020000
C00000000000000000000?ooooooooooD00006T0800L00006@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1
001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000
^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:BW0T7`1`91l0000003aQNP400000V6EC<82h4`1lL4T`
000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000g65j0LdC2TTP0000
3P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E06`=8`0U0000L>PG00002P2PK@40
f;L100@0000X]a<0F10QUFAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005P0000Q2P00U000074:00050@000@0005EE1d5f@0M18@X00>h000020000
C00000000000000000000?ooooooooooD00003d0800h00006@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@0000000P10019C07T0
K@1R06l0K00006D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1
000C0440TGa81aD0G@2AO<dC2TY`91l0L2@O0000000lHGX1000009QUDc20^1<0O719<1Rg4`000000
^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:Bg0T7`1`91l000000=aQNP7=4`Y9800000h00S00n?oo
I7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@1/3B<0=M<1<12n4`000000O69j0MRg0@0P0000
:;LC05P@8IETMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E08P?8`0U0000L>PG00002P2lK`40
f;L100@0000X]a<0F10QUFAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0001b2P00RP000;P:00030@000@0005EE1d5f@0M1LPX00>h000010000
C00000000000000000000?ooooooooooD0000:G`001700005P0000`0000000009@0000`0000>0020
:00000`000020000AP0002P0000L0000AdA9@`8000270`00kP@00<@3001_1@00000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2h2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l20000
0P000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000/<000000
0020_`008<000;3000410P8@`=/00000003oo`Q0;`</00008000008@`=/20000000005EEJDAEEIi4
EEEYA:XL[D@00@005D0_010000040000;P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000080000U000030000040000C000030000080000k0000
200001/0000@0000T3X002=?001I0000:000000000000000ooooooooool30000T3X1EP/j0EH;>R=?
?@0000P0000K000040000=Dk003:D`00F@0002@00000000000000?oooooooooo0P0004hjReK6><YC
F00003@00000000000000?oooooooooo1P000;@hZU?0>85Ch3Q_D`0iGE<Y>FUC>cV9DeT0000X0000
00000000003oooooooooo`<00028>^5E53[QEF4kRE=H0000=000000000000000ooooooooool60000
Lc]YDi/kGE>l>fmCg3^1DnLkZU?E>lYC?@0000P0000l0000200003l0000H0000R@<00?0400300`00
J`D001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000i`8007@400051000
30D0000000160000500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`000000@`00002Q`04004`0V6EC<7aRNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000
?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1
b7Aj0Abh4`1RO0X`aPh:012n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005P0000]0`00R`@00643003l10000@0005EE1d5f@0M1
;@<00>D400020000C00000000000000000000?ooooooooooD00006T0800L00006@0001H0000<0000
000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095laPh:0G0T7`1`91l0000003aQNP400000
V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000
g65j0LH>2P0P00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E08`G8`0U0000
L>PG00002P30M`40f;L100@0000X]a<0F10QUFAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`0003o0002E0000600001R0`00R`@00>@3003l10000@0005EE1d5f@0M1
HP<00>D400030000C00000000000000000000?ooooooooooE00003d0800a0000>00001T0000b0000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80001O1@00
kP@009`5001_1@00000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@302Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;300041008@`=/00000003oo`Q0<@</0000
8000008@`=/20000000005Fg[dAEEIi4EKN_A:XL[D@00@005D0a010000040000<000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h00000000000B0@0@000000000?l00000000000000000000U000030000080000U0000
30000040000C000030000080000k0000200001/0000@00005eP002=?001I0000:000000000000000
ooooooooool300005eP1EY5G0EJAEb=??@0000P0000K0000400005aI003:D`00F@0002@000000000
00000?oooooooooo0P000=AGReI=E/YCF00003@00000000000000?oooooooooo1P0003]FZU=6EX5C
IUI_DhMFGE>_EVUC`EJ9DeT0000X000000000000003oooooooooo`<0000>F>5EVUOQENMHRE=H0000
=000000000000000ooooooooool60000nEQYDb9IGE=2FFmCHUV1DfiIZU=LFLYC?@0000P0000l0000
200003l0000H0000HPD00?04002I1@00J`D001<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000`0@007@4003N1@0030D0000000160000500000P00017A4U30`000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00003E`04004`0V6EC<7aRNP400000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`cA<:F12n4`0>008`0?SoofAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E00005P000061@00
R`@003X5003l10000@0005EE1d5f@0M11PD00>D400020000C00000000000000000000?oooooooooo
D00006T0800L00006@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@00
0P0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8Q
C;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095l
cA<:FG0T7`1`91l0000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000
@`0009450S38^1<0=M<1<12n4`000000g65j0LdC2UPP00003P02<03hoomTMP08000003X80S1`j1L0
a;LC05iJlgO4]a<0000E09`O8`0U0000L>PG00002P3@O`40f;L100@0000X]a<0F10QUFAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`0003o0002E0000600000k1@00
R`@00;d5003l10000@0005EE1d5f@0M1>`D00>D400030000C00000000000000000000?oooooooooo
E00003d0800b0000>00001T0000b00005P0000`0000000009@0000`0000>0020:00000`000020000
AP0002P0000L0000AdA9@`80000g1`00kP@007D7001_1@00000004H0000D0@00204004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@3<2Y00009P000024<3K000009`@00000000
EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l200000P00000000000211
0020?`000000000000000000000X00000Q30f`<000008000000P@000/<0000000020_`008<000;30
0041008@`=/00000003oo`Q0<P</00008000008@`=/2000000000034jTAEEIi40<CZA:XL[D@00@00
5D0b010000040000<`00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h00000000000B0@0@000000000?l000000000
00000000000U000030000080000U000030000040000C000030000080000k0000200001/0000@0000
WGD002=?001I0000:000000000000000ooooooooool30000WGD1EQQe0EHHMB=??@0000P0000K0000
40000>9f003:D`00F@0002@00000000000000?oooooooooo0P0005YeReKCLlYCF00003@000000000
00000?oooooooooo1P000<5cZU?=Lh5CkG=_D`edGE<fM6UCAgB9DeT0000X000000000000003ooooo
ooooo`<0002EMN5E87GQEFifRE=H0000=000000000000000ooooooooool60000OgIYDjQfGE?8MVmC
j7J1DoAfZU?RM/YC?@0000P0000l0000200003l0000H0000>PL00?04001a1`00J`D001<0000<0000
0@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000V0H007@4002f1`0030D0000000160000
500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1
000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
@`00003:`04004`0V6EC<7aRNP400000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`
P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`
aPh:3Q2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E00005P0003N1P00R`@00187003l10000@0005EE1d5f@0M1gPH00>D400020000
C00000000000000000000?ooooooooooD00006T0800L00006@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0g`000:d1002`:gX1
001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000
^02AO6PT7`3T]a<0@@2AO4P75@1M095laPh:3g0T7`1`91l0000003aQNP400000V6EC<82h4`1lL4T`
000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000g65j0LH>2PhP0000
3P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E0:`W8`0U0000L>PG00002P3PQ`40
f;L100@0000X]a<0F10QUFAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`0003o0002E0000600000C1`00R`@009D7003l10000@0005EE1d5f@0M14`L00>D400030000
C00000000000000000000?ooooooooooE00003d0800c0000>00001T0000b00005P0000`000000000
9@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80001K2P00kP@009P:001_1@00
000004H0000D0@00204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@3D2
Y00009P000024<3K000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`0000020000
0P000000P3l200000P000000000002110020?`000000000000000000000X00000Q30f`<000008000
000P@000/<0000000020_`008<000;300041008@`=/00000003oo`Q0=0</00008000008@`=/20000
0000002D9dEEEIi409@WAJXL[D@00@005D0d010000040000=@00024000080000HP0000`000010000
900002@00000000n000000000000000n0000000000020000G`0003P000020000>0000000000h0000
0000000B0@08000000000?l00000000000000000000U000030000080000U000030000040000C0000
30000080000k0000200001/0000@0000j5<0098W001I0000:000000000000000ooooooooool30000
j5<1:jEC0B^UDi8W?@0000P0000K0000400008YD003U:@00F@0002@00000000000000?oooooooooo
0P000<ICAR/3DnDYF00003@00000000000000?oooooooooo1P000?YBeBT0Dl4Y45>h:B1C[bTdDkDY
?E?5:ET0000X000000000000003oooooooooo`<0003TDo4ZZE?a:U1DaBUH0000=000000000000000
ooooooooool60000FEBe:FeD[bUmE;PYSEC1:I=DeBV:E>DY?@0000P0000l0000200003l0000H0000
G@X00?04002D2P00J`D001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T0000
0000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
^`T007@4003I2P0030D0000000160000500000P00017A4U30`000580001`0@000P0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<0g`000:d1002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00003E`04004`0V6EC<1aSNP400000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1l7Aj0Abh4`1RO0X`cA<:J12n4`0>008`0?SoofAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005P0003/2@00S@@0020:003n1000
0@0005EE1d5f@0M1k0T00>L400020000C00000000000000000000?ooooooooooD00006T0800L0000
6@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<0g`000:d1002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000001Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:JG0T7`1`91l0
000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0
=M<1<12n4`000000g65j0LdC2VPP00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0
000E0;`_8`0U0000L>PG00002P3`S`40f;L100@0000X]a<0F10QUFAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005P0000Q2P00S@@0074:003n1000
0@0005EE1d5f@0M18@X00>L400020000C00000000000000000000?ooooooooooD00003d0800h0000
6@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool00000
00000000002@0@0000000P10019C07T0K@1R06l0K00006D0M`0P0580K`1]0640KP0000@000000000
000008bj4`3X^Q<0g`000:d1002`:gX1000C0440TGa81aD0G@2AO<dC2VU`91l0L2@O0000000lHGX1
000009QUDc20^1<0O719<1Rg4`000000^02AO6PT7`3T]a<0@@2AO4P75@1M095lcA<:JW0T7`1`91l0
00000=aQNP7=4`YX800000h00S00n?ooI7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@2l;b<0
=M<1<12n4`000000O69j0MRg0@0P0000:;LC05P@8IETMP08000003X80S1`j1L0a;LC05iJlgO4]a<0
000E0=Pa8`0U0000L>PG00002P0<TP40f;L100@0000X]a<0F10QUFAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`0003o0002E00005@0001b2P00P`@00;P:003l1000
0@0005EE1d5f@0M1LPX00>L400010000C00000000000000000000?ooooooooooD0000:G`00170000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`80001I2000
?@000309000A0@00000004H0000D0000200004M4BD<30000DP00070100020000J_ooo`0000000000
00000;`20000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000002`:gX1
0@0000000000000000000000000000001`0000AbNP6PM7X1Z5SV<;0[NP7XIgX15000052h4`000000
16mj0@4000010000D;PC04N9k300000016mj0@00002PM7X1j2aj0@000004KgX1H00005bh4`1/F>H`
0@00000000020000P75j0N2h4`3DLgX100000000003oooooB93/<:2>NP44KgX1c;TC0040000ed`4`
4;hC0000000lHGX12@Aj0@T4NP7AO0d`9R0000T4NP4001<000000000000/^A<0000000000004KgX1
;;TC05j=k304KgX1000001Bi4`0T^A<00000090_NP7XIgX1I7H02000000U000030000080000F0000
300001P0000B000030000040000H000030000?l0009D0000E00007P8001E00003@T00?h000010000
EED7@GI01d5h2000gP000040001<00000000000000000000oooooooooom@00009R0009H0000F0000
30000000000U0000300000h0080X00003000008000160000:00001`00017A4U30P0005T8000g1000
<0T000`500000000AP0001@000080000AdA9@`<0001B0000L0400080001Zoooo0000000000000000
_08000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000;0[NP410000
00000000000000000000000000070000179j0J1dNP6XF>H`/2]j0NQWNP4D0000D;PC00000004KgX1
0@000040001@^1<0AhW/<0000004KgX100000:1dNP7X;7X1000000A_NP5P0000G;PC06aHiS010000
000000800020LGX1h;PC0=AcNP40000000000?oooom8T>``X8ij0@A_NP7<^A<00@0003GC0C0@_Q<0
000003aQNP4917X12@Aj0M5l3C0V80002@Aj0@004`000000000002bi4`000000000000A_NP4/^A<0
GXg/<0A_NP4000005;TC02Bi4`000000T2mj0NQWNP5TMP08000002D0000<00000P0001H0000<0000
60000180000<00000@0001P0000<0000o`000U@0001D0000N0P00504000=2@00n@@00040001EE@M1
MT07@GP8003I10000@0004`00000000000000000003ooooooooooe00000V8000UP0001H0000<0000
000002D0000<00003P00P2P0000<00000P0004H0000d0000:00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080Q000020000680000<00000@0004`0001T0000g@000;4000322P00
``L00=d0002a0000iPT001<7000Y0:X0000000000000080o000000000000080o0000000000000000
000000000000000000000000000R000030000?oooom60000700001000015CDH[0T0000`000000000
3P0001@000000000400001@0
\>"], "Text",
 ImageSize->{322.0000469386535, 233.80168697434704`}],

Cell["\<\
Shrnuto je to na tomto obr\[AAcute]zku :\
\>", "Text",
 CellChangeTimes->{{3.561806326441112*^9, 3.561806331441112*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@000:oh0@0006`0002X0000404000H;003;0`00
S@D004X8001XG@0022000215CDH00040n:l001<5000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
K`<00<P1001l0`00[`<0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@043;000020000024<3K0P000000002[FUe4Zh;W@j]JGD@0o6U40041PAE00@0@0000
10000000000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0001]0`00a`4007d3002_0`000P0004lgjAa?=gLj
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80003F1@00X@<0058:002_0`00000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@082>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q00`</00008000008@`=/20000
000005FQ^d@0o6U4EJhTAJ_JJD@00@<35D030100000400000P00024000080000HP0000`000010000
900002@00000000n000000000000000n0000000000020000G`0003P000010000>0000000000h0000
000000020@1T000000000000V@00000000000000000U000030000040000U0000300000D0081G0000
90000=D5002O0`00DPX00:l300020000iBhl7EAB>1dU0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P0001H6002G0P00k@H00>0200000000AP0002P0000L0000AdA9@`80000F1P00U`800>d6002a0P00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0@2
>00002`000024<3K000009P0000000000038@@80000000110000008@`=/00000V@00o`Q01@</0000
8000008@`=/20000000005E[a4AEhBQ4E@gLA5GQ:4@00@615D050100000400001000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@2@0@0000000000V@00000000000000000U000030000040000U0000
300000D0081G0000900001D6002E0P00kPH00;4200020000;V8a:_m]<BXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0001H600360P00k@H00>0200000000AP000:P0002L0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q01P8h0000;000008@`=/00000V000000000000<Q1
0P000000044000000Q30f`00002I003o24070b`0000P00000Q30f`8000000000EF_4A:^j=4AE3Ma4
ZkXdA0010`<E@0L0400000@0000600008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T00005@H00<@2003^1P00
h0800080000^HRL]ofdW;BD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<200005PH009L2003]1P00
/@80000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D050100000400001000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000040000U0000300000D0081G0000900001D6002E0P00kPH00;4200020000
;V8a:_m]<BXU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0001H600360P00k@H00>0200000000
AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E01`0@0000
100000H0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40T0400000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0000E1P00a0800>h6003P0P000P0002iR9bgoKBL]
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000m2000R@<007X800360`00000004H0003D0000
b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0P3T00008@000024<3K
3@000000000[]@E5EMeSA;oS14EEgF=403X4AE:4IT@0>PA50<YYA00j14F]3fe4_n<4AJZfKd@[]@E5
Z[I_A9J61TFZ]Vm4EC07AJd?KDAE<0M50<YYA5D`1dEBQ6I4UXH6AEGMHd@[]@E5EMeSA0030`<30`<3
0`<30h<0000D@0R0400000@0002I003o8@0000P0001R000030000040000T00009000000003h00000
0000000003h0000000000080000W00006000004000000000002I0000000U000030000040000C0000
30000040000k0000200005D0001@000000000000003oooooooooo`d0003G@WPLKT9h71U2cA`I@SHM
6D:N7Fi2lagG@_<M@4?c7IE3WQfE@cHMUD?=7413N1cG@WPL?00000P0000n0000600004<8002?0`00
L`P00;l3000C000030000040000U000030000000080T000090000000044000000000000004400000
0000008000160000I00005P00015CDH[24090T@0000h00000Q30f`00003N000000000000B4420000
0P000080000000110P00000000024<3K000009T00?lE@0P0400000@000090000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h0000000000000@1T0000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000D00003/800270`00
NPP00<H3000=0000ed9h76i2N1`I@/dL6D8f7AU2WQe^@_<Med;c7D13lafE@ihMUD<f7IE3cAa0@gPL
ed9h72D0000<00001`00P2D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000V@H00>4200101`00N@<0000000160000
500000P00017A4U30`000580001`0@000P0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000000008bj4`3X^Q<0J@000<T0002`:gX1
00000000=PX4800060000>cS=PX8lCH:600007[gbS1300006000062g4`000000600000@000010000
F;LC03bg4`06m/X`0?mP<A@0001LmLX`?;LC01P000040000J4e<0:e:031/lcH:100009XC0S0D0000
J4e<09QUDc0007X15P0004`0002D]a<0AQ<2<</;0@L]01<0=M<1<12n4`000000?65j0@00002HIE<`
P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`
0a<:_a2n4`0>008`0?SoofAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`000000002E00005@0002h1P00n0800?`6001Y0`000@0005EE1d5f@0M1^0H0058300010000
C00000000000000000000?ooooooooooD00004<0001300005P0000`0000000009@0000`0000>0020
:00000`000020000AP0002P0000L0000AdA9@`80003J1P00V@4000<8003F0@00000004H0000X0000
700004M4BD<20000fPH009T100161`00eP40000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240:0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@0/3F00004`000024<3K1`00000000007]a4Zh;W@`0Ng4CeJmY3
@/7NA03@cd=E0^940=3?@eM3iD@0d<m3ZnKWA?E[fT>[i^M4Zh;W@`030`<30`>15D0;010000040000
2P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000>0000=T6002G0@00APL00=H1000700001fkY70M^AQ]IKo8I
nW3b6IYblQW/LdHKk7?Y72D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000>@L009T1002U1`00
eP40000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240<0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@0d3
F00004`000024<3K1`000000001EmnM4Zh;W@eGgidCeJmY3Ui[ZA03@cd>Zfne40=3?@j`LlD@0d<m3
0<3cA?E[fT<0`?=4Zh;W@`030`<30`<35D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
>00003P7002G0@00Y@L00=H100070000m7?Y7?AcAQ]6MO8IiWKb6HMhlQWHNDHKf7WY72D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000U`L009T100032000eP40000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240>0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@0l3F00004`000024<3K1`0000000000`?=4
Zh;W@`30ldCeJmY3@V?fA03@cd=EY?U40=3?@eOUo4@0d<m3ZhSoA?E[fT>[R?m4Zh;W@`030`<30`>1
5D0?0100000400003P00024000080000HP0000`000010000900002@00000000n000000000000000n
0000000000020000G`0003P000020000>0000000000h0000000000020@1T000000000000V@000000
00000000000U000030000080000U0000300000D0081E0000>00009H7002G0@0010P00=H100070000
k3ae3^`lX`fE?OT<ISki33Hon@cO?j<=gcme3RD0000<00001`00P2D0000<00000000P2@0000T0000
0000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
fPH009T100161`00eP40000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0;0100000400002P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081E0000>0000=T6002G0@00
APL00=H1000700001fkY70M^AQ]IKo8InW3b6IYblQW/LdHKk7?Y72D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000>@L009T1002U1`00eP40000000160000A00003P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000205D0=0100000400003000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
>00003P7002G0@00Y@L00=H100070000m7?Y7?AcAQ]6MO8IiWKb6HMhlQWHNDHKf7WY72D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000U`L009T100032000eP40000000160000A00003P00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000205D0?0100000400003P00024000080000
HP0000`000010000900002@00000000n000000000000000n0000000000020000G`0003P000020000
>0000000000h0000000000020@1T000000000000V@00000000000000000U000030000080000U0000
300000D0081E0000>00009H7002G0@0010P00=H100070000k3ae3^`lX`fE?OT<ISki33Hon@cO?j<=
gcme3RD0000<00001`00P2D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000/`P009T1003K2@00eP40000000160000
:00001`00017A4U30P000;<8002I0@007PT00=H100000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q0408h0000;000008@`=/00000V0000000000004Q1
0P000000044000000Q30f`00002I003o240A0eP0001<00000Q30f`L000000000EID;AJ^2id=EU@]5
mF_J@oKV34D0d<m3P8L>A@3@cd<0:1150=3?@jYi4DGeJmY3ZWTAAJ^2id<00`<30`<3PAE04@0@0000
10000100000Q000020000680000<00000@0002@0000T00000000?P00000000000000?P0000000000
0P0005l0000h00000P0003P000000000>000000000000P40I0000000000009T00000000000000000
9@0000`0000200009@0000`000050020E@0003P0002a2000U`4001l9003F0@001`000<M5M@k7AJ<=
L4Ki3417n@`@B?T<^DRS3KU8M@hU0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000149002I0@00
O@T00=H100000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q04P8h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240C0eP0001<00000Q30f`L000000000088AAJ^2id<0PQ55mF_J@j7C4TD0d<m3:g@DA@3@cd>[51I5
0=3?@eEV5dGeJmY3EFHGAJ^2id<00`<30`<30aE04`0@000010000180000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000
>000000000000P40I0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@0003P0000@2@00U`4007h9003F0@001`000;e8M@jmB:<=ITWi33M:n@`7BoT</4^S3K1;M@hU0000
300000L0080U000030000000080T00009000000004400000000000000440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000709002I0@00f`T00=H100000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0508h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o240E0eP0001<00000Q30f`L000000000
EFHGAJ^2id=EIQM5mF_J@oJg64D0d<m3P5PJA@3@cd<0nA]50=3?@jY:7DGeJmY3ZTXMAJ^2id<00`<3
0`<30aE05@0@0000100001@0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40I0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E@0003P0001^2@00U`400=`9003F0@00
1`000;1;M@j`Bj<=F4ci32U=n@ciCOT<XTjS3J9>M@hU0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000080000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000;<8002I0@007PT00=H100000000AP0004@0000h0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P1E04@0@000010000100000Q000020000680000<00000@0002@0000T0000
0000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40
I0000000000009T000000000000000009@0000`0000200009@0000`000050020E@0003P0002a2000
U`4001l9003F0@001`000<M5M@k7AJ<=L4Ki3417n@`@B?T<^DRS3KU8M@hU0000300000L0080U0000
30000000080T00009000000004400000000000000440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000149002I0@00O@T00=H100000000AP0004@0000h0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P1E04`0@000010000180000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000
>000000000000P40I0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@0003P0000@2@00U`4007h9003F0@001`000;e8M@jmB:<=ITWi33M:n@`7BoT</4^S3K1;M@hU0000
300000L0080U000030000000080T00009000000004400000000000000440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000709002I0@00f`T00=H100000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E05@0@0000100001@0000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0P0003P000000000>000000000000P40I0000000000009T000000000000000009@0000`000020000
9@0000`000050020E@0003P0001^2@00U`400=`9003F0@001`000;1;M@j`Bj<=F4ci32U=n@ciCOT<
XTjS3J9>M@hU0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000?07002G0P00a`P00>0200000000
AP0002P0000L0000AdA9@`80003`1`00U`800<L8002a0P00000004H0002X0000W00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@1H2>00002`000024<3K000009P000000000
0038@@80000000110000008@`=/00000V@00o`Q05`</00008000008@`=/20000000005FIodAEhBQ4
Zid;AEGQ:4@00@<35D0G0100000400005P00024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000080000U0000300000D0081G000090000>h7002E0P00
a`P00;4200020000hclI5L]56ADU0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000?0700360P00
a`P00>0200000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0608h0000;000008@`=/00000V000000000000<Q10P000000044000000Q30f`00002I003o
240I0b`0000P00000Q30f`8000000000EIWoA:^j=4B[W@]5ZkXdA0010H4E@1T0400000@0000H0000
8@0000P0001R000030000040000T00009000000003h000000000000003h0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T0000kPL00<D200372000h0800080003S?i@FbdFD5RD0000<0000
1`00P2D0000<00000000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000l0L009L200372000/@80000000160000A00003P00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000205D0G0100000400005P00024000080000
HP0000`000010000900002@00000000n000000000000000n0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081G000090000>h7002E0P00a`P00;4200020000hclI5L]56ADU0000300000L0080U0000
30000000080T00009000000004400000000000000440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000?0700360P00a`P00>0200000000AP0004@0000h0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P1E06@0@0000100001P0000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000P0003P000000000
>000000000000P40b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E`0002@0003^1`00a@800<L8003P0P000P000><oU1K;AI@F9@0000`0000700209@0000`000000020
900002@00000001100000000000000110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80003F1@00b@400>P6003G0@00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@1X2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q06`</00008000008@`=/20000000005FQ^d@02>Q301kLA5G5id<00@61
5D0K0100000400006P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000020000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000080000U0000300000D0081G000090000=D500370@00j0H00=L100020000
bEgi70M^lA`U0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<h900380@00DPX00=H100000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0708h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o240M0b`0000P0000
0Q30f`8000000000ZdXMAJ^2id=F[RA5Zh;W@`010H4E@1d0400000@0000L00008@0000P0001R0000
30000040000T00009000000003h000000000000003h0000000000080001O0000>0000080000h0000
000003P000000000008106@000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5L0000T0000c@T00<L1001B2P00eP400080002RCWD>E59e3RD0000<00001`00P2D0000<0000
0000P2@0000T00000000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000H`H008T3002P1P00aP<0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240N0i00002400000Q30f`d000000000ECc@A:_nHdAoVLi4
ZoiSA016cDBXYFI404K=A5K[JD@0A/e40c5]A7nIcT@0f6m4ECc@A03HKd@/gm540=Q_A:/bdd@3<Fe4
Zc;CA5K[JDB[<]=4Z:EVA2cOdDB[oV=4ECc@A:_nHd@00`<30`<30`<30`>3003o540NP10000040000
V@00ob4000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
9@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
5fSh>4EWn3RKIZ8iVfIc>Y]VAC]5Inhk5fS^>nQXkS^BJDDkTVUc>Y9YXSWXJ?Ph5fSh>3`000080000
?P0001P0001Y1P00S`<009X6002o0`004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q07`940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0N010000040000
7`0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@000500001R1P00R0<00:4600370`003@0001MXn3Q5IoPhVfJR>I]VLcZKITDkAFO^>aMXkS_XJ>hk
TVU5>i9YLcZBJJ8ij6Sh>1MXn3PU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0003d8002`0@00
NPP00>d100000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q080>@0000Q000008@`=/=0000000002^e1DD0R=]3_n<4A@28fd<0>PA5n]GP@`0j14EEHNM3
03X4AK3/kD>oh`A5Zc[c@b^e1DF[>_=3UXH6AJ/jld=E<0M5/>c]@eD`1dEEHNM3EC07AO[Eh4>FQPI5
08SK@b^e1DD0R=]300<30`<30`<30`<3P`0J@QA0880@0000100009T00?lQ000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0002D0000<00000@0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@000=M2]@e^@[D=6D8:3QU2L`hI@]/>
KT8`3mM2<0m0@c0?UD?K3YE3L`jE@`X>@4>e3MM2]@dl0000200003h0000H0000@`P00;H1001c2000
iP4001<0000<00000@0002D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0004H0001T0000F00004E=AR/8@242A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE0800@000010000240000T00009000000003h00000
0000000003h0000000000080001O0000>0000080000h0000000003P000000000000106@000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000>`P00:l1001j2000
kP4000d0003G@[D=KT:e3AU22PhI@W<>6D;K3Vi2<0oG@S0?@4<`3iE3f`jE@g<>UD<:3T13]@gG@[D=
9@0000`0000700209@0000`000000020900002@00000001100000000000000110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80001S1P00/@400:06003^0@00000004H0003D0000
b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@283T00008@000024<3K
3@000000001E?=14Zl[K@gnIcTB[b]]304K=A:DHhD<0A/e40:CW@`16cDAK;ni3OiW>A5Imld=E?=14
EWgc@bcOdDAFOO=3Zc;CA5/_kT>[<]=40:CW@j/bddBU6>53;=oAA:_:fd=E?=14Zl[K@`030`<30`<3
0`<30h<0000D@2:0400000@0002I003o8@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080000U000030000040000C000030000040000k0000200005D0001@0000
00000000003oooooooooo`d0000GJ78KAFMb6i]V71bKI^dLVfJn7DEWJ1hGJ6PNj6QX7Y9Y_QfBJNdL
TVTL7>QXLQ/GJ78K?00000P0000n0000600006T6002g0@00VPH00>L1000C000030000040000U0000
30000000080T000090000000P440000000000000P44000000000008000160000I00005P00015CDH[
240S0T@0000h00000Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K
000009T00?lE@280400000@0000S0000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000000@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081E0000D0000686002_0@00X@H00>h1000=00005fQb6dEWLQ^KIQ`L
VfK]79]V_Qe5IfPN5fQX7^QXJ1jBJKhMTVW]799Y71cXJ78K5fQb6bD0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000E0P00<`2001R2000[P<0000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240T0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@2D3;000020000024<3K0P0000000000/@E5ZkXdA02a1DF[fVU4
00430aE09@0@0000100002@0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000P0003P000000000>000000000000P40I0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E`0002@0001C2000b`800688002_0`00
0P000=E2U1KE@SPM9@0000`0000700209@0000`000000020900002@0000000110000000000000011
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001k1P00c08008T6002^0`00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2H2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q09`</0000
8000008@`=/2000000000:]4d4B[^SA4ZdC@A:_JJD@00@615D0W0100000400009P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000080000U0000
300000D0081G0000900007X6003;0P00R@H00:l3000200006fPW;A]XKcXU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0005@800380@00HPP00:X200000000AP000:P0002L0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q0:08h0000;000008@`=/00000V0000000000004Q1
0P000000044000000Q30f`00002I003o240Y0b`0000P00000Q30f`80000000000;45AJ^2id<0/@E5
EN4XA0010H4E@2T0400000@0000X00008@0000P0001R000030000040000T00009000000003h00000
0000000003h0000000000080001O0000>0000080000h0000000003P000000000008106@000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000D`P00<L1001R2000
Z`800080003E@WD>eD8I5BD0000<00001`00P2D0000<00000000P2@0000T00000000@@0000000000
0000@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000N`H00<P100291P00
ZP80000000160000Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240Z0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@2/3
;000020000024<3K0P000000002[A=14Zh;W@j]4d4AEhBQ40041PAE0:`0@0000100002X0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0P0003P000000000>000000000000P40b0000000000009T000000000000000009@0000`000020000
9@0000`000050020E`0002@0001j1P00a`4008T6002[0P000P0001]XjA`KJ34Z9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80001b2000j@8001T900210`00000004H0000D0000200004M4BD<30000
DP00070100020000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000b@000;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000;<S2`00C02HIE<`
g65j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S034`[Q4;hC00h00S00n?oo
I7H02000000U000030000080000F0000300001P0000B000030000040000H000030000000009D0000
E000094800000`00e@P0074300010000EED7@GI01d6A2000FP<00040001<00000000000000000000
oooooooooom@0000@`0004<0000F000030000000000U0000300000h0080X00003000008000160000
:00001`00017A4U30P0000l7003j0000cPL0098100000000AP0001@000080000AdA9@`<0001B0000
L0400080002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00000000000000000002<^Q<0j;XC0840003g0000/2]j0@004`3T]Q<0d61j0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000_b<;001<09QUDc3LHGX1
000009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`
b`/11bd04`000000@`0009450S38^1<016mj0J1dNP4L^1<0HW`:<94?2TH@_Q<03P02<03hoomTMP08
000002D0000<00000P0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000
D@L0010100291`00P@400040001EE@M1MT07@E87001Z0@000@0004`00000000000000000003ooooo
oooooe00001<0000>00001H0000<0000000002D0000<00003P00P2P0000<00000P0004H0000X0000
700004M4BD<20000j0P00?X0002W2@00TP40000000160000500000P00017A4U30`000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP00000000000000000008bj4`3X^Q<0P@000?L0002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002e8`/004`0V6EC<=aQNP400000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`0a<:j12n4`0>008`0?SoofAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`000000002E00005@0000Z2@00
4040068900210@000@0005EE1d5f@0M1:`T006X100010000C00000000000000000000?oooooooooo
D00004`0000h00005P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000
AdA9@`80003f1`00b0400<08003F0@00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@2`2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q0;@</00008000008@`=/2000000000:^8odB[P^M3EYD;AJ^2id<00@61
5D0]010000040000;000024000080000HP0000`000010000900002@00000000n000000000000000n
0000000000020000G`0003P000020000>0000000000h0000000000020@1T000000000000V@000000
00000000000U000030000080000U0000300000D0081G000090000?@700370@00`@P00=H100020000
gcme3/M5M@hU0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000080000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0004D9000/0P0070X0004300000000
AP0001@000080000AdA9@`<0001B0000L0400080001Zoooo0000000000000000_08000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000;0[NP4100000000000000000000
0000000000070000179j0J1dNP6XF>H`/2]j0NQWNP4D0000D;PC00000004KgX10@000040001@^1<0
AhW/<0000004KgX100000:1dNP7X;7X1000000A_NP5P0000G;PC06aHiS010000000000800020LGX1
h;PC0=AcNP40000000000?oooom8T>``X8ij0@A_NP7<^A<00@0003GC0C0@_Q<0000003aQNP4917X1
2@Aj0M5l3C0V80002@Aj0@004`000000000002bi4`000000000000A_NP4/^A<0GXg/<0A_NP400000
5;TC02Bi4`000000T2mj0NQWNP5TMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<000000000U@0001D0000I@T004D2003j2@00kP800040001EE@M1MT07@FD9003>0P00
0@0004`00000000000000000003ooooooooooe00000V8000UP0001H0000<0000000002D0000<0000
3P00P2P0000<00000P0004H0000X0000700004M4BD<20000_PD008T3003k1@00aP<0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240^0i0000240000
0Q30f`d00000000009VkA:_nHd@Zm[U4ZoiSA:^R^4BXYFI4Zj:hA5K[JDB[X[Q40c5]A2[f^D@0f6m4
09VkA03HKdCG>ke40=Q_A5J?_T@3<Fe4EXnnA5K[JDAFSki4Z:EVA=Lk_DB[oV=409VkA:_nHd@00`<3
0`<30`<30`>30000540^P10000040000ooooobP0000<00000@00024000080000HP0000`000010000
900002@00000080m000000000000080m00000000000200009`0001P00001000000000?ooo`000000
9@0000`0000100004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
aEgh>?ALn3Q:G:8iBUac>TYLAC_dG>hkaEg^>iINkS]0GdDk@5mc>T1OXSVFG_PhaEgh>3`000080000
?P0001P000341@00S`<00?@5002o0`004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q0;`940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0^010000040000
;`0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E@000500002m1@00R0<00?`500370`003@000<EMn3SdG?PhBUbR>DYLLcY:G4Dkm5c^>lEMkS^FG^hk
@5m5>d1OLcY0Gj8iUUkh><EMn3PU0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000;l5002a0@00
o0D00>h100000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0<0>@0000Q000008@`=/=000000000:ZY^dB[b]]3e0JjA:_:fd=E/kQ4YASQ@eFc^4@0Y>M3
EK>hA5/_kT?D1[Y4EWgc@jZY^dAFOO=3PDbmA5Imld<0X;i4Fbo^@`2P_T@0Y>M30:2nA:DHhD>1C;e4
Zl[K@jZY^dB[b]]300<30`<30`<30`<3P`0001A0<80@000010000?oooolQ000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0002D0000<00000@0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@000<eMLQ_lG78KDU`L759LkAaBG;hM
o5aX7/eMJ1jOGVPNB5nn7DQOkAa8Ga`LWeib6leMLQ/l0000200003h0000H0000a@D00;L1003e1@00
i`4001<0000<00000@0002D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0004H0001T0000F00004E=AR/8@342A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE0<00@000010000340000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000010<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0001@0000_@D00:l1003l1@00
kP4000d0003=GG8Ko5ab6e9L71aBG>dLDUbn7OaLJ1k=GFPNWeiX7TQO_Qe8GndLB5lL79mNLQ_=GG8K
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80002l2@00J`8000P;00030`00000004H0000D0000
200004M4BD<30000DP00070100020000W?ooo`0000000000000009010000000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00001P00000000000000S;XC0>Rj4`0/0@00@0800;0[NP4001<0
i;HC0=1PNP4>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
0>hS2`00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0
O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S034`[e
4;hC00h00S00n?ooI7H02000000U000030000080000F0000300001P0000B000030000040000H0000
30000000009D0000N00000P:00220P001P/00?<200010000EED7@GI01d482P00g08000L0001<0000
0000000000000000oooooooooomL0000H@1T0200J@1^06H0;P0002`0000b00006@0001`0000b0000
8@0001T0000F000030000000000U0000300000h0080X00003000008000160000:00001`00017A4U3
0P000?80002Q0`00O@<00:l300000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0<P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240c0b`0000P00000Q30f`8000000000071h@j_JJD@0O5e40?aYA0010H4E@3<0
400000@0000b00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5L0000T0000l00009l3001m0`00[`<00080001o3flj
EcMg>RD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000lP000<P100030P00eP40000000160000
Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240d0SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@3D3;000020000024<3K
0P0000000000L7Q3Zh;W@j/ZoT>[P^M30041PAE0=@0@0000100003@0000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000P0003P000000000
>000000000000P40b0000000000009T000000000000000009@0000`0000200009@0000`000050020
E`0002@0003`0000a`4000@2003F0@000P0007l?jAbn7nTL9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80003J0000R@<001L100360`00000004H0003D0000b00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@3H3T00008@000024<3K3@000000001F;GQ3ZoiSA:0FJd>[oV=4
ZgYP@jRUITB[NV13E^]YA:]jH4<3<Fe4X1I[@`3HKdAF;GQ30=Q_A0JRPT<0f6m40?27@`<aKD@0l8M3
E^]YA03`Qd>XYFI41Z:2@j_nHdAF;GQ3ZoiSA0030`<30`<30`<30h=W2@8D@3J0400000@0003ooooo
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080000U0000
30000040000C000030000040000k0000200005D0001@000000000000003oooooooooo`d0001k3oPh
ZPkh>00>XST03W<j00i5>jX>kS]k3nhkCA3^>oH@AC_f47<jmQ2R>Dd@n3Qk3oPh?00000P0000n0000
60000>00002?0`0040400;l3000C000030000040000U000030000000080T000090000000P4400000
00000000P44000000000008000160000I00005P00015CDH[240g0T@0000h00000Q30f`00003N0000
00000000B44200000P000080000000110P00000000024<3K000009T00?lE@3H0400000@0000g0000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000000@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
D0000=P000280`005`400<L3000=0000N`oh>:X>n3P03Z8i00ic>P0>AC^Z3^hkN`o^>dd@kS_f44Dk
mQ1c>_H@XSU=4?PhN`oh>2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000fP000;01000G0@00
k@40000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240h0i00002400000Q30f`d000000000EReh@`28fd>P5V]308SK@j]jH4?jeN13ZgYP@eEQid>[NV13
/>c]@j0FJd>[>_=3EReh@j/jld<6XX93Zc[c@`3`Qd>`k>e30?27@eEQid<0l8M3n]GP@`JRPT<0R=]3
EReh@`28fd<00`<30`<30`<30`>30000540hP10000040000ooooob4000080000HP0000`000010000
900002@00000080m000000000000080m00000000000200009@0000`0000100004`0000`000010000
>`0000P0001E0000D000000000000000ooooooooool=0000N`mY6jX>JA/03Q<L00kU700>]QfZ3V0N
N`mP7Td@H1kf4;HMmQ3U7?H@4aa=46TKN`mY6c`000080000?P0001P0003P0000]P400101003V0@00
4`0000`0000100009@0000`000000020900002@00000081100000000000008110000000000020000
AP0006@0001H0000ADe6:`Q0>@940000>000008@`=/00000gP000000000004Q10P00008000020000
0000@@80000000000Q30f`00002I003o5D0h010000040000>@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000P0003P000000000>000000000000040b0000000000009T0
00000000000000009@0000`0000200009@0000`000050020E@000500003H0000[`4001L1003^0@00
3@0007/?JA^Z3VTK00hC700>iA`03[HMZPiP7W/?H1i=460NmQ2f7OH@iAcf41<LCA1Y6g/?JA/U0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000?H1002I0@007P<00=H100000000AP0002P0000L0000
AdA9@`80003f0@00V@400642003F0@00000004H0003D0000b00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@3X2>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q0>`=H0000C000008@`=/7000000000:/ZoT>[P^M3Zb[n@oE[fT?JF`A4
0=3?@`3N2T@0d<m30f0AA03@cd>[YQI4mF_J@j^V5TB[P^M300<30`<30`<E@3/0400000@0000j0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5D0000h0000m04009L1001R0P00eP4000L0002n7nTL_Qm66`lQlQV`8_8I
D2Cb6J8UAQ^R9NTL9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001D0P00V@400<02003F0@00
000004H0003D0000b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@3`2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q0?@=H0000
C000008@`=/70000000000385TB[P^M30<PFA?E[fT>43Qa40=3?@j^@8T@0d<m3[A8YA03@cd=EFBi4
mF_J@eEI;TB[P^M300<30`<30`<E@3d0400000@0000l00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000
D`8009L100310P00eP4000L0002Z9NTLZRE66o`VlQVM:?8I?B[b6Hl[AQ^?:nTL9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002c0P00V@4001h3003F0@00000004H0003D0000b00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@3h2>00002`000024<3K000009P000000000
0018@@80000000110000008@`=/00000V@00o`Q0?`=H0000C000008@`=/70000000005EI;TB[P^M3
EET^A?E[fT?IWc=40=3?@`0R>T@0d<m30ZA0A03@cd>ZjTE4mF_J@j[ZADB[P^M300<30`<30`<E@3l0
400000@0000n00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000080000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000P0002D0000<00001@00P5D0000h0000/@8009L1000O0`00eP4000L0002?:nTL
Sb]66n0/lQV1;_8I8C3b6G<aAQ]c<NTL9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80003f0@00
V@400642003F0@00000004H000140000>00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P000080E@3/0400000@0000j00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000080000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000m04009L1001R0P00
eP4000L0002n7nTL_Qm66`lQlQV`8_8ID2Cb6J8UAQ^R9NTL9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000200008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80001D0P00V@400<02003F0@00000004H000140000>00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P000080E@3d0400000@0000l00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5D0000h0000
D`8009L100310P00eP4000L0002Z9NTLZRE66o`VlQVM:?8I?B[b6Hl[AQ^?:nTL9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000020000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002c0P00V@4001h3003F0@00000004H000140000>00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P000080E@3l0400000@0000n00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0000h0000/@8009L1000O0`00eP4000L0002?:nTLSb]66n0/lQV1;_8I8C3b6G<aAQ]c<NTL
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80001o0@00R@<00;`100360`00000004H0003D0000
b00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@003T00008@000024<3K
3@000000002Zi/i3ZoiSA4mKb4>[oV=4E@g3@jRUITAE3L=3E^]YA5D=`d<3<Fe4Ce_8@`3HKdBZi/i3
0=Q_A0EbeD<0f6m40<3J@`<aKD@0`=Y3E^]YA030fT>XYFI41G;E@j_nHdBZi/i3ZoiSA0030`<30`<3
0`<30h<0000D@020400000@0002I003o:00000`0000100008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080000W00006000004000000000002I0000000U0000
30000040000C000030000040000k0000200005D0001@000000000000003oooooooooo`d0003E6OPh
11Wh>5XHXSUJ67<jFQQ5>`@IkS_E6NhkYa[^>e0KAC]@6g<jD1^R>JLJn3SE6OPh?00000P0000n0000
600008D1002?0`00]@400;l3000C000030000040000U000030000000080T000090000000P4400000
00000000P44000000000008000160000I00005P00015CDH[24010T@0000h00000Q30f`00003N0000
00000000B44200000P000080000000110P00000000024<3K000009T00?lE@000400000@000010000
900002@00000080m000000000000080m0000000000020000G`0003P000020000>0000000000h0000
000000000@38000000000000V@00000000000000000U000030000080000U0000300000D0081E0000
D00007h100280`00_@400<L3000=0000eAWh>0@In3QJ6:8iFQQc>UXHAC/46NhkeAW^>jLJkS]@6dDk
D1]c>U0KXSVW6_PheAWh>2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000<P4009L200090P00
h080000000160000:00001`00017A4U30P000381002G0P002@800;4200000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q00P8h0000;000008@`=/00000
V000000000000<Q10P000000044000000Q30f`00002I003o24030b`0000P00000Q30f`8000000000
Zj:O@eGQ:4B[:_i3EN4XA0010`<E@0<0400000@0000200008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
0081090100000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
<@4009D2000:0P00/@800080003]4c4Z_Qla:RD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
<P400<H200090P00h080000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024040SP0000/00000Q30f`00002H000000000000b44200000000@@0000024<3K
000009T00?l8@0D3;000020000024<3K0P000000002[XYm3ZkXdA:/ZoT>[^SA400430aE01@0@0000
100000@0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000P0003P000000000>000000000000P40T0400000000009T00000000000000000
9@0000`0000200009@0000`000050020E`0002@0000a0@00a08000X2003P0P000P000>dC9bfn7bL]
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000200008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80000b0@00U`8000T2002a0P00000004H000140000
>00004E=AR/Z@000900001P00000080o0000P0000800080o0000P000080E@0<0400000@000020000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P0000000000081090100000000002I000000000000000002D0000<0000
0P0002D0000<00001@00P5L0000T0000<@4009D2000:0P00/@800080003]4c4Z_Qla:RD0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0P000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000<P400<H200090P00h080000000160000A00003P00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000205D050100000400001000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000020000
>0000000000h0000000000020@2@0@0000000000V@00000000000000000U000030000080000U0000
300000D0081G00009000034100340P002P800>0200020000kA<W;KhO9bdU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000080000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0007l1002a0@00_0400>h100000000AP000=@000380000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q01P>@0000Q000008@`=/=000000000:[VcT>[b]]3
Ce_8@j_:fd=E3L=3YASQ@eD=`d<0Y>M3E@g3@e/_kT=?FlQ3EWgc@j[VcT=FOO=31G;E@eImld<0`=Y3
Fbo^@`30fT<0Y>M30<3J@jDHhD<5L]E3Zl[K@j[VcT>[b]]300<30`<30`<30`<3P`0001A01X0@0000
100009T00?lQ000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0002D0000<00000@0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo
3@000=DILQ/46G8KFQPL75XHkAaJ6;hM11UX7]DIJ1jW6VPND1^n7E0KkAa@6a`LYaYb6mDILQ/l0000
200003h0000H0000Q@400;L1002e0@00i`4001<0000<00000@0002D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@0L2A00003P000024<3K
00000=h0000000000018@@80000200000P000000044200000000008@`=/00000V@00oaE01P0@0000
100000L0000T000090000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000
000003P00000000000010<P000000000002I000000000000000002D0000<00000P0002D0000<0000
1@00P5D0001@0000OP400:l1002m0@00kP4000d0003E6G8K11Ub6eXH71aJ6>dLFQRn7@@IJ1kE6FPN
YaYX7U0K_Qe@6ndLD1/L7:LJLQ_E6G8K9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002G0@00
c0800:D1002^0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@0T2>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000
V@00o`Q020</00008000008@`=/2000000000008cd>[^SA400S?@j_JJD@00@<35D08010000040000
2@00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000020000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000080000U0000300000D0081G0000900009H1003;0P00Y@400:l300020000fATW;MTIKcXU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000080000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0009L100380@00Y@400:X200000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q02P8h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o240;0b`0000P00000Q30f`8000000000
00S?@j^2id<02<m3EN4XA001000E@0/0400000@0000:00008@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000P0002D0000<00001@00P5L0000T0000
UP400<L1002U0@00Z`800080003I6NTLfATa:RD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000P000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
]@400>42001L0P00N@<0000000160000500000P00017A4U30`000580001`0@000P0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000
000008bj4`3X^Q<0J@000<X0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00001M=PX004`0V6EC<=aQNP410000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`T@l:LQ2n4`0>008`0?SoofAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`000000002E00005@0003D0@00n08001P2001Y0`00
0@0005EE1d5f@0M1e040058300010000C00000000000000000000?ooooooooooD00004<000130000
5P0000`0000000009@0000`0000>0020:00000`000020000AP0002P0000L0000AdA9@`8000120P00
nP000043002B0@00000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000
S;XC0>Rj4`210000m`000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000006Pf2P00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`
4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`
b;PC00A_NP6PM7X17;PC069l2S034`XD4;hC00h00S00n?ooI7H02000000U000030000080000F0000
300001P0000B000030000040000H000030000000009D0000E00008@2000@0@00_080084100010000
EED7@GI01d650P00JP400040001<00000000000000000000oooooooooom@0000C00003P0000F0000
30000000000U0000300000h0080X00003000008000160000:00001`00017A4U30P000=T0000@0P00
5`4006H300000000AP000801001d0@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0308@0@001040008@`=/00000WQP00000001EE@E1o`000?l0000200000000@@00001T0000
0Q30f`00000200000P000000P3l200000P000000000002110020?`000000000000000000000X0000
0Q30f`<000008000000P@000/<0000000020_`008<000;30004106@000024<3K0000008000020000
0020?`8000020000000000008440080o0000000000000000000002P000024<3K0`00000P00000210
002``0000000082o000P`000/<000@400Q30f`000000003o240=0b`0000P00000Q30f`8000000000
ZnYg@j]f1DB[jWM3EREHA001000E@0d0400000@0000<0000:00000`0000100008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P00000000001810100000000000000000000000000000002D0000<00000@0002L0000H0000
0P00000000000000000002D0000<00000P0001<0000<00000P0003/0000800006`000100002j3`00
fb4005T0000X000000000000003oooooooooo`<0002j3g`e=0ml=C@?fb4m0000200001/0000@0000
l0d001<T001I00009000000000000000ooooooooool20000M`mB8Ol@4bAH0000=000000000000000
ooooooooool600004A4c90DAG2CU46hTaA2099`@M2B:45@TF@0002P00000000000000?oooooooooo
0`0003d?o26a3o`QI0iD95P0000d000000000000003oooooooooo`H0001B3W@T:Pj090T>KRCY3E`T
gPdc9?0=4b@m0000200001/0000@0000oa0004Dc001I00009000000000000000ooooooooool20000
M`l6=_0=AC=H0000=000000000000000ooooooooool60000gPdU<nT=o3893^Xb:PkH<U8>i39T3P@c
F@0002P00000000000000?oooooooooo0`000;4?G3Dm3e`eRQ04<eP0000d000000000000003ooooo
ooooo`H0002L4>@baA3H<^D@jS854O`b4A4U<ol@AC<m0000200003`000080000?`0001P0003L0000
4`8001<1001R0`004`0000`0000100009@0000`0000000209@0000`000070020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002W0000
K08004l100040`00000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000
S;XC0>Rj4`27000010400;0[NP4001<0i;HC0=1PNP4>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000006`f2P00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`
4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`
b;PC00A_NP6PM7X17;PC069l2S2A3`Yj4;hC00h00S00n?ooI7H02000000U000030000040000F0000
300001P0000B000030000040000H000030000000009D0000E0000:P000230P00i@000?@200010000
EED7@GI01d6X0000g@800040001<00000000000000000000oooooooooom@0000FP0003P0000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P00014300380@00
O@<00=H100000000AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q03P8h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240?0b`0000P00000Q30f`8000000000ZnY5A5G5id<0O5e4ZX;W@`01000E@0l0400000@0000>0000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000000810<P000000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5L0000T00003`<00<L1001m0`00e`400080001c<O4LEcOY72D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000@0<002L2002/0`00D0<0000000160000F00004`00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000202T00P2@0000H0000ooooo`40002ZXU54
07@;A5RE_D:ZZXe3:00000`0000200008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080000W00006000008000000000oooo0000000U000030000080000U0000
300000P0081F0000<00004H3000]0P00Y@<004T300050000HCCE8V4dRcA>>X/dCS[E8V4deB8U0000
300000L0080U000030000000080T000090000000P440000000000000P44000000000008000160000
W00009000015CDH[240@0T00000d00000Q30f`00003F000000000000B44200000P00000004420000
0000008@`=/00000V@00o`Q04@<l0000<000008@`=/40000000005EEJDAEBE94EEEYA01d2dBZXU54
07@;A:ZRDDAEBE940041PAE04@0@000010000100000j0000300000P0000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P00000000002010<P000000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5H0000/000030<00?<1003O0`00
P`<000@0001>>X/dCS[E8V4deB9Q=8/d9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`000010000>P0000`0000:00008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80002i1000b@400<L4002_0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@182>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q04`</00008000008@`=/2000000000:/4V4AEaNM3Z`BHA5DMJT@00@00
5D0C0100000400004P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000040000U0000300000D0081G000090000;P400370@00a`@00;0300020000
nd_a7?];P3XU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0008/4000X0P00m`@0050300000000
AP0005P0001<0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Y0080T0000
60000?ooool10000ZbRBA5JE2dA@UKe2ZZZ=@b4000080000HP0000`000010000900002@00000080m
000000000000080m00000000000200009@0000`0000200009@0000`000080020EP000300002@1000
;@800?04001:0`001@0000e9gR8=BI<dnDjC=?U>gR8=BMhR9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000AP0009`0002@0000ADe6:`Q050900000
=000008@`=/00000eP000000000004Q10P000080000000110P00000000024<3K000009T00?l8@1D3
?000030000024<3K1000000000000Yi4ZfYBA002WTAFU@]4ZbRBA5JE2dB[:994ZfYBA0010H4E@1D0
400000@0000D0000>P0000`000080000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h00000000000P0@38000000000000V@00000000000000000U0000
30000040000U0000300000D0081F0000;00005H4003c0@00:PD008@300040000nDjC=?U>gR8=BMhR
3DVC=2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@0003X0000<00002P000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000XP@008X3003O1000
a`<0000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240F0i00002400000Q30f`d000000000ZQfHA00PI4CDNYI4021TA5DWUDCmaVI4EBNEA:/<JTAE9iE4
F59]A=AjUTAEnFm4ZQfHA5GiKdB1`9U4EOU_A00DVdAHDVe401BKA:/<JT@059]4oLIVA870VD@086A4
ZQfHA00PI4@00`<30`<30`<30`>30211540FP10000040000ooooob4000080000HP0000`000010000
900002@00000080m000000000000080m00000000000200009@0000`0000200004`0000`000010000
>`0000P0001E0000D000000000000000ooooooooool=00001d`0>CI;03V<BZXiS4Yl>Xa:CC/fBoLk
1dcg>mU<mc^2CDdkPTel>X9=ZSWIC00i1d`0>C`000080000?P0001P0002X1000T0<00=T400300`00
4`0000`0000100009@0000`000000020900002@00000081100000000000008110000000000020000
AP0006@0001H0000ADe6:`Q05`940000>000008@`=/00000gP000000000004Q10P00008000020000
0000@@80000000000Q30f`00002I003o5D0F0100000400005`0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000040b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E@000500002Q1000R0<00>0400370`00
3@0000M<03TfB`0iS4ZZ>Ha:O3Z<BTdk=T_g>`M<mc_IC?LkPTe=>h9=O3Z2CJXifD`0>@M<03TU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000:<4002a0@00h0@00>h100000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q060>@0000Q000008@`=/=0000
000005D^V4AE3Ma3Oh^FA5D=g4<0>9E4Ce_Q@`0hUDBZi^M303REA0EbkT=oRiI40<3c@eD^V4@0`?=3
;=6IA030ld>[99]41G;^@j/TVdBZi^M3ZbBKA4mKhD</dIU4E@gL@eD^V4AE3Ma300<30`<30`<30`<3
P`<30aA0680@000010000?oooolQ000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0002D0000<00000P0001<0000<00000@0003/000080000E@00050000000000
00000?oooooooooo3@00011<NQ/nBgXKU4XT79A:mAbDB/LM?T]`7Q1<L1kQC70NRdg77H]=mAb;CB@L
hDaj6a1<NQ/l0000200003h0000H0000Z@@00;L1003I1000i`4001<0000<00000@0002D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000F00004E=AR/8@1T2
A00003P000024<3K00000=h0000000000018@@80000200000P000000044200000000008@`=/00000
V@00oaE0600@0000100001T0000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000040000h0000000003P00000000000010<P000000000002I000000000000000002D0000<0000
0@0002D0000<00001@00P5D0001@0000XP@00;01003P1000k`4000d0000@C7XK?T]j6iA:91bDB_DL
U4[77Ci;L1h@C70NhDa`7X]=aaf;CODLRddT7>5<NQ/@C7XK9@0000`0000700209@0000`000000020
900002@00000081100000000000008110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80003C0`00G08006<4000a0`00000004H0000D0000200004M4BD<30000DP00070100010000
J_ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
00000000002`:gX10@000000000000000000000000000000400007QdNP41000016mj0N2g4`38^a<0
:<M=<000001@^1<0aHW/<=1PNP4lHGX10000022h4`00000016mj0@00000P0@00T000060000180000
900000h1000000000000000000020000P75j0N2h4`3DLgX10000000000000000j2aj0J2>NP44KgX1
ooooo`40000ed`4`4;hC0000000lHGX1j2aj0@0000070000179j0GQdNP400>H`/2]j0HaWNP4D0000
N7Aj0Lbi4`0300000;TC00d0mC24LgX1000000<0000<^A<00000090_NP6<IgX1I7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000000009D0000E0000?83001h0P00
AP@0024300010000EED7@GI01d7b0`00oP800040001<00000000000000000000oooooooooom@0000
HB8005D0000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0006D5001L0P00m@D0034300000000AP0001@000080000AdA9@`<0001B0000L0400040001Zoooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000
00000;0[NP410000000000000000000000000000000@0000N7Aj0@400004KgX1h;LC0<Rk4`0Xadd`
0000052h4`35RN``d61j0CaQNP4000008;PC00000004KgX100000201002@0000H00004P0000T0000
3P40000000000000000000800020LGX1h;PC0=AcNP40000000000000003X;7X1X8ij0@A_NP7ooooo
0@0003GC0C0@_Q<0000003aQNP7X;7X1000000L00004LWX1N7Aj0@00iS2`:gX1S6Mj0A@0001hM7X1
c;TC00<00000^A<03@3e<8AcNP4000000`0000bi4`000000T2mj0HaWNP5TMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000Q@D007P2003I1@00
8@<00040001EE@M1MT07@HD5003n0P000@0004`00000000000000000003ooooooooooe00001Q8P00
E@0001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000
_`@006`2001W1@0010<0000000160000500000P00017A4U30`000580001`0@000@0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00000000000000
000008bj4`3X^Q<0J@000<X0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00002W=PX004`0V6EC<=aQNP400000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`0a<:;Q2n4`0>008`0?SoofAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`000000002E00005@0000?1@00P`8004`5003d0P00
0@0005EE1d5f@0M13`D00=d200010000C00000000000000000000?ooooooooooD00005X0000h0000
5P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000AdA9@`80002P0P00
K08004P300040`00000004H0000D0000200004M4BD<30000DP00070100010000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000
S;XC0>Rj4`1Y0000bP000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C0000001300000<0f2P00C02HIE<`g65j0@00002D]a<0[a82<2d04`0ed`4`
4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`
b;PC00A_NP6PM7X17;PC069l2S2A3`ZC4;hC00h00S00n?ooI7H02000000U000030000040000F0000
300001P0000B000030000040000H000030000000009D0000E0000?0200230P00;@<00?@200010000
EED7@GI01d7`0P00g@800040001<00000000000000000000oooooooooom@0000FP0003P0000F0000
30000000000U0000300000h0080X00003000004000160000=00002P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000208@0000P0001R000030000040001<0000I0000:h0002C0@00
EPX00</3002^0000T`400:T9000i0P00:@2Z0000000000000020?`00000000000020?`0000000000
000000000000000000000000000000008P0000`0003oooooAP0001`0000@0000ADe6:`90000<0000
000000h0000D000000000100000D0000
\>"], "Text",
 ImageSize->{387.5000413507186, 104.85295236548856`}],

Cell["kter\[YAcute] vede na rovnici:", "Text",
 CellChangeTimes->{{3.561806326441112*^9, 3.561806331441112*^9}, {
  3.561806375987987*^9, 3.561806382581737*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "n", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"zInfinity", "=", 
  RowBox[{"z", "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"z", "\[Equal]", 
       FractionBox["1", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"z", "+", 
           RowBox[{"I", "*", "\[Omega]", "*", "L"}]}]], "+", 
         RowBox[{"I", "*", "\[Omega]", "*", "c"}]}]]}], ",", "z"}], "]"}], 
    "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"zInfinity", "=", 
    RowBox[{"z", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         FractionBox["1", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"z", "+", 
             RowBox[{"I", "*", "\[Omega]", "*", "L"}]}]], "+", 
           RowBox[{"I", "*", "\[Omega]", "*", "c"}]}]]}], ",", "z"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.46916439925301*^9, 3.46916439972176*^9}, {
  3.46916501347176*^9, 3.46916502181551*^9}}],

Cell[TextData[{
 "... Dosa\:010fme tedy do vztahu pro impedanci nekone\[CHacek]n\[EAcute]ho \
veden\[IAcute] podle pravidel ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"L", "\[Rule]", 
     FractionBox["L", "n"]}], ",", 
    RowBox[{"c", "\[Rule]", 
     FractionBox["c", "n"]}]}], "}"}]]],
 ", \[CHacek]\[IAcute]m vyjad\:0159ujeme, \:017ee jsme p\:0159ed \
chv\[IAcute]l\[IAcute] my\[SHacek]len\[YAcute] \[UAcute]sek veden\[IAcute] \
mezi dv\:011bma indexy podle obr\[AAcute]zku my\[SHacek]lenkov\:011b rozd\
\:011blili na ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " kousk\:016f o p\:0159\[IAcute]slu\[SHacek]n\:011b men\[SHacek]\[IAcute] \
kapacit\:011b a induk\[CHacek]nosti. "
}], "Text",
 CellChangeTimes->{{3.561806326441112*^9, 3.561806331441112*^9}, {
  3.561806375987987*^9, 3.561806382581737*^9}, {3.561806625441112*^9, 
  3.561806666034862*^9}, {3.561806737831737*^9, 3.561806761191112*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"zn", "=", 
  RowBox[{"zInfinity", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"L", "\[Rule]", 
      FractionBox["L", "n"]}], ",", 
     RowBox[{"c", "\[Rule]", 
      FractionBox["c", "n"]}]}], "}"}]}]}]], "Input"],

Cell["\<\
V\[YAcute]sledn\[YAcute] vztah se zjednodu\[SHacek]\[IAcute] na:\
\>", "Text",
 CellChangeTimes->{{3.561806326441112*^9, 3.561806331441112*^9}, {
  3.561806375987987*^9, 3.561806382581737*^9}, {3.561806625441112*^9, 
  3.561806666034862*^9}, {3.561806737831737*^9, 3.561806761191112*^9}, {
  3.561806805284862*^9, 3.561806807472362*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"zn", ",", 
    RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"L", ">", "0"}], ",", 
       RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}], "&"}]}]], "Input"],

Cell[TextData[{
 "V\[YAcute]razu ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Z", "\[Infinity]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " = ",
 Cell[BoxData[
  SqrtBox[
   FractionBox["L", "c"]]],
  CellChangeTimes->{3.561804546862987*^9}],
 " \:0159\[IAcute]k\[AAcute]me vlnov\[AAcute] impedance veden\[IAcute]."
}], "Text",
 CellChangeTimes->{{3.561806326441112*^9, 3.561806331441112*^9}, {
  3.561806375987987*^9, 3.561806382581737*^9}, {3.561806625441112*^9, 
  3.561806666034862*^9}, {3.561806737831737*^9, 3.561806761191112*^9}, {
  3.561806805284862*^9, 3.561806807472362*^9}, {3.561806921878612*^9, 
  3.561806932519237*^9}, {3.561806985737987*^9, 3.561807048737987*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell["\<\
Veden\[IAcute] - \:0159e\[SHacek]en\[IAcute] (impuls vyslan\[YAcute] po veden\
\[IAcute])\
\>", "Subtitle",
 CellChangeTimes->{{3.561807069284862*^9, 3.561807074847362*^9}, {
  3.561807470956737*^9, 3.561807479300487*^9}},
 Background->GrayLevel[0.85]],

Cell[GraphicsData["Metafile", "\<\
CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@000A6/0@0006`0001M0000W`4000T;00281000
A@<00?X<001XG@00ABH00215CDH00040[1410<X6000300000000000000000000H0T000P=003;0000
6P4000000000000000000<0I0`1@C`@0AP0002`0000P0000ADe6:`500@0L00004000008@`=/00000
;04002`100160000G00005000015CDH[8T0400`0000000007T0900`000000000940100`000000000
<4020100000400000020?b501`0<0000000000A0000<0000000004H0000X0000700004M4BD<20000
f@0008H2003W0000J`@0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`000800002024000SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@043;000020000024<3K0P000000002[NV13EHn<A5KeGd>Z9R=40041PAE00@0@0000
10000000000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003H0000Q0800>P0001/10000P00000>@4Kh3L8X
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80001K2P00QP8006T:001/1000000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@082>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q00`</00008000008@`=/20000
0000000M9TD0X8a4Za@VA@188d@00@<35D030100000400000P00024000080000HP0000`000010000
900002@00000000n000000000000000n0000000000020000G`0003P000010000>0000000000h0000
000000020@1T000000000000V@00000000000000000U000030000040000U0000300000D0081G0000
900005T:00250P00J@X006`4000200002e<T8`MCIA@U0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000=X0001N1000J@X006`400000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0108h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o24050b`0000P00000Q30f`8000000000ZgYP@`2PS4@07BI50:2<A0010H4E@0D0
400000@0000400008@0000P0001R000030000040000T00009000000003h000000000000003h00000
00000080001O0000>0000040000h0000000003P000000000008106@000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000f00005d4001Y2P00K0@0008000001b@S
2e<T8bD0000<00001`00P2D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<200005P@001`2002_1000D@80000000160000
504000P10015CDH[:T0002@0000H00000020?`00080000200020?`000800002024060Z@0002H0000
0Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/000000@00008000000910
0000000000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000:30
0000000000000230002P`001P@024<3K0000002I0?l8@0L3;000020000024<3K0P000000001EHH=4
EHT=A5DWUDAER@e40061PAE01`0@0000100000H0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000004P40
400000000000V@0000000000000000009@0000`0000100009`0001P0000200000000002I00000000
9@0000`0000200004`0000`000020000F`0004`0000I10007`800:/4001<0P000P0000T000050000
10000:U162<dB1PS=4RM8jU1WB>Y@APSlDL=8Xa:Fb?aAjPTlDL=8Q<0000<00000@0002D0000<0000
0000P2D0000<00001`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<200000P@008P1003a10008080000000160000500000P00017A4U3
0`000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0/0000581002`:gX1000C0>Bf4`3@H7X1
3P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002UG`/004`0
V6EC<5aTNP430000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000
000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1@7Ej0Abh4`1RO0X`A@l:9Q2n4`0>008`
0?SoofAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02
E00005@0000[1000W`4004H4000@0P000@0005EE1d5f@0M1:`@00?T100010000C000000000000000
00000?ooooooooooD00006T0000L00005P0000`0000000009@0000`0000>0020:00000`000010000
DP00070100010000_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`2`0000DP400;0[NP400640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095lB2@O0>Bg4`11095l
B0LE05d0TGa53`XWD2@O050T7`000000?65j0@00002HIE<`P;PC07a`BC000000000C00000S3;2`47
;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000003LHGX1A@l:9R00000>008`0?SoofAf00P00000
>PP2<73X5`34]a<0GU[cMlBg4`0001D096/O02D0001`j1L0000:070;003H]`40100002Rg4`363R7f
I7H02000000U000030000040000F0000300001P0000B000030000040000H00003000002I009D0000
E00004L4003F0@00J0@0024200010000EED7@GI01d5710004P800040001<00000000000000000000
oooooooooom@0000<P000280000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC0;00001B0@00/2]j0@004`11095lB0LE05d0TGa53`XW
D2@O050T7`000000?65j0@00002HIE<`P;PC07a`BC0H]a<000000;P0TGa891l0i;LC0440TGa81aD0
G@2AO4D?2RQ@91l0D2@O0000003LHGX1A@l:9R00000>008`0?SoofAf00P000000002<73X5`34]a<0
GU[cMlBg4`0001D096/O03GC0C0@_Q<0000007aRNP7H]`40800002Rg4`363R7fI7H02000000j208`
L>PG0<Bg4`1NF_=ga;LC00005@0lKAl09@00073X5`0000X0R0d00=Rg0@040000:;LC0<H>8OITMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D0000
J@@009l10029100040800040001EE@M1MT07@FT4003i0@000@0004`00000000000000000003ooooo
oooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0/0000581002`:gX1000C0440TGa81aD0G@2AO4D?2RQ@91l0
D2@O0000003LHGX1A@l:9R00000>008`0?SooaRg4`000000^02AO4PT7`3T]a<0@@2AO4P75@1M095l
A@l::E0T7`1@91l0000007aRNP7H]`40800002Rg4`363R7fI7H020000000008`L>PG0<Bg4`1NF_=g
a;LC00005@0lKAl0=M<1<12n4`00000076=j0MRg0@0P0000:;LC0<H>8OITMP08000003X80S1`j1L0
a;LC05iJlgO4]a<0000E05A_7`0U0000L>PG00002P2P3`00f;L100@0000X]a<0aPhQmVAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002:1000
W`400:L4000@0P000@0005EE1d5f@0M1RP@00?T100010000C00000000000000000000?oooooooooo
D00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1000000000000000S;XC0>Rj4`2`0000DP400;0[NP4001<0@@2AO4P75@1M095lA@l::E0T7`1@91l0
000007aRNP7H]`40800002Rg4`363R7f6;LC0000002h095lB2@O0>Bg4`11095lB0LE05d0TGa53`XZ
D2@O050T7`00000076=j0MRg0@0P0000:;LC0<H>8OITMP08000000000S1`j1L0a;LC05iJlgO4]a<0
000E05A_7`0ed`4`4;hC0000002lHgX1f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0
GU[cMlBg4`0001D0K74O02D0001`j1L0000:0;PA003H]`40100002Rg4`363R7fI7H02000000U0000
30000040000F0000300001P0000B000030000040000H00003000002I009D0000E0000:H4002O0@00
aP@0010200010000EED7@GI01d6V1000n@400040001<00000000000000000000oooooooooom@0000
:@000240000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0005D4001D0`00;0D009d300000000AP0002P0000L0000AdA9@`80001E1000E0<002`5001^0`00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@0P2
>00002`000024<3K000009P0000000000038@@80000000110000008@`=/00000V@00o`Q02@</0000
8000008@`=/200000000000lS4B[AUQ40=jSA:]6F4@00H615D090100000400002000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@2@0@0000000000V@00000000000000000U000030000040000U0000
300000D0081G0000900005<4001C0`00;0D006l3000200005TH:=^MA2SHU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P0005D400240`00;0D009d300000000AP000:P0002L0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q02P8h0000;000008@`=/00000V000000000000<Q1
0P000000044000000Q30f`00002I003o240;0b`0000P00000Q30f`800000000003b<A00PI4@0gZ=4
021TA001PH4E@0/0400000@0000:00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P0000000000081090100000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T0000D`@00883000/1@00
WP<00080000FAP0iie40>BD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000E@@005@3000/1@00
KP<0000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D090100000400002000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@000000
00000000000U000030000040000U0000300000D0081G0000900005<4001C0`00;0D006l300020000
5TH:=^MA2SHU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0005D400240`00;0D009d300000000
AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E02`0@0000
100000X0000Q000020000680000<00000@0002@0000T00000020?@00000000000020?@0000000000
0P0005l0000h00000@0003P000000000>000000000000P40T0400000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0001C1000PP<002`5002N0`000P0001I603WWD@0i
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`8000100`00EP8006T4002C0P00000004H0000X0000
700004M4BD<20000@0<005H2002/0`00T`80000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240<0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@0d3F00004`000024<3K1`000000002[XU54ZRHSA:^RDDA?Vaa4
;nUFA5E=5dAFJee4EDdGA5S]HdAECAM403AYA4nK74@0=6U4ZRHSA0030`<30`<35D0=010000040000
3000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000040000U0000300000D0081E0000>00003h3001E0P00[0<009@200070000HCC2:64d7bNc=L`U
DcO<9O@hc2E5>QlWAC[2:2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000W`<005H2000:1000
T`80000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240>0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@0l3
F00004`000024<3K1`000000001EEFU4ZRHSA5EEJDA?Vaa4fI]^A5E=5d@07WE4EDdGA0:PNdAECAM4
EG>0A4nK74AELh14ZRHSA0030`<30`<35D0?0100000400003P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081E0000
>00009d3001E0P002`@009@200070000CS[2:4hj7bNO>l`U@3g<9N0nc2Db@1lW<T32:2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000o@<005H2001Y1000T`80000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240@0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@143F00004`000024<3K1`000000001ELh14
ZRHSA5EcP4A?Vaa4UaJ3A5E=5dBZEhI4EDdGA:bHRDAECAM403b<A4nK74@0?8a4ZRHSA0030`<30`<0
5D0A0100000400004000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000040000U0000300000D0081E0000>0000?/3001E0P00J@@009@200070000
<T32:3907bN4@L`U94?<9LE4c2DFAQlW5TK2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
@0<005H2002/0`00T`80000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0=0100000400003000024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000040000U0000300000D0081E0000>00003h3001E0P00
[0<009@200070000HCC2:64d7bNc=L`UDcO<9O@hc2E5>QlWAC[2:2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000W`<005H2000:1000T`80000000160000A00003P00015CDH[:T0002@0000H0000
0020?`00080000200020?`00080000205D0?0100000400003P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081E0000
>00009d3001E0P002`@009@200070000CS[2:4hj7bNO>l`U@3g<9N0nc2Db@1lW<T32:2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000o@<005H2001Y1000T`80000000160000A00003P00015CDH[
:T0002@0000H00000020?`00080000200020?`00080000205D0A0100000400004000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000>0000?/3001E0P00J@@009@200070000<T32:3907bN4@L`U94?<9LE4c2DFAQlW
5TK2:2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000gPL004H4000J2000P`@0000000160000
e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240B0i0000240000
0Q30f`d000000000EH3oA5FQRDAogOe4EJ69A02:o4CDm8Y408[lA:ZGS4@0R_a4PCZ>A7oMoD@0SXm4
EH3oA02>SdBFT@1508j?A5Dk0DF1>Xi4EC/1AJZGS4AE>`55e?B:A9JA04EEXHU4EH3oA5FQRD@00`<3
0`<30`<30`>3VhTi540BP10000040000V@00obP0000<00000P00024000080000HP0000`000010000
900002@00000000n000000000000000n00000000000200009`0001P00002000000000000V@000000
9@0000`0000200004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
gCmU8W@oIB8O?kXR7clR8aloRb=d?n0SgCoP8dE0h2>J@8/SVT0R8iY0^R95@6DRgCmU8S`000080000
?P0001P0003S1`00C0@001@8001l10004`0000`0000100009@0000`000000020900002@000000011
00000000000000110000000000020000AP0006@0001H0000ADe6:`Q04`940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0B010000040000
4`0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000@0003P000000000
>000000000000040I0000000000009T000000000000000009@0000`0000100009@0000`000050020
E@000500003L1`00A@@001/8002410003@000=doIB9d?fDR7cnj8Qlo8R<O?h/SM3oP8mdoh2=5@>0S
VT2;8iY08R>J@;XRAD1U8]doIB8U0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<X200171000
1P<008@400000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q050>@0000Q000008@`=/=000000000:/0>T@0/XU4oKXfA02bRD@053A4O`F;A00D=4AEZ8a4
01@dA2a;STCm^SI4Zij?A:/0>TB[WXm4F4HmA:^NSdAEkCm4;4^>A5G]?dAEZ8a4ENdoA7l5RdAHASe4
0;:9A:/0>T@0/XU400<30`<30`<30`<3P`0001A0580@0000100009T00?lQ000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0002D0000<00000P0001<0000<0000
0@0003/000080000E@0005000000000000000?oooooooooo3@0007T^dDBW;M54oBakAOd/CDKm;1i7
Ybg8AgT^b4M:;lQ7m2lNAo@_CDKd;g]5BRoAA7T^dD@l0000200003h0000H0000c`8004d400000`00
O@@001<0000<00000@0002D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0004H0001T0000F00004E=AR/8@1D2A00003P000024<3K00000=h0000000000018@@8000020000
0P000000044200000000008@`=/00000V@00oaE0500@0000100001D0000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P00000000000010<P000000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5D0001@0000b08004D400070`00
Q0@000d0001i;]54YbgAA?d/NdGm;4e6oB`NAjL]b4Mi;/Q7BRo8Ao@_7TOd;de6m2mkADX_dDAi;]54
9@0000`0000700209@0000`000000020900002@00000081100000000000008110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80003H1000W`<007l5000g1000000004H0000D0000
200004M4BD<30000DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000b@000;0[NP4001<0
i;HC0=1PNP4>008`_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C000000130000
0<UO2`00C02HIE<`g65j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0
O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S0j3@Z^
4;hC00h00S00n?ooI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000000009D0000E0000?L4002f0`00>`D002L400010000EED7@GI01d7g100040@00040001<0000
0000000000000000oooooooooom@0000@`0004<0000F000030000000000U0000300000h0080X0000
3000004000160000:00001`00017A4U30P0005h3000X0`00H`@00<0300000000AP0001@000080000
AdA9@`<0001B0000L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC0<L0001n0@00/2]j0@004`3T]Q<0
d61j0@h00S2moooo0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000e5l;
001<09QUDc1LI7X10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`
000000004`0j208`b`/11bd04`000000@`0009450S38^1<016mj0D1eNP4L^1<0HW`:<4D?2TP@_Q<0
3P02<03hoomTMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001D0000TP<003l300330`00/0<00040001EE@M1MT07@I83002I0`000@0004`000000000
00000000003ooooooooooe00001e0000<P0001H0000<0000000002D0000<00003P00P2P0000<0000
0@000580001`0@000@000;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0a`0007h1002`:gX1001Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000001Rg4`000000^02AO4PT7`3T]a<0
@@2AO4P75@1M095lA@l:BE0T7`1@91l0000003aQNP400000V6EC<82h4`1lL4T`000000004`00008`
b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000g65j0DD?2TPP00003P02<03hoomTMP08
000003X80S1`j1L0a;LC05iJlgO4]a<0000E002C7`0U0000L>PG00002P1<<`00f;L100@0000X]a<0
aPhQmVAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002
E00005@000340`00MP<00>D300310`000@0005EE1d5f@0M1a0<00;8300010000C000000000000000
00000?ooooooooooD0000340000R00005P0000`0000000009@0000`0000>0020:00000`000010000
DP00070100010000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`370000OP400;0[NP4001<0@@2AO4P75@1M095l
A@l:BE0T7`1@91l0000003aQNP400000V6EC<82h4`1lL4T`6;LC0000002h095lB2@O0>Bg4`11095l
B0LE05d0TGa53`Y:D2@O050T7`000000g65j0DD?2TPP00003P02<03hoomTMP08000000000S1`j1L0
a;LC05iJlgO4]a<0000E002C7`0ed`4`4;hC0000001lHWX1f;L10200000X]a<0aPhQmVAf00P00000
>PP2<73X5`34]a<0GU[cMlBg4`0001D069DO02D0001`j1L0000:06@e003H]`40100002Rg4`363R7f
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000>H3000o0`001P@00;0300010000EED7@GI01d7V0`00V@<00040001<00000000000000000000
oooooooooom@0000:0000240000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC0<L0001n0@00/2]j0@004`11095lB0LE05d0TGa53`Y:
D2@O050T7`000000g65j0DD?2TPP00003P02<03hoolH]a<000000;P0TGa891l0i;LC0440TGa81aD0
G@2AO4D?2T]@91l0D2@O0000001lHWX1f;L10200000X]a<0aPhQmVAf00P000000002<73X5`34]a<0
GU[cMlBg4`0001D069DO03GC0C0@_Q<0000001aSNP7H]`40800002Rg4`363R7fI7H02000000j208`
L>PG0<Bg4`1NF_=ga;LC00005@0`Ual09@00073X5`0000X0O3L00=Rg0@040000:;LC0<H>8OITMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
1`@003l3000T1000/0<00040001EE@M1MT07@@L4002I0`000@0004`00000000000000000003ooooo
oooooe00001d0000700001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0a`0007h1002`:gX1000C0440TGa81aD0G@2AO4D?2T]@91l0
D2@O0000001lHWX1f;L10200000X]a<0aPhQmQRg4`000000^02AO4PT7`3T]a<0@@2AO4P75@1M095l
A@l:C50T7`1@91l0000001aSNP7H]`40800002Rg4`363R7fI7H020000000008`L>PG0<Bg4`1NF_=g
a;LC00005@0`Ual0=M<1<12n4`000000_6=j0MRg0@0P0000:;LC0<H>8OITMP08000003X80S1`j1L0
a;LC05iJlgO4]a<0000E04RI7`0U0000L>PG00002P2D>@00f;L100@0000X]a<0aPhQmVAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0000S1000
?`<004<4002`0`000@0005EE1d5f@0M18`@009T300010000C00000000000000000000?oooooooooo
D00002T0000Q00005P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000
AdA9@`80000I1@00EP800486002C0P00000004H0000X0000700004M4BD<200006@D005H200241@00
T`80000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240F0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@1L3
F00004`000024<3K1`000000002[kZ=4ZRHSA:_^XdA?Vaa4kI6VA5E=5d@0djU4EDdGA08D[DAECAM4
E[N_A4nK74AF]jm4ZRHSA0030`<30`>15D0G0100000400005P00024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081E0000
>00001L5001E0P00Q@D009@200070000l572:?1A7bM1Dl`UhUC<9H9Fc2GDEalWe5O2:2D0000<0000
1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000N0D005H2003S1@00T`80000000160000e0000<P00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240H0SP0000/00000Q30f`00002H0000
00000000B44200000000@@0000024<3K000009T00?l8@1T3F00004`000024<3K1`0000000000b:m4
ZRHSA038[dA?Vaa4@V^bA5E=5dAE[;E4EDdGA5O]^4AECAM4Zi2kA4nK74B[T;]4ZRHSA0030`<30`>1
5D0I0100000400006000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000040000U0000300000D0081E0000>00007H5001E0P00i0D009@200070000
g5O2:=aG7bL^FL`Uce[<9FmLc2G1GAlW`Eg2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
ePD005H200121P00T`80000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240J0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@1/3F00004`000024<3K1`000000002[T;]4ZRHSA:^@^dA?Vaa4kC>nA5E=5d@0ML54
EDdGA0:fa4AECAM4EUW7A4nK74AFFLM4ZRHSA0030`<30`<35D0K0100000400006P00024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000>0000=@5001E0P00@PH009@200070000`Eg2:<5M7bLBGl`U/f3<9E=Rc2FUHalW
YF?2:2D0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<200006@D005H200241@00T`80000000160000
A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`00080000205D0G010000040000
5P00024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000040000U0000300000D0081E0000>00001L5001E0P00Q@D009@200070000l572:?1A7bM1Dl`U
hUC<9H9Fc2GDEalWe5O2:2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000N0D005H2003S1@00
T`80000000160000A00003P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
5D0I0100000400006000024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000040000U0000300000D0081E0000>00007H5001E0P00i0D009@200070000
g5O2:=aG7bL^FL`Uce[<9FmLc2G1GAlW`Eg2:2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
ePD005H200121P00T`80000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0K0100000400006P00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000040000U0000300000D0081E0000>0000=@5001E0P00
@PH009@200070000`Eg2:<5M7bLBGl`U/f3<9E=Rc2FUHalWYF?2:2D0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000D`P005H2001l2@00T`80000000160000:00001`00017A4U30P0005<8001F0P00
_`P009<200000000AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q0708h0000;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o
240M0eP0001<00000Q30f`L000000000EJ05AJXV8dAEX0E5Ci/LA?Ka1TEECAM4P988AEE=5d@0<`Y5
EDdGA:Z42dE?Vaa4ZX@;AJXV8d@00`<30`<30aE07@0@0000100001`0000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000@0003P000000000
>000000000000P40I0000000000009T000000000000000009@0000`0000100009@0000`000050020
E@0003P0001B2000E@800<08002D0P001`000<e2HAC=@Y0CMD?V4TI4iQ8FANHB_dF@4km5HA@U0000
300000L0080U000030000000080T00009000000004400000000000000440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P000;88001F0P007PT009<200000000AP000=@000380000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q07P8h0000;000008@`=/00000
V0000000000004Q10P000000044000000Q30f`00002I003o240O0eP0001<00000Q30f`L000000000
08d;AJXV8d@0S@]5Ci/LA:7N34EECAM4:gl>AEE=5dB[7a15EDdGA5Ea4DE?Vaa4EG4AAJXV8d@00`<3
0`<30aE07`0@0000100001h0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000@0003P000000000>000000000000P40I0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E@0003P0002a2000E@8001h9002D0P00
1`000<=5HAC3AI0CK4KV4Sa7iQ8<B>HB]DR@4kE8HA@U0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000109001F0P00O0T009<200000000AP000=@000380000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0808h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240Q0eP0001<00000Q30f`L000000000EG4AAJXV8dAELA55Ci/LA?K24TEECAM4
P6<DAEE=5d@011I5EDdGA:YE5dE?Vaa4ZUDGAJXV8d@00`<30`<3PAE08@0@000010000200000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0@0003P000000000>000000000000P40I0000000000009T000000000000000009@0000`000010000
9@0000`000050020E@0003P0000?2@00E@8007d9002D0P001`000;E8HABeB90CGTWV4Ri:iQ;nB^HB
Yd^@4jM;HA@U0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P0005<8001F0P00_`P009<200000000
AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E07@0@0000
100001`0000Q000020000680000<00000@0002@0000T00000000?P00000000000000?P0000000000
0P0005l0000h00000@0003P000000000>000000000000P40I0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E@0003P0001B2000E@800<08002D0P001`000<e2HAC=@Y0C
MD?V4TI4iQ8FANHB_dF@4km5HA@U0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000;88001F0P00
7PT009<200000000AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P1E07`0@0000100001h0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000@0003P000000000>000000000000P40I0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E@0003P0002a2000E@8001h9002D0P00
1`000<=5HAC3AI0CK4KV4Sa7iQ8<B>HB]DR@4kE8HA@U0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000109001F0P00O0T009<200000000AP0004@0000h0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P1E08@0@000010000200000Q000020000680000<00000@0002@0000T0000
0000?P00000000000000?P00000000000P0005l0000h00000@0003P000000000>000000000000P40
I0000000000009T000000000000000009@0000`0000100009@0000`000050020E@0003P0000?2@00
E@8007d9002D0P001`000;E8HABeB90CGTWV4Ri:iQ;nB^HBYd^@4jM;HA@U0000300000L0080U0000
30000000080T00009000000004400000000000000440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000907001D0`00J0P009d300000000AP0002P0000L0000AdA9@`80002@1`00
E0<006P8001^0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@282>00002`000024<3K000009P0000000000038@@80000000110000008@`=/00000
V@00o`Q08`</00008000008@`=/20000000005F_ldB[AUQ4ZjP5AJ]6F4@00@<35D0S010000040000
8P00024000080000HP0000`000010000900002@00000000n000000000000000n0000000000020000
G`0003P000010000>0000000000h0000000000020@38000000000000V@00000000000000000U0000
30000040000U0000300000D0081G0000900008l7001C0`00J0P006l300020000j3`56m521A/U0000
300000L0080U000030000000080T00009000000004400000000000000440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P00090700240`00J0P009d300000000AP000:P0002L0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0908h0000;000008@`=/00000
V000000000000<Q10P000000044000000Q30f`00002I003o240U0b`0000P00000Q30f`8000000000
EJocA00PI4B[Z0E5021TA001000E@2D0400000@0000T00008@0000P0001R000030000040000T0000
9000000003h000000000000003h0000000000080001O0000>0000040000h0000000003P000000000
00810<P000000000002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T0000
S`L00883001X2000WP<00080003X?80LdD:072D0000<00001`00P2D0000<00000000P2@0000T0000
0000@@00000000000000@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
T0L005@3001X2000KP<0000000160000A00003P00015CDH[:T0002@0000H00000020?`0008000020
0020?`00080000205D0S0100000400008P00024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000010000>0000000000h0000000000020@380000
00000000V@00000000000000000U000030000040000U0000300000D0081G0000900008l7001C0`00
J0P006l300020000j3`56m521A/U0000300000L0080U000030000000080T00009000000004400000
000000000440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P00090700240`00
J0P009d300000000AP0004@0000h0000ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P1E09@0@0000100002@0000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0002?1`00PP<006P8002N0`00
0P000>PlP1cA@X0L9@0000`0000700209@0000`000000020900002@0000000110000000000000011
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001l0P00E0<005@3002M0`00
000004H0000X0000700004M4BD<20000O08005@3001D0`00KP<0000000160000Z00009`00015CDH[
:T0002@0000H00000020?`00080000200020?`0008000020240V0SP0000/00000Q30f`00002H0000
00000000b44200000000@@0000024<3K000009T00?l8@2L3;000020000024<3K0P000000002[GR94
ZdIHA:^RDDB[AUQ40041PAE09`0@0000100002H0000Q000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40
T0400000000009T000000000000000009@0000`0000100009@0000`000050020E`0002@0001k0P00
D`<005@3001_0`000P00090X2SIQ=0Xf9@0000`0000700209@0000`000000020900002@000000811
00000000000008110000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80001l0P00
Q0<005@3002M0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o
0000P0000808@2P2>00002`000024<3K000009P0000000000038@@80000000110000008@`=/00000
V@00o`Q0:@</00008000008@`=/2000000000:]N8T@086A4Zj9AA00PI4@00@615D0Y010000040000
:000024000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
G`0003P000010000>0000000000h0000000000020@2@0@0000000000V@00000000000000000U0000
30000040000U0000300000D0081G0000900007/200220`00E0<009h300020000T2P0>F4d03TU0000
300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000
30000040000R000030000?oooom60000700001000015CDH[140000`000000000AP0001@000080000
AdA9@`<000160000:00001`00017A4U30P0007`2001D0`00E0<006h300000000AP0004@0000h0000
ADe6:bY0000T000060000000P3l000200000P000P3l000200000P1E09`0@0000100002H0000Q0000
20000680000<00000@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000
0@0003P000000000>000000000000P40T0400000000009T000000000000000009@0000`000010000
9@0000`000050020E`0002@0001k0P00D`<005@3001_0`000P00090X2SIQ=0Xf9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80001l0P00Q0<005@3002M0`00000004H000140000>00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P000080E@2T0400000@0000X00008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P0000000000081090100000000002I000000000000000002D0000<00000@0002D0000<0000
1@00P5L0000T0000N`800883001D0`00WP<00080002@:00iHC@0>BD0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000F`@008H2000V1@00T`80000000160000Z00009`00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240Z0SP0000/00000Q30f`00002H000000000000B4420000
0000@@0000024<3K000009T00?l8@2/3;000020000024<3K0P0000000000?8a4ZbHSA03NXdB[9R=4
004001E0:`0@0000100002X0000Q000020000680000<00000@0002@0000T00000020?@0000000000
0020?@00000000000P0005l0000h00000@0003P000000000>000000000000P40b0000000000009T0
00000000000000009@0000`0000100009@0000`000050020E`0002@0001J1000Q08002H5002D0P00
0P0001I6`RSWDL8X9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000d1P00QP800746002C0P00
000004H0002X0000W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@2`2
>00002`000024<3K000009P0000000000018@@80000000110000008@`=/00000V@00o`Q0;@</0000
8000008@`=/20000000005EIadB[9R=404K=A:/V8d@00@005D0]010000040000;000024000080000
HP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000020@38000000000000V@00000000000000000U000030000040000U0000
300000D0081G0000900003<600240P00L@H009@200020000YF?2:9]V`RPU0000300000L0080U0000
30000000080T000090000000P440000000000000P440000000000080000X000030000040000R0000
30000?oooom60000700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000
:00001`00017A4U30P000=X000260P00C@<009<200000000AP000:P0002L0000ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q0;P8h0000;000008@`=/00000V0000000000004Q1
0P000000044000000Q30f`00002I003o240_0b`0000P00000Q30f`8000000000ZgYP@j/V8dB[XU54
ZbHSA0010@4E@2l0400000@0000^00008@0000P0001R000030000040000T000090000000P3d00000
00000000P3d0000000000080001O0000>0000040000h0000000003P00000000000810<P000000000
002I000000000000000002D0000<00000@0002D0000<00001@00P5L0000T0000f00008@2001>0`00
U080008000003/8XHCC2:2D0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000
0020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000K`T008H2001Y2P00
T`80000000160000Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240`0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@343
;000020000024<3K0P000000002[EAM5ZbHSA00M9TF[9R=4004001E0<@0@000010000300000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0@0003P000000000>000000000000P40I0000000000009T000000000000000009@0000`000010000
9@0000`000050020E`0002@0001]2@00Q08006T:002D0P000P000:M;HA@;Df4D9@0000`000070020
9@0000`000000020900002@00000001100000000000000110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002R1000A`@00=l400241000000004H0003D0000b00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@383T00008@000024<3K3@00000000003IQ4
0;:9A2YZUT@0/XU4ZaJEA7l5RdB[5YE4EJR<A:/FUD@/Bhi4:VZFA:^NSd@03IQ4Zij?A=N_VDB[WXm4
EP>KA2a;STAF0i]4EJR<A5H3VdAo1H]4ejnIA02bRD@03IQ40;:9A0030`<30`<30`<30h?ooolD@3:0
400000@0002I003o8@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080000U000030000080000C000030000040000k0000200005D0001@000000000000003ooooo
ooooo`d0003oBm54;T_AA8A:NdF4BTe6Q4XNAbi;b4OoBlQ7d4c8AgY=7TMjCDe6NTekAM1<dDCoBm54
?00000P0000n000060000:P4001=1000f0@007d4000C000030000040000U000030000000080T0000
90000000P440000000000000P44000000000008000160000I00005P00015CDH[240c0T@0000h0000
0Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K000009T00?lE@380
400000@0000c0000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000000@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000D0000:4400151000g`@008@4000=0000od_AA2i;dDB4BW]5Q4Y=AXA:7TL^BlQ7
od_8Am1<b4MjCAi7NTe=AWY=NdG@C=54od_AA2D0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
gPL006h2000J2000Z`80000000160000e0000<P00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240d0i00002400000Q30f`d000000000EH3oA5DY7DAogOe4EBTMA02:o4ABd1m4
08[lA00F8d@0R_a4[E/VA7oMoDBZ0RU4EH3oA:X2:DBFT@15ZP8YA5Dk0DF]FbI4EC/1A@0F8dAE>`55
D]0OA9JA04EE:Ae4EH3oA5DY7D@00`<30`<30`<30`>30000540dP10000040000V@00ob4000080000
HP0000`000010000900002@00000000n000000000000000n00000000000200009@0000`000020000
4`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000gCnR4g@oXQ<O?oLC
7cmO51lob1Ad?adEgClM5DE07AFJ@<PDVT1O59Y0ma=5@:8CgCnR4c`000080000?P0001P0003S1`00
M08001@8002T0P004`0000`0000100009@0000`000000020900002@0000000110000000000000011
0000000000020000AP0006@0001H0000ADe6:`Q0=@940000>000008@`=/00000gP000000000004Q1
0P000080000200000000@@80000000000Q30f`00002I003o5D0d010000040000=@0002@0000T0000
0000?P00000000000000?P00000000000P0005l0000h00000@0003P000000000>000000000000040
I0000000000009T000000000000000009@0000`0000100009@0000`000050020E@000500003L1`00
K@8001/8002[0P003@000=doXQ=d?j8C7cog4aloGa@O?lPDM3lM5Mdo7AE5@1dEVT3859Y0GaBJ@?LC
AD2R4mdoXQ<U0000300000L0080U000030000000080T000090000000044000000000000004400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000<X2001^0P001P<00:/200000000
AP000=@000380000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0=P>@0000
Q000008@`=/=000000000:/0>TB[BQe4oKXfA:]:7D@053A4Z?4OA00D=4AF=b=401@dA0=m9TCm^SI4
02@YA:/0>T@092U4F4HmA00T:DAEkCm40gdVA5G]?dAF=b=4ENdoA:Sa7dAHASe4ZdXMA:/0>TB[BQe4
00<30`<30`<30`<3P`0001A0=X0@0000100009T00?lQ000020000680000<00000@0002@0000T0000
0020?@00000000000020?@00000000000P0002D0000<00000P0001<0000<00000@0003/000080000
E@0005000000000000000?oooooooooo3@0007T^BbNW;D/WoBce9od/aRSm;9PYYbe1:WT^@BY:;d4Z
m2nH:O@_aRSd;oDWBRm;9gT^BbLl0000200003h0000H0000c`8007@200000`00Y@8001<0000<0000
0@0002D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0001T0000
F00004E=AR/8@3L2A00003P000024<3K00000=h0000000000018@@80000200000P00000004420000
0000008@`=/00000V@00oaE0=P0@0000100003L0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000010<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5D0001@0000b08006d200070`00[08000d0001i;T/W
Ybe;9od/mBOm;<HXoBbH:JL]@BYi;T4ZBRm1:_@_V2Wd;lHXm2oe9dX_BbMi;T/W9@0000`000070020
9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80002R1000KP800=l4002[0P00000004H0003D0000b00004E=AR/Z@000
900001P00000080o0000P0000800080o0000P0000808@3P3T00008@000024<3K3@00000000003IQ4
ZdXMA2YZUTB[BQe4ZaJEA:Sa7dB[5YE4ESLSA:/FUD@3OBI4:VZFA00T:D@03IQ402@YA=N_VD@092U4
EP>KA0=m9TAF0i]4ESLSA5H3VdBXlAm4ejnIA:]:7D@03IQ4ZdXMA0030`<30`<30`<30h<0000D@3R0
400000@0002I003o8@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080000U000030000080000C000030000040000k0000200005D0001@000000000000003ooooo
ooooo`d0003oBd/W;T];9hA:mBN4B/HXQ4ZH:Bi;@B[oBd4Zd4a1:WY=V2UjCLHXNTge9m1<BbOoBd/W
?00000P0000n000060000:P4001d0P00f0@00:D2000C000030000040000U000030000000080T0000
90000000P440000000000000P44000000000008000160000I00005P00015CDH[240i0T@0000h0000
0Q30f`00003N000000000000B44200000P000080000000110P00000000024<3K000009T00?lE@3P0
400000@0000i0000900002@00000080m000000000000080m0000000000020000G`0003P000010000
>0000000000h0000000000000@38000000000000V@00000000000000000U000030000040000U0000
300000D0081E0000D0000:44001]0P00g`@00:`2000=0000od];9bi;BbN4B_DWQ4[6:8A:V2T^Bd4Z
od]1:]1<@BYjCIPYNTg6:7Y=mBO@C4/Wod];9bD0000<00001`00P2D0000<00000000P2@0000T0000
0020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000
400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000
m@L008X300022000K0@0000000160000Z00009`00015CDH[:T0002@0000H00000020?`0008000020
0020?`0008000020240j0SP0000/00000Q30f`00002H000000000000B44200000000@@0000024<3K
000009T00?l8@3/3;000020000024<3K0P0000000000N?m4021TA01hod@0X8a40041PAE0>`0@0000
100003X0000Q000020000680000<00000@0002@0000T00000000?P00000000000000?P0000000000
0P0005l0000h00000@0003P000000000>000000000000P40I0000000000009T00000000000000000
9@0000`0000100009@0000`000050020E`0002@0003d1`00R0<000<8001/10000P000=XoP1cJ?b@S
9@0000`0000700209@0000`000000020900002@00000001100000000000000110000000000020000
:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000
200004M4BD<30000AP0002P0000L0000AdA9@`80002j1000RP<00<L4001/1000000004H0002X0000
W00004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@3`2>00002`000024<3K
000009P0000000000018@@80000000110000008@`=/00000V@00o`Q0?@</00008000008@`=/20000
000005DEV4@086A4EAFHA02PS4@00@615D0m010000040000?000024000080000HP0000`000010000
900002@00000080m000000000000080m0000000000020000G`0003P000010000>0000000000h0000
000000020@38000000000000V@00000000000000000U000030000040000U0000300000D0081G0000
90000;P400280`00b0@006`4000200000d`0>@=<B4HU0000300000L0080U000030000000080T0000
90000000P440000000000000P440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000>82002:0`00k`8006`400000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0?P8h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240o0b`0000P00000Q30f`8000000000EA4jA00PI4AE4CY40:2<A001000E@3l0
400000@0000n00008@0000P0001R000030000040000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000000810<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000h08008P3003`0P00K0@00080001m;P0i
OBi8ARD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000m@L008H200022000J0<0000000160000
Z00009`00015CDH[:T0002@0000H00000020?`00080000200020?`000800002024000SP0000/0000
0Q30f`00002H000000000000B44200000000@@0000024<3K000009T00?l8@043;000020000024<3K
0P0000000000N?m4ZbHSA01hodB[AUQ40041PAE00@0@000010000000000Q000020000680000<0000
0@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h00000@0003P000000000
>000000000000P40I0000000000009T000000000000000009@0000`0000100009@0000`000050020
E`0002@0003d1`00Q08000<8001X0`000P000=XoHACJ?`DK9@0000`0000700209@0000`000000020
900002@00000001100000000000000110000000000020000:00000`0000100008P0000`0003ooooo
AP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000
AdA9@`80002j1000QP800<L4001X0`00000004H0002X0000W00004E=AR/Z@000900001P00000080o
0000P0000800080o0000P0000808@082>00002`000024<3K000009P0000000000018@@8000000011
0000008@`=/00000V@00o`Q00`</00008000008@`=/20000000005DEV4B[9R=4EAFHA:]6F4@00@00
5D030100000400000P00024000080000HP0000`000010000900002@00000080m000000000000080m
0000000000020000G`0003P000010000>0000000000h0000000000020@38000000000000V@000000
00000000000U000030000040000U0000300000D0081G000090000;P400240P00b0@006P300020000
0dc2:0=<2SHU0000300000L0080U000030000000080T000090000000P440000000000000P4400000
00000080000X000030000040000R000030000?oooom60000700001000015CDH[140000`000000000
AP0001@000080000AdA9@`<000160000:00001`00017A4U30P000>8200260P00k`8006P300000000
AP000:P0002L0000ADe6:bY0000T000060000000P3l000200000P000P3l000200000P0Q0108h0000
;000008@`=/00000V0000000000004Q10P000000044000000Q30f`00002I003o24050b`0000P0000
0Q30f`8000000000EA4jA:/V8dAE4CY4ZdIHA0010H4E@0D0400000@0000400008@0000P0001R0000
30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000
000003P00000000000810<P000000000002I000000000000000002D0000<00000@0002D0000<0000
1@00P5L0000T0000h08008@2003`0P00J0<00080001m;/8XOBh:=RD0000<00001`00P2D0000<0000
0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000W`T003<2000h2P00J080000000160000504000P10015CDH[:T0002@0000H0000
0020?`00080000200020?`000800002024060Z@0002H00000Q30f`00002L4000000005EE1D7o0000
0P00000004400000I000008@`=/000000@000080000009100000000000000000000P@@00P3l00000
0000000000000000:000008@`=/300000200000084000:300000000000000230002P`001P@024<3K
0000002I0?l8@0L3;000020000024<3K0P000000001E>aY5EFDCA5DN8dEEIA=400430aE01`0@0000
100000H0000X000030000080000Q000020000680000<00000@0002@0000T00000000?P0000000000
0000?P00000000000P0005l0000h00000P0003P000000000>000000000004P40200000000000V@00
00000000000000009@0000`0000200009`0001P0000100000000002I000000009@0000`000010000
4`0000`000020000F`0004`0002Q2@00=P8003<:001T0P000P0000T000050000100001Y=B19PD4PB
H52:4QY=RQ8JCDPB?U324HaAJA8nD10C?U324A<0000<00000@0002D0000<00000000P2D0000<0000
1`00P2@0000T00000000@@00000000000000@@00000000000P0002P0000<00000P000280000<0000
ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U30`0004H0000X0000
700004M4BD<20000G0T009l1002Z2P00=`80000000160000500000P00017A4U30`000580001`0@00
0P0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000H000000000000008bj4`3X^Q<03`4000P2002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00000<`P4004`0V6EC<?aTNP430000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1J7Ej0Abh4`1RO0X`>Pd:l12n4`0>008`0?SoofAf00P00000
9@0000`0000200005P0000`0000H00004P0000`000010000600000`00000V@02E00005@0002B2@00
]P400:d9000W0P000@0005EE1d5f@0M1TPT0010200010000C00000000000000000000?oooooooooo
D00006T0000L00005P0000`0000000009@0000`0000>0020:00000`000020000DP00070100020000
_Oooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1P00000000000000S;XC0>Rj4`0?0@0020800;0[NP400640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095l<0@L0>Bg4`11095lB0LE05d0TG`j3@[a
>0@L03P470000000?65j0@00002HIE<`P;PC07a`BC000000000C00000S3;2`47;@0C000000130000
T@D2<<Rh4`0ed`4`4;hC0000003LHGX1>Pd:l200000>008`0?SoofAf00P00000>PP2<73X5`34]a<0
GU[cMlBg4`0001D0k2TP02D0001`j1L0000:032:003H]`40100002Rg4`363R7fI7H02000000U0000
30000080000F0000300001P0000B000030000040000H00003000002I009D0000E0000:h9003]0@00
cPT003P200010000EED7@GI01d6^2@00:@800040001<00000000000000000000oooooooooom@0000
KP000240000F000030000000000U0000300000h0080X000030000080001B0000L0400080002moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000060000
00000000002<^Q<0j;XC00l100080P00/2]j0@004`11095lB0LE05d0TG`j3@[a>0@L03P470000000
?65j0@00002HIE<`P;PC07a`BC0H]a<000000;P0TG``11`0i;LC0440TGa81aD0G@2AO3X=2_8h11`0
>0@L0000003LHGX1>Pd:l200000>008`0?SoofAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0
k2TP03GC0C0@_Q<0000007aRNP7H]`40800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=g
a;LC00005@04;2009@00073X5`0000X0B8`00=Rg0@040000:;LC0<H>8OITMP08000002D0000<0000
0P0001H0000<000060000180000<00000@0001P0000<000009T00U@0001H0000c`T00>d1000F2P00
>0800040001EE@M1MT07@Ll9000Y0P000P0004`00000000000000000003ooooooooooe00000[0340
9P000280000F000030000000000U0000300000h0080X000030000080001B0000L0400080002Loooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000060000
00000000002<^Q<0j;XC00l100080P00/2]j0@004`11095lB0LE05d0TG`j3@[b>0@L03P470000000
g65j0CX=2_0P00003P02<03hoolH]a<000000;P0TG``11`0i;LC0440TGa81aD0G@2AO3X=2_<h11`0
>0@L0000001lHWX1f;L10200000X]a<0aPhQmVAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0
12`P03GC0C0@_Q<0000001aSNP7H]`40800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=g
a;LC00005@0L;R009@00073X5`0000X0H8h00=Rg0@040000:;LC0<H>8OITMP08000002D0000<0000
0P0001H0000<000060000180000<00000@0001P0000<000009T00U@0001D00005`X00;H1000g2P00
9`800040001EE@M1MT07@AL:000@0P000@0004`00000000000000000003ooooooooooe00000X0000
8@0001H0000<0000000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000H000000000
000008bj4`3X^Q<03`4000P2002`:gX1000C0440TGa81aD0G@2AO3X=2_<h11`0>0@L0000001lHWX1
f;L10200000X]a<0aPhQmQRg4`000000^02AO304703T]a<0@@2AO4P75@1M095l>Pd:m3P4700h11`0
000001aSNP7H]`40800002Rg4`363R7fI7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@0L;R00
=M<1<12n4`000000_6=j0MRg0@0P0000:;LC0<H>8OITMP08000003X80S1`j1L0a;LC05iJlgO4]a<0
000E03P`800U0000L>PG00002P1lT000f;L100@0000X]a<0aPhQmVAf00P000009@0000`000020000
5P0000`0000H00004P0000`000010000600000`00000V@02E00005@0000h2P00]P4005D:000W0P00
0@0005EE1d5f@0M1>0X0010200010000C00000000000000000000?ooooooooooD00007@0000L0000
5P0000`0000000009@0000`0000>0020:00000`000020000DP00070100020000W?ooo`0000000000
000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001P00000000000000
S;XC0>Rj4`0?0@0020800;0[NP4001<0@@2AO4P75@1M095l>Pd:m3P4700h11`0000001aSNP7H]`40
800002Rg4`363R7f6;LC0000002h095l<0@L0>Bg4`11095lB0LE05d0TG`j3@[e>0@L03P470000000
_6=j0MRg0@0P0000:;LC0<H>8OITMP08000000000S1`j1L0a;LC05iJlgO4]a<0000E03P`800ed`4`
4;hC0000001LI7X1f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0
D38P02D0001`j1L0000:09BB003H]`40100002Rg4`363R7fI7H02000000U000030000080000F0000
300001P0000B000030000040000H00003000002I009D0000E00005@:002f0@00M0X002L200010000
EED7@GI01d5D2P0040800040001<00000000000000000000oooooooooom@0000:@000240000F0000
30000000000U0000300000h0080X00003000008000160000:00001`00017A4U30P0000L300340P00
N`<0058400000000AP000401000d0@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q020:T0000V000008@`=/00000W1000000001EE@E1o`00008000000011000006@000024<3K
00000080000200000020?`8000020000000000008440080o0000000000000000000002P000024<3K
0`00000P00000210002``0000000082o000P`000/<000@400Q30f`0000000?oo24090eP0001<0000
0Q30f`L000000000/CQ9A5E1<T@VV5E4H6/jA01lGDAabd]407aMA9OPGT@0O5e4DlIcA7/;E4@J=8=4
hnY5A5FcQT@00`<30`<301E02@0@0000100000P0000X000030000040000Q000020000680000<0000
0@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000004P4040000000003o000000000000000000009@0000`0000100009`0001P000020000
00000?l0000000009@0000`0000200004`0000`000020000>`0000P0000K0000400006lb001C;000
F@0002010000000000000?oooooooooo@@00000c_2b><cD]5CBk;I<dCBh9=NT^MCF@;mTe@C0d=_X`
QSJj<LdfQ38:=e@c?CLZ=6Dg1CF3=nDeU3O8=YXg/3NC=j`hOSNT>E/gV3X]=h@kl3I/?:PfBSeE=R0n
mCG/?X/e[ClF=FE0Uc@?@@ld[45m<ca2hS:m@Slb;D<8<Ta3b37H@_@a`4:=<UI283?M@JXcED4/=<10
YC@L@1HeKCml=K<nf3G_?BTf8Ce_=TTlZSI[>mLfQC[i=YTi3SNY>1Dg/cL?=m<foSKf=N8f73Fl=TTd
RcIi<e0f/C8;=^ha_CDe<FDePS06=MT_WS@j;bhdY2jf<aX^=c>J;K4b:2dP<[l/?@0000P0000K0000
400009Hd001E@`00F@0002@00000000000000?oooooooooo0P00070aE4<K<jQ0F00003@000000000
00000?oooooooooo1P0002hcRD1G<gm0Mc>C@9HcYT2O<lm0S3?_@5T0000X000000000000003ooooo
ooooo`<0000Q<SE3j37?@YLdd49H0000=000000000000000ooooooooool60000^cC@@]TdkT;I=1=3
fC@g@k/dED>F=5E3?@0000P0000l0000200003l0000H00005@<00<<2001l0`00=`@001<0000<0000
0@0002D0000<00000000P2D0000<00001`00P2@0000T00000020@@00000000000020@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000P@H002P300261`00`0<0000000160000
500000P00017A4U30`000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0a`0007h1002`:gX1
000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000
@`00002_8`/004`0V6EC<5aTNP410000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`
P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1@7Ej0Abh4`1RO0X`
A@l:Sa2n4`0>008`0?SoofAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0002P1P00?`<00=46002`0`000@0005EE1d5f@0M1X0H009T300010000
C00000000000000000000?ooooooooooD00007D0000b00005P0000`0000000009@0000`0000>0020
:00000`000010000DP00070100010000_Oooo`0000000000000009010001000004004U@0J@1]06D0
L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`370000OP400;0[NP400640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`0000006;LC0000002h095l
B2@O0>Bg4`11095lB0LE05d0TGa53`Z@D2@O050T7`000000?65j0@00002HIE<`P;PC07a`BC000000
000C00000S3;2`47;@0C000000130000T@D2<<Rh4`0ed`4`4;hC0000003LHGX1A@l:Sb00000>008`
0?SoofAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0V3/P02D0001`j1L0000:0=bK003H]`40
100002Rg4`363R7fI7H02000000U000030000040000F0000300001P0000B000030000040000H0000
30000?l0009D0000E0000=86001f0`00l`H00<4300010000EED7@GI01d7B1P00/P<00040001<0000
0000000000000000oooooooooom@0000KP000280000F000030000000000U0000300000h0080X0000
30000040001B0000L0400040002Loooo0000000000000000T04000000000@00BE01Y06d0I@1c0200
CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC0<L0001n0@00/2]j0@004`11095l
B0LE05d0TGa53`Z@D2@O050T7`000000?65j0@00002HIE<`P;PC07a`BC0H]a<000000;P0TGa891l0
i;LC0440TGa81aD0G@2AO4D?2Y5@91l0D2@O0000003LHGX1A@l:Sb00000>008`0?SoofAf00P00000
0002<73X5`34]a<0GU[cMlBg4`0001D0V3/P03GC0C0@_Q<0000007aRNP7H]`40800002Rg4`363R7f
I7H02000000j208`L>PG0<Bg4`1NF_=ga;LC00005@2`?B009@00073X5`0000X0m9d00=Rg0@040000
:;LC0<H>8OITMP08000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000
o`000U@0001D0000m0H003l3000D1`00/0<00040001EE@M1MT07@O@6002I0`000@0004`000000000
00000000003ooooooooooe00000X00008@0001H0000<0000000002D0000<00003P00P2P0000<0000
0@000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0a`0007h1002`:gX1000C0440TGa81aD0
G@2AO4D?2Y5@91l0D2@O0000003LHGX1A@l:Sb00000>008`0?SooaRg4`000000^02AO4PT7`3T]a<0
@@2AO4P75@1M095lA@l:TU0T7`1@91l0000007aRNP7H]`40800002Rg4`363R7fI7H020000000008`
L>PG0<Bg4`1NF_=ga;LC00005@2`?B00=M<1<12n4`00000076=j0MRg0@0P0000:;LC0<H>8OITMP08
000003X80S1`j1L0a;LC05iJlgO4]a<0000E0<Po800U0000L>PG00002P0<X000f;L100@0000X]a<0
aPhQmVAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002
E00005@0000E1`00?`<00387002`0`000@0005EE1d5f@0M15@L009T300010000C000000000000000
00000?ooooooooooD00007@0000L00005P0000`0000000009@0000`0000>0020:00000`000010000
DP00070100010000W?ooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`370000OP400;0[NP4001<0@@2AO4P75@1M095l
A@l:TU0T7`1@91l0000007aRNP7H]`40800002Rg4`363R7f6;LC0000002h095lB2@O0>Bg4`11095l
B0LE05d0TGa53`ZCD2@O050T7`00000076=j0MRg0@0P0000:;LC0<H>8OITMP08000000000S1`j1L0
a;LC05iJlgO4]a<0000E0<Po800ed`4`4;hC0000002lHgX1f;L10200000X]a<0aPhQmVAf00P00000
>PP2<73X5`34]a<0GU[cMlBg4`0001D0h44P02D0001`j1L0000:02BR003H]`40100002Rg4`363R7f
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000347000o0`00D@L00;0300010000EED7@GI01d4a1`00V@<00040001<00000000000000000000
oooooooooom@0000:@000240000F000030000000000U0000300000h0080X00003000004000160000
:00001`00017A4U30P0006T7002g0P00g@L004D400000000AP000401000d0@00ADe6:bY0000T0000
60000000P3l000200000P000P3l000200000P0Q02P:T0000V000008@`=/00000W1000000001EE@E1
o`00008000000011000006@000024<3K00000080000200000020?`8000020000000000008440080o
0000000000000000000002P000024<3K0`00000P00000210002``0000000082o000P`000/<000@40
0Q30f`0000000?oo240;0eP0001<00000Q30f`L000000000D^CgA000;dBH]?542bXgA:_2kD@LRTQ4
Zl;]A4:OFdB[`^e4oXA`A>ejlTA`Th54>H_iA:/BQD@00`<30`<301E02`0@0000100000X0000Q0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0@0003P000000000>000000000004P4020000000003o000000000000000000009@0000`000010000
9@0000`0000200004`0000`000020000>`0000P0000K0000400000Xn003g5@00F@00020100000000
00000?oooooooooo@@000<4m;1In?FDF?SfU5P<mjQK;?3@GUcb55fLlfALk?38H53b?6?8klASD>eDI
^c^l6JPk9QZJ>i<JTS/16hlkLA^B>n`KWC]U7:dkfQc5>ddMhS^m7@Dl:1h]?8lNFccb7XhlCao7?:HO
0cgh7d@m@b29?HHPdcg381lnn20f?P@Q5Chn8OXm;R6X?OHPFcff818mKR3>?1lPSSc:7e@lKalO?0hO
kc^X7/Dk?AjQ>ldMPc]K7F/ki1aJ>fXLD3_^6d`kL1]?>o`JF3^:6VLk6aYk>jdIU3]26K<kfQSG>gHH
oc/E62dl^1MO?60GUC`<5m0l_QH??GDFDcdc5YXmmQGR?L4E?@0000P0000K0000400008dm003[7`00
F@0002@00000000000000?oooooooooo0P00064n@R7>?44QF00003@00000000000000?oooooooooo
1P000;`l@B6]?38Q[C`P8Jdl3B6l??hPcScn85T0000X000000000000003oooooooooo`<0000U?P0Q
2Chb8EDm3R1H0000=000000000000000ooooooooool60000Bcgo7e0mjQmP?N0OKcgG7h@mg1n=?N/O
?@0000P0000l0000200003l0000H0000J0L00;H2003>1`00:P@001<0000<00000@0002D0000<0000
0000P2D0000<00001`00P2@0000T00000000@@00000000000000@@00000000000P0002P0000<0000
0@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000500000P00017A4U3
0`0004H0000X0000700004M4BD<20000@P8009l3003Y0P00=`@0000000160000500000P00017A4U3
0`000580001`0@000@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0
M`0P0580K`1]0640KP00000000000000000008bj4`3X^Q<0J@000<X0002`:gX1000C0>Bf4`3@H7X1
3P02<;goool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`00002d8`/004`0
V6EC<=aQNP410000U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000
000C03X80S3;2`47;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`>Pd:1Q2n4`0>008`
0?SoofAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000600000`000000002
E00005@000270P00]P<00</2000W10000@0005EE1d5f@0M1Q`80010400010000C000000000000000
00000?ooooooooooD00004<0001300005P0000`0000000009@0000`0000>0020:00000`000010000
AP0002P0000L0000AdA9@`80000C2000Y`<00;X8000o1000000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000000000000000000S;XC0>Rj4`1Y0000b@000;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000<<f2P00C02HIE<`
g65j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S153`ZK4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000000009D0000
E0000388002n0`00MPP002l400010000EED7@GI01d4b200060@00040001<00000000000000000000
oooooooooom@0000@`0004<0000F000030000000000U0000300000h0080X00003000004000160000
:00001`00017A4U30P0008`3002g0@00B`@004l200000000AP0001@000080000AdA9@`<0001B0000
L0400040002Loooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00000000000000000002<^Q<0j;XC0840003g0000/2]j0@004`3T]Q<0d61j0@h00S2moooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P
>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0000004<00000ccH:001<09QUDc3LHGX1
000009Bg4`2_4P8`;@0C03GC0C0@_Q<0000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`
b`/11bd04`000000@`0009450S38^1<016mj0J1dNP4L^1<0HW`:<3X=2Pd@_Q<03P02<03hoomTMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000
c`<00<h100071000?`800040001EE@M1MT07@M03000X0P000@0004`00000000000000000003ooooo
oooooe00001<0000>00001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000
700004M4BD<20000I@D00;L1000T1P00C`80000000160000500000P00017A4U30`000580001`0@00
0@0009coool0000000000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP00000000000000000008bj4`3X^Q<0P@000?L0002`:gX1000C0>Bf4`3@H7X13P02<;goool00000
00000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP
[22/828Q8R5<^A<0I;LC01DD0S0]00003a<2<2d04`000000@`000036=PX004`0V6EC<=aQNP400000
U;LC0:lB0S0]01<0=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47
;@0C000000130000T@D2<<Rh4`04KgX1X7Aj0Abh4`1RO0X`A@l:XQ2n4`0>008`0?SoofAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`000000002E00005@0002W1@00
cP400=l5000o0P000@0005EE1d5f@0M1Z0D002P200010000C00000000000000000000?oooooooooo
D00004`0000h00005P0000`0000000009@0000`0000>0020:00000`000010000AP0002P0000L0000
AdA9@`80002P2000]`4005l9001?0P00000004H0000D0000200004M4BD<30000DP00070100010000
W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
0000000000000000S;XC0>Rj4`210000m`000;0[NP4001<0i;HC0=1PNP4>008`_Oooo`0000000000
000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000001300000=<f2P00C02HIE<`g65j0@00002D]a<0
[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0
000004<0002A1@8`b;PC00A_NP6PM7X17;PC069l2S0j3@XD4;hC00h00S00n?ooI7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000000009D0000E0000>88003>0@00
6PT003l200010000EED7@GI01d7S2000:0800040001<00000000000000000000oooooooooom@0000
C00003P0000F000030000000000U0000300000h0080X00003000004000160000:00001`00017A4U3
0P0003P700260P00H@P009<200000000AP000:P0002L0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q0308h0000;000008@`=/00000V0000000000004Q10P00000004400000
0Q30f`00002I003o240=0b`0000P00000Q30f`80000000000=KWA:/V8dAEX0E5ZbHSA0010`<E@0d0
400000@0000<00008@0000P0001R000030000040000T00009000000003h000000000000003h00000
00000080001O0000>0000040000h0000000003P000000000008106@000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5L0000T0000=`L008@2001Q2000U0800080003b>F4D
cD9Q52D0000<00001`00P2D0000<00000000P2@0000T00000000@@00000000000000@@0000000000
0P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@0003000000000160000
500000P00017A4U30`0004H0000X0000700004M4BD<20000:`X00>D2002G2P003@@0000000160000
F00004`00015CDH[:T0002@0000H00000020?`00080000200020?`00080000202T00P2@0000H0000
ooooo`4000005R=5EMTjA62E_D:ZZXe3:00000`0000200008@0000P0001R000030000040000T0000
9000000003h000000000000003h0000000000080000W00006000008000000000oooo0000000U0000
30000080000U0000300000P0081F0000<000030:003[0P00T0X000L400050000Qe5H5hMA<R1nE38P
OUAH5hMAF1LU0000300000L0080U000030000000080T000090000000044000000000000004400000
0000008000160000W00009000015CDH[240>0T00000d00000Q30f`00003F000000000000B4420000
0P000000044200000000008@`=/00000V@00o`Q03`<l0000<000008@`=/400000000000F8dEEfCY4
01HSAEGGP4B[0RU5EMN0A:/2:DEEfCY40041PAE03`0@0000100000h0000j0000300000P0000T0000
9000000003h000000000000003h0000000000080001O0000>0000040000h0000000003P000000000
020106@000000000002I000000000000000002D0000<00000@0002D0000<00001@00P5H0000/0000
mPT00;42003:2P00@@@000@00027DEPGQe4b87iD<R1nE5PG9@0000`0000700209@0000`000000020
900002@00000001100000000000000110000000000020000:00000`000010000>P0000`0000:0000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80001Q2P00:0<000P;00300`00000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00000@00000000000000S;XC0>Rj4`2700000`400;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C00000013000004<f2P00C02HIE<`
O69j0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP78M7X17;PC069l2S0j3@XM4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000000009D0000
E0000:/:000o0`00j0X00;0300010000EED7@GI01d6/2P00V@<00040001<00000000000000000000
oooooooooom@0000DP0003d0000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002moooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00001000000000000002<^Q<0j;XC08L000030@00/2]j0@00H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<000000;P0TGa891l0i;LC0440TGa81aD0
G@2AO3X=2Qi@91l0D2@O0000000lHGX1000009QUDc20^1<0O719<000000001<00002<</;0@L]01<0
000004<0002A1@8`b;PC03GC0C0@_Q<000000=aQNP4j3@XM800000h00S00n?ooI7H02000000j208`
L>PG0<Bg4`1NF_=ga;LC00005@3PFb009@00073X5`0000X09;`00=Rg0@040000:;LC0<H>8OITMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<000000000U@0001D0000
j@X007H300092`00`@<00040001EE@M1MT07@NT:002b0`000@0004`00000000000000000003ooooo
oooooe00001[00007P0001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000
700004M4BD<20000H`000?`2001M0@00mP<0000000160000e0000<P00015CDH[:T0002@0000H0000
0020?`00080000200020?`0008000020240@0i00002400000Q30f`d000000000EOEO@`2D@4BKZ1i3
09A0A5Eedd9lcde4EGGC@Z/RGTAEMM=2fGE^A9^X7T=E/G]4EOEO@eFaNd@8XI13EK5kA00HZd?IMFi4
01R[@j/RGT@06:]3O<m=A0RQT4<0U414EOEO@`2D@4@00`<30`<30`<30`>30000540@P10000040000
ooooob4000080000HP0000`000010000900002@00000080m000000000000080m0000000000020000
9@0000`0000200004`0000`000010000>`0000P0001E0000D000000000000000ooooooooool=0000
n0dM<><97C2D1V`cU0J1=i@6US_S2NDnn0gU?PdBiCiK5IHkFaF1=e/EK3<=4Qd`n0dM<3`000080000
?P0001P0001Y00000@<005H1003_0`004`0000`0000100009@0000`000000020900002@000000811
00000000000008110000000000020000AP0006@0001H0000ADe6:`Q04@940000>000008@`=/00000
gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o5D0@010000040000
4@0002@0000T00000020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000
>000000000000040b0000000000009T000000000000000009@0000`0000100009@0000`000050020
E@000500001R0000nP8005d1003f0`003@000?P=7C3S2Ad`U0I/<i@6PCND1YHkh`WU?_P=iCh=4^Dn
FaFF>e/EPCMK5F`c3A8M<?P=7C0U0000300000L0080U000030000000080T000090000000P4400000
00000000P440000000000080000X000030000040000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<0001B0000L0400040001Zoooo0000000000000000
T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000;0[NP410000
00000000000000000000000000070000179j0J1dNP6XF>H`/2]j0NQWNP4D0000D;PC00000004KgX1
0@000040001@^1<0AhW/<0000004KgX100000:1dNP7X;7X1000000A_NP5P0000G;PC06aHiS010000
000000800020LGX1h;PC0=AcNP40000000000?oooom8T>``X8ij0@A_NP7<^A<00@0003GC0C0@_Q<0
000003aQNP4917X12@Aj0M5l3C1E00002@Aj0@004`000000000002bi4`000000000000A_NP4/^A<0
GXg/<0A_NP4000005;TC02Bi4`000000T2mj0NQWNP5TMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<0000002I0U@0001D0000ZP0002X3000E0@00d`<00040001EE@M1
MT07@JX0002`0`000@0004`00000000000000000003ooooooooooe00001E0000K00001H0000<0000
000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000>04005H2001Q0P00
``80000000160000F00004`00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
2T00P2@0000H0000ooooo`400000H9m3EDdGA:ZZSD=HUKe28@0000P0001R000030000040000T0000
90000000P3d0000000000000P3d0000000000080000U000030000080000U0000300000P0081F0000
<00003h1001L0P00FP800;`200050000i1?<9N@C^2^J9KP[VRG<9N@Cc2DU0000300000L0080U0000
30000000080T000090000000P440000000000000P44000000000008000160000W00009000015CDH[
240C0T00000d00000Q30f`00003F000000000000B44200000P000000044200000000008@`=/00000
V@00o`Q04P<l0000<000008@`=/400000000001PWd<002m4EHDFA000;dAEQAI4EDdGA01PWd=ECAM4
0041PAE04P0@0000100001<0000j0000300000P0000T000090000000P3d0000000000000P3d00000
00000080001O0000>0000040000h0000000003P00000000002010<P000000000002I000000000000
000002D0000<00000@0002D0000<00001@00P5H0000/000010400282002D0P00mP8000@0003T4kP[
VRFh:iXUc2GT4l`U9@0000`0000700209@0000`000000020900002@0000008110000000000000811
0000000000020000:00000`000010000>P0000`0000:00008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80002E1@00
jP8006/6002n0`00000004H0000D0000200004M4BD<30000DP00070100010000J_ooo`0000000000
00000;`20000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000002`:gX1
0@0000000000000000000000000000001`0000AbNP6PM7X1Z5SV<;0[NP7XIgX15000052h4`000000
16mj0@4000010000D;PC04N9k300000016mj0@00002PM7X1j2aj0@000004KgX1H00005bh4`1/F>H`
0@00000000020000P75j0N2h4`3DLgX100000000003oooooB93/<:2>NP44KgX1c;TC0040000ed`4`
4;hC0000000lHGX12@Aj0@T4NP7AO0d`9R0000T4NP4001<000000000000/^A<0000000000004KgX1
;;TC05j=k304KgX1000001Bi4`0T^A<00000090_NP7XIgX1I7H02000000U000030000040000F0000
300001P0000B000030000040000H000030000000009D0000E0000;@500020`00B@H00:/300010000
EED7@GI01d6d1@00R`<00040001<00000000000000000000oooooooooom@00009R0009H0000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P0003h2000L0P00
eP80054200000000AP0001@100080@00ADe6:bY0000T000060000000P3l000200000P000P3l00020
0000P0Q05@:T0000V000008@`=/00000W1000000001EE@E1o`00008000000011000006@000024<3K
0000004000020000002@@00000000000000000008440080o0000000000000000000002P000024<3K
0`00000P00000210002P`00000000000000P`000X<000H5<0Q30f`000000V@3o240D0b`0000P0000
0Q30f`8000000000EJT@A5F93DAE=CA4EHT=A0010`<E@1@0400000@0000E0000:00000`000020000
8@0000P0001R000030000040000T000090000000P3d0000000000000P3d0000000000080001O0000
>0000080000h0000000003P000000000018101000000000009T0000000000000000002D0000<0000
0P0002L0000H00000@0000000000V@00000002D0000<00000@0001<0000<00000P0005/0001<0000
@08001l2003B0P00C0800080000900001@0000@0000S91PS[RXH8jhZWB<S99dS8b@H8f/Z3B86;E/S
JbZX96/Z3B8C000030000040000U000030000000080U0000300000L0080T000090000000P4400000
00000000P440000000000080000X000030000080000R000030000?oooom60000700001000015CDH[
140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U30P00018200280@00
0@<0020200000000AP0001@000080000AdA9@`<0001B0000L0400080002Loooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0
j;XC0;00001B0@00/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000004<00000JcH:001<09QUDc1LI7X10@0009Bg4`2_4P8`;@0C03GC0C0@_Q<0
000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<0
16mj0D1eNP4L^1<0HW`:<3X=2SD@_Q<03P02<03hoomTMP08000002D0000<00000P0001H0000<0000
60000180000<00000@0001P0000<000009T00U@0001D0000>`8009l1001F0P0040800040001EE@M1
MT07@C/2003i0@000@0004`00000000000000000003ooooooooooe00001Y0000700001H0000<0000
000002D0000<00003P00P2P0000<00000P000580001`0@000P000;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
/0000581002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000001Rg4`000000^02AO304703T]a<0@@2AO4P75@1M095l>Pd:=SP4700h11`0000003aQNP400000
V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000
g65j0CX=2SDP00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E050^8@0U0000
L>PG00002P2<cP00f;L100@0000X]a<0aPhQmVAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`00000V@02E00005@0001G0P00eP4007P2000Q0P000@0005EE1d5f@0M1
E`80018200010000C00000000000000000000?ooooooooooD0000340000R00005P0000`000000000
9@0000`0000>0020:00000`000020000DP00070100020000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`2`0000
DP400;0[NP4001<0@@2AO4P75@1M095l>Pd:=SP4700h11`0000003aQNP400000V6EC<82h4`1lL4T`
6;LC0000002h095l<0@L0>Bg4`11095lB0LE05d0TG`j3@Xg>0@L03P470000000g65j0CX=2SDP0000
3P02<03hoomTMP08000000000S1`j1L0a;LC05iJlgO4]a<0000E050^8@0ed`4`4;hC0000001lHWX1
f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0J30Q02D0001`j1L0
000:0:C@003H]`40100002Rg4`363R7fI7H02000000U000030000080000F0000300001P0000B0000
30000040000H00003000002I009D0000E00007T2002O0@00V@80010200010000EED7@GI01d5i0P00
n@400040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000080001B0000L0400080002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC0;00001B0@00
/2]j0@004`11095lB0LE05d0TG`j3@Xg>0@L03P470000000g65j0CX=2SDP00003P02<03hoolH]a<0
00000;P0TG``11`0i;LC0440TGa81aD0G@2AO3X=2SPh11`0>0@L0000001lHWX1f;L10200000X]a<0
aPhQmVAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0J30Q03GC0C0@_Q<0000001aSNP7H]`40
800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=ga;LC00005@20<R409@00073X5`0000X0
_=800=Rg0@040000:;LC0<H>8OITMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<000009T00U@0001D0000VP8009l1002g0P0040800040001EE@M1MT07@IX2003i0@00
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0/0000581002`:gX1
000C0440TGa81aD0G@2AO3X=2SPh11`0>0@L0000001lHWX1f;L10200000X]a<0aPhQmQRg4`000000
^02AO304703T]a<0@@2AO4P75@1M095l>Pd:>CP4700h11`0000001aSNP7H]`40800002Rg4`363R7f
I7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@20<R40=M<1<12n4`000000_6=j0MRg0@0P0000
:;LC0<H>8OITMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E09Pd8@0U0000L>PG00002P3De000
f;L100@0000X]a<0aPhQmVAf00P000009@0000`0000200005P0000`0000H00004P0000`000010000
600000`00000V@02E00005@0002f0P00W`400=H2000@0P000@0005EE1d5f@0M1]P800?T100010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000020000AP0002P0000L0000AdA9@`80001A1`00<`800>X7001X0P00000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@1H2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000100000P000000T4000000
00000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000X<000000
000000008<000:300061C08@`=/0000009T0o`Q05`</00008000008@`=/2000000000034jTAEIA=4
08[lA5EU4d@00H405D0G0100000400005P00024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000020000>0000000000h00000000000B0@080000
0000002I0000000000000000000U000030000080000U000030000040000C000030000080001K0000
C00005@7000f0P00iPL006@2000200002@0000D000040000[CY84_<mB1;c?HXB[CZ:4ZdjB1;B?L8A
7cmY4]8m41?B?L8A4`0000`0000100009@0000`0000000209@0000`000070020900002@000000011
00000000000000110000000000020000:00000`0000200008P0000`0003oooooAP0001`0000@0000
ADe6:`A0000<0000000004H0000D0000200004M4BD<30000AP0002P0000L0000AdA9@`80000>1`00
W`4005`8000g0P00000004H0000D0000200004M4BD<30000DP00070100020000W?ooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000
S;XC0>Rj4`0?0@0020800;0[NP4001<0i;HC0=1PNP4>008`_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<0
5A@2<2d0000?4`8`;@0C00000013000006<f2P00C02HIE<`G6Aj0@40002D]a<0[a82<2d04`0ed`4`
4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0>PP2<</;0@L]01<0000004<0002A1@8`
b;PC00A_NP50MGX17;PC069l2S153`[A4;hC00h00S00n?ooI7H02000000U000030000080000F0000
300001P0000B000030000040000H00003000002I009D0000E00006L7002f0@00PPL002L200010000
EED7@GI01d5W1`0040800040001<00000000000000000000oooooooooom@0000J@0001`0000F0000
30000000000U0000300000h0080X000030000080001B0000L0400080002moooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0
j;XC00l100080P00/2]j0@00H@1^00009R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`
;@0C0000000H]a<000000;P0TG``11`0i;LC0440TGa81aD0G@2AO4D?2]8h11`0>0@L0000000lHGX1
000009QUDc20^1<0O719<000000001<00002<</;0@L]01<0000004<0002A1@8`b;PC03GC0C0@_Q<0
00000=aQNP553`[A800000h00S00n?ooI7H02000000j208`L>PG0<Bg4`1NF_=ga;LC00005@2`>b40
9@00073X5`0000X0k=/00=Rg0@040000:;LC0<H>8OITMP08000002D0000<00000P0001H0000<0000
60000180000<00000@0001P0000<000009T00U@0001D0000P`L00>d1002T1`00>0800040001EE@M1
MT07@H<7000Y0P000@0004`00000000000000000003ooooooooooe00001^00008P0001H0000<0000
000002D0000<00003P00P2P0000<00000P000580001`0@000P0009coool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000@000000000000008bj4`3X^Q<0
3`4000P2002`:gX1000C0440TGa81aD0G@2AO4D?2]8h11`0>0@L0000000lHGX1000009QUDc20^1<0
O719<1Rg4`000000^02AO304703T]a<0@@2AO4P75@1M095lA@l:dcP4700h11`000000=aQNP553`[A
800000h00S00n?ooI7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@2`>b40=M<1<12n4`000000
O69j0MRg0@0P0000:;LC0<H>8OITMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E0<Pm8@0U0000
L>PG00002P04gP00f;L100@0000X]a<0aPhQmVAf00P000009@0000`0000200005P0000`0000H0000
4P0000`000010000600000`00000V@02E00005@0002U1`00]P400<D7000W0P000@0005EE1d5f@0M1
Y@L0010200010000C00000000000000000000?ooooooooooD00002P0000Q00005P0000`000000000
9@0000`0000>0020:00000`000020000DP00070100020000W?ooo`00000000000000090100010000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001000000000000000S;XC0>Rj4`0?0@00
20800;0[NP4001<0@@2AO4P75@1M095lA@l:dcP4700h11`000000=aQNP553`[A800000h00S00n?oo
6;LC0000002h095l<0@L0>Bg4`11095lB0LE05d0TGa53`[D>0@L03P470000000O69j0MRg0@0P0000
:;LC0<H>8OITMP08000000000S1`j1L0a;LC05iJlgO4]a<0000E0<Pm8@0ed`4`4;hC0000000LHgX1
f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0h3lQ02D0001`j1L0
000:01cP003H]`40100002Rg4`363R7fI7H02000000U000030000080000F0000300001P0000B0000
30000040000H00003000002I009D0000E0000<H7002f0@00h`L002L200010000EED7@GI01d761`00
40800040001<00000000000000000000oooooooooom@0000M00001`0000F000030000000000U0000
300000h0080X000030000080001B0000L0400080002Loooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00004000000000000002<^Q<0j;XC00l100080P00
/2]j0@004`11095lB0LE05d0TGa53`[D>0@L03P470000000O69j0MRg0@0P0000:;LC0<H>8OHH]a<0
00000;P0TG``11`0i;LC0440TGa81aD0G@2AO4D?2]Dh11`0>0@L0000000LHgX1f;L10200000X]a<0
aPhQmVAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0h3lQ03GC0C0@_Q<000000;aSNP7H]`40
800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=ga;LC00005@3h@B409@00073X5`0000X0
=>800=Rg0@040000:;LC0<H>8OITMP08000002D0000<00000P0001H0000<000060000180000<0000
0@0001P0000<000009T00U@0001D0000hPL00;H1000220009`800040001EE@M1MT07@N87000@0P00
0@0004`00000000000000000003ooooooooooe00000Y00008@0001H0000<0000000002D0000<0000
3P00P2P0000<00000P0004H0000X0000700004M4BD<200005P400<@2002:0@00DP@0000000160000
@04003@10015CDH[:T0002@0000H00000020?`00080000200020?`0008000020240H0Z@0002H0000
0Q30f`00002L4000000005EE1D7o00000P00000004400000I000008@`=/000000P0000800000080o
0P00008000000000000P@@00P3l000000000000000000000:000008@`=/300000200000084000;30
00000000P;l00230002``0010@024<3K00000000ool8@1T3F00004`000024<3K1`000000000=A9Y3
ED4bA?L2/d=PJcY4Zl[2@g7;BdB[b/93Un1NA:_:`T=CaW=4XNV_@aXdPdAbZ9=3EK>6A0030`<30`<0
5D0I010000040000600002P0000<00000@00024000080000HP0000`000010000900002@00000080m
000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000
00000?l00000000000000000000U000030000040000W00006000008000000000o`000000000U0000
30000080000C000030000080000k0000200001/0000@0000JA<005</001I00008040000000000000
oooooooooom10000nQ>l;8PD=Bd?5K/]SAE=;P<FjBi_5Y0_daI1<2hGnS205kXaaaN4<PDHDc<h62Xd
H1P5=GhHiCF?6<PfUAR`=hhH[3Qi6:@iEQRH>RPHQ3_[5f`lXaM:?E0G83k`5^`nQQJ]?a4FID2B5@m1
2QF/@GPD?4;M4ke2>Q<]@`<CC4?34]Q2ka;0@XPCET8K5=e1YAAE@BLE`42P5Aa04AI]?gLF/ckC5^lm
91LQ?FXGBCbU5f/kdQN5>_@GVCT96:Th41Rc=`XHdcKi5oHegALL=KLGBCB65gXcBQNa<PDGkS6g5SDa
GaJ2<00FfBnH5CX_:1FT;[0D6Rha59X]Za<X;AXC_b`m0000200001/0000@0000TAD005E3001I0000
9000000000000000ooooooooool20000Ja9D@aHDZ41H0000=000000000000000ooooooooool60000
:AB9@58DOd1b59=0TABV@9XDcd275>m0F@0002P00000000000000?oooooooooo0`0001`C=D?S4/m2
TQG@@UP0000d000000000000003oooooooooo`H0002f5M12e1G^@]@E4d?D5CM3]QEE@i4EED<m0000
200003`000080000?`0001P0000U0@00``8008/1000g10004`0000`0000100009@0000`000000020
9@0000`000070020900002@00000081100000000000008110000000000020000:00000`000010000
8P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000000004H0000D0000200004M4BD<30000
AP0002P0000L0000AdA9@`80001^0@00<@<007<200390`00000004H0000D0000200004M4BD<30000
DP00070100010000W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200
DP1_06d0H@1^00001000000000000000S;XC0>Rj4`370000OP400;0[NP4001<0i;HC0=1PNP4>008`
_Oooo`0000000000000009010000000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
9R0`83PP>R2/8:`P8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C00000013000006`f2P00C02HIE<`
G6Aj0@40002D]a<0[a82<2d04`0ed`4`4;hC0000000lHGX1000009QUDc20^1<0O719<000000001<0
>PP2<</;0@L]01<0000004<0002A1@8`b;PC00A_NP50MGX17;PC069l2S0j3@YB4;hC00h00S00n?oo
I7H02000000U000030000040000F0000300001P0000B000030000040000H000030000?l0009D0000
E0000:X100180`00f`400;T300010000EED7@GI01d6Z0@00XP<00040001<00000000000000000000
oooooooooom@0000M@000380000F000030000000000U0000300000h0080X000030000040001B0000
L0400040002moooo0000000000000000T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0
K@1Q06h00004000000000000002<^Q<0j;XC0<L0001n0@00/2]j0@00H@1^00009R0`83PP>R2/8:`P
8R4R8Dbi4`1T]a<05A@2<2d0000?4`8`;@0C0000000H]a<000000;P0TGa891l0i;LC0440TGa81aD0
G@2AO3X=2U=@91l0D2@O0000000lHGX1000009QUDc20^1<0O719<000000001<00002<</;0@L]01<0
000004<0002A1@8`b;PC03GC0C0@_Q<000000=aQNP4j3@YB800000h00S00n?ooI7H02000000j208`
L>PG0<Bg4`1NF_=ga;LC00005@10Bb409@00073X5`0000X0O>/00=Rg0@040000:;LC0<H>8OITMP08
000002D0000<00000@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000
fP4007l3003e0@00bP<00040001EE@M1MT07@M`1002k0`000@0004`00000000000000000003ooooo
oooooe00001j00006P0001H0000<0000000002D0000<00003P00P2P0000<00000@000580001`0@00
0@0009coool0000000000000002@0@0000000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640
KP0000@000000000000008bj4`3X^Q<0a`0007h1002`:gX1000C0440TGa81aD0G@2AO3X=2U=@91l0
D2@O0000000lHGX1000009QUDc20^1<0O719<1Rg4`000000^02AO4PT7`3T]a<0@@2AO4P75@1M095l
>Pd:E50T7`1@91l000000=aQNP4j3@YB800000h00S00n?ooI7H020000000008`L>PG0<Bg4`1NF_=g
a;LC00005@10Bb40=M<1<12n4`000000O69j0MRg0@0P0000:;LC0<H>8OITMP08000003X80S1`j1L0
a;LC05iJlgO4]a<0000E05Q=8@0U0000L>PG00002P2Dk@00f;L100@0000X]a<0aPhQmVAf00P00000
9@0000`0000100005P0000`0000H00004P0000`000010000600000`0003o0002E00005@0003f0@00
B0<001H2002i0`000@0005EE1d5f@0M1mP400:8300010000C00000000000000000000?oooooooooo
D00002P0000Q00005P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000
W?ooo`0000000000000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000
1000000000000000S;XC0>Rj4`370000OP400;0[NP4001<0@@2AO4P75@1M095l>Pd:E50T7`1@91l0
00000=aQNP4j3@YB800000h00S00n?oo6;LC0000002h095lB2@O0>Bg4`11095lB0LE05d0TG`j3@YE
D2@O050T7`000000O69j0MRg0@0P0000:;LC0<H>8OITMP08000000000S1`j1L0a;LC05iJlgO4]a<0
000E05Q=8@0ed`4`4;hC0000000LHgX1f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0
GU[cMlBg4`0001D0L4lQ02D0001`j1L0000:0:c_003H]`40100002Rg4`363R7fI7H02000000U0000
30000040000F0000300001P0000B000030000040000H000030000?l0009D0000E00001L200180`00
=0800;T300010000EED7@GI01d4G0P00XP<00040001<00000000000000000000oooooooooom@0000
M00001`0000F000030000000000U0000300000h0080X000030000040001B0000L0400040002Loooo
0000000000000000T04000000000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000040000
00000000002<^Q<0j;XC0<L0001n0@00/2]j0@004`11095lB0LE05d0TG`j3@YED2@O050T7`000000
O69j0MRg0@0P0000:;LC0<H>8OHH]a<000000;P0TGa891l0i;LC0440TGa81aD0G@2AO3X=2UI@91l0
D2@O0000000LHgX1f;L10200000X]a<0aPhQmVAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0
L4lQ03GC0C0@_Q<000000;aSNP7H]`40800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=g
a;LC00005@28DB409@00073X5`0000X0a?400=Rg0@040000:;LC0<H>8OITMP08000002D0000<0000
0@0001H0000<000060000180000<00000@0001P0000<0000o`000U@0001D0000<`8004P3001C0P00
^@<00040001EE@M1MT07@C<2002R0`000@0004`00000000000000000003ooooooooooe00000Y0000
8@0001H0000<0000000002D0000<00003P00P2P0000<00000@0004H0000X0000700004M4BD<20000
K@400;L1000/0P00C`80000000160000500000P00017A4U30`000580001`0@000@0009coool00000
00000000002@0@000@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP00004000000000
000008bj4`3X^Q<0P@000?L0002`:gX1000C0>Bf4`3@H7X13P02<;goool0000000000000002@0@00
00000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0002HP<20h83XP[22/828Q8R5<^A<0
I;LC01DD0S0]00003a<2<2d04`000000@`00002>=PX004`0V6EC<7aRNP410000U;LC0:lB0S0]01<0
=M<1<12n4`000000?65j0@00002HIE<`P;PC07a`BC000000000C03X80S3;2`47;@0C000000130000
T@D2<<Rh4`04KgX1b7Aj0Abh4`1RO0X`A@l:ia2n4`0>008`0?SoofAf00P000009@0000`000010000
5P0000`0000H00004P0000`000010000600000`000000002E00005@0002]0@00cP400>X1000o0P00
0@0005EE1d5f@0M1[P4002P200010000C00000000000000000000?ooooooooooD0000580000m0000
5P0000`0000000009@0000`0000>0020:00000`000010000DP00070100010000_Oooo`0000000000
000009010001000004004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000@00000000000000
S;XC0>Rj4`210000m`000;0[NP400640KP0002HP<20h83XP[22/828Q8R5<^A<0I;LC01DD0S0]0000
3a<2<2d04`0000006;LC0000002h095lB2@O0>Bg4`11095lB0LE05d0TGa53`[XD2@O050T7`000000
?65j0@00002HIE<`P;PC07a`BC000000000C00000S3;2`47;@0C000000130000T@D2<<Rh4`0ed`4`
4;hC0000003LHGX1A@l:ib00000>008`0?SoofAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0
m5DQ02D0001`j1L0000:033f003H]`40100002Rg4`363R7fI7H02000000U000030000040000F0000
300001P0000B000030000040000H000030000000009D0000E0000><100050P003080050200010000
EED7@GI01d7[0@00@@800040001<00000000000000000000oooooooooom@0000L0000280000F0000
30000000000U0000300000h0080X00003000004000160000:00001`00017A4U30P000;T8000X0`00
1@X00<0300000000AP0001@000080000AdA9@`<0001B0000L0400040002Loooo0000000000000000
T04000400000@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00006000000000000002<^Q<0
j;XC00d100050P00/2]j0@004`3T]Q<0d61j0@h00S2moooo0000000000000000T04000000000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`
;@0000lC0S0]01<0000004<00000X3H:001<09QUDc3lI7X10`0009Bg4`2_4P8`;@0C03GC0C0@_Q<0
000003aQNP400000V6EC<82h4`1lL4T`000000004`0j208`b`/11bd04`000000@`0009450S38^1<0
16mj0FQeNP4L^1<0HW`:<3X=2VT@_Q<03P02<03hoomTMP08000002D0000<00000@0001H0000<0000
60000180000<00000@0001P0000<0000o`000U@0001D0000f0P003l300092@00/0<00040001EE@M1
MT07@MP8002I0`000@0004`00000000000000000003ooooooooooe00001e0000<P0001H0000<0000
000002D0000<00003P00P2P0000<00000@000580001`0@000@000;goool0000000000000002@0@00
0@000010019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP0000H000000000000008bj4`3X^Q<0
3@4000D2002`:gX1001Q06h0000V830P>20j8:`P[20R8B8QC;TC06Bg4`0E508`;@0000lC0S0]01<0
000001Rg4`000000^02AO4PT7`3T]a<0@@2AO4P75@1M095l>Pd:JU0T7`1@91l0000003aQNP400000
V6EC<82h4`1lL4T`000000004`00008`b`/11bd04`000000@`0009450S38^1<0=M<1<12n4`000000
g65j0CX=2VTP00003P02<03hoomTMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E061J8@0U0000
L>PG00002P2LnP00f;L100@0000X]a<0aPhQmVAf00P000009@0000`0000100005P0000`0000H0000
4P0000`000010000600000`0003o0002E00005@0000:2@00MP<002/900310`000@0005EE1d5f@0M1
2PT00;8300010000C00000000000000000000?ooooooooooD00006h0000R00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000_Oooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001P00000000000000S;XC0>Rj4`0=0@00
1@800;0[NP4001<0@@2AO4P75@1M095l>Pd:JU0T7`1@91l0000003aQNP400000V6EC<82h4`1lL4T`
6;LC0000002h095lB2@O0>Bg4`11095lB0LE05d0TG`j3@Y[D2@O050T7`000000g65j0CX=2VTP0000
3P02<03hoomTMP08000000000S1`j1L0a;LC05iJlgO4]a<0000E061J8@0ed`4`4;hC0000001lHWX1
f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0N5`Q02D0001`j1L0
000:0;Cl003H]`40100002Rg4`363R7fI7H02000000U000030000040000F0000300001P0000B0000
30000040000H000030000?l0009D0000F00002`9001f0`00LPT00<4300010000EED7@GI01d4/2@00
/P<00080001<00000000000000000000oooooooooom@0000:`0a02D0000R00005P0000`000000000
9@0000`0000>0020:00000`000010000DP00070100010000W?ooo`00000000000000090100000000
04004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00001P00000000000000S;XC0>Rj4`0=0@00
1@800;0[NP4001<0@@2AO4P75@1M095l>Pd:Je0T7`1@91l000000=aQNP4j3@YY800000h00S00n?oo
6;LC0000002h095lB2@O0>Bg4`11095lB0LE05d0TG`j3@Y/D2@O050T7`000000O69j0MRg0@0P0000
:;LC0<H>8OITMP08000000000S1`j1L0a;LC05iJlgO4]a<0000E07QL8@0ed`4`4;hC0000000LHgX1
f;L10200000X]a<0aPhQmVAf00P00000>PP2<73X5`34]a<0GU[cMlBg4`0001D0T5hQ02D0001`j1L0
000:0<cn003H]`40100002Rg4`363R7fI7H02000000U000030000040000F0000300001P0000B0000
30000040000H000030000?l0009D0000E00007<9000o0`00T`T00;0300010000EED7@GI01d5c2@00
V@<00040001<00000000000000000000oooooooooom@0000:0000240000F000030000000000U0000
300000h0080X000030000040001B0000L0400040002Loooo0000000000000000T04000400000@00B
E01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00006000000000000002<^Q<0j;XC00d100050P00
/2]j0@004`11095lB0LE05d0TG`j3@Y/D2@O050T7`000000O69j0MRg0@0P0000:;LC0<H>8OHH]a<0
00000;P0TGa891l0i;LC0440TGa81aD0G@2AO3X=2Ve@91l0D2@O0000000LHgX1f;L10200000X]a<0
aPhQmVAf00P000000002<73X5`34]a<0GU[cMlBg4`0001D0T5hQ03GC0C0@_Q<000000;aSNP7H]`40
800002Rg4`363R7fI7H02000000j208`L>PG0<Bg4`1NF_=ga;LC00005@2/H2409@00073X5`0000X0
j0010=Rg0@040000:;LC0<H>8OITMP08000002D0000<00000@0001H0000<000060000180000<0000
0@0001P0000<0000o`000U@0001D0000U0T003l3002a2@00/0<00040001EE@M1MT07@I@9002I0`00
0@0004`00000000000000000003ooooooooooe00001d0000700001H0000<0000000002D0000<0000
3P00P2P0000<00000@000580001`0@000@0009coool0000000000000002@0@0000000010019D06T0
K@1U07<0801>06D0M`0P0580K`1]0640KP0000H000000000000008bj4`3X^Q<03@4000D2002`:gX1
000C0440TGa81aD0G@2AO3X=2Ve@91l0D2@O0000000LHgX1f;L10200000X]a<0aPhQmQRg4`000000
^02AO4PT7`3T]a<0@@2AO4P75@1M095l>Pd:KU0T7`1@91l000000;aSNP7H]`40800002Rg4`363R7f
I7H020000000008`L>PG0<Bg4`1NF_=ga;LC00005@2/H240=M<1<12n4`000000G6Aj0MRg0@0P0000
:;LC0<H>8OITMP08000003X80S1`j1L0a;LC05iJlgO4]a<0000E0<AR8@0U0000L>PG00002P000`40
f;L100@0000X]a<0aPhQmVAf00P000009@0000`0000100005P0000`0000H00004P0000`000010000
600000`0003o0002E00005@0002`2@00?`<00=09002`0`000@0005EE1d5f@0M1/0T009T300010000
C00000000000000000000?ooooooooooD00002T0000Q00005P0000`0000000009@0000`0000>0020
:00000`000010000AP0002P0000L0000AdA9@`80003=2@00c`8000X:000T1000000004H0000D0@00
204004E=AR/Z@000900001P00000080o0000P0000800080o0000P0000808@1X2Y00009P000024<3K
000009`@00000000EED5@Ol0000200000000@@00001T00000Q30f`00000200000P000000P3l20000
0P000000000002110020?`000000000000000000000X00000Q30f`<000008000000P@000/<000000
0020_`008<000;3000410`8@`=/00000003oo`Q06`</00008000008@`=/20000000005Fi7TD0g3A4
EKTNAEG5Pd@00@<35D0K0100000400006P00024000080000HP0000`000010000900002@00000000n
000000000000000n0000000000020000G`0003P000010000>0000000000h00000000000B0@080000
00000?l00000000000000000000U000030000040000U000030000080000C000030000080000k0000
200001/0000@0000NTl009PF001I0000:000000000000000ooooooooool30000NTn[83Q?Zb0hCiPF
?@0000P0000K0000400001e@002?7`00F@0002@00000000000000?oooooooooo0P0005U?l22ECXlO
F00003@00000000000000?oooooooooo1P0008a>OanBCV/OXTiR7k9>FAo7CUlOd4i_7eT0000X0000
00000000003oooooooooo`<0001fCi/P?4nK8>=?KamH0000=000000000000000ooooooooool60000
k4mO7`1@FAl@D68O851[7bI@OalMD8lO?@0000P0000l0000200003l0000H0000d0T00=4200072P00
80@001<0000<00000@0002D0000<00000000P2D0000<00001`00P2@0000T00000000@@0000000000
0000@@00000000000P0002P0000<00000@000280000<0000ooooodH0000L0000400004E=AR/4@000
3000000000160000500000P00017A4U30`0004H0000X0000700004M4BD<20000c@T004L4000:2P00
Q0@0000000160000e0000<P00015CDH[:T0002@0000H00000020?`00080000200020?`0008000020
240L0i00002400000Q30f`d000000000P;dNA@2bRD@Dk1e50;:9A5E27DEo1H]4ED8MAEFXS4AE@Qe5
;4^>A1C/7DF[WXm4P;dNAJ^NSdC[SQm5Zij?A:Xh84D/Bhi4ZSPPAEFXS4BZ>215O`F;A>^>7dD0/XU4
P;dNA@2bRD@00`<30`<30`<30`>30000540LP10000040000ooooobP0000<00000P00024000080000
HP0000`000010000900002@00000000n000000000000000n00000000000200009`0001P000020000
00000?ooo`0000009@0000`0000200004`0000`000010000>`0000P0001E0000D000000000000000
ooooooooool=0000FdmY8_=>JB:NC[hRWThW8ii>Sb?cC^@SFdoT8lA?i2<ID8lS6E0W8aU@_R;4CfTR
FdmY8S`000080000?P0001P0003C2@00C@@000@:001m10004`0000`0000100009@0000`000000020
900002@00000001100000000000000110000000000020000AP0006@0001H0000ADe6:`Q07@940000
>000008@`=/00000gP000000000004Q10P000080000200000000@@80000000000Q30f`00002I003o
5D0L0100000400007@0002@0000T00000000?P00000000000000?P00000000000P0005l0000h0000
0@0003P000000000>000000000000040I0000000000009T000000000000000009@0000`000010000
9@0000`000050020E@000500003<2@00A@@000/:002410003@0005]?JB;cCVTRWTjn8Yi>9b>NCXlS
ldkT8e]?i2?4Cn@S6E2?8aU@9b<ID;hRa4mY8U]?JB8U0000300000L0080U000030000000080T0000
9000000004400000000000000440000000000080000X000030000040000R000030000?oooom60000
700001000015CDH[140000`000000000AP0001@000080000AdA9@`<000160000:00001`00017A4U3
0P000<d9001^0P002PX00:/200000000AP000=@000380000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P0Q07P>@0000Q000008@`=/=00000000082m7TEE:Ae45>`MAEDY7DAE@Qe5
D]0OA5E27DD05R=4ED8MAJeK9T@Dk1e5ZP8YA82m7TFZ0RU4jhhOAJX2:DBZ>215[E/VA:Xh84D05R=4
ZSPPAE;@7dC[SQm5EBTMA82m7TEE:Ae400<30`<30`<30`<3P`0001A07X0@000010000?oooolQ0000
20000680000<00000@0002@0000T00000000?P00000000000000?P00000000000P0002D0000<0000
0P0001<0000<00000@0003/000080000E@0005000000000000000?oooooooooo3@0005]?XQ?cCZ8C
WTkg4ii>GaBNC/PDldhM5E]?7AG4CadE6E3851U@Ga@ID?LCa4nR4e]?XQ<l0000200003h0000H0000
d`T007@200042P00Y08001<0000<00000@0002D0000<00000000P2@0000T00000000@@0000000000
0000@@00000000000P0004H0001T0000F00004E=AR/8@1l2A00003P000024<3K00000=h000000000
0018@@80000200000P000000044200000000008@`=/00000V@00oaE07P0@0000100001l0000T0000
9000000003h000000000000003h0000000000080001O0000>0000040000h0000000003P000000000
000106@000000000002I000000000000000002D0000<00000@0002D0000<00001@00P5D0001@0000
c0T006d2000;2P00Z`8000d0001KCj8CldjR4ii>ma>NCUlDWTk85?=>7AEKCadEa4lM5AU@b1@ID5lD
6E3g4lA?XQ=KCj8C9@0000`0000700209@0000`000000020900002@0000000110000000000000011
0000000000020000:00000`0000100008P0000`0003oooooAP0001`0000@0000ADe6:`A0000<0000
000004H0000D0000200004M4BD<30000AP0003@0000X0000ADe6:bY0000T000060000000P3l00020
0000P000P3l000200000P24000080000HP0000`000010000C00006@0001M000020800<4:00281000
G@0000P2001U2P00P@8002T0ZP00000000000000P3l0000000000000P3l000000000000000000000
000000000000000000000280000<0000ooooodH0000L0000400004E=AR/2@00030000000000>0000
50000000000@00005000
\>"], "Text",
 ImageSize->{389.5000431388578, 109.43521854245436`}],

Cell[CellGroupData[{

Cell["Popis obvodu", "Subsubtitle",
 CellChangeTimes->{{3.561807179378612*^9, 3.561807181269237*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "300"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rk", "\[Rule]", 
      RowBox[{"15", "R0"}]}], ",", 
     RowBox[{"Rp", "\[Rule]", 
      RowBox[{".1", "R0"}]}], ",", 
     RowBox[{"L", "\[Rule]", 
      RowBox[{".02", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{".05", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]]}]}], ",", 
     RowBox[{"R0", "\[Rule]", 
      SqrtBox[
       FractionBox["L", "c"]]}], ",", 
     RowBox[{"Rtl", "\[Rule]", 
      RowBox[{"1.5", "*", 
       SuperscriptBox["10", "6"]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f0", "=", 
   RowBox[{"1.5", "*", 
    SuperscriptBox["10", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T0", "=", 
   FractionBox["1", "f0"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"3.5", "T0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "0.005"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], ":=", 
   RowBox[{"0", "+", 
    RowBox[{"1", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tanh", "[", 
        FractionBox["t", 
         RowBox[{"k", "*", "T0"}]], "]"}], "-", 
       RowBox[{"Tanh", "[", 
        FractionBox[
         RowBox[{"t", "-", 
          RowBox[{"0.2", "T0"}]}], 
         RowBox[{"k", "*", "T0"}]], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rce", "[", "k_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["i", 
          RowBox[{"k", "+", "1"}]], "[", "t", "]"}], ",", "t"}], "]"}], "==", 
      RowBox[{
       FractionBox["1", "L"], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["u", "k"], "[", "t", "]"}], "-", 
         RowBox[{
          SubscriptBox["u", 
           RowBox[{"k", "+", "1"}]], "[", "t", "]"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["u", "k"], "[", "t", "]"}], ",", "t"}], "]"}], "==", 
      RowBox[{
       FractionBox["1", "c"], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["i", "k"], "[", "t", "]"}], "-", 
         RowBox[{
          SubscriptBox["i", 
           RowBox[{"k", "+", "1"}]], "[", "t", "]"}]}], ")"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceIn", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"rce", "/@", 
     RowBox[{"Range", "[", "n", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcePoc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"uz", "[", "t", "]"}], "-", 
     RowBox[{
      SubscriptBox["u", "1"], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], "[", "t", "]"}], "*", "Rp"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosPoc", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rcePoc", ",", 
      RowBox[{
       SubscriptBox["i", "1"], "[", "t", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceKon", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["i", 
       RowBox[{"n", "+", "1"}]], "[", "t", "]"}], "*", "Rk"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["u", 
      RowBox[{"n", "+", "1"}]], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosKon", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rceKon", ",", 
      RowBox[{
       SubscriptBox["u", 
        RowBox[{"n", "+", "1"}]], "[", "t", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rvysl", "=", 
   RowBox[{
    RowBox[{"rceIn", "/.", 
     RowBox[{"Union", "[", 
      RowBox[{"dosKon", ",", "dosPoc"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ders", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"rvysl", ",", 
      RowBox[{
       RowBox[{"_", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", "Union"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"ders", "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
     RowBox[{"a", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"nezname", "/.", 
    RowBox[{
     RowBox[{"a_", "[", "t", "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4684370887368336`*^9, 3.4684373944564366`*^9}, {
   3.4684374270232654`*^9, 3.468438076897739*^9}, {3.468438124205765*^9, 
   3.4684381828400764`*^9}, {3.4684382502069454`*^9, 3.468438254423008*^9}, 
   3.468438299297534*^9, {3.4684383877547293`*^9, 3.4684383984100513`*^9}, 
   3.4684389654353933`*^9, {3.468438997221099*^9, 3.468439087881462*^9}, {
   3.46843912021796*^9, 3.4684391229919486`*^9}, {3.468439153045163*^9, 
   3.468439262182094*^9}, {3.468439321647601*^9, 3.4684396172526608`*^9}, {
   3.4684396490383663`*^9, 3.468439781198403*^9}, 3.468439821065729*^9, {
   3.468440820432749*^9, 3.4684408307676096`*^9}, 3.4684409357685933`*^9, {
   3.468440972641614*^9, 3.468440988304136*^9}, 3.468468537600088*^9, 
   3.468468668558397*^9, {3.468471665117237*^9, 3.4684717605845118`*^9}, {
   3.468471807972653*^9, 3.468471875029075*^9}, {3.468471915777669*^9, 
   3.468471916158216*^9}, {3.468472005987384*^9, 3.4684720212994013`*^9}, {
   3.468472061296915*^9, 3.4684721366953325`*^9}, {3.4684722058147216`*^9, 
   3.4684722100808563`*^9}, {3.468472344143629*^9, 3.4684723485099072`*^9}, 
   3.4684723893987026`*^9, 3.468472467851512*^9, {3.468472570178651*^9, 
   3.468472605219037*^9}, {3.4684726875674477`*^9, 3.4684727161485453`*^9}, {
   3.4684729793269777`*^9, 3.468473034796739*^9}, 3.468473128601624*^9, 
   3.4684731703115997`*^9, 3.4684732379688864`*^9, {3.468473333065629*^9, 
   3.468473347606538*^9}, {3.4684737106385517`*^9, 3.4684737713558593`*^9}, {
   3.4684759116534557`*^9, 3.4684759275963807`*^9}, {3.468476067127016*^9, 
   3.4684763489122033`*^9}, {3.4684764111016273`*^9, 3.4684765124673843`*^9}, 
   3.46847744370644*^9, {3.4684775131062317`*^9, 3.468477513486779*^9}, {
   3.4684775582912045`*^9, 3.46847763523184*^9}, {3.4684777382199297`*^9, 
   3.468477748284402*^9}, {3.46847789735876*^9, 3.4684779181486545`*^9}, 
   3.4684780055142803`*^9, 3.4684780766866207`*^9, {3.468478123293638*^9, 
   3.4684781382150946`*^9}, 3.46847821982244*^9, {3.468739364375*^9, 
   3.468739387453125*^9}, 3.468739419515625*^9, 3.468739451984375*^9, {
   3.46873951509375*^9, 3.468739525359375*^9}, {3.46873958096875*^9, 
   3.46873958390625*^9}, 3.468739651625*^9, {3.46873983921875*^9, 
   3.46873984140625*^9}, {3.46892498775*^9, 3.4689249911875*^9}, {
   3.468925032734375*^9, 3.468925058390625*^9}, {3.46892515228125*^9, 
   3.46892516925*^9}, {3.468925374015625*^9, 3.468925375984375*^9}, 
   3.468925411328125*^9, 3.468925460421875*^9, {3.468925499859375*^9, 
   3.468925526203125*^9}, {3.46892556528125*^9, 3.46892556759375*^9}, {
   3.468925845765625*^9, 3.46892584603125*^9}, {3.468926933296875*^9, 
   3.4689269335625*^9}, {3.468927011953125*^9, 3.468927020265625*^9}, 
   3.46892718940625*^9, 3.46892732325*^9, 3.468927356078125*^9, {
   3.468927650828125*^9, 3.46892773290625*^9}, 3.468927787546875*^9, 
   3.46892782553125*^9, 3.468927869078125*^9, {3.468927900015625*^9, 
   3.468927900234375*^9}, {3.468927995015625*^9, 3.468928002375*^9}, {
   3.468928204671875*^9, 3.468928204984375*^9}, {3.468928292390625*^9, 
   3.4689283144375*^9}, {3.4689397278244*^9, 3.468939728698*^9}, 
   3.4689400863124*^9, {3.4689401515204*^9, 3.4689401749828*^9}, {
   3.4689402806415997`*^9, 3.468940292014*^9}, {3.4689404938780003`*^9, 
   3.4689405039712*^9}, {3.4689405833128*^9, 3.46894058662*^9}, {
   3.4689406969588003`*^9, 3.4689407156008*^9}, {3.4689408334432*^9, 
   3.4689408582784*^9}, 3.4691643465186343`*^9, {3.4691645146436343`*^9, 
   3.46916451803426*^9}, 3.4691651379248843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\:0158e\[SHacek]en\[IAcute]", "Subsubtitle",
 CellChangeTimes->{{3.561807179378612*^9, 3.561807181269237*^9}, {
  3.561807218191112*^9, 3.561807220128612*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"numRce", "=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rvysl", ",", "pocs"}], "]"}], "//.", "dos"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"NDSolve", "[", 
     RowBox[{"numRce", ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"StartingStepSize", "\[Rule]", 
       RowBox[{"T0", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}], ",", 
      RowBox[{"Method", "->", "\"\<Adams\>\""}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<trvalo to  \>\"", ",", 
    RowBox[{"pom", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<  s\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"pom", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"napeti", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"nezname", ",", 
     RowBox[{
      SubscriptBox["u", "_"], "[", "t", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vys2", "[", "t_", "]"}], "=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"napeti", "/.", "res"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.468477694136541*^9, 3.468477859704616*^9}, {
   3.4684779666984653`*^9, 3.468477983813075*^9}, {3.4684780341955214`*^9, 
   3.4684780418365088`*^9}, {3.4687393730625*^9, 3.46873938071875*^9}, {
   3.46892520759375*^9, 3.468925241859375*^9}, 3.468939736342*^9, {
   3.4691643617686343`*^9, 3.4691643621123843`*^9}, {3.46916445728426*^9, 
   3.46916446734676*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zobrazen\[IAcute] v\[YAcute]sledk\:016f", "Subsubtitle",
 CellChangeTimes->{{3.561807179378612*^9, 3.561807181269237*^9}, {
  3.561807222769237*^9, 3.561807227691112*^9}},
 Background->RGBColor[1, 0.85, 0.85]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"vys2", "[", 
      RowBox[{"ktmax", "*", "tmax"}], "]"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x[i]\>\"", ",", "\"\<\!\(\*SubscriptBox[\(u\), \(i\)]\)[V]\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ktmax", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.468927109328125*^9, 3.468927168609375*^9}, {
   3.46892723921875*^9, 3.46892728075*^9}, {3.4689273313125*^9, 
   3.468927337453125*^9}, {3.468927372265625*^9, 3.468927392859375*^9}, {
   3.468927745546875*^9, 3.4689277463125*^9}, 3.46892783965625*^9, {
   3.46892791584375*^9, 3.468927956828125*^9}, {3.46892805384375*^9, 
   3.468928161203125*^9}, {3.468928239046875*^9, 3.46892823978125*^9}, {
   3.468940251376*^9, 3.4689402556191998`*^9}, {3.4689404512743998`*^9, 
   3.4689404576703997`*^9}, {3.4689405949504004`*^9, 3.468940600426*^9}, {
   3.46916458975301*^9, 3.4691645991123843`*^9}, {3.561755900671875*^9, 
   3.5617559055625*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 702},
WindowMargins->{{-4, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 131, 2, 156, "Title"],
Cell[701, 26, 346, 8, 75, "Input"],
Cell[1050, 36, 831, 20, 95, "Text"],
Cell[1884, 58, 141958, 1754, 397, "Text"],
Cell[143845, 1814, 168, 4, 69, "Text"],
Cell[144016, 1820, 60966, 754, 190, "Text"],
Cell[204985, 2576, 199, 3, 110, "Text"],
Cell[205187, 2581, 1147, 34, 281, "Input"],
Cell[206337, 2617, 977, 23, 168, "Text"],
Cell[207317, 2642, 245, 8, 115, "Input"],
Cell[207565, 2652, 385, 7, 110, "Text"],
Cell[207953, 2661, 336, 11, 73, "Input"],
Cell[208292, 2674, 734, 18, 169, "Text"],
Cell[CellGroupData[{
Cell[209051, 2696, 262, 6, 164, "Subtitle"],
Cell[209316, 2704, 94731, 1171, 316, "Text"],
Cell[CellGroupData[{
Cell[304072, 3879, 139, 2, 115, "Subsubtitle"],
Cell[304214, 3883, 8439, 213, 1052, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[312690, 4101, 203, 3, 115, "Subsubtitle"],
Cell[312896, 4106, 1838, 51, 404, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314771, 4162, 215, 3, 115, "Subsubtitle"],
Cell[314989, 4167, 1306, 29, 120, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
