(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64885,       1470]
NotebookOptionsPosition[     63036,       1408]
NotebookOutlinePosition[     63438,       1425]
CellTagsIndexPosition[     63395,       1422]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", "*", "3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 3.689476074453125*^9}, {
   3.690042085125*^9, 3.69004208646875*^9}, {3.6900439293125*^9, 
   3.690043938546875*^9}, 3.69008213334375*^9, 3.690082312671875*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a = \"\>", "\[InvisibleSpace]", "1.2648809523809523`*^-6", 
   "\[InvisibleSpace]", "\<\"  \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a = ", 1.2648809523809523`*^-6, 
   "  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.752382399890625*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]x = \"\>", "\[InvisibleSpace]", "0.05`", 
   "\[InvisibleSpace]", "\<\"  m\"\>"}],
  SequenceForm["\[CapitalDelta]x = ", 0.05, "  m"],
  Editable->False]], "Print",
 CellChangeTimes->{3.75238239990625*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]tmax = \"\>", "\[InvisibleSpace]", 
   "988.2352941176473`", "\[InvisibleSpace]", "\<\"  s\"\>"}],
  SequenceForm["\[CapitalDelta]tmax = ", 988.2352941176473, "  s"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7523823999375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]el", "[", "T_", "]"}], ":=", 
   RowBox[{"1.5", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.0005", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "150"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Skolma", "=", 
   RowBox[{"Pi", "*", 
    SuperscriptBox["R", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obvod", "=", 
   RowBox[{"2", "*", "Pi", "*", "R"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "5.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV1", "[", "T_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["proud", "Skolma"], ")"}], "2"], "*", 
    RowBox[{"\[Rho]el", "[", "T", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV2", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox["obvod", "Skolma"], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}], "+", 
      RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", "+", "273."}], ")"}], "4"], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"To", "+", "273."}], ")"}], "4"]}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qv", "[", "T_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"QV1", "[", "T", "]"}], "-", 
     RowBox[{"QV2", "[", "T", "]"}]}], 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"qv", "[", "Tustalene", "]"}], "\[Equal]", "0"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Tust", "=", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Tustalene", "/.", "%"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}], "//",
    "Max"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690041981890625*^9, 3.69004201409375*^9}, {
   3.690042057671875*^9, 3.690042449171875*^9}, {3.6900425315625*^9, 
   3.69004260603125*^9}, {3.6900436025625*^9, 3.690043624921875*^9}, {
   3.690082154875*^9, 3.690082166859375*^9}, {3.6900822255625*^9, 
   3.69008225271875*^9}, 3.690082706984375*^9, 3.69008293615625*^9, {
   3.69008363284375*^9, 3.690083640453125*^9}, {3.69008383903125*^9, 
   3.690083876640625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{"-", "846.9985434850008`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "190.55558261763318`"}], "-", 
      RowBox[{"505.1926590950824`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "190.55558261763318`"}], "+", 
      RowBox[{"505.1926590950824`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", "136.1097087202672`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7523824001875*^9}],

Cell[BoxData["136.1097087202672`"], "Output",
 CellChangeTimes->{3.752382400203125*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "\[Alpha]1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], ":=", "To1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], ":=", "Ton"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042772671875*^9}, {3.690043833125*^9, 
   3.690043840921875*^9}, {3.690082173234375*^9, 3.690082209984375*^9}, 
   3.690082289390625*^9, 3.69008241721875*^9, 3.69008247815625*^9, 
   3.690082961578125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "krok", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Tpom", ",", "odQV"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"odQV", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]t", "*", 
          RowBox[{"qv", "[", "#", "]"}]}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"list", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Tpom", "=", 
       RowBox[{
        RowBox[{"1", "*", "odQV"}], "+", 
        RowBox[{"ListConvolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Fo", ",", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}],
          "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{"Tpom", ",", 
          RowBox[{"fTn", "[", 
           RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"krok", "[", "Tpolepoc", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.690042942125*^9}, {3.690043200828125*^9, 3.690043297484375*^9}, {
   3.690043448078125*^9, 3.690043451015625*^9}, {3.69004370228125*^9, 
   3.690043703796875*^9}, {3.690043903703125*^9, 3.690043904125*^9}, {
   3.690082271046875*^9, 3.690082276484375*^9}, {3.69008274721875*^9, 
   3.69008287409375*^9}, {3.690082914625*^9, 3.6900829280625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"10", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxT", "=", 
   RowBox[{
    RowBox[{"Last", "[", "teppole", "]"}], "//", "Max"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.690043497046875*^9}, {3.690043647546875*^9, 3.690043650421875*^9}, {
   3.690043768484375*^9, 3.69004379325*^9}, 3.69004389503125*^9, {
   3.6900823911875*^9, 3.690082391453125*^9}, 3.69008250709375*^9, 
   3.690082973640625*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plotik", "[", 
     RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"nel", "=", 
         RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i", 
        ",", "tpopis"}], "}"}], ",", 
      RowBox[{
       RowBox[{"listpom", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
            RowBox[{"list", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"listpom", ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
         ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"maxT", "+", "10"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{"tpopis", "=", 
           RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
          RowBox[{"PlotLabel", "->", 
           RowBox[{"\"\<t=\>\"", "<>", 
            RowBox[{"ToString", "[", "tpopis", "]"}], "<>", 
            "\"\< s\>\""}]}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.6900434928125*^9}, {3.69004366353125*^9, 3.6900436775*^9}, {
   3.690043744765625*^9, 3.6900437659375*^9}, {3.690043801109375*^9, 
   3.690043802625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 3.689476362265625*^9}, {
   3.690043683015625*^9, 3.69004369415625*^9}, 3.690043805375*^9, 
   3.690044085796875*^9, {3.690047003421875*^9, 3.690047010078125*^9}, 
   3.69008234125*^9, 3.690082997296875*^9, {3.690083660390625*^9, 
   3.690083668109375*^9}, {3.752382820265625*^9, 3.75238283565625*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"plots", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{3.690043991421875*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceUstStav", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"qv", "[", 
        RowBox[{"T", "[", "x", "]"}], "]"}]}], "\[Equal]", "0"}], "}"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "d", "]"}], "\[Equal]", "Ton"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"resNDS", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rceUstStav", ",", "okr1", ",", "okr2"}], "]"}], ",", "T", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "resNDS"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690044568703125*^9, 3.6900446249375*^9}, {
   3.690044659953125*^9, 3.6900446638125*^9}, {3.690044766109375*^9, 
   3.690044841265625*^9}, {3.690044872828125*^9, 3.690044930453125*^9}, {
   3.6900449689375*^9, 3.690044969515625*^9}, {3.690045002765625*^9, 
   3.690045050828125*^9}, {3.690083035390625*^9, 3.690083116796875*^9}, 
   3.69008368015625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"sszero\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The step size in the search \
has become less than the tolerance prescribed by the PrecisionGoal option, \
but the function value is still greater than the tolerance prescribed by the \
AccuracyGoal option.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/FindRoot\\\", ButtonNote -> \\\"FindRoot::sszero\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.75238240390625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"berr\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"There are significant errors \
\\\\\\\"\\\", \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\({\\(\\(-19.999993259951452`\\)\
\\), \\(\\(-818.3892260127064`\\)\\)}\\), \
\\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\\\" in the boundary value \
residuals. Returning the best solution found.\\\\\\\"\\\", \\\"MT\\\"]\\) \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/NDSolve\\\", ButtonNote -> \
\\\"NDSolve::berr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.752382404*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"T", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.752382404046875*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVWnk4VP8bRSnaZM0WJcmSCImKFxFZsmQp2UmSkDWVNWQ3kzXZk/JNlCWF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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1.5}, {-1139.0719563071214`, 6.740037582511242*^-6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.75238240421875*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"DSolve", "[", 
   RowBox[{"rceUstStav", ",", 
    RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690044707359375*^9, 3.690044721046875*^9}, 
   3.690044754328125*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"resStrelba", "[", 
   RowBox[{"derT0_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rce", ",", "res"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rce", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"rceUstStav", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"res", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{"rce", ",", 
         RowBox[{"{", 
          RowBox[{"T", ",", 
           RowBox[{"T", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", "[", "d", "]"}], ",", "T"}], "}"}], "/.", "res"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resStrelba", "[", "20.1", "]"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.69004510465625*^9, 3.690045276484375*^9}, {
  3.690045309859375*^9, 3.690045316484375*^9}, {3.690045353015625*^9, 
  3.690045382484375*^9}, {3.690045430640625*^9, 3.690045444328125*^9}, {
  3.6900455263125*^9, 3.690045628140625*^9}, {3.69008314978125*^9, 
  3.690083208375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1124.253124337331`"}], ",", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.752382404296875*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"resStrelba", "[", "T0", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T0", ",", "20", ",", "20.1"}], "}"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690045639328125*^9, 3.69004566425*^9}, 
   3.6900456968125*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"resStrelba", "[", 
    StyleBox["1610.697632",
     FontColor->RGBColor[1, 0, 0]], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "d"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690045702796875*^9, 3.69004576675*^9}, {
  3.690083247828125*^9, 3.69008349196875*^9}, {3.6900837148125*^9, 
  3.690083806453125*^9}, {3.752382614984375*^9, 3.75238271065625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Xk4VU0YAHClolISypaQUCqFlPUdUqRCsq9HRbZSKpUospRdRIpIlKRF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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.75238240434375*^9, {3.75238261609375*^9, 3.752382711015625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"{", 
     RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Tvlevo", "+", "Tvpravo", "-", 
     RowBox[{"2", "Tzde"}]}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rceUvnitr", "[", 
    RowBox[{"trojice", ":", 
     RowBox[{"{", 
      RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"der2", "[", "trojice", "]"}]}], "+", 
     RowBox[{"qv", "[", "Tzde", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcesIn", "=", 
   RowBox[{
    RowBox[{"rceUvnitr", "/@", 
     RowBox[{"Partition", "[", 
      RowBox[{"teploty", ",", "3", ",", "1"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "rcesIn", "]"}], "+", "2"}], "\[Equal]", 
  "n"}]}], "Input",
 CellChangeTimes->{{3.69004616290625*^9, 3.69004622325*^9}, {
  3.69004628921875*^9, 3.69004639315625*^9}, {3.69004642625*^9, 
  3.690046508078125*^9}, {3.69004694071875*^9, 3.690046940953125*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7523824044375*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceT1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], "-", "To1"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceTn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "n"], "-", "Ton"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690046633703125*^9, 3.6900467539375*^9}, {
  3.69008353121875*^9, 3.690083547*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"rceSite", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rcesIn", ",", "rceT1", ",", "rceTn"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6900467973125*^9, 3.6900468335*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocTeploty", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", "Tust"}], "}"}], "&"}], "/@", "teploty"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"rceSite", ",", "pocTeploty"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"%", "/.", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", "b"}]}], ")"}], "//",
   "ListPlot"}]}], "Input",
 CellChangeTimes->{{3.6900468523125*^9, 3.69004693203125*^9}, {
  3.690083929015625*^9, 3.690083931984375*^9}, {3.752382967125*^9, 
  3.7523829888125*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], "\[Rule]", "20.`"}], ",", 
   RowBox[{
    SubscriptBox["T", "2"], "\[Rule]", "78.72670743342223`"}], ",", 
   RowBox[{
    SubscriptBox["T", "3"], "\[Rule]", "108.42060159570582`"}], ",", 
   RowBox[{
    SubscriptBox["T", "4"], "\[Rule]", "122.91145889438405`"}], ",", 
   RowBox[{
    SubscriptBox["T", "5"], "\[Rule]", "129.85629090414554`"}], ",", 
   RowBox[{
    SubscriptBox["T", "6"], "\[Rule]", "133.15532020818958`"}], ",", 
   RowBox[{
    SubscriptBox["T", "7"], "\[Rule]", "134.7158338656009`"}], ",", 
   RowBox[{
    SubscriptBox["T", "8"], "\[Rule]", "135.4525021962061`"}], ",", 
   RowBox[{
    SubscriptBox["T", "9"], "\[Rule]", "135.79992260465315`"}], ",", 
   RowBox[{
    SubscriptBox["T", "10"], "\[Rule]", "135.9636840474342`"}], ",", 
   RowBox[{
    SubscriptBox["T", "11"], "\[Rule]", "136.04083367678757`"}], ",", 
   RowBox[{
    SubscriptBox["T", "12"], "\[Rule]", "136.07712246196283`"}], ",", 
   RowBox[{
    SubscriptBox["T", "13"], "\[Rule]", "136.09407712653692`"}], ",", 
   RowBox[{
    SubscriptBox["T", "14"], "\[Rule]", "136.10175679004982`"}], ",", 
   RowBox[{
    SubscriptBox["T", "15"], "\[Rule]", "136.10471807608545`"}], ",", 
   RowBox[{
    SubscriptBox["T", "16"], "\[Rule]", "136.10471807608545`"}], ",", 
   RowBox[{
    SubscriptBox["T", "17"], "\[Rule]", "136.10175679004982`"}], ",", 
   RowBox[{
    SubscriptBox["T", "18"], "\[Rule]", "136.09407712653692`"}], ",", 
   RowBox[{
    SubscriptBox["T", "19"], "\[Rule]", "136.07712246196283`"}], ",", 
   RowBox[{
    SubscriptBox["T", "20"], "\[Rule]", "136.04083367678757`"}], ",", 
   RowBox[{
    SubscriptBox["T", "21"], "\[Rule]", "135.9636840474342`"}], ",", 
   RowBox[{
    SubscriptBox["T", "22"], "\[Rule]", "135.79992260465315`"}], ",", 
   RowBox[{
    SubscriptBox["T", "23"], "\[Rule]", "135.4525021962061`"}], ",", 
   RowBox[{
    SubscriptBox["T", "24"], "\[Rule]", "134.7158338656009`"}], ",", 
   RowBox[{
    SubscriptBox["T", "25"], "\[Rule]", "133.15532020818958`"}], ",", 
   RowBox[{
    SubscriptBox["T", "26"], "\[Rule]", "129.85629090414554`"}], ",", 
   RowBox[{
    SubscriptBox["T", "27"], "\[Rule]", "122.91145889438405`"}], ",", 
   RowBox[{
    SubscriptBox["T", "28"], "\[Rule]", "108.42060159570582`"}], ",", 
   RowBox[{
    SubscriptBox["T", "29"], "\[Rule]", "78.72670743342223`"}], ",", 
   RowBox[{
    SubscriptBox["T", "30"], "\[Rule]", "20.`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.752382404578125*^9, 3.75238298928125*^9}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQDQEf7CG0iQNUwOGA8NP4pnXBUD6Hw5ueL0qvpaKh
fAGHEwfXh4fuioPyRRyil+rtSbNOgPIlHBZeEk36sQTGl3FgdMmReXENxldw
iDz06GnVOxhfyUHBy+v7jJ8wvooDa+7b+mv/YHw1B0mf3CY/xkQoX8Mhurbt
ZDkTjK/l8HgHxzomZhhfx0Fubcl0Rzhfz+Ek086bkXC+ARrfEE29EZp5xmj2
maC5xxTNvWZo/jFH868FWnhYooWXFVp4WqOFtw1afNiixZcd3J0A3TR0xg==

    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.752382404578125*^9, 3.752382989296875*^9}]
}, Open  ]]
},
WindowSize->{1003, 740},
WindowMargins->{{18, Automatic}, {Automatic, 6}},
ShowSelection->True,
Magnification->1.8500001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 330, 9, 117, "Input"],
Cell[CellGroupData[{
Cell[900, 33, 2047, 54, 574, "Input"],
Cell[CellGroupData[{
Cell[2972, 91, 450, 10, 41, "Print"],
Cell[3425, 103, 269, 6, 38, "Print"],
Cell[3697, 111, 300, 6, 38, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4046, 123, 3044, 90, 642, "Input"],
Cell[7093, 215, 687, 19, 82, "Output"],
Cell[7783, 236, 87, 1, 51, "Output"]
}, Open  ]],
Cell[7885, 240, 1226, 31, 309, "Input"],
Cell[9114, 273, 2059, 52, 213, "Input"],
Cell[11176, 327, 1159, 28, 211, "Input"],
Cell[12338, 357, 2258, 57, 277, "Input"],
Cell[14599, 416, 815, 20, 140, "Input"],
Cell[15417, 438, 329, 10, 52, "Input"],
Cell[CellGroupData[{
Cell[15771, 452, 1532, 44, 181, "Input"],
Cell[17306, 498, 616, 11, 129, "Message"],
Cell[17925, 511, 693, 13, 99, "Message"],
Cell[18621, 526, 378, 13, 51, "Output"],
Cell[19002, 541, 19393, 324, 416, "Output"]
}, Open  ]],
Cell[38410, 868, 249, 6, 52, "Input"],
Cell[CellGroupData[{
Cell[38684, 878, 1573, 42, 213, "Input"],
Cell[40260, 922, 446, 15, 51, "Output"]
}, Open  ]],
Cell[40721, 940, 355, 10, 52, "Input"],
Cell[CellGroupData[{
Cell[41101, 954, 638, 16, 108, "Input"],
Cell[41742, 972, 15152, 253, 473, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56931, 1230, 1413, 41, 245, "Input"],
Cell[58347, 1273, 71, 1, 51, "Output"]
}, Open  ]],
Cell[58433, 1277, 500, 16, 117, "Input"],
Cell[58936, 1295, 213, 5, 52, "Input"],
Cell[CellGroupData[{
Cell[59174, 1304, 654, 19, 140, "Input"],
Cell[59831, 1325, 2559, 63, 255, "Output"],
Cell[62393, 1390, 627, 15, 450, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
