(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     60567,       1658]
NotebookOptionsPosition[     59082,       1614]
NotebookOutlinePosition[     59483,       1631]
CellTagsIndexPosition[     59440,       1628]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.505321783390625*^9, 3.505321788078125*^9}, {
   3.60467097675*^9, 3.60467101234375*^9}, 3.60467289*^9, {
   3.6820718363175707`*^9, 3.6820718445831957`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", "*", "x"}], "+", "c"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vyr", "[", "x0", "]"}], "\[Equal]", "f0"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "+", "dx"}], "]"}], "\[Equal]", "fplus1"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "-", "dx"}], "]"}], "\[Equal]", "fminus1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"integrand", "=", 
   RowBox[{
    RowBox[{"vyr", "[", "x", "]"}], "/.", "res"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"intNormal", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", "dx"}], ",", 
      RowBox[{"x0", "+", "dx"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.682679477296875*^9, 3.682679644734375*^9}, {
  3.682679678140625*^9, 3.682679679234375*^9}}],

Cell[BoxData[
 RowBox[{"intNewVlevo", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", 
       RowBox[{
        FractionBox["3", "2"], "dx"}]}], ",", 
      RowBox[{"x0", "+", "dx"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.682679692390625*^9, 3.682679701328125*^9}, {
  3.682680025609375*^9, 3.682680026640625*^9}}],

Cell[BoxData[
 RowBox[{"intNewVlevo", "-", "intNormal"}]], "Input",
 CellChangeTimes->{{3.682679716234375*^9, 3.682679721734375*^9}, {
  3.682680031875*^9, 3.682680054109375*^9}}],

Cell[BoxData[
 RowBox[{"plusVahyVlevo", "=", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["17", "24"], ",", 
    FractionBox[
     RowBox[{"-", "7"}], "24"], ",", 
    FractionBox["1", "12"]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.682679757421875*^9, 3.682679825203125*^9}, {
  3.682680057671875*^9, 3.682680058734375*^9}}],

Cell[BoxData[
 RowBox[{"intNewVpravo", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{"integrand", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x0", "-", "dx"}], ",", 
      RowBox[{"x0", "+", 
       RowBox[{
        FractionBox["3", "2"], "dx"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.682680071796875*^9, 3.68268008875*^9}}],

Cell[BoxData[
 RowBox[{"intNewVpravo", "-", "intNormal"}]], "Input",
 CellChangeTimes->{{3.682680104390625*^9, 3.68268010484375*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plusVahyVpravo", "=", 
     RowBox[{"Reverse", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["17", "24"], ",", 
        FractionBox[
         RowBox[{"-", "7"}], "24"], ",", 
        FractionBox["1", "12"]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plusVahyVpravo", "\[Equal]", 
    RowBox[{"Reverse", "[", "plusVahyVlevo", "]"}]}], "\[IndentingNewLine]", 
   "plusVahyVpravo"}]}]], "Input",
 CellChangeTimes->{{3.68268012221875*^9, 3.682680221625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vahyOld", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "3"], 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], ",", 
      "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vahyOld", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaVahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldVahy", ",", "nVah"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"oldVahy", "=", 
       RowBox[{"vahyOld", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nVah", "=", 
       RowBox[{"Length", "[", "oldVahy", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"plusVahyVlevo", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0", "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"nVah", "-", "6"}], "]"}]}], ")"}], ",", 
        "plusVahyVpravo"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"deltaVahy", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    RowBox[{"vahyOld", "[", "n", "]"}], "+", 
    RowBox[{"deltaVahy", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"vahy", "[", "5", "]"}]}], "Input",
 CellChangeTimes->{{3.6826798970625*^9, 3.6826799564375*^9}, {
  3.68267999259375*^9, 3.68267999940625*^9}, {3.6826802885*^9, 
  3.682680427921875*^9}, {3.682680475484375*^9, 3.68268055690625*^9}, {
  3.682682437390625*^9, 3.682682439359375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "ukazkove", " ", "pouziti", " ", "pro", " ", "zjisteni", " ", 
    "amplitudy"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sr", "=", "1000"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "kolik", " ", "samplu", " ", "ODPOVIDA", " ", "jedne", " ", "sekunde"}], 
     ",", " ", 
     RowBox[{"jsou", " ", "to", " ", "ale", " ", "vnitrni", " ", "samply"}]}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "a", " ", "ted", " ", "to", " ", "chosi", " ", "nufozne", " ", "i", " ", 
     "pro", " ", "male", " ", "sr"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dt", "=", 
     FractionBox["1", "sr"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", 
     FractionBox["sr", "171"]}], 
    RowBox[{"(*", 
     RowBox[{
     "jmenovatel", " ", "liche", " ", "cislo", " ", "musi", " ", "byt"}], 
     "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sampluNaPeriodu", "=", 
     FractionBox["T", "dt"]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.682680835875*^9, 3.682681101984375*^9}, {
   3.682681163296875*^9, 3.682681261703125*^9}, {3.682681302640625*^9, 
   3.682681310453125*^9}, {3.68268141225*^9, 3.682681423734375*^9}, {
   3.68268147190625*^9, 3.68268153215625*^9}, {3.68268162078125*^9, 
   3.682681688*^9}, {3.682681730453125*^9, 3.682681797125*^9}, {
   3.68268182890625*^9, 3.6826818575*^9}, {3.68268194740625*^9, 
   3.68268194759375*^9}, 3.68268197934375*^9, {3.68268203828125*^9, 
   3.682682100703125*^9}, {3.682682236125*^9, 3.682682250484375*^9}, {
   3.682682717875*^9, 3.682682740921875*^9}, {3.682683074875*^9, 
   3.6826830856875*^9}, {3.682683170171875*^9, 3.682683203359375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"signalfce", "[", "t_", "]"}], ":=", 
   RowBox[{"1", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"2.", "*", "Pi", "*", "f", "*", "t"}], "+", "0.642"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabSin", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2.", "Pi", "*", "f", "*", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"T", "-", "dt"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabCos", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2.", "Pi", "*", "f", "*", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"T", "-", "dt"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nPeriod", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"signal", "=", 
   RowBox[{"signalfce", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"nPeriod", "*", "T"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "ListPlot"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejAmplitdu", "[", "k_Integer", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dats", ",", "vazky", ",", "nProVahy", ",", "intSin", ",", "intCos"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dats", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"signal", ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"k", "+", "sampluNaPeriodu", "-", "1"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nProVahy", "[", "i_Integer", "]"}], ":=", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", "i"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vazky", "=", 
       RowBox[{
        RowBox[{"vahy", "@", 
         RowBox[{"nProVahy", "[", "sampluNaPeriodu", "]"}]}], "//", "N"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"intSin", "=", 
       RowBox[{"dt", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"tabSin", "*", "dats"}], ")"}], ".", "vazky"}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"intCos", "=", 
       RowBox[{"dt", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"tabCos", "*", "dats"}], ")"}], ".", "vazky"}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       FractionBox["2", "T"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"I", "*", "intCos"}], "+", "intSin"}], ")"}]}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vydejAmplitdu", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "Abs"}]}], "Input",
 CellChangeTimes->{{3.682680835875*^9, 3.682681101984375*^9}, {
   3.682681163296875*^9, 3.682681261703125*^9}, {3.682681302640625*^9, 
   3.682681310453125*^9}, {3.68268141225*^9, 3.682681423734375*^9}, {
   3.68268147190625*^9, 3.68268153215625*^9}, {3.68268162078125*^9, 
   3.682681688*^9}, {3.682681730453125*^9, 3.682681797125*^9}, {
   3.68268182890625*^9, 3.68268185571875*^9}, {3.6826822763125*^9, 
   3.682682299109375*^9}, {3.6826823400625*^9, 3.68268235221875*^9}, {
   3.68268247378125*^9, 3.682682573640625*^9}, {3.682682607078125*^9, 
   3.682682618359375*^9}, {3.682682683828125*^9, 3.682682713015625*^9}, 
   3.682683164203125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rnd", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kNoise", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"signalPeriodical", "[", "t_", "]"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["rnd", 
         RowBox[{
          SuperscriptBox["i", "2"], "+", "1"}]], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["rnd", 
         RowBox[{
          SuperscriptBox["i", "2"], "+", "1"}]], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"signalPeriodical", "[", "t_", "]"}], "=", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", "*", "2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"7", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"5", "*", "2.", "Pi", "*", "f", "*", "t"}], "]"}]}], "+", 
      "5.6"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"signalPeriodical", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noise", ":=", 
   RowBox[{"kNoise", "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68758352684375*^9, 3.68758374578125*^9}, {
   3.68758378496875*^9, 3.687583816125*^9}, 3.68758398015625*^9, {
   3.68758412925*^9, 3.68758413190625*^9}, {3.687584166703125*^9, 
   3.687584216953125*^9}, {3.687584262640625*^9, 3.687584281390625*^9}, {
   3.687585011420551*^9, 3.687585029701801*^9}, 3.687585113983051*^9, {
   3.6875858660611763`*^9, 3.6875859519049263`*^9}, 3.687586025889301*^9, {
   3.6875862256549263`*^9, 3.6875862837174263`*^9}, {3.6875863452486763`*^9, 
   3.687586345326801*^9}, 3.687586531920551*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sr", "=", "4000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dt", "=", 
   FractionBox["1.", "sr"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"signalPeriodical", "[", "#", "]"}], "+", "noise"}]}], "}"}], 
     "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "T"}], ",", "dt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", "data", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intData", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"intData", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "T"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "T"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"intData", "[", "t", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}], "/;", 
    RowBox[{"i", "\[Equal]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["2", "T"], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"intData", "[", "t", "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}], "/;", 
    RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "i_", "]"}], ":=", 
   RowBox[{
    FractionBox["2", "T"], "*", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"intData", "[", "t", "]"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6875840055*^9, 3.687584115515625*^9}, 
   3.687584153984375*^9, 3.68758434115625*^9, {3.68758437253125*^9, 
   3.6875844140299263`*^9}, {3.687584563295551*^9, 3.687584615295551*^9}, {
   3.6875847817799263`*^9, 3.6875848208424263`*^9}, {3.6875848631861763`*^9, 
   3.687584914983051*^9}, {3.687584963233051*^9, 3.687584966545551*^9}, {
   3.687585442920551*^9, 3.687585491733051*^9}, {3.6875855400924263`*^9, 
   3.6875855440924263`*^9}, 3.6875856686236763`*^9, 3.6875857094986763`*^9, 
   3.687585811420551*^9, 3.6875858607799263`*^9, {3.6875860625924263`*^9, 
   3.687586120545551*^9}, 3.687586209983051*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"periodicalReconstruction", "[", "t_", "]"}], "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "0"}], "n"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", "i", "]"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"b", "[", "i", "]"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"2.", "Pi", "*", "f", "*", "t", "*", "i"}], "]"}]}]}], 
       ")"}]}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6875863816236763`*^9, 3.687586420608051*^9}, {
  3.687586488889301*^9, 3.6875864951861763`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"periodicalReconstruction", "[", "t", "]"}], "-", 
    RowBox[{"signalPeriodical", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "T"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6875864333424263`*^9, 3.687586462639301*^9}, {
   3.687586511514301*^9, 3.687586512139301*^9}, {3.688106513265625*^9, 
   3.688106517546875*^9}, 3.6881089505625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"length", "[", "n_", "]"}], ":=", 
   RowBox[{"Length", "[", 
    RowBox[{"vahyOld", "[", "n", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux1", "=", 
   RowBox[{"length", "/@", 
    RowBox[{"Range", "[", "5", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{"aux1", ",", "ni"}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vahyOld", "[", "n_Integer", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "3"], 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], ",", 
      "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Omega]", "=", 
    RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"integral", "[", 
     RowBox[{"nForWeigths_", ",", "nHarm_", ",", "signal_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "weights", ",", "nWeigths", ",", "\[CapitalDelta]t", ",", "times", 
         ",", "functValues", ",", "sinValues", ",", "cosValues", ",", "a", 
         ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"weights", "=", 
         RowBox[{"1.", "*", 
          RowBox[{"vahyOld", "[", "nForWeigths", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nWeigths", "=", 
         RowBox[{"Length", "[", "weights", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[CapitalDelta]t", "=", 
         FractionBox["T", 
          RowBox[{"nWeigths", "-", "1."}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{"times", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "T", ",", "\[CapitalDelta]t"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"functValues", "=", 
         RowBox[{"signal", "/@", "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sinValues", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"\[Omega]", "*", "nHarm", "*", "#"}], "]"}], "&"}], "/@", 
          "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cosValues", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"\[Omega]", "*", "nHarm", "*", "#"}], "]"}], "&"}], "/@", 
          "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{
          FractionBox["2", "T"], "\[CapitalDelta]t", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"cosValues", "*", "functValues"}], ")"}], ".", 
           "weights"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"b", "=", 
         RowBox[{
          FractionBox["2", "T"], "\[CapitalDelta]t", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"sinValues", "*", "functValues"}], ")"}], ".", 
           "weights"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "nHarm"}], "}"}]}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], "/;", 
     RowBox[{"nHarm", ">", "0"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"integral", "[", 
     RowBox[{"nForWeigths_", ",", "nHarm_", ",", "signal_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "weights", ",", "nWeigths", ",", "\[CapitalDelta]t", ",", "times", 
         ",", "functValues", ",", "sinValues", ",", "cosValues", ",", "a", 
         ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"weights", "=", 
         RowBox[{"1.", "*", 
          RowBox[{"vahyOld", "[", "nForWeigths", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nWeigths", "=", 
         RowBox[{"Length", "[", "weights", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[CapitalDelta]t", "=", 
         FractionBox["T", 
          RowBox[{"nWeigths", "-", "1."}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{"times", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "T", ",", "\[CapitalDelta]t"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"functValues", "=", 
         RowBox[{"signal", "/@", "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sinValues", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"\[Omega]", "*", "nHarm", "*", "#"}], "]"}], "&"}], "/@", 
          "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cosValues", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"\[Omega]", "*", "nHarm", "*", "#"}], "]"}], "&"}], "/@", 
          "times"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"a", "=", 
         RowBox[{
          FractionBox["1", "T"], "\[CapitalDelta]t", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"cosValues", "*", "functValues"}], ")"}], ".", 
           "weights"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"b", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "nHarm"}], "}"}]}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], "/;", 
     RowBox[{"nHarm", "==", "0"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux2", "=", 
   RowBox[{"integral", "[", 
    RowBox[{"3", ",", "0", ",", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"5", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Omega]", "*", "#"}], "]"}]}]}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.688106806328125*^9, 3.688106813296875*^9}, {
  3.688106853109375*^9, 3.688106879125*^9}, {3.688106924015625*^9, 
  3.68810694109375*^9}, {3.688106984046875*^9, 3.688107072578125*^9}, {
  3.688107106625*^9, 3.688107200875*^9}, {3.6881075525*^9, 
  3.688107726078125*^9}, {3.68810779478125*^9, 3.68810804465625*^9}, {
  3.6881080814375*^9, 3.688108207109375*^9}, {3.6881082711875*^9, 
  3.68810827159375*^9}, {3.688108329546875*^9, 3.68810835653125*^9}, {
  3.688108396140625*^9, 3.688108453171875*^9}, {3.6881085775625*^9, 
  3.688108610671875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"oneTermOfReconstr", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_"}], "}"}], ",", "nHarm_"}], "}"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Omega]", "*", "nHarm", "*", "t"}], "]"}]}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", "nHarm", "*", "t"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.68810846746875*^9, 3.688108617890625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fourierData", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"integral", "[", 
      RowBox[{"10", ",", "#", ",", "signalPeriodical"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "n"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"recconstructedSignal", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"oneTermOfReconstr", "/@", "fourierData"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"recconstructedSignal", "-", 
    RowBox[{"signalPeriodical", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "T"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.688108653453125*^9, 3.68810885290625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fourierData", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"integral", "[", 
      RowBox[{"10", ",", "#", ",", "intData"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "n"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"recconstructedSignal", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"oneTermOfReconstr", "/@", "fourierData"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"recconstructedSignal", "-", 
    RowBox[{"signalPeriodical", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "T"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6881089358125*^9, 3.688108937984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sr", "=", "101"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"length", "[", "n_", "]"}], ":=", 
   RowBox[{"Length", "[", 
    RowBox[{"vahyOld", "[", "n", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux1", "=", 
   RowBox[{"length", "/@", 
    RowBox[{"Range", "[", "5", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{"aux1", ",", "ni"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "srr"}], ",", "ni"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6881103408125*^9, 3.688110360375*^9}, {
   3.68811041434375*^9, 3.6881104154375*^9}, 3.688110539890625*^9, {
   3.688828903125*^9, 3.68882890428125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nHarmMax", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", "101"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     FractionBox["T", 
      RowBox[{"sr", "-", "1."}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nWeights", "[", "srr_", "]"}], ":=", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "2"]}], "+", 
      FractionBox["srr", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nW", "=", 
     RowBox[{"nWeights", "[", "sr", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nSamples", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"vahyOld", "[", "nW", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"listOfSamples", "=", 
     RowBox[{"signalPeriodical", "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "T", ",", "\[CapitalDelta]t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tableSin", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Omega]", "*", "t", "*", "nH"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "1", ",", "nHarmMax", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T", ",", "\[CapitalDelta]t"}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tableCos", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"\[Omega]", "*", "t", "*", "nH"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "1", ",", "nHarmMax", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T", ",", "\[CapitalDelta]t"}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "integralData", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"integralData", "[", 
      RowBox[{"listOfSamples_", ",", "nHarm_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"weights", ",", "a", ",", "b"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"weights", "=", 
          RowBox[{"1.", "*", 
           RowBox[{"vahyOld", "[", "nW", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{
           FractionBox["2", "T"], "\[CapitalDelta]t", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"tableCos", "[", 
               RowBox[{"[", "nHarm", "]"}], "]"}], "*", "listOfSamples"}], 
             ")"}], ".", "weights"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"b", "=", 
          RowBox[{
           FractionBox["2", "T"], "\[CapitalDelta]t", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"tableSin", "[", 
               RowBox[{"[", "nHarm", "]"}], "]"}], "*", "listOfSamples"}], 
             ")"}], ".", "weights"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], ",", "nHarm"}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}], "/;", 
      RowBox[{"nHarm", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"integralData", "[", 
      RowBox[{"listOfSamples_", ",", "nHarm_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"weights", ",", "a", ",", "b"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"weights", "=", 
          RowBox[{"1.", "*", 
           RowBox[{"vahyOld", "[", "nW", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{
           FractionBox["1", "T"], "\[CapitalDelta]t", "*", 
           RowBox[{
            RowBox[{"(", "listOfSamples", ")"}], ".", "weights"}]}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "0"}], "}"}], ",", "nHarm"}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}], "/;", 
      RowBox[{"nHarm", "\[Equal]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"integralData", "[", 
     RowBox[{"listOfSamples", ",", "0"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.68811042421875*^9, 3.688110715515625*^9}, {
  3.68811074946875*^9, 3.688110833578125*^9}, {3.688110879890625*^9, 
  3.688111119640625*^9}, {3.68811118965625*^9, 3.68811136325*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fourierData", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"integralData", "[", 
      RowBox[{"listOfSamples", ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "n"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"recconstructedSignal", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"oneTermOfReconstr", "/@", "fourierData"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"recconstructedSignal", "-", 
    RowBox[{"signalPeriodical", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "T"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.688111381390625*^9, 3.68811139615625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kNoise", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noise", ":=", 
   RowBox[{"kNoise", "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataNoised", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"#", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.0", "#"}]}], ")"}]}], "]"}], "+", "noise"}]}], "}"}], 
     "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.01"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nAV", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MovingAverage", "[", 
    RowBox[{"dataNoised", ",", "nAV"}], "]"}], "//", "ListPlot"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6887952102672215`*^9, 3.6887952845640965`*^9}, {
  3.6887953149234715`*^9, 3.6887953288453465`*^9}, {3.6887954030015965`*^9, 
  3.6887954883609715`*^9}, {3.6887955677828465`*^9, 3.6887955681890965`*^9}, {
  3.6887958563922215`*^9, 3.6887958815640965`*^9}, {3.6887974018297215`*^9, 
  3.6887974365484715`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nAV", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"weigths1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"#", "-", 
        RowBox[{"0.5", "nAV"}]}], ")"}], "2"], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "nAV", ",", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "ListPlot"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"weigths2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.5", 
       SuperscriptBox["nAV", "2"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"#", "-", 
         RowBox[{"0.5", "nAV"}]}], ")"}], "2"]}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "nAV", ",", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "ListPlot"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MovingAverage", "[", 
   RowBox[{"dataNoised", ",", "weigths2"}], "]"}], "//", 
  "ListPlot"}]}], "Input",
 CellChangeTimes->{{3.6887956302984715`*^9, 3.6887956688297215`*^9}, {
  3.6887956988453465`*^9, 3.6887958214703465`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x0", ",", "3"}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"x0", "+", "\[CapitalDelta]x"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x0", ",", "3"}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"x0", "-", "\[CapitalDelta]x"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"%%", "-", "%"}]}], "Input",
 CellChangeTimes->{{3.6887960964859715`*^9, 3.6887961234234715`*^9}, {
  3.6887961608765965`*^9, 3.6887961775172215`*^9}, {3.6887962298297215`*^9, 
  3.6887962675328465`*^9}, {3.6887963057984715`*^9, 3.6887963082828465`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der1", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "+", "\[CapitalDelta]x"}], "]"}], "-", 
     RowBox[{"f", "[", "x", "]"}]}], "\[CapitalDelta]x"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "+", "\[CapitalDelta]x"}], "]"}], "-", 
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "\[CapitalDelta]x"}], "]"}]}], 
    RowBox[{"2", "\[CapitalDelta]x"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"function", "=", "Sin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"function", "'"}], "[", "x", "]"}], "-", 
      RowBox[{"der1", "[", "function", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"function", "'"}], "[", "x", "]"}], "-", 
      RowBox[{"der2", "[", "function", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thick", ",", "#"}], "}"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}], "]"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6887963557515965`*^9, 3.6887966065484715`*^9}, 
   3.6887974678453465`*^9, {3.688829319546875*^9, 3.688829356984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nAv", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat3", "=", 
   RowBox[{"MovingAverage", "[", 
    RowBox[{"dataNoised", ",", "nAv"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der2Points", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t1_", ",", "val1_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t2_", ",", "val2_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"t1", ",", 
     FractionBox[
      RowBox[{"val2", "-", "val1"}], 
      RowBox[{"t2", "-", "t1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataForDer2Points", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{"dat3", ",", "2", ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataOfDerivative2Points", "=", 
   RowBox[{"der2Points", "/@", "dataForDer2Points"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptsize", "=", "0.005"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dataOfDerivative2Points", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "ptsize", "]"}], ",", "Red"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der3Points", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t1_", ",", "val1_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t2_", ",", "val2_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t3_", ",", "val3_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"t2", ",", 
     FractionBox[
      RowBox[{"val3", "-", "val1"}], 
      RowBox[{"t3", "-", "t1"}]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataForDer3Points", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{"dat3", ",", "3", ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataOfDerivative3Points", "=", 
   RowBox[{"der3Points", "/@", "dataForDer3Points"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dataOfDerivative3Points", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "ptsize", "]"}], ",", "Blue"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", "plot2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6887966468453465`*^9, 3.6887967095953465`*^9}, {
   3.6887967614703465`*^9, 3.6887968810953465`*^9}, {3.6887969358140965`*^9, 
   3.6887970371109715`*^9}, {3.6887970852672215`*^9, 
   3.6887971062047215`*^9}, {3.6887971519703465`*^9, 3.6887973797047215`*^9}, 
   3.6887974176578465`*^9, {3.6887974523140965`*^9, 3.6887974600328465`*^9}, 
   3.6887990277672215`*^9, {3.6888001322359715`*^9, 3.6888001326422215`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nAv", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat3", "=", 
   RowBox[{"MovingAverage", "[", 
    RowBox[{"dataNoised", ",", "nAv"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polyOrder", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lehtgOfAPieceOfData", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"picesOfData", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{"dat3", ",", "lehtgOfAPieceOfData", ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"der4", "[", 
     RowBox[{"pieceOfData_List", ",", "polyOrder_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fit", ",", "functions", ",", "x", ",", "derValue", ",", "xValue"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"functions", "=", 
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "#"], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "polyOrder"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fit", "=", 
        RowBox[{"Fit", "[", 
         RowBox[{"pieceOfData", ",", "functions", ",", "x"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xValue", "=", 
        RowBox[{"pieceOfData", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"derValue", "=", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"fit", ",", "x"}], "]"}], "/.", 
         RowBox[{"x", "->", "xValue"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"xValue", ",", "derValue"}], "}"}]}]}], "\[IndentingNewLine]",
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataOfDerFromFit", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"der4", "[", 
      RowBox[{"#", ",", "polyOrder"}], "]"}], "&"}], "/@", "picesOfData"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "dataOfDerFromFit", "]"}]}], "Input",
 CellChangeTimes->{{3.6887990437515965`*^9, 3.6887990644234715`*^9}, {
   3.6887991113609715`*^9, 3.6887991426109715`*^9}, {3.6887994555640965`*^9, 
   3.6887995645953465`*^9}, 3.6887996167515965`*^9, {3.6887996798453465`*^9, 
   3.6887997293140965`*^9}, {3.6887997770953465`*^9, 
   3.6887998043609715`*^9}, {3.6887998403609715`*^9, 
   3.6887998447359715`*^9}, {3.6887998753922215`*^9, 
   3.6888000192984715`*^9}, {3.6888000893922215`*^9, 3.6888002340015965`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "comparisonOfErrors", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"comparisonOfErrors", "[", 
    RowBox[{"{", 
     RowBox[{"kNoise_", ",", "seedRandom_Integer", ",", "nAv_Integer"}], 
     "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"noise", ",", 
       RowBox[{"nSamples", "=", "2001"}], ",", 
       RowBox[{"nTake", "=", "713"}], ",", "dataNoised", ",", "der2Points", 
       ",", "dataForDer2Points", ",", "dataOfDerivative2Points", ",", 
       "signal", ",", "plder", ",", "nWeights", ",", "vahy", ",", 
       "\[CapitalDelta]t", ",", "int", ",", "intNInt", ",", "t1", ",", "t2", 
       ",", "t", ",", "dataPure", ",", "rn", ",", "dataNoisedFiltered", ",", 
       "dats", ",", "intDataPure", ",", "intDataNoised", ",", "intNIntNoised",
        ",", "ints", ",", "intNIntPure", ",", "numIntNoised", ",", 
       "numIntPure", ",", "intsNum", ",", "plints", ",", "intIntegrals", ",", 
       "ourInts", ",", "integralExact", ",", "ourErrors", ",", 
       "nIntegrateErrors", ",", "plDer", ",", "ourEffDer", ",", "pureEffDer", 
       ",", "errorOfEffDer"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SeedRandom", "[", "seedRandom", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"noise", ":=", 
       RowBox[{"kNoise", "*", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"signal", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"#", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.1", "#"}]}], ")"}]}], "]"}], "&"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dataNoised", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{
            RowBox[{"signal", "[", "#", "]"}], "+", "noise"}]}], "}"}], "&"}],
         "/@", 
        RowBox[{"(", 
         RowBox[{"rn", "=", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", 
            RowBox[{"4", "Pi"}], ",", 
            RowBox[{"\[CapitalDelta]t", "=", 
             FractionBox[
              RowBox[{"4", "Pi"}], 
              RowBox[{"nSamples", "-", "1"}]]}]}], "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dataPure", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"signal", "[", "#", "]"}]}], "}"}], "&"}], "/@", "rn"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"dataNoisedFiltered", "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Take", "[", 
           RowBox[{"#", ",", "nTake"}], "]"}], "&"}], "@", 
         RowBox[{"MovingAverage", "[", 
          RowBox[{"dataNoised", ",", "nAv"}], "]"}]}], "//", "N"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t1", ",", "t2"}], "}"}], "=", 
       RowBox[{"First", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"dataNoisedFiltered", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dats", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Select", "[", 
          RowBox[{"#", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"t1", "-", 
              RowBox[{
               StyleBox["0.499",
                FontColor->RGBColor[1, 0, 0]], "\[CapitalDelta]t"}]}], 
             "\[LessEqual]", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
             RowBox[{"t2", "+", 
              RowBox[{
               StyleBox["0.5",
                FontColor->RGBColor[1, 0, 0]], "\[CapitalDelta]t"}]}]}], 
            "&"}]}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"dataNoised", ",", "dataPure", ",", "dataNoisedFiltered"}], 
         "}"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ints", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"#", ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}], "&"}], "/@",
         "dats"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"intIntegrals", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Quiet", "@", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{"#", "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]}], "&"}], "/@",
         "ints"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nWeights", "=", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "2"]}], "+", 
        FractionBox["nTake", "2"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vahy", "=", 
       RowBox[{
        FractionBox["1.", "3"], 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
             RowBox[{"Range", "[", 
              RowBox[{
               RowBox[{"2", "nWeights"}], "+", "1"}], "]"}]}], ",", "1"}], 
           "]"}], ",", "1"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"int", "[", "data_", "]"}], ":=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Last", "/@", "data"}], ")"}], ".", "vahy"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ourInts", "=", 
       RowBox[{"int", "/@", "dats"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"integralExact", "=", 
       RowBox[{"intIntegrals", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ourErrors", ",", "nIntegrateErrors"}], "}"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"ourInts", ",", "intIntegrals"}], "}"}], "/.", 
        RowBox[{"int_Real", "\[RuleDelayed]", 
         RowBox[{
          FractionBox["1.", "integralExact"], "*", 
          RowBox[{"(", 
           RowBox[{"int", "-", "integralExact"}], ")"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"der2Points", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t1_", ",", "val1_"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t2_", ",", "val2_"}], "}"}]}], "}"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{"t1", ",", 
         FractionBox[
          RowBox[{"val2", "-", "val1"}], 
          RowBox[{"t2", "-", "t1"}]]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dataForDer2Points", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{"#", ",", 
              RowBox[{"nTake", "+", "1"}]}], "]"}], "&"}], "@", 
           RowBox[{"MovingAverage", "[", 
            RowBox[{"dataNoised", ",", "nAv"}], "]"}]}], "//", "N"}], ",", 
         "2", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dataOfDerivative2Points", "=", 
       RowBox[{"der2Points", "/@", "dataForDer2Points"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"plDer", "=", 
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"ListPlot", "[", 
          RowBox[{"dataOfDerivative2Points", ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PointSize", "[", "0.005", "]"}], ",", "Red"}], 
             "}"}]}]}], "]"}], ",", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"signal", "'"}], "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"ourEffDer", "=", 
       RowBox[{"int", "[", 
        RowBox[{"dataOfDerivative2Points", "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t_", ",", "u_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            SuperscriptBox["u", "2"]}], "}"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pureEffDer", "=", 
       RowBox[{"int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"#", ",", 
            SuperscriptBox[
             RowBox[{
              RowBox[{"signal", "'"}], "[", "#", "]"}], "2"]}], "}"}], "&"}], 
         "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"t1", ",", "t2", ",", "\[CapitalDelta]t"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"errorOfEffDer", "=", 
       RowBox[{"Abs", "@", 
        FractionBox[
         RowBox[{"ourEffDer", "-", "pureEffDer"}], "pureEffDer"]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<{ourErrors,nIntegrateErrors}= \>\"", ",", 
        RowBox[{"100", "*", 
         RowBox[{"{", 
          RowBox[{"ourErrors", ",", "nIntegrateErrors"}], "}"}]}], ",", 
        "\"\< %\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<errorOfEffDer= \>\"", ",", 
        RowBox[{"100", "errorOfEffDer"}], ",", "\"\< %\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ListPlot", "[", 
           RowBox[{"#", ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "0.005", "]"}], ",", "Red"}], 
              "}"}]}]}], "]"}], "&"}], "/@", "dats"}], ",", "plDer"}], "}"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"plints", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Quiet", "@", 
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"#", "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]}], "&"}], "/@",
         "ints"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"plints", ",", "plDer"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"comparisonOfErrors", "[", 
  RowBox[{"{", 
   RowBox[{"0.06", ",", "1", ",", "20"}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.688832866234375*^9, 3.6888329185625*^9}, {
   3.688832950984375*^9, 3.68883296615625*^9}, {3.68883302090625*^9, 
   3.68883304309375*^9}, {3.688833159609375*^9, 3.688833180359375*^9}, {
   3.6888332109375*^9, 3.688833309109375*^9}, {3.688833352890625*^9, 
   3.68883339140625*^9}, {3.688833421796875*^9, 3.688833523421875*^9}, {
   3.68883356434375*^9, 3.688833651890625*^9}, {3.688833692984375*^9, 
   3.688833735328125*^9}, {3.6888337725*^9, 3.688833811015625*^9}, {
   3.688833891171875*^9, 3.688833909390625*^9}, {3.68883396471875*^9, 
   3.68883409325*^9}, {3.688834143640625*^9, 3.6888341441875*^9}, {
   3.688834183078125*^9, 3.688834225859375*^9}, {3.688834382328125*^9, 
   3.688834488875*^9}, {3.688834534015625*^9, 3.688834569640625*^9}, {
   3.68883461246875*^9, 3.688834780890625*^9}, {3.68883490484375*^9, 
   3.688835032046875*^9}, {3.688835062203125*^9, 3.688835105109375*^9}, 
   3.688835157140625*^9, {3.68883524265625*^9, 3.688835281203125*^9}, {
   3.68883536915625*^9, 3.68883540365625*^9}, {3.688835504234375*^9, 
   3.688835579734375*^9}, {3.688835610265625*^9, 3.68883566290625*^9}, {
   3.68883570409375*^9, 3.688835704515625*^9}, {3.68883573471875*^9, 
   3.68883577003125*^9}, {3.688835993984375*^9, 3.6888360163125*^9}, {
   3.688836051140625*^9, 3.688836057453125*^9}, {3.68883617853125*^9, 
   3.68883624946875*^9}, {3.68883633696875*^9, 3.68883638715625*^9}, {
   3.688836426421875*^9, 3.68883647859375*^9}, {3.688836508875*^9, 
   3.688836583921875*^9}, {3.688836614640625*^9, 3.688836621765625*^9}, {
   3.68883666584375*^9, 3.68883673509375*^9}, {3.688836790078125*^9, 
   3.68883680909375*^9}, {3.688836839984375*^9, 3.688837000734375*^9}, {
   3.688837068296875*^9, 3.688837084921875*^9}, 3.68883713271875*^9, {
   3.68883722878125*^9, 3.688837234890625*^9}, 3.688837326953125*^9, {
   3.68883738203125*^9, 3.688837431359375*^9}, {3.688837484640625*^9, 
   3.688837561328125*^9}, {3.688837619140625*^9, 3.688837836515625*^9}, {
   3.688837873765625*^9, 3.688837945203125*^9}, {3.688837982515625*^9, 
   3.6888382468125*^9}, {3.68883850875*^9, 3.6888385288125*^9}, {
   3.688838565171875*^9, 3.6888385688125*^9}, {3.688838660171875*^9, 
   3.688838733328125*^9}, {3.688838765015625*^9, 3.688838791421875*^9}, {
   3.688838882421875*^9, 3.688838895484375*^9}, {3.688838947046875*^9, 
   3.68883898078125*^9}, {3.688869280796875*^9, 3.6888693384375*^9}}]
},
WindowSize->{1090, 790},
WindowMargins->{{9, Automatic}, {Automatic, 5}},
ShowSelection->True,
Magnification->1.3999992609024048`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 513, 13, 91, "Input"],
Cell[1073, 35, 1368, 42, 144, "Input"],
Cell[2444, 79, 411, 11, 66, "Input"],
Cell[2858, 92, 179, 3, 40, "Input"],
Cell[3040, 97, 327, 9, 66, "Input"],
Cell[3370, 108, 359, 10, 66, "Input"],
Cell[3732, 120, 133, 2, 40, "Input"],
Cell[3868, 124, 575, 16, 145, "Input"],
Cell[4446, 142, 2052, 55, 294, "Input"],
Cell[6501, 199, 1866, 45, 297, "Input"],
Cell[8370, 246, 3685, 102, 525, "Input"],
Cell[12058, 350, 3045, 82, 409, "Input"],
Cell[15106, 434, 3127, 86, 382, "Input"],
Cell[18236, 522, 764, 21, 74, "Input"],
Cell[19003, 545, 520, 12, 40, "Input"],
Cell[19526, 559, 411, 11, 91, "Input"],
Cell[19940, 572, 6590, 170, 1201, "Input"],
Cell[26533, 744, 579, 17, 66, "Input"],
Cell[27115, 763, 793, 21, 91, "Input"],
Cell[27911, 786, 783, 21, 91, "Input"],
Cell[28697, 809, 774, 19, 141, "Input"],
Cell[29474, 830, 4748, 128, 810, "Input"],
Cell[34225, 960, 783, 21, 91, "Input"],
Cell[35011, 983, 1451, 40, 216, "Input"],
Cell[36465, 1025, 1183, 37, 172, "Input"],
Cell[37651, 1064, 972, 24, 116, "Input"],
Cell[38626, 1090, 1612, 47, 225, "Input"],
Cell[40241, 1139, 2970, 82, 403, "Input"],
Cell[43214, 1223, 2611, 65, 401, "Input"],
Cell[45828, 1290, 13250, 322, 1312, "Input"]
}
]
*)

(* End of internal cache information *)
