(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39706,       1028]
NotebookOptionsPosition[     39060,       1005]
NotebookOutlinePosition[     39461,       1022]
CellTagsIndexPosition[     39418,       1019]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", "pom"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejNx5", "[", "listDat_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
        "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
        RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
        "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
        ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
        "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"sd2", "[", "list_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
          RowBox[{
           RowBox[{"mean", "=", 
            RowBox[{"Mean", "[", "list", "]"}]}], ";", 
           RowBox[{"mean2", "=", 
            RowBox[{"Mean", "[", 
             RowBox[{"list", "*", "list"}], "]"}]}], ";", 
           RowBox[{"mean2", "-", 
            SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"aclist", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"nSampl", "=", 
        RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rn", "=", 
            RowBox[{"Range", "[", 
             RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"soucty", "=", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"aclist", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                RowBox[{"aclist", "[", 
                 RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
             ")"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigma", "=", 
            RowBox[{
             FractionBox["1.", 
              SuperscriptBox["nOkno", "2"]], 
             RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]",
          "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"mozne", "=", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"start", "=", 
        RowBox[{"fce", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Round", "[", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mozne", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"mozne", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n", "<", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"n", ">", 
             RowBox[{"mozne", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}], ",", 
            RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"krok", "[", 
         RowBox[{"body", ":", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"yka", "=", 
            RowBox[{"body", "/.", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"miny", "=", 
            RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nb", "=", 
            RowBox[{"Which", "[", 
             RowBox[{
              RowBox[{"miny", "\[Equal]", "y2"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"miny", "\[Equal]", "y3"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x3", "+", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}],
               ",", 
              RowBox[{"miny", "\[Equal]", "y1"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x1", "-", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
               "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Sort", "[", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"Sort", "[", 
                RowBox[{
                 RowBox[{"Union", "[", 
                  RowBox[{"nb", ",", "body"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", 
                   RowBox[{"#2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
               "3"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", 
               RowBox[{"#2", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"nx", "=", 
        FractionBox[
         RowBox[{"y1", "+", 
          RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
          RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
          RowBox[{"2", " ", "x2", " ", "y3"}]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ykvref", "=", 
        RowBox[{"Total", "[", 
         SuperscriptBox[
          RowBox[{"Take", "[", 
           RowBox[{"listDat", ",", 
            RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"varmin", "=", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["y1", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "y1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"y1", "-", 
             RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"pomer", "=", 
        FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "=", 
          FractionBox[
           RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
         RowBox[{"100", "*", 
          RowBox[{"(", 
           RowBox[{"k\[Omega]", "-", 
            FractionBox["f", "fnom"]}], ")"}]}], ",", 
         RowBox[{
          SuperscriptBox["10", "6"], 
          SuperscriptBox["sr", "2"], 
          FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"resampluj", "[", 
     RowBox[{"list_List", ",", "nNorm_", ",", "nx_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ourInt", ",", "index", ",", "indexs", ",", "meritko"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ourInt", "[", 
         RowBox[{"x_", ",", "dats_"}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p", ",", "a", ",", "b", ",", "ya", ",", "yb", ",", "yx"}],
            "}"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b"}], "}"}], "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Floor", "[", "x", "]"}], ",", 
               RowBox[{"Ceiling", "[", "x", "]"}]}], "}"}]}]}], ";", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ya", ",", "yb"}], "}"}], "=", 
            RowBox[{"dats", "[", 
             RowBox[{"[", "p", "]"}], "]"}]}], ";", 
           RowBox[{"yx", "=", 
            RowBox[{"ya", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "a"}], ")"}], "*", 
              FractionBox[
               RowBox[{"yb", "-", "ya"}], 
               RowBox[{"b", "-", "a"}]]}]}]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"meritko", "=", 
        FractionBox[
         RowBox[{"nx", "-", "1"}], 
         RowBox[{"nNorm", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"index", "[", "x_", "]"}], ":=", 
        RowBox[{"1.", "+", 
         RowBox[{"x", "*", "meritko"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"indexs", "=", 
        RowBox[{"index", "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"nNorm", "-", "1"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ourInt", "[", 
            RowBox[{"#", ",", "list"}], "]"}], "&"}], "/@", "indexs"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fazor1harm", "[", "list_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a1", ",", "b1", ",", "int", ",", "vahy", ",", "vazky"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
             RowBox[{"Range", "[", 
              RowBox[{
               RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], 
          ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"vazky", "=", 
        RowBox[{"vahy", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["sr", "2"]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"int", "[", 
         RowBox[{"listHodnot_", ",", "listVah_"}], "]"}], ":=", 
        RowBox[{
         FractionBox["2.", 
          RowBox[{"3", "sr"}]], 
         RowBox[{"vazky", ".", 
          RowBox[{"(", 
           RowBox[{"listHodnot", "*", "listVah"}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"a1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", "cosTab"}], "]"}]}], ";", 
       RowBox[{"b1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", "sinTab"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"b1", "+", 
        RowBox[{"I", "*", "a1"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejFazor", "[", "list_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Delta]", ",", "var", ",", "pomer", ",", "newDat", ",", 
       "fazor"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "\[Delta]", ",", "var", ",", "pomer"}], "}"}], "=", 
       RowBox[{"vydejNx5", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"newDat", "=", 
       RowBox[{"resampluj", "[", 
        RowBox[{"list", ",", 
         RowBox[{"sr", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sr", "+", "1"}], ")"}], "*", "pomer"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fazor", "=", 
       RowBox[{"fazor1harm", "[", "newDat", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "f", ",", "\[Delta]", ",", "var", ",", "pomer", ",", "fazor", ",", 
        RowBox[{"Abs", "[", "fazor", "]"}], ",", 
        RowBox[{"Arg", "[", "fazor", "]"}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.7523806680625*^9, 3.752380690125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"2", "*", 
      RowBox[{"Round", "[", 
       FractionBox["48000", 
        RowBox[{"2", "*", "50"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sinTab", "=", 
     RowBox[{"Sin", "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", 
        RowBox[{"2.", "Pi"}], ",", 
        RowBox[{"2.", 
         FractionBox["Pi", "sr"]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cosTab", "=", 
     RowBox[{"Cos", "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", 
        RowBox[{"2.", "Pi"}], ",", 
        RowBox[{"2.", 
         FractionBox["Pi", "sr"]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kperSampl", "=", "1.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k\[Omega]", "=", "1.023"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"k\[Omega]", "*", "2.", "*", "Pi", "*", "fnom"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tnom", "=", 
     RowBox[{
      FractionBox["Tnom", "sr"], "//", "N"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.591248592265625*^9, 3.591248638765625*^9, {3.591248692484375*^9, 
   3.591248693125*^9}, {3.59124894825*^9, 3.591248998703125*^9}, {
   3.591249110484375*^9, 3.59124911196875*^9}, {3.591249147203125*^9, 
   3.591249147359375*^9}, 3.591249182125*^9, {3.591249215109375*^9, 
   3.591249239984375*^9}, 3.591249279671875*^9, {3.591250220390625*^9, 
   3.59125022371875*^9}, {3.591250276796875*^9, 3.59125032821875*^9}, {
   3.59125275034375*^9, 3.591252751078125*^9}, {3.59126424884375*^9, 
   3.591264249921875*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"sum", ",", "errPQ", ",", "tvor", ",", "simpleErr"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tvor", "[", "vyrt_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{"vyrt", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
        "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sum", "[", 
      RowBox[{"k_", ",", "seedRandom_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SeedRandom", "[", "seedRandom", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k", "*", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"RandomReal", "[", 
            RowBox[{"NormalDistribution", "[", 
             RowBox[{"0.0", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}],
             "}"}]}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"errPQ", "[", 
      RowBox[{
      "aU_", ",", "fiU_", ",", "aI_", ",", "fiI_", ",", "kU_", ",", "kI_", 
       ",", "seeRU_", ",", "seeRI_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sU", ",", "sI", ",", "fU", ",", "\[Delta]U", ",", "varU", ",", 
         "pomerU", ",", "fazorU", ",", "absfazorU", ",", "argfazorU", ",", 
         "fI", ",", "\[Delta]I", ",", "varI", ",", "pomerI", ",", "fazorI", 
         ",", "absfazorI", ",", "argfazorI", ",", "P", ",", "Pmer", ",", 
         "Smer", ",", "Q", ",", "Qmer"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sU", "=", 
         RowBox[{
          RowBox[{"tvor", "[", 
           RowBox[{"Im", "[", 
            RowBox[{"aU", "*", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{"(", 
                RowBox[{"fiU", "+", 
                 RowBox[{"\[Omega]", "*", "t"}]}], ")"}]}], "]"}]}], "]"}], 
           "]"}], "+", 
          RowBox[{"aU", "*", 
           RowBox[{"sum", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox["10", 
               RowBox[{"-", "2"}]], "kU"}], ",", "seeRU"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sI", "=", 
         RowBox[{
          RowBox[{"tvor", "[", 
           RowBox[{"Im", "[", 
            RowBox[{"aI", "*", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{"(", 
                RowBox[{"fiI", "+", 
                 RowBox[{"\[Omega]", "*", "t"}]}], ")"}]}], "]"}]}], "]"}], 
           "]"}], "+", 
          RowBox[{"aI", "*", 
           RowBox[{"sum", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox["10", 
               RowBox[{"-", "2"}]], "kI"}], ",", "seeRI"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "fU", ",", "\[Delta]U", ",", "varU", ",", "pomerU", ",", "fazorU", 
           ",", "absfazorU", ",", "argfazorU"}], "}"}], "=", 
         RowBox[{"vydejFazor", "[", "sU", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "fI", ",", "\[Delta]I", ",", "varI", ",", "pomerI", ",", "fazorI", 
           ",", "absfazorI", ",", "argfazorI"}], "}"}], "=", 
         RowBox[{"vydejFazor", "[", "sI", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Smer", "=", 
         RowBox[{"fazorU", "*", 
          RowBox[{"Conjugate", "[", "fazorI", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"P", "=", 
         RowBox[{"0.5", "*", "aU", "*", "aI", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"fiU", "-", "fiI"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Pmer", "=", 
         RowBox[{"0.5", "*", 
          RowBox[{"Re", "[", "Smer", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Q", "=", 
         RowBox[{"0.5", "*", "aU", "*", "aI", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"fiU", "-", "fiI"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Qmer", "=", 
         RowBox[{"0.5", "*", 
          RowBox[{"Im", "[", "Smer", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"fU", ",", "fI"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Delta]U", ",", "\[Delta]I"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"varU", ",", "varI"}], "}"}], ",", 
          RowBox[{"100", "*", 
           RowBox[{"{", 
            RowBox[{
             FractionBox[
              RowBox[{"P", "-", "Pmer"}], "P"], ",", 
             FractionBox[
              RowBox[{"Q", "-", "Qmer"}], "Q"]}], "}"}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"simpleErr", "[", "k_", "]"}], ":=", 
     RowBox[{"errPQ", "[", 
      RowBox[{
      "10", ",", "0.2", ",", "2", ",", "0.7", ",", "k", ",", "k", ",", "2", 
       ",", "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simpleErr", "[", "0.01", "]"}], "//", "Timing"}]}]}]], "Input",
 CellChangeTimes->{
  3.59125034221875*^9, {3.591250418421875*^9, 3.59125044421875*^9}, {
   3.591250537328125*^9, 3.59125069828125*^9}, {3.591250730640625*^9, 
   3.59125081846875*^9}, {3.5912508563125*^9, 3.59125093584375*^9}, {
   3.591250997640625*^9, 3.59125106678125*^9}, {3.591251098734375*^9, 
   3.591251141375*^9}, {3.591251201875*^9, 3.59125120203125*^9}, 
   3.59125127034375*^9, {3.591251349796875*^9, 3.59125153921875*^9}, {
   3.59125158915625*^9, 3.591251814375*^9}, {3.59125198590625*^9, 
   3.59125215734375*^9}, {3.591252234109375*^9, 3.591252623640625*^9}, {
   3.59125269428125*^9, 3.591252712703125*^9}, {3.59125276253125*^9, 
   3.5912527645*^9}, {3.591262377109375*^9, 3.591262451578125*^9}, {
   3.591262494171875*^9, 3.591262524390625*^9}, {3.59126302990625*^9, 
   3.59126304740625*^9}, {3.59126308921875*^9, 3.591263238546875*^9}, {
   3.591263352875*^9, 3.591263370390625*^9}, 3.591263474828125*^9, {
   3.59126352103125*^9, 3.5912635475*^9}, 3.59126414659375*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pmax", "=", "12"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pmin", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"np", "=", "80"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qp", "=", 
     RadicalBox[
      FractionBox["pmax", "pmin"], "np"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnp", "=", 
     RowBox[{"pmin", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["qp", "#"], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "np"}], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dats", "=", 
     RowBox[{"simpleErr", "/@", "rnp"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"errP", "=", 
     RowBox[{"dats", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"fU_", ",", "fI_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Delta]U_", ",", "\[Delta]I_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"varU_", ",", "varI_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Delta]P_", ",", "\[Delta]Q_"}], "}"}]}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varU", "+", "varI"}], ",", 
         RowBox[{"Abs", "[", "\[Delta]P", "]"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"lpl0", "=", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{"errP", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ln(\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\))\>\"", ",", 
         "\"\<\[Delta]P [%]\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"errQ", "=", 
     RowBox[{"dats", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"fU_", ",", "fI_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Delta]U_", ",", "\[Delta]I_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"varU_", ",", "varI_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Delta]P_", ",", "\[Delta]Q_"}], "}"}]}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varU", "+", "varI"}], ",", 
         RowBox[{"Abs", "[", "\[Delta]Q", "]"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"lpl1", "=", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{"errQ", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<ln(\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\))\>\"", ",", 
         "\"\<\[Delta]Q [%]\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5912635666875*^9, 3.59126372225*^9}, {
   3.591263914953125*^9, 3.591263923921875*^9}, 3.591264199546875*^9, {
   3.591264263609375*^9, 3.591264270671875*^9}, {3.5913421815625*^9, 
   3.591342195390625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"errPQ", "[", 
   RowBox[{
   "10", ",", "0.2", ",", "2", ",", "0.8", ",", "4", ",", "4", ",", "3", ",", 
    "3"}], "]"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.591262312796875*^9, 3.591262315015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sigmaSum", "=", "0.0001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplSampl", "=", "5.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fiSampl", "=", "0.2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcepom1", "[", "t_", "]"}], ":=", 
   RowBox[{"amplSampl", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"\[Omega]", "*", "t"}], "+", "fiSampl"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fcepom", "[", "t_", "]"}], ":=", 
    RowBox[{"fcepom1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "3", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sums", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0.0", ",", "sigmaSum"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datsignal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"fcepom", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dSpom", "=", 
   RowBox[{"sums", "+", "datsignal"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plSamples", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dSpom", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.005", "]"}], ",", 
        RowBox[{"Hue", "[", "0.666", "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [-]\>\"", ",", "\"\<uSample [V]\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plsigsamps", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"datsignal", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.005", "]"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [-]\>\"", ",", "\"\<uSample [V]\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plobe", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plSamples", ",", "plsigsamps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.591248592265625*^9, 3.591248638765625*^9, {3.591248692484375*^9, 
   3.591248693125*^9}, {3.59124894825*^9, 3.591248998703125*^9}, {
   3.591249110484375*^9, 3.59124911196875*^9}, {3.591249147203125*^9, 
   3.591249147359375*^9}, 3.591249182125*^9, {3.591249215109375*^9, 
   3.591249239984375*^9}, 3.591249279671875*^9, {3.591250220390625*^9, 
   3.59125022371875*^9}, {3.591250276796875*^9, 3.59125032821875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "errf", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "3", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sums1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0.0", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"errf", "[", "k_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "dats", "}"}], ",", 
     RowBox[{
      RowBox[{"dats", "=", 
       RowBox[{
        RowBox[{"k", "*", "sums1"}], "+", "datsignal"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vydejNx5", "[", "dats", "]"}], "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"f_", ",", "\[Delta]_", ",", "var_", ",", "pomer_"}], "}"}], 
        "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Abs", "[", "var", "]"}], "]"}], ",", 
          RowBox[{"Abs", "[", "\[Delta]", "]"}]}], "}"}]}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datchyb", "=", 
   RowBox[{"errf", "/@", 
    RowBox[{"(", 
     RowBox[{"0.3", "rnp"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plf", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"datchyb", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ln(\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\))\>\"", ",", 
       "\"\<\[Delta]f [%]\>\""}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.591094226046875*^9, 3.591094502421875*^9}, {
   3.591094541546875*^9, 3.5910947903125*^9}, {3.591094838421875*^9, 
   3.591094857*^9}, {3.59109488846875*^9, 3.5910948925*^9}, {
   3.591094959203125*^9, 3.591094969375*^9}, {3.591095125015625*^9, 
   3.591095165921875*^9}, {3.591095215671875*^9, 3.591095268328125*^9}, 
   3.59109530565625*^9, {3.59109630196875*^9, 3.591096304609375*^9}, {
   3.59109749121875*^9, 3.5910975080625*^9}, 3.591188123046875*^9, {
   3.5911881913125*^9, 3.59118821409375*^9}, {3.591188315796875*^9, 
   3.591188318296875*^9}, {3.59118835*^9, 3.591188350328125*^9}, {
   3.591188451828125*^9, 3.591188512140625*^9}, {3.59119471525*^9, 
   3.591194727609375*^9}, {3.591198736078125*^9, 3.59119875246875*^9}, 
   3.5911990685625*^9, 3.591201345546875*^9, 3.59120178078125*^9, {
   3.5912018118125*^9, 3.591201863390625*^9}, {3.591246693765625*^9, 
   3.591246696890625*^9}, {3.5912468399375*^9, 3.591246868296875*^9}, 
   3.591248037703125*^9, {3.591332889015625*^9, 3.591332917375*^9}, {
   3.5913423225625*^9, 3.591342323484375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "exp", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"exp", "[", 
    RowBox[{"{", 
     RowBox[{"plf", ",", "lpl1", ",", "lpl0"}], "}"}], "]"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.591342380609375*^9, 3.59134241765625*^9}}]
},
WindowSize->{1766, 940},
WindowMargins->{{0, Automatic}, {Automatic, 2}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 535, 14, 125, "Input"],
Cell[1083, 36, 18315, 453, 1934, "Input"],
Cell[19401, 491, 1937, 50, 427, "Input"],
Cell[21341, 543, 6635, 159, 778, "Input"],
Cell[27979, 704, 3314, 92, 421, "Input"],
Cell[31296, 798, 251, 6, 43, "Input"],
Cell[31550, 806, 3330, 89, 503, "Input"],
Cell[34883, 897, 3023, 70, 265, "Input"],
Cell[37909, 969, 1147, 34, 152, "Input"]
}
]
*)

(* End of internal cache information *)
