(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     58831,       1601]
NotebookOptionsPosition[     57811,       1569]
NotebookOutlinePosition[     58212,       1586]
CellTagsIndexPosition[     58169,       1583]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", ":=", 
   RowBox[{
    SubscriptBox["\[Alpha]", "#"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"params", ":=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", 
       SubscriptBox["\[Alpha]", "_"], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.603955150828125*^9, 3.603955151734375*^9}, {
  3.752983855625*^9, 3.752983858859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejNx5", "[", "listDat_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
        "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
        RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
        "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
        ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
        "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"sd2", "[", "list_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
          RowBox[{
           RowBox[{"mean", "=", 
            RowBox[{"Mean", "[", "list", "]"}]}], ";", 
           RowBox[{"mean2", "=", 
            RowBox[{"Mean", "[", 
             RowBox[{"list", "*", "list"}], "]"}]}], ";", 
           RowBox[{"mean2", "-", 
            SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"aclist", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0."}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"nSampl", "=", 
        RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rn", "=", 
            RowBox[{"Range", "[", 
             RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"soucty", "=", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"aclist", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                RowBox[{"aclist", "[", 
                 RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
             ")"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigma", "=", 
            RowBox[{
             FractionBox["1.", 
              SuperscriptBox["nOkno", "2"]], 
             RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]",
          "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"mozne", "=", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"start", "=", 
        RowBox[{"fce", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Round", "[", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mozne", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"mozne", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n", "<", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"n", ">", 
             RowBox[{"mozne", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}], ",", 
            RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"krok", "[", 
         RowBox[{"body", ":", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"yka", "=", 
            RowBox[{"body", "/.", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"miny", "=", 
            RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nb", "=", 
            RowBox[{"Which", "[", 
             RowBox[{
              RowBox[{"miny", "\[Equal]", "y2"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"miny", "\[Equal]", "y3"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x3", "+", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}],
               ",", 
              RowBox[{"miny", "\[Equal]", "y1"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x1", "-", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
               "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Sort", "[", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"Sort", "[", 
                RowBox[{
                 RowBox[{"Union", "[", 
                  RowBox[{"nb", ",", "body"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", 
                   RowBox[{"#2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
               "3"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", 
               RowBox[{"#2", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"nx", "=", 
        FractionBox[
         RowBox[{"y1", "+", 
          RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
          RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
          RowBox[{"2", " ", "x2", " ", "y3"}]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ykvref", "=", 
        RowBox[{"Total", "[", 
         SuperscriptBox[
          RowBox[{"Take", "[", 
           RowBox[{"listDat", ",", 
            RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"varmin", "=", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["y1", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "y1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"y1", "-", 
             RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"pomer", "=", 
        FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "=", 
          FractionBox[
           RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
         RowBox[{
          SuperscriptBox["10", "6"], 
          SuperscriptBox["sr", "2"], 
          FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"resampluj", "[", 
     RowBox[{"list_List", ",", "nNorm_", ",", "nx_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ourInt", ",", "index", ",", "indexs", ",", "meritko"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ourInt", "[", 
         RowBox[{"x_", ",", "dats_"}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p", ",", "a", ",", "b", ",", "ya", ",", "yb", ",", "yx"}],
            "}"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b"}], "}"}], "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Floor", "[", "x", "]"}], ",", 
               RowBox[{"Ceiling", "[", "x", "]"}]}], "}"}]}]}], ";", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ya", ",", "yb"}], "}"}], "=", 
            RowBox[{"dats", "[", 
             RowBox[{"[", "p", "]"}], "]"}]}], ";", 
           RowBox[{"yx", "=", 
            RowBox[{"ya", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "a"}], ")"}], "*", 
              FractionBox[
               RowBox[{"yb", "-", "ya"}], 
               RowBox[{"b", "-", "a"}]]}]}]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"meritko", "=", 
        FractionBox[
         RowBox[{"nx", "-", "1"}], 
         RowBox[{"nNorm", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"index", "[", "x_", "]"}], ":=", 
        RowBox[{"1.", "+", 
         RowBox[{"x", "*", "meritko"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"indexs", "=", 
        RowBox[{"index", "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"nNorm", "-", "1"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ourInt", "[", 
            RowBox[{"#", ",", "list"}], "]"}], "&"}], "/@", "indexs"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fazorNharm", "[", 
     RowBox[{"list_", ",", "nHarm_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a1", ",", "b1", ",", "int", ",", "vahy", ",", "vazky"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
             RowBox[{"Range", "[", 
              RowBox[{
               RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], 
          ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"vazky", "=", 
        RowBox[{"vahy", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["sr", "2"]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"int", "[", 
         RowBox[{"listHodnot_", ",", "listVah_"}], "]"}], ":=", 
        RowBox[{
         FractionBox["2.", 
          RowBox[{"3", "sr"}]], 
         RowBox[{"vazky", ".", 
          RowBox[{"(", 
           RowBox[{"listHodnot", "*", "listVah"}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"a1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", 
          RowBox[{"cosTabS", "[", 
           RowBox[{"[", "nHarm", "]"}], "]"}]}], "]"}]}], ";", 
       RowBox[{"b1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", 
          RowBox[{"sinTabS", "[", 
           RowBox[{"[", "nHarm", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"b1", "+", 
        RowBox[{"I", "*", "a1"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejFazorS", "[", "list_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Delta]", ",", "var", ",", "pomer", ",", "newDat", ",", 
       "fazors"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "var", ",", "pomer"}], "}"}], "=", 
       RowBox[{"vydejNx5", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"newDat", "=", 
       RowBox[{"resampluj", "[", 
        RowBox[{"list", ",", 
         RowBox[{"sr", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sr", "+", "1"}], ")"}], "*", "pomer"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fazors", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"#", "*", "2.", "*", "Pi", "*", "f"}], ",", 
           RowBox[{"fazorNharm", "[", 
            RowBox[{"newDat", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", "nFmax", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"f", ",", "var"}], "}"}], ",", "fazors"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, 3.6037962083125*^9, {3.6037973405625*^9, 
   3.60379735265625*^9}, {3.603797619140625*^9, 3.60379767315625*^9}, 
   3.60379774790625*^9, {3.603798933421875*^9, 3.603798949046875*^9}, {
   3.603799067734375*^9, 3.60379907675*^9}, {3.752983778015625*^9, 
   3.752983789171875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dobre", " ", "je", " ", "nFile"}], "=", "31"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nFmax", "=", "130"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nFile", "=", "31"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{"\"\<scope_\>\"", "<>", 
         RowBox[{"ToString", "[", "nFile", "]"}], "<>", "\"\<.csv\>\""}], 
        "]"}], ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"Round", "[", 
      FractionBox["Tnom", "\[CapitalDelta]t"], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sinTabS", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"i", "*", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", 
          RowBox[{"2.", "Pi"}], ",", 
          RowBox[{"2.", 
           FractionBox["Pi", "sr"]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nFmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cosTabS", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"i", "*", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", 
          RowBox[{"2.", "Pi"}], ",", 
          RowBox[{"2.", 
           FractionBox["Pi", "sr"]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nFmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kperSampl", "=", "1.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vezmi", "=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nBeru", ",", "dats", ",", 
         RowBox[{"nAV", "=", "30"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nBeru", "=", 
         RowBox[{"Round", "[", 
          RowBox[{"sr", "*", "kperSampl"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dats", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", 
            RowBox[{"Take", "[", 
             RowBox[{"data", ",", "nBeru"}], "]"}]}], ")"}], 
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"vydejFazorS", "/@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"MovingAverage", "[", 
             RowBox[{"#", ",", "nAV"}], "]"}], "&"}], "/@", "dats"}], 
          ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.603799264328125*^9, 3.60379927090625*^9}, 
   3.60380028646875*^9, 3.603800326390625*^9, {3.6038003683125*^9, 
   3.603800515890625*^9}, {3.60380076903125*^9, 3.60380079575*^9}, {
   3.60380147471875*^9, 3.603801500765625*^9}, {3.6038015354375*^9, 
   3.60380157590625*^9}, {3.60380160903125*^9, 3.603801669109375*^9}, {
   3.603802125734375*^9, 3.603802198203125*^9}, {3.6038023125625*^9, 
   3.603802322046875*^9}, {3.603802353515625*^9, 3.603802380078125*^9}, {
   3.60380241415625*^9, 3.603802543625*^9}, {3.603802687859375*^9, 
   3.603802723390625*^9}, {3.60395063778125*^9, 3.6039506496875*^9}, {
   3.603950733171875*^9, 3.60395073459375*^9}, {3.603950770375*^9, 
   3.603950782109375*^9}, {3.603951269015625*^9, 3.603951335921875*^9}, 
   3.603951447453125*^9, {3.603952016953125*^9, 3.603952018953125*^9}, {
   3.603952139640625*^9, 3.603952165234375*^9}, {3.609319282796875*^9, 
   3.609319289359375*^9}, {3.609507732640625*^9, 3.609507780140625*^9}, {
   3.609508128265625*^9, 3.609508128421875*^9}, {3.6095082110625*^9, 
   3.609508235109375*^9}, {3.609508397296875*^9, 3.6095084169375*^9}, 
   3.609508461015625*^9, {3.6095087605*^9, 3.609508774859375*^9}, {
   3.6095088195625*^9, 3.609508871015625*^9}, {3.609508961734375*^9, 
   3.609508964796875*^9}, 3.609509011734375*^9, {3.609681077765625*^9, 
   3.60968107890625*^9}, 3.60968114521875*^9, 3.609682833171875*^9, 
   3.6096829614375*^9, 3.609683030328125*^9, {3.609683963375*^9, 
   3.609683963640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fcesAVars", "=", 
   RowBox[{
    RowBox[{"vezmi", "\[Transpose]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datPhasors", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", "vezmi"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmer", "=", 
    RowBox[{
     RowBox[{"Mean", "[", "fcesAVars", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "zabyvat", " ", "se", " ", "jednotnou", " ", "frekvenci", " ", "fazoru"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmer", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"fcesAVars", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f_", ",", "var_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"f", ",", 
           FractionBox["1", "var"]}], "}"}]}]}], ")"}], "\[Transpose]"}], 
     ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_List", ",", "vahy_List"}], "}"}], "\[RuleDelayed]", 
     FractionBox[
      RowBox[{"f", ".", "vahy"}], 
      RowBox[{"Plus", "@@", "vahy"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tmer", "=", 
   FractionBox["1", "fmer"]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"harm", "[", 
    RowBox[{"{", 
     RowBox[{"\[Omega]_", ",", "fazor_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", "fazor", "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"\[Omega]", "*", "t"}], "+", 
      RowBox[{"Arg", "[", "fazor", "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rek", "[", "dats_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"harm", "/@", "dats"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r1", "[", "t_", "]"}], ",", 
      RowBox[{"r2", "[", "t_", "]"}], ",", 
      RowBox[{"r3", "[", "t_", "]"}], ",", 
      RowBox[{"r4", "[", "t_", "]"}]}], "}"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"rek", "[", 
       RowBox[{"datPhasors", "[", 
        RowBox[{"[", 
         RowBox[{"#", ",", "1"}], "]"}], "]"}], "]"}], "&"}], "/@", 
     RowBox[{"Range", "[", "4", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"napeti", "=", "r3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tok", "[", "t_", "]"}], "=", 
   RowBox[{"Re", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"napeti", "[", "t", "]"}], ",", "t"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"tok", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plb", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r2", "[", "t", "]"}], ",", 
       RowBox[{"tok", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [A]\>\"", ",", "\"\<\[Phi] [Wb]\>\""}], "}"}]}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], ",", 
        RowBox[{"r2", "[", "t", "]"}], ",", 
        RowBox[{"r3", "[", "t", "]"}], ",", 
        RowBox[{"r4", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"tStart", "+", 
         RowBox[{"3", "Tmer"}]}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t [s]\>\"", ",", "\"\<vals[V]\>\""}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.603799264328125*^9, 3.60379927090625*^9}, 
   3.60380028646875*^9, 3.603800326390625*^9, {3.6038003683125*^9, 
   3.603800515890625*^9}, {3.60380076903125*^9, 3.60380079575*^9}, {
   3.60380147471875*^9, 3.603801500765625*^9}, {3.6038015354375*^9, 
   3.60380157590625*^9}, {3.60380160903125*^9, 3.603801669109375*^9}, {
   3.603802125734375*^9, 3.603802198203125*^9}, {3.6038023125625*^9, 
   3.603802322046875*^9}, {3.603802353515625*^9, 3.603802380078125*^9}, {
   3.60380241415625*^9, 3.603802543625*^9}, {3.603802687859375*^9, 
   3.603802723390625*^9}, {3.60395063778125*^9, 3.6039506496875*^9}, {
   3.603950733171875*^9, 3.60395073459375*^9}, {3.603950770375*^9, 
   3.603950782109375*^9}, {3.603951269015625*^9, 3.603951335921875*^9}, 
   3.603951447453125*^9, {3.603952016953125*^9, 3.603952018953125*^9}, {
   3.603952139640625*^9, 3.603952165234375*^9}, {3.609319282796875*^9, 
   3.609319289359375*^9}, {3.609507732640625*^9, 3.609507780140625*^9}, {
   3.609508128265625*^9, 3.609508128421875*^9}, {3.6095082110625*^9, 
   3.609508235109375*^9}, {3.609508397296875*^9, 3.6095084169375*^9}, 
   3.609508461015625*^9, {3.6095087605*^9, 3.60950876559375*^9}, {
   3.609515657609375*^9, 3.609515675921875*^9}, 3.609681108125*^9, {
   3.609681213875*^9, 3.609681232640625*^9}, {3.6096812734375*^9, 
   3.609681289796875*^9}, 3.61072039284375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"tpoc", "=", 
      RowBox[{"k", "*", "Tmer"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pocBod", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r2", "[", "tpoc", "]"}], ",", 
        RowBox[{"tok", "[", "tpoc", "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"plb", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
          RowBox[{"Point", "[", "pocBod", "]"}]}], "}"}], "]"}]}], "]"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.603951012546875*^9, 3.603951095078125*^9}, 
   3.603951160765625*^9, {3.603951226859375*^9, 3.6039512544375*^9}, {
   3.603951354140625*^9, 3.603951358828125*^9}, 3.603951390671875*^9, 
   3.6039514225*^9, {3.60407459731654*^9, 3.604074600249345*^9}, {
   3.604074652244236*^9, 3.6040746548338404`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tpoc", "=", 
   RowBox[{"0.3", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "r2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocBod", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r2", "[", "tpoc", "]"}], ",", 
     RowBox[{"tok", "[", "tpoc", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plc", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plb", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
        RowBox[{"Point", "[", "pocBod", "]"}]}], "}"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.6039508049375*^9, 3.60395088771875*^9}, {
   3.6039509188125*^9, 3.603950968484375*^9}, {3.603951350734375*^9, 
   3.603951351109375*^9}, {3.603951397734375*^9, 3.60395141334375*^9}, 
   3.60395145390625*^9, 3.603952194421875*^9, {3.603952368875*^9, 
   3.60395237334375*^9}, 3.6039558871875*^9, 3.610720372171875*^9, {
   3.6108049708125*^9, 3.610804983375*^9}, 3.61080510921875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"tpoc", "=", 
      RowBox[{"k", "*", "Tmer"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pocBod", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r2", "[", "tpoc", "]"}], ",", 
        RowBox[{"tok", "[", "tpoc", "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"plb", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
          RowBox[{"Point", "[", "pocBod", "]"}]}], "}"}], "]"}]}], "]"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.609513023625*^9, {3.6095131293125*^9, 3.609513132734375*^9}, {
   3.609513186453125*^9, 3.609513286125*^9}, {3.60951333046875*^9, 
   3.609513356515625*^9}, {3.609513904578125*^9, 3.60951391603125*^9}, 
   3.6096809188125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bodk", ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r2", "[", 
       RowBox[{"#", "*", "Tmer"}], "]"}], ",", 
      RowBox[{"tok", "[", 
       RowBox[{"#", "*", "Tmer"}], "]"}]}], "}"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"n", "=", "200"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ta", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tb", "=", "0.971"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datLin1", "=", 
   RowBox[{"bodk", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"ta", ",", "tb", ",", 
      FractionBox[
       RowBox[{"tb", "-", "ta"}], 
       RowBox[{"n", "-", "1"}]]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ta", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tb", "=", "0.47"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datLin2", "=", 
   RowBox[{"bodk", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"ta", ",", "tb", ",", 
      FractionBox[
       RowBox[{"tb", "-", "ta"}], 
       RowBox[{"n", "-", "1"}]]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k1", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Fit", "[", 
      RowBox[{"datLin1", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "i"}], "}"}], ",", "i"}], "]"}], ",", "i"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k2", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Fit", "[", 
      RowBox[{"datLin2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "i"}], "}"}], ",", "i"}], "]"}], ",", "i"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kSat", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"(", 
     RowBox[{"k1", "+", "k2"}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.60951337375*^9, 3.609513495578125*^9}, {
  3.609513579171875*^9, 3.60951382115625*^9}, {3.609514030125*^9, 
  3.60951403059375*^9}, {3.6095141101875*^9, 3.60951411421875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ta", "=", "0.567"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tb", "=", "0.78"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datLin1", "=", 
   RowBox[{"bodk", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"ta", ",", "tb", ",", 
      FractionBox[
       RowBox[{"tb", "-", "ta"}], 
       RowBox[{"n", "-", "1"}]]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ta", "=", "063"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tb", "=", "0.282"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datLin2", "=", 
   RowBox[{"bodk", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"ta", ",", "tb", ",", 
      FractionBox[
       RowBox[{"tb", "-", "ta"}], 
       RowBox[{"n", "-", "1"}]]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k1", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Fit", "[", 
      RowBox[{"datLin1", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "i"}], "}"}], ",", "i"}], "]"}], ",", "i"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k2", "=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Fit", "[", 
      RowBox[{"datLin2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "i"}], "}"}], ",", "i"}], "]"}], ",", "i"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kMax", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"(", 
     RowBox[{"k1", "+", "k2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fiSat", "=", "0.0121"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.609514042546875*^9, 3.60951414621875*^9}, {
  3.609514292484375*^9, 3.609514303953125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"fi", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"i", "*", "kSat"}], "+", 
      RowBox[{"fiSat", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"kMax", "-", "kSat"}], "fiSat"], "*", "i"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"proud", "[", "t", "]"}], ",", 
        RowBox[{"fi", "[", 
         RowBox[{"proud", "[", "t", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Magenta", ",", "Thick"}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"plc", ",", "%"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.60951421384375*^9, 3.609514245515625*^9}, {
   3.60951430984375*^9, 3.609514361078125*^9}, {3.60951440159375*^9, 
   3.60951442990625*^9}, 3.61072036590625*^9, {3.61072049059375*^9, 
   3.610720496140625*^9}, {3.61080486090625*^9, 3.6108049436875*^9}, {
   3.610804991234375*^9, 3.61080503896875*^9}, 3.61080516034375*^9, {
   3.610961928078125*^9, 3.6109619563125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"hodn", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{"0.5", "*", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["#", "2"], "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"b", "/@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Re", "[", "t", "]"}], "/.", 
                RowBox[{"FindRoot", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"a", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"t", ",", "#"}], "}"}]}], "]"}]}], ")"}], "&"}], "/@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0.25", "Tmer"}], ",", 
               RowBox[{"0.75", "Tmer"}]}], "}"}]}], ")"}]}], ")"}]}], 
        ")"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"icoerc", "=", 
  RowBox[{"hodn", "[", 
   RowBox[{"tok", ",", "proud"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"fii0", "=", 
  RowBox[{"hodn", "[", 
   RowBox[{"proud", ",", "tok"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.610809298921875*^9, 3.61080940178125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", "**"}], "**"}], "******)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.610804851203125*^9, 3.6108048578125*^9}}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.610806342015625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"R", "=", "50."}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"modely", " ", "nelin", " ", "indukcnost"}], " ", "+", " ", 
     RowBox[{"lin", " ", "odpor", " ", "paralelne"}]}], "..."}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"10", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"taut", "=", 
   RowBox[{"3", "*", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prechodNapeti", "[", "t_", "]"}], ":=", 
   RowBox[{"Tanh", "[", 
    FractionBox["t", "taut"], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], ":=", 
   RowBox[{"0.8", "*", "11.5", "*", 
    RowBox[{"prechodNapeti", "[", "t", "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "*", "Pi", "*", 
      FractionBox["t", "Tmer"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ri", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "-", 
       RowBox[{"uL", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"iz", "[", "t", "]"}], "*", "Ri"}]}], ",", 
     RowBox[{
      RowBox[{"iz", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"iR", "[", "t", "]"}], "+", 
       RowBox[{"iL", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"iR", "[", "t", "]"}], "*", "R"}], "\[Equal]", 
      RowBox[{"uL", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"uL", "[", "t", "]"}], "\[Equal]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"fi", "[", 
         RowBox[{"iL", "[", "t", "]"}], "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"iL", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Phi]", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"uL", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"iz", ",", "iR", ",", "iL", ",", "uL", ",", "\[Phi]"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"StartingStepSize", "->", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"iz", "[", "t", "]"}], "/.", "res"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"iz", "[", "t", "]"}], ",", 
       RowBox[{"\[Phi]", "[", "t", "]"}]}], "}"}], "/.", "res"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"tmax", "-", "Tmer"}], ",", "tmax"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<i [A]\>\"", ",", "\"\<\[Phi] [Wb]\>\""}], "}"}]}]}], "]"}],
   ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.609645124671875*^9, 3.609645433484375*^9}, 
   3.609645516984375*^9, {3.60964561284375*^9, 3.609645755875*^9}, {
   3.60964579584375*^9, 3.6096458845*^9}, {3.6096809609375*^9, 
   3.609680961375*^9}, {3.60968118009375*^9, 3.609681186453125*^9}, 
   3.610720354046875*^9, {3.61072050875*^9, 3.610720576125*^9}, 
   3.610961724578125*^9, {3.610962308765625*^9, 3.610962338765625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tk", "=", 
   RowBox[{"Thickness", "[", "0.006", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r3", "[", "t", "]"}], ",", 
      RowBox[{"r4", "[", "t", "]"}], ",", 
      RowBox[{"r1", "[", "t", "]"}], ",", 
      RowBox[{"r2", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Red", ",", "tk"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "tk"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "tk"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "tk"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<\!\(\*
StyleBox[\"u1\",
FontColor->RGBColor[0, 0, 1]]\)  \!\(\*
StyleBox[\"u2\",
FontColor->RGBColor[1, 0, 0]]\)  \!\(\*
StyleBox[\"uz1\",
FontColor->RGBColor[0, 1, 0]]\)  \!\(\*
StyleBox[\"i\",
FontColor->GrayLevel[0]]\) \>\""}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t [s]\>\"", ",", "\"\<vals\>\""}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6096825685*^9, 3.60968280175*^9}, {3.609682919875*^9, 
   3.609682934*^9}, {3.609683060015625*^9, 3.6096830740625*^9}, {
   3.609683465671875*^9, 3.60968347496875*^9}, {3.60968379484375*^9, 
   3.609683805890625*^9}, 3.610720345671875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"uuu1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u2", ",", "uz1", ",", "u1", ",", "i1"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{"r3", ",", "r4", ",", "r1", ",", "r2"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"#", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "&"}], "/@", 
  "uuu1"}]}], "Input",
 CellChangeTimes->{{3.609683342890625*^9, 3.609683350765625*^9}, {
   3.60968343653125*^9, 3.609683608234375*^9}, 3.609683851796875*^9, 
   3.609684363828125*^9, 3.610720359203125*^9, 3.6110528645*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rn", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "Tmer", ",", 
     FractionBox["Tmer", "200"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datProRZ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i1", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"uz1", "[", "#", "]"}], "-", 
        RowBox[{"u1", "[", "#", "]"}]}]}], "}"}], "&"}], "/@", "rn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rz", "=", 
   RowBox[{
    RowBox[{"Fit", "[", 
     RowBox[{"datProRZ", ",", 
      RowBox[{"{", "i", "}"}], ",", "i"}], "]"}], "/.", 
    RowBox[{"i", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datProPrevod", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u1", "[", "#", "]"}], ",", 
       RowBox[{"u2", "[", "#", "]"}]}], "}"}], "&"}], "/@", "rn"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Fit", "[", 
     RowBox[{"datProPrevod", ",", 
      RowBox[{"{", "u", "}"}], ",", "u"}], "]"}], "/.", 
    RowBox[{"u", "\[Rule]", "1"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"nepouzije", " ", "se"}], ",", " ", 
    RowBox[{"prumerna", " ", "hodnota"}], ",", " ", 
    RowBox[{"nema", " ", "dobry", " ", "vyznam"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prevod", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datProR1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i1", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"u1", "[", "#", "]"}], "-", 
        FractionBox[
         RowBox[{"u2", "[", "#", "]"}], "prevod"]}]}], "}"}], "&"}], "/@", 
    "rn"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R1", "=", 
   RowBox[{
    RowBox[{"Fit", "[", 
     RowBox[{"datProR1", ",", 
      RowBox[{"{", "i", "}"}], ",", "i"}], "]"}], "/.", 
    RowBox[{"i", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.609684583171875*^9, 3.6096846844375*^9}, {
  3.609684715328125*^9, 3.60968473975*^9}, {3.6096847705*^9, 
  3.609684921*^9}, {3.609685002140625*^9, 3.60968523490625*^9}, {
  3.609685284296875*^9, 3.609685387796875*^9}, {3.60968897115625*^9, 
  3.609688988859375*^9}, {3.611052803171875*^9, 3.611052806796875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"fi", ",", "Rp1"}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "rucni", " ", "uprava", " ", "vyfitovanych", " ", "veci", " ", "aby", " ", 
    "to", " ", "sedelo", " ", "lip"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kSata", "=", 
   RowBox[{"0.5", "*", "kSat"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kMaxa", "=", 
   RowBox[{"1", "*", "kMax"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R1a", "=", 
   RowBox[{"1.6", "R1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fi", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"i", "*", "kSata"}], "+", 
    RowBox[{"fiSat", "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"kMaxa", "-", "kSata"}], "fiSat"], "*", "i"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"10.", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Rp1", "=", 
    RowBox[{"5", "+", 
     RowBox[{"45", "*", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Abs", "[", 
         FractionBox[
          RowBox[{"u1o", "[", "t", "]"}], "12.1"], "]"}], ")"}], "3."]}]}]}], 
   ";"}], 
  RowBox[{"(*", 
   RowBox[{"nelinearni", " ", "Rp1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"taut", "=", 
   RowBox[{"3", "*", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prechodNapeti", "[", "t_", "]"}], ":=", 
   RowBox[{"Tanh", "[", 
    FractionBox["t", "taut"], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], ":=", 
   RowBox[{"12.3", "*", 
    RowBox[{"prechodNapeti", "[", "t", "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "*", "Pi", "*", 
      FractionBox["t", "Tmer"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"uz1o", "[", "t", "]"}], "-", 
          RowBox[{"u1o", "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{"Rz", "*", 
          RowBox[{"iz1o", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"iz1o", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"ip1", "[", "t", "]"}], "+", 
          RowBox[{"i1o", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u1o", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"Rp1", "*", 
          RowBox[{"ip1", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"u1o", "[", "t", "]"}], "-", 
          RowBox[{"uind1", "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{"R1a", "*", 
          RowBox[{"i1o", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uind1", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          FractionBox["1", "prevod"], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"fi", "[", 
             RowBox[{"i1o", "[", "t", "]"}], "]"}], ",", "t"}], "]"}]}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"i1o", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Phi]", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"prevod", "*", 
           RowBox[{"uind1", "[", "t", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["10", 
            RowBox[{"-", "10"}]], "*", 
           RowBox[{"\[Phi]", "[", "t", "]"}]}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[Phi]", "[", "0", "]"}], "\[Equal]", "0"}]}], 
       "\[IndentingNewLine]", "}"}], "//", "Simplify"}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{"uz1o", "\[Rule]", "uz"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"_Symbol", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", "Union"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"StartingStepSize", "->", 
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sh", "=", 
   RowBox[{"0.01", "Tmer"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"iz1o", "[", "t", "]"}], "/.", "res"}], ",", 
     RowBox[{"i1", "[", 
      RowBox[{"t", "+", "sh"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"tmax", "-", "Tmer"}], ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\< \!\(\*
StyleBox[\"simulace\",
FontColor->RGBColor[1, 0, 0]]\)  \!\(\*
StyleBox[\"mereni\",
FontColor->RGBColor[0, 0, 1]]\)  \>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plaa", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"iz1o", "[", "t", "]"}], ",", 
         RowBox[{"\[Phi]", "[", "t", "]"}]}], "}"}], "/.", "res"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"tmax", "-", "Tmer"}], ",", "tmax"}], "}"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Magenta", ",", 
         RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<i [A]\>\"", ",", "\"\<\[Phi] [Wb]\>\""}], "}"}]}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.609688830984375*^9, 3.609688878515625*^9}, {
   3.609688979234375*^9, 3.609689186109375*^9}, {3.609689296*^9, 
   3.609689380859375*^9}, {3.609689414640625*^9, 3.6096894695*^9}, {
   3.6096895098125*^9, 3.609689522828125*^9}, {3.60968959634375*^9, 
   3.60968960821875*^9}, {3.60968964134375*^9, 3.6096898685625*^9}, {
   3.6096899005625*^9, 3.609689933359375*^9}, {3.609689977984375*^9, 
   3.60968998234375*^9}, {3.609690034359375*^9, 3.609690061875*^9}, {
   3.609690095578125*^9, 3.60969017084375*^9}, {3.609690273171875*^9, 
   3.609690327890625*^9}, {3.6096903581875*^9, 3.60969036859375*^9}, {
   3.609690418078125*^9, 3.609690462265625*^9}, {3.60969061865625*^9, 
   3.609690629734375*^9}, 3.6107203026875*^9, {3.610962168078125*^9, 
   3.61096217621875*^9}, {3.610962211640625*^9, 3.6109622130625*^9}, {
   3.610962346953125*^9, 3.6109623845625*^9}, 3.610964327375*^9, 
   3.611048782125*^9, {3.6110552335625*^9, 3.6110552489375*^9}, 
   3.611055291109375*^9, {3.611055337375*^9, 3.611055408140625*^9}, 
   3.61105546028125*^9, {3.61105555125*^9, 3.611055601625*^9}, {
   3.611055636671875*^9, 3.611055875078125*^9}, {3.611055908796875*^9, 
   3.611055953*^9}, {3.611055992671875*^9, 3.61105630184375*^9}, {
   3.611056361265625*^9, 3.611056416453125*^9}}]
},
WindowSize->{1131, 618},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1028, 28, 188, "Input"],
Cell[1588, 50, 18752, 464, 2113, "Input"],
Cell[20343, 516, 5040, 128, 614, "Input"],
Cell[25386, 646, 5769, 158, 589, "Input"],
Cell[31158, 806, 1096, 27, 131, "Input"],
Cell[32257, 835, 1098, 28, 131, "Input"],
Cell[33358, 865, 1021, 27, 131, "Input"],
Cell[34382, 894, 2076, 64, 415, "Input"],
Cell[36461, 960, 1710, 51, 387, "Input"],
Cell[38174, 1013, 1406, 37, 189, "Input"],
Cell[39583, 1052, 1329, 38, 193, "Input"],
Cell[40915, 1092, 201, 6, 75, "Input"],
Cell[41119, 1100, 87, 1, 75, "Input"],
Cell[41209, 1103, 4173, 117, 508, "Input"],
Cell[45385, 1222, 1567, 42, 131, "Input"],
Cell[46955, 1266, 733, 20, 75, "Input"],
Cell[47691, 1288, 2377, 71, 362, "Input"],
Cell[50071, 1361, 7736, 206, 1076, "Input"]
}
]
*)

(* End of internal cache information *)

