(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     31082,        809]
NotebookOptionsPosition[     30610,        790]
NotebookOutlinePosition[     31013,        807]
CellTagsIndexPosition[     30970,        804]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", "pom"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", ":=", 
   RowBox[{
    SubscriptBox["\[Alpha]", "#"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"params", ":=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", 
       SubscriptBox["\[Alpha]", "_"], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.603955150828125*^9, 3.603955151734375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejNx5", "[", "listDat_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
        "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
        RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
        "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
        ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
        "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"sd2", "[", "list_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
          RowBox[{
           RowBox[{"mean", "=", 
            RowBox[{"Mean", "[", "list", "]"}]}], ";", 
           RowBox[{"mean2", "=", 
            RowBox[{"Mean", "[", 
             RowBox[{"list", "*", "list"}], "]"}]}], ";", 
           RowBox[{"mean2", "-", 
            SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"aclist", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0."}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"nSampl", "=", 
        RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rn", "=", 
            RowBox[{"Range", "[", 
             RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"soucty", "=", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"aclist", "[", 
                 RowBox[{"[", 
                  RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
                RowBox[{"aclist", "[", 
                 RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
             ")"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"sigma", "=", 
            RowBox[{
             FractionBox["1.", 
              SuperscriptBox["nOkno", "2"]], 
             RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]",
          "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"mozne", "=", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
           "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"start", "=", 
        RowBox[{"fce", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Round", "[", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mozne", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"mozne", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n", "<", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"n", ">", 
             RowBox[{"mozne", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}], ",", 
            RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"krok", "[", 
         RowBox[{"body", ":", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"yka", "=", 
            RowBox[{"body", "/.", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"miny", "=", 
            RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"nb", "=", 
            RowBox[{"Which", "[", 
             RowBox[{
              RowBox[{"miny", "\[Equal]", "y2"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
                RowBox[{"fce", "[", 
                 RowBox[{"Round", "[", 
                  RowBox[{"0.5", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"miny", "\[Equal]", "y3"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x3", "+", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}],
               ",", 
              RowBox[{"miny", "\[Equal]", "y1"}], ",", 
              RowBox[{"{", 
               RowBox[{"fce", "[", 
                RowBox[{"zkrot", "[", 
                 RowBox[{"x1", "-", 
                  RowBox[{"k1", "*", 
                   RowBox[{"(", 
                    RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
               "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Sort", "[", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"Sort", "[", 
                RowBox[{
                 RowBox[{"Union", "[", 
                  RowBox[{"nb", ",", "body"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", 
                   RowBox[{"#2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
               "3"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", 
               RowBox[{"#2", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"nx", "=", 
        FractionBox[
         RowBox[{"y1", "+", 
          RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
          RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
          RowBox[{"2", " ", "x2", " ", "y3"}]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ykvref", "=", 
        RowBox[{"Total", "[", 
         SuperscriptBox[
          RowBox[{"Take", "[", 
           RowBox[{"listDat", ",", 
            RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"varmin", "=", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["y1", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "y1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"y1", "-", 
             RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"pomer", "=", 
        FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "=", 
          FractionBox[
           RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
         RowBox[{
          SuperscriptBox["10", "6"], 
          SuperscriptBox["sr", "2"], 
          FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"resampluj", "[", 
     RowBox[{"list_List", ",", "nNorm_", ",", "nx_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ourInt", ",", "index", ",", "indexs", ",", "meritko"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ourInt", "[", 
         RowBox[{"x_", ",", "dats_"}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p", ",", "a", ",", "b", ",", "ya", ",", "yb", ",", "yx"}],
            "}"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b"}], "}"}], "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Floor", "[", "x", "]"}], ",", 
               RowBox[{"Ceiling", "[", "x", "]"}]}], "}"}]}]}], ";", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ya", ",", "yb"}], "}"}], "=", 
            RowBox[{"dats", "[", 
             RowBox[{"[", "p", "]"}], "]"}]}], ";", 
           RowBox[{"yx", "=", 
            RowBox[{"ya", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "a"}], ")"}], "*", 
              FractionBox[
               RowBox[{"yb", "-", "ya"}], 
               RowBox[{"b", "-", "a"}]]}]}]}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"meritko", "=", 
        FractionBox[
         RowBox[{"nx", "-", "1"}], 
         RowBox[{"nNorm", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"index", "[", "x_", "]"}], ":=", 
        RowBox[{"1.", "+", 
         RowBox[{"x", "*", "meritko"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"indexs", "=", 
        RowBox[{"index", "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"nNorm", "-", "1"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ourInt", "[", 
            RowBox[{"#", ",", "list"}], "]"}], "&"}], "/@", "indexs"}], ",", 
         RowBox[{"list", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fazorNharm", "[", 
     RowBox[{"list_", ",", "nHarm_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a1", ",", "b1", ",", "int", ",", "vahy", ",", "vazky"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"vahy", "[", "n_Integer", "]"}], ":=", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"#", "+", "1"}]], "+", "3"}], ")"}], "&"}], "/@", 
             RowBox[{"Range", "[", 
              RowBox[{
               RowBox[{"2", "n"}], "+", "1"}], "]"}]}], ",", "1"}], "]"}], 
          ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"vazky", "=", 
        RowBox[{"vahy", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["sr", "2"]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"int", "[", 
         RowBox[{"listHodnot_", ",", "listVah_"}], "]"}], ":=", 
        RowBox[{
         FractionBox["2.", 
          RowBox[{"3", "sr"}]], 
         RowBox[{"vazky", ".", 
          RowBox[{"(", 
           RowBox[{"listHodnot", "*", "listVah"}], ")"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"a1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", 
          RowBox[{"cosTabS", "[", 
           RowBox[{"[", "nHarm", "]"}], "]"}]}], "]"}]}], ";", 
       RowBox[{"b1", "=", 
        RowBox[{"int", "[", 
         RowBox[{"list", ",", 
          RowBox[{"sinTabS", "[", 
           RowBox[{"[", "nHarm", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"b1", "+", 
        RowBox[{"I", "*", "a1"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejFazorS", "[", "list_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Delta]", ",", "var", ",", "pomer", ",", "newDat", ",", 
       "fazors"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "var", ",", "pomer"}], "}"}], "=", 
       RowBox[{"vydejNx5", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"newDat", "=", 
       RowBox[{"resampluj", "[", 
        RowBox[{"list", ",", 
         RowBox[{"sr", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sr", "+", "1"}], ")"}], "*", "pomer"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fazors", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"#", "*", "2.", "*", "Pi", "*", "f"}], ",", 
           RowBox[{"fazorNharm", "[", 
            RowBox[{"newDat", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", "nFmax", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"f", ",", "var"}], "}"}], ",", "fazors"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, 3.6037962083125*^9, {3.6037973405625*^9, 
   3.60379735265625*^9}, {3.603797619140625*^9, 3.60379767315625*^9}, 
   3.60379774790625*^9, {3.603798933421875*^9, 3.603798949046875*^9}, {
   3.603799067734375*^9, 3.60379907675*^9}, {3.752983256546875*^9, 
   3.752983284203125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dobre", " ", "je", " ", "nFile"}], "=", "31"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nFmax", "=", "130"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nFile", "=", "31"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{"\"\<scope_\>\"", "<>", 
         RowBox[{"ToString", "[", "nFile", "]"}], "<>", "\"\<.csv\>\""}], 
        "]"}], ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "=", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"Round", "[", 
      FractionBox["Tnom", "\[CapitalDelta]t"], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sinTabS", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"i", "*", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", 
          RowBox[{"2.", "Pi"}], ",", 
          RowBox[{"2.", 
           FractionBox["Pi", "sr"]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nFmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cosTabS", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"i", "*", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", 
          RowBox[{"2.", "Pi"}], ",", 
          RowBox[{"2.", 
           FractionBox["Pi", "sr"]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nFmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kperSampl", "=", "1.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vezmi", "=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nBeru", ",", "dats", ",", 
         RowBox[{"nAV", "=", "30"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nBeru", "=", 
         RowBox[{"Round", "[", 
          RowBox[{"sr", "*", "kperSampl"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dats", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", 
            RowBox[{"Take", "[", 
             RowBox[{"data", ",", "nBeru"}], "]"}]}], ")"}], 
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"vydejFazorS", "/@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"MovingAverage", "[", 
             RowBox[{"#", ",", "nAV"}], "]"}], "&"}], "/@", "dats"}], 
          ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.603799264328125*^9, 3.60379927090625*^9}, 
   3.60380028646875*^9, 3.603800326390625*^9, {3.6038003683125*^9, 
   3.603800515890625*^9}, {3.60380076903125*^9, 3.60380079575*^9}, {
   3.60380147471875*^9, 3.603801500765625*^9}, {3.6038015354375*^9, 
   3.60380157590625*^9}, {3.60380160903125*^9, 3.603801669109375*^9}, {
   3.603802125734375*^9, 3.603802198203125*^9}, {3.6038023125625*^9, 
   3.603802322046875*^9}, {3.603802353515625*^9, 3.603802380078125*^9}, {
   3.60380241415625*^9, 3.603802543625*^9}, {3.603802687859375*^9, 
   3.603802723390625*^9}, {3.60395063778125*^9, 3.6039506496875*^9}, {
   3.603950733171875*^9, 3.60395073459375*^9}, {3.603950770375*^9, 
   3.603950782109375*^9}, {3.603951269015625*^9, 3.603951335921875*^9}, 
   3.603951447453125*^9, {3.603952016953125*^9, 3.603952018953125*^9}, {
   3.603952139640625*^9, 3.603952165234375*^9}, {3.609319282796875*^9, 
   3.609319289359375*^9}, {3.609507732640625*^9, 3.609507780140625*^9}, {
   3.609508128265625*^9, 3.609508128421875*^9}, {3.6095082110625*^9, 
   3.609508235109375*^9}, {3.609508397296875*^9, 3.6095084169375*^9}, 
   3.609508461015625*^9, {3.6095087605*^9, 3.609508774859375*^9}, {
   3.6095088195625*^9, 3.609508871015625*^9}, {3.609508961734375*^9, 
   3.609508964796875*^9}, 3.609509011734375*^9, {3.609681077765625*^9, 
   3.60968107890625*^9}, 3.60968114521875*^9, 3.609682833171875*^9, 
   3.6096829614375*^9, 3.609683030328125*^9, {3.609683963375*^9, 
   3.609683963640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fcesAVars", "=", 
   RowBox[{
    RowBox[{"vezmi", "\[Transpose]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datPhasors", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", "vezmi"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmer", "=", 
    RowBox[{
     RowBox[{"Mean", "[", "fcesAVars", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "zabyvat", " ", "se", " ", "jednotnou", " ", "frekvenci", " ", "fazoru"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmer", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"fcesAVars", "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f_", ",", "var_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"f", ",", 
           FractionBox["1", "var"]}], "}"}]}]}], ")"}], "\[Transpose]"}], 
     ")"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_List", ",", "vahy_List"}], "}"}], "\[RuleDelayed]", 
     FractionBox[
      RowBox[{"f", ".", "vahy"}], 
      RowBox[{"Plus", "@@", "vahy"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tmer", "=", 
   FractionBox["1", "fmer"]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"harm", "[", 
    RowBox[{"{", 
     RowBox[{"\[Omega]_", ",", "fazor_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Abs", "[", "fazor", "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"\[Omega]", "*", "t"}], "+", 
      RowBox[{"Arg", "[", "fazor", "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rek", "[", "dats_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"harm", "/@", "dats"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r1", "[", "t_", "]"}], ",", 
      RowBox[{"r2", "[", "t_", "]"}], ",", 
      RowBox[{"r3", "[", "t_", "]"}], ",", 
      RowBox[{"r4", "[", "t_", "]"}]}], "}"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"rek", "[", 
       RowBox[{"datPhasors", "[", 
        RowBox[{"[", 
         RowBox[{"#", ",", "1"}], "]"}], "]"}], "]"}], "&"}], "/@", 
     RowBox[{"Range", "[", "4", "]"}]}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"napeti", "=", "r3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tok", "[", "t_", "]"}], "=", 
   RowBox[{"Re", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"napeti", "[", "t", "]"}], ",", "t"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"tok", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.603799264328125*^9, 3.60379927090625*^9}, 
   3.60380028646875*^9, 3.603800326390625*^9, {3.6038003683125*^9, 
   3.603800515890625*^9}, {3.60380076903125*^9, 3.60380079575*^9}, {
   3.60380147471875*^9, 3.603801500765625*^9}, {3.6038015354375*^9, 
   3.60380157590625*^9}, {3.60380160903125*^9, 3.603801669109375*^9}, {
   3.603802125734375*^9, 3.603802198203125*^9}, {3.6038023125625*^9, 
   3.603802322046875*^9}, {3.603802353515625*^9, 3.603802380078125*^9}, {
   3.60380241415625*^9, 3.603802543625*^9}, {3.603802687859375*^9, 
   3.603802723390625*^9}, {3.60395063778125*^9, 3.6039506496875*^9}, {
   3.603950733171875*^9, 3.60395073459375*^9}, {3.603950770375*^9, 
   3.603950782109375*^9}, {3.603951269015625*^9, 3.603951335921875*^9}, 
   3.603951447453125*^9, {3.603952016953125*^9, 3.603952018953125*^9}, {
   3.603952139640625*^9, 3.603952165234375*^9}, {3.609319282796875*^9, 
   3.609319289359375*^9}, {3.609507732640625*^9, 3.609507780140625*^9}, {
   3.609508128265625*^9, 3.609508128421875*^9}, {3.6095082110625*^9, 
   3.609508235109375*^9}, {3.609508397296875*^9, 3.6095084169375*^9}, 
   3.609508461015625*^9, {3.6095087605*^9, 3.60950876559375*^9}, {
   3.609515657609375*^9, 3.609515675921875*^9}, 3.609681108125*^9, {
   3.609681213875*^9, 3.609681232640625*^9}, {3.6096812734375*^9, 
   3.609681289796875*^9}, 3.61072039284375*^9, {3.6506898848125*^9, 
   3.650689899890625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"plb", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r2", "[", "t", "]"}], ",", 
       RowBox[{"tok", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Tmer"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [A]\>\"", ",", "\"\<\[Phi] [Wb]\>\""}], "}"}]}]}], 
    "]"}]}], "\n"}]], "Input",
 CellChangeTimes->{3.650689914015625*^9}]
},
WindowSize->{1131, 618},
WindowMargins->{{23, Automatic}, {Automatic, 61}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1026, 28, 216, "Input"],
Cell[1586, 50, 18752, 464, 2113, "Input"],
Cell[20341, 516, 5040, 128, 614, "Input"],
Cell[25384, 646, 4395, 118, 477, "Input"],
Cell[29782, 766, 824, 22, 131, "Input"]
}
]
*)

(* End of internal cache information *)

