(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21085,        539]
NotebookOptionsPosition[     20647,        521]
NotebookOutlinePosition[     21048,        538]
CellTagsIndexPosition[     21005,        535]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.638255496078125*^9, 3.638255503171875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", "listDat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", 
       RowBox[{"\[CapitalDelta]mozne", "=", "0.2"}], ",", "mozne", ",", 
       "start", ",", "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", 
       ",", "sd2", ",", "nSampl", ",", "ykvref", ",", "varmin", ",", 
       "pomer"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0."}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"aclist", "[", 
                RowBox[{"[", 
                 RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
               RowBox[{"aclist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
            ")"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", 
             SuperscriptBox["nOkno", "2"]], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[CapitalDelta]mozne"}], ")"}], "*", "sr"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "y1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", "y2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{"krok", ",", "start"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       FractionBox[
        RowBox[{"y1", "+", 
         RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
         RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
         RowBox[{"2", " ", "x2", " ", "y3"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"y1", "-", 
           RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       RowBox[{"Total", "[", 
        SuperscriptBox[
         RowBox[{"Take", "[", 
          RowBox[{"listDat", ",", 
           RowBox[{"Round", "[", "nx", "]"}]}], "]"}], "2"], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["y1", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "y1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"y1", "-", 
            RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "=", 
         FractionBox[
          RowBox[{"fnom", "*", "sr"}], "nx"]}], ",", 
        RowBox[{"100", "*", 
         RowBox[{"(", 
          RowBox[{"k\[Omega]", "-", 
           FractionBox["f", "fnom"]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["10", "6"], 
         SuperscriptBox["sr", "2"], 
         FractionBox["varmin", "ykvref"]}], ",", "pomer"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}, {3.7239556183125*^9, 
   3.723955630328125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kperSampl", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]SumK", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SR", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "SR", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k\[Omega]", "=", "1.0456"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fnom", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnom", "=", 
     FractionBox["1", "fnom"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sr", "=", 
     RowBox[{"2", "*", 
      RowBox[{"Round", "[", 
       FractionBox["48000", 
        RowBox[{"2", "*", "50"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"k\[Omega]", "*", "2.", "*", "Pi", "*", "fnom"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tnom", "=", 
     FractionBox["Tnom", "sr"]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"trialfce", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Exp", "[", 
       FractionBox[
        RowBox[{"-", "t"}], 
        RowBox[{"20", "Tnom"}]], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"\[Omega]", "*", "t"}], "+", "0.123"}], "]"}], "+", 
        RowBox[{"0.2", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"3.483", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}], "+", 
        RowBox[{"0.2", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"7.178", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}], "+", 
        RowBox[{"0.4", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"11", "*", "\[Omega]", "*", "t"}], "+", "0.897"}], 
          "]"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datsFce", "=", 
     RowBox[{"trialfce", "/@", 
      RowBox[{"(", 
       RowBox[{"rnp", "=", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", 
          RowBox[{"kperSampl", "*", "Tnom"}], ",", "\[CapitalDelta]tnom"}], 
         "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sum", "[", 
      RowBox[{"k_", ",", "seedRandom_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SeedRandom", "[", "seedRandom", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"RandomReal", "[", 
            RowBox[{"NormalDistribution", "[", 
             RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}], "&"}], "/@", 
         "rnp"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dats", "=", 
     RowBox[{"datsFce", "+", 
      RowBox[{"sum", "[", 
       RowBox[{"\[Sigma]SumK", ",", "SR"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"datsFce", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<i [-]\>\"", ",", "\"\<signal\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
          RowBox[{"Opacity", "[", "0.9", "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"vydejNx5", "[", "dats", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ukpl", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"pl1", ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"dats", ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"PointSize", "[", "0.003", "]"}]}]}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotLabel", "->", 
       RowBox[{"\"\<\[Delta]f= \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"0.001", "*", 
          RowBox[{"Round", "[", 
           RowBox[{"1000", 
            RowBox[{"pom", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "<>", 
        "\"\< %\>\""}]}]}], "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.591248592265625*^9, 3.591248638765625*^9, {3.591248692484375*^9, 
   3.591248693125*^9}, {3.59124894825*^9, 3.591248998703125*^9}, {
   3.591249110484375*^9, 3.59124911196875*^9}, {3.591249147203125*^9, 
   3.591249147359375*^9}, 3.591249182125*^9, {3.591249215109375*^9, 
   3.591249239984375*^9}, 3.591249279671875*^9, {3.591250220390625*^9, 
   3.59125022371875*^9}, {3.591250276796875*^9, 3.59125032821875*^9}, {
   3.59125275034375*^9, 3.591252751078125*^9}, {3.59126424884375*^9, 
   3.591264249921875*^9}, {3.638254013921875*^9, 3.63825401484375*^9}, {
   3.638254666953125*^9, 3.638254695921875*^9}, {3.638254752515625*^9, 
   3.638254786796875*^9}, {3.638254821578125*^9, 3.63825495734375*^9}, {
   3.63825712134375*^9, 3.638257333140625*^9}, {3.638257389265625*^9, 
   3.6382577399375*^9}, {3.63825778628125*^9, 3.638257824234375*^9}, {
   3.638257915125*^9, 3.638258024171875*^9}, {3.638258059921875*^9, 
   3.6382580603125*^9}, {3.63825816075*^9, 3.63825827640625*^9}, {
   3.63825832834375*^9, 3.638258365515625*^9}, {3.6382585934375*^9, 
   3.638258595328125*^9}, 3.638258908015625*^9, 3.6382589783125*^9, {
   3.638259009859375*^9, 3.638259016359375*^9}, {3.63825905259375*^9, 
   3.6382590629375*^9}, {3.638259104640625*^9, 3.638259110703125*^9}, {
   3.63825916878125*^9, 3.638259177984375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"exp", "[", "ukpl", "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.63825860125*^9, 3.63825860471875*^9}, 3.75298399175*^9}]
},
WindowSize->{1113, 767},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5000001192092896`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 511, 12, 98, "Input"],
Cell[1059, 34, 12707, 306, 1171, "Input"],
Cell[13769, 342, 5862, 146, 861, "Input"],
Cell[19634, 490, 1009, 29, 125, "Input"]
}
]
*)

(* End of internal cache information *)
