(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6207,        192]
NotebookOptionsPosition[      5484,        174]
NotebookOutlinePosition[      5866,        190]
CellTagsIndexPosition[      5823,        187]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",ExpressionUUID->\
"03a48aec-d4e2-4e9c-b8c2-0173bebcd0b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dataLdif", "=", 
   RowBox[{"Import", "[", "\"\<dataLdif46.csv\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.750911583027213*^9, 
  3.7509115998200455`*^9}},ExpressionUUID->"3e7b41e1-e604-4a49-b766-\
12b97f15470d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"dataLdif", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"i", "-", "d"}], ")"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{"dataLdif", ",", "model", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "i"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Ld", "[", "i_", "]"}], "=", 
   RowBox[{"model", "/.", "params"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Ld", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "100"}], "}"}]}], "]"}], ",", "pl1"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.750911602834997*^9, 
  3.750911797632557*^9}},ExpressionUUID->"cb317f9c-9c92-4b49-8d80-\
b008c80b0a8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"opravdu", " ", "maji", " ", "bug", " ", "v", " ", "Mathematice"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Ld", "[", "i", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"fi", "'"}], "[", "i", "]"}]}], ",", 
       RowBox[{
        RowBox[{"fi", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"fi", "[", "i", "]"}], ",", "i"}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Ld", "[", "i", "]"}], ",", "i"}], "]"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.7509118288126216`*^9, 3.750911837279405*^9}, {
  3.750911869250434*^9, 3.7509119139429812`*^9}, {3.7509119606328306`*^9, 
  3.7509119967648954`*^9}},ExpressionUUID->"02b325f4-9301-42e7-a55a-\
0b7e268d2408"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "dalsim", " ", "je", " ", "mozno", " ", "proste", " ", 
    "pouzivat", " ", "fii"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"intLd", "=", 
     RowBox[{"Interpolation", "[", "dataLdif", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"imax", "=", 
     RowBox[{"intLd", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solNDS", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Ld", "[", "i", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"fi", "'"}], "[", "i", "]"}]}], ",", 
          RowBox[{
           RowBox[{"fi", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
        "fi", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "imax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fii", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fi", "[", "i", "]"}], "/.", "solNDS"}], ")"}], "/;", 
      RowBox[{"i", "\[GreaterEqual]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fii", "[", "i_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"fi", "[", 
          RowBox[{"-", "i"}], "]"}]}], "/.", "solNDS"}], ")"}], "/;", 
      RowBox[{"i", "<", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"fii", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "imax"}], ",", "imax"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7509120146044445`*^9, 3.7509122715106077`*^9}, {
  3.750912312063491*^9, 
  3.7509123282002907`*^9}},ExpressionUUID->"db633866-e85d-4166-8765-\
a1f864cc8796"]
},
WindowSize->{1309, 778},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 390, 11, 106, "Input",ExpressionUUID->"03a48aec-d4e2-4e9c-b8c2-0173bebcd0b8"],
Cell[938, 33, 257, 6, 45, "Input",ExpressionUUID->"3e7b41e1-e604-4a49-b766-12b97f15470d"],
Cell[1198, 41, 1291, 41, 166, "Input",ExpressionUUID->"cb317f9c-9c92-4b49-8d80-b008c80b0a8c"],
Cell[2492, 84, 929, 25, 106, "Input",ExpressionUUID->"02b325f4-9301-42e7-a55a-0b7e268d2408"],
Cell[3424, 111, 2056, 61, 256, "Input",ExpressionUUID->"db633866-e85d-4166-8765-a1f864cc8796"]
}
]
*)

