(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23259,        696]
NotebookOptionsPosition[     22218,        663]
NotebookOutlinePosition[     22621,        680]
CellTagsIndexPosition[     22578,        677]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", "*", "3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 3.689476074453125*^9}, {
  3.690042085125*^9, 3.69004208646875*^9}, {3.6900439293125*^9, 
  3.690043938546875*^9}, {3.690084160515625*^9, 3.69008416303125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]el", "[", "T_", "]"}], ":=", 
   RowBox[{"1.5", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "120"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Skolma", "=", 
   RowBox[{"Pi", "*", 
    SuperscriptBox["R", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obvod", "=", 
   RowBox[{"2", "*", "Pi", "*", "R"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "5.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV1", "[", "T_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["proud", "Skolma"], ")"}], "2"], "*", 
    RowBox[{"\[Rho]el", "[", "T", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV2", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox["obvod", "Skolma"], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}], "+", 
      RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", "+", "273."}], ")"}], "4"], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"To", "+", "273."}], ")"}], "4"]}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"qv", "[", "T_", "]"}], ":=", 
    FractionBox[
     RowBox[{
      RowBox[{"QV1", "[", "T", "]"}], "-", 
      RowBox[{"QV2", "[", "T", "]"}]}], 
     RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690041981890625*^9, 3.69004201409375*^9}, {
   3.690042057671875*^9, 3.690042449171875*^9}, {3.6900425315625*^9, 
   3.69004260603125*^9}, {3.6900436025625*^9, 3.690043624921875*^9}, 
   3.690084092390625*^9, {3.690084363078125*^9, 3.690084367421875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "\[Alpha]1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], "=", 
   RowBox[{"T1", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"T2", "-", "T1"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]1", "*", 
         RowBox[{"(", 
          RowBox[{"To1", "-", "T1"}], ")"}]}]}], ",", "T1"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], "=", 
   RowBox[{"Tn", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Tnminus"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]n", "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Ton"}], ")"}]}]}], ",", "Tn"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042772671875*^9}, {3.690043833125*^9, 
   3.690043840921875*^9}, 3.69008409653125*^9, 3.6900841445*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "krok", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Tpom", ",", "odQV"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"odQV", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]t", "*", 
          RowBox[{"qv", "[", "#", "]"}]}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"list", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Tpom", "=", 
       RowBox[{"odQV", "+", 
        RowBox[{"ListConvolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Fo", ",", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}],
          "]"}]}]}], ";", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fTn", "[", 
         RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ";", 
      RowBox[{"PrependTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.690042942125*^9}, {3.690043200828125*^9, 3.690043297484375*^9}, {
   3.690043448078125*^9, 3.690043451015625*^9}, {3.69004370228125*^9, 
   3.690043703796875*^9}, {3.690043903703125*^9, 3.690043904125*^9}, 
   3.69008405909375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxT", "=", 
   RowBox[{
    RowBox[{"Last", "[", "teppole", "]"}], "//", "Max"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.690043497046875*^9}, {3.690043647546875*^9, 3.690043650421875*^9}, {
   3.690043768484375*^9, 3.69004379325*^9}, 3.69004389503125*^9, 
   3.6900841316875*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plotik", "[", 
     RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"nel", "=", 
         RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i", 
        ",", "tpopis"}], "}"}], ",", 
      RowBox[{
       RowBox[{"listpom", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
            RowBox[{"list", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"listpom", ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
         ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"maxT", "+", "10"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{"tpopis", "=", 
           RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
          RowBox[{"PlotLabel", "->", 
           RowBox[{"\"\<t=\>\"", "<>", 
            RowBox[{"ToString", "[", "tpopis", "]"}], "<>", 
            "\"\< s\>\""}]}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.6900434928125*^9}, {3.69004366353125*^9, 3.6900436775*^9}, {
   3.690043744765625*^9, 3.6900437659375*^9}, {3.690043801109375*^9, 
   3.690043802625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 3.689476362265625*^9}, {
   3.690043683015625*^9, 3.69004369415625*^9}, 3.690043805375*^9, 
   3.690044085796875*^9, {3.690047003421875*^9, 3.690047010078125*^9}, 
   3.690084080703125*^9, 3.690084184859375*^9}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"plots", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{3.690043991421875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceUstStav", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"qv", "[", 
        RowBox[{"T", "[", "x", "]"}], "]"}]}], "\[Equal]", "0"}], "}"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], "*", 
      RowBox[{
       RowBox[{"T", "'"}], "[", "0", "]"}]}], "\[Equal]", 
     RowBox[{"\[Alpha]1", "*", 
      RowBox[{"(", 
       RowBox[{"To", "-", 
        RowBox[{"T", "[", "0", "]"}]}], ")"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], "*", 
      RowBox[{
       RowBox[{"T", "'"}], "[", "d", "]"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "\[Alpha]1"}], "*", 
      RowBox[{"(", 
       RowBox[{"To", "-", 
        RowBox[{"T", "[", "d", "]"}]}], ")"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"resNDS", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"rceUstStav", ",", "okr1", ",", "okr2"}], "]"}], ",", "T", 
       ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "[", "x", "]"}], "/.", "resNDS"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}]}]}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.690044568703125*^9, 3.6900446249375*^9}, {
  3.690044659953125*^9, 3.6900446638125*^9}, {3.690044766109375*^9, 
  3.690044841265625*^9}, {3.690044872828125*^9, 3.690044930453125*^9}, {
  3.6900449689375*^9, 3.690044969515625*^9}, {3.690045002765625*^9, 
  3.690045050828125*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"DSolve", "[", 
   RowBox[{"rceUstStav", ",", 
    RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690044707359375*^9, 3.690044721046875*^9}, 
   3.690044754328125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"resStrelba", "[", 
   RowBox[{"T0_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rce", ",", "res"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rce", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"rceUstStav", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Lambda]"}], "*", 
           RowBox[{
            RowBox[{"T", "'"}], "[", "0", "]"}]}], "\[Equal]", 
          RowBox[{"\[Alpha]1", "*", 
           RowBox[{"(", 
            RowBox[{"To", "-", "T0"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"T", "[", "0", "]"}], "\[Equal]", "T0"}], "}"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"res", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{"rce", ",", 
         RowBox[{"{", 
          RowBox[{"T", ",", 
           RowBox[{"T", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Lambda]"}], "*", 
          RowBox[{
           RowBox[{"T", "'"}], "[", "d", "]"}]}], "+", 
         RowBox[{"\[Alpha]1", "*", 
          RowBox[{"(", 
           RowBox[{"To", "-", 
            RowBox[{"T", "[", "d", "]"}]}], ")"}]}]}], ",", "T"}], "}"}], "/.",
       "res"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resStrelba", "[", "20.1", "]"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.69004510465625*^9, 3.690045276484375*^9}, {
  3.690045309859375*^9, 3.690045316484375*^9}, {3.690045353015625*^9, 
  3.690045382484375*^9}, {3.690045430640625*^9, 3.690045444328125*^9}, {
  3.6900455263125*^9, 3.690045628140625*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"resStrelba", "[", "T0", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T0", ",", "20", ",", "20.1"}], "}"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690045639328125*^9, 3.69004566425*^9}, 
   3.6900456968125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"resStrelba", "[", "19.8", "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690045702796875*^9, 3.69004576675*^9}, 
   3.69008421253125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"{", 
     RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Tvlevo", "+", "Tvpravo", "-", 
     RowBox[{"2", "Tzde"}]}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rceUvnitr", "[", 
    RowBox[{"trojice", ":", 
     RowBox[{"{", 
      RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"der2", "[", "trojice", "]"}]}], "+", 
     RowBox[{"qv", "[", "Tzde", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcesIn", "=", 
   RowBox[{
    RowBox[{"rceUvnitr", "/@", 
     RowBox[{"Partition", "[", 
      RowBox[{"teploty", ",", "3", ",", "1"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "rcesIn", "]"}], "+", "2"}], "\[Equal]", 
  "n"}]}], "Input",
 CellChangeTimes->{{3.69004616290625*^9, 3.69004622325*^9}, {
  3.69004628921875*^9, 3.69004639315625*^9}, {3.69004642625*^9, 
  3.690046508078125*^9}, {3.69004694071875*^9, 3.690046940953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceT1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "2"], "-", 
         SubscriptBox["T", "1"]}], ")"}]}], "-", 
      RowBox[{"\[Alpha]1", "*", 
       RowBox[{"(", 
        RowBox[{"To1", "-", 
         SubscriptBox["T", "1"]}], ")"}]}]}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceTn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "n"], "-", 
         SubscriptBox["T", 
          RowBox[{"n", "-", "1"}]]}], ")"}]}], "-", 
      RowBox[{"\[Alpha]1", "*", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "n"], "-", "Ton"}], ")"}]}]}], "\[Equal]", "0"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690046633703125*^9, 3.6900467539375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"rceSite", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rcesIn", ",", "rceT1", ",", "rceTn"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6900467973125*^9, 3.6900468335*^9}}],

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"qv", "[", "Tustalene", "]"}], "\[Equal]", "0"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Tust", "=", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Tustalene", "/.", "%"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}], "//",
    "Max"}]}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocTeploty", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", "Tust"}], "}"}], "&"}], "/@", "teploty"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"rceSite", ",", "pocTeploty"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6900468523125*^9, 3.69004693203125*^9}, 
   3.69008428215625*^9}]
},
WindowSize->{1003, 740},
WindowMargins->{{40, Automatic}, {Automatic, 31}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 330, 9, 92, "Input"],
Cell[878, 31, 2047, 54, 465, "Input"],
Cell[2928, 87, 2526, 76, 469, "Input"],
Cell[5457, 165, 2020, 56, 298, "Input"],
Cell[7480, 223, 1819, 48, 142, "Input"],
Cell[9302, 273, 1087, 27, 172, "Input"],
Cell[10392, 302, 2258, 57, 217, "Input"],
Cell[12653, 361, 724, 19, 67, "Input"],
Cell[13380, 382, 329, 10, 41, "Input"],
Cell[13712, 394, 1993, 63, 142, "Input"],
Cell[15708, 459, 249, 6, 41, "Input"],
Cell[15960, 467, 1950, 53, 167, "Input"],
Cell[17913, 522, 355, 10, 41, "Input"],
Cell[18271, 534, 395, 11, 67, "Input"],
Cell[18669, 547, 1413, 41, 172, "Input"],
Cell[20085, 590, 1111, 36, 149, "Input"],
Cell[21199, 628, 213, 5, 41, "Input"],
Cell[21415, 635, 420, 13, 92, "Input"],
Cell[21838, 650, 376, 11, 67, "Input"]
}
]
*)

(* End of internal cache information *)
