(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5910,        183]
NotebookOptionsPosition[      5478,        165]
NotebookOutlinePosition[      5880,        182]
CellTagsIndexPosition[      5837,        179]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dZed", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dIz", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]Iz", "=", "0.04"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]Zed", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TZleva", "=", "20."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TZprava", "=", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xZlom", "=", "dZed"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", 
   RowBox[{
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"Tanh", "[", 
       RowBox[{"k", "*", 
        RowBox[{"(", 
         RowBox[{"x", "-", "xZlom"}], ")"}]}], "]"}]}]}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "-", "b"}], "==", "\[Lambda]Zed"}], ",", 
        RowBox[{
         RowBox[{"a", "+", "b"}], "==", "\[Lambda]Iz"}]}], "}"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"\[Lambda]", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"xmax", "=", 
      RowBox[{"dZed", "+", "dIz"}]}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Lambda]", "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], "]"}],
     "\[Equal]", "0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okrLeft", "=", 
   RowBox[{
    RowBox[{"T", "[", "0", "]"}], "\[Equal]", "TZleva"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "[", "derT_", "]"}], ":=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"rce", ",", "okrLeft", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT"}]}], "}"}], 
      ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       FractionBox["dIz", "2000"]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"endValue", "[", 
    RowBox[{"derT_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"T", "[", "xmax", "]"}], "/.", 
    RowBox[{"sol", "[", "derT", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dder", "=", 
   RowBox[{"der", "/.", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"endValue", "[", "der", "]"}], "==", "TZprava"}], ",", 
      RowBox[{"{", 
       RowBox[{"der", ",", 
        RowBox[{"-", "100"}]}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"sol", "[", "dder", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "pom"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7511748043125*^9, 3.751174870296875*^9}, {
   3.75117556834375*^9, 3.751175910046875*^9}, {3.751176202625*^9, 
   3.75117620903125*^9}, {3.7511762430625*^9, 3.7511762706875*^9}, {
   3.751176506546875*^9, 3.751176525890625*^9}, 3.751176572625*^9, {
   3.751176724546875*^9, 3.751176745015625*^9}, {3.75117677721875*^9, 
   3.7511767816875*^9}, {3.75117688390625*^9, 3.751176906953125*^9}}],

Cell[BoxData[{
 RowBox[{"derLambda", "=", 
  RowBox[{"D", "[", 
   RowBox[{"\[Lambda]", ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"derLambda", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.751176420109375*^9, 3.751176449203125*^9}, {
  3.7511765333125*^9, 3.751176537203125*^9}}],

Cell[BoxData[
 RowBox[{"NDSolve", "//", "Options"}]], "Input",
 CellChangeTimes->{{3.751176590765625*^9, 3.75117659309375*^9}}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->2.3499999046325684`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 455, 14, 213, "Input"],
Cell[1003, 36, 3802, 109, 1001, "Input"],
Cell[4808, 147, 536, 12, 174, "Input"],
Cell[5347, 161, 127, 2, 95, "Input"]
}
]
*)

(* End of internal cache information *)
