(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7386,        229]
NotebookOptionsPosition[      6835,        208]
NotebookOutlinePosition[      7237,        225]
CellTagsIndexPosition[      7194,        222]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7208615645625*^9, 3.7208615731875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"57", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"1", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sk", "=", 
   RowBox[{"Pi", "*", 
    FractionBox[
     SuperscriptBox["d", "2"], "4"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "=", 
   FractionBox["i", "Sk"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ee", "=", 
   FractionBox["J", "\[Gamma]"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qv", "=", 
   RowBox[{"Ee", "*", "J"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pout", "=", 
   RowBox[{
    RowBox[{"\[Alpha]", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"T", "[", "x", "]"}], "-", "To"}], ")"}]}], "+", 
    RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"T", "[", "x", "]"}], "+", "273"}], ")"}], "4"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"To", "+", "273"}], ")"}], "4"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvOut", "=", 
   RowBox[{"Pout", "*", 
    FractionBox[
     RowBox[{"Pi", "*", "d"}], "Sk"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvCelk", "=", 
   RowBox[{
    RowBox[{"-", "Qv"}], "+", "Pout"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delka", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{"\[Lambda]", "*", 
    RowBox[{
     RowBox[{"T", "''"}], "[", "x", "]"}]}], "\[Equal]", 
   "QvCelk"}]}]}], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
   3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
   3.7208620900625*^9}, {3.720862139265625*^9, 3.720862742015625*^9}, {
   3.751173522453125*^9, 3.75117352915625*^9}, 3.751173565421875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sol", "[", "derT_", "]"}], ":=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eqn", ",", 
        RowBox[{
         RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT"}]}], "}"}], 
      ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
   3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
   3.7208620900625*^9}, {3.720862139265625*^9, 3.720862742015625*^9}, {
   3.751173522453125*^9, 3.751173527265625*^9}, {3.751173599640625*^9, 
   3.7511736041875*^9}, 3.75117370159375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"endValue", "[", 
    RowBox[{"derT_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"T", "[", "delka", "]"}], "/.", 
    RowBox[{"sol", "[", "derT", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"dder", "=", 
  RowBox[{"der", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"endValue", "[", "der", "]"}], "==", "To"}], ",", 
     RowBox[{"{", 
      RowBox[{"der", ",", "10000"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"sol", "[", "dder", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "pom"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
   3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
   3.7208620900625*^9}, {3.720862139265625*^9, 3.720862742015625*^9}, {
   3.751173522453125*^9, 3.751173527265625*^9}, {3.751173599640625*^9, 
   3.7511736041875*^9}, 3.751173709375*^9, 3.75117374965625*^9, 
   3.75117414003125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"f", ",", "g"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vetsiNezTri", "[", "x_", "]"}], ":=", 
   RowBox[{"x", ">", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "?", "vetsiNezTri"}], "]"}], ":=", "\"\<oranguten\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", ">", "3"}], "&"}], ")"}]}], "]"}], ":=", 
   "\"\<oranguten\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "[", "4", "]"}]}], "Input",
 CellChangeTimes->{{3.75117396290625*^9, 3.751174056921875*^9}, {
  3.7511742163125*^9, 3.751174218609375*^9}, {3.75117425946875*^9, 
  3.75117426253125*^9}}],

Cell[BoxData[{
 RowBox[{"NumberQ", "[", "Pi", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericQ", "[", "Pi", "]"}]}], "Input",
 CellChangeTimes->{{3.7511740906875*^9, 3.751174115578125*^9}}],

Cell[BoxData[
 RowBox[{"?", "*Q"}]], "Input",
 CellChangeTimes->{{3.751174168*^9, 3.751174170828125*^9}}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->2.3499999046325684`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 517, 15, 213, "Input"],
Cell[1065, 37, 2575, 77, 1000, "Input"],
Cell[3643, 116, 871, 22, 174, "Input"],
Cell[4517, 140, 1185, 31, 252, "Input"],
Cell[5705, 173, 825, 24, 252, "Input"],
Cell[6533, 199, 190, 3, 135, "Input"],
Cell[6726, 204, 105, 2, 95, "Input"]
}
]
*)

(* End of internal cache information *)
