(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38199,        875]
NotebookOptionsPosition[     37714,        856]
NotebookOutlinePosition[     38117,        873]
CellTagsIndexPosition[     38074,        870]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.48327811315625*^9, 3.483278126375*^9}, {
  3.483319988421875*^9, 3.48331998971875*^9}, {3.57849661209375*^9, 
  3.578496624484375*^9}, {3.638255496078125*^9, 3.638255503171875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejNx5", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejNx5", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"listDat_", ",", "sr_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ksr2_", ",", "ksr1_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "=", "0.5"}], ",", "aclist", ",", "x1", ",", "y1", ",", 
       "x2", ",", "y2", ",", "x3", ",", "y3", ",", "mozne", ",", "start", ",",
        "zkrot", ",", "krok", ",", "fce", ",", "nx", ",", "f", ",", "sd2", 
       ",", "nSampl", ",", "ykvref", ",", "varmin", ",", "pomer", ",", "fix", 
       ",", "sortFix", ",", "ndat"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sd2", "[", "list_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"mean", ",", "mean2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"mean", "=", 
           RowBox[{"Mean", "[", "list", "]"}]}], ";", 
          RowBox[{"mean2", "=", 
           RowBox[{"Mean", "[", 
            RowBox[{"list", "*", "list"}], "]"}]}], ";", 
          RowBox[{"mean2", "-", 
           SuperscriptBox["mean", "2"]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"aclist", "=", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Accumulate", "[", "listDat", "]"}], ",", "0"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"nSampl", "=", 
       RowBox[{"Length", "[", "aclist", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fce", "[", "nOkno_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rn", ",", "soucty", ",", "sigma"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"rn", "=", 
           RowBox[{"Range", "[", 
            RowBox[{"nSampl", "-", "nOkno"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"soucty", "=", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"aclist", "[", 
                RowBox[{"[", 
                 RowBox[{"#", "+", "nOkno"}], "]"}], "]"}], "-", 
               RowBox[{"aclist", "[", 
                RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", "rn"}], 
            ")"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"sigma", "=", 
           RowBox[{
            FractionBox["1.", "1"], 
            RowBox[{"sd2", "[", "soucty", "]"}]}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"zde", " ", "zmena"}], ",", " ", 
            RowBox[{"bylo", " ", 
             FractionBox["1.", 
              SuperscriptBox["nOkno", "2"]]}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"nOkno", ",", "sigma"}], "}"}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           SuperscriptBox["ksr1", 
            RowBox[{"-", "1"}]], "*", "sr"}], "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           SuperscriptBox["ksr2", 
            RowBox[{"-", "1"}]], "*", "sr"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       RowBox[{"fce", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"mozne", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"mozne", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}]}], "]"}], ",", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zkrot", "[", "n_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"n", "<", 
          RowBox[{"mozne", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"mozne", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", ">", 
            RowBox[{"mozne", "[", 
             RowBox[{"[", 
              RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"mozne", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"Round", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"krok", "[", 
        RowBox[{"body", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nb", ",", "yka", ",", "miny"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"yka", "=", 
           RowBox[{"body", "/.", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", "b"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"miny", "=", 
           RowBox[{"Min", "[", "yka", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"miny", "\[Equal]", "y2"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x1", "+", "x2"}], ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"fce", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{"0.5", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "+", "x2"}], ")"}]}], "]"}], "]"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"miny", "\[Equal]", "y3"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x3", "+", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x3", "-", "x2"}], ")"}]}]}], "]"}], "]"}], "}"}], 
             ",", 
             RowBox[{"miny", "\[Equal]", "y1"}], ",", 
             RowBox[{"{", 
              RowBox[{"fce", "[", 
               RowBox[{"zkrot", "[", 
                RowBox[{"x1", "-", 
                 RowBox[{"k1", "*", 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x1"}], ")"}]}]}], "]"}], "]"}], 
              "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{
                RowBox[{"Union", "[", 
                 RowBox[{"nb", ",", "body"}], "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "<", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], ",", 
              "3"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "<", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"fix", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], "=", 
        RowBox[{"FixedPoint", "[", 
         RowBox[{"krok", ",", "start"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sortFix", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"fix", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "<", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nx", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"y1", ">", "y2"}], "&&", 
          RowBox[{"y3", ">", "y2"}]}], ",", 
         FractionBox[
          RowBox[{"y1", "+", 
           RowBox[{"2", " ", "x2", " ", "y1"}], "-", 
           RowBox[{"4", " ", "x2", " ", "y2"}], "-", "y3", "+", 
           RowBox[{"2", " ", "x2", " ", "y3"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"y1", "-", 
             RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]], ",", 
         RowBox[{"sortFix", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"varmin", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"y1", ">", "y2"}], "&&", 
          RowBox[{"y3", ">", "y2"}]}], ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["y1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "y2"}], "+", "y3"}], ")"}], "2"], 
            "-", 
            RowBox[{"2", " ", "y1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "y2"}], "+", "y3"}], ")"}]}]}], 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"y1", "-", 
              RowBox[{"2", " ", "y2"}], "+", "y3"}], ")"}]}]]}], ",", 
         RowBox[{"sortFix", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pomer", "=", 
       FractionBox["nx", "sr"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ndat", "=", 
       RowBox[{"1.", "*", 
        RowBox[{"Length", "[", "listDat", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ykvref", "=", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "nx"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["ndat", "3"]}], "+", 
           RowBox[{"3", " ", "nx"}], "+", 
           SuperscriptBox["nx", "2"], "+", 
           RowBox[{
            SuperscriptBox["ndat", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{"3", " ", "nx"}]}], ")"}]}], "+", 
           RowBox[{"ndat", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"4", " ", "nx"}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"12", " ", 
         SuperscriptBox["nx", "2"]}]]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["10", "7"], 
          RowBox[{"Abs", "[", "varmin", "]"}]}], 
         RowBox[{
          RowBox[{"Abs", "[", "ykvref", "]"}], "+", 
          SuperscriptBox["10", 
           RowBox[{"-", "3"}]]}]], ",", 
        RowBox[{"N", "@", "pomer"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.589638326828125*^9, 3.589638347265625*^9}, {
   3.589638419609375*^9, 3.589638448390625*^9}, {3.58963853421875*^9, 
   3.58963855584375*^9}, {3.58963859215625*^9, 3.589638592828125*^9}, 
   3.58963869128125*^9, {3.5896387538125*^9, 3.58963887503125*^9}, {
   3.589638965578125*^9, 3.5896389911875*^9}, {3.58963906478125*^9, 
   3.589639262984375*^9}, {3.58963930484375*^9, 3.589639328109375*^9}, {
   3.589639364109375*^9, 3.589639372984375*^9}, {3.589639409390625*^9, 
   3.589639522234375*^9}, {3.589639733703125*^9, 3.58963976896875*^9}, {
   3.589640053921875*^9, 3.58964005675*^9}, {3.589640090453125*^9, 
   3.58964010171875*^9}, {3.58964015090625*^9, 3.58964030490625*^9}, {
   3.589640352078125*^9, 3.589640373953125*^9}, {3.589640488015625*^9, 
   3.589640489*^9}, {3.589640565875*^9, 3.589640627953125*^9}, {
   3.589640710125*^9, 3.58964074059375*^9}, {3.5896486455*^9, 
   3.5896486610625*^9}, {3.589648691671875*^9, 3.5896487055*^9}, {
   3.589650775546875*^9, 3.589650776046875*^9}, {3.59005184675*^9, 
   3.590051858046875*^9}, {3.590052253296875*^9, 3.59005229290625*^9}, {
   3.590052369046875*^9, 3.5900523789375*^9}, {3.59005405965625*^9, 
   3.590054070046875*^9}, {3.59005413690625*^9, 3.5900541395*^9}, {
   3.59005417075*^9, 3.590054211578125*^9}, {3.590738773546875*^9, 
   3.590738804828125*^9}, 3.59073906553125*^9, {3.590739257796875*^9, 
   3.5907393216875*^9}, {3.590739505578125*^9, 3.59073952865625*^9}, {
   3.590739582078125*^9, 3.590739607125*^9}, {3.59073963728125*^9, 
   3.590739746015625*^9}, {3.590739783390625*^9, 3.590739792375*^9}, {
   3.590743832359375*^9, 3.5907438378125*^9}, {3.590744053328125*^9, 
   3.5907440911875*^9}, {3.590744124609375*^9, 3.59074418775*^9}, {
   3.590744240203125*^9, 3.5907442564375*^9}, {3.5907442874375*^9, 
   3.590744291015625*^9}, {3.590744449125*^9, 3.5907445183125*^9}, {
   3.590744561203125*^9, 3.59074458315625*^9}, 3.590744730296875*^9, {
   3.591093663484375*^9, 3.591093726546875*^9}, {3.59109502559375*^9, 
   3.59109503040625*^9}, {3.591096260640625*^9, 3.591096286765625*^9}, 
   3.591201181359375*^9, 3.591201397921875*^9, 3.59120143103125*^9, {
   3.591246536921875*^9, 3.59124656421875*^9}, {3.591246662765625*^9, 
   3.591246664765625*^9}, {3.591246730734375*^9, 3.591246740265625*^9}, 
   3.59124715328125*^9, 3.591247873875*^9, {3.59124797821875*^9, 
   3.5912479795625*^9}, {3.59124854046875*^9, 3.591248556640625*^9}, {
   3.591248839078125*^9, 3.591248864984375*^9}, {3.59126683034375*^9, 
   3.591266838484375*^9}, {3.63825403590625*^9, 3.63825404*^9}, {
   3.638254735984375*^9, 3.638254736984375*^9}, {3.6385444074375*^9, 
   3.6385444106875*^9}, {3.63854447640625*^9, 3.638544486703125*^9}, 
   3.638544813265625*^9, {3.638545399640625*^9, 3.638545411046875*^9}, {
   3.638545604296875*^9, 3.63854564234375*^9}, {3.638545819921875*^9, 
   3.63854582409375*^9}, {3.6385463191875*^9, 3.638546329828125*^9}, {
   3.638546859625*^9, 3.638546868*^9}, {3.638546911921875*^9, 
   3.638546916203125*^9}, {3.64386655996875*^9, 3.643866666078125*^9}, {
   3.643866709984375*^9, 3.643866737765625*^9}, {3.643866809421875*^9, 
   3.6438668958125*^9}, {3.64386693225*^9, 3.6438669958125*^9}, {
   3.643868896703125*^9, 3.643868903859375*^9}, {3.643869569359375*^9, 
   3.643869570609375*^9}, {3.643869603625*^9, 3.643869628765625*^9}, 
   3.6438696996875*^9, {3.643870231578125*^9, 3.6438702908125*^9}, 
   3.643870321421875*^9, {3.643870376796875*^9, 3.64387037740625*^9}, {
   3.643870436671875*^9, 3.643870445171875*^9}, {3.643870483203125*^9, 
   3.64387048790625*^9}, {3.643878834078125*^9, 3.643878837265625*^9}, {
   3.643879901546875*^9, 3.6438799103125*^9}, {3.643879946671875*^9, 
   3.64388000353125*^9}, {3.643881072703125*^9, 3.643881073734375*^9}, {
   3.66299751409375*^9, 3.662997554765625*^9}, 3.663126166640938*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmax", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t1", ",", "t2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9", "tmax"}], ",", "tmax"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fmin", "=", "15.69"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]0rus", "=", 
     RowBox[{"2.", "*", "Pi", "*", "fmin", "*", "3.65"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.644055809828125*^9, 3.64405593634375*^9}, {
   3.6440559696875*^9, 3.644056106796875*^9}, {3.64405617278125*^9, 
   3.644056221328125*^9}, {3.644056265859375*^9, 3.644056337828125*^9}, {
   3.644057083*^9, 3.644057140796875*^9}, {3.644058144078125*^9, 
   3.644058160125*^9}, {3.6440582235*^9, 3.644058262734375*^9}, 
   3.644059652078125*^9, 3.644059746171875*^9, 3.644059830296875*^9, {
   3.644059890265625*^9, 3.644059950625*^9}, {3.6440602083125*^9, 
   3.6440602510625*^9}, {3.644060828265625*^9, 3.644061082859375*^9}, {
   3.644061159578125*^9, 3.644061209328125*^9}, 3.64406622928125*^9, {
   3.644066259796875*^9, 3.6440662881875*^9}, 3.644066336234375*^9, 
   3.644066367765625*^9, {3.644066612*^9, 3.644066632234375*^9}, 
   3.6440667481875*^9, {3.6440667800625*^9, 3.6440668810625*^9}, 
   3.644067420375*^9, {3.6440675255*^9, 3.644067537359375*^9}, 
   3.644067568515625*^9, 3.644067619015625*^9, {3.644067664453125*^9, 
   3.644067728*^9}, {3.64406776921875*^9, 3.644067800109375*^9}, {
   3.644067847640625*^9, 3.644067940140625*^9}, {3.644068830625*^9, 
   3.64406886778125*^9}, 3.644068902703125*^9, {3.644068945265625*^9, 
   3.644069009890625*^9}, 3.644069054890625*^9, {3.644069086875*^9, 
   3.6440690984375*^9}, {3.644069132359375*^9, 3.644069177375*^9}, 
   3.644069218828125*^9, 3.644069327203125*^9, 3.644069369875*^9, {
   3.644069418296875*^9, 3.64406945240625*^9}, 3.644069531046875*^9, {
   3.6440695611875*^9, 3.644069573765625*^9}, {3.6441363297741156`*^9, 
   3.6441363362741156`*^9}, {3.6441363671178656`*^9, 
   3.6441363944147406`*^9}, {3.6441365280553656`*^9, 
   3.6441365441491156`*^9}, {3.6441365760084906`*^9, 
   3.6441365822428656`*^9}, {3.6441366149303656`*^9, 
   3.6441366508366156`*^9}, {3.6441366913366156`*^9, 3.6441367207428656`*^9}, 
   3.6441367521647406`*^9, 3.6441367905084906`*^9, {3.6441368218209906`*^9, 
   3.6441368390709906`*^9}, {3.6441368738209906`*^9, 
   3.6441368927584906`*^9}, {3.6441370491803656`*^9, 
   3.6441371045397406`*^9}, {3.6441371369772406`*^9, 
   3.6441371461959906`*^9}, {3.6441372390709906`*^9, 
   3.6441373326022406`*^9}, {3.6441382742897406`*^9, 
   3.6441382758053656`*^9}, {3.6441383165241156`*^9, 
   3.6441383531959906`*^9}, {3.6441388397116156`*^9, 3.6441388666491156`*^9}, 
   3.6441398300709906`*^9, {3.6441400106959906`*^9, 3.6441401000553656`*^9}, 
   3.6441428745866156`*^9, 3.6441429293991156`*^9, 3.6441429730553656`*^9, 
   3.6441483065*^9, {3.64414833978125*^9, 3.644148442140625*^9}, 
   3.6441484750625*^9, {3.644148522078125*^9, 3.644148595796875*^9}, {
   3.644148667734375*^9, 3.644148707859375*^9}, {3.644148757*^9, 
   3.644148759859375*^9}, {3.6441488145625*^9, 3.64414881559375*^9}, {
   3.64414934871875*^9, 3.6441493693125*^9}, {3.6441500899375*^9, 
   3.644150122015625*^9}, {3.644150209796875*^9, 3.644150213390625*^9}, {
   3.6631257640442305`*^9, 3.663125766134634*^9}, {3.6631258043859015`*^9, 
   3.6631258333239517`*^9}, {3.6631261792457595`*^9, 3.663126189136177*^9}, {
   3.6631429860773716`*^9, 3.6631429907889805`*^9}, {3.66314320446416*^9, 
   3.663143259999658*^9}, {3.663143304106936*^9, 3.6631433317989845`*^9}, 
   3.66314365258115*^9, {3.6631436995724325`*^9, 3.663143710211651*^9}, 
   3.6631440486052475`*^9, {3.6631445699719653`*^9, 3.663144577836379*^9}, {
   3.6755826400625*^9, 3.67558266578125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"t", ",", "frus"}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"frus", "[", "t_", "]"}], "=", 
     RowBox[{"(", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "10"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"Cos", "[", 
            RowBox[{"1.", "*", "i"}], "]"}], 
           SuperscriptBox["i", "1.56"]], "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"i", "*", "\[Omega]0rus", "*", "t"}], "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"Sin", "[", 
            RowBox[{"1.", "*", "i"}], "]"}], "i"], "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"i", "*", "\[Omega]0rus", "*", "t"}], "]"}]}]}], ")"}]}], 
      ")"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"frus", "[", "t_", "]"}], ":=", 
   RowBox[{"Tanh", "[", 
    RowBox[{"10", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Omega]0rus", "*", "t"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"frus", "[", "t_", "]"}], "=", 
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "50"], 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "i"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "i"}], "-", "1"}], ")"}], "2"]], 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "i"}], "-", "1"}], ")"}], "*", "\[Omega]0rus", "*", 
          "t"}], "]"}]}], ")"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"frus", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "t1", ",", "t2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.644055809828125*^9, 3.64405593634375*^9}, {
   3.6440559696875*^9, 3.644056106796875*^9}, {3.64405617278125*^9, 
   3.644056221328125*^9}, {3.644056265859375*^9, 3.644056337828125*^9}, {
   3.644057083*^9, 3.644057140796875*^9}, {3.644058144078125*^9, 
   3.644058160125*^9}, {3.6440582235*^9, 3.644058262734375*^9}, 
   3.644059652078125*^9, 3.644059746171875*^9, 3.644059830296875*^9, {
   3.644059890265625*^9, 3.644059950625*^9}, {3.6440602083125*^9, 
   3.6440602510625*^9}, {3.644060828265625*^9, 3.644061082859375*^9}, {
   3.644061159578125*^9, 3.644061209328125*^9}, 3.64406622928125*^9, {
   3.644066259796875*^9, 3.6440662881875*^9}, 3.644066336234375*^9, 
   3.644066367765625*^9, {3.644066612*^9, 3.644066632234375*^9}, 
   3.6440667481875*^9, {3.6440667800625*^9, 3.6440668810625*^9}, 
   3.644067420375*^9, {3.6440675255*^9, 3.644067537359375*^9}, 
   3.644067568515625*^9, 3.644067619015625*^9, {3.644067664453125*^9, 
   3.644067728*^9}, {3.64406776921875*^9, 3.644067800109375*^9}, {
   3.644067847640625*^9, 3.644067940140625*^9}, {3.644068830625*^9, 
   3.64406886778125*^9}, 3.644068902703125*^9, {3.644068945265625*^9, 
   3.644069009890625*^9}, 3.644069054890625*^9, {3.644069086875*^9, 
   3.6440690984375*^9}, {3.644069132359375*^9, 3.644069177375*^9}, 
   3.644069218828125*^9, 3.644069327203125*^9, 3.644069369875*^9, {
   3.644069418296875*^9, 3.64406945240625*^9}, 3.644069531046875*^9, {
   3.6440695611875*^9, 3.644069573765625*^9}, {3.6441363297741156`*^9, 
   3.6441363362741156`*^9}, {3.6441363671178656`*^9, 
   3.6441363944147406`*^9}, {3.6441365280553656`*^9, 
   3.6441365441491156`*^9}, {3.6441365760084906`*^9, 
   3.6441365822428656`*^9}, {3.6441366149303656`*^9, 
   3.6441366508366156`*^9}, {3.6441366913366156`*^9, 3.6441367207428656`*^9}, 
   3.6441367521647406`*^9, 3.6441367905084906`*^9, {3.6441368218209906`*^9, 
   3.6441368390709906`*^9}, {3.6441368738209906`*^9, 
   3.6441368927584906`*^9}, {3.6441370491803656`*^9, 
   3.6441371045397406`*^9}, {3.6441371369772406`*^9, 
   3.6441371461959906`*^9}, {3.6441372390709906`*^9, 
   3.6441373326022406`*^9}, {3.6441382742897406`*^9, 
   3.6441382758053656`*^9}, {3.6441383165241156`*^9, 
   3.6441383531959906`*^9}, {3.6441388397116156`*^9, 3.6441388666491156`*^9}, 
   3.6441398300709906`*^9, {3.6441400106959906`*^9, 3.6441401000553656`*^9}, 
   3.6441428745866156`*^9, 3.6441429293991156`*^9, 3.6441429730553656`*^9, 
   3.6441483065*^9, {3.64414833978125*^9, 3.644148442140625*^9}, 
   3.6441484750625*^9, {3.644148522078125*^9, 3.644148595796875*^9}, {
   3.644148667734375*^9, 3.644148707859375*^9}, {3.644148757*^9, 
   3.644148759859375*^9}, {3.6441488145625*^9, 3.64414881559375*^9}, {
   3.64414934871875*^9, 3.6441493693125*^9}, {3.6441500899375*^9, 
   3.644150122015625*^9}, {3.644150209796875*^9, 3.644150213390625*^9}, {
   3.6631257640442305`*^9, 3.663125766134634*^9}, {3.6631258043859015`*^9, 
   3.6631258333239517`*^9}, {3.6631261792457595`*^9, 3.663126189136177*^9}, {
   3.6631429860773716`*^9, 3.6631429907889805`*^9}, {3.66314320446416*^9, 
   3.663143259999658*^9}, {3.663143304106936*^9, 3.6631433317989845`*^9}, 
   3.66314365258115*^9, {3.6631436995724325`*^9, 3.663143710211651*^9}, 
   3.6631440486052475`*^9, {3.6631445699719653`*^9, 3.663144577836379*^9}, {
   3.6755826400625*^9, 3.675582671453125*^9}, {3.675582720984375*^9, 
   3.675582763375*^9}, {3.675582797359375*^9, 3.675582808984375*^9}, {
   3.675582979015625*^9, 3.675583046421875*^9}}],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "zp1", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zp1", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kper_", ",", "nd_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1_", ",", "t2_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "listdat", ",", "\[CapitalDelta]t", ",", "Tref", ",", "sr", ",", 
         "pmin", ",", 
         RowBox[{"dint", "=", "0.08"}], ",", 
         RowBox[{"pmax", "=", "15"}], ",", "ints", ",", "vys", ",", "plAll", 
         ",", "p1", ",", "test", ",", "vysBody", ",", "grv", ",", "nints", 
         ",", "k", ",", "pecka"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[CapitalDelta]t", "=", 
         FractionBox[
          RowBox[{"t2", "-", "t1"}], 
          RowBox[{"nd", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{"listdat", "=", 
         RowBox[{"frus", "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"t1", ",", "t2", ",", "\[CapitalDelta]t"}], "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Tref", "=", 
         FractionBox[
          RowBox[{"t2", "-", "t1"}], "kper"]}], ";", "\[IndentingNewLine]", 
        RowBox[{"sr", "=", 
         RowBox[{"Round", "[", 
          FractionBox["Tref", "\[CapitalDelta]t"], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"pmin", "=", "1."}], ";", "\[IndentingNewLine]", 
        RowBox[{"nints", "=", 
         RowBox[{"Round", "[", 
          FractionBox[
           RowBox[{"pmax", "-", "pmin"}], "dint"], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k", "=", 
         RowBox[{
          FractionBox["1.", "nints"], "*", 
          RowBox[{"Log", "[", 
           FractionBox["pmax", "pmin"], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pecka", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"pmin", "*", 
            RowBox[{"Exp", "[", 
             RowBox[{"#", "*", "k"}], "]"}]}], "&"}], "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Range", "[", 
             RowBox[{"nints", "+", "1"}], "]"}], "-", "1"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ints", "=", 
         RowBox[{
          RowBox[{"Partition", "[", 
           RowBox[{"pecka", ",", "3", ",", "1"}], "]"}], "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a_", ",", "_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"a", "-", 
              FractionBox["Pi", 
               RowBox[{"500.", "E"}]]}], ",", 
             RowBox[{"c", "+", 
              FractionBox["E", 
               RowBox[{"421.3", "Pi"}]]}]}], "}"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vys", "=", 
         RowBox[{"DeleteDuplicates", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Reverse", "[", 
             RowBox[{"vydejNx5", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"listdat", ",", "sr"}], "}"}], ",", "#"}], "}"}], 
              "]"}], "]"}], "&"}], "/@", "ints"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"plAll", "=", 
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"ListLogLogPlot", "[", 
            RowBox[{
             RowBox[{"Union", "[", "vys", "]"}], ",", 
             RowBox[{"Joined", "\[Rule]", "True"}], ",", 
             RowBox[{"AxesLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<pomer\>\"", ",", "\"\<varmin\>\""}], "}"}]}], ",", 
             RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
           RowBox[{"ListLogLogPlot", "[", 
            RowBox[{"vys", ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "0.008", "]"}], ",", "Red"}], 
               "}"}]}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"p1", "=", 
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"Sort", "[", 
            RowBox[{"vys", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", 
               RowBox[{"#2", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], ",", "3", 
           ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"test", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y1", ">", "y2"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"y3", ">", "y2"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"vysBody", "=", 
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"p1", ",", "test"}], "]"}], "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a_List", ",", "b_List", ",", "c_List"}], "}"}], 
            "\[RuleDelayed]", "b"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"grv", "=", 
         RowBox[{"Show", "[", 
          RowBox[{"plAll", ",", 
           RowBox[{"ListLogLogPlot", "[", 
            RowBox[{"vysBody", ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "0.01", "]"}], ",", "Green"}], 
               "}"}]}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"vysBody", ",", "sr", ",", "Tref"}], "}"}], ",", "grv", 
          ",", 
          RowBox[{"ListPlot", "[", 
           RowBox[{"listdat", ",", 
            RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
            RowBox[{"Joined", "\[Rule]", "True"}], ",", 
            RowBox[{"AxesLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<i [-]\>\"", ",", "\"\<vel[-]\>\""}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
            RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"sr", ",", "Tref"}], "}"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"pom", "=", 
    RowBox[{
     RowBox[{"zp1", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.6", ",", "3000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"pom", "[", 
      RowBox[{"[", 
       RowBox[{"-", "3"}], "]"}], "]"}], ">>", "\"\<grafpred\>\""}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.644055809828125*^9, 3.64405593634375*^9}, {
   3.6440559696875*^9, 3.644056106796875*^9}, {3.64405617278125*^9, 
   3.644056221328125*^9}, {3.644056265859375*^9, 3.644056337828125*^9}, {
   3.644057083*^9, 3.644057140796875*^9}, {3.644058144078125*^9, 
   3.644058160125*^9}, {3.6440582235*^9, 3.644058262734375*^9}, 
   3.644059652078125*^9, 3.644059746171875*^9, 3.644059830296875*^9, {
   3.644059890265625*^9, 3.644059950625*^9}, {3.6440602083125*^9, 
   3.6440602510625*^9}, {3.644060828265625*^9, 3.644061082859375*^9}, {
   3.644061159578125*^9, 3.644061209328125*^9}, 3.64406622928125*^9, {
   3.644066259796875*^9, 3.6440662881875*^9}, 3.644066336234375*^9, 
   3.644066367765625*^9, {3.644066612*^9, 3.644066632234375*^9}, 
   3.6440667481875*^9, {3.6440667800625*^9, 3.6440668810625*^9}, 
   3.644067420375*^9, {3.6440675255*^9, 3.644067537359375*^9}, 
   3.644067568515625*^9, 3.644067619015625*^9, {3.644067664453125*^9, 
   3.644067728*^9}, {3.64406776921875*^9, 3.644067800109375*^9}, {
   3.644067847640625*^9, 3.644067940140625*^9}, {3.644068830625*^9, 
   3.64406886778125*^9}, 3.644068902703125*^9, {3.644068945265625*^9, 
   3.644069009890625*^9}, 3.644069054890625*^9, {3.644069086875*^9, 
   3.6440690984375*^9}, {3.644069132359375*^9, 3.644069177375*^9}, 
   3.644069218828125*^9, 3.644069327203125*^9, 3.644069369875*^9, {
   3.644069418296875*^9, 3.64406945240625*^9}, 3.644069531046875*^9, {
   3.6440695611875*^9, 3.644069573765625*^9}, {3.6441363297741156`*^9, 
   3.6441363362741156`*^9}, {3.6441363671178656`*^9, 
   3.6441363944147406`*^9}, {3.6441365280553656`*^9, 
   3.6441365441491156`*^9}, {3.6441365760084906`*^9, 
   3.6441365822428656`*^9}, {3.6441366149303656`*^9, 
   3.6441366508366156`*^9}, {3.6441366913366156`*^9, 3.6441367207428656`*^9}, 
   3.6441367521647406`*^9, 3.6441367905084906`*^9, {3.6441368218209906`*^9, 
   3.6441368390709906`*^9}, {3.6441368738209906`*^9, 
   3.6441368927584906`*^9}, {3.6441370491803656`*^9, 
   3.6441371045397406`*^9}, {3.6441371369772406`*^9, 
   3.6441371461959906`*^9}, {3.6441372390709906`*^9, 
   3.6441373326022406`*^9}, {3.6441382742897406`*^9, 
   3.6441382758053656`*^9}, {3.6441383165241156`*^9, 
   3.6441383531959906`*^9}, {3.6441388397116156`*^9, 3.6441388666491156`*^9}, 
   3.6441398300709906`*^9, {3.6441400106959906`*^9, 3.6441401000553656`*^9}, 
   3.6441428745866156`*^9, 3.6441429293991156`*^9, 3.6441429730553656`*^9, 
   3.6441483065*^9, {3.64414833978125*^9, 3.644148442140625*^9}, 
   3.6441484750625*^9, {3.644148522078125*^9, 3.644148595796875*^9}, {
   3.644148667734375*^9, 3.644148707859375*^9}, {3.644148757*^9, 
   3.644148759859375*^9}, {3.6441488145625*^9, 3.64414881559375*^9}, {
   3.64414934871875*^9, 3.6441493693125*^9}, {3.6441500899375*^9, 
   3.644150122015625*^9}, {3.644150209796875*^9, 3.644150213390625*^9}, {
   3.6631257640442305`*^9, 3.663125766134634*^9}, {3.6631258043859015`*^9, 
   3.6631258333239517`*^9}, {3.6631261792457595`*^9, 3.663126189136177*^9}, {
   3.6631429860773716`*^9, 3.663143013201621*^9}, {3.66314327227988*^9, 
   3.6631432776150894`*^9}, {3.6631433641906424`*^9, 
   3.6631433796346693`*^9}, {3.6631434271301527`*^9, 
   3.6631435940000467`*^9}, {3.6631437489027195`*^9, 3.663143815147436*^9}, {
   3.6631438864621615`*^9, 3.663143915434413*^9}, {3.66314394804047*^9, 
   3.663143975231318*^9}, 3.6631444842604146`*^9, {3.66314452154648*^9, 
   3.6631445381771097`*^9}, 3.663144618586651*^9, {3.6631446538603134`*^9, 
   3.663144701881198*^9}, {3.663144759387899*^9, 3.6631447967815657`*^9}, 
   3.6631448364242353`*^9, 3.66314489046673*^9, {3.6631449365230117`*^9, 
   3.6631451436941776`*^9}}]
},
WindowSize->{1141, 639},
WindowMargins->{{10, Automatic}, {Automatic, -1}},
ShowSelection->True,
Magnification->1.3000000715255737`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 511, 12, 84, "Input"],
Cell[1059, 34, 15978, 382, 1089, "Input"],
Cell[17040, 418, 3916, 68, 130, "Input"],
Cell[20959, 488, 5566, 118, 206, "Input"],
Cell[26528, 608, 11182, 246, 1015, "Input"]
}
]
*)

(* End of internal cache information *)
