(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5334,        175]
NotebookOptionsPosition[      4980,        159]
NotebookOutlinePosition[      5382,        176]
CellTagsIndexPosition[      5339,        173]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "\"\<lstol\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7208615645625*^9, 3.7208615731875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"57", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"1", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sk", "=", 
   RowBox[{"Pi", "*", 
    FractionBox[
     SuperscriptBox["d", "2"], "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J", "=", 
   FractionBox["i", "Sk"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ee", "=", 
   FractionBox["J", "\[Gamma]"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qv", "=", 
   RowBox[{"Ee", "*", "J"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pout", "=", 
   RowBox[{
    RowBox[{"\[Alpha]", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"T", "[", "x", "]"}], "-", "To"}], ")"}]}], "+", 
    RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"T", "[", "x", "]"}], "+", "273"}], ")"}], "4"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"To", "+", "273"}], ")"}], "4"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvOut", "=", 
   RowBox[{"Pout", "*", 
    FractionBox[
     RowBox[{"Pi", "*", "d"}], "Sk"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvCelk", "=", 
   RowBox[{
    RowBox[{"-", "Qv"}], "+", "Pout"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delka", "=", "0.9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{"\[Lambda]", "*", 
     RowBox[{
      RowBox[{"T", "''"}], "[", "x", "]"}]}], "\[Equal]", "QvCelk"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eqn", ",", 
        RowBox[{
         RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT"}]}], "}"}], 
      ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"endValue", "[", 
    RowBox[{"derT_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"T", "[", "delka", "]"}], "/.", 
    RowBox[{"sol", "[", "derT", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"dder", "=", 
  RowBox[{"der", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"endValue", "[", "der", "]"}], "==", "To"}], ",", 
     RowBox[{"{", 
      RowBox[{"der", ",", "10000"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"sol", "[", "dder", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "pom"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "delka"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.72086158315625*^9, 3.720861585671875*^9}, {
  3.720861621828125*^9, 3.72086187815625*^9}, {3.720861973765625*^9, 
  3.7208620900625*^9}, {3.720862139265625*^9, 3.720862742015625*^9}}]
},
WindowSize->{1126, 640},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->1.9500001668930054`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 517, 15, 159, "Input"],
Cell[1065, 37, 3911, 120, 1009, "Input"]
}
]
*)

(* End of internal cache information *)
